![Zabbix logo](misc/images/docs/zabbix_logo.svg?raw=true)

An enterprise-class, open-source distributed monitoring solution that’s designed to monitor the performance and availability of network devices, servers, services, and other IT resources.
Zabbix is a flexible solution that can monitor anything from a simple, standalone application to a large-scale environment, with features including:

- **Resource discovery:** Discover network entities, server resources, and onboard/offboard devices. Use out-of-the-box integrations (templates) to monitor anything form a low-level device to a SAAS service.
- **Metric acquisition:** Use an agent or agent-less approach for metric acquisition from any source – devices, sensors, operating systems, virtualization platforms, container platforms like Docker, Kubernetes, cloud infrastructures, databases, webpages, Java ecosystems, application servers, API endpoints, business applications, and many more.
- **Root cause analysis and problem detection:** Count on high-performance, real-time problem detection that correlates both existing and incoming problems and performs root cause analyses.
- **Incidents, alerts, and notifications:** Receive an alert when an issue is triggered (proactively or post-mortem) in the ecosystem. Use multiple messaging channels (including Slack, JIRA, Microsoft Teams, email or text messages) to get notified about the different types of events occurring in your environment.
- **“Single pane of glass” overview:** Visualize collected data and monitoring events in graphs, lists, geomaps, and network topology maps.
- **Multitenancy and distributed monitoring:** Enjoy the convenience of one monitoring solution for multiple data centers, departments, and organizations, and monitor remote locations behind firewalls with remote command execution capability.
- **Unparalleled flexibility:** Adapt Zabbix to your needs and utilize built-in functionalities, including the ability to stream metrics and events over HTTP, reporting, auditing, security, service SLA calculations, and many more.

## Get started

- [Get Zabbix](https://www.zabbix.com/download)
- [Installation manual](https://www.zabbix.com/documentation/current/en/manual/installation)

## Documentation

Zabbix documentation is available at [zabbix.com/documentation](https://www.zabbix.com/documentation/current/en/)

## License

Zabbix is distributed under [AGPL-3.0-only](COPYING)
