/*
 * Copyright (c) 2001-2003 The Trustees of Indiana University.  
 *                         All rights reserved.
 * Copyright (c) 1998-2001 University of Notre Dame. 
 *                         All rights reserved.
 * Copyright (c) 1994-1998 The Ohio State University.  
 *                         All rights reserved.
 * 
 * This file is part of the XMPI software package.  For license
 * information, see the LICENSE file in the top level directory of the
 * XMPI source distribution.
 * 
 * $HEADER$
 *
 * $Id: xmpi_misc.h,v 1.7 2003/09/03 04:28:54 jsquyres Exp $
 *
 *	Function:	- miscellaneous XMPI functions
 */

#ifndef _XMPI_MISC_H_
#define _XMPI_MISC_H_

typedef void (*xmpi_atexit_funct)(void);

Widget xmpi_mklabel(Widget, char*, int, int);

void xmpi_fail(char*);

void xmpi_atexit(xmpi_atexit_funct);

void xmpi_busy_widget(Widget);

void xmpi_unbusy_widget(Widget);

void xmpi_formattach(Widget, int, int, int, int);

void xmpi_setlabel(Widget, char*);

void xmpi_nosash(Widget);

void xmpi_vstr_extent(char*, XFontStruct, int*, int*);

void xmpi_vstr_draw(Display*, Drawable, GC, int, int, char*, XFontStruct);

Widget xmpi_mkpixbutton(Widget,  
			void (*act_cb) (Widget, XtPointer, XtPointer), 
			char*, 
			void (*arm_cb) (Widget, XtPointer, XtPointer), 
			char *, 
			void (*dis_cb) (Widget, XtPointer, XtPointer),
			char *, unsigned char*, 
			int, int, int);

Widget xmpi_mkcolpixbutton(Widget, 
			   void (*act_cb) (Widget, XtPointer, XtPointer),
			   char*, 
			   void (*arm_cb) (Widget, XtPointer, XtPointer), 
			   char *, 
			   void (*dis_cb) (Widget, XtPointer, XtPointer),
			   char *, const char**, int);

Widget xmpi_mklabel(Widget, char*, int, int);

int xmpi_yesno(Widget, char*);

int xmpi_coll2pt(int);

void xmpi_flush();

#endif
