/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

/*
 * CheckoutPathsPanel.java
 *
 * Created on Oct 18, 2010, 3:28:45 PM
 */

package org.netbeans.modules.git.ui.reset;

import javax.swing.JPanel;
import org.netbeans.libs.git.GitClient.ResetType;
import org.netbeans.modules.git.ui.repository.RevisionDialog;

/**
 *
 * @author ondra
 */
public class ResetPanel extends JPanel {
    private final RevisionDialog revisionPanel;

    /** Creates new form CheckoutPathsPanel */
    public ResetPanel (RevisionDialog revisionPanel) {
        this.revisionPanel = revisionPanel;
        initComponents();
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        buttonGroup1 = new javax.swing.ButtonGroup();
        org.netbeans.modules.git.ui.repository.RevisionDialog revisionPickerDialog1 = this.revisionPanel;
        jLabel1 = new javax.swing.JLabel();
        optionsPanel = new javax.swing.JPanel();

        jLabel1.setLabelFor(revisionPickerDialog1);
        org.openide.awt.Mnemonics.setLocalizedText(jLabel1, org.openide.util.NbBundle.getMessage(ResetPanel.class, "ResetPanel.jLabel1.text")); // NOI18N

        optionsPanel.setBorder(javax.swing.BorderFactory.createTitledBorder(org.openide.util.NbBundle.getMessage(ResetPanel.class, "ResetPanel.optionsPanel.text"))); // NOI18N

        buttonGroup1.add(rbSoft);
        org.openide.awt.Mnemonics.setLocalizedText(rbSoft, org.openide.util.NbBundle.getMessage(ResetPanel.class, "ResetPanel.rbSoft.text")); // NOI18N
        rbSoft.setToolTipText(org.openide.util.NbBundle.getMessage(ResetPanel.class, "ResetPanel.rbSoft.TTtext")); // NOI18N
        rbSoft.setActionCommand(ResetType.SOFT.name());

        buttonGroup1.add(rbMixed);
        org.openide.awt.Mnemonics.setLocalizedText(rbMixed, org.openide.util.NbBundle.getMessage(ResetPanel.class, "ResetPanel.rbMixed.text")); // NOI18N
        rbMixed.setToolTipText(org.openide.util.NbBundle.getMessage(ResetPanel.class, "ResetPanel.rbMixed.TTtext")); // NOI18N
        rbMixed.setActionCommand(ResetType.MIXED.name());

        buttonGroup1.add(rbHard);
        org.openide.awt.Mnemonics.setLocalizedText(rbHard, org.openide.util.NbBundle.getMessage(ResetPanel.class, "ResetPanel.rbHard.text")); // NOI18N
        rbHard.setToolTipText(org.openide.util.NbBundle.getMessage(ResetPanel.class, "ResetPanel.rbHard.TTtext")); // NOI18N
        rbHard.setActionCommand(ResetType.HARD.name());

        javax.swing.GroupLayout optionsPanelLayout = new javax.swing.GroupLayout(optionsPanel);
        optionsPanel.setLayout(optionsPanelLayout);
        optionsPanelLayout.setHorizontalGroup(
            optionsPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(optionsPanelLayout.createSequentialGroup()
                .addContainerGap()
                .addGroup(optionsPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(rbSoft)
                    .addComponent(rbMixed)
                    .addComponent(rbHard))
                .addContainerGap(82, Short.MAX_VALUE))
        );
        optionsPanelLayout.setVerticalGroup(
            optionsPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(optionsPanelLayout.createSequentialGroup()
                .addContainerGap()
                .addComponent(rbSoft)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(rbMixed)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(rbHard)
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING)
                    .addComponent(optionsPanel, javax.swing.GroupLayout.Alignment.LEADING, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .addComponent(jLabel1, javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(revisionPickerDialog1, javax.swing.GroupLayout.Alignment.LEADING, javax.swing.GroupLayout.DEFAULT_SIZE, 406, Short.MAX_VALUE))
                .addContainerGap())
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addComponent(jLabel1)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(revisionPickerDialog1, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(optionsPanel, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addContainerGap())
        );
    }// </editor-fold>//GEN-END:initComponents


    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.ButtonGroup buttonGroup1;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JPanel optionsPanel;
    final javax.swing.JRadioButton rbHard = new javax.swing.JRadioButton();
    final javax.swing.JRadioButton rbMixed = new javax.swing.JRadioButton();
    final javax.swing.JRadioButton rbSoft = new javax.swing.JRadioButton();
    // End of variables declaration//GEN-END:variables

}
