//start of LhaFile.java
//TEXT_STYLE:CODE=Shift_JIS(Japanese):RET_CODE=CRLF

/**
 * LhaFile.java
 * 
 * Copyright (C) 2002  Michel Ishizuka  All rights reserved.
 * 
 * ȉ̏ɓӂȂ΃\[XƃoCi`̍ĔzzƎgp
 * ύX̗Lɂ炸B
 * 
 * PD\[XR[h̍ĔzzɂĒ쌠\ ̏̃Xg
 *     щL̐ێȂĂ͂ȂȂB
 * 
 * QDoCi`̍ĔzzɂĒ쌠\ ̏̃Xg
 *     щL̐gp ̑̔zz
 *     ܂ގɋLqȂ΂ȂȂB
 * 
 * ̃\tgEFA͐Β˔ڂɂĖۏ؂Œ񋟂A̖
 * IBłƂۏ؁AilLƂۏ؂ɂƂǂ܂炸A
 * Ȃ閾IшÎIȕۏ؂ȂB
 * Β˔ڂ ̃\tgEFA̎gpɂ钼ړIAԐړIA
 * IAȁAT^IȁA邢͕KRIȑQ(gpɂf[^
 * AƖ̒f〈܂Ăv̈⎸A֐i
 * T[rX̓l邪AĂꂾɌ肳Ȃ
 * Q)ɑ΂āAȂ鎖Ԃ̌ƂȂƂĂA_̐
 * C△ߎӔC܂ ȂӔC낤ƂAƂꂪs
 * ŝׂ߂łƂĂA܂͂̂悤ȑQ̉\
 * ĂƂĂ؂̐ӔC𕉂Ȃ̂ƂB
 */

package jp.gr.java_conf.dangan.util.lha;

//import classes and interfaces
import java.io.File;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.lang.Math;
import java.util.Vector;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Enumeration;
import jp.gr.java_conf.dangan.util.lha.LhaHeader;
import jp.gr.java_conf.dangan.util.lha.LhaProperty;
import jp.gr.java_conf.dangan.util.lha.CompressMethod;

//import exceptions
import java.io.IOException;
import java.io.EOFException;
import java.io.FileNotFoundException;
import java.io.UnsupportedEncodingException;
import java.lang.SecurityException;
import java.lang.IllegalArgumentException;
import java.util.NoSuchElementException;

import java.lang.Error;


/**
 * LHAɃt@CGgf[^ǂݏo
 * InputStream𓾂邽߂̃[eBeBNXB<br>
 * java.util.zip.ZipFile Ǝ
 * C^[tFCX悤ɍB
 * CRC16ɂ`FbN͍sȂB
 * 
 * <pre>
 * -- revision history --
 * $Log: LhaFile.java,v $
 * Revision 1.1  2002/12/08 00:00:00  dangan
 * [maintenance]
 *     LhaConstants  CompressMethod ւ̃NX̕ύXɍ킹ďCB
 *
 * Revision 1.0  2002/08/05 00:00:00  dangan
 * add to version control
 * [improvement]
 *     Gg̊Ǘ Hashtable gp鎖ɂ
 *     ʂ̃GgɂŃGgJnʒu
 *     葬悤ɉǁB
 * [change]
 *     RXgN^  String encode ̂p~A
 *     Properties Ɏ̂ǉB
 * [maintanance]
 *     \[X
 *     ^up~
 *     CZX̏C
 *
 * </pre>
 * 
 * @author  $Author: dangan $
 * @version $Revision: 1.1 $
 */
public class LhaFile{


    //------------------------------------------------------------------
    //  instance field
    //------------------------------------------------------------------
    //  archive file of LHA 
    //------------------------------------------------------------------
    //  private RandomAccessFile archive
    //  private Object LastAccessObject
    //  private Vector headers
    //  private Vector entryStart
    //  private Hashtable hash
    //  private Vector duplicate
    //------------------------------------------------------------------
    /**
     * LHAɌ`̃f[^
     * RandomAccessFilẽCX^X
     */
    private RandomAccessFile archive;

    /**
     * Ō archive ɃANZXIuWFNg
     */
    private Object LastAccessObject;

    /**
     * eGg̃wb_ LhaHeader  Vector
     * headers.elementAt( index ) ̃wb_Gg 
     * entryPoint.elementAt( index ) ̈ʒun܂B
     */
    private Vector headers;

    /**
     * eGg̊Jnʒu Long  Vector
     * headers.elementAt( index ) ̃wb_Gg 
     * entryPoint.elementAt( index ) ̈ʒun܂B
     */
    private Vector entryPoint;

    /**
     * Gg̖O(i[t@C)L[ɁA
     * L[̖ÕGg index nbVe[uB
     * vf Integer
     */
    private Hashtable hash;

    /**
     * t@C̋~opB
     * dOGg index  Vector
     * vf Integer
     */
    private Vector duplicate;


    //------------------------------------------------------------------
    //  instance field
    //------------------------------------------------------------------
    //  property
    //------------------------------------------------------------------
    //  private Properties property
    //------------------------------------------------------------------
    /**
     * ek`ɑΉ̐܂܂vpeB
     */
    private Properties property;


    //------------------------------------------------------------------
    //  constructor
    //------------------------------------------------------------------
    //  private LhaFile()
    //  public LhaFile( String filename )
    //  public LhaFile( String filename, Properties property )
    //  public LhaFile( File file )
    //  public LhaFile( File file, Properties property )
    //  public LhaFile( RandomAccessFile archive )
    //  public LhaFile( RandomAccessFile archive, boolean rescueMode )
    //  public LhaFile( RandomAccessFile archive, Properties property )
    //  public LhaFile( RandomAccessFile archive, 
    //                  Properties property, boolean rescueMode )
    //  private void constructerHelper( RandomAccessFile archive, 
    //                                  Properties property,
    //                                  boolean rescueMode )
    //------------------------------------------------------------------
    /**
     * ftHgRXgN^B
     * dls
     */
    private LhaFile(){  }

    /**
     * filename Ŏw肳ꂽt@C珑Ƀf[^ǂ݂LhaFile\zB<br>
     * ek`ɑΉ̐vpeBɂ
     * LhaProperty.getProperties() œꂽvpeBgpB<br>
     * 
     * @param filename LHAɃt@C̖O
     * 
     * @exception IOException
     *                 o̓G[ꍇ
     * @exception FileNotFoundException
     *                 t@CȂꍇ
     * @exception SecurityException
     *                 ZLeB}l[Wt@C̓ǂݍ݂Ȃꍇ
     * 
     * @see LhaProperty#getProperties()
     */
    public LhaFile( String filename ) throws IOException {
        Properties property   = LhaProperty.getProperties();
        RandomAccessFile file = new RandomAccessFile( filename, "r" );          //throws FileNotFoundException SecurityException

        this.constructerHelper( file, property, false );                        //After Java 1.1 throws UnsupportedEncodingException
    }

    /**
     * filename Ŏw肳ꂽt@C珑Ƀf[^ǂ݂LhaFile\zB<br>
     * 
     * @param filename LHAɃt@C̖O
     * @param property ek`ɑΉ̐܂܂vpeB
     * 
     * @exception IOException
     *                 o̓G[ꍇ
     * @exception FileNotFoundException
     *                 t@CȂꍇ
     * @exception UnsupportedEncodingException
     *                 property.getProperty( "lha.encoding" ) œꂽ
     *                 GR[fBOT|[gȂꍇ
     * @exception SecurityException
     *                 ZLeB}l[Wt@C̓ǂݍ݂Ȃꍇ
     * 
     * @see LhaProperty
     */
    public LhaFile( String filename, Properties property ) throws IOException {
        RandomAccessFile file = new RandomAccessFile( filename, "r" );          //throws FileNotFoundException SecurityException

        this.constructerHelper( file, property, false );                        //After Java 1.1 throws UnsupportedEncodingException
    }

    /**
     * filename Ŏw肳ꂽt@C珑Ƀf[^ǂ݂LhaFile\zB<br>
     * ek`ɑΉ̐vpeBɂ
     * LhaProperty.getProperties() œꂽvpeBgpB<br>
     * 
     * @param filename LHAɃt@C
     * 
     * @exception IOException
     *                 o̓G[ꍇ
     * @exception FileNotFoundException
     *                 t@CȂꍇ
     * @exception SecurityException
     *                 ZLeB}l[Wt@C̓ǂݍ݂Ȃꍇ
     * 
     * @see LhaProperty#getProperties()
     */
    public LhaFile( File filename ) throws IOException {
        Properties property   = LhaProperty.getProperties();
        RandomAccessFile file = new RandomAccessFile( filename, "r" );          //throws FileNotFoundException SecurityException

        this.constructerHelper( file, property, false );                        //After Java 1.1 throws UnsupportedEncodingException
    }

    /**
     * filename Ŏw肳ꂽt@C珑Ƀf[^ǂ݂ LhaFile \zB<br>
     * 
     * @param filename LHAɃt@C
     * @param property ek`ɑΉ̐܂܂vpeB
     * 
     * @exception IOException
     *                 o̓G[ꍇ
     * @exception FileNotFoundException
     *                 t@CȂꍇ
     * @exception UnsupportedEncodingException
     *                 property.getProperty( "lha.encoding" ) œꂽ
     *                 GR[fBOT|[gȂꍇ
     * @exception SecurityException
     *                 ZLeB}l[Wt@C̓ǂݍ݂Ȃꍇ
     * 
     * @see LhaProperty
     */
    public LhaFile( File filename, Properties property ) throws IOException {
        RandomAccessFile file = new RandomAccessFile( filename, "r" );          //throws FileNotFoundException SecurityException

        this.constructerHelper( file, property, false );                        //After Java 1.1 throws UnsupportedEncodingException
    }

    /**
     * file Ŏw肳ꂽt@C珑Ƀf[^ǂ݂ LhaFile \zB<br>
     * ek`ɑΉ̐vpeBɂ
     * LhaProperty.getProperties() œꂽvpeBgpB<br>
     * 
     * @param file LHAɃt@C
     * 
     * @exception IOException
     *                 o̓G[ꍇ
     * @exception FileNotFoundException
     *                 t@CȂꍇ
     * @exception SecurityException
     *                 ZLeB}l[Wt@C̓ǂݍ݂Ȃꍇ
     * 
     * @see LhaProperty#getProperties()
     */
    public LhaFile( RandomAccessFile file ) throws IOException {
        Properties property   = LhaProperty.getProperties();

        this.constructerHelper( file, property, false );
    }

    /**
     * file Ŏw肳ꂽt@C珑Ƀf[^ǂ݂ LhaFile \zB<br>
     * ek`ɑΉ̐vpeBɂ
     * LhaProperty.getProperties() œꂽvpeBgpB<br>
     * 
     * @param file       LHAɃt@C
     * @param rescueMode true ɂƉꂽɂ̃f[^
     *                   邽߂̕[hŃGgB
     * 
     * @exception IOException
     *                 o̓G[ꍇ
     * @exception FileNotFoundException
     *                 t@CȂꍇ
     * @exception SecurityException
     *                 ZLeB}l[Wt@C̓ǂݍ݂Ȃꍇ
     * 
     * @see LhaProperty#getProperties()
     */
    public LhaFile( RandomAccessFile file, boolean rescueMode ) 
                                                            throws IOException {
        Properties property   = LhaProperty.getProperties();

        this.constructerHelper( file, property, rescueMode );
    }

    /**
     * file Ŏw肳ꂽt@C珑Ƀf[^ǂ݂ LhaFile \zB<br>
     * 
     * @param file     LHAɃt@C
     * @param property ek`ɑΉ̐܂܂vpeB
     * 
     * @exception IOException
     *                 o̓G[ꍇ
     * @exception FileNotFoundException
     *                 t@CȂꍇ
     * @exception SecurityException
     *                 ZLeB}l[Wt@C̓ǂݍ݂Ȃꍇ
     * 
     * @see LhaProperty
     */
    public LhaFile( RandomAccessFile file, Properties property ) 
                                                            throws IOException {

        this.constructerHelper( file, property, false );
    }

    /**
     * file Ŏw肳ꂽt@C珑Ƀf[^ǂ݂ LhaFile \zB<br>
     * 
     * @param file       LHAɃt@C
     * @param property   ek`ɑΉ̐܂܂vpeB
     * @param rescueMode true ɂƉꂽɂ̃f[^
     *                   邽߂̕[hŃGgB
     * 
     * @exception IOException
     *                 o̓G[ꍇ
     * @exception FileNotFoundException
     *                 t@CȂꍇ
     * @exception SecurityException
     *                 ZLeB}l[Wt@C̓ǂݍ݂Ȃꍇ
     * 
     * @see LhaProperty
     */
    public LhaFile( RandomAccessFile file, Properties property, boolean rescueMode ) 
                                                            throws IOException {

        this.constructerHelper( file, property, rescueMode );
    }


    /**
     * file 𑖍ăGg\zB<br>
     * 
     * @param file       LHAɃt@C
     * @param propety    ek`ɑΉ̐܂܂vpeB
     * @param rescueMode true ɂƉꂽɂ̃f[^
     *                   邽߂̕[hŃGgB
     * 
     * @exception IOException
     *                 o̓G[ꍇ
     * @exception UnsupportedEncodingException
     *                 encodeT|[gȂꍇ
     */
    private void constructerHelper( RandomAccessFile file,
                                    Properties       property,
                                    boolean          rescueMode )
                                                            throws IOException {

        this.headers    = new Vector();
        this.entryPoint = new Vector();

        file.seek( 0 );
        CachedRandomAccessFileInputStream archive =  new CachedRandomAccessFileInputStream( file );

        byte[] HeaderData = LhaHeader.getFirstHeaderData( archive );
        while( null != HeaderData ){
            LhaHeader header = LhaHeader.createInstance( HeaderData, property );
            headers.addElement( header );
            entryPoint.addElement( new Long( archive.position() ) );

            if( !rescueMode ){
                archive.skip( header.getCompressedSize() );
                HeaderData = LhaHeader.getNextHeaderData( archive );
            }else{
                HeaderData = LhaHeader.getFirstHeaderData( archive );
            }
        }
        archive.close();

        this.hash      = new Hashtable();
        this.duplicate = new Vector();
        for( int i = 0 ; i < this.headers.size() ; i++ ){
            LhaHeader header = (LhaHeader)headers.elementAt(i);

            if( !this.hash.containsKey( header.getPath() ) ){
                this.hash.put( header.getPath(), new Integer( i ) );
            }else{
                this.duplicate.addElement( new Integer( i ) );
            }
        }

        this.archive  = file;
        this.property = (Properties)property.clone();
    }


    //------------------------------------------------------------------
    //  original method ( on the model of java.util.zip.ZipFile )
    //------------------------------------------------------------------
    //  get InputStream
    //------------------------------------------------------------------
    //  public InputStream getInputStream( LhaHeader header )
    //  public InputStream getInputStream( String name )
    //  public InputStream getInputStreamWithoutExtract( LhaHeader header )
    //  public InputStream getInputStreamWithoutExtract( String name )
    //------------------------------------------------------------------
    /**
     * header Ŏw肳ꂽGg
     * e𓀂Ȃǂ݂ޓ̓Xg[𓾂B<br>
     * 
     * @param header wb_
     * 
     * @return headerŎw肳ꂽwb_Gg
     *         eǂ݂ޓ̓Xg[B<br>
     *         GgȂꍇ nullB
     */
    public InputStream getInputStream( LhaHeader header ){
        int index = this.getIndex( header );
        if( 0 <= index ){
            long start = ((Long)this.entryPoint.elementAt( index )).longValue();
            long len   = header.getCompressedSize();
            InputStream in = new RandomAccessFileInputStream( start, len );

            return CompressMethod.connectDecoder( in, 
                                                  header.getCompressMethod(), 
                                                  this.property,
                                                  header.getOriginalSize() );
        }else{
            return null;
        }
    }

    /**
     * nameŎw肳ꂽOGg
     * e𓀂Ȃǂ݂ޓ̓Xg[𓾂B<br>
     * 
     * @param name Gg̖O
     * 
     * @return nameŎw肳ꂽOGg
     *         e𓀂Ȃǂ݂ޓ̓Xg[B<br>
     *         GgȂꍇ nullB
     */
    public InputStream getInputStream( String name ){
        if( this.hash.containsKey( name ) ){
            int index  = ((Integer)this.hash.get( name )).intValue();
            LhaHeader header = (LhaHeader)this.headers.elementAt( index );
            long start = ((Long)this.entryPoint.elementAt( index )).longValue();
            long len   = header.getCompressedSize();
            InputStream in = new RandomAccessFileInputStream( start, len );

            return CompressMethod.connectDecoder( in, 
                                                  header.getCompressMethod(), 
                                                  this.property,
                                                  header.getOriginalSize() );
        }else{
            return null;
        }
    }

    /**
     * headerŎw肳ꂽGg̓e
     * 𓀂ɓǂ݂ޓ̓Xg[ԂB<br>
     * 
     * @param header wb_
     * 
     * @return headerŎw肳ꂽGg̓e
     *         𓀂ɓǂ݂ޓ̓Xg[B<br>
     *         GgȂꍇ nullB
     */
    public InputStream getInputStreamWithoutExtract( LhaHeader header ){
        int index = this.getIndex( header );
        if( 0 <= index ){
            long start = ((Long)this.entryPoint.elementAt( index )).longValue();
            long len   = header.getCompressedSize();

            return new RandomAccessFileInputStream( start, len );
        }else{
            return null;
        }
    }

    /**
     * nameŎw肳ꂽOGg
     * e𓀂ɓǂ݂ޓ̓Xg[ԂB<br>
     * 
     * @param name Gg̖O
     * 
     * @return nameŎw肳ꂽOGg
     *         e𓀂ɓǂ݂ޓ̓Xg[B<br>
     *         GgȂꍇ nullB
     */
    public InputStream getInputStreamWithoutExtract( String name ){
        if( this.hash.containsKey( name ) ){
            int index  = ((Integer)this.hash.get( name )).intValue();
            LhaHeader header = (LhaHeader)this.headers.elementAt( index );
            long start = ((Long)this.entryPoint.elementAt( index )).longValue();
            long len   = header.getCompressedSize();

            return new RandomAccessFileInputStream( start, len );
        }else{
            return null;
        }
    }


    //------------------------------------------------------------------
    //  original method ( on the model of java.util.zip.ZipFile  )
    //------------------------------------------------------------------
    //  other
    //------------------------------------------------------------------
    //  public int size()
    //  public Enumeration entries()
    //  public LhaHeader[] getEntries()
    //  public void close()
    //------------------------------------------------------------------
    /**
     *  LhaFile ̃Gg̐𓾂B
     * 
     * @return t@C̃Gg̐
     */
    public int size(){
        return this.headers.size();
    }

    /**
     *  LhaFile ̃Gg LhaHeader ̗񋓎q𓾂B
     * 
     * @return LhaHeader ̗񋓎q
     * 
     * @exception IllegalStateException
     *                   LhaFile  close() ŕĂꍇB
     */
    public Enumeration entries(){
        if( this.archive != null ){
            return new HeaderEnumeration();
        }else{
            throw new IllegalStateException();
        }
    }

    /**
     * t@C̃Gg񋓂z𓾂B
     * 
     * @return t@C̃Gg񋓂z
     */
    public LhaHeader[] getEntries(){
        LhaHeader[] headers = new LhaHeader[ this.headers.size() ];

        for( int i = 0 ; i < this.headers.size() ; i++ ){
            headers[i] = (LhaHeader)((LhaHeader)this.headers.elementAt( i )).clone();
        }

        return headers;
    }


    /**
     *  LHAɃt@CB
     * ̍ہALhaFilesSĂ
     * InputStream͋IɕB
     * 
     * @exception IOException o̓G[ꍇ
     */
    public void close() throws IOException {
        this.archive.close();
        this.archive          = null;
        this.LastAccessObject = null;
        this.headers          = null;
        this.entryPoint       = null;
        this.hash             = null;
        this.property         = null;
        this.duplicate        = null;
    }


    //------------------------------------------------------------------
    //  local method
    //------------------------------------------------------------------
    //  private int getIndex( LhaHeader target )
    //  private static boolean equal( LhaHeader header1, LhaHeader header2 )
    //------------------------------------------------------------------
    /**
     * headers ɂ target  index 𓾂B
     * 
     * @param target wb_
     * 
     * @return headers ł target  indexB 
     *         headers  target Ȃꍇ -1
     */
    private int getIndex( LhaHeader target ){
        int index = ((Integer)this.hash.get( target.getPath() )).intValue();

        LhaHeader header = (LhaHeader)this.headers.elementAt( index );
        if( !LhaFile.equal( header, target ) ){
            boolean match = false;
            for( int i = 0 ; i < this.duplicate.size() && !match ; i++ ){
                index  = ((Integer)this.duplicate.elementAt( i )).intValue();
                header = (LhaHeader)this.headers.elementAt( index );

                if( LhaFile.equal( header, target ) ){
                    match = true;
                }
            }

            if( match ){
                return index;
            }else{
                return -1;
            }
        }else{
            return index;
        }
    }

    /**
     * 2 LhaHeaderAheader1  header2 ׂB
     * 
     * @param header1 Ώۂ̃wb_ 1
     * @param header2 Ώۂ̃wb_ 2
     * 
     * @return header1  header2 ł true Ⴆ false
     */
    private static boolean equal( LhaHeader header1, LhaHeader header2 ){
        return    header1.getPath().equals( header2.getPath() )
               && header1.getCompressMethod().equals( header2.getCompressMethod() )
               && header1.getLastModified().equals( header2.getLastModified() )
               && header1.getCompressedSize() == header2.getCompressedSize()
               && header1.getOriginalSize()   == header2.getOriginalSize()
               && header1.getCRC()            == header2.getCRC()
               && header1.getOSID()           == header2.getOSID()
               && header1.getHeaderLevel()    == header2.getHeaderLevel();
    }


    //------------------------------------------------------------------
    //  inner classes
    //------------------------------------------------------------------
    //  private class RandomAccessFileInputStream
    //  private static class CachedRandomAccessFileInputStream
    //  private class EntryEnumeration
    //------------------------------------------------------------------
    /**
     * LhaFilearchive ԓ̃f[^𓾂 InputStreamB
     * Gg𓯎ɏ邽߂ ܂ށB
     */
    private class RandomAccessFileInputStream extends InputStream {

        //------------------------------------------------------------------
        //  member values
        //------------------------------------------------------------------
        //  private long position
        //  private long end
        //  private long markPosition
        //------------------------------------------------------------------
        /**
         * archivěݏʒu
         */
        private long position;

        /**
         * archivêInputStream̓ǂݎE
         */
        private long end;

        /**
         * archivẽ}[Nʒu
         */
        private long markPosition;


        //------------------------------------------------------------------
        //  constructor
        //------------------------------------------------------------------
        //  public RandomAccessFileInputStream( long start, long size )
        //------------------------------------------------------------------
        /**
         * RXgN^B
         * 
         * @param start ǂ݂݊Jnʒu
         * @param size  f[^̃TCY
         */
        public RandomAccessFileInputStream( long start, long size ){
            this.position     = start;
            this.end          = start + size;
            this.markPosition = -1;
        }

        //------------------------------------------------------------------
        //  method of java.io.InputStream
        //------------------------------------------------------------------
        //  read
        //------------------------------------------------------------------
        //  public int read()
        //  public int read( byte[] buffer )
        //  public int read( byte[] buffer, int index, int length )
        //  public long skip( long length )
        //------------------------------------------------------------------
        /**
         * archivěݏʒu 1bytẽf[^ǂݍށB
         * 
         * @return ǂ݂܂ꂽ1bytẽf[^<br>
         *         ɓǂ݂݌EɒBꍇ -1
         * 
         * @exception IOException o̓G[ꍇ
         */
        public int read() throws IOException {
            synchronized( LhaFile.this.archive ){
                if( this.position < this.end ){
                    if( LhaFile.this.LastAccessObject != this )
                        LhaFile.this.archive.seek( this.position );

                    int data = LhaFile.this.archive.read();
                    if( 0 <= data ) this.position++;
                    return data;
                }else{
                    return -1;
                }
            }
        }

        /**
         * archivěݏʒu buffer𖞂悤Ƀf[^ǂݍށB
         * 
         * @param buffer ǂ݂܂ꂽf[^i[obt@
         * 
         * @return ǂ݂܂ꂽoCg<br>
         *         ɓǂ݂݌EɒBĂꍇ-1
         * 
         * @exception IOException o̓G[ꍇ
         */
        public int read( byte[] buffer ) throws IOException {
            return this.read( buffer, 0, buffer.length );
        }

        /**
         * archivěݏʒu bufferindexn܂̈
         * lengthoCg̃f[^ǂݍށB
         * 
         * @param buffer ǂ݂܂ꂽf[^i[obt@
         * @param index  buffer̓ǂ݂݊Jnʒu
         * @param length ǂ݂ރoCgB
         * 
         * @return ǂ݂܂ꂽoCg<br>
         *         ɓǂ݂݌EɒBĂꍇ-1
         * 
         * @exception IOException o̓G[ꍇ
         */
        public int read( byte[] buffer, int index, int length )
                                                        throws IOException {
            synchronized( LhaFile.this.archive ){
                if( this.position < this.end ){
                    if( LhaFile.this.LastAccessObject != this ){
                        LhaFile.this.archive.seek( this.position );
                        LhaFile.this.LastAccessObject = this;
                    }

                    length = (int)Math.min( this.end - this.position, length );
                    length = LhaFile.this.archive.read( buffer, index, length );
                    if( 0 <= length ) this.position += length;
                    return length;
                }else{
                    return -1;
                }
            }
        }

        /**
         * lengthoCg̃f[^ǂݔ΂B
         * 
         * @param length ǂݔ΂oCg
         * 
         * @return ۂɓǂݔ΂ꂽoCg
         */
        public long skip( long length ){
            synchronized( LhaFile.this.archive ){
                long skiplen = Math.min( this.end - this.position, length );
                this.position += skiplen;

                if( LhaFile.this.LastAccessObject == this )
                    LhaFile.this.LastAccessObject = null;

                return skiplen;
            }
        }

        //------------------------------------------------------------------
        //  method of java.io.InputStream
        //------------------------------------------------------------------
        //  mark/reset
        //------------------------------------------------------------------
        //  public boolean markSupported()
        //  public void mark( int readLimit )
        //  public void reset()
        //------------------------------------------------------------------
        /**
         * ̃IuWFNgmark/resetT|[g邩ԂB
         * 
         * @return ̃IuWFNgmark/resetT|[gB<br>
         *         trueB
         */
        public boolean markSupported(){
            return true;
        }

        /**
         * ݏʒuɃ}[N{reset
         * ݂̏ʒuɖ߂悤ɂB
         * 
         * @param readLimit }[N̗LEB
         *                  ̃IuWFNgł͈ӖȂB
         */
        public void mark( int readLimit ){
            this.markPosition = this.position;
        }

        /**
         * ŌɃ}[Nꂽʒuɖ߂B
         * 
         * @exception IOException mark()ĂȂꍇ
         */
        public void reset() throws IOException {
            synchronized( LhaFile.this.archive ){
                if( 0 <= this.markPosition ){
                    this.position = this.markPosition;
                }else{
                    throw new IOException( "not marked" );
                }

                if( LhaFile.this.LastAccessObject == this )
                    LhaFile.this.LastAccessObject = null;
            }
        }

        //------------------------------------------------------------------
        //  method of java.io.InputStream
        //------------------------------------------------------------------
        //  other
        //------------------------------------------------------------------
        //  public int available()
        //  public void close()
        //------------------------------------------------------------------
        /**
         * ڑꂽ̓Xg[ubNȂ
         * ǂݍނƂ̂łoCg𓾂B<br>
         * RandomAccessFileInputStream ł
         * ǂݍ݂͏ RandomAccessFile ɑ΂
         * ANZX𔺂߁Ã\bh͏ 0 ԂB
         * 
         * @return  0<br>
         */
        public int available(){
            return 0;
        }

        /**
         * ̓̓Xg[AgpĂSẴ\[XJB<br>
         * ̃\bh͉sȂB
         */
        public void close(){
        }

    }

    /**
     * wb_p  RandomAccessFileInputStreamB<br>
     * obt@OƓsȂɂčĂB
     */
    private static class CachedRandomAccessFileInputStream extends InputStream {

        //------------------------------------------------------------------
        //  instance field
        //------------------------------------------------------------------
        //  source
        //------------------------------------------------------------------
        //  private RandomAccessFile archive
        //------------------------------------------------------------------
        /**
         * f[^ RandomAccessFile
         */
        private RandomAccessFile archive;


        //------------------------------------------------------------------
        //  instance field
        //------------------------------------------------------------------
        //  cache
        //------------------------------------------------------------------
        //  private byte[] cache
        //  private int cachePosition
        //  private int cacheLimit
        //------------------------------------------------------------------
        /**
         * f[^~邽߂̃LbV
         */
        private byte[] cache;

        /**
         * cachěݏʒu
         */
        private int cachePosition;

        /**
         * cache̓ǂݍ݌Eʒu
         */
        private int cacheLimit;


        //------------------------------------------------------------------
        //  instance field
        //------------------------------------------------------------------
        //  backup for mark/reset
        //------------------------------------------------------------------
        //  private boolean markPositionIsInCache
        //  private byte[] markCache
        //  private int markCachePosition
        //  private int markCacheLimit
        //  private long markPosition
        //------------------------------------------------------------------
        /**
         * markʒuLbV͈͓̔ɂ邩B
         * markꂽƂ true ɐݒ肳A
         *  in  LbVւ̓ǂݍ݂
         * sꂽƂ false ɐݒ肳B
         */
        private boolean markPositionIsInCache;

        /** cachẽobNAbvp */
        private byte[] markCache;

        /** cachePositioñobNAbvp */
        private int markCachePosition;

        /** cacheLimit̃obNAbvp */
        private int markCacheLimit;

        /** position ̃obNAbvp */
        private long markPosition;


        //------------------------------------------------------------------
        //  constructer
        //------------------------------------------------------------------
        //  public CachedRandomAccessFileInputStream()
        //------------------------------------------------------------------
        /**
         * LbVgp  RandomAccessFileInputStream \zB
         * 
         * @param file f[^ RandomAccessFile
         */
        public CachedRandomAccessFileInputStream( RandomAccessFile file ){
            this.archive       = file;

            this.cache         = new byte[ 1024 ];
            this.cachePosition = 0;
            this.cacheLimit    = 0;
        }

        //------------------------------------------------------------------
        //  method of java.io.InputStream
        //------------------------------------------------------------------
        //  read
        //------------------------------------------------------------------
        //  public int read()
        //  public int read( byte[] buffer )
        //  public int read( byte[] buffer, int index, int length )
        //  public long skip( long length )
        //------------------------------------------------------------------
        /**
         * archivěݏʒu 1bytẽf[^ǂݍށB
         * 
         * @return ǂ݂܂ꂽ1bytẽf[^<br>
         *         ɓǂ݂݌EɒBꍇ -1
         * 
         * @exception IOException o̓G[ꍇ
         */
        public int read() throws IOException {
            if( this.cachePosition < this.cacheLimit ){
                return this.cache[ this.cachePosition++ ] & 0xFF;
            }else{
                this.fillCache();                                                     //throws IOException

                if( this.cachePosition < this.cacheLimit ){
                    return this.cache[ this.cachePosition++ ] & 0xFF;
                }else{
                    return -1;
                }
            }
        }

        /**
         * archivěݏʒu buffer𖞂悤Ƀf[^ǂݍށB
         * 
         * @param buffer ǂ݂܂ꂽf[^i[obt@
         * 
         * @return ǂ݂܂ꂽoCg<br>
         *         ɓǂ݂݌EɒBĂꍇ-1
         * 
         * @exception IOException o̓G[ꍇ
         */
        public int read( byte[] buffer ) throws IOException {
            return this.read( buffer, 0, buffer.length );
        }

        /**
         * archivěݏʒu bufferindexn܂̈
         * lengthoCg̃f[^ǂݍށB
         * 
         * @param buffer ǂ݂܂ꂽf[^i[obt@
         * @param index  buffer̓ǂ݂݊Jnʒu
         * @param length ǂ݂ރoCgB
         * 
         * @return ǂ݂܂ꂽoCg<br>
         *         ɓǂ݂݌EɒBĂꍇ-1
         * 
         * @exception IOException o̓G[ꍇ
         */
        public int read( byte[] buffer, int index, int length )
                                                        throws IOException {
            final int requested = length;

            while( 0 < length ){
                if( this.cacheLimit <= this.cachePosition ){
                    this.fillCache();                                             //throws IOException
                    if( this.cacheLimit <= this.cachePosition ){
                        if( requested == length ){
                            return -1;
                        }else{
                            break;
                        }
                    }
                }

                int copylen = Math.min( length,
                                        this.cacheLimit - this.cachePosition );
                System.arraycopy( this.cache, this.cachePosition,
                                  buffer, index, copylen );

                index              += copylen;
                length             -= copylen;
                this.cachePosition += copylen;
            }
            return requested - length;
        }

        /**
         * lengthoCg̃f[^ǂݔ΂B
         * 
         * @param length ǂݔ΂oCg
         * 
         * @return ۂɓǂݔ΂ꂽoCg
         */
        public long skip( long length ) throws IOException  {
            final long requested = length;

            if( this.cachePosition < this.cacheLimit ){
                long avail   = (long)this.cacheLimit - this.cachePosition;
                long skiplen = Math.min( length, avail );

                length -= skiplen;
                this.cachePosition += (int)skiplen;
            }

            if( 0 < length ){
                long avail    = this.archive.length() - this.archive.getFilePointer();
                long skiplen  = Math.min( avail, length );

                length -= skiplen;
                archive.seek( archive.getFilePointer() + skiplen );
            }

            return requested - length;
        }


        //------------------------------------------------------------------
        //  method of java.io.InputStream
        //------------------------------------------------------------------
        //  mark/reset
        //------------------------------------------------------------------
        //  public boolean markSupported()
        //  public void mark( int readLimit )
        //  public void reset()
        //------------------------------------------------------------------
        /**
         * ̃IuWFNgmark/resetT|[g邩ԂB
         * 
         * @return ̃IuWFNgmark/resetT|[gB<br>
         *         trueB
         */
        public boolean markSupported(){
            return true;
        }

        /**
         * ݏʒuɃ}[N{reset
         * ݂̏ʒuɖ߂悤ɂB
         * 
         * @param readLimit }[N̗LEB
         *                  ̃IuWFNgł͈ӖȂB
         */
        public void mark( int readLimit ){
            try{
                this.markPosition = this.archive.getFilePointer();
            }catch( IOException exception ){
                throw new Error( "caught IOException( " + exception.getMessage() + " ) in mark()" );
            }

            if( this.markCache == null ){
                this.markCache = (byte[])this.cache.clone();
            }else{
                System.arraycopy( this.cache, 0, this.markCache, 0, this.cacheLimit );
            }

            this.markCacheLimit        = this.cacheLimit;
            this.markCachePosition     = this.cachePosition;
            this.markPositionIsInCache = true;
        }

        /**
         * ŌɃ}[Nꂽʒuɖ߂B
         * 
         * @exception IOException mark()ĂȂꍇ
         */
        public void reset() throws IOException {
            if( this.markPositionIsInCache ){
                this.cachePosition  = this.markCachePosition;
            }else if( this.markCache == null ){ //͖̏Ƀ}[NĂȂƂBRXgN^ markCache  null ɐݒ肳̂𗘗pB 
                throw new IOException( "not marked." );
            }else{
                //in  reset() łȂꍇ
                //ŏ̍s this.in.reset() 
                //IOException 𓊂邱Ƃ҂ĂB
                this.archive.seek( this.markPosition );                 //throws IOException

                System.arraycopy( this.markCache, 0, this.cache, 0, this.markCacheLimit );
                this.cacheLimit    = this.markCacheLimit;
                this.cachePosition = this.markCachePosition;
            }
        }


        //------------------------------------------------------------------
        //  method of java.io.InputStream
        //------------------------------------------------------------------
        //  other
        //------------------------------------------------------------------
        //  public int available()
        //  public void close()
        //------------------------------------------------------------------
        /**
         * ڑꂽ̓Xg[ubNȂ
         * ǂݍނƂ̂łoCg𓾂B<br>
         * 
         * @return ubNȂœǂݏooCgB<br>
         */
        public int available(){
            return this.cacheLimit - this.cachePosition;
        }

        /**
         * ̓̓Xg[AgpĂ
         * SẴ\[XJB<br>
         */
        public void close(){
            this.archive       = null;

            this.cache         = null;
            this.cachePosition = 0;
            this.cacheLimit    = 0;

            this.markPositionIsInCache = false;
            this.markCache             = null;
            this.markCachePosition     = 0;
            this.markCacheLimit        = 0;
            this.markPosition          = 0;
        }


        //------------------------------------------------------------------
        //  original method
        //------------------------------------------------------------------
        //  public long position()
        //------------------------------------------------------------------
        /**
         * t@C擪n_Ƃ錻݂̓ǂݍ݈ʒu𓾂B
         * 
         * @return ݂̓ǂݍ݈ʒuB
         */
        public long position() throws IOException {
            long position = this.archive.getFilePointer();

            position -= this.cacheLimit - this.cachePosition;

            return position;
        }

        //------------------------------------------------------------------
        //  local method
        //------------------------------------------------------------------
        //  private void fillCache()
        //------------------------------------------------------------------
        /**
         * KvꍇɁALbVpobt@Ƀf[^
         * ULbVpobt@ɕKf[^݂
         * Ƃۏ؂邽߂ɌĂ΂B<br>
         *  EndOfStream ܂œǂݍ܂Ăꍇ f[^
         * UȂƂɂ B
         * 
         * @exception IOException o̓G[ꍇ
         */
        private void fillCache() throws IOException {
            this.markPositionIsInCache = false;
            this.cacheLimit            = 0;
            this.cachePosition         = 0;

            //LbVɃf[^ǂݍ
            int read = 0;
            while( 0 <= read && this.cacheLimit < this.cache.length ){
                read = this.archive.read( this.cache,
                                          this.cacheLimit, 
                                          this.cache.length - this.cacheLimit );//throws IOException

                if( 0 < read ) this.cacheLimit += read;
            }
        }

    }

    /**
     * LhaFile ɂSĂ LhaHeader Ԃ񋓎q
     */
    private class HeaderEnumeration implements Enumeration {

        //------------------------------------------------------------------
        //  instance field
        //------------------------------------------------------------------
        //  private int index
        //------------------------------------------------------------------
        /**
         * ݏʒu
         */
        private int index;

        //------------------------------------------------------------------
        //  constructor
        //------------------------------------------------------------------
        //  public EntryEnumeration()
        //------------------------------------------------------------------
        /**
         * LhaFile ɂSĂ LhaHeader Ԃ񋓎q\zB
         */
        public HeaderEnumeration(){
            this.index = 0;
        }

        //------------------------------------------------------------------
        //  method of java.util.Enumeration
        //------------------------------------------------------------------
        //  public boolean hasMoreElements()
        //  public Object nextElement()
        //------------------------------------------------------------------
        /**
         * 񋓎qɂ܂vfcĂ邩𓾂B
         * 
         * @return 񋓎qɂ܂vfcĂȂ true
         *         cĂȂ false
         * 
         * @exception IllegalStateException
         *                 e LhaFile ꂽꍇ
         */
        public boolean hasMoreElements(){
            if( LhaFile.this.archive != null ){
                return this.index < LhaFile.this.headers.size();
            }else{
                throw new IllegalStateException();
            }
        }

        /**
         * 񋓎q̗̎vf𓾂B
         * 
         * @return 񋓎q̗̎vf
         * 
         * @exception IllegalStateException
         *                 e LhaFile ꂽꍇB
         * @exception NoSuchElementException
         *                 񋓎qɗvfꍇB
         *                 
         */
        public Object nextElement(){
            if( LhaFile.this.archive != null ){
                if( this.index < LhaFile.this.headers.size() ){
                    return ((LhaHeader)LhaFile.this.headers.elementAt( this.index++ )).clone();
                }else{
                    throw new NoSuchElementException();
                }
            }else{
                throw new IllegalStateException();
            }
        }
    }

}
//end of LhaFile.java
