/*
 * Copyright (C) 2015 Canonical Ltd.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authored by: Michi Henning <michi.henning@canonical.com>
 */

#pragma once

#include "dbus_connection.h"

#include <lomiri/util/DefinesPtrs.h>

#include <QStringList>

namespace lomiri
{

namespace thumbnailer
{

namespace tools
{

class Action
{
public:
    LOMIRI_DEFINES_PTRS(Action);

    virtual ~Action()
    {
    }

    virtual void run(DBusConnection& conn) = 0;

protected:
    Action(QCommandLineParser& parser)
        : parser_(parser)
        , command_(parser.positionalArguments().first())
        , help_option_(parser.addHelpOption())
    {
        parser.setApplicationDescription(QStringLiteral("Thumbnailer administrative tool"));
        parser.clearPositionalArguments();
    }

    QCommandLineParser& parser_;
    QString command_;
    QCommandLineOption help_option_;
};

}  // namespace tools

}  // namespace thumbnailer

}  // namespace lomiri
