// RUN: %clang_builtins %s %librt -o %t && %run %t
// REQUIRES: librt_has_udivmodti4
// REQUIRES: int128

#include "int_lib.h"
#include <stdio.h>

#ifdef CRT_HAS_128BIT

// Effects: if rem != 0, *rem = a % b
// Returns: a / b

COMPILER_RT_ABI tu_int __udivmodti4(tu_int a, tu_int b, tu_int* rem);

int test__udivmodti4(tu_int a, tu_int b, tu_int expected_q, tu_int expected_r)
{
    tu_int r;
    tu_int q = __udivmodti4(a, b, &r);
    if (q != expected_q || r != expected_r)
    {
        utwords at;
        at.all = a;
        utwords bt;
        bt.all = b;
        utwords expected_qt;
        expected_qt.all = expected_q;
        utwords expected_rt;
        expected_rt.all = expected_r;
        utwords qt;
        qt.all = q;
        utwords rt;
        rt.all = r;
        printf("error in __udivmodti4: 0x%.16llX%.16llX / 0x%.16llX%.16llX = "
               "0x%.16llX%.16llX, R = 0x%.16llX%.16llX, expected 0x%.16llX%.16llX, "
               "0x%.16llX%.16llX\n",
               at.s.high, at.s.low, bt.s.high, bt.s.low, qt.s.high, qt.s.low,
               rt.s.high, rt.s.low, expected_qt.s.high, expected_qt.s.low,
               expected_rt.s.high, expected_rt.s.low);
    }
    return !(q == expected_q && r == expected_r);
}

char assumption_1[sizeof(ti_int) == 2*sizeof(di_int)] = {0};

tu_int tests[][4] =
{
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000001uLL << 64 | 0x0000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000001uLL << 64 | 0x0000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000001uLL << 64 | 0x0000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000001uLL << 64 | 0x00000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000001uLL << 64 | 0x0000000100000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000001uLL << 64 | 0x0000000100000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000001uLL << 64 | 0x0000000180000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000001uLL << 64 | 0x00000001FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000001uLL << 64 | 0x8000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000001uLL << 64 | 0x8000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000001uLL << 64 | 0x8000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000001uLL << 64 | 0x80000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000001uLL << 64 | 0xFFFFFFFF00000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000001uLL << 64 | 0xFFFFFFFF00000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000001uLL << 64 | 0xFFFFFFFF80000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000001uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000080000000uLL << 64 | 0x0000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000080000000uLL << 64 | 0x0000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000080000000uLL << 64 | 0x0000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000080000000uLL << 64 | 0x00000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000080000000uLL << 64 | 0x0000000100000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000080000000uLL << 64 | 0x0000000100000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000080000000uLL << 64 | 0x0000000180000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000080000000uLL << 64 | 0x00000001FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000080000000uLL << 64 | 0x8000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000080000000uLL << 64 | 0x8000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000080000000uLL << 64 | 0x8000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000080000000uLL << 64 | 0x80000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000080000000uLL << 64 | 0xFFFFFFFF00000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000080000000uLL << 64 | 0xFFFFFFFF00000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000080000000uLL << 64 | 0xFFFFFFFF80000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000080000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x00000000FFFFFFFFuLL << 64 | 0x0000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x00000000FFFFFFFFuLL << 64 | 0x0000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x00000000FFFFFFFFuLL << 64 | 0x0000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x00000000FFFFFFFFuLL << 64 | 0x00000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x00000000FFFFFFFFuLL << 64 | 0x0000000100000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x00000000FFFFFFFFuLL << 64 | 0x0000000100000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x00000000FFFFFFFFuLL << 64 | 0x0000000180000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x00000000FFFFFFFFuLL << 64 | 0x00000001FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x00000000FFFFFFFFuLL << 64 | 0x8000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x00000000FFFFFFFFuLL << 64 | 0x8000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x00000000FFFFFFFFuLL << 64 | 0x8000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x00000000FFFFFFFFuLL << 64 | 0x80000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x00000000FFFFFFFFuLL << 64 | 0xFFFFFFFF00000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x00000000FFFFFFFFuLL << 64 | 0xFFFFFFFF00000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x00000000FFFFFFFFuLL << 64 | 0xFFFFFFFF80000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x00000000FFFFFFFFuLL << 64 | 0xFFFFFFFFFFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000100000000uLL << 64 | 0x0000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000100000000uLL << 64 | 0x0000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000100000000uLL << 64 | 0x0000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000100000000uLL << 64 | 0x00000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000100000000uLL << 64 | 0x0000000100000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000100000000uLL << 64 | 0x0000000100000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000100000000uLL << 64 | 0x0000000180000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000100000000uLL << 64 | 0x00000001FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000100000000uLL << 64 | 0x8000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000100000000uLL << 64 | 0x8000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000100000000uLL << 64 | 0x8000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000100000000uLL << 64 | 0x80000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000100000000uLL << 64 | 0xFFFFFFFF00000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000100000000uLL << 64 | 0xFFFFFFFF00000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000100000000uLL << 64 | 0xFFFFFFFF80000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000100000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000100000001uLL << 64 | 0x0000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000100000001uLL << 64 | 0x0000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000100000001uLL << 64 | 0x0000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000100000001uLL << 64 | 0x00000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000100000001uLL << 64 | 0x0000000100000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000100000001uLL << 64 | 0x0000000100000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000100000001uLL << 64 | 0x0000000180000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000100000001uLL << 64 | 0x00000001FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000100000001uLL << 64 | 0x8000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000100000001uLL << 64 | 0x8000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000100000001uLL << 64 | 0x8000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000100000001uLL << 64 | 0x80000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000100000001uLL << 64 | 0xFFFFFFFF00000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000100000001uLL << 64 | 0xFFFFFFFF00000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000100000001uLL << 64 | 0xFFFFFFFF80000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000100000001uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000180000000uLL << 64 | 0x0000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000180000000uLL << 64 | 0x0000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000180000000uLL << 64 | 0x0000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000180000000uLL << 64 | 0x00000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000180000000uLL << 64 | 0x0000000100000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000180000000uLL << 64 | 0x0000000100000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000180000000uLL << 64 | 0x0000000180000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000180000000uLL << 64 | 0x00000001FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000180000000uLL << 64 | 0x8000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000180000000uLL << 64 | 0x8000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000180000000uLL << 64 | 0x8000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000180000000uLL << 64 | 0x80000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000180000000uLL << 64 | 0xFFFFFFFF00000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000180000000uLL << 64 | 0xFFFFFFFF00000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000180000000uLL << 64 | 0xFFFFFFFF80000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000180000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x00000001FFFFFFFFuLL << 64 | 0x0000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x00000001FFFFFFFFuLL << 64 | 0x0000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x00000001FFFFFFFFuLL << 64 | 0x0000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x00000001FFFFFFFFuLL << 64 | 0x00000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x00000001FFFFFFFFuLL << 64 | 0x0000000100000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x00000001FFFFFFFFuLL << 64 | 0x0000000100000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x00000001FFFFFFFFuLL << 64 | 0x0000000180000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x00000001FFFFFFFFuLL << 64 | 0x00000001FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x00000001FFFFFFFFuLL << 64 | 0x8000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x00000001FFFFFFFFuLL << 64 | 0x8000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x00000001FFFFFFFFuLL << 64 | 0x8000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x00000001FFFFFFFFuLL << 64 | 0x80000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x00000001FFFFFFFFuLL << 64 | 0xFFFFFFFF00000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x00000001FFFFFFFFuLL << 64 | 0xFFFFFFFF00000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x00000001FFFFFFFFuLL << 64 | 0xFFFFFFFF80000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x00000001FFFFFFFFuLL << 64 | 0xFFFFFFFFFFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x8000000000000000uLL << 64 | 0x0000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x8000000000000000uLL << 64 | 0x0000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x8000000000000000uLL << 64 | 0x0000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x8000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x8000000000000000uLL << 64 | 0x0000000100000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x8000000000000000uLL << 64 | 0x0000000100000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x8000000000000000uLL << 64 | 0x0000000180000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x8000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x8000000000000000uLL << 64 | 0x8000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x8000000000000000uLL << 64 | 0x8000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x8000000000000000uLL << 64 | 0x8000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x8000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x8000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x8000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x8000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x8000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x8000000000000001uLL << 64 | 0x0000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x8000000000000001uLL << 64 | 0x0000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x8000000000000001uLL << 64 | 0x0000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x8000000000000001uLL << 64 | 0x00000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x8000000000000001uLL << 64 | 0x0000000100000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x8000000000000001uLL << 64 | 0x0000000100000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x8000000000000001uLL << 64 | 0x0000000180000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x8000000000000001uLL << 64 | 0x00000001FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x8000000000000001uLL << 64 | 0x8000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x8000000000000001uLL << 64 | 0x8000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x8000000000000001uLL << 64 | 0x8000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x8000000000000001uLL << 64 | 0x80000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x8000000000000001uLL << 64 | 0xFFFFFFFF00000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x8000000000000001uLL << 64 | 0xFFFFFFFF00000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x8000000000000001uLL << 64 | 0xFFFFFFFF80000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x8000000000000001uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x8000000080000000uLL << 64 | 0x0000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x8000000080000000uLL << 64 | 0x0000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x8000000080000000uLL << 64 | 0x0000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x8000000080000000uLL << 64 | 0x00000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x8000000080000000uLL << 64 | 0x0000000100000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x8000000080000000uLL << 64 | 0x0000000100000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x8000000080000000uLL << 64 | 0x0000000180000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x8000000080000000uLL << 64 | 0x00000001FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x8000000080000000uLL << 64 | 0x8000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x8000000080000000uLL << 64 | 0x8000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x8000000080000000uLL << 64 | 0x8000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x8000000080000000uLL << 64 | 0x80000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x8000000080000000uLL << 64 | 0xFFFFFFFF00000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x8000000080000000uLL << 64 | 0xFFFFFFFF00000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x8000000080000000uLL << 64 | 0xFFFFFFFF80000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x8000000080000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x80000000FFFFFFFFuLL << 64 | 0x0000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x80000000FFFFFFFFuLL << 64 | 0x0000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x80000000FFFFFFFFuLL << 64 | 0x0000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x80000000FFFFFFFFuLL << 64 | 0x00000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x80000000FFFFFFFFuLL << 64 | 0x0000000100000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x80000000FFFFFFFFuLL << 64 | 0x0000000100000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x80000000FFFFFFFFuLL << 64 | 0x0000000180000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x80000000FFFFFFFFuLL << 64 | 0x00000001FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x80000000FFFFFFFFuLL << 64 | 0x8000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x80000000FFFFFFFFuLL << 64 | 0x8000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x80000000FFFFFFFFuLL << 64 | 0x8000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x80000000FFFFFFFFuLL << 64 | 0x80000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x80000000FFFFFFFFuLL << 64 | 0xFFFFFFFF00000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x80000000FFFFFFFFuLL << 64 | 0xFFFFFFFF00000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x80000000FFFFFFFFuLL << 64 | 0xFFFFFFFF80000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x80000000FFFFFFFFuLL << 64 | 0xFFFFFFFFFFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0xFFFFFFFF00000000uLL << 64 | 0x0000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0xFFFFFFFF00000000uLL << 64 | 0x0000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0xFFFFFFFF00000000uLL << 64 | 0x0000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0xFFFFFFFF00000000uLL << 64 | 0x00000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0xFFFFFFFF00000000uLL << 64 | 0x0000000100000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0xFFFFFFFF00000000uLL << 64 | 0x0000000100000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0xFFFFFFFF00000000uLL << 64 | 0x0000000180000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0xFFFFFFFF00000000uLL << 64 | 0x00000001FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0xFFFFFFFF00000000uLL << 64 | 0x8000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0xFFFFFFFF00000000uLL << 64 | 0x8000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0xFFFFFFFF00000000uLL << 64 | 0x8000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0xFFFFFFFF00000000uLL << 64 | 0x80000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0xFFFFFFFF00000000uLL << 64 | 0xFFFFFFFF00000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0xFFFFFFFF00000000uLL << 64 | 0xFFFFFFFF00000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0xFFFFFFFF00000000uLL << 64 | 0xFFFFFFFF80000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0xFFFFFFFF00000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0xFFFFFFFF00000001uLL << 64 | 0x0000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0xFFFFFFFF00000001uLL << 64 | 0x0000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0xFFFFFFFF00000001uLL << 64 | 0x0000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0xFFFFFFFF00000001uLL << 64 | 0x00000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0xFFFFFFFF00000001uLL << 64 | 0x0000000100000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0xFFFFFFFF00000001uLL << 64 | 0x0000000100000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0xFFFFFFFF00000001uLL << 64 | 0x0000000180000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0xFFFFFFFF00000001uLL << 64 | 0x00000001FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0xFFFFFFFF00000001uLL << 64 | 0x8000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0xFFFFFFFF00000001uLL << 64 | 0x8000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0xFFFFFFFF00000001uLL << 64 | 0x8000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0xFFFFFFFF00000001uLL << 64 | 0x80000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0xFFFFFFFF00000001uLL << 64 | 0xFFFFFFFF00000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0xFFFFFFFF00000001uLL << 64 | 0xFFFFFFFF00000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0xFFFFFFFF00000001uLL << 64 | 0xFFFFFFFF80000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0xFFFFFFFF00000001uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0xFFFFFFFF80000000uLL << 64 | 0x0000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0xFFFFFFFF80000000uLL << 64 | 0x0000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0xFFFFFFFF80000000uLL << 64 | 0x0000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0xFFFFFFFF80000000uLL << 64 | 0x00000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0xFFFFFFFF80000000uLL << 64 | 0x0000000100000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0xFFFFFFFF80000000uLL << 64 | 0x0000000100000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0xFFFFFFFF80000000uLL << 64 | 0x0000000180000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0xFFFFFFFF80000000uLL << 64 | 0x00000001FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0xFFFFFFFF80000000uLL << 64 | 0x8000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0xFFFFFFFF80000000uLL << 64 | 0x8000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0xFFFFFFFF80000000uLL << 64 | 0x8000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0xFFFFFFFF80000000uLL << 64 | 0x80000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0xFFFFFFFF80000000uLL << 64 | 0xFFFFFFFF00000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0xFFFFFFFF80000000uLL << 64 | 0xFFFFFFFF00000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0xFFFFFFFF80000000uLL << 64 | 0xFFFFFFFF80000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0xFFFFFFFF80000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0xFFFFFFFFFFFFFFFFuLL << 64 | 0x0000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0xFFFFFFFFFFFFFFFFuLL << 64 | 0x0000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0xFFFFFFFFFFFFFFFFuLL << 64 | 0x0000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0xFFFFFFFFFFFFFFFFuLL << 64 | 0x00000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0xFFFFFFFFFFFFFFFFuLL << 64 | 0x0000000100000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0xFFFFFFFFFFFFFFFFuLL << 64 | 0x0000000100000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0xFFFFFFFFFFFFFFFFuLL << 64 | 0x0000000180000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0xFFFFFFFFFFFFFFFFuLL << 64 | 0x00000001FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0xFFFFFFFFFFFFFFFFuLL << 64 | 0x8000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0xFFFFFFFFFFFFFFFFuLL << 64 | 0x8000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0xFFFFFFFFFFFFFFFFuLL << 64 | 0x8000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0xFFFFFFFFFFFFFFFFuLL << 64 | 0x80000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0xFFFFFFFFFFFFFFFFuLL << 64 | 0xFFFFFFFF00000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0xFFFFFFFFFFFFFFFFuLL << 64 | 0xFFFFFFFF00000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0xFFFFFFFFFFFFFFFFuLL << 64 | 0xFFFFFFFF80000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0xFFFFFFFFFFFFFFFFuLL << 64 | 0xFFFFFFFFFFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL, (tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL, (tu_int)0x0000000000000001uLL << 64 | 0x0000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL, (tu_int)0x0000000000000001uLL << 64 | 0x0000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL, (tu_int)0x0000000000000001uLL << 64 | 0x0000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL, (tu_int)0x0000000000000001uLL << 64 | 0x00000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL, (tu_int)0x0000000000000001uLL << 64 | 0x0000000100000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL, (tu_int)0x0000000000000001uLL << 64 | 0x0000000100000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL, (tu_int)0x0000000000000001uLL << 64 | 0x0000000180000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL, (tu_int)0x0000000000000001uLL << 64 | 0x00000001FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL, (tu_int)0x0000000000000001uLL << 64 | 0x8000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL, (tu_int)0x0000000000000001uLL << 64 | 0x8000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL, (tu_int)0x0000000000000001uLL << 64 | 0x8000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL, (tu_int)0x0000000000000001uLL << 64 | 0x80000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL, (tu_int)0x0000000000000001uLL << 64 | 0xFFFFFFFF00000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL, (tu_int)0x0000000000000001uLL << 64 | 0xFFFFFFFF00000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL, (tu_int)0x0000000000000001uLL << 64 | 0xFFFFFFFF80000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL, (tu_int)0x0000000000000001uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL, (tu_int)0x0000000080000000uLL << 64 | 0x0000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL, (tu_int)0x0000000080000000uLL << 64 | 0x0000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL, (tu_int)0x0000000080000000uLL << 64 | 0x0000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL, (tu_int)0x0000000080000000uLL << 64 | 0x00000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL, (tu_int)0x0000000080000000uLL << 64 | 0x0000000100000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL, (tu_int)0x0000000080000000uLL << 64 | 0x0000000100000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL, (tu_int)0x0000000080000000uLL << 64 | 0x0000000180000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL, (tu_int)0x0000000080000000uLL << 64 | 0x00000001FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL, (tu_int)0x0000000080000000uLL << 64 | 0x8000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL, (tu_int)0x0000000080000000uLL << 64 | 0x8000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL, (tu_int)0x0000000080000000uLL << 64 | 0x8000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL, (tu_int)0x0000000080000000uLL << 64 | 0x80000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL, (tu_int)0x0000000080000000uLL << 64 | 0xFFFFFFFF00000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL, (tu_int)0x0000000080000000uLL << 64 | 0xFFFFFFFF00000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL, (tu_int)0x0000000080000000uLL << 64 | 0xFFFFFFFF80000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL, (tu_int)0x0000000080000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL, (tu_int)0x00000000FFFFFFFFuLL << 64 | 0x0000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL, (tu_int)0x00000000FFFFFFFFuLL << 64 | 0x0000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL, (tu_int)0x00000000FFFFFFFFuLL << 64 | 0x0000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL, (tu_int)0x00000000FFFFFFFFuLL << 64 | 0x00000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL, (tu_int)0x00000000FFFFFFFFuLL << 64 | 0x0000000100000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL, (tu_int)0x00000000FFFFFFFFuLL << 64 | 0x0000000100000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL, (tu_int)0x00000000FFFFFFFFuLL << 64 | 0x0000000180000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL, (tu_int)0x00000000FFFFFFFFuLL << 64 | 0x00000001FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL, (tu_int)0x00000000FFFFFFFFuLL << 64 | 0x8000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL, (tu_int)0x00000000FFFFFFFFuLL << 64 | 0x8000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL, (tu_int)0x00000000FFFFFFFFuLL << 64 | 0x8000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL, (tu_int)0x00000000FFFFFFFFuLL << 64 | 0x80000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL, (tu_int)0x00000000FFFFFFFFuLL << 64 | 0xFFFFFFFF00000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL, (tu_int)0x00000000FFFFFFFFuLL << 64 | 0xFFFFFFFF00000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL, (tu_int)0x00000000FFFFFFFFuLL << 64 | 0xFFFFFFFF80000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL, (tu_int)0x00000000FFFFFFFFuLL << 64 | 0xFFFFFFFFFFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL, (tu_int)0x0000000100000000uLL << 64 | 0x0000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL, (tu_int)0x0000000100000000uLL << 64 | 0x0000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL, (tu_int)0x0000000100000000uLL << 64 | 0x0000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL, (tu_int)0x0000000100000000uLL << 64 | 0x00000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL, (tu_int)0x0000000100000000uLL << 64 | 0x0000000100000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL, (tu_int)0x0000000100000000uLL << 64 | 0x0000000100000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL, (tu_int)0x0000000100000000uLL << 64 | 0x0000000180000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL, (tu_int)0x0000000100000000uLL << 64 | 0x00000001FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL, (tu_int)0x0000000100000000uLL << 64 | 0x8000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL, (tu_int)0x0000000100000000uLL << 64 | 0x8000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL, (tu_int)0x0000000100000000uLL << 64 | 0x8000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL, (tu_int)0x0000000100000000uLL << 64 | 0x80000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL, (tu_int)0x0000000100000000uLL << 64 | 0xFFFFFFFF00000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL, (tu_int)0x0000000100000000uLL << 64 | 0xFFFFFFFF00000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL, (tu_int)0x0000000100000000uLL << 64 | 0xFFFFFFFF80000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL, (tu_int)0x0000000100000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL, (tu_int)0x0000000100000001uLL << 64 | 0x0000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL, (tu_int)0x0000000100000001uLL << 64 | 0x0000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL, (tu_int)0x0000000100000001uLL << 64 | 0x0000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL, (tu_int)0x0000000100000001uLL << 64 | 0x00000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL, (tu_int)0x0000000100000001uLL << 64 | 0x0000000100000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL, (tu_int)0x0000000100000001uLL << 64 | 0x0000000100000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL, (tu_int)0x0000000100000001uLL << 64 | 0x0000000180000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL, (tu_int)0x0000000100000001uLL << 64 | 0x00000001FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL, (tu_int)0x0000000100000001uLL << 64 | 0x8000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL, (tu_int)0x0000000100000001uLL << 64 | 0x8000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL, (tu_int)0x0000000100000001uLL << 64 | 0x8000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL, (tu_int)0x0000000100000001uLL << 64 | 0x80000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL, (tu_int)0x0000000100000001uLL << 64 | 0xFFFFFFFF00000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL, (tu_int)0x0000000100000001uLL << 64 | 0xFFFFFFFF00000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL, (tu_int)0x0000000100000001uLL << 64 | 0xFFFFFFFF80000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL, (tu_int)0x0000000100000001uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL, (tu_int)0x0000000180000000uLL << 64 | 0x0000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL, (tu_int)0x0000000180000000uLL << 64 | 0x0000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL, (tu_int)0x0000000180000000uLL << 64 | 0x0000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL, (tu_int)0x0000000180000000uLL << 64 | 0x00000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL, (tu_int)0x0000000180000000uLL << 64 | 0x0000000100000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL, (tu_int)0x0000000180000000uLL << 64 | 0x0000000100000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL, (tu_int)0x0000000180000000uLL << 64 | 0x0000000180000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL, (tu_int)0x0000000180000000uLL << 64 | 0x00000001FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL, (tu_int)0x0000000180000000uLL << 64 | 0x8000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL, (tu_int)0x0000000180000000uLL << 64 | 0x8000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL, (tu_int)0x0000000180000000uLL << 64 | 0x8000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL, (tu_int)0x0000000180000000uLL << 64 | 0x80000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL, (tu_int)0x0000000180000000uLL << 64 | 0xFFFFFFFF00000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL, (tu_int)0x0000000180000000uLL << 64 | 0xFFFFFFFF00000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL, (tu_int)0x0000000180000000uLL << 64 | 0xFFFFFFFF80000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL, (tu_int)0x0000000180000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL, (tu_int)0x00000001FFFFFFFFuLL << 64 | 0x0000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL, (tu_int)0x00000001FFFFFFFFuLL << 64 | 0x0000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL, (tu_int)0x00000001FFFFFFFFuLL << 64 | 0x0000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL, (tu_int)0x00000001FFFFFFFFuLL << 64 | 0x00000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL, (tu_int)0x00000001FFFFFFFFuLL << 64 | 0x0000000100000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL, (tu_int)0x00000001FFFFFFFFuLL << 64 | 0x0000000100000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL, (tu_int)0x00000001FFFFFFFFuLL << 64 | 0x0000000180000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL, (tu_int)0x00000001FFFFFFFFuLL << 64 | 0x00000001FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL, (tu_int)0x00000001FFFFFFFFuLL << 64 | 0x8000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL, (tu_int)0x00000001FFFFFFFFuLL << 64 | 0x8000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL, (tu_int)0x00000001FFFFFFFFuLL << 64 | 0x8000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL, (tu_int)0x00000001FFFFFFFFuLL << 64 | 0x80000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL, (tu_int)0x00000001FFFFFFFFuLL << 64 | 0xFFFFFFFF00000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL, (tu_int)0x00000001FFFFFFFFuLL << 64 | 0xFFFFFFFF00000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL, (tu_int)0x00000001FFFFFFFFuLL << 64 | 0xFFFFFFFF80000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL, (tu_int)0x00000001FFFFFFFFuLL << 64 | 0xFFFFFFFFFFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL, (tu_int)0x8000000000000000uLL << 64 | 0x0000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL, (tu_int)0x8000000000000000uLL << 64 | 0x0000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL, (tu_int)0x8000000000000000uLL << 64 | 0x0000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL, (tu_int)0x8000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL, (tu_int)0x8000000000000000uLL << 64 | 0x0000000100000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL, (tu_int)0x8000000000000000uLL << 64 | 0x0000000100000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL, (tu_int)0x8000000000000000uLL << 64 | 0x0000000180000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL, (tu_int)0x8000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL, (tu_int)0x8000000000000000uLL << 64 | 0x8000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL, (tu_int)0x8000000000000000uLL << 64 | 0x8000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL, (tu_int)0x8000000000000000uLL << 64 | 0x8000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL, (tu_int)0x8000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL, (tu_int)0x8000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL, (tu_int)0x8000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL, (tu_int)0x8000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL, (tu_int)0x8000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL, (tu_int)0x8000000000000001uLL << 64 | 0x0000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL, (tu_int)0x8000000000000001uLL << 64 | 0x0000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL, (tu_int)0x8000000000000001uLL << 64 | 0x0000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL, (tu_int)0x8000000000000001uLL << 64 | 0x00000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL, (tu_int)0x8000000000000001uLL << 64 | 0x0000000100000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL, (tu_int)0x8000000000000001uLL << 64 | 0x0000000100000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL, (tu_int)0x8000000000000001uLL << 64 | 0x0000000180000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL, (tu_int)0x8000000000000001uLL << 64 | 0x00000001FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL, (tu_int)0x8000000000000001uLL << 64 | 0x8000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL, (tu_int)0x8000000000000001uLL << 64 | 0x8000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL, (tu_int)0x8000000000000001uLL << 64 | 0x8000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL, (tu_int)0x8000000000000001uLL << 64 | 0x80000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL, (tu_int)0x8000000000000001uLL << 64 | 0xFFFFFFFF00000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL, (tu_int)0x8000000000000001uLL << 64 | 0xFFFFFFFF00000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL, (tu_int)0x8000000000000001uLL << 64 | 0xFFFFFFFF80000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL, (tu_int)0x8000000000000001uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL, (tu_int)0x8000000080000000uLL << 64 | 0x0000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL, (tu_int)0x8000000080000000uLL << 64 | 0x0000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL, (tu_int)0x8000000080000000uLL << 64 | 0x0000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL, (tu_int)0x8000000080000000uLL << 64 | 0x00000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL, (tu_int)0x8000000080000000uLL << 64 | 0x0000000100000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL, (tu_int)0x8000000080000000uLL << 64 | 0x0000000100000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL, (tu_int)0x8000000080000000uLL << 64 | 0x0000000180000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL, (tu_int)0x8000000080000000uLL << 64 | 0x00000001FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL, (tu_int)0x8000000080000000uLL << 64 | 0x8000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL, (tu_int)0x8000000080000000uLL << 64 | 0x8000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL, (tu_int)0x8000000080000000uLL << 64 | 0x8000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL, (tu_int)0x8000000080000000uLL << 64 | 0x80000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL, (tu_int)0x8000000080000000uLL << 64 | 0xFFFFFFFF00000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL, (tu_int)0x8000000080000000uLL << 64 | 0xFFFFFFFF00000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL, (tu_int)0x8000000080000000uLL << 64 | 0xFFFFFFFF80000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL, (tu_int)0x8000000080000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL, (tu_int)0x80000000FFFFFFFFuLL << 64 | 0x0000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL, (tu_int)0x80000000FFFFFFFFuLL << 64 | 0x0000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL, (tu_int)0x80000000FFFFFFFFuLL << 64 | 0x0000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL, (tu_int)0x80000000FFFFFFFFuLL << 64 | 0x00000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL, (tu_int)0x80000000FFFFFFFFuLL << 64 | 0x0000000100000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL, (tu_int)0x80000000FFFFFFFFuLL << 64 | 0x0000000100000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL, (tu_int)0x80000000FFFFFFFFuLL << 64 | 0x0000000180000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL, (tu_int)0x80000000FFFFFFFFuLL << 64 | 0x00000001FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL, (tu_int)0x80000000FFFFFFFFuLL << 64 | 0x8000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL, (tu_int)0x80000000FFFFFFFFuLL << 64 | 0x8000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL, (tu_int)0x80000000FFFFFFFFuLL << 64 | 0x8000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL, (tu_int)0x80000000FFFFFFFFuLL << 64 | 0x80000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL, (tu_int)0x80000000FFFFFFFFuLL << 64 | 0xFFFFFFFF00000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL, (tu_int)0x80000000FFFFFFFFuLL << 64 | 0xFFFFFFFF00000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL, (tu_int)0x80000000FFFFFFFFuLL << 64 | 0xFFFFFFFF80000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL, (tu_int)0x80000000FFFFFFFFuLL << 64 | 0xFFFFFFFFFFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL, (tu_int)0xFFFFFFFF00000000uLL << 64 | 0x0000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL, (tu_int)0xFFFFFFFF00000000uLL << 64 | 0x0000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL, (tu_int)0xFFFFFFFF00000000uLL << 64 | 0x0000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL, (tu_int)0xFFFFFFFF00000000uLL << 64 | 0x00000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL, (tu_int)0xFFFFFFFF00000000uLL << 64 | 0x0000000100000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL, (tu_int)0xFFFFFFFF00000000uLL << 64 | 0x0000000100000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL, (tu_int)0xFFFFFFFF00000000uLL << 64 | 0x0000000180000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL, (tu_int)0xFFFFFFFF00000000uLL << 64 | 0x00000001FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL, (tu_int)0xFFFFFFFF00000000uLL << 64 | 0x8000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL, (tu_int)0xFFFFFFFF00000000uLL << 64 | 0x8000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL, (tu_int)0xFFFFFFFF00000000uLL << 64 | 0x8000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL, (tu_int)0xFFFFFFFF00000000uLL << 64 | 0x80000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL, (tu_int)0xFFFFFFFF00000000uLL << 64 | 0xFFFFFFFF00000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL, (tu_int)0xFFFFFFFF00000000uLL << 64 | 0xFFFFFFFF00000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL, (tu_int)0xFFFFFFFF00000000uLL << 64 | 0xFFFFFFFF80000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL, (tu_int)0xFFFFFFFF00000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL, (tu_int)0xFFFFFFFF00000001uLL << 64 | 0x0000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL, (tu_int)0xFFFFFFFF00000001uLL << 64 | 0x0000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL, (tu_int)0xFFFFFFFF00000001uLL << 64 | 0x0000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL, (tu_int)0xFFFFFFFF00000001uLL << 64 | 0x00000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL, (tu_int)0xFFFFFFFF00000001uLL << 64 | 0x0000000100000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL, (tu_int)0xFFFFFFFF00000001uLL << 64 | 0x0000000100000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL, (tu_int)0xFFFFFFFF00000001uLL << 64 | 0x0000000180000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL, (tu_int)0xFFFFFFFF00000001uLL << 64 | 0x00000001FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL, (tu_int)0xFFFFFFFF00000001uLL << 64 | 0x8000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL, (tu_int)0xFFFFFFFF00000001uLL << 64 | 0x8000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL, (tu_int)0xFFFFFFFF00000001uLL << 64 | 0x8000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL, (tu_int)0xFFFFFFFF00000001uLL << 64 | 0x80000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL, (tu_int)0xFFFFFFFF00000001uLL << 64 | 0xFFFFFFFF00000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL, (tu_int)0xFFFFFFFF00000001uLL << 64 | 0xFFFFFFFF00000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL, (tu_int)0xFFFFFFFF00000001uLL << 64 | 0xFFFFFFFF80000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL, (tu_int)0xFFFFFFFF00000001uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL, (tu_int)0xFFFFFFFF80000000uLL << 64 | 0x0000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL, (tu_int)0xFFFFFFFF80000000uLL << 64 | 0x0000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL, (tu_int)0xFFFFFFFF80000000uLL << 64 | 0x0000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL, (tu_int)0xFFFFFFFF80000000uLL << 64 | 0x00000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL, (tu_int)0xFFFFFFFF80000000uLL << 64 | 0x0000000100000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL, (tu_int)0xFFFFFFFF80000000uLL << 64 | 0x0000000100000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL, (tu_int)0xFFFFFFFF80000000uLL << 64 | 0x0000000180000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL, (tu_int)0xFFFFFFFF80000000uLL << 64 | 0x00000001FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL, (tu_int)0xFFFFFFFF80000000uLL << 64 | 0x8000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL, (tu_int)0xFFFFFFFF80000000uLL << 64 | 0x8000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL, (tu_int)0xFFFFFFFF80000000uLL << 64 | 0x8000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL, (tu_int)0xFFFFFFFF80000000uLL << 64 | 0x80000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL, (tu_int)0xFFFFFFFF80000000uLL << 64 | 0xFFFFFFFF00000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL, (tu_int)0xFFFFFFFF80000000uLL << 64 | 0xFFFFFFFF00000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL, (tu_int)0xFFFFFFFF80000000uLL << 64 | 0xFFFFFFFF80000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL, (tu_int)0xFFFFFFFF80000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL, (tu_int)0xFFFFFFFFFFFFFFFFuLL << 64 | 0x0000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL, (tu_int)0xFFFFFFFFFFFFFFFFuLL << 64 | 0x0000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL, (tu_int)0xFFFFFFFFFFFFFFFFuLL << 64 | 0x0000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL, (tu_int)0xFFFFFFFFFFFFFFFFuLL << 64 | 0x00000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL, (tu_int)0xFFFFFFFFFFFFFFFFuLL << 64 | 0x0000000100000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL, (tu_int)0xFFFFFFFFFFFFFFFFuLL << 64 | 0x0000000100000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL, (tu_int)0xFFFFFFFFFFFFFFFFuLL << 64 | 0x0000000180000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL, (tu_int)0xFFFFFFFFFFFFFFFFuLL << 64 | 0x00000001FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL, (tu_int)0xFFFFFFFFFFFFFFFFuLL << 64 | 0x8000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL, (tu_int)0xFFFFFFFFFFFFFFFFuLL << 64 | 0x8000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL, (tu_int)0xFFFFFFFFFFFFFFFFuLL << 64 | 0x8000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL, (tu_int)0xFFFFFFFFFFFFFFFFuLL << 64 | 0x80000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL, (tu_int)0xFFFFFFFFFFFFFFFFuLL << 64 | 0xFFFFFFFF00000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL, (tu_int)0xFFFFFFFFFFFFFFFFuLL << 64 | 0xFFFFFFFF00000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL, (tu_int)0xFFFFFFFFFFFFFFFFuLL << 64 | 0xFFFFFFFF80000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL, (tu_int)0xFFFFFFFFFFFFFFFFuLL << 64 | 0xFFFFFFFFFFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL, (tu_int)0x0000000000000001uLL << 64 | 0x0000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL, (tu_int)0x0000000000000001uLL << 64 | 0x0000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL, (tu_int)0x0000000000000001uLL << 64 | 0x0000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL, (tu_int)0x0000000000000001uLL << 64 | 0x00000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL, (tu_int)0x0000000000000001uLL << 64 | 0x0000000100000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL, (tu_int)0x0000000000000001uLL << 64 | 0x0000000100000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL, (tu_int)0x0000000000000001uLL << 64 | 0x0000000180000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL, (tu_int)0x0000000000000001uLL << 64 | 0x00000001FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL, (tu_int)0x0000000000000001uLL << 64 | 0x8000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL, (tu_int)0x0000000000000001uLL << 64 | 0x8000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL, (tu_int)0x0000000000000001uLL << 64 | 0x8000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL, (tu_int)0x0000000000000001uLL << 64 | 0x80000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL, (tu_int)0x0000000000000001uLL << 64 | 0xFFFFFFFF00000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL, (tu_int)0x0000000000000001uLL << 64 | 0xFFFFFFFF00000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL, (tu_int)0x0000000000000001uLL << 64 | 0xFFFFFFFF80000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL, (tu_int)0x0000000000000001uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL, (tu_int)0x0000000080000000uLL << 64 | 0x0000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL, (tu_int)0x0000000080000000uLL << 64 | 0x0000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL, (tu_int)0x0000000080000000uLL << 64 | 0x0000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL, (tu_int)0x0000000080000000uLL << 64 | 0x00000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL, (tu_int)0x0000000080000000uLL << 64 | 0x0000000100000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL, (tu_int)0x0000000080000000uLL << 64 | 0x0000000100000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL, (tu_int)0x0000000080000000uLL << 64 | 0x0000000180000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL, (tu_int)0x0000000080000000uLL << 64 | 0x00000001FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL, (tu_int)0x0000000080000000uLL << 64 | 0x8000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL, (tu_int)0x0000000080000000uLL << 64 | 0x8000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL, (tu_int)0x0000000080000000uLL << 64 | 0x8000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL, (tu_int)0x0000000080000000uLL << 64 | 0x80000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL, (tu_int)0x0000000080000000uLL << 64 | 0xFFFFFFFF00000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL, (tu_int)0x0000000080000000uLL << 64 | 0xFFFFFFFF00000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL, (tu_int)0x0000000080000000uLL << 64 | 0xFFFFFFFF80000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL, (tu_int)0x0000000080000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL, (tu_int)0x00000000FFFFFFFFuLL << 64 | 0x0000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL, (tu_int)0x00000000FFFFFFFFuLL << 64 | 0x0000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL, (tu_int)0x00000000FFFFFFFFuLL << 64 | 0x0000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL, (tu_int)0x00000000FFFFFFFFuLL << 64 | 0x00000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL, (tu_int)0x00000000FFFFFFFFuLL << 64 | 0x0000000100000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL, (tu_int)0x00000000FFFFFFFFuLL << 64 | 0x0000000100000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL, (tu_int)0x00000000FFFFFFFFuLL << 64 | 0x0000000180000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL, (tu_int)0x00000000FFFFFFFFuLL << 64 | 0x00000001FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL, (tu_int)0x00000000FFFFFFFFuLL << 64 | 0x8000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL, (tu_int)0x00000000FFFFFFFFuLL << 64 | 0x8000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL, (tu_int)0x00000000FFFFFFFFuLL << 64 | 0x8000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL, (tu_int)0x00000000FFFFFFFFuLL << 64 | 0x80000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL, (tu_int)0x00000000FFFFFFFFuLL << 64 | 0xFFFFFFFF00000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL, (tu_int)0x00000000FFFFFFFFuLL << 64 | 0xFFFFFFFF00000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL, (tu_int)0x00000000FFFFFFFFuLL << 64 | 0xFFFFFFFF80000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL, (tu_int)0x00000000FFFFFFFFuLL << 64 | 0xFFFFFFFFFFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL, (tu_int)0x0000000100000000uLL << 64 | 0x0000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL, (tu_int)0x0000000100000000uLL << 64 | 0x0000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL, (tu_int)0x0000000100000000uLL << 64 | 0x0000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL, (tu_int)0x0000000100000000uLL << 64 | 0x00000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL, (tu_int)0x0000000100000000uLL << 64 | 0x0000000100000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL, (tu_int)0x0000000100000000uLL << 64 | 0x0000000100000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL, (tu_int)0x0000000100000000uLL << 64 | 0x0000000180000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL, (tu_int)0x0000000100000000uLL << 64 | 0x00000001FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL, (tu_int)0x0000000100000000uLL << 64 | 0x8000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL, (tu_int)0x0000000100000000uLL << 64 | 0x8000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL, (tu_int)0x0000000100000000uLL << 64 | 0x8000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL, (tu_int)0x0000000100000000uLL << 64 | 0x80000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL, (tu_int)0x0000000100000000uLL << 64 | 0xFFFFFFFF00000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL, (tu_int)0x0000000100000000uLL << 64 | 0xFFFFFFFF00000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL, (tu_int)0x0000000100000000uLL << 64 | 0xFFFFFFFF80000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL, (tu_int)0x0000000100000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL, (tu_int)0x0000000100000001uLL << 64 | 0x0000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL, (tu_int)0x0000000100000001uLL << 64 | 0x0000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL, (tu_int)0x0000000100000001uLL << 64 | 0x0000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL, (tu_int)0x0000000100000001uLL << 64 | 0x00000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL, (tu_int)0x0000000100000001uLL << 64 | 0x0000000100000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL, (tu_int)0x0000000100000001uLL << 64 | 0x0000000100000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL, (tu_int)0x0000000100000001uLL << 64 | 0x0000000180000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL, (tu_int)0x0000000100000001uLL << 64 | 0x00000001FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL, (tu_int)0x0000000100000001uLL << 64 | 0x8000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL, (tu_int)0x0000000100000001uLL << 64 | 0x8000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL, (tu_int)0x0000000100000001uLL << 64 | 0x8000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL, (tu_int)0x0000000100000001uLL << 64 | 0x80000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL, (tu_int)0x0000000100000001uLL << 64 | 0xFFFFFFFF00000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL, (tu_int)0x0000000100000001uLL << 64 | 0xFFFFFFFF00000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL, (tu_int)0x0000000100000001uLL << 64 | 0xFFFFFFFF80000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL, (tu_int)0x0000000100000001uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL, (tu_int)0x0000000180000000uLL << 64 | 0x0000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL, (tu_int)0x0000000180000000uLL << 64 | 0x0000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL, (tu_int)0x0000000180000000uLL << 64 | 0x0000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL, (tu_int)0x0000000180000000uLL << 64 | 0x00000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL, (tu_int)0x0000000180000000uLL << 64 | 0x0000000100000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL, (tu_int)0x0000000180000000uLL << 64 | 0x0000000100000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL, (tu_int)0x0000000180000000uLL << 64 | 0x0000000180000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL, (tu_int)0x0000000180000000uLL << 64 | 0x00000001FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL, (tu_int)0x0000000180000000uLL << 64 | 0x8000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL, (tu_int)0x0000000180000000uLL << 64 | 0x8000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL, (tu_int)0x0000000180000000uLL << 64 | 0x8000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL, (tu_int)0x0000000180000000uLL << 64 | 0x80000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL, (tu_int)0x0000000180000000uLL << 64 | 0xFFFFFFFF00000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL, (tu_int)0x0000000180000000uLL << 64 | 0xFFFFFFFF00000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL, (tu_int)0x0000000180000000uLL << 64 | 0xFFFFFFFF80000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL, (tu_int)0x0000000180000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL, (tu_int)0x00000001FFFFFFFFuLL << 64 | 0x0000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL, (tu_int)0x00000001FFFFFFFFuLL << 64 | 0x0000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL, (tu_int)0x00000001FFFFFFFFuLL << 64 | 0x0000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL, (tu_int)0x00000001FFFFFFFFuLL << 64 | 0x00000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL, (tu_int)0x00000001FFFFFFFFuLL << 64 | 0x0000000100000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL, (tu_int)0x00000001FFFFFFFFuLL << 64 | 0x0000000100000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL, (tu_int)0x00000001FFFFFFFFuLL << 64 | 0x0000000180000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL, (tu_int)0x00000001FFFFFFFFuLL << 64 | 0x00000001FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL, (tu_int)0x00000001FFFFFFFFuLL << 64 | 0x8000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL, (tu_int)0x00000001FFFFFFFFuLL << 64 | 0x8000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL, (tu_int)0x00000001FFFFFFFFuLL << 64 | 0x8000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL, (tu_int)0x00000001FFFFFFFFuLL << 64 | 0x80000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL, (tu_int)0x00000001FFFFFFFFuLL << 64 | 0xFFFFFFFF00000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL, (tu_int)0x00000001FFFFFFFFuLL << 64 | 0xFFFFFFFF00000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL, (tu_int)0x00000001FFFFFFFFuLL << 64 | 0xFFFFFFFF80000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL, (tu_int)0x00000001FFFFFFFFuLL << 64 | 0xFFFFFFFFFFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL, (tu_int)0x8000000000000000uLL << 64 | 0x0000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL, (tu_int)0x8000000000000000uLL << 64 | 0x0000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL, (tu_int)0x8000000000000000uLL << 64 | 0x0000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL, (tu_int)0x8000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL, (tu_int)0x8000000000000000uLL << 64 | 0x0000000100000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL, (tu_int)0x8000000000000000uLL << 64 | 0x0000000100000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL, (tu_int)0x8000000000000000uLL << 64 | 0x0000000180000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL, (tu_int)0x8000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL, (tu_int)0x8000000000000000uLL << 64 | 0x8000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL, (tu_int)0x8000000000000000uLL << 64 | 0x8000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL, (tu_int)0x8000000000000000uLL << 64 | 0x8000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL, (tu_int)0x8000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL, (tu_int)0x8000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL, (tu_int)0x8000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL, (tu_int)0x8000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL, (tu_int)0x8000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL, (tu_int)0x8000000000000001uLL << 64 | 0x0000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL, (tu_int)0x8000000000000001uLL << 64 | 0x0000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL, (tu_int)0x8000000000000001uLL << 64 | 0x0000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL, (tu_int)0x8000000000000001uLL << 64 | 0x00000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL, (tu_int)0x8000000000000001uLL << 64 | 0x0000000100000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL, (tu_int)0x8000000000000001uLL << 64 | 0x0000000100000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL, (tu_int)0x8000000000000001uLL << 64 | 0x0000000180000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL, (tu_int)0x8000000000000001uLL << 64 | 0x00000001FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL, (tu_int)0x8000000000000001uLL << 64 | 0x8000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL, (tu_int)0x8000000000000001uLL << 64 | 0x8000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL, (tu_int)0x8000000000000001uLL << 64 | 0x8000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL, (tu_int)0x8000000000000001uLL << 64 | 0x80000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL, (tu_int)0x8000000000000001uLL << 64 | 0xFFFFFFFF00000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL, (tu_int)0x8000000000000001uLL << 64 | 0xFFFFFFFF00000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL, (tu_int)0x8000000000000001uLL << 64 | 0xFFFFFFFF80000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL, (tu_int)0x8000000000000001uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL, (tu_int)0x8000000080000000uLL << 64 | 0x0000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL, (tu_int)0x8000000080000000uLL << 64 | 0x0000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL, (tu_int)0x8000000080000000uLL << 64 | 0x0000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL, (tu_int)0x8000000080000000uLL << 64 | 0x00000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL, (tu_int)0x8000000080000000uLL << 64 | 0x0000000100000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL, (tu_int)0x8000000080000000uLL << 64 | 0x0000000100000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL, (tu_int)0x8000000080000000uLL << 64 | 0x0000000180000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL, (tu_int)0x8000000080000000uLL << 64 | 0x00000001FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL, (tu_int)0x8000000080000000uLL << 64 | 0x8000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL, (tu_int)0x8000000080000000uLL << 64 | 0x8000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL, (tu_int)0x8000000080000000uLL << 64 | 0x8000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL, (tu_int)0x8000000080000000uLL << 64 | 0x80000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL, (tu_int)0x8000000080000000uLL << 64 | 0xFFFFFFFF00000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL, (tu_int)0x8000000080000000uLL << 64 | 0xFFFFFFFF00000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL, (tu_int)0x8000000080000000uLL << 64 | 0xFFFFFFFF80000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL, (tu_int)0x8000000080000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL, (tu_int)0x80000000FFFFFFFFuLL << 64 | 0x0000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL, (tu_int)0x80000000FFFFFFFFuLL << 64 | 0x0000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL, (tu_int)0x80000000FFFFFFFFuLL << 64 | 0x0000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL, (tu_int)0x80000000FFFFFFFFuLL << 64 | 0x00000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL, (tu_int)0x80000000FFFFFFFFuLL << 64 | 0x0000000100000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL, (tu_int)0x80000000FFFFFFFFuLL << 64 | 0x0000000100000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL, (tu_int)0x80000000FFFFFFFFuLL << 64 | 0x0000000180000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL, (tu_int)0x80000000FFFFFFFFuLL << 64 | 0x00000001FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL, (tu_int)0x80000000FFFFFFFFuLL << 64 | 0x8000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL, (tu_int)0x80000000FFFFFFFFuLL << 64 | 0x8000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL, (tu_int)0x80000000FFFFFFFFuLL << 64 | 0x8000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL, (tu_int)0x80000000FFFFFFFFuLL << 64 | 0x80000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL, (tu_int)0x80000000FFFFFFFFuLL << 64 | 0xFFFFFFFF00000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL, (tu_int)0x80000000FFFFFFFFuLL << 64 | 0xFFFFFFFF00000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL, (tu_int)0x80000000FFFFFFFFuLL << 64 | 0xFFFFFFFF80000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL, (tu_int)0x80000000FFFFFFFFuLL << 64 | 0xFFFFFFFFFFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL, (tu_int)0xFFFFFFFF00000000uLL << 64 | 0x0000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL, (tu_int)0xFFFFFFFF00000000uLL << 64 | 0x0000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL, (tu_int)0xFFFFFFFF00000000uLL << 64 | 0x0000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL, (tu_int)0xFFFFFFFF00000000uLL << 64 | 0x00000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL, (tu_int)0xFFFFFFFF00000000uLL << 64 | 0x0000000100000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL, (tu_int)0xFFFFFFFF00000000uLL << 64 | 0x0000000100000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL, (tu_int)0xFFFFFFFF00000000uLL << 64 | 0x0000000180000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL, (tu_int)0xFFFFFFFF00000000uLL << 64 | 0x00000001FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL, (tu_int)0xFFFFFFFF00000000uLL << 64 | 0x8000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL, (tu_int)0xFFFFFFFF00000000uLL << 64 | 0x8000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL, (tu_int)0xFFFFFFFF00000000uLL << 64 | 0x8000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL, (tu_int)0xFFFFFFFF00000000uLL << 64 | 0x80000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL, (tu_int)0xFFFFFFFF00000000uLL << 64 | 0xFFFFFFFF00000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL, (tu_int)0xFFFFFFFF00000000uLL << 64 | 0xFFFFFFFF00000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL, (tu_int)0xFFFFFFFF00000000uLL << 64 | 0xFFFFFFFF80000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL, (tu_int)0xFFFFFFFF00000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL, (tu_int)0xFFFFFFFF00000001uLL << 64 | 0x0000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL, (tu_int)0xFFFFFFFF00000001uLL << 64 | 0x0000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL, (tu_int)0xFFFFFFFF00000001uLL << 64 | 0x0000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL, (tu_int)0xFFFFFFFF00000001uLL << 64 | 0x00000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL, (tu_int)0xFFFFFFFF00000001uLL << 64 | 0x0000000100000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL, (tu_int)0xFFFFFFFF00000001uLL << 64 | 0x0000000100000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL, (tu_int)0xFFFFFFFF00000001uLL << 64 | 0x0000000180000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL, (tu_int)0xFFFFFFFF00000001uLL << 64 | 0x00000001FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL, (tu_int)0xFFFFFFFF00000001uLL << 64 | 0x8000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL, (tu_int)0xFFFFFFFF00000001uLL << 64 | 0x8000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL, (tu_int)0xFFFFFFFF00000001uLL << 64 | 0x8000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL, (tu_int)0xFFFFFFFF00000001uLL << 64 | 0x80000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL, (tu_int)0xFFFFFFFF00000001uLL << 64 | 0xFFFFFFFF00000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL, (tu_int)0xFFFFFFFF00000001uLL << 64 | 0xFFFFFFFF00000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL, (tu_int)0xFFFFFFFF00000001uLL << 64 | 0xFFFFFFFF80000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL, (tu_int)0xFFFFFFFF00000001uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL, (tu_int)0xFFFFFFFF80000000uLL << 64 | 0x0000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL, (tu_int)0xFFFFFFFF80000000uLL << 64 | 0x0000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL, (tu_int)0xFFFFFFFF80000000uLL << 64 | 0x0000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL, (tu_int)0xFFFFFFFF80000000uLL << 64 | 0x00000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL, (tu_int)0xFFFFFFFF80000000uLL << 64 | 0x0000000100000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL, (tu_int)0xFFFFFFFF80000000uLL << 64 | 0x0000000100000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL, (tu_int)0xFFFFFFFF80000000uLL << 64 | 0x0000000180000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL, (tu_int)0xFFFFFFFF80000000uLL << 64 | 0x00000001FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL, (tu_int)0xFFFFFFFF80000000uLL << 64 | 0x8000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL, (tu_int)0xFFFFFFFF80000000uLL << 64 | 0x8000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL, (tu_int)0xFFFFFFFF80000000uLL << 64 | 0x8000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL, (tu_int)0xFFFFFFFF80000000uLL << 64 | 0x80000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL, (tu_int)0xFFFFFFFF80000000uLL << 64 | 0xFFFFFFFF00000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL, (tu_int)0xFFFFFFFF80000000uLL << 64 | 0xFFFFFFFF00000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL, (tu_int)0xFFFFFFFF80000000uLL << 64 | 0xFFFFFFFF80000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL, (tu_int)0xFFFFFFFF80000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL, (tu_int)0xFFFFFFFFFFFFFFFFuLL << 64 | 0x0000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL, (tu_int)0xFFFFFFFFFFFFFFFFuLL << 64 | 0x0000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL, (tu_int)0xFFFFFFFFFFFFFFFFuLL << 64 | 0x0000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL, (tu_int)0xFFFFFFFFFFFFFFFFuLL << 64 | 0x00000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL, (tu_int)0xFFFFFFFFFFFFFFFFuLL << 64 | 0x0000000100000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL, (tu_int)0xFFFFFFFFFFFFFFFFuLL << 64 | 0x0000000100000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL, (tu_int)0xFFFFFFFFFFFFFFFFuLL << 64 | 0x0000000180000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL, (tu_int)0xFFFFFFFFFFFFFFFFuLL << 64 | 0x00000001FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL, (tu_int)0xFFFFFFFFFFFFFFFFuLL << 64 | 0x8000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL, (tu_int)0xFFFFFFFFFFFFFFFFuLL << 64 | 0x8000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL, (tu_int)0xFFFFFFFFFFFFFFFFuLL << 64 | 0x8000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL, (tu_int)0xFFFFFFFFFFFFFFFFuLL << 64 | 0x80000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL, (tu_int)0xFFFFFFFFFFFFFFFFuLL << 64 | 0xFFFFFFFF00000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL, (tu_int)0xFFFFFFFFFFFFFFFFuLL << 64 | 0xFFFFFFFF00000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL, (tu_int)0xFFFFFFFFFFFFFFFFuLL << 64 | 0xFFFFFFFF80000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL, (tu_int)0xFFFFFFFFFFFFFFFFuLL << 64 | 0xFFFFFFFFFFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL, (tu_int)0x0000000000000000uLL << 64 | 0x000000007FFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL, (tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL, (tu_int)0x0000000000000001uLL << 64 | 0x0000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL, (tu_int)0x0000000000000001uLL << 64 | 0x0000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL, (tu_int)0x0000000000000001uLL << 64 | 0x0000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL, (tu_int)0x0000000000000001uLL << 64 | 0x00000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL, (tu_int)0x0000000000000001uLL << 64 | 0x0000000100000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL, (tu_int)0x0000000000000001uLL << 64 | 0x0000000100000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL, (tu_int)0x0000000000000001uLL << 64 | 0x0000000180000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL, (tu_int)0x0000000000000001uLL << 64 | 0x00000001FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL, (tu_int)0x0000000000000001uLL << 64 | 0x8000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL, (tu_int)0x0000000000000001uLL << 64 | 0x8000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL, (tu_int)0x0000000000000001uLL << 64 | 0x8000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL, (tu_int)0x0000000000000001uLL << 64 | 0x80000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL, (tu_int)0x0000000000000001uLL << 64 | 0xFFFFFFFF00000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL, (tu_int)0x0000000000000001uLL << 64 | 0xFFFFFFFF00000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL, (tu_int)0x0000000000000001uLL << 64 | 0xFFFFFFFF80000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL, (tu_int)0x0000000000000001uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL, (tu_int)0x0000000080000000uLL << 64 | 0x0000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL, (tu_int)0x0000000080000000uLL << 64 | 0x0000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL, (tu_int)0x0000000080000000uLL << 64 | 0x0000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL, (tu_int)0x0000000080000000uLL << 64 | 0x00000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL, (tu_int)0x0000000080000000uLL << 64 | 0x0000000100000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL, (tu_int)0x0000000080000000uLL << 64 | 0x0000000100000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL, (tu_int)0x0000000080000000uLL << 64 | 0x0000000180000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL, (tu_int)0x0000000080000000uLL << 64 | 0x00000001FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL, (tu_int)0x0000000080000000uLL << 64 | 0x8000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL, (tu_int)0x0000000080000000uLL << 64 | 0x8000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL, (tu_int)0x0000000080000000uLL << 64 | 0x8000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL, (tu_int)0x0000000080000000uLL << 64 | 0x80000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL, (tu_int)0x0000000080000000uLL << 64 | 0xFFFFFFFF00000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL, (tu_int)0x0000000080000000uLL << 64 | 0xFFFFFFFF00000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL, (tu_int)0x0000000080000000uLL << 64 | 0xFFFFFFFF80000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL, (tu_int)0x0000000080000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL, (tu_int)0x00000000FFFFFFFFuLL << 64 | 0x0000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL, (tu_int)0x00000000FFFFFFFFuLL << 64 | 0x0000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL, (tu_int)0x00000000FFFFFFFFuLL << 64 | 0x0000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL, (tu_int)0x00000000FFFFFFFFuLL << 64 | 0x00000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL, (tu_int)0x00000000FFFFFFFFuLL << 64 | 0x0000000100000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL, (tu_int)0x00000000FFFFFFFFuLL << 64 | 0x0000000100000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL, (tu_int)0x00000000FFFFFFFFuLL << 64 | 0x0000000180000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL, (tu_int)0x00000000FFFFFFFFuLL << 64 | 0x00000001FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL, (tu_int)0x00000000FFFFFFFFuLL << 64 | 0x8000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL, (tu_int)0x00000000FFFFFFFFuLL << 64 | 0x8000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL, (tu_int)0x00000000FFFFFFFFuLL << 64 | 0x8000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL, (tu_int)0x00000000FFFFFFFFuLL << 64 | 0x80000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL, (tu_int)0x00000000FFFFFFFFuLL << 64 | 0xFFFFFFFF00000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL, (tu_int)0x00000000FFFFFFFFuLL << 64 | 0xFFFFFFFF00000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL, (tu_int)0x00000000FFFFFFFFuLL << 64 | 0xFFFFFFFF80000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL, (tu_int)0x00000000FFFFFFFFuLL << 64 | 0xFFFFFFFFFFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL, (tu_int)0x0000000100000000uLL << 64 | 0x0000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL, (tu_int)0x0000000100000000uLL << 64 | 0x0000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL, (tu_int)0x0000000100000000uLL << 64 | 0x0000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL, (tu_int)0x0000000100000000uLL << 64 | 0x00000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL, (tu_int)0x0000000100000000uLL << 64 | 0x0000000100000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL, (tu_int)0x0000000100000000uLL << 64 | 0x0000000100000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL, (tu_int)0x0000000100000000uLL << 64 | 0x0000000180000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL, (tu_int)0x0000000100000000uLL << 64 | 0x00000001FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL, (tu_int)0x0000000100000000uLL << 64 | 0x8000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL, (tu_int)0x0000000100000000uLL << 64 | 0x8000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL, (tu_int)0x0000000100000000uLL << 64 | 0x8000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL, (tu_int)0x0000000100000000uLL << 64 | 0x80000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL, (tu_int)0x0000000100000000uLL << 64 | 0xFFFFFFFF00000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL, (tu_int)0x0000000100000000uLL << 64 | 0xFFFFFFFF00000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL, (tu_int)0x0000000100000000uLL << 64 | 0xFFFFFFFF80000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL, (tu_int)0x0000000100000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL, (tu_int)0x0000000100000001uLL << 64 | 0x0000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL, (tu_int)0x0000000100000001uLL << 64 | 0x0000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL, (tu_int)0x0000000100000001uLL << 64 | 0x0000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL, (tu_int)0x0000000100000001uLL << 64 | 0x00000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL, (tu_int)0x0000000100000001uLL << 64 | 0x0000000100000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL, (tu_int)0x0000000100000001uLL << 64 | 0x0000000100000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL, (tu_int)0x0000000100000001uLL << 64 | 0x0000000180000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL, (tu_int)0x0000000100000001uLL << 64 | 0x00000001FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL, (tu_int)0x0000000100000001uLL << 64 | 0x8000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL, (tu_int)0x0000000100000001uLL << 64 | 0x8000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL, (tu_int)0x0000000100000001uLL << 64 | 0x8000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL, (tu_int)0x0000000100000001uLL << 64 | 0x80000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL, (tu_int)0x0000000100000001uLL << 64 | 0xFFFFFFFF00000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL, (tu_int)0x0000000100000001uLL << 64 | 0xFFFFFFFF00000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL, (tu_int)0x0000000100000001uLL << 64 | 0xFFFFFFFF80000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL, (tu_int)0x0000000100000001uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL, (tu_int)0x0000000180000000uLL << 64 | 0x0000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL, (tu_int)0x0000000180000000uLL << 64 | 0x0000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL, (tu_int)0x0000000180000000uLL << 64 | 0x0000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL, (tu_int)0x0000000180000000uLL << 64 | 0x00000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL, (tu_int)0x0000000180000000uLL << 64 | 0x0000000100000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL, (tu_int)0x0000000180000000uLL << 64 | 0x0000000100000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL, (tu_int)0x0000000180000000uLL << 64 | 0x0000000180000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL, (tu_int)0x0000000180000000uLL << 64 | 0x00000001FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL, (tu_int)0x0000000180000000uLL << 64 | 0x8000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL, (tu_int)0x0000000180000000uLL << 64 | 0x8000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL, (tu_int)0x0000000180000000uLL << 64 | 0x8000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL, (tu_int)0x0000000180000000uLL << 64 | 0x80000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL, (tu_int)0x0000000180000000uLL << 64 | 0xFFFFFFFF00000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL, (tu_int)0x0000000180000000uLL << 64 | 0xFFFFFFFF00000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL, (tu_int)0x0000000180000000uLL << 64 | 0xFFFFFFFF80000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL, (tu_int)0x0000000180000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL, (tu_int)0x00000001FFFFFFFFuLL << 64 | 0x0000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL, (tu_int)0x00000001FFFFFFFFuLL << 64 | 0x0000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL, (tu_int)0x00000001FFFFFFFFuLL << 64 | 0x0000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL, (tu_int)0x00000001FFFFFFFFuLL << 64 | 0x00000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL, (tu_int)0x00000001FFFFFFFFuLL << 64 | 0x0000000100000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL, (tu_int)0x00000001FFFFFFFFuLL << 64 | 0x0000000100000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL, (tu_int)0x00000001FFFFFFFFuLL << 64 | 0x0000000180000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL, (tu_int)0x00000001FFFFFFFFuLL << 64 | 0x00000001FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL, (tu_int)0x00000001FFFFFFFFuLL << 64 | 0x8000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL, (tu_int)0x00000001FFFFFFFFuLL << 64 | 0x8000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL, (tu_int)0x00000001FFFFFFFFuLL << 64 | 0x8000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL, (tu_int)0x00000001FFFFFFFFuLL << 64 | 0x80000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL, (tu_int)0x00000001FFFFFFFFuLL << 64 | 0xFFFFFFFF00000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL, (tu_int)0x00000001FFFFFFFFuLL << 64 | 0xFFFFFFFF00000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL, (tu_int)0x00000001FFFFFFFFuLL << 64 | 0xFFFFFFFF80000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL, (tu_int)0x00000001FFFFFFFFuLL << 64 | 0xFFFFFFFFFFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL, (tu_int)0x8000000000000000uLL << 64 | 0x0000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL, (tu_int)0x8000000000000000uLL << 64 | 0x0000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL, (tu_int)0x8000000000000000uLL << 64 | 0x0000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL, (tu_int)0x8000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL, (tu_int)0x8000000000000000uLL << 64 | 0x0000000100000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL, (tu_int)0x8000000000000000uLL << 64 | 0x0000000100000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL, (tu_int)0x8000000000000000uLL << 64 | 0x0000000180000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL, (tu_int)0x8000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL, (tu_int)0x8000000000000000uLL << 64 | 0x8000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL, (tu_int)0x8000000000000000uLL << 64 | 0x8000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL, (tu_int)0x8000000000000000uLL << 64 | 0x8000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL, (tu_int)0x8000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL, (tu_int)0x8000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL, (tu_int)0x8000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL, (tu_int)0x8000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL, (tu_int)0x8000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL, (tu_int)0x8000000000000001uLL << 64 | 0x0000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL, (tu_int)0x8000000000000001uLL << 64 | 0x0000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL, (tu_int)0x8000000000000001uLL << 64 | 0x0000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL, (tu_int)0x8000000000000001uLL << 64 | 0x00000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL, (tu_int)0x8000000000000001uLL << 64 | 0x0000000100000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL, (tu_int)0x8000000000000001uLL << 64 | 0x0000000100000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL, (tu_int)0x8000000000000001uLL << 64 | 0x0000000180000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL, (tu_int)0x8000000000000001uLL << 64 | 0x00000001FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL, (tu_int)0x8000000000000001uLL << 64 | 0x8000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL, (tu_int)0x8000000000000001uLL << 64 | 0x8000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL, (tu_int)0x8000000000000001uLL << 64 | 0x8000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL, (tu_int)0x8000000000000001uLL << 64 | 0x80000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL, (tu_int)0x8000000000000001uLL << 64 | 0xFFFFFFFF00000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL, (tu_int)0x8000000000000001uLL << 64 | 0xFFFFFFFF00000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL, (tu_int)0x8000000000000001uLL << 64 | 0xFFFFFFFF80000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL, (tu_int)0x8000000000000001uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL, (tu_int)0x8000000080000000uLL << 64 | 0x0000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL, (tu_int)0x8000000080000000uLL << 64 | 0x0000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL, (tu_int)0x8000000080000000uLL << 64 | 0x0000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL, (tu_int)0x8000000080000000uLL << 64 | 0x00000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL, (tu_int)0x8000000080000000uLL << 64 | 0x0000000100000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL, (tu_int)0x8000000080000000uLL << 64 | 0x0000000100000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL, (tu_int)0x8000000080000000uLL << 64 | 0x0000000180000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL, (tu_int)0x8000000080000000uLL << 64 | 0x00000001FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL, (tu_int)0x8000000080000000uLL << 64 | 0x8000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL, (tu_int)0x8000000080000000uLL << 64 | 0x8000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL, (tu_int)0x8000000080000000uLL << 64 | 0x8000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL, (tu_int)0x8000000080000000uLL << 64 | 0x80000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL, (tu_int)0x8000000080000000uLL << 64 | 0xFFFFFFFF00000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL, (tu_int)0x8000000080000000uLL << 64 | 0xFFFFFFFF00000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL, (tu_int)0x8000000080000000uLL << 64 | 0xFFFFFFFF80000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL, (tu_int)0x8000000080000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL, (tu_int)0x80000000FFFFFFFFuLL << 64 | 0x0000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL, (tu_int)0x80000000FFFFFFFFuLL << 64 | 0x0000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL, (tu_int)0x80000000FFFFFFFFuLL << 64 | 0x0000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL, (tu_int)0x80000000FFFFFFFFuLL << 64 | 0x00000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL, (tu_int)0x80000000FFFFFFFFuLL << 64 | 0x0000000100000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL, (tu_int)0x80000000FFFFFFFFuLL << 64 | 0x0000000100000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL, (tu_int)0x80000000FFFFFFFFuLL << 64 | 0x0000000180000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL, (tu_int)0x80000000FFFFFFFFuLL << 64 | 0x00000001FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL, (tu_int)0x80000000FFFFFFFFuLL << 64 | 0x8000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL, (tu_int)0x80000000FFFFFFFFuLL << 64 | 0x8000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL, (tu_int)0x80000000FFFFFFFFuLL << 64 | 0x8000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL, (tu_int)0x80000000FFFFFFFFuLL << 64 | 0x80000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL, (tu_int)0x80000000FFFFFFFFuLL << 64 | 0xFFFFFFFF00000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL, (tu_int)0x80000000FFFFFFFFuLL << 64 | 0xFFFFFFFF00000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL, (tu_int)0x80000000FFFFFFFFuLL << 64 | 0xFFFFFFFF80000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL, (tu_int)0x80000000FFFFFFFFuLL << 64 | 0xFFFFFFFFFFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL, (tu_int)0xFFFFFFFF00000000uLL << 64 | 0x0000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL, (tu_int)0xFFFFFFFF00000000uLL << 64 | 0x0000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL, (tu_int)0xFFFFFFFF00000000uLL << 64 | 0x0000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL, (tu_int)0xFFFFFFFF00000000uLL << 64 | 0x00000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL, (tu_int)0xFFFFFFFF00000000uLL << 64 | 0x0000000100000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL, (tu_int)0xFFFFFFFF00000000uLL << 64 | 0x0000000100000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL, (tu_int)0xFFFFFFFF00000000uLL << 64 | 0x0000000180000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL, (tu_int)0xFFFFFFFF00000000uLL << 64 | 0x00000001FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL, (tu_int)0xFFFFFFFF00000000uLL << 64 | 0x8000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL, (tu_int)0xFFFFFFFF00000000uLL << 64 | 0x8000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL, (tu_int)0xFFFFFFFF00000000uLL << 64 | 0x8000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL, (tu_int)0xFFFFFFFF00000000uLL << 64 | 0x80000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL, (tu_int)0xFFFFFFFF00000000uLL << 64 | 0xFFFFFFFF00000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL, (tu_int)0xFFFFFFFF00000000uLL << 64 | 0xFFFFFFFF00000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL, (tu_int)0xFFFFFFFF00000000uLL << 64 | 0xFFFFFFFF80000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL, (tu_int)0xFFFFFFFF00000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL, (tu_int)0xFFFFFFFF00000001uLL << 64 | 0x0000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL, (tu_int)0xFFFFFFFF00000001uLL << 64 | 0x0000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL, (tu_int)0xFFFFFFFF00000001uLL << 64 | 0x0000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL, (tu_int)0xFFFFFFFF00000001uLL << 64 | 0x00000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL, (tu_int)0xFFFFFFFF00000001uLL << 64 | 0x0000000100000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL, (tu_int)0xFFFFFFFF00000001uLL << 64 | 0x0000000100000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL, (tu_int)0xFFFFFFFF00000001uLL << 64 | 0x0000000180000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL, (tu_int)0xFFFFFFFF00000001uLL << 64 | 0x00000001FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL, (tu_int)0xFFFFFFFF00000001uLL << 64 | 0x8000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL, (tu_int)0xFFFFFFFF00000001uLL << 64 | 0x8000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL, (tu_int)0xFFFFFFFF00000001uLL << 64 | 0x8000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL, (tu_int)0xFFFFFFFF00000001uLL << 64 | 0x80000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL, (tu_int)0xFFFFFFFF00000001uLL << 64 | 0xFFFFFFFF00000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL, (tu_int)0xFFFFFFFF00000001uLL << 64 | 0xFFFFFFFF00000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL, (tu_int)0xFFFFFFFF00000001uLL << 64 | 0xFFFFFFFF80000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL, (tu_int)0xFFFFFFFF00000001uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL, (tu_int)0xFFFFFFFF80000000uLL << 64 | 0x0000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL, (tu_int)0xFFFFFFFF80000000uLL << 64 | 0x0000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL, (tu_int)0xFFFFFFFF80000000uLL << 64 | 0x0000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL, (tu_int)0xFFFFFFFF80000000uLL << 64 | 0x00000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL, (tu_int)0xFFFFFFFF80000000uLL << 64 | 0x0000000100000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL, (tu_int)0xFFFFFFFF80000000uLL << 64 | 0x0000000100000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL, (tu_int)0xFFFFFFFF80000000uLL << 64 | 0x0000000180000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL, (tu_int)0xFFFFFFFF80000000uLL << 64 | 0x00000001FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL, (tu_int)0xFFFFFFFF80000000uLL << 64 | 0x8000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL, (tu_int)0xFFFFFFFF80000000uLL << 64 | 0x8000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL, (tu_int)0xFFFFFFFF80000000uLL << 64 | 0x8000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL, (tu_int)0xFFFFFFFF80000000uLL << 64 | 0x80000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL, (tu_int)0xFFFFFFFF80000000uLL << 64 | 0xFFFFFFFF00000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL, (tu_int)0xFFFFFFFF80000000uLL << 64 | 0xFFFFFFFF00000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL, (tu_int)0xFFFFFFFF80000000uLL << 64 | 0xFFFFFFFF80000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL, (tu_int)0xFFFFFFFF80000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL, (tu_int)0xFFFFFFFFFFFFFFFFuLL << 64 | 0x0000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL, (tu_int)0xFFFFFFFFFFFFFFFFuLL << 64 | 0x0000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL, (tu_int)0xFFFFFFFFFFFFFFFFuLL << 64 | 0x0000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL, (tu_int)0xFFFFFFFFFFFFFFFFuLL << 64 | 0x00000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL, (tu_int)0xFFFFFFFFFFFFFFFFuLL << 64 | 0x0000000100000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL, (tu_int)0xFFFFFFFFFFFFFFFFuLL << 64 | 0x0000000100000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL, (tu_int)0xFFFFFFFFFFFFFFFFuLL << 64 | 0x0000000180000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL, (tu_int)0xFFFFFFFFFFFFFFFFuLL << 64 | 0x00000001FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL, (tu_int)0xFFFFFFFFFFFFFFFFuLL << 64 | 0x8000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL, (tu_int)0xFFFFFFFFFFFFFFFFuLL << 64 | 0x8000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL, (tu_int)0xFFFFFFFFFFFFFFFFuLL << 64 | 0x8000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL, (tu_int)0xFFFFFFFFFFFFFFFFuLL << 64 | 0x80000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL, (tu_int)0xFFFFFFFFFFFFFFFFuLL << 64 | 0xFFFFFFFF00000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL, (tu_int)0xFFFFFFFFFFFFFFFFuLL << 64 | 0xFFFFFFFF00000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL, (tu_int)0xFFFFFFFFFFFFFFFFuLL << 64 | 0xFFFFFFFF80000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL, (tu_int)0xFFFFFFFFFFFFFFFFuLL << 64 | 0xFFFFFFFFFFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000002uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL, (tu_int)0x0000000000000001uLL << 64 | 0x0000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL, (tu_int)0x0000000000000001uLL << 64 | 0x0000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL, (tu_int)0x0000000000000001uLL << 64 | 0x0000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL, (tu_int)0x0000000000000001uLL << 64 | 0x00000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL, (tu_int)0x0000000000000001uLL << 64 | 0x0000000100000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL, (tu_int)0x0000000000000001uLL << 64 | 0x0000000100000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL, (tu_int)0x0000000000000001uLL << 64 | 0x0000000180000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL, (tu_int)0x0000000000000001uLL << 64 | 0x00000001FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL, (tu_int)0x0000000000000001uLL << 64 | 0x8000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL, (tu_int)0x0000000000000001uLL << 64 | 0x8000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL, (tu_int)0x0000000000000001uLL << 64 | 0x8000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL, (tu_int)0x0000000000000001uLL << 64 | 0x80000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL, (tu_int)0x0000000000000001uLL << 64 | 0xFFFFFFFF00000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL, (tu_int)0x0000000000000001uLL << 64 | 0xFFFFFFFF00000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL, (tu_int)0x0000000000000001uLL << 64 | 0xFFFFFFFF80000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL, (tu_int)0x0000000000000001uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL, (tu_int)0x0000000080000000uLL << 64 | 0x0000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL, (tu_int)0x0000000080000000uLL << 64 | 0x0000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL, (tu_int)0x0000000080000000uLL << 64 | 0x0000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL, (tu_int)0x0000000080000000uLL << 64 | 0x00000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL, (tu_int)0x0000000080000000uLL << 64 | 0x0000000100000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL, (tu_int)0x0000000080000000uLL << 64 | 0x0000000100000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL, (tu_int)0x0000000080000000uLL << 64 | 0x0000000180000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL, (tu_int)0x0000000080000000uLL << 64 | 0x00000001FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL, (tu_int)0x0000000080000000uLL << 64 | 0x8000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL, (tu_int)0x0000000080000000uLL << 64 | 0x8000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL, (tu_int)0x0000000080000000uLL << 64 | 0x8000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL, (tu_int)0x0000000080000000uLL << 64 | 0x80000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL, (tu_int)0x0000000080000000uLL << 64 | 0xFFFFFFFF00000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL, (tu_int)0x0000000080000000uLL << 64 | 0xFFFFFFFF00000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL, (tu_int)0x0000000080000000uLL << 64 | 0xFFFFFFFF80000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL, (tu_int)0x0000000080000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL, (tu_int)0x00000000FFFFFFFFuLL << 64 | 0x0000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL, (tu_int)0x00000000FFFFFFFFuLL << 64 | 0x0000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL, (tu_int)0x00000000FFFFFFFFuLL << 64 | 0x0000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL, (tu_int)0x00000000FFFFFFFFuLL << 64 | 0x00000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL, (tu_int)0x00000000FFFFFFFFuLL << 64 | 0x0000000100000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL, (tu_int)0x00000000FFFFFFFFuLL << 64 | 0x0000000100000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL, (tu_int)0x00000000FFFFFFFFuLL << 64 | 0x0000000180000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL, (tu_int)0x00000000FFFFFFFFuLL << 64 | 0x00000001FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL, (tu_int)0x00000000FFFFFFFFuLL << 64 | 0x8000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL, (tu_int)0x00000000FFFFFFFFuLL << 64 | 0x8000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL, (tu_int)0x00000000FFFFFFFFuLL << 64 | 0x8000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL, (tu_int)0x00000000FFFFFFFFuLL << 64 | 0x80000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL, (tu_int)0x00000000FFFFFFFFuLL << 64 | 0xFFFFFFFF00000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL, (tu_int)0x00000000FFFFFFFFuLL << 64 | 0xFFFFFFFF00000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL, (tu_int)0x00000000FFFFFFFFuLL << 64 | 0xFFFFFFFF80000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL, (tu_int)0x00000000FFFFFFFFuLL << 64 | 0xFFFFFFFFFFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL, (tu_int)0x0000000100000000uLL << 64 | 0x0000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL, (tu_int)0x0000000100000000uLL << 64 | 0x0000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL, (tu_int)0x0000000100000000uLL << 64 | 0x0000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL, (tu_int)0x0000000100000000uLL << 64 | 0x00000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL, (tu_int)0x0000000100000000uLL << 64 | 0x0000000100000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL, (tu_int)0x0000000100000000uLL << 64 | 0x0000000100000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL, (tu_int)0x0000000100000000uLL << 64 | 0x0000000180000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL, (tu_int)0x0000000100000000uLL << 64 | 0x00000001FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL, (tu_int)0x0000000100000000uLL << 64 | 0x8000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL, (tu_int)0x0000000100000000uLL << 64 | 0x8000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL, (tu_int)0x0000000100000000uLL << 64 | 0x8000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL, (tu_int)0x0000000100000000uLL << 64 | 0x80000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL, (tu_int)0x0000000100000000uLL << 64 | 0xFFFFFFFF00000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL, (tu_int)0x0000000100000000uLL << 64 | 0xFFFFFFFF00000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL, (tu_int)0x0000000100000000uLL << 64 | 0xFFFFFFFF80000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL, (tu_int)0x0000000100000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL, (tu_int)0x0000000100000001uLL << 64 | 0x0000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL, (tu_int)0x0000000100000001uLL << 64 | 0x0000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL, (tu_int)0x0000000100000001uLL << 64 | 0x0000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL, (tu_int)0x0000000100000001uLL << 64 | 0x00000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL, (tu_int)0x0000000100000001uLL << 64 | 0x0000000100000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL, (tu_int)0x0000000100000001uLL << 64 | 0x0000000100000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL, (tu_int)0x0000000100000001uLL << 64 | 0x0000000180000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL, (tu_int)0x0000000100000001uLL << 64 | 0x00000001FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL, (tu_int)0x0000000100000001uLL << 64 | 0x8000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL, (tu_int)0x0000000100000001uLL << 64 | 0x8000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL, (tu_int)0x0000000100000001uLL << 64 | 0x8000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL, (tu_int)0x0000000100000001uLL << 64 | 0x80000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL, (tu_int)0x0000000100000001uLL << 64 | 0xFFFFFFFF00000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL, (tu_int)0x0000000100000001uLL << 64 | 0xFFFFFFFF00000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL, (tu_int)0x0000000100000001uLL << 64 | 0xFFFFFFFF80000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL, (tu_int)0x0000000100000001uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL, (tu_int)0x0000000180000000uLL << 64 | 0x0000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL, (tu_int)0x0000000180000000uLL << 64 | 0x0000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL, (tu_int)0x0000000180000000uLL << 64 | 0x0000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL, (tu_int)0x0000000180000000uLL << 64 | 0x00000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL, (tu_int)0x0000000180000000uLL << 64 | 0x0000000100000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL, (tu_int)0x0000000180000000uLL << 64 | 0x0000000100000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL, (tu_int)0x0000000180000000uLL << 64 | 0x0000000180000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL, (tu_int)0x0000000180000000uLL << 64 | 0x00000001FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL, (tu_int)0x0000000180000000uLL << 64 | 0x8000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL, (tu_int)0x0000000180000000uLL << 64 | 0x8000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL, (tu_int)0x0000000180000000uLL << 64 | 0x8000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL, (tu_int)0x0000000180000000uLL << 64 | 0x80000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL, (tu_int)0x0000000180000000uLL << 64 | 0xFFFFFFFF00000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL, (tu_int)0x0000000180000000uLL << 64 | 0xFFFFFFFF00000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL, (tu_int)0x0000000180000000uLL << 64 | 0xFFFFFFFF80000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL, (tu_int)0x0000000180000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL, (tu_int)0x00000001FFFFFFFFuLL << 64 | 0x0000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL, (tu_int)0x00000001FFFFFFFFuLL << 64 | 0x0000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL, (tu_int)0x00000001FFFFFFFFuLL << 64 | 0x0000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL, (tu_int)0x00000001FFFFFFFFuLL << 64 | 0x00000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL, (tu_int)0x00000001FFFFFFFFuLL << 64 | 0x0000000100000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL, (tu_int)0x00000001FFFFFFFFuLL << 64 | 0x0000000100000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL, (tu_int)0x00000001FFFFFFFFuLL << 64 | 0x0000000180000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL, (tu_int)0x00000001FFFFFFFFuLL << 64 | 0x00000001FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL, (tu_int)0x00000001FFFFFFFFuLL << 64 | 0x8000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL, (tu_int)0x00000001FFFFFFFFuLL << 64 | 0x8000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL, (tu_int)0x00000001FFFFFFFFuLL << 64 | 0x8000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL, (tu_int)0x00000001FFFFFFFFuLL << 64 | 0x80000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL, (tu_int)0x00000001FFFFFFFFuLL << 64 | 0xFFFFFFFF00000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL, (tu_int)0x00000001FFFFFFFFuLL << 64 | 0xFFFFFFFF00000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL, (tu_int)0x00000001FFFFFFFFuLL << 64 | 0xFFFFFFFF80000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL, (tu_int)0x00000001FFFFFFFFuLL << 64 | 0xFFFFFFFFFFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL, (tu_int)0x8000000000000000uLL << 64 | 0x0000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL, (tu_int)0x8000000000000000uLL << 64 | 0x0000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL, (tu_int)0x8000000000000000uLL << 64 | 0x0000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL, (tu_int)0x8000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL, (tu_int)0x8000000000000000uLL << 64 | 0x0000000100000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL, (tu_int)0x8000000000000000uLL << 64 | 0x0000000100000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL, (tu_int)0x8000000000000000uLL << 64 | 0x0000000180000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL, (tu_int)0x8000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL, (tu_int)0x8000000000000000uLL << 64 | 0x8000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL, (tu_int)0x8000000000000000uLL << 64 | 0x8000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL, (tu_int)0x8000000000000000uLL << 64 | 0x8000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL, (tu_int)0x8000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL, (tu_int)0x8000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL, (tu_int)0x8000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL, (tu_int)0x8000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL, (tu_int)0x8000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL, (tu_int)0x8000000000000001uLL << 64 | 0x0000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL, (tu_int)0x8000000000000001uLL << 64 | 0x0000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL, (tu_int)0x8000000000000001uLL << 64 | 0x0000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL, (tu_int)0x8000000000000001uLL << 64 | 0x00000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL, (tu_int)0x8000000000000001uLL << 64 | 0x0000000100000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL, (tu_int)0x8000000000000001uLL << 64 | 0x0000000100000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL, (tu_int)0x8000000000000001uLL << 64 | 0x0000000180000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL, (tu_int)0x8000000000000001uLL << 64 | 0x00000001FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL, (tu_int)0x8000000000000001uLL << 64 | 0x8000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL, (tu_int)0x8000000000000001uLL << 64 | 0x8000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL, (tu_int)0x8000000000000001uLL << 64 | 0x8000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL, (tu_int)0x8000000000000001uLL << 64 | 0x80000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL, (tu_int)0x8000000000000001uLL << 64 | 0xFFFFFFFF00000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL, (tu_int)0x8000000000000001uLL << 64 | 0xFFFFFFFF00000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL, (tu_int)0x8000000000000001uLL << 64 | 0xFFFFFFFF80000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL, (tu_int)0x8000000000000001uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL, (tu_int)0x8000000080000000uLL << 64 | 0x0000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL, (tu_int)0x8000000080000000uLL << 64 | 0x0000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL, (tu_int)0x8000000080000000uLL << 64 | 0x0000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL, (tu_int)0x8000000080000000uLL << 64 | 0x00000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL, (tu_int)0x8000000080000000uLL << 64 | 0x0000000100000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL, (tu_int)0x8000000080000000uLL << 64 | 0x0000000100000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL, (tu_int)0x8000000080000000uLL << 64 | 0x0000000180000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL, (tu_int)0x8000000080000000uLL << 64 | 0x00000001FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL, (tu_int)0x8000000080000000uLL << 64 | 0x8000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL, (tu_int)0x8000000080000000uLL << 64 | 0x8000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL, (tu_int)0x8000000080000000uLL << 64 | 0x8000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL, (tu_int)0x8000000080000000uLL << 64 | 0x80000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL, (tu_int)0x8000000080000000uLL << 64 | 0xFFFFFFFF00000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL, (tu_int)0x8000000080000000uLL << 64 | 0xFFFFFFFF00000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL, (tu_int)0x8000000080000000uLL << 64 | 0xFFFFFFFF80000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL, (tu_int)0x8000000080000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL, (tu_int)0x80000000FFFFFFFFuLL << 64 | 0x0000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL, (tu_int)0x80000000FFFFFFFFuLL << 64 | 0x0000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL, (tu_int)0x80000000FFFFFFFFuLL << 64 | 0x0000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL, (tu_int)0x80000000FFFFFFFFuLL << 64 | 0x00000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL, (tu_int)0x80000000FFFFFFFFuLL << 64 | 0x0000000100000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL, (tu_int)0x80000000FFFFFFFFuLL << 64 | 0x0000000100000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL, (tu_int)0x80000000FFFFFFFFuLL << 64 | 0x0000000180000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL, (tu_int)0x80000000FFFFFFFFuLL << 64 | 0x00000001FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL, (tu_int)0x80000000FFFFFFFFuLL << 64 | 0x8000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL, (tu_int)0x80000000FFFFFFFFuLL << 64 | 0x8000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL, (tu_int)0x80000000FFFFFFFFuLL << 64 | 0x8000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL, (tu_int)0x80000000FFFFFFFFuLL << 64 | 0x80000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL, (tu_int)0x80000000FFFFFFFFuLL << 64 | 0xFFFFFFFF00000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL, (tu_int)0x80000000FFFFFFFFuLL << 64 | 0xFFFFFFFF00000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL, (tu_int)0x80000000FFFFFFFFuLL << 64 | 0xFFFFFFFF80000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL, (tu_int)0x80000000FFFFFFFFuLL << 64 | 0xFFFFFFFFFFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL, (tu_int)0xFFFFFFFF00000000uLL << 64 | 0x0000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL, (tu_int)0xFFFFFFFF00000000uLL << 64 | 0x0000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL, (tu_int)0xFFFFFFFF00000000uLL << 64 | 0x0000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL, (tu_int)0xFFFFFFFF00000000uLL << 64 | 0x00000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL, (tu_int)0xFFFFFFFF00000000uLL << 64 | 0x0000000100000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL, (tu_int)0xFFFFFFFF00000000uLL << 64 | 0x0000000100000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL, (tu_int)0xFFFFFFFF00000000uLL << 64 | 0x0000000180000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL, (tu_int)0xFFFFFFFF00000000uLL << 64 | 0x00000001FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL, (tu_int)0xFFFFFFFF00000000uLL << 64 | 0x8000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL, (tu_int)0xFFFFFFFF00000000uLL << 64 | 0x8000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL, (tu_int)0xFFFFFFFF00000000uLL << 64 | 0x8000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL, (tu_int)0xFFFFFFFF00000000uLL << 64 | 0x80000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL, (tu_int)0xFFFFFFFF00000000uLL << 64 | 0xFFFFFFFF00000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL, (tu_int)0xFFFFFFFF00000000uLL << 64 | 0xFFFFFFFF00000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL, (tu_int)0xFFFFFFFF00000000uLL << 64 | 0xFFFFFFFF80000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL, (tu_int)0xFFFFFFFF00000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL, (tu_int)0xFFFFFFFF00000001uLL << 64 | 0x0000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL, (tu_int)0xFFFFFFFF00000001uLL << 64 | 0x0000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL, (tu_int)0xFFFFFFFF00000001uLL << 64 | 0x0000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL, (tu_int)0xFFFFFFFF00000001uLL << 64 | 0x00000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL, (tu_int)0xFFFFFFFF00000001uLL << 64 | 0x0000000100000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL, (tu_int)0xFFFFFFFF00000001uLL << 64 | 0x0000000100000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL, (tu_int)0xFFFFFFFF00000001uLL << 64 | 0x0000000180000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL, (tu_int)0xFFFFFFFF00000001uLL << 64 | 0x00000001FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL, (tu_int)0xFFFFFFFF00000001uLL << 64 | 0x8000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL, (tu_int)0xFFFFFFFF00000001uLL << 64 | 0x8000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL, (tu_int)0xFFFFFFFF00000001uLL << 64 | 0x8000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL, (tu_int)0xFFFFFFFF00000001uLL << 64 | 0x80000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL, (tu_int)0xFFFFFFFF00000001uLL << 64 | 0xFFFFFFFF00000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL, (tu_int)0xFFFFFFFF00000001uLL << 64 | 0xFFFFFFFF00000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL, (tu_int)0xFFFFFFFF00000001uLL << 64 | 0xFFFFFFFF80000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL, (tu_int)0xFFFFFFFF00000001uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL, (tu_int)0xFFFFFFFF80000000uLL << 64 | 0x0000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL, (tu_int)0xFFFFFFFF80000000uLL << 64 | 0x0000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL, (tu_int)0xFFFFFFFF80000000uLL << 64 | 0x0000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL, (tu_int)0xFFFFFFFF80000000uLL << 64 | 0x00000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL, (tu_int)0xFFFFFFFF80000000uLL << 64 | 0x0000000100000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL, (tu_int)0xFFFFFFFF80000000uLL << 64 | 0x0000000100000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL, (tu_int)0xFFFFFFFF80000000uLL << 64 | 0x0000000180000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL, (tu_int)0xFFFFFFFF80000000uLL << 64 | 0x00000001FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL, (tu_int)0xFFFFFFFF80000000uLL << 64 | 0x8000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL, (tu_int)0xFFFFFFFF80000000uLL << 64 | 0x8000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL, (tu_int)0xFFFFFFFF80000000uLL << 64 | 0x8000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL, (tu_int)0xFFFFFFFF80000000uLL << 64 | 0x80000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL, (tu_int)0xFFFFFFFF80000000uLL << 64 | 0xFFFFFFFF00000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL, (tu_int)0xFFFFFFFF80000000uLL << 64 | 0xFFFFFFFF00000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL, (tu_int)0xFFFFFFFF80000000uLL << 64 | 0xFFFFFFFF80000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL, (tu_int)0xFFFFFFFF80000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL, (tu_int)0xFFFFFFFFFFFFFFFFuLL << 64 | 0x0000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL, (tu_int)0xFFFFFFFFFFFFFFFFuLL << 64 | 0x0000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL, (tu_int)0xFFFFFFFFFFFFFFFFuLL << 64 | 0x0000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL, (tu_int)0xFFFFFFFFFFFFFFFFuLL << 64 | 0x00000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL, (tu_int)0xFFFFFFFFFFFFFFFFuLL << 64 | 0x0000000100000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL, (tu_int)0xFFFFFFFFFFFFFFFFuLL << 64 | 0x0000000100000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL, (tu_int)0xFFFFFFFFFFFFFFFFuLL << 64 | 0x0000000180000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL, (tu_int)0xFFFFFFFFFFFFFFFFuLL << 64 | 0x00000001FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL, (tu_int)0xFFFFFFFFFFFFFFFFuLL << 64 | 0x8000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL, (tu_int)0xFFFFFFFFFFFFFFFFuLL << 64 | 0x8000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL, (tu_int)0xFFFFFFFFFFFFFFFFuLL << 64 | 0x8000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL, (tu_int)0xFFFFFFFFFFFFFFFFuLL << 64 | 0x80000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL, (tu_int)0xFFFFFFFFFFFFFFFFuLL << 64 | 0xFFFFFFFF00000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL, (tu_int)0xFFFFFFFFFFFFFFFFuLL << 64 | 0xFFFFFFFF00000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL, (tu_int)0xFFFFFFFFFFFFFFFFuLL << 64 | 0xFFFFFFFF80000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL, (tu_int)0xFFFFFFFFFFFFFFFFuLL << 64 | 0xFFFFFFFFFFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000002uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000002uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL, (tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL, (tu_int)0x0000000000000001uLL << 64 | 0x0000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL, (tu_int)0x0000000000000001uLL << 64 | 0x0000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL, (tu_int)0x0000000000000001uLL << 64 | 0x0000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL, (tu_int)0x0000000000000001uLL << 64 | 0x00000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL, (tu_int)0x0000000000000001uLL << 64 | 0x0000000100000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL, (tu_int)0x0000000000000001uLL << 64 | 0x0000000100000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL, (tu_int)0x0000000000000001uLL << 64 | 0x0000000180000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL, (tu_int)0x0000000000000001uLL << 64 | 0x00000001FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL, (tu_int)0x0000000000000001uLL << 64 | 0x8000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL, (tu_int)0x0000000000000001uLL << 64 | 0x8000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL, (tu_int)0x0000000000000001uLL << 64 | 0x8000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL, (tu_int)0x0000000000000001uLL << 64 | 0x80000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL, (tu_int)0x0000000000000001uLL << 64 | 0xFFFFFFFF00000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL, (tu_int)0x0000000000000001uLL << 64 | 0xFFFFFFFF00000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL, (tu_int)0x0000000000000001uLL << 64 | 0xFFFFFFFF80000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL, (tu_int)0x0000000000000001uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL, (tu_int)0x0000000080000000uLL << 64 | 0x0000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL, (tu_int)0x0000000080000000uLL << 64 | 0x0000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL, (tu_int)0x0000000080000000uLL << 64 | 0x0000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL, (tu_int)0x0000000080000000uLL << 64 | 0x00000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL, (tu_int)0x0000000080000000uLL << 64 | 0x0000000100000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL, (tu_int)0x0000000080000000uLL << 64 | 0x0000000100000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL, (tu_int)0x0000000080000000uLL << 64 | 0x0000000180000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL, (tu_int)0x0000000080000000uLL << 64 | 0x00000001FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL, (tu_int)0x0000000080000000uLL << 64 | 0x8000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL, (tu_int)0x0000000080000000uLL << 64 | 0x8000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL, (tu_int)0x0000000080000000uLL << 64 | 0x8000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL, (tu_int)0x0000000080000000uLL << 64 | 0x80000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL, (tu_int)0x0000000080000000uLL << 64 | 0xFFFFFFFF00000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL, (tu_int)0x0000000080000000uLL << 64 | 0xFFFFFFFF00000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL, (tu_int)0x0000000080000000uLL << 64 | 0xFFFFFFFF80000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL, (tu_int)0x0000000080000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL, (tu_int)0x00000000FFFFFFFFuLL << 64 | 0x0000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL, (tu_int)0x00000000FFFFFFFFuLL << 64 | 0x0000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL, (tu_int)0x00000000FFFFFFFFuLL << 64 | 0x0000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL, (tu_int)0x00000000FFFFFFFFuLL << 64 | 0x00000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL, (tu_int)0x00000000FFFFFFFFuLL << 64 | 0x0000000100000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL, (tu_int)0x00000000FFFFFFFFuLL << 64 | 0x0000000100000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL, (tu_int)0x00000000FFFFFFFFuLL << 64 | 0x0000000180000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL, (tu_int)0x00000000FFFFFFFFuLL << 64 | 0x00000001FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL, (tu_int)0x00000000FFFFFFFFuLL << 64 | 0x8000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL, (tu_int)0x00000000FFFFFFFFuLL << 64 | 0x8000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL, (tu_int)0x00000000FFFFFFFFuLL << 64 | 0x8000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL, (tu_int)0x00000000FFFFFFFFuLL << 64 | 0x80000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL, (tu_int)0x00000000FFFFFFFFuLL << 64 | 0xFFFFFFFF00000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL, (tu_int)0x00000000FFFFFFFFuLL << 64 | 0xFFFFFFFF00000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL, (tu_int)0x00000000FFFFFFFFuLL << 64 | 0xFFFFFFFF80000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL, (tu_int)0x00000000FFFFFFFFuLL << 64 | 0xFFFFFFFFFFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL, (tu_int)0x0000000100000000uLL << 64 | 0x0000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL, (tu_int)0x0000000100000000uLL << 64 | 0x0000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL, (tu_int)0x0000000100000000uLL << 64 | 0x0000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL, (tu_int)0x0000000100000000uLL << 64 | 0x00000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL, (tu_int)0x0000000100000000uLL << 64 | 0x0000000100000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL, (tu_int)0x0000000100000000uLL << 64 | 0x0000000100000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL, (tu_int)0x0000000100000000uLL << 64 | 0x0000000180000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL, (tu_int)0x0000000100000000uLL << 64 | 0x00000001FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL, (tu_int)0x0000000100000000uLL << 64 | 0x8000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL, (tu_int)0x0000000100000000uLL << 64 | 0x8000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL, (tu_int)0x0000000100000000uLL << 64 | 0x8000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL, (tu_int)0x0000000100000000uLL << 64 | 0x80000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL, (tu_int)0x0000000100000000uLL << 64 | 0xFFFFFFFF00000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL, (tu_int)0x0000000100000000uLL << 64 | 0xFFFFFFFF00000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL, (tu_int)0x0000000100000000uLL << 64 | 0xFFFFFFFF80000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL, (tu_int)0x0000000100000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL, (tu_int)0x0000000100000001uLL << 64 | 0x0000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL, (tu_int)0x0000000100000001uLL << 64 | 0x0000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL, (tu_int)0x0000000100000001uLL << 64 | 0x0000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL, (tu_int)0x0000000100000001uLL << 64 | 0x00000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL, (tu_int)0x0000000100000001uLL << 64 | 0x0000000100000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL, (tu_int)0x0000000100000001uLL << 64 | 0x0000000100000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL, (tu_int)0x0000000100000001uLL << 64 | 0x0000000180000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL, (tu_int)0x0000000100000001uLL << 64 | 0x00000001FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL, (tu_int)0x0000000100000001uLL << 64 | 0x8000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL, (tu_int)0x0000000100000001uLL << 64 | 0x8000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL, (tu_int)0x0000000100000001uLL << 64 | 0x8000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL, (tu_int)0x0000000100000001uLL << 64 | 0x80000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL, (tu_int)0x0000000100000001uLL << 64 | 0xFFFFFFFF00000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL, (tu_int)0x0000000100000001uLL << 64 | 0xFFFFFFFF00000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL, (tu_int)0x0000000100000001uLL << 64 | 0xFFFFFFFF80000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL, (tu_int)0x0000000100000001uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL, (tu_int)0x0000000180000000uLL << 64 | 0x0000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL, (tu_int)0x0000000180000000uLL << 64 | 0x0000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL, (tu_int)0x0000000180000000uLL << 64 | 0x0000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL, (tu_int)0x0000000180000000uLL << 64 | 0x00000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL, (tu_int)0x0000000180000000uLL << 64 | 0x0000000100000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL, (tu_int)0x0000000180000000uLL << 64 | 0x0000000100000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL, (tu_int)0x0000000180000000uLL << 64 | 0x0000000180000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL, (tu_int)0x0000000180000000uLL << 64 | 0x00000001FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL, (tu_int)0x0000000180000000uLL << 64 | 0x8000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL, (tu_int)0x0000000180000000uLL << 64 | 0x8000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL, (tu_int)0x0000000180000000uLL << 64 | 0x8000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL, (tu_int)0x0000000180000000uLL << 64 | 0x80000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL, (tu_int)0x0000000180000000uLL << 64 | 0xFFFFFFFF00000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL, (tu_int)0x0000000180000000uLL << 64 | 0xFFFFFFFF00000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL, (tu_int)0x0000000180000000uLL << 64 | 0xFFFFFFFF80000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL, (tu_int)0x0000000180000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL, (tu_int)0x00000001FFFFFFFFuLL << 64 | 0x0000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL, (tu_int)0x00000001FFFFFFFFuLL << 64 | 0x0000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL, (tu_int)0x00000001FFFFFFFFuLL << 64 | 0x0000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL, (tu_int)0x00000001FFFFFFFFuLL << 64 | 0x00000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL, (tu_int)0x00000001FFFFFFFFuLL << 64 | 0x0000000100000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL, (tu_int)0x00000001FFFFFFFFuLL << 64 | 0x0000000100000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL, (tu_int)0x00000001FFFFFFFFuLL << 64 | 0x0000000180000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL, (tu_int)0x00000001FFFFFFFFuLL << 64 | 0x00000001FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL, (tu_int)0x00000001FFFFFFFFuLL << 64 | 0x8000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL, (tu_int)0x00000001FFFFFFFFuLL << 64 | 0x8000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL, (tu_int)0x00000001FFFFFFFFuLL << 64 | 0x8000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL, (tu_int)0x00000001FFFFFFFFuLL << 64 | 0x80000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL, (tu_int)0x00000001FFFFFFFFuLL << 64 | 0xFFFFFFFF00000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL, (tu_int)0x00000001FFFFFFFFuLL << 64 | 0xFFFFFFFF00000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL, (tu_int)0x00000001FFFFFFFFuLL << 64 | 0xFFFFFFFF80000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL, (tu_int)0x00000001FFFFFFFFuLL << 64 | 0xFFFFFFFFFFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL, (tu_int)0x8000000000000000uLL << 64 | 0x0000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL, (tu_int)0x8000000000000000uLL << 64 | 0x0000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL, (tu_int)0x8000000000000000uLL << 64 | 0x0000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL, (tu_int)0x8000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL, (tu_int)0x8000000000000000uLL << 64 | 0x0000000100000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL, (tu_int)0x8000000000000000uLL << 64 | 0x0000000100000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL, (tu_int)0x8000000000000000uLL << 64 | 0x0000000180000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL, (tu_int)0x8000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL, (tu_int)0x8000000000000000uLL << 64 | 0x8000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL, (tu_int)0x8000000000000000uLL << 64 | 0x8000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL, (tu_int)0x8000000000000000uLL << 64 | 0x8000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL, (tu_int)0x8000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL, (tu_int)0x8000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL, (tu_int)0x8000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL, (tu_int)0x8000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL, (tu_int)0x8000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL, (tu_int)0x8000000000000001uLL << 64 | 0x0000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL, (tu_int)0x8000000000000001uLL << 64 | 0x0000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL, (tu_int)0x8000000000000001uLL << 64 | 0x0000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL, (tu_int)0x8000000000000001uLL << 64 | 0x00000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL, (tu_int)0x8000000000000001uLL << 64 | 0x0000000100000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL, (tu_int)0x8000000000000001uLL << 64 | 0x0000000100000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL, (tu_int)0x8000000000000001uLL << 64 | 0x0000000180000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL, (tu_int)0x8000000000000001uLL << 64 | 0x00000001FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL, (tu_int)0x8000000000000001uLL << 64 | 0x8000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL, (tu_int)0x8000000000000001uLL << 64 | 0x8000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL, (tu_int)0x8000000000000001uLL << 64 | 0x8000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL, (tu_int)0x8000000000000001uLL << 64 | 0x80000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL, (tu_int)0x8000000000000001uLL << 64 | 0xFFFFFFFF00000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL, (tu_int)0x8000000000000001uLL << 64 | 0xFFFFFFFF00000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL, (tu_int)0x8000000000000001uLL << 64 | 0xFFFFFFFF80000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL, (tu_int)0x8000000000000001uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL, (tu_int)0x8000000080000000uLL << 64 | 0x0000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL, (tu_int)0x8000000080000000uLL << 64 | 0x0000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL, (tu_int)0x8000000080000000uLL << 64 | 0x0000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL, (tu_int)0x8000000080000000uLL << 64 | 0x00000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL, (tu_int)0x8000000080000000uLL << 64 | 0x0000000100000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL, (tu_int)0x8000000080000000uLL << 64 | 0x0000000100000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL, (tu_int)0x8000000080000000uLL << 64 | 0x0000000180000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL, (tu_int)0x8000000080000000uLL << 64 | 0x00000001FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL, (tu_int)0x8000000080000000uLL << 64 | 0x8000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL, (tu_int)0x8000000080000000uLL << 64 | 0x8000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL, (tu_int)0x8000000080000000uLL << 64 | 0x8000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL, (tu_int)0x8000000080000000uLL << 64 | 0x80000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL, (tu_int)0x8000000080000000uLL << 64 | 0xFFFFFFFF00000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL, (tu_int)0x8000000080000000uLL << 64 | 0xFFFFFFFF00000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL, (tu_int)0x8000000080000000uLL << 64 | 0xFFFFFFFF80000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL, (tu_int)0x8000000080000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL, (tu_int)0x80000000FFFFFFFFuLL << 64 | 0x0000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL, (tu_int)0x80000000FFFFFFFFuLL << 64 | 0x0000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL, (tu_int)0x80000000FFFFFFFFuLL << 64 | 0x0000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL, (tu_int)0x80000000FFFFFFFFuLL << 64 | 0x00000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL, (tu_int)0x80000000FFFFFFFFuLL << 64 | 0x0000000100000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL, (tu_int)0x80000000FFFFFFFFuLL << 64 | 0x0000000100000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL, (tu_int)0x80000000FFFFFFFFuLL << 64 | 0x0000000180000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL, (tu_int)0x80000000FFFFFFFFuLL << 64 | 0x00000001FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL, (tu_int)0x80000000FFFFFFFFuLL << 64 | 0x8000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL, (tu_int)0x80000000FFFFFFFFuLL << 64 | 0x8000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL, (tu_int)0x80000000FFFFFFFFuLL << 64 | 0x8000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL, (tu_int)0x80000000FFFFFFFFuLL << 64 | 0x80000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL, (tu_int)0x80000000FFFFFFFFuLL << 64 | 0xFFFFFFFF00000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL, (tu_int)0x80000000FFFFFFFFuLL << 64 | 0xFFFFFFFF00000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL, (tu_int)0x80000000FFFFFFFFuLL << 64 | 0xFFFFFFFF80000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL, (tu_int)0x80000000FFFFFFFFuLL << 64 | 0xFFFFFFFFFFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL, (tu_int)0xFFFFFFFF00000000uLL << 64 | 0x0000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL, (tu_int)0xFFFFFFFF00000000uLL << 64 | 0x0000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL, (tu_int)0xFFFFFFFF00000000uLL << 64 | 0x0000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL, (tu_int)0xFFFFFFFF00000000uLL << 64 | 0x00000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL, (tu_int)0xFFFFFFFF00000000uLL << 64 | 0x0000000100000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL, (tu_int)0xFFFFFFFF00000000uLL << 64 | 0x0000000100000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL, (tu_int)0xFFFFFFFF00000000uLL << 64 | 0x0000000180000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL, (tu_int)0xFFFFFFFF00000000uLL << 64 | 0x00000001FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL, (tu_int)0xFFFFFFFF00000000uLL << 64 | 0x8000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL, (tu_int)0xFFFFFFFF00000000uLL << 64 | 0x8000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL, (tu_int)0xFFFFFFFF00000000uLL << 64 | 0x8000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL, (tu_int)0xFFFFFFFF00000000uLL << 64 | 0x80000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL, (tu_int)0xFFFFFFFF00000000uLL << 64 | 0xFFFFFFFF00000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL, (tu_int)0xFFFFFFFF00000000uLL << 64 | 0xFFFFFFFF00000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL, (tu_int)0xFFFFFFFF00000000uLL << 64 | 0xFFFFFFFF80000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL, (tu_int)0xFFFFFFFF00000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL, (tu_int)0xFFFFFFFF00000001uLL << 64 | 0x0000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL, (tu_int)0xFFFFFFFF00000001uLL << 64 | 0x0000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL, (tu_int)0xFFFFFFFF00000001uLL << 64 | 0x0000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL, (tu_int)0xFFFFFFFF00000001uLL << 64 | 0x00000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL, (tu_int)0xFFFFFFFF00000001uLL << 64 | 0x0000000100000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL, (tu_int)0xFFFFFFFF00000001uLL << 64 | 0x0000000100000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL, (tu_int)0xFFFFFFFF00000001uLL << 64 | 0x0000000180000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL, (tu_int)0xFFFFFFFF00000001uLL << 64 | 0x00000001FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL, (tu_int)0xFFFFFFFF00000001uLL << 64 | 0x8000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL, (tu_int)0xFFFFFFFF00000001uLL << 64 | 0x8000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL, (tu_int)0xFFFFFFFF00000001uLL << 64 | 0x8000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL, (tu_int)0xFFFFFFFF00000001uLL << 64 | 0x80000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL, (tu_int)0xFFFFFFFF00000001uLL << 64 | 0xFFFFFFFF00000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL, (tu_int)0xFFFFFFFF00000001uLL << 64 | 0xFFFFFFFF00000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL, (tu_int)0xFFFFFFFF00000001uLL << 64 | 0xFFFFFFFF80000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL, (tu_int)0xFFFFFFFF00000001uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL, (tu_int)0xFFFFFFFF80000000uLL << 64 | 0x0000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL, (tu_int)0xFFFFFFFF80000000uLL << 64 | 0x0000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL, (tu_int)0xFFFFFFFF80000000uLL << 64 | 0x0000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL, (tu_int)0xFFFFFFFF80000000uLL << 64 | 0x00000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL, (tu_int)0xFFFFFFFF80000000uLL << 64 | 0x0000000100000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL, (tu_int)0xFFFFFFFF80000000uLL << 64 | 0x0000000100000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL, (tu_int)0xFFFFFFFF80000000uLL << 64 | 0x0000000180000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL, (tu_int)0xFFFFFFFF80000000uLL << 64 | 0x00000001FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL, (tu_int)0xFFFFFFFF80000000uLL << 64 | 0x8000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL, (tu_int)0xFFFFFFFF80000000uLL << 64 | 0x8000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL, (tu_int)0xFFFFFFFF80000000uLL << 64 | 0x8000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL, (tu_int)0xFFFFFFFF80000000uLL << 64 | 0x80000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL, (tu_int)0xFFFFFFFF80000000uLL << 64 | 0xFFFFFFFF00000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL, (tu_int)0xFFFFFFFF80000000uLL << 64 | 0xFFFFFFFF00000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL, (tu_int)0xFFFFFFFF80000000uLL << 64 | 0xFFFFFFFF80000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL, (tu_int)0xFFFFFFFF80000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL, (tu_int)0xFFFFFFFFFFFFFFFFuLL << 64 | 0x0000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL, (tu_int)0xFFFFFFFFFFFFFFFFuLL << 64 | 0x0000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL, (tu_int)0xFFFFFFFFFFFFFFFFuLL << 64 | 0x0000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL, (tu_int)0xFFFFFFFFFFFFFFFFuLL << 64 | 0x00000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL, (tu_int)0xFFFFFFFFFFFFFFFFuLL << 64 | 0x0000000100000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL, (tu_int)0xFFFFFFFFFFFFFFFFuLL << 64 | 0x0000000100000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL, (tu_int)0xFFFFFFFFFFFFFFFFuLL << 64 | 0x0000000180000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL, (tu_int)0xFFFFFFFFFFFFFFFFuLL << 64 | 0x00000001FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL, (tu_int)0xFFFFFFFFFFFFFFFFuLL << 64 | 0x8000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL, (tu_int)0xFFFFFFFFFFFFFFFFuLL << 64 | 0x8000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL, (tu_int)0xFFFFFFFFFFFFFFFFuLL << 64 | 0x8000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL, (tu_int)0xFFFFFFFFFFFFFFFFuLL << 64 | 0x80000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL, (tu_int)0xFFFFFFFFFFFFFFFFuLL << 64 | 0xFFFFFFFF00000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL, (tu_int)0xFFFFFFFFFFFFFFFFuLL << 64 | 0xFFFFFFFF00000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL, (tu_int)0xFFFFFFFFFFFFFFFFuLL << 64 | 0xFFFFFFFF80000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL, (tu_int)0xFFFFFFFFFFFFFFFFuLL << 64 | 0xFFFFFFFFFFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000003uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000080000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL, (tu_int)0x0000000000000000uLL << 64 | 0x000000007FFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL, (tu_int)0x0000000000000001uLL << 64 | 0x0000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL, (tu_int)0x0000000000000001uLL << 64 | 0x0000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL, (tu_int)0x0000000000000001uLL << 64 | 0x0000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL, (tu_int)0x0000000000000001uLL << 64 | 0x00000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL, (tu_int)0x0000000000000001uLL << 64 | 0x0000000100000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL, (tu_int)0x0000000000000001uLL << 64 | 0x0000000100000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL, (tu_int)0x0000000000000001uLL << 64 | 0x0000000180000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL, (tu_int)0x0000000000000001uLL << 64 | 0x00000001FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL, (tu_int)0x0000000000000001uLL << 64 | 0x8000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL, (tu_int)0x0000000000000001uLL << 64 | 0x8000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL, (tu_int)0x0000000000000001uLL << 64 | 0x8000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL, (tu_int)0x0000000000000001uLL << 64 | 0x80000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL, (tu_int)0x0000000000000001uLL << 64 | 0xFFFFFFFF00000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL, (tu_int)0x0000000000000001uLL << 64 | 0xFFFFFFFF00000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL, (tu_int)0x0000000000000001uLL << 64 | 0xFFFFFFFF80000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL, (tu_int)0x0000000000000001uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL, (tu_int)0x0000000080000000uLL << 64 | 0x0000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL, (tu_int)0x0000000080000000uLL << 64 | 0x0000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL, (tu_int)0x0000000080000000uLL << 64 | 0x0000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL, (tu_int)0x0000000080000000uLL << 64 | 0x00000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL, (tu_int)0x0000000080000000uLL << 64 | 0x0000000100000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL, (tu_int)0x0000000080000000uLL << 64 | 0x0000000100000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL, (tu_int)0x0000000080000000uLL << 64 | 0x0000000180000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL, (tu_int)0x0000000080000000uLL << 64 | 0x00000001FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL, (tu_int)0x0000000080000000uLL << 64 | 0x8000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL, (tu_int)0x0000000080000000uLL << 64 | 0x8000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL, (tu_int)0x0000000080000000uLL << 64 | 0x8000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL, (tu_int)0x0000000080000000uLL << 64 | 0x80000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL, (tu_int)0x0000000080000000uLL << 64 | 0xFFFFFFFF00000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL, (tu_int)0x0000000080000000uLL << 64 | 0xFFFFFFFF00000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL, (tu_int)0x0000000080000000uLL << 64 | 0xFFFFFFFF80000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL, (tu_int)0x0000000080000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL, (tu_int)0x00000000FFFFFFFFuLL << 64 | 0x0000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL, (tu_int)0x00000000FFFFFFFFuLL << 64 | 0x0000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL, (tu_int)0x00000000FFFFFFFFuLL << 64 | 0x0000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL, (tu_int)0x00000000FFFFFFFFuLL << 64 | 0x00000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL, (tu_int)0x00000000FFFFFFFFuLL << 64 | 0x0000000100000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL, (tu_int)0x00000000FFFFFFFFuLL << 64 | 0x0000000100000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL, (tu_int)0x00000000FFFFFFFFuLL << 64 | 0x0000000180000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL, (tu_int)0x00000000FFFFFFFFuLL << 64 | 0x00000001FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL, (tu_int)0x00000000FFFFFFFFuLL << 64 | 0x8000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL, (tu_int)0x00000000FFFFFFFFuLL << 64 | 0x8000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL, (tu_int)0x00000000FFFFFFFFuLL << 64 | 0x8000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL, (tu_int)0x00000000FFFFFFFFuLL << 64 | 0x80000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL, (tu_int)0x00000000FFFFFFFFuLL << 64 | 0xFFFFFFFF00000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL, (tu_int)0x00000000FFFFFFFFuLL << 64 | 0xFFFFFFFF00000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL, (tu_int)0x00000000FFFFFFFFuLL << 64 | 0xFFFFFFFF80000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL, (tu_int)0x00000000FFFFFFFFuLL << 64 | 0xFFFFFFFFFFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL, (tu_int)0x0000000100000000uLL << 64 | 0x0000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL, (tu_int)0x0000000100000000uLL << 64 | 0x0000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL, (tu_int)0x0000000100000000uLL << 64 | 0x0000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL, (tu_int)0x0000000100000000uLL << 64 | 0x00000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL, (tu_int)0x0000000100000000uLL << 64 | 0x0000000100000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL, (tu_int)0x0000000100000000uLL << 64 | 0x0000000100000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL, (tu_int)0x0000000100000000uLL << 64 | 0x0000000180000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL, (tu_int)0x0000000100000000uLL << 64 | 0x00000001FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL, (tu_int)0x0000000100000000uLL << 64 | 0x8000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL, (tu_int)0x0000000100000000uLL << 64 | 0x8000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL, (tu_int)0x0000000100000000uLL << 64 | 0x8000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL, (tu_int)0x0000000100000000uLL << 64 | 0x80000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL, (tu_int)0x0000000100000000uLL << 64 | 0xFFFFFFFF00000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL, (tu_int)0x0000000100000000uLL << 64 | 0xFFFFFFFF00000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL, (tu_int)0x0000000100000000uLL << 64 | 0xFFFFFFFF80000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL, (tu_int)0x0000000100000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL, (tu_int)0x0000000100000001uLL << 64 | 0x0000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL, (tu_int)0x0000000100000001uLL << 64 | 0x0000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL, (tu_int)0x0000000100000001uLL << 64 | 0x0000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL, (tu_int)0x0000000100000001uLL << 64 | 0x00000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL, (tu_int)0x0000000100000001uLL << 64 | 0x0000000100000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL, (tu_int)0x0000000100000001uLL << 64 | 0x0000000100000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL, (tu_int)0x0000000100000001uLL << 64 | 0x0000000180000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL, (tu_int)0x0000000100000001uLL << 64 | 0x00000001FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL, (tu_int)0x0000000100000001uLL << 64 | 0x8000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL, (tu_int)0x0000000100000001uLL << 64 | 0x8000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL, (tu_int)0x0000000100000001uLL << 64 | 0x8000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL, (tu_int)0x0000000100000001uLL << 64 | 0x80000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL, (tu_int)0x0000000100000001uLL << 64 | 0xFFFFFFFF00000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL, (tu_int)0x0000000100000001uLL << 64 | 0xFFFFFFFF00000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL, (tu_int)0x0000000100000001uLL << 64 | 0xFFFFFFFF80000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL, (tu_int)0x0000000100000001uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL, (tu_int)0x0000000180000000uLL << 64 | 0x0000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL, (tu_int)0x0000000180000000uLL << 64 | 0x0000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL, (tu_int)0x0000000180000000uLL << 64 | 0x0000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL, (tu_int)0x0000000180000000uLL << 64 | 0x00000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL, (tu_int)0x0000000180000000uLL << 64 | 0x0000000100000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL, (tu_int)0x0000000180000000uLL << 64 | 0x0000000100000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL, (tu_int)0x0000000180000000uLL << 64 | 0x0000000180000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL, (tu_int)0x0000000180000000uLL << 64 | 0x00000001FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL, (tu_int)0x0000000180000000uLL << 64 | 0x8000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL, (tu_int)0x0000000180000000uLL << 64 | 0x8000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL, (tu_int)0x0000000180000000uLL << 64 | 0x8000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL, (tu_int)0x0000000180000000uLL << 64 | 0x80000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL, (tu_int)0x0000000180000000uLL << 64 | 0xFFFFFFFF00000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL, (tu_int)0x0000000180000000uLL << 64 | 0xFFFFFFFF00000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL, (tu_int)0x0000000180000000uLL << 64 | 0xFFFFFFFF80000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL, (tu_int)0x0000000180000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL, (tu_int)0x00000001FFFFFFFFuLL << 64 | 0x0000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL, (tu_int)0x00000001FFFFFFFFuLL << 64 | 0x0000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL, (tu_int)0x00000001FFFFFFFFuLL << 64 | 0x0000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL, (tu_int)0x00000001FFFFFFFFuLL << 64 | 0x00000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL, (tu_int)0x00000001FFFFFFFFuLL << 64 | 0x0000000100000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL, (tu_int)0x00000001FFFFFFFFuLL << 64 | 0x0000000100000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL, (tu_int)0x00000001FFFFFFFFuLL << 64 | 0x0000000180000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL, (tu_int)0x00000001FFFFFFFFuLL << 64 | 0x00000001FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL, (tu_int)0x00000001FFFFFFFFuLL << 64 | 0x8000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL, (tu_int)0x00000001FFFFFFFFuLL << 64 | 0x8000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL, (tu_int)0x00000001FFFFFFFFuLL << 64 | 0x8000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL, (tu_int)0x00000001FFFFFFFFuLL << 64 | 0x80000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL, (tu_int)0x00000001FFFFFFFFuLL << 64 | 0xFFFFFFFF00000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL, (tu_int)0x00000001FFFFFFFFuLL << 64 | 0xFFFFFFFF00000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL, (tu_int)0x00000001FFFFFFFFuLL << 64 | 0xFFFFFFFF80000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL, (tu_int)0x00000001FFFFFFFFuLL << 64 | 0xFFFFFFFFFFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL, (tu_int)0x8000000000000000uLL << 64 | 0x0000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL, (tu_int)0x8000000000000000uLL << 64 | 0x0000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL, (tu_int)0x8000000000000000uLL << 64 | 0x0000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL, (tu_int)0x8000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL, (tu_int)0x8000000000000000uLL << 64 | 0x0000000100000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL, (tu_int)0x8000000000000000uLL << 64 | 0x0000000100000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL, (tu_int)0x8000000000000000uLL << 64 | 0x0000000180000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL, (tu_int)0x8000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL, (tu_int)0x8000000000000000uLL << 64 | 0x8000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL, (tu_int)0x8000000000000000uLL << 64 | 0x8000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL, (tu_int)0x8000000000000000uLL << 64 | 0x8000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL, (tu_int)0x8000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL, (tu_int)0x8000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL, (tu_int)0x8000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL, (tu_int)0x8000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL, (tu_int)0x8000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL, (tu_int)0x8000000000000001uLL << 64 | 0x0000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL, (tu_int)0x8000000000000001uLL << 64 | 0x0000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL, (tu_int)0x8000000000000001uLL << 64 | 0x0000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL, (tu_int)0x8000000000000001uLL << 64 | 0x00000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL, (tu_int)0x8000000000000001uLL << 64 | 0x0000000100000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL, (tu_int)0x8000000000000001uLL << 64 | 0x0000000100000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL, (tu_int)0x8000000000000001uLL << 64 | 0x0000000180000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL, (tu_int)0x8000000000000001uLL << 64 | 0x00000001FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL, (tu_int)0x8000000000000001uLL << 64 | 0x8000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL, (tu_int)0x8000000000000001uLL << 64 | 0x8000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL, (tu_int)0x8000000000000001uLL << 64 | 0x8000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL, (tu_int)0x8000000000000001uLL << 64 | 0x80000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL, (tu_int)0x8000000000000001uLL << 64 | 0xFFFFFFFF00000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL, (tu_int)0x8000000000000001uLL << 64 | 0xFFFFFFFF00000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL, (tu_int)0x8000000000000001uLL << 64 | 0xFFFFFFFF80000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL, (tu_int)0x8000000000000001uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL, (tu_int)0x8000000080000000uLL << 64 | 0x0000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL, (tu_int)0x8000000080000000uLL << 64 | 0x0000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL, (tu_int)0x8000000080000000uLL << 64 | 0x0000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL, (tu_int)0x8000000080000000uLL << 64 | 0x00000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL, (tu_int)0x8000000080000000uLL << 64 | 0x0000000100000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL, (tu_int)0x8000000080000000uLL << 64 | 0x0000000100000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL, (tu_int)0x8000000080000000uLL << 64 | 0x0000000180000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL, (tu_int)0x8000000080000000uLL << 64 | 0x00000001FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL, (tu_int)0x8000000080000000uLL << 64 | 0x8000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL, (tu_int)0x8000000080000000uLL << 64 | 0x8000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL, (tu_int)0x8000000080000000uLL << 64 | 0x8000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL, (tu_int)0x8000000080000000uLL << 64 | 0x80000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL, (tu_int)0x8000000080000000uLL << 64 | 0xFFFFFFFF00000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL, (tu_int)0x8000000080000000uLL << 64 | 0xFFFFFFFF00000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL, (tu_int)0x8000000080000000uLL << 64 | 0xFFFFFFFF80000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL, (tu_int)0x8000000080000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL, (tu_int)0x80000000FFFFFFFFuLL << 64 | 0x0000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL, (tu_int)0x80000000FFFFFFFFuLL << 64 | 0x0000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL, (tu_int)0x80000000FFFFFFFFuLL << 64 | 0x0000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL, (tu_int)0x80000000FFFFFFFFuLL << 64 | 0x00000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL, (tu_int)0x80000000FFFFFFFFuLL << 64 | 0x0000000100000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL, (tu_int)0x80000000FFFFFFFFuLL << 64 | 0x0000000100000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL, (tu_int)0x80000000FFFFFFFFuLL << 64 | 0x0000000180000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL, (tu_int)0x80000000FFFFFFFFuLL << 64 | 0x00000001FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL, (tu_int)0x80000000FFFFFFFFuLL << 64 | 0x8000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL, (tu_int)0x80000000FFFFFFFFuLL << 64 | 0x8000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL, (tu_int)0x80000000FFFFFFFFuLL << 64 | 0x8000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL, (tu_int)0x80000000FFFFFFFFuLL << 64 | 0x80000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL, (tu_int)0x80000000FFFFFFFFuLL << 64 | 0xFFFFFFFF00000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL, (tu_int)0x80000000FFFFFFFFuLL << 64 | 0xFFFFFFFF00000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL, (tu_int)0x80000000FFFFFFFFuLL << 64 | 0xFFFFFFFF80000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL, (tu_int)0x80000000FFFFFFFFuLL << 64 | 0xFFFFFFFFFFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL, (tu_int)0xFFFFFFFF00000000uLL << 64 | 0x0000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL, (tu_int)0xFFFFFFFF00000000uLL << 64 | 0x0000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL, (tu_int)0xFFFFFFFF00000000uLL << 64 | 0x0000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL, (tu_int)0xFFFFFFFF00000000uLL << 64 | 0x00000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL, (tu_int)0xFFFFFFFF00000000uLL << 64 | 0x0000000100000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL, (tu_int)0xFFFFFFFF00000000uLL << 64 | 0x0000000100000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL, (tu_int)0xFFFFFFFF00000000uLL << 64 | 0x0000000180000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL, (tu_int)0xFFFFFFFF00000000uLL << 64 | 0x00000001FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL, (tu_int)0xFFFFFFFF00000000uLL << 64 | 0x8000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL, (tu_int)0xFFFFFFFF00000000uLL << 64 | 0x8000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL, (tu_int)0xFFFFFFFF00000000uLL << 64 | 0x8000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL, (tu_int)0xFFFFFFFF00000000uLL << 64 | 0x80000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL, (tu_int)0xFFFFFFFF00000000uLL << 64 | 0xFFFFFFFF00000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL, (tu_int)0xFFFFFFFF00000000uLL << 64 | 0xFFFFFFFF00000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL, (tu_int)0xFFFFFFFF00000000uLL << 64 | 0xFFFFFFFF80000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL, (tu_int)0xFFFFFFFF00000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL, (tu_int)0xFFFFFFFF00000001uLL << 64 | 0x0000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL, (tu_int)0xFFFFFFFF00000001uLL << 64 | 0x0000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL, (tu_int)0xFFFFFFFF00000001uLL << 64 | 0x0000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL, (tu_int)0xFFFFFFFF00000001uLL << 64 | 0x00000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL, (tu_int)0xFFFFFFFF00000001uLL << 64 | 0x0000000100000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL, (tu_int)0xFFFFFFFF00000001uLL << 64 | 0x0000000100000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL, (tu_int)0xFFFFFFFF00000001uLL << 64 | 0x0000000180000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL, (tu_int)0xFFFFFFFF00000001uLL << 64 | 0x00000001FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL, (tu_int)0xFFFFFFFF00000001uLL << 64 | 0x8000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL, (tu_int)0xFFFFFFFF00000001uLL << 64 | 0x8000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL, (tu_int)0xFFFFFFFF00000001uLL << 64 | 0x8000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL, (tu_int)0xFFFFFFFF00000001uLL << 64 | 0x80000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL, (tu_int)0xFFFFFFFF00000001uLL << 64 | 0xFFFFFFFF00000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL, (tu_int)0xFFFFFFFF00000001uLL << 64 | 0xFFFFFFFF00000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL, (tu_int)0xFFFFFFFF00000001uLL << 64 | 0xFFFFFFFF80000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL, (tu_int)0xFFFFFFFF00000001uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL, (tu_int)0xFFFFFFFF80000000uLL << 64 | 0x0000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL, (tu_int)0xFFFFFFFF80000000uLL << 64 | 0x0000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL, (tu_int)0xFFFFFFFF80000000uLL << 64 | 0x0000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL, (tu_int)0xFFFFFFFF80000000uLL << 64 | 0x00000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL, (tu_int)0xFFFFFFFF80000000uLL << 64 | 0x0000000100000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL, (tu_int)0xFFFFFFFF80000000uLL << 64 | 0x0000000100000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL, (tu_int)0xFFFFFFFF80000000uLL << 64 | 0x0000000180000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL, (tu_int)0xFFFFFFFF80000000uLL << 64 | 0x00000001FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL, (tu_int)0xFFFFFFFF80000000uLL << 64 | 0x8000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL, (tu_int)0xFFFFFFFF80000000uLL << 64 | 0x8000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL, (tu_int)0xFFFFFFFF80000000uLL << 64 | 0x8000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL, (tu_int)0xFFFFFFFF80000000uLL << 64 | 0x80000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL, (tu_int)0xFFFFFFFF80000000uLL << 64 | 0xFFFFFFFF00000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL, (tu_int)0xFFFFFFFF80000000uLL << 64 | 0xFFFFFFFF00000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL, (tu_int)0xFFFFFFFF80000000uLL << 64 | 0xFFFFFFFF80000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL, (tu_int)0xFFFFFFFF80000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL, (tu_int)0xFFFFFFFFFFFFFFFFuLL << 64 | 0x0000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL, (tu_int)0xFFFFFFFFFFFFFFFFuLL << 64 | 0x0000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL, (tu_int)0xFFFFFFFFFFFFFFFFuLL << 64 | 0x0000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL, (tu_int)0xFFFFFFFFFFFFFFFFuLL << 64 | 0x00000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL, (tu_int)0xFFFFFFFFFFFFFFFFuLL << 64 | 0x0000000100000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL, (tu_int)0xFFFFFFFFFFFFFFFFuLL << 64 | 0x0000000100000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL, (tu_int)0xFFFFFFFFFFFFFFFFuLL << 64 | 0x0000000180000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL, (tu_int)0xFFFFFFFFFFFFFFFFuLL << 64 | 0x00000001FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL, (tu_int)0xFFFFFFFFFFFFFFFFuLL << 64 | 0x8000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL, (tu_int)0xFFFFFFFFFFFFFFFFuLL << 64 | 0x8000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL, (tu_int)0xFFFFFFFFFFFFFFFFuLL << 64 | 0x8000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL, (tu_int)0xFFFFFFFFFFFFFFFFuLL << 64 | 0x80000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL, (tu_int)0xFFFFFFFFFFFFFFFFuLL << 64 | 0xFFFFFFFF00000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL, (tu_int)0xFFFFFFFFFFFFFFFFuLL << 64 | 0xFFFFFFFF00000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL, (tu_int)0xFFFFFFFFFFFFFFFFuLL << 64 | 0xFFFFFFFF80000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL, (tu_int)0xFFFFFFFFFFFFFFFFuLL << 64 | 0xFFFFFFFFFFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000003uLL, (tu_int)0x0000000000000000uLL << 64 | 0x000000007FFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000002uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFEuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL, (tu_int)0x0000000000000000uLL << 64 | 0x000000007FFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL, (tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL, (tu_int)0x0000000000000001uLL << 64 | 0x0000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL, (tu_int)0x0000000000000001uLL << 64 | 0x0000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL, (tu_int)0x0000000000000001uLL << 64 | 0x0000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL, (tu_int)0x0000000000000001uLL << 64 | 0x00000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL, (tu_int)0x0000000000000001uLL << 64 | 0x0000000100000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL, (tu_int)0x0000000000000001uLL << 64 | 0x0000000100000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL, (tu_int)0x0000000000000001uLL << 64 | 0x0000000180000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL, (tu_int)0x0000000000000001uLL << 64 | 0x00000001FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL, (tu_int)0x0000000000000001uLL << 64 | 0x8000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL, (tu_int)0x0000000000000001uLL << 64 | 0x8000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL, (tu_int)0x0000000000000001uLL << 64 | 0x8000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL, (tu_int)0x0000000000000001uLL << 64 | 0x80000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL, (tu_int)0x0000000000000001uLL << 64 | 0xFFFFFFFF00000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL, (tu_int)0x0000000000000001uLL << 64 | 0xFFFFFFFF00000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL, (tu_int)0x0000000000000001uLL << 64 | 0xFFFFFFFF80000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL, (tu_int)0x0000000000000001uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL, (tu_int)0x0000000080000000uLL << 64 | 0x0000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL, (tu_int)0x0000000080000000uLL << 64 | 0x0000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL, (tu_int)0x0000000080000000uLL << 64 | 0x0000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL, (tu_int)0x0000000080000000uLL << 64 | 0x00000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL, (tu_int)0x0000000080000000uLL << 64 | 0x0000000100000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL, (tu_int)0x0000000080000000uLL << 64 | 0x0000000100000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL, (tu_int)0x0000000080000000uLL << 64 | 0x0000000180000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL, (tu_int)0x0000000080000000uLL << 64 | 0x00000001FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL, (tu_int)0x0000000080000000uLL << 64 | 0x8000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL, (tu_int)0x0000000080000000uLL << 64 | 0x8000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL, (tu_int)0x0000000080000000uLL << 64 | 0x8000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL, (tu_int)0x0000000080000000uLL << 64 | 0x80000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL, (tu_int)0x0000000080000000uLL << 64 | 0xFFFFFFFF00000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL, (tu_int)0x0000000080000000uLL << 64 | 0xFFFFFFFF00000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL, (tu_int)0x0000000080000000uLL << 64 | 0xFFFFFFFF80000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL, (tu_int)0x0000000080000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL, (tu_int)0x00000000FFFFFFFFuLL << 64 | 0x0000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL, (tu_int)0x00000000FFFFFFFFuLL << 64 | 0x0000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL, (tu_int)0x00000000FFFFFFFFuLL << 64 | 0x0000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL, (tu_int)0x00000000FFFFFFFFuLL << 64 | 0x00000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL, (tu_int)0x00000000FFFFFFFFuLL << 64 | 0x0000000100000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL, (tu_int)0x00000000FFFFFFFFuLL << 64 | 0x0000000100000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL, (tu_int)0x00000000FFFFFFFFuLL << 64 | 0x0000000180000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL, (tu_int)0x00000000FFFFFFFFuLL << 64 | 0x00000001FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL, (tu_int)0x00000000FFFFFFFFuLL << 64 | 0x8000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL, (tu_int)0x00000000FFFFFFFFuLL << 64 | 0x8000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL, (tu_int)0x00000000FFFFFFFFuLL << 64 | 0x8000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL, (tu_int)0x00000000FFFFFFFFuLL << 64 | 0x80000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL, (tu_int)0x00000000FFFFFFFFuLL << 64 | 0xFFFFFFFF00000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL, (tu_int)0x00000000FFFFFFFFuLL << 64 | 0xFFFFFFFF00000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL, (tu_int)0x00000000FFFFFFFFuLL << 64 | 0xFFFFFFFF80000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL, (tu_int)0x00000000FFFFFFFFuLL << 64 | 0xFFFFFFFFFFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL, (tu_int)0x0000000100000000uLL << 64 | 0x0000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL, (tu_int)0x0000000100000000uLL << 64 | 0x0000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL, (tu_int)0x0000000100000000uLL << 64 | 0x0000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL, (tu_int)0x0000000100000000uLL << 64 | 0x00000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL, (tu_int)0x0000000100000000uLL << 64 | 0x0000000100000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL, (tu_int)0x0000000100000000uLL << 64 | 0x0000000100000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL, (tu_int)0x0000000100000000uLL << 64 | 0x0000000180000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL, (tu_int)0x0000000100000000uLL << 64 | 0x00000001FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL, (tu_int)0x0000000100000000uLL << 64 | 0x8000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL, (tu_int)0x0000000100000000uLL << 64 | 0x8000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL, (tu_int)0x0000000100000000uLL << 64 | 0x8000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL, (tu_int)0x0000000100000000uLL << 64 | 0x80000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL, (tu_int)0x0000000100000000uLL << 64 | 0xFFFFFFFF00000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL, (tu_int)0x0000000100000000uLL << 64 | 0xFFFFFFFF00000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL, (tu_int)0x0000000100000000uLL << 64 | 0xFFFFFFFF80000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL, (tu_int)0x0000000100000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL, (tu_int)0x0000000100000001uLL << 64 | 0x0000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL, (tu_int)0x0000000100000001uLL << 64 | 0x0000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL, (tu_int)0x0000000100000001uLL << 64 | 0x0000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL, (tu_int)0x0000000100000001uLL << 64 | 0x00000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL, (tu_int)0x0000000100000001uLL << 64 | 0x0000000100000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL, (tu_int)0x0000000100000001uLL << 64 | 0x0000000100000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL, (tu_int)0x0000000100000001uLL << 64 | 0x0000000180000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL, (tu_int)0x0000000100000001uLL << 64 | 0x00000001FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL, (tu_int)0x0000000100000001uLL << 64 | 0x8000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL, (tu_int)0x0000000100000001uLL << 64 | 0x8000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL, (tu_int)0x0000000100000001uLL << 64 | 0x8000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL, (tu_int)0x0000000100000001uLL << 64 | 0x80000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL, (tu_int)0x0000000100000001uLL << 64 | 0xFFFFFFFF00000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL, (tu_int)0x0000000100000001uLL << 64 | 0xFFFFFFFF00000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL, (tu_int)0x0000000100000001uLL << 64 | 0xFFFFFFFF80000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL, (tu_int)0x0000000100000001uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL, (tu_int)0x0000000180000000uLL << 64 | 0x0000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL, (tu_int)0x0000000180000000uLL << 64 | 0x0000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL, (tu_int)0x0000000180000000uLL << 64 | 0x0000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL, (tu_int)0x0000000180000000uLL << 64 | 0x00000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL, (tu_int)0x0000000180000000uLL << 64 | 0x0000000100000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL, (tu_int)0x0000000180000000uLL << 64 | 0x0000000100000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL, (tu_int)0x0000000180000000uLL << 64 | 0x0000000180000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL, (tu_int)0x0000000180000000uLL << 64 | 0x00000001FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL, (tu_int)0x0000000180000000uLL << 64 | 0x8000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL, (tu_int)0x0000000180000000uLL << 64 | 0x8000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL, (tu_int)0x0000000180000000uLL << 64 | 0x8000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL, (tu_int)0x0000000180000000uLL << 64 | 0x80000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL, (tu_int)0x0000000180000000uLL << 64 | 0xFFFFFFFF00000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL, (tu_int)0x0000000180000000uLL << 64 | 0xFFFFFFFF00000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL, (tu_int)0x0000000180000000uLL << 64 | 0xFFFFFFFF80000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL, (tu_int)0x0000000180000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL, (tu_int)0x00000001FFFFFFFFuLL << 64 | 0x0000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL, (tu_int)0x00000001FFFFFFFFuLL << 64 | 0x0000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL, (tu_int)0x00000001FFFFFFFFuLL << 64 | 0x0000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL, (tu_int)0x00000001FFFFFFFFuLL << 64 | 0x00000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL, (tu_int)0x00000001FFFFFFFFuLL << 64 | 0x0000000100000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL, (tu_int)0x00000001FFFFFFFFuLL << 64 | 0x0000000100000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL, (tu_int)0x00000001FFFFFFFFuLL << 64 | 0x0000000180000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL, (tu_int)0x00000001FFFFFFFFuLL << 64 | 0x00000001FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL, (tu_int)0x00000001FFFFFFFFuLL << 64 | 0x8000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL, (tu_int)0x00000001FFFFFFFFuLL << 64 | 0x8000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL, (tu_int)0x00000001FFFFFFFFuLL << 64 | 0x8000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL, (tu_int)0x00000001FFFFFFFFuLL << 64 | 0x80000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL, (tu_int)0x00000001FFFFFFFFuLL << 64 | 0xFFFFFFFF00000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL, (tu_int)0x00000001FFFFFFFFuLL << 64 | 0xFFFFFFFF00000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL, (tu_int)0x00000001FFFFFFFFuLL << 64 | 0xFFFFFFFF80000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL, (tu_int)0x00000001FFFFFFFFuLL << 64 | 0xFFFFFFFFFFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL, (tu_int)0x8000000000000000uLL << 64 | 0x0000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL, (tu_int)0x8000000000000000uLL << 64 | 0x0000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL, (tu_int)0x8000000000000000uLL << 64 | 0x0000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL, (tu_int)0x8000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL, (tu_int)0x8000000000000000uLL << 64 | 0x0000000100000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL, (tu_int)0x8000000000000000uLL << 64 | 0x0000000100000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL, (tu_int)0x8000000000000000uLL << 64 | 0x0000000180000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL, (tu_int)0x8000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL, (tu_int)0x8000000000000000uLL << 64 | 0x8000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL, (tu_int)0x8000000000000000uLL << 64 | 0x8000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL, (tu_int)0x8000000000000000uLL << 64 | 0x8000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL, (tu_int)0x8000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL, (tu_int)0x8000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL, (tu_int)0x8000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL, (tu_int)0x8000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL, (tu_int)0x8000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL, (tu_int)0x8000000000000001uLL << 64 | 0x0000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL, (tu_int)0x8000000000000001uLL << 64 | 0x0000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL, (tu_int)0x8000000000000001uLL << 64 | 0x0000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL, (tu_int)0x8000000000000001uLL << 64 | 0x00000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL, (tu_int)0x8000000000000001uLL << 64 | 0x0000000100000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL, (tu_int)0x8000000000000001uLL << 64 | 0x0000000100000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL, (tu_int)0x8000000000000001uLL << 64 | 0x0000000180000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL, (tu_int)0x8000000000000001uLL << 64 | 0x00000001FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL, (tu_int)0x8000000000000001uLL << 64 | 0x8000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL, (tu_int)0x8000000000000001uLL << 64 | 0x8000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL, (tu_int)0x8000000000000001uLL << 64 | 0x8000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL, (tu_int)0x8000000000000001uLL << 64 | 0x80000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL, (tu_int)0x8000000000000001uLL << 64 | 0xFFFFFFFF00000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL, (tu_int)0x8000000000000001uLL << 64 | 0xFFFFFFFF00000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL, (tu_int)0x8000000000000001uLL << 64 | 0xFFFFFFFF80000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL, (tu_int)0x8000000000000001uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL, (tu_int)0x8000000080000000uLL << 64 | 0x0000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL, (tu_int)0x8000000080000000uLL << 64 | 0x0000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL, (tu_int)0x8000000080000000uLL << 64 | 0x0000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL, (tu_int)0x8000000080000000uLL << 64 | 0x00000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL, (tu_int)0x8000000080000000uLL << 64 | 0x0000000100000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL, (tu_int)0x8000000080000000uLL << 64 | 0x0000000100000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL, (tu_int)0x8000000080000000uLL << 64 | 0x0000000180000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL, (tu_int)0x8000000080000000uLL << 64 | 0x00000001FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL, (tu_int)0x8000000080000000uLL << 64 | 0x8000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL, (tu_int)0x8000000080000000uLL << 64 | 0x8000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL, (tu_int)0x8000000080000000uLL << 64 | 0x8000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL, (tu_int)0x8000000080000000uLL << 64 | 0x80000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL, (tu_int)0x8000000080000000uLL << 64 | 0xFFFFFFFF00000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL, (tu_int)0x8000000080000000uLL << 64 | 0xFFFFFFFF00000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL, (tu_int)0x8000000080000000uLL << 64 | 0xFFFFFFFF80000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL, (tu_int)0x8000000080000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL, (tu_int)0x80000000FFFFFFFFuLL << 64 | 0x0000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL, (tu_int)0x80000000FFFFFFFFuLL << 64 | 0x0000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL, (tu_int)0x80000000FFFFFFFFuLL << 64 | 0x0000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL, (tu_int)0x80000000FFFFFFFFuLL << 64 | 0x00000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL, (tu_int)0x80000000FFFFFFFFuLL << 64 | 0x0000000100000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL, (tu_int)0x80000000FFFFFFFFuLL << 64 | 0x0000000100000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL, (tu_int)0x80000000FFFFFFFFuLL << 64 | 0x0000000180000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL, (tu_int)0x80000000FFFFFFFFuLL << 64 | 0x00000001FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL, (tu_int)0x80000000FFFFFFFFuLL << 64 | 0x8000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL, (tu_int)0x80000000FFFFFFFFuLL << 64 | 0x8000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL, (tu_int)0x80000000FFFFFFFFuLL << 64 | 0x8000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL, (tu_int)0x80000000FFFFFFFFuLL << 64 | 0x80000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL, (tu_int)0x80000000FFFFFFFFuLL << 64 | 0xFFFFFFFF00000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL, (tu_int)0x80000000FFFFFFFFuLL << 64 | 0xFFFFFFFF00000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL, (tu_int)0x80000000FFFFFFFFuLL << 64 | 0xFFFFFFFF80000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL, (tu_int)0x80000000FFFFFFFFuLL << 64 | 0xFFFFFFFFFFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL, (tu_int)0xFFFFFFFF00000000uLL << 64 | 0x0000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL, (tu_int)0xFFFFFFFF00000000uLL << 64 | 0x0000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL, (tu_int)0xFFFFFFFF00000000uLL << 64 | 0x0000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL, (tu_int)0xFFFFFFFF00000000uLL << 64 | 0x00000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL, (tu_int)0xFFFFFFFF00000000uLL << 64 | 0x0000000100000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL, (tu_int)0xFFFFFFFF00000000uLL << 64 | 0x0000000100000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL, (tu_int)0xFFFFFFFF00000000uLL << 64 | 0x0000000180000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL, (tu_int)0xFFFFFFFF00000000uLL << 64 | 0x00000001FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL, (tu_int)0xFFFFFFFF00000000uLL << 64 | 0x8000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL, (tu_int)0xFFFFFFFF00000000uLL << 64 | 0x8000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL, (tu_int)0xFFFFFFFF00000000uLL << 64 | 0x8000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL, (tu_int)0xFFFFFFFF00000000uLL << 64 | 0x80000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL, (tu_int)0xFFFFFFFF00000000uLL << 64 | 0xFFFFFFFF00000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL, (tu_int)0xFFFFFFFF00000000uLL << 64 | 0xFFFFFFFF00000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL, (tu_int)0xFFFFFFFF00000000uLL << 64 | 0xFFFFFFFF80000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL, (tu_int)0xFFFFFFFF00000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL, (tu_int)0xFFFFFFFF00000001uLL << 64 | 0x0000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL, (tu_int)0xFFFFFFFF00000001uLL << 64 | 0x0000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL, (tu_int)0xFFFFFFFF00000001uLL << 64 | 0x0000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL, (tu_int)0xFFFFFFFF00000001uLL << 64 | 0x00000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL, (tu_int)0xFFFFFFFF00000001uLL << 64 | 0x0000000100000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL, (tu_int)0xFFFFFFFF00000001uLL << 64 | 0x0000000100000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL, (tu_int)0xFFFFFFFF00000001uLL << 64 | 0x0000000180000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL, (tu_int)0xFFFFFFFF00000001uLL << 64 | 0x00000001FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL, (tu_int)0xFFFFFFFF00000001uLL << 64 | 0x8000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL, (tu_int)0xFFFFFFFF00000001uLL << 64 | 0x8000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL, (tu_int)0xFFFFFFFF00000001uLL << 64 | 0x8000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL, (tu_int)0xFFFFFFFF00000001uLL << 64 | 0x80000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL, (tu_int)0xFFFFFFFF00000001uLL << 64 | 0xFFFFFFFF00000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL, (tu_int)0xFFFFFFFF00000001uLL << 64 | 0xFFFFFFFF00000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL, (tu_int)0xFFFFFFFF00000001uLL << 64 | 0xFFFFFFFF80000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL, (tu_int)0xFFFFFFFF00000001uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL, (tu_int)0xFFFFFFFF80000000uLL << 64 | 0x0000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL, (tu_int)0xFFFFFFFF80000000uLL << 64 | 0x0000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL, (tu_int)0xFFFFFFFF80000000uLL << 64 | 0x0000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL, (tu_int)0xFFFFFFFF80000000uLL << 64 | 0x00000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL, (tu_int)0xFFFFFFFF80000000uLL << 64 | 0x0000000100000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL, (tu_int)0xFFFFFFFF80000000uLL << 64 | 0x0000000100000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL, (tu_int)0xFFFFFFFF80000000uLL << 64 | 0x0000000180000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL, (tu_int)0xFFFFFFFF80000000uLL << 64 | 0x00000001FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL, (tu_int)0xFFFFFFFF80000000uLL << 64 | 0x8000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL, (tu_int)0xFFFFFFFF80000000uLL << 64 | 0x8000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL, (tu_int)0xFFFFFFFF80000000uLL << 64 | 0x8000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL, (tu_int)0xFFFFFFFF80000000uLL << 64 | 0x80000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL, (tu_int)0xFFFFFFFF80000000uLL << 64 | 0xFFFFFFFF00000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL, (tu_int)0xFFFFFFFF80000000uLL << 64 | 0xFFFFFFFF00000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL, (tu_int)0xFFFFFFFF80000000uLL << 64 | 0xFFFFFFFF80000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL, (tu_int)0xFFFFFFFF80000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL, (tu_int)0xFFFFFFFFFFFFFFFFuLL << 64 | 0x0000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL, (tu_int)0xFFFFFFFFFFFFFFFFuLL << 64 | 0x0000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL, (tu_int)0xFFFFFFFFFFFFFFFFuLL << 64 | 0x0000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL, (tu_int)0xFFFFFFFFFFFFFFFFuLL << 64 | 0x00000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL, (tu_int)0xFFFFFFFFFFFFFFFFuLL << 64 | 0x0000000100000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL, (tu_int)0xFFFFFFFFFFFFFFFFuLL << 64 | 0x0000000100000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL, (tu_int)0xFFFFFFFFFFFFFFFFuLL << 64 | 0x0000000180000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL, (tu_int)0xFFFFFFFFFFFFFFFFuLL << 64 | 0x00000001FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL, (tu_int)0xFFFFFFFFFFFFFFFFuLL << 64 | 0x8000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL, (tu_int)0xFFFFFFFFFFFFFFFFuLL << 64 | 0x8000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL, (tu_int)0xFFFFFFFFFFFFFFFFuLL << 64 | 0x8000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL, (tu_int)0xFFFFFFFFFFFFFFFFuLL << 64 | 0x80000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL, (tu_int)0xFFFFFFFFFFFFFFFFuLL << 64 | 0xFFFFFFFF00000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL, (tu_int)0xFFFFFFFFFFFFFFFFuLL << 64 | 0xFFFFFFFF00000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL, (tu_int)0xFFFFFFFFFFFFFFFFuLL << 64 | 0xFFFFFFFF80000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL, (tu_int)0xFFFFFFFFFFFFFFFFuLL << 64 | 0xFFFFFFFFFFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x000000007FFFFFFFuLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000080000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000055555555uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000040000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000040000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL, (tu_int)0x0000000000000001uLL << 64 | 0x0000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL, (tu_int)0x0000000000000001uLL << 64 | 0x0000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL, (tu_int)0x0000000000000001uLL << 64 | 0x0000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL, (tu_int)0x0000000000000001uLL << 64 | 0x00000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL, (tu_int)0x0000000000000001uLL << 64 | 0x0000000100000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL, (tu_int)0x0000000000000001uLL << 64 | 0x0000000100000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL, (tu_int)0x0000000000000001uLL << 64 | 0x0000000180000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL, (tu_int)0x0000000000000001uLL << 64 | 0x00000001FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL, (tu_int)0x0000000000000001uLL << 64 | 0x8000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL, (tu_int)0x0000000000000001uLL << 64 | 0x8000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL, (tu_int)0x0000000000000001uLL << 64 | 0x8000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL, (tu_int)0x0000000000000001uLL << 64 | 0x80000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL, (tu_int)0x0000000000000001uLL << 64 | 0xFFFFFFFF00000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL, (tu_int)0x0000000000000001uLL << 64 | 0xFFFFFFFF00000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL, (tu_int)0x0000000000000001uLL << 64 | 0xFFFFFFFF80000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL, (tu_int)0x0000000000000001uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL, (tu_int)0x0000000080000000uLL << 64 | 0x0000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL, (tu_int)0x0000000080000000uLL << 64 | 0x0000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL, (tu_int)0x0000000080000000uLL << 64 | 0x0000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL, (tu_int)0x0000000080000000uLL << 64 | 0x00000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL, (tu_int)0x0000000080000000uLL << 64 | 0x0000000100000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL, (tu_int)0x0000000080000000uLL << 64 | 0x0000000100000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL, (tu_int)0x0000000080000000uLL << 64 | 0x0000000180000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL, (tu_int)0x0000000080000000uLL << 64 | 0x00000001FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL, (tu_int)0x0000000080000000uLL << 64 | 0x8000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL, (tu_int)0x0000000080000000uLL << 64 | 0x8000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL, (tu_int)0x0000000080000000uLL << 64 | 0x8000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL, (tu_int)0x0000000080000000uLL << 64 | 0x80000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL, (tu_int)0x0000000080000000uLL << 64 | 0xFFFFFFFF00000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL, (tu_int)0x0000000080000000uLL << 64 | 0xFFFFFFFF00000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL, (tu_int)0x0000000080000000uLL << 64 | 0xFFFFFFFF80000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL, (tu_int)0x0000000080000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL, (tu_int)0x00000000FFFFFFFFuLL << 64 | 0x0000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL, (tu_int)0x00000000FFFFFFFFuLL << 64 | 0x0000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL, (tu_int)0x00000000FFFFFFFFuLL << 64 | 0x0000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL, (tu_int)0x00000000FFFFFFFFuLL << 64 | 0x00000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL, (tu_int)0x00000000FFFFFFFFuLL << 64 | 0x0000000100000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL, (tu_int)0x00000000FFFFFFFFuLL << 64 | 0x0000000100000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL, (tu_int)0x00000000FFFFFFFFuLL << 64 | 0x0000000180000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL, (tu_int)0x00000000FFFFFFFFuLL << 64 | 0x00000001FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL, (tu_int)0x00000000FFFFFFFFuLL << 64 | 0x8000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL, (tu_int)0x00000000FFFFFFFFuLL << 64 | 0x8000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL, (tu_int)0x00000000FFFFFFFFuLL << 64 | 0x8000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL, (tu_int)0x00000000FFFFFFFFuLL << 64 | 0x80000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL, (tu_int)0x00000000FFFFFFFFuLL << 64 | 0xFFFFFFFF00000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL, (tu_int)0x00000000FFFFFFFFuLL << 64 | 0xFFFFFFFF00000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL, (tu_int)0x00000000FFFFFFFFuLL << 64 | 0xFFFFFFFF80000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL, (tu_int)0x00000000FFFFFFFFuLL << 64 | 0xFFFFFFFFFFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL, (tu_int)0x0000000100000000uLL << 64 | 0x0000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL, (tu_int)0x0000000100000000uLL << 64 | 0x0000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL, (tu_int)0x0000000100000000uLL << 64 | 0x0000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL, (tu_int)0x0000000100000000uLL << 64 | 0x00000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL, (tu_int)0x0000000100000000uLL << 64 | 0x0000000100000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL, (tu_int)0x0000000100000000uLL << 64 | 0x0000000100000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL, (tu_int)0x0000000100000000uLL << 64 | 0x0000000180000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL, (tu_int)0x0000000100000000uLL << 64 | 0x00000001FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL, (tu_int)0x0000000100000000uLL << 64 | 0x8000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL, (tu_int)0x0000000100000000uLL << 64 | 0x8000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL, (tu_int)0x0000000100000000uLL << 64 | 0x8000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL, (tu_int)0x0000000100000000uLL << 64 | 0x80000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL, (tu_int)0x0000000100000000uLL << 64 | 0xFFFFFFFF00000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL, (tu_int)0x0000000100000000uLL << 64 | 0xFFFFFFFF00000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL, (tu_int)0x0000000100000000uLL << 64 | 0xFFFFFFFF80000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL, (tu_int)0x0000000100000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL, (tu_int)0x0000000100000001uLL << 64 | 0x0000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL, (tu_int)0x0000000100000001uLL << 64 | 0x0000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL, (tu_int)0x0000000100000001uLL << 64 | 0x0000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL, (tu_int)0x0000000100000001uLL << 64 | 0x00000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL, (tu_int)0x0000000100000001uLL << 64 | 0x0000000100000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL, (tu_int)0x0000000100000001uLL << 64 | 0x0000000100000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL, (tu_int)0x0000000100000001uLL << 64 | 0x0000000180000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL, (tu_int)0x0000000100000001uLL << 64 | 0x00000001FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL, (tu_int)0x0000000100000001uLL << 64 | 0x8000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL, (tu_int)0x0000000100000001uLL << 64 | 0x8000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL, (tu_int)0x0000000100000001uLL << 64 | 0x8000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL, (tu_int)0x0000000100000001uLL << 64 | 0x80000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL, (tu_int)0x0000000100000001uLL << 64 | 0xFFFFFFFF00000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL, (tu_int)0x0000000100000001uLL << 64 | 0xFFFFFFFF00000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL, (tu_int)0x0000000100000001uLL << 64 | 0xFFFFFFFF80000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL, (tu_int)0x0000000100000001uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL, (tu_int)0x0000000180000000uLL << 64 | 0x0000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL, (tu_int)0x0000000180000000uLL << 64 | 0x0000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL, (tu_int)0x0000000180000000uLL << 64 | 0x0000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL, (tu_int)0x0000000180000000uLL << 64 | 0x00000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL, (tu_int)0x0000000180000000uLL << 64 | 0x0000000100000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL, (tu_int)0x0000000180000000uLL << 64 | 0x0000000100000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL, (tu_int)0x0000000180000000uLL << 64 | 0x0000000180000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL, (tu_int)0x0000000180000000uLL << 64 | 0x00000001FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL, (tu_int)0x0000000180000000uLL << 64 | 0x8000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL, (tu_int)0x0000000180000000uLL << 64 | 0x8000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL, (tu_int)0x0000000180000000uLL << 64 | 0x8000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL, (tu_int)0x0000000180000000uLL << 64 | 0x80000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL, (tu_int)0x0000000180000000uLL << 64 | 0xFFFFFFFF00000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL, (tu_int)0x0000000180000000uLL << 64 | 0xFFFFFFFF00000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL, (tu_int)0x0000000180000000uLL << 64 | 0xFFFFFFFF80000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL, (tu_int)0x0000000180000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL, (tu_int)0x00000001FFFFFFFFuLL << 64 | 0x0000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL, (tu_int)0x00000001FFFFFFFFuLL << 64 | 0x0000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL, (tu_int)0x00000001FFFFFFFFuLL << 64 | 0x0000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL, (tu_int)0x00000001FFFFFFFFuLL << 64 | 0x00000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL, (tu_int)0x00000001FFFFFFFFuLL << 64 | 0x0000000100000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL, (tu_int)0x00000001FFFFFFFFuLL << 64 | 0x0000000100000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL, (tu_int)0x00000001FFFFFFFFuLL << 64 | 0x0000000180000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL, (tu_int)0x00000001FFFFFFFFuLL << 64 | 0x00000001FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL, (tu_int)0x00000001FFFFFFFFuLL << 64 | 0x8000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL, (tu_int)0x00000001FFFFFFFFuLL << 64 | 0x8000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL, (tu_int)0x00000001FFFFFFFFuLL << 64 | 0x8000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL, (tu_int)0x00000001FFFFFFFFuLL << 64 | 0x80000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL, (tu_int)0x00000001FFFFFFFFuLL << 64 | 0xFFFFFFFF00000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL, (tu_int)0x00000001FFFFFFFFuLL << 64 | 0xFFFFFFFF00000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL, (tu_int)0x00000001FFFFFFFFuLL << 64 | 0xFFFFFFFF80000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL, (tu_int)0x00000001FFFFFFFFuLL << 64 | 0xFFFFFFFFFFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL, (tu_int)0x8000000000000000uLL << 64 | 0x0000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL, (tu_int)0x8000000000000000uLL << 64 | 0x0000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL, (tu_int)0x8000000000000000uLL << 64 | 0x0000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL, (tu_int)0x8000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL, (tu_int)0x8000000000000000uLL << 64 | 0x0000000100000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL, (tu_int)0x8000000000000000uLL << 64 | 0x0000000100000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL, (tu_int)0x8000000000000000uLL << 64 | 0x0000000180000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL, (tu_int)0x8000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL, (tu_int)0x8000000000000000uLL << 64 | 0x8000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL, (tu_int)0x8000000000000000uLL << 64 | 0x8000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL, (tu_int)0x8000000000000000uLL << 64 | 0x8000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL, (tu_int)0x8000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL, (tu_int)0x8000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL, (tu_int)0x8000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL, (tu_int)0x8000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL, (tu_int)0x8000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL, (tu_int)0x8000000000000001uLL << 64 | 0x0000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL, (tu_int)0x8000000000000001uLL << 64 | 0x0000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL, (tu_int)0x8000000000000001uLL << 64 | 0x0000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL, (tu_int)0x8000000000000001uLL << 64 | 0x00000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL, (tu_int)0x8000000000000001uLL << 64 | 0x0000000100000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL, (tu_int)0x8000000000000001uLL << 64 | 0x0000000100000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL, (tu_int)0x8000000000000001uLL << 64 | 0x0000000180000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL, (tu_int)0x8000000000000001uLL << 64 | 0x00000001FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL, (tu_int)0x8000000000000001uLL << 64 | 0x8000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL, (tu_int)0x8000000000000001uLL << 64 | 0x8000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL, (tu_int)0x8000000000000001uLL << 64 | 0x8000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL, (tu_int)0x8000000000000001uLL << 64 | 0x80000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL, (tu_int)0x8000000000000001uLL << 64 | 0xFFFFFFFF00000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL, (tu_int)0x8000000000000001uLL << 64 | 0xFFFFFFFF00000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL, (tu_int)0x8000000000000001uLL << 64 | 0xFFFFFFFF80000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL, (tu_int)0x8000000000000001uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL, (tu_int)0x8000000080000000uLL << 64 | 0x0000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL, (tu_int)0x8000000080000000uLL << 64 | 0x0000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL, (tu_int)0x8000000080000000uLL << 64 | 0x0000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL, (tu_int)0x8000000080000000uLL << 64 | 0x00000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL, (tu_int)0x8000000080000000uLL << 64 | 0x0000000100000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL, (tu_int)0x8000000080000000uLL << 64 | 0x0000000100000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL, (tu_int)0x8000000080000000uLL << 64 | 0x0000000180000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL, (tu_int)0x8000000080000000uLL << 64 | 0x00000001FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL, (tu_int)0x8000000080000000uLL << 64 | 0x8000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL, (tu_int)0x8000000080000000uLL << 64 | 0x8000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL, (tu_int)0x8000000080000000uLL << 64 | 0x8000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL, (tu_int)0x8000000080000000uLL << 64 | 0x80000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL, (tu_int)0x8000000080000000uLL << 64 | 0xFFFFFFFF00000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL, (tu_int)0x8000000080000000uLL << 64 | 0xFFFFFFFF00000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL, (tu_int)0x8000000080000000uLL << 64 | 0xFFFFFFFF80000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL, (tu_int)0x8000000080000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL, (tu_int)0x80000000FFFFFFFFuLL << 64 | 0x0000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL, (tu_int)0x80000000FFFFFFFFuLL << 64 | 0x0000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL, (tu_int)0x80000000FFFFFFFFuLL << 64 | 0x0000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL, (tu_int)0x80000000FFFFFFFFuLL << 64 | 0x00000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL, (tu_int)0x80000000FFFFFFFFuLL << 64 | 0x0000000100000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL, (tu_int)0x80000000FFFFFFFFuLL << 64 | 0x0000000100000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL, (tu_int)0x80000000FFFFFFFFuLL << 64 | 0x0000000180000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL, (tu_int)0x80000000FFFFFFFFuLL << 64 | 0x00000001FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL, (tu_int)0x80000000FFFFFFFFuLL << 64 | 0x8000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL, (tu_int)0x80000000FFFFFFFFuLL << 64 | 0x8000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL, (tu_int)0x80000000FFFFFFFFuLL << 64 | 0x8000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL, (tu_int)0x80000000FFFFFFFFuLL << 64 | 0x80000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL, (tu_int)0x80000000FFFFFFFFuLL << 64 | 0xFFFFFFFF00000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL, (tu_int)0x80000000FFFFFFFFuLL << 64 | 0xFFFFFFFF00000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL, (tu_int)0x80000000FFFFFFFFuLL << 64 | 0xFFFFFFFF80000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL, (tu_int)0x80000000FFFFFFFFuLL << 64 | 0xFFFFFFFFFFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL, (tu_int)0xFFFFFFFF00000000uLL << 64 | 0x0000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL, (tu_int)0xFFFFFFFF00000000uLL << 64 | 0x0000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL, (tu_int)0xFFFFFFFF00000000uLL << 64 | 0x0000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL, (tu_int)0xFFFFFFFF00000000uLL << 64 | 0x00000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL, (tu_int)0xFFFFFFFF00000000uLL << 64 | 0x0000000100000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL, (tu_int)0xFFFFFFFF00000000uLL << 64 | 0x0000000100000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL, (tu_int)0xFFFFFFFF00000000uLL << 64 | 0x0000000180000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL, (tu_int)0xFFFFFFFF00000000uLL << 64 | 0x00000001FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL, (tu_int)0xFFFFFFFF00000000uLL << 64 | 0x8000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL, (tu_int)0xFFFFFFFF00000000uLL << 64 | 0x8000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL, (tu_int)0xFFFFFFFF00000000uLL << 64 | 0x8000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL, (tu_int)0xFFFFFFFF00000000uLL << 64 | 0x80000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL, (tu_int)0xFFFFFFFF00000000uLL << 64 | 0xFFFFFFFF00000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL, (tu_int)0xFFFFFFFF00000000uLL << 64 | 0xFFFFFFFF00000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL, (tu_int)0xFFFFFFFF00000000uLL << 64 | 0xFFFFFFFF80000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL, (tu_int)0xFFFFFFFF00000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL, (tu_int)0xFFFFFFFF00000001uLL << 64 | 0x0000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL, (tu_int)0xFFFFFFFF00000001uLL << 64 | 0x0000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL, (tu_int)0xFFFFFFFF00000001uLL << 64 | 0x0000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL, (tu_int)0xFFFFFFFF00000001uLL << 64 | 0x00000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL, (tu_int)0xFFFFFFFF00000001uLL << 64 | 0x0000000100000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL, (tu_int)0xFFFFFFFF00000001uLL << 64 | 0x0000000100000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL, (tu_int)0xFFFFFFFF00000001uLL << 64 | 0x0000000180000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL, (tu_int)0xFFFFFFFF00000001uLL << 64 | 0x00000001FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL, (tu_int)0xFFFFFFFF00000001uLL << 64 | 0x8000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL, (tu_int)0xFFFFFFFF00000001uLL << 64 | 0x8000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL, (tu_int)0xFFFFFFFF00000001uLL << 64 | 0x8000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL, (tu_int)0xFFFFFFFF00000001uLL << 64 | 0x80000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL, (tu_int)0xFFFFFFFF00000001uLL << 64 | 0xFFFFFFFF00000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL, (tu_int)0xFFFFFFFF00000001uLL << 64 | 0xFFFFFFFF00000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL, (tu_int)0xFFFFFFFF00000001uLL << 64 | 0xFFFFFFFF80000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL, (tu_int)0xFFFFFFFF00000001uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL, (tu_int)0xFFFFFFFF80000000uLL << 64 | 0x0000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL, (tu_int)0xFFFFFFFF80000000uLL << 64 | 0x0000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL, (tu_int)0xFFFFFFFF80000000uLL << 64 | 0x0000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL, (tu_int)0xFFFFFFFF80000000uLL << 64 | 0x00000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL, (tu_int)0xFFFFFFFF80000000uLL << 64 | 0x0000000100000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL, (tu_int)0xFFFFFFFF80000000uLL << 64 | 0x0000000100000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL, (tu_int)0xFFFFFFFF80000000uLL << 64 | 0x0000000180000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL, (tu_int)0xFFFFFFFF80000000uLL << 64 | 0x00000001FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL, (tu_int)0xFFFFFFFF80000000uLL << 64 | 0x8000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL, (tu_int)0xFFFFFFFF80000000uLL << 64 | 0x8000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL, (tu_int)0xFFFFFFFF80000000uLL << 64 | 0x8000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL, (tu_int)0xFFFFFFFF80000000uLL << 64 | 0x80000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL, (tu_int)0xFFFFFFFF80000000uLL << 64 | 0xFFFFFFFF00000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL, (tu_int)0xFFFFFFFF80000000uLL << 64 | 0xFFFFFFFF00000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL, (tu_int)0xFFFFFFFF80000000uLL << 64 | 0xFFFFFFFF80000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL, (tu_int)0xFFFFFFFF80000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL, (tu_int)0xFFFFFFFFFFFFFFFFuLL << 64 | 0x0000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL, (tu_int)0xFFFFFFFFFFFFFFFFuLL << 64 | 0x0000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL, (tu_int)0xFFFFFFFFFFFFFFFFuLL << 64 | 0x0000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL, (tu_int)0xFFFFFFFFFFFFFFFFuLL << 64 | 0x00000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL, (tu_int)0xFFFFFFFFFFFFFFFFuLL << 64 | 0x0000000100000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL, (tu_int)0xFFFFFFFFFFFFFFFFuLL << 64 | 0x0000000100000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL, (tu_int)0xFFFFFFFFFFFFFFFFuLL << 64 | 0x0000000180000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL, (tu_int)0xFFFFFFFFFFFFFFFFuLL << 64 | 0x00000001FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL, (tu_int)0xFFFFFFFFFFFFFFFFuLL << 64 | 0x8000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL, (tu_int)0xFFFFFFFFFFFFFFFFuLL << 64 | 0x8000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL, (tu_int)0xFFFFFFFFFFFFFFFFuLL << 64 | 0x8000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL, (tu_int)0xFFFFFFFFFFFFFFFFuLL << 64 | 0x80000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL, (tu_int)0xFFFFFFFFFFFFFFFFuLL << 64 | 0xFFFFFFFF00000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL, (tu_int)0xFFFFFFFFFFFFFFFFuLL << 64 | 0xFFFFFFFF00000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL, (tu_int)0xFFFFFFFFFFFFFFFFuLL << 64 | 0xFFFFFFFF80000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL, (tu_int)0xFFFFFFFFFFFFFFFFuLL << 64 | 0xFFFFFFFFFFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000080000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x000000007FFFFFFFuLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000080000002uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000055555555uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000080000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000040000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000040000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL, (tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL, (tu_int)0x0000000000000001uLL << 64 | 0x0000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL, (tu_int)0x0000000000000001uLL << 64 | 0x0000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL, (tu_int)0x0000000000000001uLL << 64 | 0x0000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL, (tu_int)0x0000000000000001uLL << 64 | 0x00000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL, (tu_int)0x0000000000000001uLL << 64 | 0x0000000100000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL, (tu_int)0x0000000000000001uLL << 64 | 0x0000000100000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL, (tu_int)0x0000000000000001uLL << 64 | 0x0000000180000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL, (tu_int)0x0000000000000001uLL << 64 | 0x00000001FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL, (tu_int)0x0000000000000001uLL << 64 | 0x8000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL, (tu_int)0x0000000000000001uLL << 64 | 0x8000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL, (tu_int)0x0000000000000001uLL << 64 | 0x8000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL, (tu_int)0x0000000000000001uLL << 64 | 0x80000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL, (tu_int)0x0000000000000001uLL << 64 | 0xFFFFFFFF00000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL, (tu_int)0x0000000000000001uLL << 64 | 0xFFFFFFFF00000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL, (tu_int)0x0000000000000001uLL << 64 | 0xFFFFFFFF80000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL, (tu_int)0x0000000000000001uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL, (tu_int)0x0000000080000000uLL << 64 | 0x0000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL, (tu_int)0x0000000080000000uLL << 64 | 0x0000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL, (tu_int)0x0000000080000000uLL << 64 | 0x0000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL, (tu_int)0x0000000080000000uLL << 64 | 0x00000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL, (tu_int)0x0000000080000000uLL << 64 | 0x0000000100000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL, (tu_int)0x0000000080000000uLL << 64 | 0x0000000100000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL, (tu_int)0x0000000080000000uLL << 64 | 0x0000000180000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL, (tu_int)0x0000000080000000uLL << 64 | 0x00000001FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL, (tu_int)0x0000000080000000uLL << 64 | 0x8000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL, (tu_int)0x0000000080000000uLL << 64 | 0x8000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL, (tu_int)0x0000000080000000uLL << 64 | 0x8000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL, (tu_int)0x0000000080000000uLL << 64 | 0x80000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL, (tu_int)0x0000000080000000uLL << 64 | 0xFFFFFFFF00000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL, (tu_int)0x0000000080000000uLL << 64 | 0xFFFFFFFF00000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL, (tu_int)0x0000000080000000uLL << 64 | 0xFFFFFFFF80000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL, (tu_int)0x0000000080000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL, (tu_int)0x00000000FFFFFFFFuLL << 64 | 0x0000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL, (tu_int)0x00000000FFFFFFFFuLL << 64 | 0x0000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL, (tu_int)0x00000000FFFFFFFFuLL << 64 | 0x0000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL, (tu_int)0x00000000FFFFFFFFuLL << 64 | 0x00000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL, (tu_int)0x00000000FFFFFFFFuLL << 64 | 0x0000000100000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL, (tu_int)0x00000000FFFFFFFFuLL << 64 | 0x0000000100000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL, (tu_int)0x00000000FFFFFFFFuLL << 64 | 0x0000000180000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL, (tu_int)0x00000000FFFFFFFFuLL << 64 | 0x00000001FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL, (tu_int)0x00000000FFFFFFFFuLL << 64 | 0x8000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL, (tu_int)0x00000000FFFFFFFFuLL << 64 | 0x8000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL, (tu_int)0x00000000FFFFFFFFuLL << 64 | 0x8000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL, (tu_int)0x00000000FFFFFFFFuLL << 64 | 0x80000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL, (tu_int)0x00000000FFFFFFFFuLL << 64 | 0xFFFFFFFF00000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL, (tu_int)0x00000000FFFFFFFFuLL << 64 | 0xFFFFFFFF00000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL, (tu_int)0x00000000FFFFFFFFuLL << 64 | 0xFFFFFFFF80000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL, (tu_int)0x00000000FFFFFFFFuLL << 64 | 0xFFFFFFFFFFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL, (tu_int)0x0000000100000000uLL << 64 | 0x0000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL, (tu_int)0x0000000100000000uLL << 64 | 0x0000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL, (tu_int)0x0000000100000000uLL << 64 | 0x0000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL, (tu_int)0x0000000100000000uLL << 64 | 0x00000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL, (tu_int)0x0000000100000000uLL << 64 | 0x0000000100000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL, (tu_int)0x0000000100000000uLL << 64 | 0x0000000100000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL, (tu_int)0x0000000100000000uLL << 64 | 0x0000000180000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL, (tu_int)0x0000000100000000uLL << 64 | 0x00000001FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL, (tu_int)0x0000000100000000uLL << 64 | 0x8000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL, (tu_int)0x0000000100000000uLL << 64 | 0x8000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL, (tu_int)0x0000000100000000uLL << 64 | 0x8000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL, (tu_int)0x0000000100000000uLL << 64 | 0x80000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL, (tu_int)0x0000000100000000uLL << 64 | 0xFFFFFFFF00000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL, (tu_int)0x0000000100000000uLL << 64 | 0xFFFFFFFF00000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL, (tu_int)0x0000000100000000uLL << 64 | 0xFFFFFFFF80000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL, (tu_int)0x0000000100000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL, (tu_int)0x0000000100000001uLL << 64 | 0x0000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL, (tu_int)0x0000000100000001uLL << 64 | 0x0000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL, (tu_int)0x0000000100000001uLL << 64 | 0x0000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL, (tu_int)0x0000000100000001uLL << 64 | 0x00000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL, (tu_int)0x0000000100000001uLL << 64 | 0x0000000100000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL, (tu_int)0x0000000100000001uLL << 64 | 0x0000000100000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL, (tu_int)0x0000000100000001uLL << 64 | 0x0000000180000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL, (tu_int)0x0000000100000001uLL << 64 | 0x00000001FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL, (tu_int)0x0000000100000001uLL << 64 | 0x8000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL, (tu_int)0x0000000100000001uLL << 64 | 0x8000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL, (tu_int)0x0000000100000001uLL << 64 | 0x8000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL, (tu_int)0x0000000100000001uLL << 64 | 0x80000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL, (tu_int)0x0000000100000001uLL << 64 | 0xFFFFFFFF00000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL, (tu_int)0x0000000100000001uLL << 64 | 0xFFFFFFFF00000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL, (tu_int)0x0000000100000001uLL << 64 | 0xFFFFFFFF80000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL, (tu_int)0x0000000100000001uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL, (tu_int)0x0000000180000000uLL << 64 | 0x0000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL, (tu_int)0x0000000180000000uLL << 64 | 0x0000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL, (tu_int)0x0000000180000000uLL << 64 | 0x0000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL, (tu_int)0x0000000180000000uLL << 64 | 0x00000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL, (tu_int)0x0000000180000000uLL << 64 | 0x0000000100000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL, (tu_int)0x0000000180000000uLL << 64 | 0x0000000100000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL, (tu_int)0x0000000180000000uLL << 64 | 0x0000000180000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL, (tu_int)0x0000000180000000uLL << 64 | 0x00000001FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL, (tu_int)0x0000000180000000uLL << 64 | 0x8000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL, (tu_int)0x0000000180000000uLL << 64 | 0x8000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL, (tu_int)0x0000000180000000uLL << 64 | 0x8000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL, (tu_int)0x0000000180000000uLL << 64 | 0x80000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL, (tu_int)0x0000000180000000uLL << 64 | 0xFFFFFFFF00000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL, (tu_int)0x0000000180000000uLL << 64 | 0xFFFFFFFF00000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL, (tu_int)0x0000000180000000uLL << 64 | 0xFFFFFFFF80000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL, (tu_int)0x0000000180000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL, (tu_int)0x00000001FFFFFFFFuLL << 64 | 0x0000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL, (tu_int)0x00000001FFFFFFFFuLL << 64 | 0x0000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL, (tu_int)0x00000001FFFFFFFFuLL << 64 | 0x0000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL, (tu_int)0x00000001FFFFFFFFuLL << 64 | 0x00000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL, (tu_int)0x00000001FFFFFFFFuLL << 64 | 0x0000000100000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL, (tu_int)0x00000001FFFFFFFFuLL << 64 | 0x0000000100000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL, (tu_int)0x00000001FFFFFFFFuLL << 64 | 0x0000000180000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL, (tu_int)0x00000001FFFFFFFFuLL << 64 | 0x00000001FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL, (tu_int)0x00000001FFFFFFFFuLL << 64 | 0x8000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL, (tu_int)0x00000001FFFFFFFFuLL << 64 | 0x8000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL, (tu_int)0x00000001FFFFFFFFuLL << 64 | 0x8000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL, (tu_int)0x00000001FFFFFFFFuLL << 64 | 0x80000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL, (tu_int)0x00000001FFFFFFFFuLL << 64 | 0xFFFFFFFF00000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL, (tu_int)0x00000001FFFFFFFFuLL << 64 | 0xFFFFFFFF00000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL, (tu_int)0x00000001FFFFFFFFuLL << 64 | 0xFFFFFFFF80000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL, (tu_int)0x00000001FFFFFFFFuLL << 64 | 0xFFFFFFFFFFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL, (tu_int)0x8000000000000000uLL << 64 | 0x0000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL, (tu_int)0x8000000000000000uLL << 64 | 0x0000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL, (tu_int)0x8000000000000000uLL << 64 | 0x0000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL, (tu_int)0x8000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL, (tu_int)0x8000000000000000uLL << 64 | 0x0000000100000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL, (tu_int)0x8000000000000000uLL << 64 | 0x0000000100000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL, (tu_int)0x8000000000000000uLL << 64 | 0x0000000180000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL, (tu_int)0x8000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL, (tu_int)0x8000000000000000uLL << 64 | 0x8000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL, (tu_int)0x8000000000000000uLL << 64 | 0x8000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL, (tu_int)0x8000000000000000uLL << 64 | 0x8000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL, (tu_int)0x8000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL, (tu_int)0x8000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL, (tu_int)0x8000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL, (tu_int)0x8000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL, (tu_int)0x8000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL, (tu_int)0x8000000000000001uLL << 64 | 0x0000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL, (tu_int)0x8000000000000001uLL << 64 | 0x0000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL, (tu_int)0x8000000000000001uLL << 64 | 0x0000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL, (tu_int)0x8000000000000001uLL << 64 | 0x00000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL, (tu_int)0x8000000000000001uLL << 64 | 0x0000000100000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL, (tu_int)0x8000000000000001uLL << 64 | 0x0000000100000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL, (tu_int)0x8000000000000001uLL << 64 | 0x0000000180000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL, (tu_int)0x8000000000000001uLL << 64 | 0x00000001FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL, (tu_int)0x8000000000000001uLL << 64 | 0x8000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL, (tu_int)0x8000000000000001uLL << 64 | 0x8000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL, (tu_int)0x8000000000000001uLL << 64 | 0x8000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL, (tu_int)0x8000000000000001uLL << 64 | 0x80000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL, (tu_int)0x8000000000000001uLL << 64 | 0xFFFFFFFF00000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL, (tu_int)0x8000000000000001uLL << 64 | 0xFFFFFFFF00000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL, (tu_int)0x8000000000000001uLL << 64 | 0xFFFFFFFF80000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL, (tu_int)0x8000000000000001uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL, (tu_int)0x8000000080000000uLL << 64 | 0x0000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL, (tu_int)0x8000000080000000uLL << 64 | 0x0000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL, (tu_int)0x8000000080000000uLL << 64 | 0x0000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL, (tu_int)0x8000000080000000uLL << 64 | 0x00000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL, (tu_int)0x8000000080000000uLL << 64 | 0x0000000100000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL, (tu_int)0x8000000080000000uLL << 64 | 0x0000000100000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL, (tu_int)0x8000000080000000uLL << 64 | 0x0000000180000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL, (tu_int)0x8000000080000000uLL << 64 | 0x00000001FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL, (tu_int)0x8000000080000000uLL << 64 | 0x8000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL, (tu_int)0x8000000080000000uLL << 64 | 0x8000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL, (tu_int)0x8000000080000000uLL << 64 | 0x8000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL, (tu_int)0x8000000080000000uLL << 64 | 0x80000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL, (tu_int)0x8000000080000000uLL << 64 | 0xFFFFFFFF00000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL, (tu_int)0x8000000080000000uLL << 64 | 0xFFFFFFFF00000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL, (tu_int)0x8000000080000000uLL << 64 | 0xFFFFFFFF80000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL, (tu_int)0x8000000080000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL, (tu_int)0x80000000FFFFFFFFuLL << 64 | 0x0000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL, (tu_int)0x80000000FFFFFFFFuLL << 64 | 0x0000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL, (tu_int)0x80000000FFFFFFFFuLL << 64 | 0x0000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL, (tu_int)0x80000000FFFFFFFFuLL << 64 | 0x00000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL, (tu_int)0x80000000FFFFFFFFuLL << 64 | 0x0000000100000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL, (tu_int)0x80000000FFFFFFFFuLL << 64 | 0x0000000100000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL, (tu_int)0x80000000FFFFFFFFuLL << 64 | 0x0000000180000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL, (tu_int)0x80000000FFFFFFFFuLL << 64 | 0x00000001FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL, (tu_int)0x80000000FFFFFFFFuLL << 64 | 0x8000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL, (tu_int)0x80000000FFFFFFFFuLL << 64 | 0x8000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL, (tu_int)0x80000000FFFFFFFFuLL << 64 | 0x8000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL, (tu_int)0x80000000FFFFFFFFuLL << 64 | 0x80000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL, (tu_int)0x80000000FFFFFFFFuLL << 64 | 0xFFFFFFFF00000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL, (tu_int)0x80000000FFFFFFFFuLL << 64 | 0xFFFFFFFF00000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL, (tu_int)0x80000000FFFFFFFFuLL << 64 | 0xFFFFFFFF80000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL, (tu_int)0x80000000FFFFFFFFuLL << 64 | 0xFFFFFFFFFFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL, (tu_int)0xFFFFFFFF00000000uLL << 64 | 0x0000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL, (tu_int)0xFFFFFFFF00000000uLL << 64 | 0x0000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL, (tu_int)0xFFFFFFFF00000000uLL << 64 | 0x0000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL, (tu_int)0xFFFFFFFF00000000uLL << 64 | 0x00000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL, (tu_int)0xFFFFFFFF00000000uLL << 64 | 0x0000000100000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL, (tu_int)0xFFFFFFFF00000000uLL << 64 | 0x0000000100000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL, (tu_int)0xFFFFFFFF00000000uLL << 64 | 0x0000000180000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL, (tu_int)0xFFFFFFFF00000000uLL << 64 | 0x00000001FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL, (tu_int)0xFFFFFFFF00000000uLL << 64 | 0x8000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL, (tu_int)0xFFFFFFFF00000000uLL << 64 | 0x8000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL, (tu_int)0xFFFFFFFF00000000uLL << 64 | 0x8000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL, (tu_int)0xFFFFFFFF00000000uLL << 64 | 0x80000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL, (tu_int)0xFFFFFFFF00000000uLL << 64 | 0xFFFFFFFF00000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL, (tu_int)0xFFFFFFFF00000000uLL << 64 | 0xFFFFFFFF00000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL, (tu_int)0xFFFFFFFF00000000uLL << 64 | 0xFFFFFFFF80000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL, (tu_int)0xFFFFFFFF00000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL, (tu_int)0xFFFFFFFF00000001uLL << 64 | 0x0000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL, (tu_int)0xFFFFFFFF00000001uLL << 64 | 0x0000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL, (tu_int)0xFFFFFFFF00000001uLL << 64 | 0x0000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL, (tu_int)0xFFFFFFFF00000001uLL << 64 | 0x00000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL, (tu_int)0xFFFFFFFF00000001uLL << 64 | 0x0000000100000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL, (tu_int)0xFFFFFFFF00000001uLL << 64 | 0x0000000100000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL, (tu_int)0xFFFFFFFF00000001uLL << 64 | 0x0000000180000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL, (tu_int)0xFFFFFFFF00000001uLL << 64 | 0x00000001FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL, (tu_int)0xFFFFFFFF00000001uLL << 64 | 0x8000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL, (tu_int)0xFFFFFFFF00000001uLL << 64 | 0x8000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL, (tu_int)0xFFFFFFFF00000001uLL << 64 | 0x8000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL, (tu_int)0xFFFFFFFF00000001uLL << 64 | 0x80000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL, (tu_int)0xFFFFFFFF00000001uLL << 64 | 0xFFFFFFFF00000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL, (tu_int)0xFFFFFFFF00000001uLL << 64 | 0xFFFFFFFF00000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL, (tu_int)0xFFFFFFFF00000001uLL << 64 | 0xFFFFFFFF80000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL, (tu_int)0xFFFFFFFF00000001uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL, (tu_int)0xFFFFFFFF80000000uLL << 64 | 0x0000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL, (tu_int)0xFFFFFFFF80000000uLL << 64 | 0x0000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL, (tu_int)0xFFFFFFFF80000000uLL << 64 | 0x0000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL, (tu_int)0xFFFFFFFF80000000uLL << 64 | 0x00000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL, (tu_int)0xFFFFFFFF80000000uLL << 64 | 0x0000000100000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL, (tu_int)0xFFFFFFFF80000000uLL << 64 | 0x0000000100000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL, (tu_int)0xFFFFFFFF80000000uLL << 64 | 0x0000000180000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL, (tu_int)0xFFFFFFFF80000000uLL << 64 | 0x00000001FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL, (tu_int)0xFFFFFFFF80000000uLL << 64 | 0x8000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL, (tu_int)0xFFFFFFFF80000000uLL << 64 | 0x8000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL, (tu_int)0xFFFFFFFF80000000uLL << 64 | 0x8000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL, (tu_int)0xFFFFFFFF80000000uLL << 64 | 0x80000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL, (tu_int)0xFFFFFFFF80000000uLL << 64 | 0xFFFFFFFF00000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL, (tu_int)0xFFFFFFFF80000000uLL << 64 | 0xFFFFFFFF00000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL, (tu_int)0xFFFFFFFF80000000uLL << 64 | 0xFFFFFFFF80000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL, (tu_int)0xFFFFFFFF80000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL, (tu_int)0xFFFFFFFFFFFFFFFFuLL << 64 | 0x0000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL, (tu_int)0xFFFFFFFFFFFFFFFFuLL << 64 | 0x0000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL, (tu_int)0xFFFFFFFFFFFFFFFFuLL << 64 | 0x0000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL, (tu_int)0xFFFFFFFFFFFFFFFFuLL << 64 | 0x00000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL, (tu_int)0xFFFFFFFFFFFFFFFFuLL << 64 | 0x0000000100000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL, (tu_int)0xFFFFFFFFFFFFFFFFuLL << 64 | 0x0000000100000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL, (tu_int)0xFFFFFFFFFFFFFFFFuLL << 64 | 0x0000000180000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL, (tu_int)0xFFFFFFFFFFFFFFFFuLL << 64 | 0x00000001FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL, (tu_int)0xFFFFFFFFFFFFFFFFuLL << 64 | 0x8000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL, (tu_int)0xFFFFFFFFFFFFFFFFuLL << 64 | 0x8000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL, (tu_int)0xFFFFFFFFFFFFFFFFuLL << 64 | 0x8000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL, (tu_int)0xFFFFFFFFFFFFFFFFuLL << 64 | 0x80000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL, (tu_int)0xFFFFFFFFFFFFFFFFuLL << 64 | 0xFFFFFFFF00000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL, (tu_int)0xFFFFFFFFFFFFFFFFuLL << 64 | 0xFFFFFFFF00000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL, (tu_int)0xFFFFFFFFFFFFFFFFuLL << 64 | 0xFFFFFFFF80000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL, (tu_int)0xFFFFFFFFFFFFFFFFuLL << 64 | 0xFFFFFFFFFFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000080000001uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000055555555uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000040000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000000C0000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL, (tu_int)0x0000000000000000uLL << 64 | 0x000000007FFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL, (tu_int)0x0000000000000001uLL << 64 | 0x0000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL, (tu_int)0x0000000000000001uLL << 64 | 0x0000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL, (tu_int)0x0000000000000001uLL << 64 | 0x0000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL, (tu_int)0x0000000000000001uLL << 64 | 0x00000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL, (tu_int)0x0000000000000001uLL << 64 | 0x0000000100000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL, (tu_int)0x0000000000000001uLL << 64 | 0x0000000100000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL, (tu_int)0x0000000000000001uLL << 64 | 0x0000000180000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL, (tu_int)0x0000000000000001uLL << 64 | 0x00000001FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL, (tu_int)0x0000000000000001uLL << 64 | 0x8000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL, (tu_int)0x0000000000000001uLL << 64 | 0x8000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL, (tu_int)0x0000000000000001uLL << 64 | 0x8000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL, (tu_int)0x0000000000000001uLL << 64 | 0x80000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL, (tu_int)0x0000000000000001uLL << 64 | 0xFFFFFFFF00000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL, (tu_int)0x0000000000000001uLL << 64 | 0xFFFFFFFF00000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL, (tu_int)0x0000000000000001uLL << 64 | 0xFFFFFFFF80000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL, (tu_int)0x0000000000000001uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL, (tu_int)0x0000000080000000uLL << 64 | 0x0000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL, (tu_int)0x0000000080000000uLL << 64 | 0x0000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL, (tu_int)0x0000000080000000uLL << 64 | 0x0000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL, (tu_int)0x0000000080000000uLL << 64 | 0x00000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL, (tu_int)0x0000000080000000uLL << 64 | 0x0000000100000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL, (tu_int)0x0000000080000000uLL << 64 | 0x0000000100000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL, (tu_int)0x0000000080000000uLL << 64 | 0x0000000180000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL, (tu_int)0x0000000080000000uLL << 64 | 0x00000001FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL, (tu_int)0x0000000080000000uLL << 64 | 0x8000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL, (tu_int)0x0000000080000000uLL << 64 | 0x8000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL, (tu_int)0x0000000080000000uLL << 64 | 0x8000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL, (tu_int)0x0000000080000000uLL << 64 | 0x80000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL, (tu_int)0x0000000080000000uLL << 64 | 0xFFFFFFFF00000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL, (tu_int)0x0000000080000000uLL << 64 | 0xFFFFFFFF00000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL, (tu_int)0x0000000080000000uLL << 64 | 0xFFFFFFFF80000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL, (tu_int)0x0000000080000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL, (tu_int)0x00000000FFFFFFFFuLL << 64 | 0x0000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL, (tu_int)0x00000000FFFFFFFFuLL << 64 | 0x0000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL, (tu_int)0x00000000FFFFFFFFuLL << 64 | 0x0000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL, (tu_int)0x00000000FFFFFFFFuLL << 64 | 0x00000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL, (tu_int)0x00000000FFFFFFFFuLL << 64 | 0x0000000100000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL, (tu_int)0x00000000FFFFFFFFuLL << 64 | 0x0000000100000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL, (tu_int)0x00000000FFFFFFFFuLL << 64 | 0x0000000180000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL, (tu_int)0x00000000FFFFFFFFuLL << 64 | 0x00000001FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL, (tu_int)0x00000000FFFFFFFFuLL << 64 | 0x8000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL, (tu_int)0x00000000FFFFFFFFuLL << 64 | 0x8000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL, (tu_int)0x00000000FFFFFFFFuLL << 64 | 0x8000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL, (tu_int)0x00000000FFFFFFFFuLL << 64 | 0x80000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL, (tu_int)0x00000000FFFFFFFFuLL << 64 | 0xFFFFFFFF00000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL, (tu_int)0x00000000FFFFFFFFuLL << 64 | 0xFFFFFFFF00000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL, (tu_int)0x00000000FFFFFFFFuLL << 64 | 0xFFFFFFFF80000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL, (tu_int)0x00000000FFFFFFFFuLL << 64 | 0xFFFFFFFFFFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL, (tu_int)0x0000000100000000uLL << 64 | 0x0000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL, (tu_int)0x0000000100000000uLL << 64 | 0x0000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL, (tu_int)0x0000000100000000uLL << 64 | 0x0000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL, (tu_int)0x0000000100000000uLL << 64 | 0x00000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL, (tu_int)0x0000000100000000uLL << 64 | 0x0000000100000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL, (tu_int)0x0000000100000000uLL << 64 | 0x0000000100000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL, (tu_int)0x0000000100000000uLL << 64 | 0x0000000180000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL, (tu_int)0x0000000100000000uLL << 64 | 0x00000001FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL, (tu_int)0x0000000100000000uLL << 64 | 0x8000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL, (tu_int)0x0000000100000000uLL << 64 | 0x8000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL, (tu_int)0x0000000100000000uLL << 64 | 0x8000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL, (tu_int)0x0000000100000000uLL << 64 | 0x80000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL, (tu_int)0x0000000100000000uLL << 64 | 0xFFFFFFFF00000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL, (tu_int)0x0000000100000000uLL << 64 | 0xFFFFFFFF00000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL, (tu_int)0x0000000100000000uLL << 64 | 0xFFFFFFFF80000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL, (tu_int)0x0000000100000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL, (tu_int)0x0000000100000001uLL << 64 | 0x0000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL, (tu_int)0x0000000100000001uLL << 64 | 0x0000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL, (tu_int)0x0000000100000001uLL << 64 | 0x0000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL, (tu_int)0x0000000100000001uLL << 64 | 0x00000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL, (tu_int)0x0000000100000001uLL << 64 | 0x0000000100000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL, (tu_int)0x0000000100000001uLL << 64 | 0x0000000100000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL, (tu_int)0x0000000100000001uLL << 64 | 0x0000000180000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL, (tu_int)0x0000000100000001uLL << 64 | 0x00000001FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL, (tu_int)0x0000000100000001uLL << 64 | 0x8000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL, (tu_int)0x0000000100000001uLL << 64 | 0x8000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL, (tu_int)0x0000000100000001uLL << 64 | 0x8000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL, (tu_int)0x0000000100000001uLL << 64 | 0x80000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL, (tu_int)0x0000000100000001uLL << 64 | 0xFFFFFFFF00000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL, (tu_int)0x0000000100000001uLL << 64 | 0xFFFFFFFF00000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL, (tu_int)0x0000000100000001uLL << 64 | 0xFFFFFFFF80000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL, (tu_int)0x0000000100000001uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL, (tu_int)0x0000000180000000uLL << 64 | 0x0000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL, (tu_int)0x0000000180000000uLL << 64 | 0x0000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL, (tu_int)0x0000000180000000uLL << 64 | 0x0000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL, (tu_int)0x0000000180000000uLL << 64 | 0x00000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL, (tu_int)0x0000000180000000uLL << 64 | 0x0000000100000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL, (tu_int)0x0000000180000000uLL << 64 | 0x0000000100000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL, (tu_int)0x0000000180000000uLL << 64 | 0x0000000180000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL, (tu_int)0x0000000180000000uLL << 64 | 0x00000001FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL, (tu_int)0x0000000180000000uLL << 64 | 0x8000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL, (tu_int)0x0000000180000000uLL << 64 | 0x8000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL, (tu_int)0x0000000180000000uLL << 64 | 0x8000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL, (tu_int)0x0000000180000000uLL << 64 | 0x80000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL, (tu_int)0x0000000180000000uLL << 64 | 0xFFFFFFFF00000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL, (tu_int)0x0000000180000000uLL << 64 | 0xFFFFFFFF00000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL, (tu_int)0x0000000180000000uLL << 64 | 0xFFFFFFFF80000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL, (tu_int)0x0000000180000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL, (tu_int)0x00000001FFFFFFFFuLL << 64 | 0x0000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL, (tu_int)0x00000001FFFFFFFFuLL << 64 | 0x0000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL, (tu_int)0x00000001FFFFFFFFuLL << 64 | 0x0000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL, (tu_int)0x00000001FFFFFFFFuLL << 64 | 0x00000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL, (tu_int)0x00000001FFFFFFFFuLL << 64 | 0x0000000100000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL, (tu_int)0x00000001FFFFFFFFuLL << 64 | 0x0000000100000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL, (tu_int)0x00000001FFFFFFFFuLL << 64 | 0x0000000180000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL, (tu_int)0x00000001FFFFFFFFuLL << 64 | 0x00000001FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL, (tu_int)0x00000001FFFFFFFFuLL << 64 | 0x8000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL, (tu_int)0x00000001FFFFFFFFuLL << 64 | 0x8000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL, (tu_int)0x00000001FFFFFFFFuLL << 64 | 0x8000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL, (tu_int)0x00000001FFFFFFFFuLL << 64 | 0x80000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL, (tu_int)0x00000001FFFFFFFFuLL << 64 | 0xFFFFFFFF00000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL, (tu_int)0x00000001FFFFFFFFuLL << 64 | 0xFFFFFFFF00000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL, (tu_int)0x00000001FFFFFFFFuLL << 64 | 0xFFFFFFFF80000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL, (tu_int)0x00000001FFFFFFFFuLL << 64 | 0xFFFFFFFFFFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL, (tu_int)0x8000000000000000uLL << 64 | 0x0000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL, (tu_int)0x8000000000000000uLL << 64 | 0x0000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL, (tu_int)0x8000000000000000uLL << 64 | 0x0000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL, (tu_int)0x8000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL, (tu_int)0x8000000000000000uLL << 64 | 0x0000000100000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL, (tu_int)0x8000000000000000uLL << 64 | 0x0000000100000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL, (tu_int)0x8000000000000000uLL << 64 | 0x0000000180000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL, (tu_int)0x8000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL, (tu_int)0x8000000000000000uLL << 64 | 0x8000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL, (tu_int)0x8000000000000000uLL << 64 | 0x8000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL, (tu_int)0x8000000000000000uLL << 64 | 0x8000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL, (tu_int)0x8000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL, (tu_int)0x8000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL, (tu_int)0x8000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL, (tu_int)0x8000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL, (tu_int)0x8000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL, (tu_int)0x8000000000000001uLL << 64 | 0x0000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL, (tu_int)0x8000000000000001uLL << 64 | 0x0000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL, (tu_int)0x8000000000000001uLL << 64 | 0x0000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL, (tu_int)0x8000000000000001uLL << 64 | 0x00000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL, (tu_int)0x8000000000000001uLL << 64 | 0x0000000100000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL, (tu_int)0x8000000000000001uLL << 64 | 0x0000000100000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL, (tu_int)0x8000000000000001uLL << 64 | 0x0000000180000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL, (tu_int)0x8000000000000001uLL << 64 | 0x00000001FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL, (tu_int)0x8000000000000001uLL << 64 | 0x8000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL, (tu_int)0x8000000000000001uLL << 64 | 0x8000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL, (tu_int)0x8000000000000001uLL << 64 | 0x8000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL, (tu_int)0x8000000000000001uLL << 64 | 0x80000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL, (tu_int)0x8000000000000001uLL << 64 | 0xFFFFFFFF00000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL, (tu_int)0x8000000000000001uLL << 64 | 0xFFFFFFFF00000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL, (tu_int)0x8000000000000001uLL << 64 | 0xFFFFFFFF80000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL, (tu_int)0x8000000000000001uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL, (tu_int)0x8000000080000000uLL << 64 | 0x0000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL, (tu_int)0x8000000080000000uLL << 64 | 0x0000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL, (tu_int)0x8000000080000000uLL << 64 | 0x0000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL, (tu_int)0x8000000080000000uLL << 64 | 0x00000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL, (tu_int)0x8000000080000000uLL << 64 | 0x0000000100000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL, (tu_int)0x8000000080000000uLL << 64 | 0x0000000100000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL, (tu_int)0x8000000080000000uLL << 64 | 0x0000000180000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL, (tu_int)0x8000000080000000uLL << 64 | 0x00000001FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL, (tu_int)0x8000000080000000uLL << 64 | 0x8000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL, (tu_int)0x8000000080000000uLL << 64 | 0x8000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL, (tu_int)0x8000000080000000uLL << 64 | 0x8000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL, (tu_int)0x8000000080000000uLL << 64 | 0x80000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL, (tu_int)0x8000000080000000uLL << 64 | 0xFFFFFFFF00000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL, (tu_int)0x8000000080000000uLL << 64 | 0xFFFFFFFF00000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL, (tu_int)0x8000000080000000uLL << 64 | 0xFFFFFFFF80000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL, (tu_int)0x8000000080000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL, (tu_int)0x80000000FFFFFFFFuLL << 64 | 0x0000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL, (tu_int)0x80000000FFFFFFFFuLL << 64 | 0x0000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL, (tu_int)0x80000000FFFFFFFFuLL << 64 | 0x0000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL, (tu_int)0x80000000FFFFFFFFuLL << 64 | 0x00000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL, (tu_int)0x80000000FFFFFFFFuLL << 64 | 0x0000000100000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL, (tu_int)0x80000000FFFFFFFFuLL << 64 | 0x0000000100000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL, (tu_int)0x80000000FFFFFFFFuLL << 64 | 0x0000000180000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL, (tu_int)0x80000000FFFFFFFFuLL << 64 | 0x00000001FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL, (tu_int)0x80000000FFFFFFFFuLL << 64 | 0x8000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL, (tu_int)0x80000000FFFFFFFFuLL << 64 | 0x8000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL, (tu_int)0x80000000FFFFFFFFuLL << 64 | 0x8000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL, (tu_int)0x80000000FFFFFFFFuLL << 64 | 0x80000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL, (tu_int)0x80000000FFFFFFFFuLL << 64 | 0xFFFFFFFF00000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL, (tu_int)0x80000000FFFFFFFFuLL << 64 | 0xFFFFFFFF00000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL, (tu_int)0x80000000FFFFFFFFuLL << 64 | 0xFFFFFFFF80000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL, (tu_int)0x80000000FFFFFFFFuLL << 64 | 0xFFFFFFFFFFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL, (tu_int)0xFFFFFFFF00000000uLL << 64 | 0x0000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL, (tu_int)0xFFFFFFFF00000000uLL << 64 | 0x0000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL, (tu_int)0xFFFFFFFF00000000uLL << 64 | 0x0000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL, (tu_int)0xFFFFFFFF00000000uLL << 64 | 0x00000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL, (tu_int)0xFFFFFFFF00000000uLL << 64 | 0x0000000100000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL, (tu_int)0xFFFFFFFF00000000uLL << 64 | 0x0000000100000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL, (tu_int)0xFFFFFFFF00000000uLL << 64 | 0x0000000180000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL, (tu_int)0xFFFFFFFF00000000uLL << 64 | 0x00000001FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL, (tu_int)0xFFFFFFFF00000000uLL << 64 | 0x8000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL, (tu_int)0xFFFFFFFF00000000uLL << 64 | 0x8000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL, (tu_int)0xFFFFFFFF00000000uLL << 64 | 0x8000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL, (tu_int)0xFFFFFFFF00000000uLL << 64 | 0x80000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL, (tu_int)0xFFFFFFFF00000000uLL << 64 | 0xFFFFFFFF00000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL, (tu_int)0xFFFFFFFF00000000uLL << 64 | 0xFFFFFFFF00000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL, (tu_int)0xFFFFFFFF00000000uLL << 64 | 0xFFFFFFFF80000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL, (tu_int)0xFFFFFFFF00000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL, (tu_int)0xFFFFFFFF00000001uLL << 64 | 0x0000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL, (tu_int)0xFFFFFFFF00000001uLL << 64 | 0x0000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL, (tu_int)0xFFFFFFFF00000001uLL << 64 | 0x0000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL, (tu_int)0xFFFFFFFF00000001uLL << 64 | 0x00000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL, (tu_int)0xFFFFFFFF00000001uLL << 64 | 0x0000000100000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL, (tu_int)0xFFFFFFFF00000001uLL << 64 | 0x0000000100000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL, (tu_int)0xFFFFFFFF00000001uLL << 64 | 0x0000000180000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL, (tu_int)0xFFFFFFFF00000001uLL << 64 | 0x00000001FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL, (tu_int)0xFFFFFFFF00000001uLL << 64 | 0x8000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL, (tu_int)0xFFFFFFFF00000001uLL << 64 | 0x8000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL, (tu_int)0xFFFFFFFF00000001uLL << 64 | 0x8000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL, (tu_int)0xFFFFFFFF00000001uLL << 64 | 0x80000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL, (tu_int)0xFFFFFFFF00000001uLL << 64 | 0xFFFFFFFF00000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL, (tu_int)0xFFFFFFFF00000001uLL << 64 | 0xFFFFFFFF00000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL, (tu_int)0xFFFFFFFF00000001uLL << 64 | 0xFFFFFFFF80000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL, (tu_int)0xFFFFFFFF00000001uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL, (tu_int)0xFFFFFFFF80000000uLL << 64 | 0x0000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL, (tu_int)0xFFFFFFFF80000000uLL << 64 | 0x0000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL, (tu_int)0xFFFFFFFF80000000uLL << 64 | 0x0000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL, (tu_int)0xFFFFFFFF80000000uLL << 64 | 0x00000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL, (tu_int)0xFFFFFFFF80000000uLL << 64 | 0x0000000100000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL, (tu_int)0xFFFFFFFF80000000uLL << 64 | 0x0000000100000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL, (tu_int)0xFFFFFFFF80000000uLL << 64 | 0x0000000180000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL, (tu_int)0xFFFFFFFF80000000uLL << 64 | 0x00000001FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL, (tu_int)0xFFFFFFFF80000000uLL << 64 | 0x8000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL, (tu_int)0xFFFFFFFF80000000uLL << 64 | 0x8000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL, (tu_int)0xFFFFFFFF80000000uLL << 64 | 0x8000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL, (tu_int)0xFFFFFFFF80000000uLL << 64 | 0x80000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL, (tu_int)0xFFFFFFFF80000000uLL << 64 | 0xFFFFFFFF00000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL, (tu_int)0xFFFFFFFF80000000uLL << 64 | 0xFFFFFFFF00000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL, (tu_int)0xFFFFFFFF80000000uLL << 64 | 0xFFFFFFFF80000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL, (tu_int)0xFFFFFFFF80000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL, (tu_int)0xFFFFFFFFFFFFFFFFuLL << 64 | 0x0000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL, (tu_int)0xFFFFFFFFFFFFFFFFuLL << 64 | 0x0000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL, (tu_int)0xFFFFFFFFFFFFFFFFuLL << 64 | 0x0000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL, (tu_int)0xFFFFFFFFFFFFFFFFuLL << 64 | 0x00000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL, (tu_int)0xFFFFFFFFFFFFFFFFuLL << 64 | 0x0000000100000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL, (tu_int)0xFFFFFFFFFFFFFFFFuLL << 64 | 0x0000000100000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL, (tu_int)0xFFFFFFFFFFFFFFFFuLL << 64 | 0x0000000180000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL, (tu_int)0xFFFFFFFFFFFFFFFFuLL << 64 | 0x00000001FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL, (tu_int)0xFFFFFFFFFFFFFFFFuLL << 64 | 0x8000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL, (tu_int)0xFFFFFFFFFFFFFFFFuLL << 64 | 0x8000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL, (tu_int)0xFFFFFFFFFFFFFFFFuLL << 64 | 0x8000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL, (tu_int)0xFFFFFFFFFFFFFFFFuLL << 64 | 0x80000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL, (tu_int)0xFFFFFFFFFFFFFFFFuLL << 64 | 0xFFFFFFFF00000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL, (tu_int)0xFFFFFFFFFFFFFFFFuLL << 64 | 0xFFFFFFFF00000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL, (tu_int)0xFFFFFFFFFFFFFFFFuLL << 64 | 0xFFFFFFFF80000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL, (tu_int)0xFFFFFFFFFFFFFFFFuLL << 64 | 0xFFFFFFFFFFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL, (tu_int)0x0000000000000000uLL << 64 | 0x000000007FFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000080000001uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x000000007FFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000055555555uLL, (tu_int)0x0000000000000000uLL << 64 | 0x000000017FFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000040000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x000000013FFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFEuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL, (tu_int)0x0000000000000000uLL << 64 | 0x000000007FFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL, (tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL, (tu_int)0x0000000000000001uLL << 64 | 0x0000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL, (tu_int)0x0000000000000001uLL << 64 | 0x0000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL, (tu_int)0x0000000000000001uLL << 64 | 0x0000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL, (tu_int)0x0000000000000001uLL << 64 | 0x00000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL, (tu_int)0x0000000000000001uLL << 64 | 0x0000000100000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL, (tu_int)0x0000000000000001uLL << 64 | 0x0000000100000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL, (tu_int)0x0000000000000001uLL << 64 | 0x0000000180000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL, (tu_int)0x0000000000000001uLL << 64 | 0x00000001FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL, (tu_int)0x0000000000000001uLL << 64 | 0x8000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL, (tu_int)0x0000000000000001uLL << 64 | 0x8000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL, (tu_int)0x0000000000000001uLL << 64 | 0x8000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL, (tu_int)0x0000000000000001uLL << 64 | 0x80000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL, (tu_int)0x0000000000000001uLL << 64 | 0xFFFFFFFF00000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL, (tu_int)0x0000000000000001uLL << 64 | 0xFFFFFFFF00000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL, (tu_int)0x0000000000000001uLL << 64 | 0xFFFFFFFF80000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL, (tu_int)0x0000000000000001uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL, (tu_int)0x0000000080000000uLL << 64 | 0x0000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL, (tu_int)0x0000000080000000uLL << 64 | 0x0000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL, (tu_int)0x0000000080000000uLL << 64 | 0x0000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL, (tu_int)0x0000000080000000uLL << 64 | 0x00000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL, (tu_int)0x0000000080000000uLL << 64 | 0x0000000100000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL, (tu_int)0x0000000080000000uLL << 64 | 0x0000000100000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL, (tu_int)0x0000000080000000uLL << 64 | 0x0000000180000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL, (tu_int)0x0000000080000000uLL << 64 | 0x00000001FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL, (tu_int)0x0000000080000000uLL << 64 | 0x8000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL, (tu_int)0x0000000080000000uLL << 64 | 0x8000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL, (tu_int)0x0000000080000000uLL << 64 | 0x8000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL, (tu_int)0x0000000080000000uLL << 64 | 0x80000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL, (tu_int)0x0000000080000000uLL << 64 | 0xFFFFFFFF00000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL, (tu_int)0x0000000080000000uLL << 64 | 0xFFFFFFFF00000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL, (tu_int)0x0000000080000000uLL << 64 | 0xFFFFFFFF80000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL, (tu_int)0x0000000080000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL, (tu_int)0x00000000FFFFFFFFuLL << 64 | 0x0000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL, (tu_int)0x00000000FFFFFFFFuLL << 64 | 0x0000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL, (tu_int)0x00000000FFFFFFFFuLL << 64 | 0x0000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL, (tu_int)0x00000000FFFFFFFFuLL << 64 | 0x00000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL, (tu_int)0x00000000FFFFFFFFuLL << 64 | 0x0000000100000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL, (tu_int)0x00000000FFFFFFFFuLL << 64 | 0x0000000100000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL, (tu_int)0x00000000FFFFFFFFuLL << 64 | 0x0000000180000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL, (tu_int)0x00000000FFFFFFFFuLL << 64 | 0x00000001FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL, (tu_int)0x00000000FFFFFFFFuLL << 64 | 0x8000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL, (tu_int)0x00000000FFFFFFFFuLL << 64 | 0x8000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL, (tu_int)0x00000000FFFFFFFFuLL << 64 | 0x8000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL, (tu_int)0x00000000FFFFFFFFuLL << 64 | 0x80000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL, (tu_int)0x00000000FFFFFFFFuLL << 64 | 0xFFFFFFFF00000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL, (tu_int)0x00000000FFFFFFFFuLL << 64 | 0xFFFFFFFF00000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL, (tu_int)0x00000000FFFFFFFFuLL << 64 | 0xFFFFFFFF80000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL, (tu_int)0x00000000FFFFFFFFuLL << 64 | 0xFFFFFFFFFFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL, (tu_int)0x0000000100000000uLL << 64 | 0x0000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL, (tu_int)0x0000000100000000uLL << 64 | 0x0000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL, (tu_int)0x0000000100000000uLL << 64 | 0x0000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL, (tu_int)0x0000000100000000uLL << 64 | 0x00000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL, (tu_int)0x0000000100000000uLL << 64 | 0x0000000100000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL, (tu_int)0x0000000100000000uLL << 64 | 0x0000000100000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL, (tu_int)0x0000000100000000uLL << 64 | 0x0000000180000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL, (tu_int)0x0000000100000000uLL << 64 | 0x00000001FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL, (tu_int)0x0000000100000000uLL << 64 | 0x8000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL, (tu_int)0x0000000100000000uLL << 64 | 0x8000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL, (tu_int)0x0000000100000000uLL << 64 | 0x8000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL, (tu_int)0x0000000100000000uLL << 64 | 0x80000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL, (tu_int)0x0000000100000000uLL << 64 | 0xFFFFFFFF00000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL, (tu_int)0x0000000100000000uLL << 64 | 0xFFFFFFFF00000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL, (tu_int)0x0000000100000000uLL << 64 | 0xFFFFFFFF80000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL, (tu_int)0x0000000100000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL, (tu_int)0x0000000100000001uLL << 64 | 0x0000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL, (tu_int)0x0000000100000001uLL << 64 | 0x0000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL, (tu_int)0x0000000100000001uLL << 64 | 0x0000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL, (tu_int)0x0000000100000001uLL << 64 | 0x00000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL, (tu_int)0x0000000100000001uLL << 64 | 0x0000000100000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL, (tu_int)0x0000000100000001uLL << 64 | 0x0000000100000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL, (tu_int)0x0000000100000001uLL << 64 | 0x0000000180000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL, (tu_int)0x0000000100000001uLL << 64 | 0x00000001FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL, (tu_int)0x0000000100000001uLL << 64 | 0x8000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL, (tu_int)0x0000000100000001uLL << 64 | 0x8000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL, (tu_int)0x0000000100000001uLL << 64 | 0x8000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL, (tu_int)0x0000000100000001uLL << 64 | 0x80000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL, (tu_int)0x0000000100000001uLL << 64 | 0xFFFFFFFF00000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL, (tu_int)0x0000000100000001uLL << 64 | 0xFFFFFFFF00000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL, (tu_int)0x0000000100000001uLL << 64 | 0xFFFFFFFF80000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL, (tu_int)0x0000000100000001uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL, (tu_int)0x0000000180000000uLL << 64 | 0x0000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL, (tu_int)0x0000000180000000uLL << 64 | 0x0000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL, (tu_int)0x0000000180000000uLL << 64 | 0x0000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL, (tu_int)0x0000000180000000uLL << 64 | 0x00000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL, (tu_int)0x0000000180000000uLL << 64 | 0x0000000100000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL, (tu_int)0x0000000180000000uLL << 64 | 0x0000000100000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL, (tu_int)0x0000000180000000uLL << 64 | 0x0000000180000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL, (tu_int)0x0000000180000000uLL << 64 | 0x00000001FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL, (tu_int)0x0000000180000000uLL << 64 | 0x8000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL, (tu_int)0x0000000180000000uLL << 64 | 0x8000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL, (tu_int)0x0000000180000000uLL << 64 | 0x8000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL, (tu_int)0x0000000180000000uLL << 64 | 0x80000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL, (tu_int)0x0000000180000000uLL << 64 | 0xFFFFFFFF00000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL, (tu_int)0x0000000180000000uLL << 64 | 0xFFFFFFFF00000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL, (tu_int)0x0000000180000000uLL << 64 | 0xFFFFFFFF80000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL, (tu_int)0x0000000180000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL, (tu_int)0x00000001FFFFFFFFuLL << 64 | 0x0000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL, (tu_int)0x00000001FFFFFFFFuLL << 64 | 0x0000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL, (tu_int)0x00000001FFFFFFFFuLL << 64 | 0x0000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL, (tu_int)0x00000001FFFFFFFFuLL << 64 | 0x00000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL, (tu_int)0x00000001FFFFFFFFuLL << 64 | 0x0000000100000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL, (tu_int)0x00000001FFFFFFFFuLL << 64 | 0x0000000100000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL, (tu_int)0x00000001FFFFFFFFuLL << 64 | 0x0000000180000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL, (tu_int)0x00000001FFFFFFFFuLL << 64 | 0x00000001FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL, (tu_int)0x00000001FFFFFFFFuLL << 64 | 0x8000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL, (tu_int)0x00000001FFFFFFFFuLL << 64 | 0x8000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL, (tu_int)0x00000001FFFFFFFFuLL << 64 | 0x8000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL, (tu_int)0x00000001FFFFFFFFuLL << 64 | 0x80000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL, (tu_int)0x00000001FFFFFFFFuLL << 64 | 0xFFFFFFFF00000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL, (tu_int)0x00000001FFFFFFFFuLL << 64 | 0xFFFFFFFF00000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL, (tu_int)0x00000001FFFFFFFFuLL << 64 | 0xFFFFFFFF80000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL, (tu_int)0x00000001FFFFFFFFuLL << 64 | 0xFFFFFFFFFFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL, (tu_int)0x8000000000000000uLL << 64 | 0x0000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL, (tu_int)0x8000000000000000uLL << 64 | 0x0000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL, (tu_int)0x8000000000000000uLL << 64 | 0x0000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL, (tu_int)0x8000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL, (tu_int)0x8000000000000000uLL << 64 | 0x0000000100000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL, (tu_int)0x8000000000000000uLL << 64 | 0x0000000100000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL, (tu_int)0x8000000000000000uLL << 64 | 0x0000000180000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL, (tu_int)0x8000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL, (tu_int)0x8000000000000000uLL << 64 | 0x8000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL, (tu_int)0x8000000000000000uLL << 64 | 0x8000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL, (tu_int)0x8000000000000000uLL << 64 | 0x8000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL, (tu_int)0x8000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL, (tu_int)0x8000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL, (tu_int)0x8000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL, (tu_int)0x8000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL, (tu_int)0x8000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL, (tu_int)0x8000000000000001uLL << 64 | 0x0000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL, (tu_int)0x8000000000000001uLL << 64 | 0x0000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL, (tu_int)0x8000000000000001uLL << 64 | 0x0000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL, (tu_int)0x8000000000000001uLL << 64 | 0x00000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL, (tu_int)0x8000000000000001uLL << 64 | 0x0000000100000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL, (tu_int)0x8000000000000001uLL << 64 | 0x0000000100000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL, (tu_int)0x8000000000000001uLL << 64 | 0x0000000180000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL, (tu_int)0x8000000000000001uLL << 64 | 0x00000001FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL, (tu_int)0x8000000000000001uLL << 64 | 0x8000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL, (tu_int)0x8000000000000001uLL << 64 | 0x8000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL, (tu_int)0x8000000000000001uLL << 64 | 0x8000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL, (tu_int)0x8000000000000001uLL << 64 | 0x80000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL, (tu_int)0x8000000000000001uLL << 64 | 0xFFFFFFFF00000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL, (tu_int)0x8000000000000001uLL << 64 | 0xFFFFFFFF00000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL, (tu_int)0x8000000000000001uLL << 64 | 0xFFFFFFFF80000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL, (tu_int)0x8000000000000001uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL, (tu_int)0x8000000080000000uLL << 64 | 0x0000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL, (tu_int)0x8000000080000000uLL << 64 | 0x0000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL, (tu_int)0x8000000080000000uLL << 64 | 0x0000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL, (tu_int)0x8000000080000000uLL << 64 | 0x00000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL, (tu_int)0x8000000080000000uLL << 64 | 0x0000000100000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL, (tu_int)0x8000000080000000uLL << 64 | 0x0000000100000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL, (tu_int)0x8000000080000000uLL << 64 | 0x0000000180000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL, (tu_int)0x8000000080000000uLL << 64 | 0x00000001FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL, (tu_int)0x8000000080000000uLL << 64 | 0x8000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL, (tu_int)0x8000000080000000uLL << 64 | 0x8000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL, (tu_int)0x8000000080000000uLL << 64 | 0x8000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL, (tu_int)0x8000000080000000uLL << 64 | 0x80000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL, (tu_int)0x8000000080000000uLL << 64 | 0xFFFFFFFF00000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL, (tu_int)0x8000000080000000uLL << 64 | 0xFFFFFFFF00000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL, (tu_int)0x8000000080000000uLL << 64 | 0xFFFFFFFF80000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL, (tu_int)0x8000000080000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL, (tu_int)0x80000000FFFFFFFFuLL << 64 | 0x0000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL, (tu_int)0x80000000FFFFFFFFuLL << 64 | 0x0000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL, (tu_int)0x80000000FFFFFFFFuLL << 64 | 0x0000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL, (tu_int)0x80000000FFFFFFFFuLL << 64 | 0x00000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL, (tu_int)0x80000000FFFFFFFFuLL << 64 | 0x0000000100000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL, (tu_int)0x80000000FFFFFFFFuLL << 64 | 0x0000000100000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL, (tu_int)0x80000000FFFFFFFFuLL << 64 | 0x0000000180000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL, (tu_int)0x80000000FFFFFFFFuLL << 64 | 0x00000001FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL, (tu_int)0x80000000FFFFFFFFuLL << 64 | 0x8000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL, (tu_int)0x80000000FFFFFFFFuLL << 64 | 0x8000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL, (tu_int)0x80000000FFFFFFFFuLL << 64 | 0x8000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL, (tu_int)0x80000000FFFFFFFFuLL << 64 | 0x80000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL, (tu_int)0x80000000FFFFFFFFuLL << 64 | 0xFFFFFFFF00000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL, (tu_int)0x80000000FFFFFFFFuLL << 64 | 0xFFFFFFFF00000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL, (tu_int)0x80000000FFFFFFFFuLL << 64 | 0xFFFFFFFF80000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL, (tu_int)0x80000000FFFFFFFFuLL << 64 | 0xFFFFFFFFFFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL, (tu_int)0xFFFFFFFF00000000uLL << 64 | 0x0000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL, (tu_int)0xFFFFFFFF00000000uLL << 64 | 0x0000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL, (tu_int)0xFFFFFFFF00000000uLL << 64 | 0x0000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL, (tu_int)0xFFFFFFFF00000000uLL << 64 | 0x00000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL, (tu_int)0xFFFFFFFF00000000uLL << 64 | 0x0000000100000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL, (tu_int)0xFFFFFFFF00000000uLL << 64 | 0x0000000100000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL, (tu_int)0xFFFFFFFF00000000uLL << 64 | 0x0000000180000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL, (tu_int)0xFFFFFFFF00000000uLL << 64 | 0x00000001FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL, (tu_int)0xFFFFFFFF00000000uLL << 64 | 0x8000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL, (tu_int)0xFFFFFFFF00000000uLL << 64 | 0x8000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL, (tu_int)0xFFFFFFFF00000000uLL << 64 | 0x8000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL, (tu_int)0xFFFFFFFF00000000uLL << 64 | 0x80000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL, (tu_int)0xFFFFFFFF00000000uLL << 64 | 0xFFFFFFFF00000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL, (tu_int)0xFFFFFFFF00000000uLL << 64 | 0xFFFFFFFF00000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL, (tu_int)0xFFFFFFFF00000000uLL << 64 | 0xFFFFFFFF80000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL, (tu_int)0xFFFFFFFF00000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL, (tu_int)0xFFFFFFFF00000001uLL << 64 | 0x0000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL, (tu_int)0xFFFFFFFF00000001uLL << 64 | 0x0000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL, (tu_int)0xFFFFFFFF00000001uLL << 64 | 0x0000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL, (tu_int)0xFFFFFFFF00000001uLL << 64 | 0x00000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL, (tu_int)0xFFFFFFFF00000001uLL << 64 | 0x0000000100000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL, (tu_int)0xFFFFFFFF00000001uLL << 64 | 0x0000000100000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL, (tu_int)0xFFFFFFFF00000001uLL << 64 | 0x0000000180000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL, (tu_int)0xFFFFFFFF00000001uLL << 64 | 0x00000001FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL, (tu_int)0xFFFFFFFF00000001uLL << 64 | 0x8000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL, (tu_int)0xFFFFFFFF00000001uLL << 64 | 0x8000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL, (tu_int)0xFFFFFFFF00000001uLL << 64 | 0x8000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL, (tu_int)0xFFFFFFFF00000001uLL << 64 | 0x80000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL, (tu_int)0xFFFFFFFF00000001uLL << 64 | 0xFFFFFFFF00000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL, (tu_int)0xFFFFFFFF00000001uLL << 64 | 0xFFFFFFFF00000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL, (tu_int)0xFFFFFFFF00000001uLL << 64 | 0xFFFFFFFF80000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL, (tu_int)0xFFFFFFFF00000001uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL, (tu_int)0xFFFFFFFF80000000uLL << 64 | 0x0000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL, (tu_int)0xFFFFFFFF80000000uLL << 64 | 0x0000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL, (tu_int)0xFFFFFFFF80000000uLL << 64 | 0x0000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL, (tu_int)0xFFFFFFFF80000000uLL << 64 | 0x00000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL, (tu_int)0xFFFFFFFF80000000uLL << 64 | 0x0000000100000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL, (tu_int)0xFFFFFFFF80000000uLL << 64 | 0x0000000100000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL, (tu_int)0xFFFFFFFF80000000uLL << 64 | 0x0000000180000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL, (tu_int)0xFFFFFFFF80000000uLL << 64 | 0x00000001FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL, (tu_int)0xFFFFFFFF80000000uLL << 64 | 0x8000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL, (tu_int)0xFFFFFFFF80000000uLL << 64 | 0x8000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL, (tu_int)0xFFFFFFFF80000000uLL << 64 | 0x8000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL, (tu_int)0xFFFFFFFF80000000uLL << 64 | 0x80000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL, (tu_int)0xFFFFFFFF80000000uLL << 64 | 0xFFFFFFFF00000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL, (tu_int)0xFFFFFFFF80000000uLL << 64 | 0xFFFFFFFF00000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL, (tu_int)0xFFFFFFFF80000000uLL << 64 | 0xFFFFFFFF80000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL, (tu_int)0xFFFFFFFF80000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL, (tu_int)0xFFFFFFFFFFFFFFFFuLL << 64 | 0x0000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL, (tu_int)0xFFFFFFFFFFFFFFFFuLL << 64 | 0x0000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL, (tu_int)0xFFFFFFFFFFFFFFFFuLL << 64 | 0x0000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL, (tu_int)0xFFFFFFFFFFFFFFFFuLL << 64 | 0x00000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL, (tu_int)0xFFFFFFFFFFFFFFFFuLL << 64 | 0x0000000100000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL, (tu_int)0xFFFFFFFFFFFFFFFFuLL << 64 | 0x0000000100000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL, (tu_int)0xFFFFFFFFFFFFFFFFuLL << 64 | 0x0000000180000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL, (tu_int)0xFFFFFFFFFFFFFFFFuLL << 64 | 0x00000001FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL, (tu_int)0xFFFFFFFFFFFFFFFFuLL << 64 | 0x8000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL, (tu_int)0xFFFFFFFFFFFFFFFFuLL << 64 | 0x8000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL, (tu_int)0xFFFFFFFFFFFFFFFFuLL << 64 | 0x8000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL, (tu_int)0xFFFFFFFFFFFFFFFFuLL << 64 | 0x80000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL, (tu_int)0xFFFFFFFFFFFFFFFFuLL << 64 | 0xFFFFFFFF00000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL, (tu_int)0xFFFFFFFFFFFFFFFFuLL << 64 | 0xFFFFFFFF00000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL, (tu_int)0xFFFFFFFFFFFFFFFFuLL << 64 | 0xFFFFFFFF80000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL, (tu_int)0xFFFFFFFFFFFFFFFFuLL << 64 | 0xFFFFFFFFFFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFEuLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFEuLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000002uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x00000000AAAAAAAAuLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x000000007FFFFFFFuLL, (tu_int)0x0000000000000000uLL << 64 | 0x000000017FFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL, (tu_int)0x0000000000000000uLL << 64 | 0x7FFFFFFF00000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL, (tu_int)0x0000000000000000uLL << 64 | 0x7FFFFFFEFFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL, (tu_int)0x0000000000000000uLL << 64 | 0x7FFFFFFE80000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL, (tu_int)0x0000000000000000uLL << 64 | 0x7FFFFFFE00000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL, (tu_int)0x0000000000000001uLL << 64 | 0x0000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL, (tu_int)0x0000000000000001uLL << 64 | 0x0000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL, (tu_int)0x0000000000000001uLL << 64 | 0x0000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL, (tu_int)0x0000000000000001uLL << 64 | 0x00000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL, (tu_int)0x0000000000000001uLL << 64 | 0x0000000100000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL, (tu_int)0x0000000000000001uLL << 64 | 0x0000000100000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL, (tu_int)0x0000000000000001uLL << 64 | 0x0000000180000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL, (tu_int)0x0000000000000001uLL << 64 | 0x00000001FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL, (tu_int)0x0000000000000001uLL << 64 | 0x8000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL, (tu_int)0x0000000000000001uLL << 64 | 0x8000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL, (tu_int)0x0000000000000001uLL << 64 | 0x8000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL, (tu_int)0x0000000000000001uLL << 64 | 0x80000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL, (tu_int)0x0000000000000001uLL << 64 | 0xFFFFFFFF00000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL, (tu_int)0x0000000000000001uLL << 64 | 0xFFFFFFFF00000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL, (tu_int)0x0000000000000001uLL << 64 | 0xFFFFFFFF80000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL, (tu_int)0x0000000000000001uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL, (tu_int)0x0000000080000000uLL << 64 | 0x0000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL, (tu_int)0x0000000080000000uLL << 64 | 0x0000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL, (tu_int)0x0000000080000000uLL << 64 | 0x0000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL, (tu_int)0x0000000080000000uLL << 64 | 0x00000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL, (tu_int)0x0000000080000000uLL << 64 | 0x0000000100000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL, (tu_int)0x0000000080000000uLL << 64 | 0x0000000100000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL, (tu_int)0x0000000080000000uLL << 64 | 0x0000000180000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL, (tu_int)0x0000000080000000uLL << 64 | 0x00000001FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL, (tu_int)0x0000000080000000uLL << 64 | 0x8000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL, (tu_int)0x0000000080000000uLL << 64 | 0x8000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL, (tu_int)0x0000000080000000uLL << 64 | 0x8000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL, (tu_int)0x0000000080000000uLL << 64 | 0x80000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL, (tu_int)0x0000000080000000uLL << 64 | 0xFFFFFFFF00000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL, (tu_int)0x0000000080000000uLL << 64 | 0xFFFFFFFF00000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL, (tu_int)0x0000000080000000uLL << 64 | 0xFFFFFFFF80000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL, (tu_int)0x0000000080000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL, (tu_int)0x00000000FFFFFFFFuLL << 64 | 0x0000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL, (tu_int)0x00000000FFFFFFFFuLL << 64 | 0x0000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL, (tu_int)0x00000000FFFFFFFFuLL << 64 | 0x0000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL, (tu_int)0x00000000FFFFFFFFuLL << 64 | 0x00000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL, (tu_int)0x00000000FFFFFFFFuLL << 64 | 0x0000000100000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL, (tu_int)0x00000000FFFFFFFFuLL << 64 | 0x0000000100000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL, (tu_int)0x00000000FFFFFFFFuLL << 64 | 0x0000000180000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL, (tu_int)0x00000000FFFFFFFFuLL << 64 | 0x00000001FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL, (tu_int)0x00000000FFFFFFFFuLL << 64 | 0x8000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL, (tu_int)0x00000000FFFFFFFFuLL << 64 | 0x8000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL, (tu_int)0x00000000FFFFFFFFuLL << 64 | 0x8000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL, (tu_int)0x00000000FFFFFFFFuLL << 64 | 0x80000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL, (tu_int)0x00000000FFFFFFFFuLL << 64 | 0xFFFFFFFF00000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL, (tu_int)0x00000000FFFFFFFFuLL << 64 | 0xFFFFFFFF00000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL, (tu_int)0x00000000FFFFFFFFuLL << 64 | 0xFFFFFFFF80000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL, (tu_int)0x00000000FFFFFFFFuLL << 64 | 0xFFFFFFFFFFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL, (tu_int)0x0000000100000000uLL << 64 | 0x0000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL, (tu_int)0x0000000100000000uLL << 64 | 0x0000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL, (tu_int)0x0000000100000000uLL << 64 | 0x0000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL, (tu_int)0x0000000100000000uLL << 64 | 0x00000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL, (tu_int)0x0000000100000000uLL << 64 | 0x0000000100000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL, (tu_int)0x0000000100000000uLL << 64 | 0x0000000100000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL, (tu_int)0x0000000100000000uLL << 64 | 0x0000000180000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL, (tu_int)0x0000000100000000uLL << 64 | 0x00000001FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL, (tu_int)0x0000000100000000uLL << 64 | 0x8000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL, (tu_int)0x0000000100000000uLL << 64 | 0x8000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL, (tu_int)0x0000000100000000uLL << 64 | 0x8000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL, (tu_int)0x0000000100000000uLL << 64 | 0x80000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL, (tu_int)0x0000000100000000uLL << 64 | 0xFFFFFFFF00000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL, (tu_int)0x0000000100000000uLL << 64 | 0xFFFFFFFF00000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL, (tu_int)0x0000000100000000uLL << 64 | 0xFFFFFFFF80000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL, (tu_int)0x0000000100000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL, (tu_int)0x0000000100000001uLL << 64 | 0x0000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL, (tu_int)0x0000000100000001uLL << 64 | 0x0000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL, (tu_int)0x0000000100000001uLL << 64 | 0x0000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL, (tu_int)0x0000000100000001uLL << 64 | 0x00000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL, (tu_int)0x0000000100000001uLL << 64 | 0x0000000100000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL, (tu_int)0x0000000100000001uLL << 64 | 0x0000000100000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL, (tu_int)0x0000000100000001uLL << 64 | 0x0000000180000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL, (tu_int)0x0000000100000001uLL << 64 | 0x00000001FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL, (tu_int)0x0000000100000001uLL << 64 | 0x8000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL, (tu_int)0x0000000100000001uLL << 64 | 0x8000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL, (tu_int)0x0000000100000001uLL << 64 | 0x8000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL, (tu_int)0x0000000100000001uLL << 64 | 0x80000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL, (tu_int)0x0000000100000001uLL << 64 | 0xFFFFFFFF00000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL, (tu_int)0x0000000100000001uLL << 64 | 0xFFFFFFFF00000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL, (tu_int)0x0000000100000001uLL << 64 | 0xFFFFFFFF80000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL, (tu_int)0x0000000100000001uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL, (tu_int)0x0000000180000000uLL << 64 | 0x0000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL, (tu_int)0x0000000180000000uLL << 64 | 0x0000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL, (tu_int)0x0000000180000000uLL << 64 | 0x0000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL, (tu_int)0x0000000180000000uLL << 64 | 0x00000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL, (tu_int)0x0000000180000000uLL << 64 | 0x0000000100000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL, (tu_int)0x0000000180000000uLL << 64 | 0x0000000100000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL, (tu_int)0x0000000180000000uLL << 64 | 0x0000000180000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL, (tu_int)0x0000000180000000uLL << 64 | 0x00000001FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL, (tu_int)0x0000000180000000uLL << 64 | 0x8000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL, (tu_int)0x0000000180000000uLL << 64 | 0x8000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL, (tu_int)0x0000000180000000uLL << 64 | 0x8000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL, (tu_int)0x0000000180000000uLL << 64 | 0x80000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL, (tu_int)0x0000000180000000uLL << 64 | 0xFFFFFFFF00000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL, (tu_int)0x0000000180000000uLL << 64 | 0xFFFFFFFF00000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL, (tu_int)0x0000000180000000uLL << 64 | 0xFFFFFFFF80000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL, (tu_int)0x0000000180000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL, (tu_int)0x00000001FFFFFFFFuLL << 64 | 0x0000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL, (tu_int)0x00000001FFFFFFFFuLL << 64 | 0x0000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL, (tu_int)0x00000001FFFFFFFFuLL << 64 | 0x0000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL, (tu_int)0x00000001FFFFFFFFuLL << 64 | 0x00000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL, (tu_int)0x00000001FFFFFFFFuLL << 64 | 0x0000000100000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL, (tu_int)0x00000001FFFFFFFFuLL << 64 | 0x0000000100000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL, (tu_int)0x00000001FFFFFFFFuLL << 64 | 0x0000000180000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL, (tu_int)0x00000001FFFFFFFFuLL << 64 | 0x00000001FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL, (tu_int)0x00000001FFFFFFFFuLL << 64 | 0x8000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL, (tu_int)0x00000001FFFFFFFFuLL << 64 | 0x8000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL, (tu_int)0x00000001FFFFFFFFuLL << 64 | 0x8000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL, (tu_int)0x00000001FFFFFFFFuLL << 64 | 0x80000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL, (tu_int)0x00000001FFFFFFFFuLL << 64 | 0xFFFFFFFF00000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL, (tu_int)0x00000001FFFFFFFFuLL << 64 | 0xFFFFFFFF00000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL, (tu_int)0x00000001FFFFFFFFuLL << 64 | 0xFFFFFFFF80000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL, (tu_int)0x00000001FFFFFFFFuLL << 64 | 0xFFFFFFFFFFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL, (tu_int)0x8000000000000000uLL << 64 | 0x0000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL, (tu_int)0x8000000000000000uLL << 64 | 0x0000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL, (tu_int)0x8000000000000000uLL << 64 | 0x0000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL, (tu_int)0x8000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL, (tu_int)0x8000000000000000uLL << 64 | 0x0000000100000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL, (tu_int)0x8000000000000000uLL << 64 | 0x0000000100000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL, (tu_int)0x8000000000000000uLL << 64 | 0x0000000180000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL, (tu_int)0x8000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL, (tu_int)0x8000000000000000uLL << 64 | 0x8000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL, (tu_int)0x8000000000000000uLL << 64 | 0x8000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL, (tu_int)0x8000000000000000uLL << 64 | 0x8000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL, (tu_int)0x8000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL, (tu_int)0x8000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL, (tu_int)0x8000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL, (tu_int)0x8000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL, (tu_int)0x8000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL, (tu_int)0x8000000000000001uLL << 64 | 0x0000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL, (tu_int)0x8000000000000001uLL << 64 | 0x0000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL, (tu_int)0x8000000000000001uLL << 64 | 0x0000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL, (tu_int)0x8000000000000001uLL << 64 | 0x00000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL, (tu_int)0x8000000000000001uLL << 64 | 0x0000000100000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL, (tu_int)0x8000000000000001uLL << 64 | 0x0000000100000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL, (tu_int)0x8000000000000001uLL << 64 | 0x0000000180000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL, (tu_int)0x8000000000000001uLL << 64 | 0x00000001FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL, (tu_int)0x8000000000000001uLL << 64 | 0x8000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL, (tu_int)0x8000000000000001uLL << 64 | 0x8000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL, (tu_int)0x8000000000000001uLL << 64 | 0x8000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL, (tu_int)0x8000000000000001uLL << 64 | 0x80000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL, (tu_int)0x8000000000000001uLL << 64 | 0xFFFFFFFF00000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL, (tu_int)0x8000000000000001uLL << 64 | 0xFFFFFFFF00000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL, (tu_int)0x8000000000000001uLL << 64 | 0xFFFFFFFF80000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL, (tu_int)0x8000000000000001uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL, (tu_int)0x8000000080000000uLL << 64 | 0x0000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL, (tu_int)0x8000000080000000uLL << 64 | 0x0000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL, (tu_int)0x8000000080000000uLL << 64 | 0x0000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL, (tu_int)0x8000000080000000uLL << 64 | 0x00000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL, (tu_int)0x8000000080000000uLL << 64 | 0x0000000100000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL, (tu_int)0x8000000080000000uLL << 64 | 0x0000000100000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL, (tu_int)0x8000000080000000uLL << 64 | 0x0000000180000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL, (tu_int)0x8000000080000000uLL << 64 | 0x00000001FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL, (tu_int)0x8000000080000000uLL << 64 | 0x8000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL, (tu_int)0x8000000080000000uLL << 64 | 0x8000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL, (tu_int)0x8000000080000000uLL << 64 | 0x8000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL, (tu_int)0x8000000080000000uLL << 64 | 0x80000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL, (tu_int)0x8000000080000000uLL << 64 | 0xFFFFFFFF00000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL, (tu_int)0x8000000080000000uLL << 64 | 0xFFFFFFFF00000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL, (tu_int)0x8000000080000000uLL << 64 | 0xFFFFFFFF80000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL, (tu_int)0x8000000080000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL, (tu_int)0x80000000FFFFFFFFuLL << 64 | 0x0000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL, (tu_int)0x80000000FFFFFFFFuLL << 64 | 0x0000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL, (tu_int)0x80000000FFFFFFFFuLL << 64 | 0x0000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL, (tu_int)0x80000000FFFFFFFFuLL << 64 | 0x00000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL, (tu_int)0x80000000FFFFFFFFuLL << 64 | 0x0000000100000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL, (tu_int)0x80000000FFFFFFFFuLL << 64 | 0x0000000100000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL, (tu_int)0x80000000FFFFFFFFuLL << 64 | 0x0000000180000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL, (tu_int)0x80000000FFFFFFFFuLL << 64 | 0x00000001FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL, (tu_int)0x80000000FFFFFFFFuLL << 64 | 0x8000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL, (tu_int)0x80000000FFFFFFFFuLL << 64 | 0x8000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL, (tu_int)0x80000000FFFFFFFFuLL << 64 | 0x8000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL, (tu_int)0x80000000FFFFFFFFuLL << 64 | 0x80000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL, (tu_int)0x80000000FFFFFFFFuLL << 64 | 0xFFFFFFFF00000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL, (tu_int)0x80000000FFFFFFFFuLL << 64 | 0xFFFFFFFF00000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL, (tu_int)0x80000000FFFFFFFFuLL << 64 | 0xFFFFFFFF80000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL, (tu_int)0x80000000FFFFFFFFuLL << 64 | 0xFFFFFFFFFFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL, (tu_int)0xFFFFFFFF00000000uLL << 64 | 0x0000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL, (tu_int)0xFFFFFFFF00000000uLL << 64 | 0x0000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL, (tu_int)0xFFFFFFFF00000000uLL << 64 | 0x0000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL, (tu_int)0xFFFFFFFF00000000uLL << 64 | 0x00000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL, (tu_int)0xFFFFFFFF00000000uLL << 64 | 0x0000000100000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL, (tu_int)0xFFFFFFFF00000000uLL << 64 | 0x0000000100000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL, (tu_int)0xFFFFFFFF00000000uLL << 64 | 0x0000000180000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL, (tu_int)0xFFFFFFFF00000000uLL << 64 | 0x00000001FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL, (tu_int)0xFFFFFFFF00000000uLL << 64 | 0x8000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL, (tu_int)0xFFFFFFFF00000000uLL << 64 | 0x8000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL, (tu_int)0xFFFFFFFF00000000uLL << 64 | 0x8000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL, (tu_int)0xFFFFFFFF00000000uLL << 64 | 0x80000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL, (tu_int)0xFFFFFFFF00000000uLL << 64 | 0xFFFFFFFF00000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL, (tu_int)0xFFFFFFFF00000000uLL << 64 | 0xFFFFFFFF00000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL, (tu_int)0xFFFFFFFF00000000uLL << 64 | 0xFFFFFFFF80000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL, (tu_int)0xFFFFFFFF00000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL, (tu_int)0xFFFFFFFF00000001uLL << 64 | 0x0000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL, (tu_int)0xFFFFFFFF00000001uLL << 64 | 0x0000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL, (tu_int)0xFFFFFFFF00000001uLL << 64 | 0x0000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL, (tu_int)0xFFFFFFFF00000001uLL << 64 | 0x00000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL, (tu_int)0xFFFFFFFF00000001uLL << 64 | 0x0000000100000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL, (tu_int)0xFFFFFFFF00000001uLL << 64 | 0x0000000100000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL, (tu_int)0xFFFFFFFF00000001uLL << 64 | 0x0000000180000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL, (tu_int)0xFFFFFFFF00000001uLL << 64 | 0x00000001FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL, (tu_int)0xFFFFFFFF00000001uLL << 64 | 0x8000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL, (tu_int)0xFFFFFFFF00000001uLL << 64 | 0x8000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL, (tu_int)0xFFFFFFFF00000001uLL << 64 | 0x8000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL, (tu_int)0xFFFFFFFF00000001uLL << 64 | 0x80000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL, (tu_int)0xFFFFFFFF00000001uLL << 64 | 0xFFFFFFFF00000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL, (tu_int)0xFFFFFFFF00000001uLL << 64 | 0xFFFFFFFF00000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL, (tu_int)0xFFFFFFFF00000001uLL << 64 | 0xFFFFFFFF80000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL, (tu_int)0xFFFFFFFF00000001uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL, (tu_int)0xFFFFFFFF80000000uLL << 64 | 0x0000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL, (tu_int)0xFFFFFFFF80000000uLL << 64 | 0x0000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL, (tu_int)0xFFFFFFFF80000000uLL << 64 | 0x0000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL, (tu_int)0xFFFFFFFF80000000uLL << 64 | 0x00000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL, (tu_int)0xFFFFFFFF80000000uLL << 64 | 0x0000000100000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL, (tu_int)0xFFFFFFFF80000000uLL << 64 | 0x0000000100000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL, (tu_int)0xFFFFFFFF80000000uLL << 64 | 0x0000000180000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL, (tu_int)0xFFFFFFFF80000000uLL << 64 | 0x00000001FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL, (tu_int)0xFFFFFFFF80000000uLL << 64 | 0x8000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL, (tu_int)0xFFFFFFFF80000000uLL << 64 | 0x8000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL, (tu_int)0xFFFFFFFF80000000uLL << 64 | 0x8000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL, (tu_int)0xFFFFFFFF80000000uLL << 64 | 0x80000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL, (tu_int)0xFFFFFFFF80000000uLL << 64 | 0xFFFFFFFF00000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL, (tu_int)0xFFFFFFFF80000000uLL << 64 | 0xFFFFFFFF00000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL, (tu_int)0xFFFFFFFF80000000uLL << 64 | 0xFFFFFFFF80000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL, (tu_int)0xFFFFFFFF80000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL, (tu_int)0xFFFFFFFFFFFFFFFFuLL << 64 | 0x0000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL, (tu_int)0xFFFFFFFFFFFFFFFFuLL << 64 | 0x0000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL, (tu_int)0xFFFFFFFFFFFFFFFFuLL << 64 | 0x0000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL, (tu_int)0xFFFFFFFFFFFFFFFFuLL << 64 | 0x00000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL, (tu_int)0xFFFFFFFFFFFFFFFFuLL << 64 | 0x0000000100000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL, (tu_int)0xFFFFFFFFFFFFFFFFuLL << 64 | 0x0000000100000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL, (tu_int)0xFFFFFFFFFFFFFFFFuLL << 64 | 0x0000000180000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL, (tu_int)0xFFFFFFFFFFFFFFFFuLL << 64 | 0x00000001FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL, (tu_int)0xFFFFFFFFFFFFFFFFuLL << 64 | 0x8000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL, (tu_int)0xFFFFFFFFFFFFFFFFuLL << 64 | 0x8000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL, (tu_int)0xFFFFFFFFFFFFFFFFuLL << 64 | 0x8000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL, (tu_int)0xFFFFFFFFFFFFFFFFuLL << 64 | 0x80000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL, (tu_int)0xFFFFFFFFFFFFFFFFuLL << 64 | 0xFFFFFFFF00000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL, (tu_int)0xFFFFFFFFFFFFFFFFuLL << 64 | 0xFFFFFFFF00000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL, (tu_int)0xFFFFFFFFFFFFFFFFuLL << 64 | 0xFFFFFFFF80000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL, (tu_int)0xFFFFFFFFFFFFFFFFuLL << 64 | 0xFFFFFFFFFFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFEuLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFEuLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000003uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x00000000AAAAAAAAuLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x000000007FFFFFFFuLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL, (tu_int)0x0000000000000000uLL << 64 | 0x7FFFFFFF00000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL, (tu_int)0x0000000000000000uLL << 64 | 0x7FFFFFFF00000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL, (tu_int)0x0000000000000000uLL << 64 | 0x7FFFFFFE80000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL, (tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL, (tu_int)0x0000000000000000uLL << 64 | 0x7FFFFFFE00000002uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL, (tu_int)0x0000000000000001uLL << 64 | 0x0000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL, (tu_int)0x0000000000000001uLL << 64 | 0x0000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL, (tu_int)0x0000000000000001uLL << 64 | 0x0000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL, (tu_int)0x0000000000000001uLL << 64 | 0x00000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL, (tu_int)0x0000000000000001uLL << 64 | 0x0000000100000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL, (tu_int)0x0000000000000001uLL << 64 | 0x0000000100000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL, (tu_int)0x0000000000000001uLL << 64 | 0x0000000180000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL, (tu_int)0x0000000000000001uLL << 64 | 0x00000001FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL, (tu_int)0x0000000000000001uLL << 64 | 0x8000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL, (tu_int)0x0000000000000001uLL << 64 | 0x8000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL, (tu_int)0x0000000000000001uLL << 64 | 0x8000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL, (tu_int)0x0000000000000001uLL << 64 | 0x80000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL, (tu_int)0x0000000000000001uLL << 64 | 0xFFFFFFFF00000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL, (tu_int)0x0000000000000001uLL << 64 | 0xFFFFFFFF00000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL, (tu_int)0x0000000000000001uLL << 64 | 0xFFFFFFFF80000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL, (tu_int)0x0000000000000001uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL, (tu_int)0x0000000080000000uLL << 64 | 0x0000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL, (tu_int)0x0000000080000000uLL << 64 | 0x0000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL, (tu_int)0x0000000080000000uLL << 64 | 0x0000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL, (tu_int)0x0000000080000000uLL << 64 | 0x00000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL, (tu_int)0x0000000080000000uLL << 64 | 0x0000000100000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL, (tu_int)0x0000000080000000uLL << 64 | 0x0000000100000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL, (tu_int)0x0000000080000000uLL << 64 | 0x0000000180000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL, (tu_int)0x0000000080000000uLL << 64 | 0x00000001FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL, (tu_int)0x0000000080000000uLL << 64 | 0x8000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL, (tu_int)0x0000000080000000uLL << 64 | 0x8000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL, (tu_int)0x0000000080000000uLL << 64 | 0x8000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL, (tu_int)0x0000000080000000uLL << 64 | 0x80000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL, (tu_int)0x0000000080000000uLL << 64 | 0xFFFFFFFF00000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL, (tu_int)0x0000000080000000uLL << 64 | 0xFFFFFFFF00000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL, (tu_int)0x0000000080000000uLL << 64 | 0xFFFFFFFF80000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL, (tu_int)0x0000000080000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL, (tu_int)0x00000000FFFFFFFFuLL << 64 | 0x0000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL, (tu_int)0x00000000FFFFFFFFuLL << 64 | 0x0000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL, (tu_int)0x00000000FFFFFFFFuLL << 64 | 0x0000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL, (tu_int)0x00000000FFFFFFFFuLL << 64 | 0x00000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL, (tu_int)0x00000000FFFFFFFFuLL << 64 | 0x0000000100000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL, (tu_int)0x00000000FFFFFFFFuLL << 64 | 0x0000000100000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL, (tu_int)0x00000000FFFFFFFFuLL << 64 | 0x0000000180000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL, (tu_int)0x00000000FFFFFFFFuLL << 64 | 0x00000001FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL, (tu_int)0x00000000FFFFFFFFuLL << 64 | 0x8000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL, (tu_int)0x00000000FFFFFFFFuLL << 64 | 0x8000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL, (tu_int)0x00000000FFFFFFFFuLL << 64 | 0x8000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL, (tu_int)0x00000000FFFFFFFFuLL << 64 | 0x80000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL, (tu_int)0x00000000FFFFFFFFuLL << 64 | 0xFFFFFFFF00000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL, (tu_int)0x00000000FFFFFFFFuLL << 64 | 0xFFFFFFFF00000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL, (tu_int)0x00000000FFFFFFFFuLL << 64 | 0xFFFFFFFF80000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL, (tu_int)0x00000000FFFFFFFFuLL << 64 | 0xFFFFFFFFFFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL, (tu_int)0x0000000100000000uLL << 64 | 0x0000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL, (tu_int)0x0000000100000000uLL << 64 | 0x0000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL, (tu_int)0x0000000100000000uLL << 64 | 0x0000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL, (tu_int)0x0000000100000000uLL << 64 | 0x00000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL, (tu_int)0x0000000100000000uLL << 64 | 0x0000000100000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL, (tu_int)0x0000000100000000uLL << 64 | 0x0000000100000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL, (tu_int)0x0000000100000000uLL << 64 | 0x0000000180000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL, (tu_int)0x0000000100000000uLL << 64 | 0x00000001FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL, (tu_int)0x0000000100000000uLL << 64 | 0x8000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL, (tu_int)0x0000000100000000uLL << 64 | 0x8000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL, (tu_int)0x0000000100000000uLL << 64 | 0x8000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL, (tu_int)0x0000000100000000uLL << 64 | 0x80000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL, (tu_int)0x0000000100000000uLL << 64 | 0xFFFFFFFF00000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL, (tu_int)0x0000000100000000uLL << 64 | 0xFFFFFFFF00000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL, (tu_int)0x0000000100000000uLL << 64 | 0xFFFFFFFF80000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL, (tu_int)0x0000000100000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL, (tu_int)0x0000000100000001uLL << 64 | 0x0000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL, (tu_int)0x0000000100000001uLL << 64 | 0x0000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL, (tu_int)0x0000000100000001uLL << 64 | 0x0000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL, (tu_int)0x0000000100000001uLL << 64 | 0x00000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL, (tu_int)0x0000000100000001uLL << 64 | 0x0000000100000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL, (tu_int)0x0000000100000001uLL << 64 | 0x0000000100000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL, (tu_int)0x0000000100000001uLL << 64 | 0x0000000180000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL, (tu_int)0x0000000100000001uLL << 64 | 0x00000001FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL, (tu_int)0x0000000100000001uLL << 64 | 0x8000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL, (tu_int)0x0000000100000001uLL << 64 | 0x8000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL, (tu_int)0x0000000100000001uLL << 64 | 0x8000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL, (tu_int)0x0000000100000001uLL << 64 | 0x80000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL, (tu_int)0x0000000100000001uLL << 64 | 0xFFFFFFFF00000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL, (tu_int)0x0000000100000001uLL << 64 | 0xFFFFFFFF00000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL, (tu_int)0x0000000100000001uLL << 64 | 0xFFFFFFFF80000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL, (tu_int)0x0000000100000001uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL, (tu_int)0x0000000180000000uLL << 64 | 0x0000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL, (tu_int)0x0000000180000000uLL << 64 | 0x0000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL, (tu_int)0x0000000180000000uLL << 64 | 0x0000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL, (tu_int)0x0000000180000000uLL << 64 | 0x00000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL, (tu_int)0x0000000180000000uLL << 64 | 0x0000000100000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL, (tu_int)0x0000000180000000uLL << 64 | 0x0000000100000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL, (tu_int)0x0000000180000000uLL << 64 | 0x0000000180000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL, (tu_int)0x0000000180000000uLL << 64 | 0x00000001FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL, (tu_int)0x0000000180000000uLL << 64 | 0x8000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL, (tu_int)0x0000000180000000uLL << 64 | 0x8000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL, (tu_int)0x0000000180000000uLL << 64 | 0x8000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL, (tu_int)0x0000000180000000uLL << 64 | 0x80000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL, (tu_int)0x0000000180000000uLL << 64 | 0xFFFFFFFF00000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL, (tu_int)0x0000000180000000uLL << 64 | 0xFFFFFFFF00000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL, (tu_int)0x0000000180000000uLL << 64 | 0xFFFFFFFF80000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL, (tu_int)0x0000000180000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL, (tu_int)0x00000001FFFFFFFFuLL << 64 | 0x0000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL, (tu_int)0x00000001FFFFFFFFuLL << 64 | 0x0000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL, (tu_int)0x00000001FFFFFFFFuLL << 64 | 0x0000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL, (tu_int)0x00000001FFFFFFFFuLL << 64 | 0x00000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL, (tu_int)0x00000001FFFFFFFFuLL << 64 | 0x0000000100000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL, (tu_int)0x00000001FFFFFFFFuLL << 64 | 0x0000000100000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL, (tu_int)0x00000001FFFFFFFFuLL << 64 | 0x0000000180000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL, (tu_int)0x00000001FFFFFFFFuLL << 64 | 0x00000001FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL, (tu_int)0x00000001FFFFFFFFuLL << 64 | 0x8000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL, (tu_int)0x00000001FFFFFFFFuLL << 64 | 0x8000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL, (tu_int)0x00000001FFFFFFFFuLL << 64 | 0x8000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL, (tu_int)0x00000001FFFFFFFFuLL << 64 | 0x80000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL, (tu_int)0x00000001FFFFFFFFuLL << 64 | 0xFFFFFFFF00000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL, (tu_int)0x00000001FFFFFFFFuLL << 64 | 0xFFFFFFFF00000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL, (tu_int)0x00000001FFFFFFFFuLL << 64 | 0xFFFFFFFF80000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL, (tu_int)0x00000001FFFFFFFFuLL << 64 | 0xFFFFFFFFFFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL, (tu_int)0x8000000000000000uLL << 64 | 0x0000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL, (tu_int)0x8000000000000000uLL << 64 | 0x0000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL, (tu_int)0x8000000000000000uLL << 64 | 0x0000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL, (tu_int)0x8000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL, (tu_int)0x8000000000000000uLL << 64 | 0x0000000100000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL, (tu_int)0x8000000000000000uLL << 64 | 0x0000000100000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL, (tu_int)0x8000000000000000uLL << 64 | 0x0000000180000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL, (tu_int)0x8000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL, (tu_int)0x8000000000000000uLL << 64 | 0x8000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL, (tu_int)0x8000000000000000uLL << 64 | 0x8000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL, (tu_int)0x8000000000000000uLL << 64 | 0x8000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL, (tu_int)0x8000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL, (tu_int)0x8000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL, (tu_int)0x8000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL, (tu_int)0x8000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL, (tu_int)0x8000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL, (tu_int)0x8000000000000001uLL << 64 | 0x0000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL, (tu_int)0x8000000000000001uLL << 64 | 0x0000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL, (tu_int)0x8000000000000001uLL << 64 | 0x0000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL, (tu_int)0x8000000000000001uLL << 64 | 0x00000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL, (tu_int)0x8000000000000001uLL << 64 | 0x0000000100000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL, (tu_int)0x8000000000000001uLL << 64 | 0x0000000100000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL, (tu_int)0x8000000000000001uLL << 64 | 0x0000000180000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL, (tu_int)0x8000000000000001uLL << 64 | 0x00000001FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL, (tu_int)0x8000000000000001uLL << 64 | 0x8000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL, (tu_int)0x8000000000000001uLL << 64 | 0x8000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL, (tu_int)0x8000000000000001uLL << 64 | 0x8000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL, (tu_int)0x8000000000000001uLL << 64 | 0x80000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL, (tu_int)0x8000000000000001uLL << 64 | 0xFFFFFFFF00000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL, (tu_int)0x8000000000000001uLL << 64 | 0xFFFFFFFF00000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL, (tu_int)0x8000000000000001uLL << 64 | 0xFFFFFFFF80000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL, (tu_int)0x8000000000000001uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL, (tu_int)0x8000000080000000uLL << 64 | 0x0000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL, (tu_int)0x8000000080000000uLL << 64 | 0x0000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL, (tu_int)0x8000000080000000uLL << 64 | 0x0000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL, (tu_int)0x8000000080000000uLL << 64 | 0x00000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL, (tu_int)0x8000000080000000uLL << 64 | 0x0000000100000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL, (tu_int)0x8000000080000000uLL << 64 | 0x0000000100000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL, (tu_int)0x8000000080000000uLL << 64 | 0x0000000180000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL, (tu_int)0x8000000080000000uLL << 64 | 0x00000001FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL, (tu_int)0x8000000080000000uLL << 64 | 0x8000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL, (tu_int)0x8000000080000000uLL << 64 | 0x8000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL, (tu_int)0x8000000080000000uLL << 64 | 0x8000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL, (tu_int)0x8000000080000000uLL << 64 | 0x80000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL, (tu_int)0x8000000080000000uLL << 64 | 0xFFFFFFFF00000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL, (tu_int)0x8000000080000000uLL << 64 | 0xFFFFFFFF00000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL, (tu_int)0x8000000080000000uLL << 64 | 0xFFFFFFFF80000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL, (tu_int)0x8000000080000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL, (tu_int)0x80000000FFFFFFFFuLL << 64 | 0x0000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL, (tu_int)0x80000000FFFFFFFFuLL << 64 | 0x0000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL, (tu_int)0x80000000FFFFFFFFuLL << 64 | 0x0000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL, (tu_int)0x80000000FFFFFFFFuLL << 64 | 0x00000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL, (tu_int)0x80000000FFFFFFFFuLL << 64 | 0x0000000100000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL, (tu_int)0x80000000FFFFFFFFuLL << 64 | 0x0000000100000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL, (tu_int)0x80000000FFFFFFFFuLL << 64 | 0x0000000180000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL, (tu_int)0x80000000FFFFFFFFuLL << 64 | 0x00000001FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL, (tu_int)0x80000000FFFFFFFFuLL << 64 | 0x8000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL, (tu_int)0x80000000FFFFFFFFuLL << 64 | 0x8000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL, (tu_int)0x80000000FFFFFFFFuLL << 64 | 0x8000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL, (tu_int)0x80000000FFFFFFFFuLL << 64 | 0x80000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL, (tu_int)0x80000000FFFFFFFFuLL << 64 | 0xFFFFFFFF00000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL, (tu_int)0x80000000FFFFFFFFuLL << 64 | 0xFFFFFFFF00000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL, (tu_int)0x80000000FFFFFFFFuLL << 64 | 0xFFFFFFFF80000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL, (tu_int)0x80000000FFFFFFFFuLL << 64 | 0xFFFFFFFFFFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL, (tu_int)0xFFFFFFFF00000000uLL << 64 | 0x0000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL, (tu_int)0xFFFFFFFF00000000uLL << 64 | 0x0000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL, (tu_int)0xFFFFFFFF00000000uLL << 64 | 0x0000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL, (tu_int)0xFFFFFFFF00000000uLL << 64 | 0x00000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL, (tu_int)0xFFFFFFFF00000000uLL << 64 | 0x0000000100000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL, (tu_int)0xFFFFFFFF00000000uLL << 64 | 0x0000000100000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL, (tu_int)0xFFFFFFFF00000000uLL << 64 | 0x0000000180000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL, (tu_int)0xFFFFFFFF00000000uLL << 64 | 0x00000001FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL, (tu_int)0xFFFFFFFF00000000uLL << 64 | 0x8000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL, (tu_int)0xFFFFFFFF00000000uLL << 64 | 0x8000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL, (tu_int)0xFFFFFFFF00000000uLL << 64 | 0x8000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL, (tu_int)0xFFFFFFFF00000000uLL << 64 | 0x80000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL, (tu_int)0xFFFFFFFF00000000uLL << 64 | 0xFFFFFFFF00000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL, (tu_int)0xFFFFFFFF00000000uLL << 64 | 0xFFFFFFFF00000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL, (tu_int)0xFFFFFFFF00000000uLL << 64 | 0xFFFFFFFF80000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL, (tu_int)0xFFFFFFFF00000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL, (tu_int)0xFFFFFFFF00000001uLL << 64 | 0x0000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL, (tu_int)0xFFFFFFFF00000001uLL << 64 | 0x0000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL, (tu_int)0xFFFFFFFF00000001uLL << 64 | 0x0000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL, (tu_int)0xFFFFFFFF00000001uLL << 64 | 0x00000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL, (tu_int)0xFFFFFFFF00000001uLL << 64 | 0x0000000100000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL, (tu_int)0xFFFFFFFF00000001uLL << 64 | 0x0000000100000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL, (tu_int)0xFFFFFFFF00000001uLL << 64 | 0x0000000180000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL, (tu_int)0xFFFFFFFF00000001uLL << 64 | 0x00000001FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL, (tu_int)0xFFFFFFFF00000001uLL << 64 | 0x8000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL, (tu_int)0xFFFFFFFF00000001uLL << 64 | 0x8000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL, (tu_int)0xFFFFFFFF00000001uLL << 64 | 0x8000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL, (tu_int)0xFFFFFFFF00000001uLL << 64 | 0x80000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL, (tu_int)0xFFFFFFFF00000001uLL << 64 | 0xFFFFFFFF00000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL, (tu_int)0xFFFFFFFF00000001uLL << 64 | 0xFFFFFFFF00000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL, (tu_int)0xFFFFFFFF00000001uLL << 64 | 0xFFFFFFFF80000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL, (tu_int)0xFFFFFFFF00000001uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL, (tu_int)0xFFFFFFFF80000000uLL << 64 | 0x0000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL, (tu_int)0xFFFFFFFF80000000uLL << 64 | 0x0000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL, (tu_int)0xFFFFFFFF80000000uLL << 64 | 0x0000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL, (tu_int)0xFFFFFFFF80000000uLL << 64 | 0x00000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL, (tu_int)0xFFFFFFFF80000000uLL << 64 | 0x0000000100000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL, (tu_int)0xFFFFFFFF80000000uLL << 64 | 0x0000000100000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL, (tu_int)0xFFFFFFFF80000000uLL << 64 | 0x0000000180000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL, (tu_int)0xFFFFFFFF80000000uLL << 64 | 0x00000001FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL, (tu_int)0xFFFFFFFF80000000uLL << 64 | 0x8000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL, (tu_int)0xFFFFFFFF80000000uLL << 64 | 0x8000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL, (tu_int)0xFFFFFFFF80000000uLL << 64 | 0x8000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL, (tu_int)0xFFFFFFFF80000000uLL << 64 | 0x80000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL, (tu_int)0xFFFFFFFF80000000uLL << 64 | 0xFFFFFFFF00000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL, (tu_int)0xFFFFFFFF80000000uLL << 64 | 0xFFFFFFFF00000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL, (tu_int)0xFFFFFFFF80000000uLL << 64 | 0xFFFFFFFF80000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL, (tu_int)0xFFFFFFFF80000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL, (tu_int)0xFFFFFFFFFFFFFFFFuLL << 64 | 0x0000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL, (tu_int)0xFFFFFFFFFFFFFFFFuLL << 64 | 0x0000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL, (tu_int)0xFFFFFFFFFFFFFFFFuLL << 64 | 0x0000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL, (tu_int)0xFFFFFFFFFFFFFFFFuLL << 64 | 0x00000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL, (tu_int)0xFFFFFFFFFFFFFFFFuLL << 64 | 0x0000000100000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL, (tu_int)0xFFFFFFFFFFFFFFFFuLL << 64 | 0x0000000100000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL, (tu_int)0xFFFFFFFFFFFFFFFFuLL << 64 | 0x0000000180000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL, (tu_int)0xFFFFFFFFFFFFFFFFuLL << 64 | 0x00000001FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL, (tu_int)0xFFFFFFFFFFFFFFFFuLL << 64 | 0x8000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL, (tu_int)0xFFFFFFFFFFFFFFFFuLL << 64 | 0x8000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL, (tu_int)0xFFFFFFFFFFFFFFFFuLL << 64 | 0x8000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL, (tu_int)0xFFFFFFFFFFFFFFFFuLL << 64 | 0x80000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL, (tu_int)0xFFFFFFFFFFFFFFFFuLL << 64 | 0xFFFFFFFF00000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL, (tu_int)0xFFFFFFFFFFFFFFFFuLL << 64 | 0xFFFFFFFF00000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL, (tu_int)0xFFFFFFFFFFFFFFFFuLL << 64 | 0xFFFFFFFF80000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL, (tu_int)0xFFFFFFFFFFFFFFFFuLL << 64 | 0xFFFFFFFFFFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFEuLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000080000002uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x00000000AAAAAAAAuLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL, (tu_int)0x0000000000000000uLL << 64 | 0x7FFFFFFF80000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL, (tu_int)0x0000000000000000uLL << 64 | 0x7FFFFFFF7FFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL, (tu_int)0x0000000000000000uLL << 64 | 0x7FFFFFFF00000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL, (tu_int)0x0000000000000000uLL << 64 | 0x7FFFFFFE80000001uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL, (tu_int)0x0000000000000000uLL << 64 | 0x000000007FFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL, (tu_int)0x0000000000000001uLL << 64 | 0x0000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL, (tu_int)0x0000000000000001uLL << 64 | 0x0000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL, (tu_int)0x0000000000000001uLL << 64 | 0x0000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL, (tu_int)0x0000000000000001uLL << 64 | 0x00000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL, (tu_int)0x0000000000000001uLL << 64 | 0x0000000100000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL, (tu_int)0x0000000000000001uLL << 64 | 0x0000000100000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL, (tu_int)0x0000000000000001uLL << 64 | 0x0000000180000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL, (tu_int)0x0000000000000001uLL << 64 | 0x00000001FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL, (tu_int)0x0000000000000001uLL << 64 | 0x8000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL, (tu_int)0x0000000000000001uLL << 64 | 0x8000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL, (tu_int)0x0000000000000001uLL << 64 | 0x8000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL, (tu_int)0x0000000000000001uLL << 64 | 0x80000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL, (tu_int)0x0000000000000001uLL << 64 | 0xFFFFFFFF00000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL, (tu_int)0x0000000000000001uLL << 64 | 0xFFFFFFFF00000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL, (tu_int)0x0000000000000001uLL << 64 | 0xFFFFFFFF80000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL, (tu_int)0x0000000000000001uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL, (tu_int)0x0000000080000000uLL << 64 | 0x0000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL, (tu_int)0x0000000080000000uLL << 64 | 0x0000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL, (tu_int)0x0000000080000000uLL << 64 | 0x0000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL, (tu_int)0x0000000080000000uLL << 64 | 0x00000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL, (tu_int)0x0000000080000000uLL << 64 | 0x0000000100000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL, (tu_int)0x0000000080000000uLL << 64 | 0x0000000100000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL, (tu_int)0x0000000080000000uLL << 64 | 0x0000000180000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL, (tu_int)0x0000000080000000uLL << 64 | 0x00000001FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL, (tu_int)0x0000000080000000uLL << 64 | 0x8000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL, (tu_int)0x0000000080000000uLL << 64 | 0x8000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL, (tu_int)0x0000000080000000uLL << 64 | 0x8000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL, (tu_int)0x0000000080000000uLL << 64 | 0x80000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL, (tu_int)0x0000000080000000uLL << 64 | 0xFFFFFFFF00000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL, (tu_int)0x0000000080000000uLL << 64 | 0xFFFFFFFF00000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL, (tu_int)0x0000000080000000uLL << 64 | 0xFFFFFFFF80000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL, (tu_int)0x0000000080000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL, (tu_int)0x00000000FFFFFFFFuLL << 64 | 0x0000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL, (tu_int)0x00000000FFFFFFFFuLL << 64 | 0x0000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL, (tu_int)0x00000000FFFFFFFFuLL << 64 | 0x0000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL, (tu_int)0x00000000FFFFFFFFuLL << 64 | 0x00000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL, (tu_int)0x00000000FFFFFFFFuLL << 64 | 0x0000000100000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL, (tu_int)0x00000000FFFFFFFFuLL << 64 | 0x0000000100000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL, (tu_int)0x00000000FFFFFFFFuLL << 64 | 0x0000000180000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL, (tu_int)0x00000000FFFFFFFFuLL << 64 | 0x00000001FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL, (tu_int)0x00000000FFFFFFFFuLL << 64 | 0x8000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL, (tu_int)0x00000000FFFFFFFFuLL << 64 | 0x8000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL, (tu_int)0x00000000FFFFFFFFuLL << 64 | 0x8000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL, (tu_int)0x00000000FFFFFFFFuLL << 64 | 0x80000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL, (tu_int)0x00000000FFFFFFFFuLL << 64 | 0xFFFFFFFF00000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL, (tu_int)0x00000000FFFFFFFFuLL << 64 | 0xFFFFFFFF00000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL, (tu_int)0x00000000FFFFFFFFuLL << 64 | 0xFFFFFFFF80000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL, (tu_int)0x00000000FFFFFFFFuLL << 64 | 0xFFFFFFFFFFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL, (tu_int)0x0000000100000000uLL << 64 | 0x0000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL, (tu_int)0x0000000100000000uLL << 64 | 0x0000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL, (tu_int)0x0000000100000000uLL << 64 | 0x0000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL, (tu_int)0x0000000100000000uLL << 64 | 0x00000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL, (tu_int)0x0000000100000000uLL << 64 | 0x0000000100000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL, (tu_int)0x0000000100000000uLL << 64 | 0x0000000100000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL, (tu_int)0x0000000100000000uLL << 64 | 0x0000000180000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL, (tu_int)0x0000000100000000uLL << 64 | 0x00000001FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL, (tu_int)0x0000000100000000uLL << 64 | 0x8000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL, (tu_int)0x0000000100000000uLL << 64 | 0x8000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL, (tu_int)0x0000000100000000uLL << 64 | 0x8000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL, (tu_int)0x0000000100000000uLL << 64 | 0x80000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL, (tu_int)0x0000000100000000uLL << 64 | 0xFFFFFFFF00000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL, (tu_int)0x0000000100000000uLL << 64 | 0xFFFFFFFF00000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL, (tu_int)0x0000000100000000uLL << 64 | 0xFFFFFFFF80000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL, (tu_int)0x0000000100000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL, (tu_int)0x0000000100000001uLL << 64 | 0x0000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL, (tu_int)0x0000000100000001uLL << 64 | 0x0000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL, (tu_int)0x0000000100000001uLL << 64 | 0x0000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL, (tu_int)0x0000000100000001uLL << 64 | 0x00000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL, (tu_int)0x0000000100000001uLL << 64 | 0x0000000100000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL, (tu_int)0x0000000100000001uLL << 64 | 0x0000000100000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL, (tu_int)0x0000000100000001uLL << 64 | 0x0000000180000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL, (tu_int)0x0000000100000001uLL << 64 | 0x00000001FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL, (tu_int)0x0000000100000001uLL << 64 | 0x8000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL, (tu_int)0x0000000100000001uLL << 64 | 0x8000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL, (tu_int)0x0000000100000001uLL << 64 | 0x8000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL, (tu_int)0x0000000100000001uLL << 64 | 0x80000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL, (tu_int)0x0000000100000001uLL << 64 | 0xFFFFFFFF00000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL, (tu_int)0x0000000100000001uLL << 64 | 0xFFFFFFFF00000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL, (tu_int)0x0000000100000001uLL << 64 | 0xFFFFFFFF80000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL, (tu_int)0x0000000100000001uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL, (tu_int)0x0000000180000000uLL << 64 | 0x0000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL, (tu_int)0x0000000180000000uLL << 64 | 0x0000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL, (tu_int)0x0000000180000000uLL << 64 | 0x0000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL, (tu_int)0x0000000180000000uLL << 64 | 0x00000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL, (tu_int)0x0000000180000000uLL << 64 | 0x0000000100000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL, (tu_int)0x0000000180000000uLL << 64 | 0x0000000100000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL, (tu_int)0x0000000180000000uLL << 64 | 0x0000000180000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL, (tu_int)0x0000000180000000uLL << 64 | 0x00000001FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL, (tu_int)0x0000000180000000uLL << 64 | 0x8000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL, (tu_int)0x0000000180000000uLL << 64 | 0x8000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL, (tu_int)0x0000000180000000uLL << 64 | 0x8000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL, (tu_int)0x0000000180000000uLL << 64 | 0x80000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL, (tu_int)0x0000000180000000uLL << 64 | 0xFFFFFFFF00000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL, (tu_int)0x0000000180000000uLL << 64 | 0xFFFFFFFF00000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL, (tu_int)0x0000000180000000uLL << 64 | 0xFFFFFFFF80000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL, (tu_int)0x0000000180000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL, (tu_int)0x00000001FFFFFFFFuLL << 64 | 0x0000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL, (tu_int)0x00000001FFFFFFFFuLL << 64 | 0x0000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL, (tu_int)0x00000001FFFFFFFFuLL << 64 | 0x0000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL, (tu_int)0x00000001FFFFFFFFuLL << 64 | 0x00000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL, (tu_int)0x00000001FFFFFFFFuLL << 64 | 0x0000000100000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL, (tu_int)0x00000001FFFFFFFFuLL << 64 | 0x0000000100000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL, (tu_int)0x00000001FFFFFFFFuLL << 64 | 0x0000000180000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL, (tu_int)0x00000001FFFFFFFFuLL << 64 | 0x00000001FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL, (tu_int)0x00000001FFFFFFFFuLL << 64 | 0x8000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL, (tu_int)0x00000001FFFFFFFFuLL << 64 | 0x8000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL, (tu_int)0x00000001FFFFFFFFuLL << 64 | 0x8000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL, (tu_int)0x00000001FFFFFFFFuLL << 64 | 0x80000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL, (tu_int)0x00000001FFFFFFFFuLL << 64 | 0xFFFFFFFF00000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL, (tu_int)0x00000001FFFFFFFFuLL << 64 | 0xFFFFFFFF00000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL, (tu_int)0x00000001FFFFFFFFuLL << 64 | 0xFFFFFFFF80000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL, (tu_int)0x00000001FFFFFFFFuLL << 64 | 0xFFFFFFFFFFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL, (tu_int)0x8000000000000000uLL << 64 | 0x0000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL, (tu_int)0x8000000000000000uLL << 64 | 0x0000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL, (tu_int)0x8000000000000000uLL << 64 | 0x0000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL, (tu_int)0x8000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL, (tu_int)0x8000000000000000uLL << 64 | 0x0000000100000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL, (tu_int)0x8000000000000000uLL << 64 | 0x0000000100000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL, (tu_int)0x8000000000000000uLL << 64 | 0x0000000180000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL, (tu_int)0x8000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL, (tu_int)0x8000000000000000uLL << 64 | 0x8000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL, (tu_int)0x8000000000000000uLL << 64 | 0x8000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL, (tu_int)0x8000000000000000uLL << 64 | 0x8000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL, (tu_int)0x8000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL, (tu_int)0x8000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL, (tu_int)0x8000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL, (tu_int)0x8000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL, (tu_int)0x8000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL, (tu_int)0x8000000000000001uLL << 64 | 0x0000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL, (tu_int)0x8000000000000001uLL << 64 | 0x0000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL, (tu_int)0x8000000000000001uLL << 64 | 0x0000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL, (tu_int)0x8000000000000001uLL << 64 | 0x00000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL, (tu_int)0x8000000000000001uLL << 64 | 0x0000000100000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL, (tu_int)0x8000000000000001uLL << 64 | 0x0000000100000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL, (tu_int)0x8000000000000001uLL << 64 | 0x0000000180000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL, (tu_int)0x8000000000000001uLL << 64 | 0x00000001FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL, (tu_int)0x8000000000000001uLL << 64 | 0x8000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL, (tu_int)0x8000000000000001uLL << 64 | 0x8000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL, (tu_int)0x8000000000000001uLL << 64 | 0x8000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL, (tu_int)0x8000000000000001uLL << 64 | 0x80000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL, (tu_int)0x8000000000000001uLL << 64 | 0xFFFFFFFF00000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL, (tu_int)0x8000000000000001uLL << 64 | 0xFFFFFFFF00000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL, (tu_int)0x8000000000000001uLL << 64 | 0xFFFFFFFF80000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL, (tu_int)0x8000000000000001uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL, (tu_int)0x8000000080000000uLL << 64 | 0x0000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL, (tu_int)0x8000000080000000uLL << 64 | 0x0000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL, (tu_int)0x8000000080000000uLL << 64 | 0x0000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL, (tu_int)0x8000000080000000uLL << 64 | 0x00000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL, (tu_int)0x8000000080000000uLL << 64 | 0x0000000100000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL, (tu_int)0x8000000080000000uLL << 64 | 0x0000000100000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL, (tu_int)0x8000000080000000uLL << 64 | 0x0000000180000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL, (tu_int)0x8000000080000000uLL << 64 | 0x00000001FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL, (tu_int)0x8000000080000000uLL << 64 | 0x8000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL, (tu_int)0x8000000080000000uLL << 64 | 0x8000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL, (tu_int)0x8000000080000000uLL << 64 | 0x8000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL, (tu_int)0x8000000080000000uLL << 64 | 0x80000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL, (tu_int)0x8000000080000000uLL << 64 | 0xFFFFFFFF00000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL, (tu_int)0x8000000080000000uLL << 64 | 0xFFFFFFFF00000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL, (tu_int)0x8000000080000000uLL << 64 | 0xFFFFFFFF80000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL, (tu_int)0x8000000080000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL, (tu_int)0x80000000FFFFFFFFuLL << 64 | 0x0000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL, (tu_int)0x80000000FFFFFFFFuLL << 64 | 0x0000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL, (tu_int)0x80000000FFFFFFFFuLL << 64 | 0x0000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL, (tu_int)0x80000000FFFFFFFFuLL << 64 | 0x00000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL, (tu_int)0x80000000FFFFFFFFuLL << 64 | 0x0000000100000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL, (tu_int)0x80000000FFFFFFFFuLL << 64 | 0x0000000100000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL, (tu_int)0x80000000FFFFFFFFuLL << 64 | 0x0000000180000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL, (tu_int)0x80000000FFFFFFFFuLL << 64 | 0x00000001FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL, (tu_int)0x80000000FFFFFFFFuLL << 64 | 0x8000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL, (tu_int)0x80000000FFFFFFFFuLL << 64 | 0x8000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL, (tu_int)0x80000000FFFFFFFFuLL << 64 | 0x8000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL, (tu_int)0x80000000FFFFFFFFuLL << 64 | 0x80000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL, (tu_int)0x80000000FFFFFFFFuLL << 64 | 0xFFFFFFFF00000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL, (tu_int)0x80000000FFFFFFFFuLL << 64 | 0xFFFFFFFF00000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL, (tu_int)0x80000000FFFFFFFFuLL << 64 | 0xFFFFFFFF80000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL, (tu_int)0x80000000FFFFFFFFuLL << 64 | 0xFFFFFFFFFFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL, (tu_int)0xFFFFFFFF00000000uLL << 64 | 0x0000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL, (tu_int)0xFFFFFFFF00000000uLL << 64 | 0x0000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL, (tu_int)0xFFFFFFFF00000000uLL << 64 | 0x0000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL, (tu_int)0xFFFFFFFF00000000uLL << 64 | 0x00000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL, (tu_int)0xFFFFFFFF00000000uLL << 64 | 0x0000000100000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL, (tu_int)0xFFFFFFFF00000000uLL << 64 | 0x0000000100000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL, (tu_int)0xFFFFFFFF00000000uLL << 64 | 0x0000000180000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL, (tu_int)0xFFFFFFFF00000000uLL << 64 | 0x00000001FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL, (tu_int)0xFFFFFFFF00000000uLL << 64 | 0x8000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL, (tu_int)0xFFFFFFFF00000000uLL << 64 | 0x8000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL, (tu_int)0xFFFFFFFF00000000uLL << 64 | 0x8000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL, (tu_int)0xFFFFFFFF00000000uLL << 64 | 0x80000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL, (tu_int)0xFFFFFFFF00000000uLL << 64 | 0xFFFFFFFF00000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL, (tu_int)0xFFFFFFFF00000000uLL << 64 | 0xFFFFFFFF00000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL, (tu_int)0xFFFFFFFF00000000uLL << 64 | 0xFFFFFFFF80000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL, (tu_int)0xFFFFFFFF00000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL, (tu_int)0xFFFFFFFF00000001uLL << 64 | 0x0000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL, (tu_int)0xFFFFFFFF00000001uLL << 64 | 0x0000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL, (tu_int)0xFFFFFFFF00000001uLL << 64 | 0x0000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL, (tu_int)0xFFFFFFFF00000001uLL << 64 | 0x00000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL, (tu_int)0xFFFFFFFF00000001uLL << 64 | 0x0000000100000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL, (tu_int)0xFFFFFFFF00000001uLL << 64 | 0x0000000100000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL, (tu_int)0xFFFFFFFF00000001uLL << 64 | 0x0000000180000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL, (tu_int)0xFFFFFFFF00000001uLL << 64 | 0x00000001FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL, (tu_int)0xFFFFFFFF00000001uLL << 64 | 0x8000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL, (tu_int)0xFFFFFFFF00000001uLL << 64 | 0x8000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL, (tu_int)0xFFFFFFFF00000001uLL << 64 | 0x8000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL, (tu_int)0xFFFFFFFF00000001uLL << 64 | 0x80000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL, (tu_int)0xFFFFFFFF00000001uLL << 64 | 0xFFFFFFFF00000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL, (tu_int)0xFFFFFFFF00000001uLL << 64 | 0xFFFFFFFF00000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL, (tu_int)0xFFFFFFFF00000001uLL << 64 | 0xFFFFFFFF80000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL, (tu_int)0xFFFFFFFF00000001uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL, (tu_int)0xFFFFFFFF80000000uLL << 64 | 0x0000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL, (tu_int)0xFFFFFFFF80000000uLL << 64 | 0x0000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL, (tu_int)0xFFFFFFFF80000000uLL << 64 | 0x0000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL, (tu_int)0xFFFFFFFF80000000uLL << 64 | 0x00000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL, (tu_int)0xFFFFFFFF80000000uLL << 64 | 0x0000000100000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL, (tu_int)0xFFFFFFFF80000000uLL << 64 | 0x0000000100000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL, (tu_int)0xFFFFFFFF80000000uLL << 64 | 0x0000000180000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL, (tu_int)0xFFFFFFFF80000000uLL << 64 | 0x00000001FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL, (tu_int)0xFFFFFFFF80000000uLL << 64 | 0x8000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL, (tu_int)0xFFFFFFFF80000000uLL << 64 | 0x8000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL, (tu_int)0xFFFFFFFF80000000uLL << 64 | 0x8000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL, (tu_int)0xFFFFFFFF80000000uLL << 64 | 0x80000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL, (tu_int)0xFFFFFFFF80000000uLL << 64 | 0xFFFFFFFF00000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL, (tu_int)0xFFFFFFFF80000000uLL << 64 | 0xFFFFFFFF00000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL, (tu_int)0xFFFFFFFF80000000uLL << 64 | 0xFFFFFFFF80000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL, (tu_int)0xFFFFFFFF80000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL, (tu_int)0xFFFFFFFFFFFFFFFFuLL << 64 | 0x0000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL, (tu_int)0xFFFFFFFFFFFFFFFFuLL << 64 | 0x0000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL, (tu_int)0xFFFFFFFFFFFFFFFFuLL << 64 | 0x0000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL, (tu_int)0xFFFFFFFFFFFFFFFFuLL << 64 | 0x00000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL, (tu_int)0xFFFFFFFFFFFFFFFFuLL << 64 | 0x0000000100000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL, (tu_int)0xFFFFFFFFFFFFFFFFuLL << 64 | 0x0000000100000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL, (tu_int)0xFFFFFFFFFFFFFFFFuLL << 64 | 0x0000000180000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL, (tu_int)0xFFFFFFFFFFFFFFFFuLL << 64 | 0x00000001FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL, (tu_int)0xFFFFFFFFFFFFFFFFuLL << 64 | 0x8000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL, (tu_int)0xFFFFFFFFFFFFFFFFuLL << 64 | 0x8000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL, (tu_int)0xFFFFFFFFFFFFFFFFuLL << 64 | 0x8000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL, (tu_int)0xFFFFFFFFFFFFFFFFuLL << 64 | 0x80000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL, (tu_int)0xFFFFFFFFFFFFFFFFuLL << 64 | 0xFFFFFFFF00000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL, (tu_int)0xFFFFFFFFFFFFFFFFuLL << 64 | 0xFFFFFFFF00000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL, (tu_int)0xFFFFFFFFFFFFFFFFuLL << 64 | 0xFFFFFFFF80000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL, (tu_int)0xFFFFFFFFFFFFFFFFuLL << 64 | 0xFFFFFFFFFFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL, (tu_int)0x0000000000000000uLL << 64 | 0x000000007FFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000100000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000180000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x00000000AAAAAAAAuLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000080000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0x000000007FFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL, (tu_int)0x0000000000000000uLL << 64 | 0x7FFFFFFFFFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL, (tu_int)0x0000000000000000uLL << 64 | 0x7FFFFFFFFFFFFFFEuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL, (tu_int)0x0000000000000000uLL << 64 | 0x8000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL, (tu_int)0x0000000000000000uLL << 64 | 0x7FFFFFFF7FFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL, (tu_int)0x0000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL, (tu_int)0x0000000000000000uLL << 64 | 0x7FFFFFFF00000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL, (tu_int)0x0000000000000000uLL << 64 | 0x00000000FFFFFFFEuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL, (tu_int)0x0000000000000000uLL << 64 | 0x000000007FFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000001uLL, (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL, (tu_int)0x0000000000000001uLL << 64 | 0x0000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL, (tu_int)0x0000000000000001uLL << 64 | 0x0000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL, (tu_int)0x0000000000000001uLL << 64 | 0x0000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL, (tu_int)0x0000000000000001uLL << 64 | 0x00000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL, (tu_int)0x0000000000000001uLL << 64 | 0x0000000100000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL, (tu_int)0x0000000000000001uLL << 64 | 0x0000000100000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL, (tu_int)0x0000000000000001uLL << 64 | 0x0000000180000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL, (tu_int)0x0000000000000001uLL << 64 | 0x00000001FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL, (tu_int)0x0000000000000001uLL << 64 | 0x8000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL, (tu_int)0x0000000000000001uLL << 64 | 0x8000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL, (tu_int)0x0000000000000001uLL << 64 | 0x8000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL, (tu_int)0x0000000000000001uLL << 64 | 0x80000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL, (tu_int)0x0000000000000001uLL << 64 | 0xFFFFFFFF00000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL, (tu_int)0x0000000000000001uLL << 64 | 0xFFFFFFFF00000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL, (tu_int)0x0000000000000001uLL << 64 | 0xFFFFFFFF80000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL, (tu_int)0x0000000000000001uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL, (tu_int)0x0000000080000000uLL << 64 | 0x0000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL, (tu_int)0x0000000080000000uLL << 64 | 0x0000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL, (tu_int)0x0000000080000000uLL << 64 | 0x0000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL, (tu_int)0x0000000080000000uLL << 64 | 0x00000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL, (tu_int)0x0000000080000000uLL << 64 | 0x0000000100000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL, (tu_int)0x0000000080000000uLL << 64 | 0x0000000100000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL, (tu_int)0x0000000080000000uLL << 64 | 0x0000000180000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL, (tu_int)0x0000000080000000uLL << 64 | 0x00000001FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL, (tu_int)0x0000000080000000uLL << 64 | 0x8000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL, (tu_int)0x0000000080000000uLL << 64 | 0x8000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL, (tu_int)0x0000000080000000uLL << 64 | 0x8000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL, (tu_int)0x0000000080000000uLL << 64 | 0x80000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL, (tu_int)0x0000000080000000uLL << 64 | 0xFFFFFFFF00000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL, (tu_int)0x0000000080000000uLL << 64 | 0xFFFFFFFF00000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL, (tu_int)0x0000000080000000uLL << 64 | 0xFFFFFFFF80000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL, (tu_int)0x0000000080000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL, (tu_int)0x00000000FFFFFFFFuLL << 64 | 0x0000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL, (tu_int)0x00000000FFFFFFFFuLL << 64 | 0x0000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL, (tu_int)0x00000000FFFFFFFFuLL << 64 | 0x0000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL, (tu_int)0x00000000FFFFFFFFuLL << 64 | 0x00000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL, (tu_int)0x00000000FFFFFFFFuLL << 64 | 0x0000000100000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL, (tu_int)0x00000000FFFFFFFFuLL << 64 | 0x0000000100000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL, (tu_int)0x00000000FFFFFFFFuLL << 64 | 0x0000000180000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL, (tu_int)0x00000000FFFFFFFFuLL << 64 | 0x00000001FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL, (tu_int)0x00000000FFFFFFFFuLL << 64 | 0x8000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL, (tu_int)0x00000000FFFFFFFFuLL << 64 | 0x8000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL, (tu_int)0x00000000FFFFFFFFuLL << 64 | 0x8000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL, (tu_int)0x00000000FFFFFFFFuLL << 64 | 0x80000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL, (tu_int)0x00000000FFFFFFFFuLL << 64 | 0xFFFFFFFF00000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL, (tu_int)0x00000000FFFFFFFFuLL << 64 | 0xFFFFFFFF00000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL, (tu_int)0x00000000FFFFFFFFuLL << 64 | 0xFFFFFFFF80000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL, (tu_int)0x00000000FFFFFFFFuLL << 64 | 0xFFFFFFFFFFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL, (tu_int)0x0000000100000000uLL << 64 | 0x0000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL, (tu_int)0x0000000100000000uLL << 64 | 0x0000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL, (tu_int)0x0000000100000000uLL << 64 | 0x0000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL, (tu_int)0x0000000100000000uLL << 64 | 0x00000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL, (tu_int)0x0000000100000000uLL << 64 | 0x0000000100000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL, (tu_int)0x0000000100000000uLL << 64 | 0x0000000100000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL, (tu_int)0x0000000100000000uLL << 64 | 0x0000000180000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL, (tu_int)0x0000000100000000uLL << 64 | 0x00000001FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL, (tu_int)0x0000000100000000uLL << 64 | 0x8000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL, (tu_int)0x0000000100000000uLL << 64 | 0x8000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL, (tu_int)0x0000000100000000uLL << 64 | 0x8000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL, (tu_int)0x0000000100000000uLL << 64 | 0x80000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL, (tu_int)0x0000000100000000uLL << 64 | 0xFFFFFFFF00000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL, (tu_int)0x0000000100000000uLL << 64 | 0xFFFFFFFF00000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL, (tu_int)0x0000000100000000uLL << 64 | 0xFFFFFFFF80000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL, (tu_int)0x0000000100000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL, (tu_int)0x0000000100000001uLL << 64 | 0x0000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL, (tu_int)0x0000000100000001uLL << 64 | 0x0000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL, (tu_int)0x0000000100000001uLL << 64 | 0x0000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL, (tu_int)0x0000000100000001uLL << 64 | 0x00000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL, (tu_int)0x0000000100000001uLL << 64 | 0x0000000100000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL, (tu_int)0x0000000100000001uLL << 64 | 0x0000000100000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL, (tu_int)0x0000000100000001uLL << 64 | 0x0000000180000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL, (tu_int)0x0000000100000001uLL << 64 | 0x00000001FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL, (tu_int)0x0000000100000001uLL << 64 | 0x8000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL, (tu_int)0x0000000100000001uLL << 64 | 0x8000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL, (tu_int)0x0000000100000001uLL << 64 | 0x8000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL, (tu_int)0x0000000100000001uLL << 64 | 0x80000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL, (tu_int)0x0000000100000001uLL << 64 | 0xFFFFFFFF00000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL, (tu_int)0x0000000100000001uLL << 64 | 0xFFFFFFFF00000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL, (tu_int)0x0000000100000001uLL << 64 | 0xFFFFFFFF80000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL, (tu_int)0x0000000100000001uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL, (tu_int)0x0000000180000000uLL << 64 | 0x0000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL, (tu_int)0x0000000180000000uLL << 64 | 0x0000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL, (tu_int)0x0000000180000000uLL << 64 | 0x0000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL, (tu_int)0x0000000180000000uLL << 64 | 0x00000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL, (tu_int)0x0000000180000000uLL << 64 | 0x0000000100000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL, (tu_int)0x0000000180000000uLL << 64 | 0x0000000100000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL, (tu_int)0x0000000180000000uLL << 64 | 0x0000000180000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL, (tu_int)0x0000000180000000uLL << 64 | 0x00000001FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL, (tu_int)0x0000000180000000uLL << 64 | 0x8000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL, (tu_int)0x0000000180000000uLL << 64 | 0x8000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL, (tu_int)0x0000000180000000uLL << 64 | 0x8000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL, (tu_int)0x0000000180000000uLL << 64 | 0x80000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL, (tu_int)0x0000000180000000uLL << 64 | 0xFFFFFFFF00000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL, (tu_int)0x0000000180000000uLL << 64 | 0xFFFFFFFF00000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL, (tu_int)0x0000000180000000uLL << 64 | 0xFFFFFFFF80000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL, (tu_int)0x0000000180000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL, (tu_int)0x00000001FFFFFFFFuLL << 64 | 0x0000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL, (tu_int)0x00000001FFFFFFFFuLL << 64 | 0x0000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL, (tu_int)0x00000001FFFFFFFFuLL << 64 | 0x0000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL, (tu_int)0x00000001FFFFFFFFuLL << 64 | 0x00000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL, (tu_int)0x00000001FFFFFFFFuLL << 64 | 0x0000000100000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL, (tu_int)0x00000001FFFFFFFFuLL << 64 | 0x0000000100000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL, (tu_int)0x00000001FFFFFFFFuLL << 64 | 0x0000000180000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL, (tu_int)0x00000001FFFFFFFFuLL << 64 | 0x00000001FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL, (tu_int)0x00000001FFFFFFFFuLL << 64 | 0x8000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL, (tu_int)0x00000001FFFFFFFFuLL << 64 | 0x8000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL, (tu_int)0x00000001FFFFFFFFuLL << 64 | 0x8000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL, (tu_int)0x00000001FFFFFFFFuLL << 64 | 0x80000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL, (tu_int)0x00000001FFFFFFFFuLL << 64 | 0xFFFFFFFF00000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL, (tu_int)0x00000001FFFFFFFFuLL << 64 | 0xFFFFFFFF00000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL, (tu_int)0x00000001FFFFFFFFuLL << 64 | 0xFFFFFFFF80000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL, (tu_int)0x00000001FFFFFFFFuLL << 64 | 0xFFFFFFFFFFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL, (tu_int)0x8000000000000000uLL << 64 | 0x0000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL, (tu_int)0x8000000000000000uLL << 64 | 0x0000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL, (tu_int)0x8000000000000000uLL << 64 | 0x0000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL, (tu_int)0x8000000000000000uLL << 64 | 0x00000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL, (tu_int)0x8000000000000000uLL << 64 | 0x0000000100000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL, (tu_int)0x8000000000000000uLL << 64 | 0x0000000100000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL, (tu_int)0x8000000000000000uLL << 64 | 0x0000000180000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL, (tu_int)0x8000000000000000uLL << 64 | 0x00000001FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL, (tu_int)0x8000000000000000uLL << 64 | 0x8000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL, (tu_int)0x8000000000000000uLL << 64 | 0x8000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL, (tu_int)0x8000000000000000uLL << 64 | 0x8000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL, (tu_int)0x8000000000000000uLL << 64 | 0x80000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL, (tu_int)0x8000000000000000uLL << 64 | 0xFFFFFFFF00000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL, (tu_int)0x8000000000000000uLL << 64 | 0xFFFFFFFF00000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL, (tu_int)0x8000000000000000uLL << 64 | 0xFFFFFFFF80000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL, (tu_int)0x8000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL, (tu_int)0x8000000000000001uLL << 64 | 0x0000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL, (tu_int)0x8000000000000001uLL << 64 | 0x0000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL, (tu_int)0x8000000000000001uLL << 64 | 0x0000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL, (tu_int)0x8000000000000001uLL << 64 | 0x00000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL, (tu_int)0x8000000000000001uLL << 64 | 0x0000000100000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL, (tu_int)0x8000000000000001uLL << 64 | 0x0000000100000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL, (tu_int)0x8000000000000001uLL << 64 | 0x0000000180000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL, (tu_int)0x8000000000000001uLL << 64 | 0x00000001FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL, (tu_int)0x8000000000000001uLL << 64 | 0x8000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL, (tu_int)0x8000000000000001uLL << 64 | 0x8000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL, (tu_int)0x8000000000000001uLL << 64 | 0x8000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL, (tu_int)0x8000000000000001uLL << 64 | 0x80000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL, (tu_int)0x8000000000000001uLL << 64 | 0xFFFFFFFF00000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL, (tu_int)0x8000000000000001uLL << 64 | 0xFFFFFFFF00000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL, (tu_int)0x8000000000000001uLL << 64 | 0xFFFFFFFF80000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL, (tu_int)0x8000000000000001uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL, (tu_int)0x8000000080000000uLL << 64 | 0x0000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL, (tu_int)0x8000000080000000uLL << 64 | 0x0000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL, (tu_int)0x8000000080000000uLL << 64 | 0x0000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL, (tu_int)0x8000000080000000uLL << 64 | 0x00000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL, (tu_int)0x8000000080000000uLL << 64 | 0x0000000100000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL, (tu_int)0x8000000080000000uLL << 64 | 0x0000000100000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL, (tu_int)0x8000000080000000uLL << 64 | 0x0000000180000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL, (tu_int)0x8000000080000000uLL << 64 | 0x00000001FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL, (tu_int)0x8000000080000000uLL << 64 | 0x8000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL, (tu_int)0x8000000080000000uLL << 64 | 0x8000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL, (tu_int)0x8000000080000000uLL << 64 | 0x8000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL, (tu_int)0x8000000080000000uLL << 64 | 0x80000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL, (tu_int)0x8000000080000000uLL << 64 | 0xFFFFFFFF00000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL, (tu_int)0x8000000080000000uLL << 64 | 0xFFFFFFFF00000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL, (tu_int)0x8000000080000000uLL << 64 | 0xFFFFFFFF80000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL, (tu_int)0x8000000080000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL, (tu_int)0x80000000FFFFFFFFuLL << 64 | 0x0000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL, (tu_int)0x80000000FFFFFFFFuLL << 64 | 0x0000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL, (tu_int)0x80000000FFFFFFFFuLL << 64 | 0x0000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL, (tu_int)0x80000000FFFFFFFFuLL << 64 | 0x00000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL, (tu_int)0x80000000FFFFFFFFuLL << 64 | 0x0000000100000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL, (tu_int)0x80000000FFFFFFFFuLL << 64 | 0x0000000100000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL, (tu_int)0x80000000FFFFFFFFuLL << 64 | 0x0000000180000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL, (tu_int)0x80000000FFFFFFFFuLL << 64 | 0x00000001FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL, (tu_int)0x80000000FFFFFFFFuLL << 64 | 0x8000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL, (tu_int)0x80000000FFFFFFFFuLL << 64 | 0x8000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL, (tu_int)0x80000000FFFFFFFFuLL << 64 | 0x8000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL, (tu_int)0x80000000FFFFFFFFuLL << 64 | 0x80000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL, (tu_int)0x80000000FFFFFFFFuLL << 64 | 0xFFFFFFFF00000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL, (tu_int)0x80000000FFFFFFFFuLL << 64 | 0xFFFFFFFF00000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL, (tu_int)0x80000000FFFFFFFFuLL << 64 | 0xFFFFFFFF80000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL, (tu_int)0x80000000FFFFFFFFuLL << 64 | 0xFFFFFFFFFFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL, (tu_int)0xFFFFFFFF00000000uLL << 64 | 0x0000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL, (tu_int)0xFFFFFFFF00000000uLL << 64 | 0x0000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL, (tu_int)0xFFFFFFFF00000000uLL << 64 | 0x0000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL, (tu_int)0xFFFFFFFF00000000uLL << 64 | 0x00000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL, (tu_int)0xFFFFFFFF00000000uLL << 64 | 0x0000000100000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL, (tu_int)0xFFFFFFFF00000000uLL << 64 | 0x0000000100000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL, (tu_int)0xFFFFFFFF00000000uLL << 64 | 0x0000000180000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL, (tu_int)0xFFFFFFFF00000000uLL << 64 | 0x00000001FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL, (tu_int)0xFFFFFFFF00000000uLL << 64 | 0x8000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL, (tu_int)0xFFFFFFFF00000000uLL << 64 | 0x8000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL, (tu_int)0xFFFFFFFF00000000uLL << 64 | 0x8000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL, (tu_int)0xFFFFFFFF00000000uLL << 64 | 0x80000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL, (tu_int)0xFFFFFFFF00000000uLL << 64 | 0xFFFFFFFF00000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL, (tu_int)0xFFFFFFFF00000000uLL << 64 | 0xFFFFFFFF00000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL, (tu_int)0xFFFFFFFF00000000uLL << 64 | 0xFFFFFFFF80000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL, (tu_int)0xFFFFFFFF00000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL, (tu_int)0xFFFFFFFF00000001uLL << 64 | 0x0000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL, (tu_int)0xFFFFFFFF00000001uLL << 64 | 0x0000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL, (tu_int)0xFFFFFFFF00000001uLL << 64 | 0x0000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL, (tu_int)0xFFFFFFFF00000001uLL << 64 | 0x00000000FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL, (tu_int)0xFFFFFFFF00000001uLL << 64 | 0x0000000100000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL, (tu_int)0xFFFFFFFF00000001uLL << 64 | 0x0000000100000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL, (tu_int)0xFFFFFFFF00000001uLL << 64 | 0x0000000180000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL, (tu_int)0xFFFFFFFF00000001uLL << 64 | 0x00000001FFFFFFFFuLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL, (tu_int)0xFFFFFFFF00000001uLL << 64 | 0x8000000000000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL, (tu_int)0xFFFFFFFF00000001uLL << 64 | 0x8000000000000001uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL, (tu_int)0xFFFFFFFF00000001uLL << 64 | 0x8000000080000000uLL,  (tu_int)0x0000000000000000uLL << 64 | 0x0000000000000000uLL, (tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFFFFFFFFuLL},
{(tu_int)0x0000000000000000uLL << 64 | 0xFFFFFFFFFF