; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt < %s -data-layout="e-p:32:32:32-p1:16:16:16-i1:8:8-i8:8:8-i16:16:16-i32:32:32-i64:32:64-f32:32:32-f64:32:64-n8:16:32" -basic-aa -gvn -S -dce | FileCheck %s --check-prefixes=CHECK,LE
; RUN: opt < %s -data-layout="E-p:32:32:32-p1:16:16:16-i1:8:8-i8:8:8-i16:16:16-i32:32:32-i64:32:64-f32:32:32-f64:64:64-n32"      -basic-aa -gvn -S -dce | FileCheck %s --check-prefixes=CHECK,BE

;; Trivial RLE test.
define i32 @test0(i32 %V, i32* %P) {
; CHECK-LABEL: @test0(
; CHECK-NEXT:    store i32 [[V:%.*]], i32* [[P:%.*]], align 4
; CHECK-NEXT:    ret i32 [[V]]
;
  store i32 %V, i32* %P

  %A = load i32, i32* %P
  ret i32 %A
}


;;===----------------------------------------------------------------------===;;
;; Tests for crashers
;;===----------------------------------------------------------------------===;;

;; PR5016
define i8 @crash0({i32, i32} %A, {i32, i32}* %P) {
; CHECK-LABEL: @crash0(
; CHECK-NEXT:    store { i32, i32 } [[A:%.*]], { i32, i32 }* [[P:%.*]], align 4
; CHECK-NEXT:    [[X:%.*]] = bitcast { i32, i32 }* [[P]] to i8*
; CHECK-NEXT:    [[Y:%.*]] = load i8, i8* [[X]], align 1
; CHECK-NEXT:    ret i8 [[Y]]
;
  store {i32, i32} %A, {i32, i32}* %P
  %X = bitcast {i32, i32}* %P to i8*
  %Y = load i8, i8* %X
  ret i8 %Y
}

;; No PR filed, crashed in CaptureTracker.
declare void @helper()
define void @crash1() {
; CHECK-LABEL: @crash1(
; CHECK-NEXT:    tail call void @llvm.memcpy.p0i8.p0i8.i64(i8* undef, i8* undef, i64 undef, i1 false) #[[ATTR3:[0-9]+]]
; CHECK-NEXT:    ret void
;
  tail call void @llvm.memcpy.p0i8.p0i8.i64(i8* undef, i8* undef, i64 undef, i1 false) nounwind
  %ttmp = load i8, i8* bitcast (void ()* @helper to i8*)
  %x = icmp eq i8 %ttmp, 15
  ret void
}


;;===----------------------------------------------------------------------===;;
;; Store -> Load  and  Load -> Load forwarding where src and dst are different
;; types, but where the base pointer is a must alias.
;;===----------------------------------------------------------------------===;;

;; i32 -> f32 forwarding.
define float @coerce_mustalias1(i32 %V, i32* %P) {
; CHECK-LABEL: @coerce_mustalias1(
; CHECK-NEXT:    store i32 [[V:%.*]], i32* [[P:%.*]], align 4
; CHECK-NEXT:    [[TMP1:%.*]] = bitcast i32 [[V]] to float
; CHECK-NEXT:    ret float [[TMP1]]
;
  store i32 %V, i32* %P

  %P2 = bitcast i32* %P to float*

  %A = load float, float* %P2
  ret float %A
}

;; i32* -> float forwarding.
define float @coerce_mustalias2(i32* %V, i32** %P) {
; CHECK-LABEL: @coerce_mustalias2(
; CHECK-NEXT:    store i32* [[V:%.*]], i32** [[P:%.*]], align 4
; CHECK-NEXT:    [[TMP1:%.*]] = ptrtoint i32* [[V]] to i32
; CHECK-NEXT:    [[TMP2:%.*]] = bitcast i32 [[TMP1]] to float
; CHECK-NEXT:    ret float [[TMP2]]
;
  store i32* %V, i32** %P

  %P2 = bitcast i32** %P to float*

  %A = load float, float* %P2
  ret float %A
}

;; float -> i32* forwarding.
define i32* @coerce_mustalias3(float %V, float* %P) {
; CHECK-LABEL: @coerce_mustalias3(
; CHECK-NEXT:    store float [[V:%.*]], float* [[P:%.*]], align 4
; CHECK-NEXT:    [[TMP1:%.*]] = bitcast float [[V]] to i32
; CHECK-NEXT:    [[TMP2:%.*]] = inttoptr i32 [[TMP1]] to i32*
; CHECK-NEXT:    ret i32* [[TMP2]]
;
  store float %V, float* %P

  %P2 = bitcast float* %P to i32**

  %A = load i32*, i32** %P2
  ret i32* %A
}

;; i32 -> f32 load forwarding.
define float @coerce_mustalias4(i32* %P, i1 %cond) {
; CHECK-LABEL: @coerce_mustalias4(
; CHECK-NEXT:    [[A:%.*]] = load i32, i32* [[P:%.*]], align 4
; CHECK-NEXT:    [[TMP1:%.*]] = bitcast i32 [[A]] to float
; CHECK-NEXT:    br i1 [[COND:%.*]], label [[T:%.*]], label [[F:%.*]]
; CHECK:       T:
; CHECK-NEXT:    ret float [[TMP1]]
; CHECK:       F:
; CHECK-NEXT:    ret float [[TMP1]]
;
  %A = load i32, i32* %P

  %P2 = bitcast i32* %P to float*
  %B = load float, float* %P2
  br i1 %cond, label %T, label %F
T:
  ret float %B

F:
  %X = bitcast i32 %A to float
  ret float %X

}

;; i32 -> i8 forwarding
define i8 @coerce_mustalias5(i32 %V, i32* %P) {
; LE-LABEL: @coerce_mustalias5(
; LE-NEXT:    store i32 [[V:%.*]], i32* [[P:%.*]], align 4
; LE-NEXT:    [[TMP1:%.*]] = trunc i32 [[V]] to i8
; LE-NEXT:    ret i8 [[TMP1]]
;
; BE-LABEL: @coerce_mustalias5(
; BE-NEXT:    store i32 [[V:%.*]], i32* [[P:%.*]], align 4
; BE-NEXT:    [[TMP1:%.*]] = lshr i32 [[V]], 24
; BE-NEXT:    [[TMP2:%.*]] = trunc i32 [[TMP1]] to i8
; BE-NEXT:    ret i8 [[TMP2]]
;
  store i32 %V, i32* %P

  %P2 = bitcast i32* %P to i8*

  %A = load i8, i8* %P2
  ret i8 %A
}

;; i64 -> float forwarding
define float @coerce_mustalias6(i64 %V, i64* %P) {
; LE-LABEL: @coerce_mustalias6(
; LE-NEXT:    store i64 [[V:%.*]], i64* [[P:%.*]], align 4
; LE-NEXT:    [[TMP1:%.*]] = trunc i64 [[V]] to i32
; LE-NEXT:    [[TMP2:%.*]] = bitcast i32 [[TMP1]] to float
; LE-NEXT:    ret float [[TMP2]]
;
; BE-LABEL: @coerce_mustalias6(
; BE-NEXT:    store i64 [[V:%.*]], i64* [[P:%.*]], align 4
; BE-NEXT:    [[TMP1:%.*]] = lshr i64 [[V]], 32
; BE-NEXT:    [[TMP2:%.*]] = trunc i64 [[TMP1]] to i32
; BE-NEXT:    [[TMP3:%.*]] = bitcast i32 [[TMP2]] to float
; BE-NEXT:    ret float [[TMP3]]
;
  store i64 %V, i64* %P

  %P2 = bitcast i64* %P to float*

  %A = load float, float* %P2
  ret float %A
}

;; i64 -> i8* (32-bit) forwarding
define i8* @coerce_mustalias7(i64 %V, i64* %P) {
; LE-LABEL: @coerce_mustalias7(
; LE-NEXT:    store i64 [[V:%.*]], i64* [[P:%.*]], align 4
; LE-NEXT:    [[TMP1:%.*]] = trunc i64 [[V]] to i32
; LE-NEXT:    [[TMP2:%.*]] = inttoptr i32 [[TMP1]] to i8*
; LE-NEXT:    ret i8* [[TMP2]]
;
; BE-LABEL: @coerce_mustalias7(
; BE-NEXT:    store i64 [[V:%.*]], i64* [[P:%.*]], align 4
; BE-NEXT:    [[TMP1:%.*]] = lshr i64 [[V]], 32
; BE-NEXT:    [[TMP2:%.*]] = trunc i64 [[TMP1]] to i32
; BE-NEXT:    [[TMP3:%.*]] = inttoptr i32 [[TMP2]] to i8*
; BE-NEXT:    ret i8* [[TMP3]]
;
  store i64 %V, i64* %P

  %P2 = bitcast i64* %P to i8**

  %A = load i8*, i8** %P2
  ret i8* %A
}

; memset -> i16 forwarding.
define signext i16 @memset_to_i16_local(i16* %A) nounwind ssp {
; CHECK-LABEL: @memset_to_i16_local(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[CONV:%.*]] = bitcast i16* [[A:%.*]] to i8*
; CHECK-NEXT:    tail call void @llvm.memset.p0i8.i64(i8* [[CONV]], i8 1, i64 200, i1 false)
; CHECK-NEXT:    ret i16 257
;
entry:
  %conv = bitcast i16* %A to i8*
  tail call void @llvm.memset.p0i8.i64(i8* %conv, i8 1, i64 200, i1 false)
  %arrayidx = getelementptr inbounds i16, i16* %A, i64 42
  %ttmp2 = load i16, i16* %arrayidx
  ret i16 %ttmp2
}

; memset -> float forwarding.
define float @memset_to_float_local(float* %A, i8 %Val) nounwind ssp {
; CHECK-LABEL: @memset_to_float_local(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[CONV:%.*]] = bitcast float* [[A:%.*]] to i8*
; CHECK-NEXT:    tail call void @llvm.memset.p0i8.i64(i8* [[CONV]], i8 [[VAL:%.*]], i64 400, i1 false)
; CHECK-NEXT:    [[TMP0:%.*]] = zext i8 [[VAL]] to i32
; CHECK-NEXT:    [[TMP1:%.*]] = shl i32 [[TMP0]], 8
; CHECK-NEXT:    [[TMP2:%.*]] = or i32 [[TMP0]], [[TMP1]]
; CHECK-NEXT:    [[TMP3:%.*]] = shl i32 [[TMP2]], 16
; CHECK-NEXT:    [[TMP4:%.*]] = or i32 [[TMP2]], [[TMP3]]
; CHECK-NEXT:    [[TMP5:%.*]] = bitcast i32 [[TMP4]] to float
; CHECK-NEXT:    ret float [[TMP5]]
;
entry:
  %conv = bitcast float* %A to i8*                ; <i8*> [#uses=1]
  tail call void @llvm.memset.p0i8.i64(i8* %conv, i8 %Val, i64 400, i1 false)
  %arrayidx = getelementptr inbounds float, float* %A, i64 42 ; <float*> [#uses=1]
  %ttmp2 = load float, float* %arrayidx                   ; <float> [#uses=1]
  ret float %ttmp2
}

;; non-local memset -> i16 load forwarding.
define i16 @memset_to_i16_nonlocal0(i16* %P, i1 %cond) {
; CHECK-LABEL: @memset_to_i16_nonlocal0(
; CHECK-NEXT:    [[P3:%.*]] = bitcast i16* [[P:%.*]] to i8*
; CHECK-NEXT:    br i1 [[COND:%.*]], label [[T:%.*]], label [[F:%.*]]
; CHECK:       T:
; CHECK-NEXT:    tail call void @llvm.memset.p0i8.i64(i8* [[P3]], i8 1, i64 400, i1 false)
; CHECK-NEXT:    br label [[CONT:%.*]]
; CHECK:       F:
; CHECK-NEXT:    tail call void @llvm.memset.p0i8.i64(i8* [[P3]], i8 2, i64 400, i1 false)
; CHECK-NEXT:    br label [[CONT]]
; CHECK:       Cont:
; CHECK-NEXT:    [[A:%.*]] = phi i16 [ 514, [[F]] ], [ 257, [[T]] ]
; CHECK-NEXT:    ret i16 [[A]]
;
  %P3 = bitcast i16* %P to i8*
  br i1 %cond, label %T, label %F
T:
  tail call void @llvm.memset.p0i8.i64(i8* %P3, i8 1, i64 400, i1 false)
  br label %Cont

F:
  tail call void @llvm.memset.p0i8.i64(i8* %P3, i8 2, i64 400, i1 false)
  br label %Cont

Cont:
  %P2 = getelementptr i16, i16* %P, i32 4
  %A = load i16, i16* %P2
  ret i16 %A

}

@GCst = constant {i32, float, i32 } { i32 42, float 14., i32 97 }
@GCst_as1 = addrspace(1) constant {i32, float, i32 } { i32 42, float 14., i32 97 }

; memset -> float forwarding.
define float @memcpy_to_float_local(float* %A) nounwind ssp {
; CHECK-LABEL: @memcpy_to_float_local(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[CONV:%.*]] = bitcast float* [[A:%.*]] to i8*
; CHECK-NEXT:    tail call void @llvm.memcpy.p0i8.p0i8.i64(i8* [[CONV]], i8* bitcast ({ i32, float, i32 }* @GCst to i8*), i64 12, i1 false)
; CHECK-NEXT:    ret float 1.400000e+01
;
entry:
  %conv = bitcast float* %A to i8*                ; <i8*> [#uses=1]
  tail call void @llvm.memcpy.p0i8.p0i8.i64(i8* %conv, i8* bitcast ({i32, float, i32 }* @GCst to i8*), i64 12, i1 false)
  %arrayidx = getelementptr inbounds float, float* %A, i64 1 ; <float*> [#uses=1]
  %ttmp2 = load float, float* %arrayidx                   ; <float> [#uses=1]
  ret float %ttmp2
}

; memcpy from address space 1
define float @memcpy_to_float_local_as1(float* %A) nounwind ssp {
; CHECK-LABEL: @memcpy_to_float_local_as1(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[CONV:%.*]] = bitcast float* [[A:%.*]] to i8*
; CHECK-NEXT:    tail call void @llvm.memcpy.p0i8.p1i8.i64(i8* [[CONV]], i8 addrspace(1)* bitcast ({ i32, float, i32 } addrspace(1)* @GCst_as1 to i8 addrspace(1)*), i64 12, i1 false)
; CHECK-NEXT:    ret float 1.400000e+01
;
entry:
  %conv = bitcast float* %A to i8*                ; <i8*> [#uses=1]
  tail call void @llvm.memcpy.p0i8.p1i8.i64(i8* %conv, i8 addrspace(1)* bitcast ({i32, float, i32 } addrspace(1)* @GCst_as1 to i8 addrspace(1)*), i64 12, i1 false)
  %arrayidx = getelementptr inbounds float, float* %A, i64 1 ; <float*> [#uses=1]
  %ttmp2 = load float, float* %arrayidx                   ; <float> [#uses=1]
  ret float %ttmp2
}

;; non-local i32/float -> i8 load forwarding.
define i8 @coerce_mustalias_nonlocal0(i32* %P, i1 %cond) {
; LE-LABEL: @coerce_mustalias_nonlocal0(
; LE-NEXT:    [[P2:%.*]] = bitcast i32* [[P:%.*]] to float*
; LE-NEXT:    br i1 [[COND:%.*]], label [[T:%.*]], label [[F:%.*]]
; LE:       T:
; LE-NEXT:    store i32 42, i32* [[P]], align 4
; LE-NEXT:    br label [[CONT:%.*]]
; LE:       F:
; LE-NEXT:    store float 1.000000e+00, float* [[P2]], align 4
; LE-NEXT:    br label [[CONT]]
; LE:       Cont:
; LE-NEXT:    [[A:%.*]] = phi i8 [ 0, [[F]] ], [ 42, [[T]] ]
; LE-NEXT:    ret i8 [[A]]
;
; BE-LABEL: @coerce_mustalias_nonlocal0(
; BE-NEXT:    [[P2:%.*]] = bitcast i32* [[P:%.*]] to float*
; BE-NEXT:    br i1 [[COND:%.*]], label [[T:%.*]], label [[F:%.*]]
; BE:       T:
; BE-NEXT:    store i32 42, i32* [[P]], align 4
; BE-NEXT:    br label [[CONT:%.*]]
; BE:       F:
; BE-NEXT:    store float 1.000000e+00, float* [[P2]], align 4
; BE-NEXT:    br label [[CONT]]
; BE:       Cont:
; BE-NEXT:    [[A:%.*]] = phi i8 [ 63, [[F]] ], [ 0, [[T]] ]
; BE-NEXT:    ret i8 [[A]]
;
  %P2 = bitcast i32* %P to float*
  %P3 = bitcast i32* %P to i8*
  br i1 %cond, label %T, label %F
T:
  store i32 42, i32* %P
  br label %Cont

F:
  store float 1.0, float* %P2
  br label %Cont

Cont:
  %A = load i8, i8* %P3
  ret i8 %A

}


;; non-local i32/float -> i8 load forwarding.  This also tests that the "P3"
;; bitcast equivalence can be properly phi translated.
define i8 @coerce_mustalias_nonlocal1(i32* %P, i1 %cond) {
; LE-LABEL: @coerce_mustalias_nonlocal1(
; LE-NEXT:    [[P2:%.*]] = bitcast i32* [[P:%.*]] to float*
; LE-NEXT:    br i1 [[COND:%.*]], label [[T:%.*]], label [[F:%.*]]
; LE:       T:
; LE-NEXT:    store i32 42, i32* [[P]], align 4
; LE-NEXT:    br label [[CONT:%.*]]
; LE:       F:
; LE-NEXT:    store float 1.000000e+00, float* [[P2]], align 4
; LE-NEXT:    br label [[CONT]]
; LE:       Cont:
; LE-NEXT:    [[A:%.*]] = phi i8 [ 0, [[F]] ], [ 42, [[T]] ]
; LE-NEXT:    ret i8 [[A]]
;
; BE-LABEL: @coerce_mustalias_nonlocal1(
; BE-NEXT:    [[P2:%.*]] = bitcast i32* [[P:%.*]] to float*
; BE-NEXT:    br i1 [[COND:%.*]], label [[T:%.*]], label [[F:%.*]]
; BE:       T:
; BE-NEXT:    store i32 42, i32* [[P]], align 4
; BE-NEXT:    br label [[CONT:%.*]]
; BE:       F:
; BE-NEXT:    store float 1.000000e+00, float* [[P2]], align 4
; BE-NEXT:    br label [[CONT]]
; BE:       Cont:
; BE-NEXT:    [[A:%.*]] = phi i8 [ 63, [[F]] ], [ 0, [[T]] ]
; BE-NEXT:    ret i8 [[A]]
;
  %P2 = bitcast i32* %P to float*
  br i1 %cond, label %T, label %F
T:
  store i32 42, i32* %P
  br label %Cont

F:
  store float 1.0, float* %P2
  br label %Cont

Cont:
  %P3 = bitcast i32* %P to i8*
  %A = load i8, i8* %P3
  ret i8 %A

}


;; non-local i32 -> i8 partial redundancy load forwarding.
define i8 @coerce_mustalias_pre0(i32* %P, i1 %cond) {
; LE-LABEL: @coerce_mustalias_pre0(
; LE-NEXT:    [[P3:%.*]] = bitcast i32* [[P:%.*]] to i8*
; LE-NEXT:    br i1 [[COND:%.*]], label [[T:%.*]], label [[F:%.*]]
; LE:       T:
; LE-NEXT:    store i32 42, i32* [[P]], align 4
; LE-NEXT:    br label [[CONT:%.*]]
; LE:       F:
; LE-NEXT:    [[A_PRE:%.*]] = load i8, i8* [[P3]], align 1
; LE-NEXT:    br label [[CONT]]
; LE:       Cont:
; LE-NEXT:    [[A:%.*]] = phi i8 [ [[A_PRE]], [[F]] ], [ 42, [[T]] ]
; LE-NEXT:    ret i8 [[A]]
;
; BE-LABEL: @coerce_mustalias_pre0(
; BE-NEXT:    [[P3:%.*]] = bitcast i32* [[P:%.*]] to i8*
; BE-NEXT:    br i1 [[COND:%.*]], label [[T:%.*]], label [[F:%.*]]
; BE:       T:
; BE-NEXT:    store i32 42, i32* [[P]], align 4
; BE-NEXT:    br label [[CONT:%.*]]
; BE:       F:
; BE-NEXT:    [[A_PRE:%.*]] = load i8, i8* [[P3]], align 1
; BE-NEXT:    br label [[CONT]]
; BE:       Cont:
; BE-NEXT:    [[A:%.*]] = phi i8 [ [[A_PRE]], [[F]] ], [ 0, [[T]] ]
; BE-NEXT:    ret i8 [[A]]
;
  %P3 = bitcast i32* %P to i8*
  br i1 %cond, label %T, label %F
T:
  store i32 42, i32* %P
  br label %Cont

F:
  br label %Cont

Cont:
  %A = load i8, i8* %P3
  ret i8 %A

}

;;===----------------------------------------------------------------------===;;
;; Store -> Load  and  Load -> Load forwarding where src and dst are different
;; types, and the reload is an offset from the store pointer.
;;===----------------------------------------------------------------------===;;

;; i32 -> i8 forwarding.
;; PR4216
define i8 @coerce_offset0(i32 %V, i32* %P) {
; LE-LABEL: @coerce_offset0(
; LE-NEXT:    store i32 [[V:%.*]], i32* [[P:%.*]], align 4
; LE-NEXT:    [[TMP1:%.*]] = lshr i32 [[V]], 16
; LE-NEXT:    [[TMP2:%.*]] = trunc i32 [[TMP1]] to i8
; LE-NEXT:    ret i8 [[TMP2]]
;
; BE-LABEL: @coerce_offset0(
; BE-NEXT:    store i32 [[V:%.*]], i32* [[P:%.*]], align 4
; BE-NEXT:    [[TMP1:%.*]] = lshr i32 [[V]], 8
; BE-NEXT:    [[TMP2:%.*]] = trunc i32 [[TMP1]] to i8
; BE-NEXT:    ret i8 [[TMP2]]
;
  store i32 %V, i32* %P

  %P2 = bitcast i32* %P to i8*
  %P3 = getelementptr i8, i8* %P2, i32 2

  %A = load i8, i8* %P3
  ret i8 %A
}

;; non-local i32/float -> i8 load forwarding.
define i8 @coerce_offset_nonlocal0(i32* %P, i1 %cond) {
; LE-LABEL: @coerce_offset_nonlocal0(
; LE-NEXT:    [[P2:%.*]] = bitcast i32* [[P:%.*]] to float*
; LE-NEXT:    br i1 [[COND:%.*]], label [[T:%.*]], label [[F:%.*]]
; LE:       T:
; LE-NEXT:    store i32 57005, i32* [[P]], align 4
; LE-NEXT:    br label [[CONT:%.*]]
; LE:       F:
; LE-NEXT:    store float 1.000000e+00, float* [[P2]], align 4
; LE-NEXT:    br label [[CONT]]
; LE:       Cont:
; LE-NEXT:    [[A:%.*]] = phi i8 [ -128, [[F]] ], [ 0, [[T]] ]
; LE-NEXT:    ret i8 [[A]]
;
; BE-LABEL: @coerce_offset_nonlocal0(
; BE-NEXT:    [[P2:%.*]] = bitcast i32* [[P:%.*]] to float*
; BE-NEXT:    br i1 [[COND:%.*]], label [[T:%.*]], label [[F:%.*]]
; BE:       T:
; BE-NEXT:    store i32 57005, i32* [[P]], align 4
; BE-NEXT:    br label [[CONT:%.*]]
; BE:       F:
; BE-NEXT:    store float 1.000000e+00, float* [[P2]], align 4
; BE-NEXT:    br label [[CONT]]
; BE:       Cont:
; BE-NEXT:    [[A:%.*]] = phi i8 [ 0, [[F]] ], [ -34, [[T]] ]
; BE-NEXT:    ret i8 [[A]]
;
  %P2 = bitcast i32* %P to float*
  %P3 = bitcast i32* %P to i8*
  %P4 = getelementptr i8, i8* %P3, i32 2
  br i1 %cond, label %T, label %F
T:
  store i32 57005, i32* %P
  br label %Cont

F:
  store float 1.0, float* %P2
  br label %Cont

Cont:
  %A = load i8, i8* %P4
  ret i8 %A

}


;; non-local i32 -> i8 partial redundancy load forwarding.
define i8 @coerce_offset_pre0(i32* %P, i1 %cond) {
; CHECK-LABEL: @coerce_offset_pre0(
; CHECK-NEXT:    [[P3:%.*]] = bitcast i32* [[P:%.*]] to i8*
; CHECK-NEXT:    [[P4:%.*]] = getelementptr i8, i8* [[P3]], i32 2
; CHECK-NEXT:    br i1 [[COND:%.*]], label [[T:%.*]], label [[F:%.*]]
; CHECK:       T:
; CHECK-NEXT:    store i32 42, i32* [[P]], align 4
; CHECK-NEXT:    br label [[CONT:%.*]]
; CHECK:       F:
; CHECK-NEXT:    [[A_PRE:%.*]] = load i8, i8* [[P4]], align 1
; CHECK-NEXT:    br label [[CONT]]
; CHECK:       Cont:
; CHECK-NEXT:    [[A:%.*]] = phi i8 [ [[A_PRE]], [[F]] ], [ 0, [[T]] ]
; CHECK-NEXT:    ret i8 [[A]]
;
  %P3 = bitcast i32* %P to i8*
  %P4 = getelementptr i8, i8* %P3, i32 2
  br i1 %cond, label %T, label %F
T:
  store i32 42, i32* %P
  br label %Cont

F:
  br label %Cont

Cont:
  %A = load i8, i8* %P4
  ret i8 %A

}

define i32 @chained_load(i32** %p, i32 %x, i32 %y) {
; CHECK-LABEL: @chained_load(
; CHECK-NEXT:  block1:
; CHECK-NEXT:    [[A:%.*]] = alloca i32*, align 4
; CHECK-NEXT:    [[Z:%.*]] = load i32*, i32** [[P:%.*]], align 4
; CHECK-NEXT:    store i32* [[Z]], i32** [[A]], align 4
; CHECK-NEXT:    [[CMP:%.*]] = icmp eq i32 [[X:%.*]], [[Y:%.*]]
; CHECK-NEXT:    br i1 [[CMP]], label [[BLOCK2:%.*]], label [[BLOCK3:%.*]]
; CHECK:       block2:
; CHECK-NEXT:    br label [[BLOCK4:%.*]]
; CHECK:       block3:
; CHECK-NEXT:    br label [[BLOCK4]]
; CHECK:       block4:
; CHECK-NEXT:    [[D:%.*]] = load i32, i32* [[Z]], align 4
; CHECK-NEXT:    ret i32 [[D]]
;
block1:
  %A = alloca i32*

  %z = load i32*, i32** %p
  store i32* %z, i32** %A
  %cmp = icmp eq i32 %x, %y
  br i1 %cmp, label %block2, label %block3

block2:
  %a = load i32*, i32** %p
  br label %block4

block3:
  %b = load i32*, i32** %p
  br label %block4

block4:
  %c = load i32*, i32** %p
  %d = load i32, i32* %c
  ret i32 %d

}


declare i1 @cond() readonly
declare i1 @cond2() readonly

define i32 @phi_trans2() {
; CHECK-LABEL: @phi_trans2(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[P:%.*]] = alloca i32, i32 400, align 4
; CHECK-NEXT:    br label [[F1:%.*]]
; CHECK:       F1:
; CHECK-NEXT:    [[A:%.*]] = phi i32 [ 1, [[ENTRY:%.*]] ], [ 2, [[F:%.*]] ]
; CHECK-NEXT:    [[COND2:%.*]] = call i1 @cond()
; CHECK-NEXT:    br i1 [[COND2]], label [[T1:%.*]], label [[TY:%.*]]
; CHECK:       T1:
; CHECK-NEXT:    [[P2:%.*]] = getelementptr i32, i32* [[P]], i32 [[A]]
; CHECK-NEXT:    [[X:%.*]] = load i32, i32* [[P2]], align 4
; CHECK-NEXT:    [[COND:%.*]] = call i1 @cond2()
; CHECK-NEXT:    br i1 [[COND]], label [[TX:%.*]], label [[F]]
; CHECK:       F:
; CHECK-NEXT:    [[P3:%.*]] = getelementptr i32, i32* [[P]], i32 2
; CHECK-NEXT:    store i32 17, i32* [[P3]], align 4
; CHECK-NEXT:    store i32 42, i32* [[P2]], align 4
; CHECK-NEXT:    br label [[F1]]
; CHECK:       TX:
; CHECK-NEXT:    ret i32 [[X]]
; CHECK:       TY:
; CHECK-NEXT:    ret i32 0
;
entry:
  %P = alloca i32, i32 400
  br label %F1

F1:
  %A = phi i32 [1, %entry], [2, %F]
  %cond2 = call i1 @cond()
  br i1 %cond2, label %T1, label %TY

T1:
  %P2 = getelementptr i32, i32* %P, i32 %A
  %x = load i32, i32* %P2
  %cond = call i1 @cond2()
  br i1 %cond, label %TX, label %F

F:
  %P3 = getelementptr i32, i32* %P, i32 2
  store i32 17, i32* %P3

  store i32 42, i32* %P2  ; Provides "P[A]".
  br label %F1

TX:
  ; This load should not be compiled to 'ret i32 42'.  An overly clever
  ; implementation of GVN would see that we're returning 17 if the loop
  ; executes once or 42 if it executes more than that, but we'd have to do
  ; loop restructuring to expose this, and GVN shouldn't do this sort of CFG
  ; transformation.

  ret i32 %x
TY:
  ret i32 0
}

define i32 @phi_trans3(i32* %p, i32 %x, i32 %y, i32 %z) {
; CHECK-LABEL: @phi_trans3(
; CHECK-NEXT:  block1:
; CHECK-NEXT:    [[CMPXY:%.*]] = icmp eq i32 [[X:%.*]], [[Y:%.*]]
; CHECK-NEXT:    br i1 [[CMPXY]], label [[BLOCK2:%.*]], label [[BLOCK3:%.*]]
; CHECK:       block2:
; CHECK-NEXT:    store i32 87, i32* [[P:%.*]], align 4
; CHECK-NEXT:    br label [[BLOCK4:%.*]]
; CHECK:       block3:
; CHECK-NEXT:    [[P2:%.*]] = getelementptr i32, i32* [[P]], i32 43
; CHECK-NEXT:    store i32 97, i32* [[P2]], align 4
; CHECK-NEXT:    br label [[BLOCK4]]
; CHECK:       block4:
; CHECK-NEXT:    [[D:%.*]] = phi i32 [ 87, [[BLOCK2]] ], [ 97, [[BLOCK3]] ]
; CHECK-NEXT:    br i1 [[CMPXY]], label [[BLOCK5:%.*]], label [[EXIT:%.*]]
; CHECK:       block5:
; CHECK-NEXT:    br i1 true, label [[BLOCK6:%.*]], label [[BLOCK5_EXIT_CRIT_EDGE:%.*]]
; CHECK:       block5.exit_crit_edge:
; CHECK-NEXT:    br label [[EXIT]]
; CHECK:       block6:
; CHECK-NEXT:    br i1 true, label [[BLOCK7:%.*]], label [[BLOCK6_EXIT_CRIT_EDGE:%.*]]
; CHECK:       block6.exit_crit_edge:
; CHECK-NEXT:    br label [[EXIT]]
; CHECK:       block7:
; CHECK-NEXT:    ret i32 [[D]]
; CHECK:       exit:
; CHECK-NEXT:    ret i32 -1
;
block1:
  %cmpxy = icmp eq i32 %x, %y
  br i1 %cmpxy, label %block2, label %block3

block2:
  store i32 87, i32* %p
  br label %block4

block3:
  %p2 = getelementptr i32, i32* %p, i32 43
  store i32 97, i32* %p2
  br label %block4

block4:
  %A = phi i32 [-1, %block2], [42, %block3]
  br i1 %cmpxy, label %block5, label %exit


block5:
  %B = add i32 %A, 1
  br i1 %cmpxy, label %block6, label %exit

block6:
  %C = getelementptr i32, i32* %p, i32 %B
  br i1 %cmpxy, label %block7, label %exit

block7:
  %D = load i32, i32* %C
  ret i32 %D


exit:
  ret i32 -1
}

define i8 @phi_trans4(i8* %p) {
; CHECK-LABEL: @phi_trans4(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[X3:%.*]] = getelementptr i8, i8* [[P:%.*]], i32 192
; CHECK-NEXT:    store i8 -64, i8* [[X3]], align 1
; CHECK-NEXT:    [[X:%.*]] = getelementptr i8, i8* [[P]], i32 4
; CHECK-NEXT:    [[Y:%.*]] = load i8, i8* [[X]], align 1
; CHECK-NEXT:    br label [[LOOP:%.*]]
; CHECK:       loop:
; CHECK-NEXT:    [[Y2:%.*]] = phi i8 [ [[Y]], [[ENTRY:%.*]] ], [ 0, [[LOOP]] ]
; CHECK-NEXT:    [[COND:%.*]] = call i1 @cond2()
; CHECK-NEXT:    [[Z:%.*]] = bitcast i8* [[X3]] to i32*
; CHECK-NEXT:    store i32 0, i32* [[Z]], align 4
; CHECK-NEXT:    br i1 [[COND]], label [[LOOP]], label [[OUT:%.*]]
; CHECK:       out:
; CHECK-NEXT:    [[R:%.*]] = add i8 [[Y]], [[Y2]]
; CHECK-NEXT:    ret i8 [[R]]
;
entry:
  %X3 = getelementptr i8, i8* %p, i32 192
  store i8 192, i8* %X3

  %X = getelementptr i8, i8* %p, i32 4
  %Y = load i8, i8* %X
  br label %loop

loop:
  %i = phi i32 [4, %entry], [192, %loop]
  %X2 = getelementptr i8, i8* %p, i32 %i
  %Y2 = load i8, i8* %X2


  %cond = call i1 @cond2()

  %Z = bitcast i8 *%X3 to i32*
  store i32 0, i32* %Z
  br i1 %cond, label %loop, label %out

out:
  %R = add i8 %Y, %Y2
  ret i8 %R
}

define i8 @phi_trans5(i8* %p) {
; CHECK-LABEL: @phi_trans5(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[X4:%.*]] = getelementptr i8, i8* [[P:%.*]], i32 2
; CHECK-NEXT:    store i8 19, i8* [[X4]], align 1
; CHECK-NEXT:    [[X:%.*]] = getelementptr i8, i8* [[P]], i32 4
; CHECK-NEXT:    [[Y:%.*]] = load i8, i8* [[X]], align 1
; CHECK-NEXT:    br label [[LOOP:%.*]]
; CHECK:       loop:
; CHECK-NEXT:    [[Y2:%.*]] = phi i8 [ [[Y]], [[ENTRY:%.*]] ], [ [[Y2_PRE:%.*]], [[CONT:%.*]] ]
; CHECK-NEXT:    [[I:%.*]] = phi i32 [ 4, [[ENTRY]] ], [ 3, [[CONT]] ]
; CHECK-NEXT:    [[X2:%.*]] = getelementptr i8, i8* [[P]], i32 [[I]]
; CHECK-NEXT:    [[COND:%.*]] = call i1 @cond2()
; CHECK-NEXT:    br i1 [[COND]], label [[CONT]], label [[OUT:%.*]]
; CHECK:       cont:
; CHECK-NEXT:    [[Z:%.*]] = getelementptr i8, i8* [[X2]], i32 -1
; CHECK-NEXT:    [[Z2:%.*]] = bitcast i8* [[Z]] to i32*
; CHECK-NEXT:    store i32 50462976, i32* [[Z2]], align 4
; CHECK-NEXT:    [[X2_PHI_TRANS_INSERT:%.*]] = getelementptr i8, i8* [[P]], i32 3
; CHECK-NEXT:    [[Y2_PRE]] = load i8, i8* [[X2_PHI_TRANS_INSERT]], align 1
; CHECK-NEXT:    br label [[LOOP]]
; CHECK:       out:
; CHECK-NEXT:    [[R:%.*]] = add i8 [[Y]], [[Y2]]
; CHECK-NEXT:    ret i8 [[R]]
;
entry:

  %X4 = getelementptr i8, i8* %p, i32 2
  store i8 19, i8* %X4

  %X = getelementptr i8, i8* %p, i32 4
  %Y = load i8, i8* %X
  br label %loop

loop:
  %i = phi i32 [4, %entry], [3, %cont]
  %X2 = getelementptr i8, i8* %p, i32 %i
  %Y2 = load i8, i8* %X2  ; Ensure this load is not being incorrectly replaced.
  %cond = call i1 @cond2()
  br i1 %cond, label %cont, label %out

cont:
  %Z = getelementptr i8, i8* %X2, i32 -1
  %Z2 = bitcast i8 *%Z to i32*
  store i32 50462976, i32* %Z2  ;; (1 << 8) | (2 << 16) | (3 << 24)


  br label %loop

out:
  %R = add i8 %Y, %Y2
  ret i8 %R
}

declare void @use_i32(i32) readonly

; indirectbr currently prevents MergeBlockIntoPredecessor from merging latch
; into header. Make sure we translate the address for %l1 correctly where
; parts of the address computations are in different basic blocks.
define i32 @phi_trans6(i32* noalias nocapture readonly %x, i1 %cond) {
; CHECK-LABEL: @phi_trans6(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[L0:%.*]] = load i32, i32* [[X:%.*]], align 4
; CHECK-NEXT:    call void @use_i32(i32 [[L0]])
; CHECK-NEXT:    br label [[HEADER:%.*]]
; CHECK:       header:
; CHECK-NEXT:    [[L1:%.*]] = phi i32 [ [[L0]], [[ENTRY:%.*]] ], [ [[L1_PRE:%.*]], [[LATCH_HEADER_CRIT_EDGE:%.*]] ]
; CHECK-NEXT:    [[IV:%.*]] = phi i32 [ 0, [[ENTRY]] ], [ [[IV_NEXT:%.*]], [[LATCH_HEADER_CRIT_EDGE]] ]
; CHECK-NEXT:    indirectbr i8* blockaddress(@phi_trans6, [[LATCH:%.*]]), [label %latch]
; CHECK:       latch:
; CHECK-NEXT:    [[IV_NEXT]] = add i32 [[IV]], 1
; CHECK-NEXT:    br i1 [[COND:%.*]], label [[EXIT:%.*]], label [[LATCH_HEADER_CRIT_EDGE]]
; CHECK:       latch.header_crit_edge:
; CHECK-NEXT:    [[GEP_1_PHI_TRANS_INSERT_PHI_TRANS_INSERT:%.*]] = getelementptr i32, i32* [[X]], i32 [[IV_NEXT]]
; CHECK-NEXT:    [[L1_PRE]] = load i32, i32* [[GEP_1_PHI_TRANS_INSERT_PHI_TRANS_INSERT]], align 4
; CHECK-NEXT:    br label [[HEADER]]
; CHECK:       exit:
; CHECK-NEXT:    ret i32 [[L1]]
;
entry:
  %l0 = load i32, i32* %x
  call void @use_i32(i32 %l0)
  br label %header

header:
  %iv = phi i32 [0, %entry], [ %iv.next, %latch]
  indirectbr i8* blockaddress(@phi_trans6, %latch), [label %latch]

latch:
  %gep.1 = getelementptr i32, i32* %x, i32 %iv
  %l1 = load i32, i32* %gep.1
  %iv.next = add i32 %iv, 1
  br i1 %cond, label %exit, label %header

exit:
  ret i32 %l1
}

; FIXME: Currently we fail to translate the PHI in this case.
define i32 @phi_trans7(i32* noalias nocapture readonly %x, i1 %cond) {
; CHECK-LABEL: @phi_trans7(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[L0:%.*]] = load i32, i32* [[X:%.*]], align 4
; CHECK-NEXT:    call void @use_i32(i32 [[L0]])
; CHECK-NEXT:    br label [[HEADER:%.*]]
; CHECK:       header:
; CHECK-NEXT:    [[IV:%.*]] = phi i32 [ 2, [[ENTRY:%.*]] ], [ [[IV_NEXT:%.*]], [[LATCH_HEADER_CRIT_EDGE:%.*]] ]
; CHECK-NEXT:    [[OFFSET:%.*]] = add i32 [[IV]], -2
; CHECK-NEXT:    indirectbr i8* blockaddress(@phi_trans7, [[LATCH:%.*]]), [label %latch]
; CHECK:       latch:
; CHECK-NEXT:    [[GEP_1:%.*]] = getelementptr i32, i32* [[X]], i32 [[OFFSET]]
; CHECK-NEXT:    [[L1:%.*]] = load i32, i32* [[GEP_1]], align 4
; CHECK-NEXT:    [[IV_NEXT]] = add i32 [[IV]], 1
; CHECK-NEXT:    br i1 [[COND:%.*]], label [[EXIT:%.*]], label [[LATCH_HEADER_CRIT_EDGE]]
; CHECK:       latch.header_crit_edge:
; CHECK-NEXT:    br label [[HEADER]]
; CHECK:       exit:
; CHECK-NEXT:    ret i32 [[L1]]
;
entry:
  %l0 = load i32, i32* %x
  call void @use_i32(i32 %l0)
  br label %header

header:
  %iv = phi i32 [2, %entry], [ %iv.next, %latch]
  %offset = add i32 %iv, -2
  indirectbr i8* blockaddress(@phi_trans7, %latch), [label %latch]

latch:
  %gep.1 = getelementptr i32, i32* %x, i32 %offset
  %l1 = load i32, i32* %gep.1
  %iv.next = add i32 %iv, 1
  br i1 %cond, label %exit, label %header

exit:
  ret i32 %l1
}

; FIXME: Currently we fail to translate the PHI in this case.
define i32 @phi_trans8(i32* noalias nocapture readonly %x, i1 %cond) {
; CHECK-LABEL: @phi_trans8(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[L0:%.*]] = load i32, i32* [[X:%.*]], align 4
; CHECK-NEXT:    call void @use_i32(i32 [[L0]])
; CHECK-NEXT:    br label [[HEADER:%.*]]
; CHECK:       header:
; CHECK-NEXT:    [[IV:%.*]] = phi i32 [ 2, [[ENTRY:%.*]] ], [ [[IV_NEXT:%.*]], [[LATCH_HEADER_CRIT_EDGE:%.*]] ]
; CHECK-NEXT:    indirectbr i8* blockaddress(@phi_trans8, [[LATCH:%.*]]), [label %latch]
; CHECK:       latch:
; CHECK-NEXT:    [[OFFSET:%.*]] = add i32 [[IV]], -2
; CHECK-NEXT:    [[GEP_1:%.*]] = getelementptr i32, i32* [[X]], i32 [[OFFSET]]
; CHECK-NEXT:    [[L1:%.*]] = load i32, i32* [[GEP_1]], align 4
; CHECK-NEXT:    [[IV_NEXT]] = add i32 [[IV]], 1
; CHECK-NEXT:    br i1 [[COND:%.*]], label [[EXIT:%.*]], label [[LATCH_HEADER_CRIT_EDGE]]
; CHECK:       latch.header_crit_edge:
; CHECK-NEXT:    br label [[HEADER]]
; CHECK:       exit:
; CHECK-NEXT:    ret i32 [[L1]]
;
entry:
  %l0 = load i32, i32* %x
  call void @use_i32(i32 %l0)
  br label %header

header:
  %iv = phi i32 [2, %entry], [ %iv.next, %latch]
  indirectbr i8* blockaddress(@phi_trans8, %latch), [label %latch]

latch:
  %offset = add i32 %iv, -2
  %gep.1 = getelementptr i32, i32* %x, i32 %offset
  %l1 = load i32, i32* %gep.1
  %iv.next = add i32 %iv, 1
  br i1 %cond, label %exit, label %header

exit:
  ret i32 %l1
}



; PR6642
define i32 @memset_to_load() nounwind readnone {
; CHECK-LABEL: @memset_to_load(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[X:%.*]] = alloca [256 x i32], align 4
; CHECK-NEXT:    [[TTMP:%.*]] = bitcast [256 x i32]* [[X]] to i8*
; CHECK-NEXT:    call void @llvm.memset.p0i8.i64(i8* align 4 [[TTMP]], i8 0, i64 1024, i1 false)
; CHECK-NEXT:    ret i32 0
;
entry:
  %x = alloca [256 x i32], align 4                ; <[256 x i32]*> [#uses=2]
  %ttmp = bitcast [256 x i32]* %x to i8*           ; <i8*> [#uses=1]
  call void @llvm.memset.p0i8.i64(i8* align 4 %ttmp, i8 0, i64 1024, i1 false)
  %arraydecay = getelementptr inbounds [256 x i32], [256 x i32]* %x, i32 0, i32 0 ; <i32*>
  %ttmp1 = load i32, i32* %arraydecay                   ; <i32> [#uses=1]
  ret i32 %ttmp1
}


;;===----------------------------------------------------------------------===;;
;; Load -> Load forwarding in partial alias case.
;;===----------------------------------------------------------------------===;;

define i32 @load_load_partial_alias(i8* %P) nounwind ssp {
; CHECK-LABEL: @load_load_partial_alias(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = bitcast i8* [[P:%.*]] to i32*
; CHECK-NEXT:    [[TTMP2:%.*]] = load i32, i32* [[TMP0]], align 4
; LE-NEXT:       [[TMP1:%.*]] = lshr i32 [[TTMP2]], 8
; BE-NEXT:       [[TMP1:%.*]] = lshr i32 [[TTMP2]], 16
; CHECK-NEXT:    [[TMP2:%.*]] = trunc i32 [[TMP1]] to i8
; CHECK-NEXT:    [[CONV:%.*]] = zext i8 [[TMP2]] to i32
; CHECK-NEXT:    [[ADD:%.*]] = add nsw i32 [[TTMP2]], [[CONV]]
; CHECK-NEXT:    ret i32 [[ADD]]
;
entry:
  %0 = bitcast i8* %P to i32*
  %ttmp2 = load i32, i32* %0
  %add.ptr = getelementptr inbounds i8, i8* %P, i64 1
  %ttmp5 = load i8, i8* %add.ptr
  %conv = zext i8 %ttmp5 to i32
  %add = add nsw i32 %ttmp2, %conv
  ret i32 %add
}


; Cross block partial alias case.
define i32 @load_load_partial_alias_cross_block(i8* %P) nounwind ssp {
; CHECK-LABEL: @load_load_partial_alias_cross_block(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[XX:%.*]] = bitcast i8* [[P:%.*]] to i32*
; CHECK-NEXT:    [[X1:%.*]] = load i32, i32* [[XX]], align 4
; CHECK-NEXT:    [[CMP:%.*]] = icmp eq i32 [[X1]], 127
; LE-NEXT:       [[TMP0:%.*]] = lshr i32 [[X1]], 8
; BE-NEXT:       [[TMP0:%.*]] = lshr i32 [[X1]], 16
; CHECK-NEXT:    [[TMP1:%.*]] = trunc i32 [[TMP0]] to i8
; CHECK-NEXT:    br i1 [[CMP]], label [[LAND_LHS_TRUE:%.*]], label [[IF_END:%.*]]
; CHECK:       land.lhs.true:
; CHECK-NEXT:    [[CONV6:%.*]] = zext i8 [[TMP1]] to i32
; CHECK-NEXT:    ret i32 [[CONV6]]
; CHECK:       if.end:
; CHECK-NEXT:    ret i32 52
;
entry:
  %xx = bitcast i8* %P to i32*
  %x1 = load i32, i32* %xx, align 4
  %cmp = icmp eq i32 %x1, 127
  br i1 %cmp, label %land.lhs.true, label %if.end

land.lhs.true:                                    ; preds = %entry
  %arrayidx4 = getelementptr inbounds i8, i8* %P, i64 1
  %ttmp5 = load i8, i8* %arrayidx4, align 1
  %conv6 = zext i8 %ttmp5 to i32
  ret i32 %conv6

if.end:
  ret i32 52
}

define i32 @load_load_partial_alias_cross_block_phi_trans(i8* %P) nounwind {
; CHECK-LABEL: @load_load_partial_alias_cross_block_phi_trans(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[XX:%.*]] = bitcast i8* [[P:%.*]] to i32*
; CHECK-NEXT:    [[X1:%.*]] = load i32, i32* [[XX]], align 4
; CHECK-NEXT:    [[CMP:%.*]] = icmp eq i32 [[X1]], 127
; LE-NEXT:       [[TMP0:%.*]] = lshr i32 [[X1]], 16
; BE-NEXT:       [[TMP0:%.*]] = lshr i32 [[X1]], 8
; CHECK-NEXT:    [[TMP1:%.*]] = trunc i32 [[TMP0]] to i8
; LE-NEXT:       [[TMP2:%.*]] = lshr i32 [[X1]], 8
; BE-NEXT:       [[TMP2:%.*]] = lshr i32 [[X1]], 16
; CHECK-NEXT:    [[TMP3:%.*]] = trunc i32 [[TMP2]] to i8
; CHECK-NEXT:    br i1 [[CMP]], label [[IF:%.*]], label [[ELSE:%.*]]
; CHECK:       if:
; CHECK-NEXT:    br label [[JOIN:%.*]]
; CHECK:       else:
; CHECK-NEXT:    br label [[JOIN]]
; CHECK:       join:
; CHECK-NEXT:    [[TTMP5:%.*]] = phi i8 [ [[TMP3]], [[IF]] ], [ [[TMP1]], [[ELSE]] ]
; CHECK-NEXT:    [[CONV6:%.*]] = zext i8 [[TTMP5]] to i32
; CHECK-NEXT:    ret i32 [[CONV6]]
; CHECK:       if.end:
; CHECK-NEXT:    ret i32 52
;
entry:
  %xx = bitcast i8* %P to i32*
  %x1 = load i32, i32* %xx, align 4
  %cmp = icmp eq i32 %x1, 127
  br i1 %cmp, label %if, label %else

if:
  %arrayidx.if = getelementptr inbounds i8, i8* %P, i64 1
  br label %join

else:
  %arrayidx.else = getelementptr inbounds i8, i8* %P, i64 2
  br label %join

join:
  %idx = phi i64 [ 1, %if ], [ 2, %else ]
  %arrayidx4 = getelementptr inbounds i8, i8* %P, i64 %idx
  %ttmp5 = load i8, i8* %arrayidx4, align 1
  %conv6 = zext i8 %ttmp5 to i32
  ret i32 %conv6

if.end:
  ret i32 52
}

define void @load_load_partial_alias_loop(i8* %P) {
; LE-LABEL: @load_load_partial_alias_loop(
; LE-NEXT:  entry:
; LE-NEXT:    [[P_1:%.*]] = getelementptr i8, i8* [[P:%.*]], i64 1
; LE-NEXT:    [[V_1:%.*]] = load i8, i8* [[P_1]], align 1
; LE-NEXT:    call void @use.i8(i8 [[V_1]])
; LE-NEXT:    [[P_1_32:%.*]] = bitcast i8* [[P_1]] to i32*
; LE-NEXT:    [[V_1_32:%.*]] = load i32, i32* [[P_1_32]], align 4
; LE-NEXT:    call void @use.i32(i32 [[V_1_32]])
; LE-NEXT:    [[TMP0:%.*]] = trunc i32 [[V_1_32]] to i8
; LE-NEXT:    br label [[LOOP:%.*]]
; LE:       loop:
; LE-NEXT:    [[V_I:%.*]] = phi i8 [ [[TMP0]], [[ENTRY:%.*]] ], [ [[TMP2:%.*]], [[LOOP_LOOP_CRIT_EDGE:%.*]] ]
; LE-NEXT:    [[I:%.*]] = phi i64 [ 1, [[ENTRY]] ], [ [[I_INC:%.*]], [[LOOP_LOOP_CRIT_EDGE]] ]
; LE-NEXT:    [[P_I:%.*]] = getelementptr i8, i8* [[P]], i64 [[I]]
; LE-NEXT:    call void @use.i8(i8 [[V_I]])
; LE-NEXT:    [[P_I_32:%.*]] = bitcast i8* [[P_I]] to i32*
; LE-NEXT:    [[V_I_32:%.*]] = load i32, i32* [[P_I_32]], align 4
; LE-NEXT:    call void @use.i32(i32 [[V_I_32]])
; LE-NEXT:    [[I_INC]] = add i64 [[I]], 1
; LE-NEXT:    [[CMP:%.*]] = icmp ne i64 [[I_INC]], 64
; LE-NEXT:    [[TMP1:%.*]] = lshr i32 [[V_I_32]], 8
; LE-NEXT:    [[TMP2]] = trunc i32 [[TMP1]] to i8
; LE-NEXT:    br i1 [[CMP]], label [[LOOP_LOOP_CRIT_EDGE]], label [[EXIT:%.*]]
; LE:       loop.loop_crit_edge:
; LE-NEXT:    br label [[LOOP]]
; LE:       exit:
; LE-NEXT:    ret void
;
; BE-LABEL: @load_load_partial_alias_loop(
; BE-NEXT:  entry:
; BE-NEXT:    [[P_1:%.*]] = getelementptr i8, i8* [[P:%.*]], i64 1
; BE-NEXT:    [[V_1:%.*]] = load i8, i8* [[P_1]], align 1
; BE-NEXT:    call void @use.i8(i8 [[V_1]])
; BE-NEXT:    [[P_1_32:%.*]] = bitcast i8* [[P_1]] to i32*
; BE-NEXT:    [[V_1_32:%.*]] = load i32, i32* [[P_1_32]], align 4
; BE-NEXT:    call void @use.i32(i32 [[V_1_32]])
; BE-NEXT:    [[TMP0:%.*]] = lshr i32 [[V_1_32]], 24
; BE-NEXT:    [[TMP1:%.*]] = trunc i32 [[TMP0]] to i8
; BE-NEXT:    br label [[LOOP:%.*]]
; BE:       loop:
; BE-NEXT:    [[V_I:%.*]] = phi i8 [ [[TMP1]], [[ENTRY:%.*]] ], [ [[TMP3:%.*]], [[LOOP_LOOP_CRIT_EDGE:%.*]] ]
; BE-NEXT:    [[I:%.*]] = phi i64 [ 1, [[ENTRY]] ], [ [[I_INC:%.*]], [[LOOP_LOOP_CRIT_EDGE]] ]
; BE-NEXT:    [[P_I:%.*]] = getelementptr i8, i8* [[P]], i64 [[I]]
; BE-NEXT:    call void @use.i8(i8 [[V_I]])
; BE-NEXT:    [[P_I_32:%.*]] = bitcast i8* [[P_I]] to i32*
; BE-NEXT:    [[V_I_32:%.*]] = load i32, i32* [[P_I_32]], align 4
; BE-NEXT:    call void @use.i32(i32 [[V_I_32]])
; BE-NEXT:    [[I_INC]] = add i64 [[I]], 1
; BE-NEXT:    [[CMP:%.*]] = icmp ne i64 [[I_INC]], 64
; BE-NEXT:    [[TMP2:%.*]] = lshr i32 [[V_I_32]], 16
; BE-NEXT:    [[TMP3]] = trunc i32 [[TMP2]] to i8
; BE-NEXT:    br i1 [[CMP]], label [[LOOP_LOOP_CRIT_EDGE]], label [[EXIT:%.*]]
; BE:       loop.loop_crit_edge:
; BE-NEXT:    br label [[LOOP]]
; BE:       exit:
; BE-NEXT:    ret void
;
entry:
  %P.1 = getelementptr i8, i8* %P, i64 1
  %v.1 = load i8, i8* %P.1
  call void @use.i8(i8 %v.1)
  %P.1.32 = bitcast i8* %P.1 to i32*
  %v.1.32 = load i32, i32* %P.1.32
  call void @use.i32(i32 %v.1.32)
  br label %loop

loop:
  %i = phi i64 [ 1, %entry ], [ %i.inc, %loop ]
  %P.i = getelementptr i8, i8* %P, i64 %i
  %v.i = load i8, i8* %P.i
  call void @use.i8(i8 %v.i)
  %P.i.32 = bitcast i8* %P.i to i32*
  %v.i.32 = load i32, i32* %P.i.32
  call void @use.i32(i32 %v.i.32)
  %i.inc = add i64 %i, 1
  %cmp = icmp ne i64 %i.inc, 64
  br i1 %cmp, label %loop, label %exit

exit:
  ret void
}

declare void @use.i8(i8) readnone
declare void @use.i32(i32) readnone

@global = external local_unnamed_addr global i8, align 4

define void @load_load_partial_alias_atomic(i8* %arg) {
; CHECK-LABEL: @load_load_partial_alias_atomic(
; CHECK-NEXT:  bb:
; CHECK-NEXT:    [[TMP2_1:%.*]] = getelementptr inbounds i8, i8* [[ARG:%.*]], i64 1
; CHECK-NEXT:    [[TMP2_2:%.*]] = bitcast i8* [[TMP2_1]] to i64*
; CHECK-NEXT:    [[TMP2_3:%.*]] = load i64, i64* [[TMP2_2]], align 4
; CHECK-NEXT:    [[TMP3_1:%.*]] = getelementptr inbounds i8, i8* [[ARG]], i64 2
; LE-NEXT:       [[TMP0:%.*]] = lshr i64 [[TMP2_3]], 8
; BE-NEXT:       [[TMP0:%.*]] = lshr i64 [[TMP2_3]], 48
; CHECK-NEXT:    [[TMP1:%.*]] = trunc i64 [[TMP0]] to i8
; CHECK-NEXT:    br label [[BB5:%.*]]
; CHECK:       bb5:
; CHECK-NEXT:    [[TMP4_1:%.*]] = phi i8 [ [[TMP4_1_PRE:%.*]], [[BB5]] ], [ [[TMP1]], [[BB:%.*]] ]
; CHECK-NEXT:    [[TMP6_1:%.*]] = load atomic i8, i8* @global acquire, align 4
; CHECK-NEXT:    [[TMP7_1:%.*]] = add i8 [[TMP6_1]], [[TMP4_1]]
; CHECK-NEXT:    store i8 [[TMP7_1]], i8* [[ARG]], align 1
; CHECK-NEXT:    [[TMP4_1_PRE]] = load i8, i8* [[TMP3_1]], align 4
; CHECK-NEXT:    br label [[BB5]]
;
bb:
  %tmp1.1 = getelementptr inbounds i8, i8* %arg, i64 0
  %tmp2.1 = getelementptr inbounds i8, i8* %arg, i64 1
  %tmp2.2 = bitcast i8* %tmp2.1 to i64*
  %tmp2.3 = load i64, i64* %tmp2.2, align 4
  %tmp2.4 = icmp ugt i64 %tmp2.3, 1

  %tmp3.1 = getelementptr inbounds i8, i8* %arg, i64 2
  br label %bb5

bb5:                                              ; preds = %bb14, %bb
  %tmp4.1 = load i8, i8* %tmp3.1, align 4
  %tmp6.1 = load atomic i8, i8* getelementptr inbounds (i8, i8* @global, i64 0) acquire, align 4
  %tmp7.1 = add i8 %tmp6.1, %tmp4.1
  store i8 %tmp7.1, i8* %tmp1.1
  br label %bb5

}

;;===----------------------------------------------------------------------===;;
;; Load Widening
;; We explicitly choose NOT to widen. And are testing to make sure we don't.
;;===----------------------------------------------------------------------===;;

%widening1 = type { i32, i8, i8, i8, i8 }

@f = global %widening1 zeroinitializer, align 4

define i32 @test_widening1(i8* %P) nounwind ssp noredzone {
; CHECK-LABEL: @test_widening1(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TTMP:%.*]] = load i8, i8* getelementptr inbounds ([[WIDENING1:%.*]], %widening1* @f, i64 0, i32 1), align 4
; CHECK-NEXT:    [[CONV:%.*]] = zext i8 [[TTMP]] to i32
; CHECK-NEXT:    [[TTMP1:%.*]] = load i8, i8* getelementptr inbounds ([[WIDENING1]], %widening1* @f, i64 0, i32 2), align 1
; CHECK-NEXT:    [[CONV2:%.*]] = zext i8 [[TTMP1]] to i32
; CHECK-NEXT:    [[ADD:%.*]] = add nsw i32 [[CONV]], [[CONV2]]
; CHECK-NEXT:    ret i32 [[ADD]]
;
entry:
  %ttmp = load i8, i8* getelementptr inbounds (%widening1, %widening1* @f, i64 0, i32 1), align 4
  %conv = zext i8 %ttmp to i32
  %ttmp1 = load i8, i8* getelementptr inbounds (%widening1, %widening1* @f, i64 0, i32 2), align 1
  %conv2 = zext i8 %ttmp1 to i32
  %add = add nsw i32 %conv, %conv2
  ret i32 %add
}

define i32 @test_widening2() nounwind ssp noredzone {
; CHECK-LABEL: @test_widening2(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TTMP:%.*]] = load i8, i8* getelementptr inbounds ([[WIDENING1:%.*]], %widening1* @f, i64 0, i32 1), align 4
; CHECK-NEXT:    [[CONV:%.*]] = zext i8 [[TTMP]] to i32
; CHECK-NEXT:    [[TTMP1:%.*]] = load i8, i8* getelementptr inbounds ([[WIDENING1]], %widening1* @f, i64 0, i32 2), align 1
; CHECK-NEXT:    [[CONV2:%.*]] = zext i8 [[TTMP1]] to i32
; CHECK-NEXT:    [[ADD:%.*]] = add nsw i32 [[CONV]], [[CONV2]]
; CHECK-NEXT:    [[TTMP2:%.*]] = load i8, i8* getelementptr inbounds ([[WIDENING1]], %widening1* @f, i64 0, i32 3), align 2
; CHECK-NEXT:    [[CONV3:%.*]] = zext i8 [[TTMP2]] to i32
; CHECK-NEXT:    [[ADD2:%.*]] = add nsw i32 [[ADD]], [[CONV3]]
; CHECK-NEXT:    [[TTMP3:%.*]] = load i8, i8* getelementptr inbounds ([[WIDENING1]], %widening1* @f, i64 0, i32 4), align 1
; CHECK-NEXT:    [[CONV4:%.*]] = zext i8 [[TTMP3]] to i32
; CHECK-NEXT:    [[ADD3:%.*]] = add nsw i32 [[ADD2]], [[CONV4]]
; CHECK-NEXT:    ret i32 [[ADD3]]
;
entry:
  %ttmp = load i8, i8* getelementptr inbounds (%widening1, %widening1* @f, i64 0, i32 1), align 4
  %conv = zext i8 %ttmp to i32
  %ttmp1 = load i8, i8* getelementptr inbounds (%widening1, %widening1* @f, i64 0, i32 2), align 1
  %conv2 = zext i8 %ttmp1 to i32
  %add = add nsw i32 %conv, %conv2

  %ttmp2 = load i8, i8* getelementptr inbounds (%widening1, %widening1* @f, i64 0, i32 3), align 2
  %conv3 = zext i8 %ttmp2 to i32
  %add2 = add nsw i32 %add, %conv3

  %ttmp3 = load i8, i8* getelementptr inbounds (%widening1, %widening1* @f, i64 0, i32 4), align 1
  %conv4 = zext i8 %ttmp3 to i32
  %add3 = add nsw i32 %add2, %conv4

  ret i32 %add3
}


declare void @llvm.memset.p0i8.i64(i8* nocapture, i8, i64, i1) nounwind

declare void @llvm.memcpy.p0i8.p0i8.i64(i8* nocapture, i8* nocapture, i64, i1) nounwind
declare void @llvm.memcpy.p0i8.p1i8.i64(i8* nocapture, i8 addrspace(1)* nocapture, i64, i1) nounwind


;;===----------------------------------------------------------------------===;;
;; Load -> Store dependency which isn't interfered with by a call that happens
;; before the pointer was captured.
;;===----------------------------------------------------------------------===;;

%class.X = type { [8 x i8] }

@_ZTV1X = weak_odr constant [5 x i8*] zeroinitializer
@_ZTV1Y = weak_odr constant [5 x i8*] zeroinitializer

declare void @use()
declare void @use3(i8***, i8**)

; PR8908
define void @test_escape1() nounwind {
; CHECK-LABEL: @test_escape1(
; CHECK-NEXT:    [[X:%.*]] = alloca i8**, align 8
; CHECK-NEXT:    store i8** getelementptr inbounds ([5 x i8*], [5 x i8*]* @_ZTV1X, i64 0, i64 2), i8*** [[X]], align 8
; CHECK-NEXT:    call void @use() #[[ATTR3]]
; CHECK-NEXT:    call void @use3(i8*** [[X]], i8** getelementptr inbounds ([5 x i8*], [5 x i8*]* @_ZTV1X, i64 0, i64 2)) #[[ATTR3]]
; CHECK-NEXT:    ret void
;
  %x = alloca i8**, align 8
  store i8** getelementptr inbounds ([5 x i8*], [5 x i8*]* @_ZTV1X, i64 0, i64 2), i8*** %x, align 8
  call void @use() nounwind
  %DEAD = load i8**, i8*** %x, align 8
  call void @use3(i8*** %x, i8** %DEAD) nounwind
  ret void
}
