/*************************************************************************
* Copyright (C) 2002 Intel Corporation
*
* Licensed under the Apache License,  Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* 	http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law  or agreed  to  in  writing,  software
* distributed under  the License  is  distributed  on  an  "AS IS"  BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the  specific  language  governing  permissions  and
* limitations under the License.
*************************************************************************/

#ifndef IFMA_ED25519_PRECOMP_H
#define IFMA_ED25519_PRECOMP_H

#include <internal/ed25519/ifma_arith_ed25519.h>

#if (_MBX >= _MBX_K1)

#define MUL_BASEPOINT_WIN_SIZE (4)

#define BP_WIN_SIZE MUL_BASEPOINT_WIN_SIZE
#define BP_N_ENTRY  (1 << (BP_WIN_SIZE - 1))

/* clang-format off */
__ALIGN64 static ge52_precomp ifma_ed25519_bp_precomp[][BP_N_ENTRY] = {
{   /* slot=0 [{1,2,3,..,8} * 16^(2*0)] * G) */
    {{0x00003905d740913e,0x00005d140beb39d1,0x00088f8a09fd399f,0x0001267a5c184346,0x000044fd2f9298f8}, {0x000c93c6f58c3b85,0x000c6fb8c0e192fb,0x00043d42c2cf932d,0x000ba65270b48986,0x000007cf9d3a33d4}, {0x00091205877aaa68,0x00023ccaac49eabc,0x000d43598c26d9e8,0x00065a85a1b7dcbd,0x00006f117b689f0c}},
    {{0x0009a56042b4d5a8,0x0000c4e60acf68a9,0x00016e37aa8f2b81,0x0002555e09e236bb,0x00006bb595a669c9}, {0x0004e7fc933c71d7,0x000967a0ff5b5922,0x0001d607029f469d,0x0002e2e5aa69a65e,0x0000590c063fa87d}, {0x000aa8b3a59b7a5f,0x000dd5d9acf7843f,0x000b3d6a3136c16b,0x0000b73500fa0840,0x0000701af5b13ea5}},
    {{0x00011fe8a4fcd265,0x000fde5c1ba7d566,0x00014bd6bd3bd353,0x000da628131f31a2,0x00002ab91587555b}, {0x0005b0a84cee9730,0x00030e8864b8aaf2,0x000f016732025a84,0x000f8f4c11b50029,0x00007a164e1b9a80}, {0x000e933f0dd0d889,0x000221c35da6214a,0x000cf2db4c589423,0x000b4c6d170e5458,0x00005a2826af12b9}},
    {{0x000e050a056818bf,0x000715660faa995f,0x0006a05073327e89,0x000a49ac3e8e3cd0,0x000027933f4c7445}, {0x000351b98efc099f,0x000f47dfd2538287,0x000b0a92656765c6,0x0008727ca348d3df,0x0000680e910321e5}, {0x0003fbe9c476ff09,0x000457b5cc1725a1,0x00002b44946e9e39,0x0003e2b5ddbdcf91,0x00007f9d0cbf6355}},
    {{0x000182c3a447d6ba,0x000d14b2729b77f9,0x000864a087d50014,0x00055f3e33cf11cb,0x0000154a7e73eb1b}, {0x0002bc4408a5bb33,0x000c3c75eed02a21,0x000abfec448d5048,0x00006ebdd1beb0c5,0x00002945ccf146e2}, {0x000bdbf1812a8285,0x00007d0bdd1fcbcb,0x000bbda72d270e08,0x000b69ab41b670b1,0x000043aabe696b3b}},
    {{0x000806b67b7d8ca4,0x0008427d22739499,0x00004553b9575be2,0x0007884bb085ce72,0x000038b64c41ae41}, {0x000ceeeb77157131,0x0008900c8af883a0,0x000a59a7369b2715,0x00038bd8065b668d,0x000051e57bb6a2cc}, {0x000c326702ea4b71,0x0000341a1bb0185a,0x00083bc144be70e0,0x00061e353e4a24b0,0x000010b8e91a9f0d}},
    {{0x000f2c9aaa3221b1,0x000533bba23a7ba6,0x0002192c3a6ca021,0x00017e09dea764f9,0x00001d6edd5d2e53}, {0x000a5cd0944ea3bf,0x0003ab39dc0d26b1,0x0008542e49747035,0x000927e71b252822,0x0000461bea69283c}, {0x00036dc801b8b3a2,0x00047053ea49af18,0x000877adf3b3035f,0x00090a7529c41ba5,0x00007a9fbb1c6a0f}},
    {{0x00075dedf39234d9,0x00080e1b558f9e2a,0x000e3c23fb963d76,0x00001c32c2741ac6,0x00003a9024a1320e}, {0x0007596604dd3e8f,0x00077e288702c59b,0x000ed9c3236cb303,0x000e52fb1339c665,0x00000915e76061bc}, {0x0001f5d9c9a2911a,0x000788bcca7d7e7c,0x000eb62a32b8a371,0x0004e95636412190,0x000026907c5c2ecc}},
},
{   /* slot=1 [{1,2,3,..,8} * 16^(2*1)] * G) */
    {{0x000b635449aa515e,0x0009f0bc6823aed5,0x000b42d1c4a865c4,0x00015b9850c1fe95,0x000030d76d6f03d3}, {0x000cdd0e632f9c1d,0x00096768931152ec,0x0008637a5851d0b6,0x000ef3952dfb76ba,0x00006dd37d49a00e}, {0x000444172106e4c7,0x00080928d7f696c4,0x00094d3f26fb53d6,0x0004bb0b4739ea46,0x000010c697112e86}},
    {{0x0003c4277dbe5fde,0x000ad19ad7ea2649,0x0006304590265d4f,0x000fe090e00dfc84,0x000025e61cabed66}, {0x00062aa08358c805,0x000e37a2042470ca,0x000b11eddc6a3d4a,0x00006ef7464d3a63,0x000003bf9baf5508}, {0x0003e128cc586604,0x000ecb459747e3f1,0x000c1268f56f5873,0x000e22ca0b63dedc,0x0000566d78634586}},
    {{0x0007a49f9cc10834,0x000d5a89bc451163,0x000f7fd2dbbc8e56,0x00035d91cb5ec0f7,0x000033975bca5ecc}, {0x00054285c65a2fd0,0x0002af31667c3a10,0x00031aee586c6411,0x000b22a680ae2407,0x000014fba5f34793}, {0x000746166985f7d4,0x00084c9c800573cd,0x000b61131e593e5e,0x000526c2fc3f2b67,0x000014829cea83fc}},
    {{0x00037b8497dd95c2,0x00030aa4eb5a7ff4,0x000c85e88b6c744e,0x00081739e0c5d613,0x00002fd9c71e5f75}, {0x00070b2f4e71ecb8,0x000b940a477e321e,0x000e1d4f80e656dd,0x0007b7ebf6556cec,0x000005fc3bc4535d}, {0x0008b3ae52afdedd,0x0008ced3b30cf24b,0x0009be8195349563,0x0001f0433a4bc83a,0x0000373767475c65}},
    {{0x000a99fd40d1add9,0x0006f96f4d0272fb,0x0005f03baeb30716,0x000f9994363f0521,0x00001fbea56c3b18}, {0x000095cb14246590,0x0004016c15535634,0x000910bc60ef1214,0x0007c8c9e38140c8,0x00006bf590573090}, {0x000778f1e1415b8a,0x000f7bac3a77e0fa,0x000aa29a5006409f,0x0005a566f52d7b89,0x000002521cf67a63}},
    {{0x000fee0b0a9d5294,0x0005c0fdf5a66513,0x000fe107ce8f98e7,0x0002cedd4618688b,0x00003fa00a7e7138}, {0x00046720772f5ee4,0x000b196079aceb11,0x0000ac824ae8f894,0x0006cc44af8224d0,0x0000001753d9f7cd}, {0x0009232d963ddb34,0x000dab49738583c6,0x000091f2851dde87,0x000edb6aad7d1f9a,0x000012b5fe2fa048}},
    {{0x0000fbc496fce34d,0x0006badf35bed71f,0x000f28c56173b982,0x000206fd2047261f,0x0000749b76f96fb1}, {0x000b7c26ad6f1e92,0x00023504b8913df2,0x00051c8bc34b66d3,0x000c7b88c409dc07,0x00006f7e93c20796}, {0x000af604aea6ae05,0x000f1bee49c991f5,0x000eff6b66c12351,0x000215161a808b5e,0x00000fcec10f01e0}},
    {{0x000d58a649fe1e44,0x000a231ad777e644,0x00087fd0d221fcae,0x00011f302441c5a8,0x00004901aa7183c5}, {0x0002d29dc4244e45,0x0007493d8de0a3df,0x00020c214d2b020e,0x000b90a6cc8067e8,0x0000413779166fea}, {0x0001b7548c1af8f0,0x0007c246299b408b,0x000e06d939ce0f7a,0x0001213f760b0f91,0x000041bb887b726d}},
},
{   /* slot=2 [{1,2,3,..,8} * 16^(2*2)] * G) */
    {{0x00087d44744346be,0x000d415b52b2540e,0x00013b603e1d48da,0x000bdf77c3a8a18a,0x00004eb728c12fcd}, {0x00034c597c6691ae,0x0003d0a85b4c87e2,0x00054afae764889d,0x0009e1ddae2c90c3,0x00000a871e070c6a}, {0x0001b5994bbc8989,0x0003a5bdd4260330,0x0009d59e3c736bae,0x000d4640d61ade21,0x00003ee7300f2685}},
    {{0x000255e49e7dd6b7,0x0005c610b1eacf5d,0x0002e187ca801611,0x00025c23c99975d9,0x0000138157629791}, {0x000a7947841e7518,0x00059639c46d743f,0x0003052b74e5c6fa,0x0009030a1065e1de,0x00007d47c6a2cfb8}, {0x000ad0148ef0d6e0,0x0009a91546f3c3fd,0x0006bb81579d3e74,0x000ec8071ec62102,0x0000148cf58d34c9}},
    {{0x000492f67934f027,0x000bef6840aa946a,0x0009611854469984,0x000bbd45ca1bc2a8,0x00003ff2fa1ebd5d}, {0x00072f7d9ae4756d,0x000bb88f3487fe25,0x000960a88d56c345,0x000a1b99fd10b6d6,0x0000278febad4eae}, {0x000a681f8c933966,0x0009c20290c98b1a,0x00019d3c528c2194,0x000677b391152912,0x00004104dd02fe9c}},
    {{0x0002bf5e1124422a,0x0003398a33ab572b,0x000a52b666a1fa0c,0x00053d594cb6101f,0x00002c863b00afaf}, {0x00014e06db096ab8,0x000c90ce44f35812,0x00009e2af521a8b6,0x000a4816524c12a4,0x00000165b5a48efc}, {0x0000a474a0846a76,0x00084cd2f7cc0f19,0x0008aa2b8f12eff9,0x000c8b8695e29065,0x0000591b67d9bffe}},
    {{0x000f0d1c80b49bfa,0x0005eabf3ec8a312,0x000ef01c88597951,0x0007bcb727033c09,0x00003de02ec7ca8f}, {0x0009b3719f18b55d,0x000faa18c641e99b,0x00029f05ede465e5,0x000128b61081136c,0x0000489b4f867030}, {0x0002102d3aeb92ef,0x000b46116a861d23,0x00090baa24e16253,0x000bebf3d7eabe71,0x000049f5fbba496c}},
    {{0x00049a108a5bcfd4,0x00070bc6473eb309,0x00007c0d1cdc40dd,0x0006e7492c294c13,0x00005604a86dcbfa}, {0x000d628c1e9c572e,0x000acc5884741155,0x00015763eb8a4d86,0x000515b91a352f65,0x000006a1a6c28867}, {0x0008d1d47c1764b6,0x00040e0418b51728,0x0008acf6d1725411,0x00042c69f031a601,0x000020989e89fe27}},
    {{0x000777fd3a2dcc7f,0x0002ca54fd892499,0x000207e3a032857c,0x0007e29a279d864d,0x00000403ed1d0ca6}, {0x0004278b85eaec2e,0x000077acb2bdf167,0x0001cbf45a5621dc,0x00095d3640a4c166,0x0000730b9950f705}, {0x000b2d35874ec552,0x000cf98246f8dc94,0x0006c035cec5e6c8,0x0003dccf7cb46fa1,0x00005bd745430830}},
    {{0x000ad19528b24cc2,0x000656335c1817f9,0x000fc072367f6b54,0x000ad8366b8b66e4,0x0000133a78007380}, {0x0004932115e7792a,0x000a2bdcdddc985c,0x000da3d762c64c89,0x000f82c9d1e3da8a,0x00005bb7db123067}, {0x0001f467c6ca62be,0x000d6211952ee096,0x000bd5477004ec21,0x000e0d2182360779,0x0000740dca6d58f0}},
},
{   /* slot=3 [{1,2,3,..,8} * 16^(2*3)] * G) */
    {{0x0008ee0752cfce4e,0x000f306ec08b7df4,0x00095459c4c3fffa,0x000a38d05710b2ab,0x0000161d25fa963e}, {0x000a8c570478433c,0x0000ec281439d231,0x0003d9079fb7b527,0x00003d9dbaa99eae,0x00002c03f5256c2b}, {0x000f18757b53a47d,0x00030cf0c5879790,0x00057ef7f9307b01,0x000bbaf31903d772,0x0000699468bdbd96}},
    {{0x000f2f46f4dafecf,0x00014a47fd6f7bd1,0x000a47b37f7cef01,0x0005785d31ffdda4,0x0000525219a47390}, {0x000d3de66aa91948,0x000c22fc0d2ccd8d,0x0004fdea2f485064,0x0002e3a9b4824663,0x0000293e1c4e6c4a}, {0x000e134b925112e1,0x000b5dca15da0376,0x00061c3111703778,0x0002823b04589af4,0x00005b605c447f03}},
    {{0x0005805920c47c89,0x0000c923b8fccb96,0x0002e2ef77e7f010,0x000b3ee000125650,0x000024a76dcea8ae}, {0x0009fec6f0e7f04c,0x0009e75e349623be,0x000e1de61a866a57,0x000bdd55542ef161,0x00002f12fef4cc5a}, {0x000522b2dfc0c740,0x0007f40c9a4070a4,0x0008cff66810d06e,0x0003790c6cf14417,0x00005e607b2518a4}},
    {{0x00031d8f6cdf1818,0x0004fc36258a258b,0x0006e61d6e35cfa7,0x000d5f7e1b3ff4f6,0x00005067acab6ccd}, {0x000c431ca596cf14,0x00040aed3e400a02,0x000e0f26dbe3c42d,0x0007068d24526802,0x0000201f33139e45}, {0x00027f6b08039d51,0x00064017c0006fd5,0x000e25a4a818b149,0x0000375d5220eb02,0x0000397cba886246}},
    {{0x00013093f05959b2,0x0008de9a9797630c,0x00021d5e26e23aa1,0x0006c3a222fd4917,0x00002339d320766e}, {0x0005c3fbc81379e7,0x00020dde12af1781,0x0005a8fdd5a66194,0x000c252ffa9c0f88,0x0000771b4022c1e1}, {0x000dd986513a2fa7,0x00071f9d4cf08d87,0x000ea283b3f5ac9b,0x0001a76d06bc31b1,0x0000331a18921997}},
    {{0x00066f45fb4f80c6,0x000de61c775cff51,0x000041d91c9c36c7,0x000fe21e3d4e81b9,0x000031167c6b83bd}, {0x00012f3a9d7572af,0x0008868074a9e265,0x000180f7c45bcbe2,0x000a67b84edc1c11,0x00001ac9619ff649}, {0x000b3842524b1068,0x0003bee9ce987f22,0x000a6250c8506834,0x000b111fc9d71844,0x0000612436341f08}},
    {{0x000d41db874e898d,0x000f16c07dc20d99,0x00000f9bbc09fea5,0x000ff40793d2c67d,0x000046ebe2309e5e}, {0x000349e31a2d2638,0x000009bd3fd358b6,0x0003a06ba49ddfb7,0x00004457f8bf1b8a,0x00001522aa3178d9}, {0x00082f5369614938,0x0009ab72d6d102c3,0x000646f227dafe40,0x000306ce8c83391b,0x000045fe70f50524}},
    {{0x000875a6960c0b8c,0x00076ef0e2f20da4,0x000d0b8fd45b68d0,0x00092d407fb51cf3,0x0000428d1623a0e3}, {0x00024920c8951491,0x000c83f630ca262f,0x0005c9d4b805f007,0x00022456fbb45d2f,0x000016619f6db57a}, {0x000f4a4401a308fd,0x000c376a5caac084,0x0003d1bc7da82219,0x00038c6deb8de464,0x00001d81592d60bd}},
},
{   /* slot=4 [{1,2,3,..,8} * 16^(2*4)] * G) */
    {{0x00068756a60dac5f,0x0006aebabdc57613,0x000cce0f7d17e02f,0x000dcf07f193f2d4,0x000020234a7789ec}, {0x0005b69f7b85c5e8,0x0008bd168bab2876,0x000d330f9b6ff067,0x0008e7c3a70e77c1,0x00003a5f6d51b0af}, {0x00020db67178b252,0x000f9d51ed16076d,0x0003e41170071c34,0x000e366f62a4a20b,0x00007cd682353cff}},
    {{0x0001a45bd887fab6,0x00032ba403b6e0be,0x00096e60002a846a,0x0000943d9921012e,0x00002838c8863bdc}, {0x0005cd6068acf4f3,0x000183cd7e3d3a66,0x00036025d942d92d,0x000d8ff5759389d3,0x00003ef0253b2b2c}, {0x000bb0cf4a465030,0x0004115c577abd16,0x0004ab419dfa496b,0x000281282cfae8af,0x000021dcb8a606a8}},
    {{0x000004468c9d9fc8,0x0006ed42aa3cb5c6,0x0002ee2f9c254009,0x0001dab125b4d4c1,0x00000bc3d08194a3}, {0x000d00fabe7731ba,0x0007e629e18899a8,0x0003f3d97f820360,0x000678bb2cc02374,0x00005d840dbf6c6f}, {0x000e380d309fe18b,0x000a6b9e165c7706,0x000dae20ab6eb02d,0x00096dd57bbba997,0x00003a4276232ac1}},
    {{0x0002432c8a7084fa,0x000e3dfb9e5454b4,0x000c58e45d898a19,0x000ebd1be9f00219,0x00001ff177cea16d}, {0x0008c172db447ecb,0x0001fc6282dbd3bf,0x0005aa15fe5fcfc4,0x000a9f980acffc07,0x00000770c9e824e1}, {0x0001d99a45b5b5fd,0x000e91b3a7924cf6,0x00003e3e89860984,0x0000b1ee73009193,0x000039f264fd4150}},
    {{0x000d3417dbe7e29c,0x0006a2b9c139ca7a,0x0003597ba9bd9437,0x0009840a0e91b8e9,0x00001712d7346888}, {0x000b4aabfe097be1,0x000e1dfe01929d19,0x000ca6f1ffa46dfc,0x000f14ec3c908942,0x000065c621272c35}, {0x000b89f8ce3193dd,0x00056a125c0bbe72,0x000e1cfe834d1033,0x000e2720419a93d2,0x000022f9800ab19c}},
    {{0x000a368a3e9ef8cb,0x00022a5504715605,0x000f24248fe3e9c0,0x00026e5553d48b05,0x000013f416cd6476}, {0x00029fdd9a6efdac,0x000be34a54941420,0x0007bdf37bb912ce,0x000cab4640f64b98,0x00004171a4d38598}, {0x000758aa99c94c8c,0x0006fb000b807fa2,0x000dda539223006f,0x000d1abfbd291dda,0x0000508214fa574b}},
    {{0x000269153ed6fe4b,0x00039511d77c4c20,0x000c14af94a65a67,0x000a74bcbde26462,0x000022f960ec6fab}, {0x000a15bb53d003d6,0x00088bcf3c965461,0x000c683a5ab21028,0x000b44727c576756,0x00003a7758a4c86c}, {0x000111f693ae5076,0x000df1dfd54a6548,0x0003115e651dae21,0x000f49412248c90f,0x00005d9fd15f8de7}},
    {{0x000408d36d63727f,0x000efd7c7b533031,0x000caee24b6a379a,0x000bed3a9e18fc5c,0x0000332f35914f8f}, {0x00044d2aeed7521e,0x00028432e96153f2,0x000e9c16d48e3a90,0x00098d8e164ba772,0x00003bc187fa47eb}, {0x00070115ea86c20c,0x000cb6c46d1256d4,0x000a660188998ab7,0x000ba03d77832b53,0x0000450d81ce906f}},
},
{   /* slot=5 [{1,2,3,..,8} * 16^(2*5)] * G) */
    {{0x000bb6a1a6205275,0x000d7413c8e836e7,0x00088f5cb2aa4f21,0x0005be16f56d155e,0x00002de25d4ba634}, {0x0004d8961cae743f,0x000f5ee1c63edd07,0x0007f4ed29f86d18,0x000b10897bdc55be,0x00004cbad279663a}, {0x00019024a0d71fcd,0x0000afb288af880d,0x000f3a6419c525c2,0x0007233b1a3974b5,0x00007d7fbcefe200}},
    {{0x000f1e6a266b2801,0x000c4d5739f16fae,0x000b03762c866c68,0x0005a8df68a2fbc1,0x00005975435e87b7}, {0x000c5dc5f3c29094,0x0009a2a9105abcd7,0x00021c3058c781a2,0x000d4d780c61d364,0x00004f9cd196dcd8}, {0x000297d86a7b3768,0x000241ad17a63199,0x000c1c0c17d0d058,0x0000307ba029cad5,0x00007ccdd084387a}},
    {{0x0006422c6d260417,0x00050948240bddca,0x000b68c677ae153d,0x000cf53a9c0c1b4f,0x0000428bd0ed61d0}, {0x000c84186760cc93,0x0007a1ab32a999b0,0x00020bda18cdae00,0x000ca44a88dec866,0x00003593ca848190}, {0x0003189a5e849aa7,0x0003565d8facd921,0x0003fdbbd1d4d8c3,0x00063e68c52545b5,0x000027398308da2d}},
    {{0x00038d28435ed413,0x000603278ccc942c,0x0009da03efbd50f3,0x0003355bb07ab1a7,0x0000269597aebe8c}, {0x00010e4c0a702453,0x00066d57d1bdeb9a,0x000d27daf70fa258,0x00033fdffb9d9b5c,0x0000572c2945492c}, {0x000fc745d6cd30be,0x000d3e3baaefbc77,0x000a5dda0ce4dfe8,0x000ca80a22c8830a,0x00007f985498c05b}},
    {{0x0009ce889f0be117,0x0001b7b54a288384,0x0003fc921c8005ad,0x000f3043da3c39f2,0x000076c2ec470a31}, {0x000615520fbf6363,0x00045cf4dfba6d35,0x00073fa0c208045a,0x00012e7eec24fbc8,0x000030f2653cd69b}, {0x0008c938aac10c85,0x00060db276bcb8a0,0x000e6fac7046179b,0x00073daa920c01e0,0x00002f1273f15964}},
    {{0x0009fc7c8ae01e11,0x000904a6aab9f473,0x0007728f2efd5274,0x00069f241d98a828,0x00005d9e572ad85b}, {0x00088bd755a70bc0,0x000a4f1d442e7304,0x000c59616206d6b5,0x000f784ead1a69eb,0x000038ac1997edc5}, {0x0006b517a751b13b,0x000867e9b858c066,0x00054dde49747d06,0x000e69cacacc0114,0x000022dfcd9cbfe9}},
    {{0x000bd2e0c30d0cd9,0x0005facbb43338dd,0x00022a961fad8e66,0x000c1c78f6b258c3,0x00006b2916c05448}, {0x000c59b4103be0a1,0x000ecd259f96956e,0x0003f5cd322ee3ba,0x000e472797cb2941,0x00000fe9877824cd}, {0x000b34d10aba913b,0x000822e6dac0e7ed,0x000578f8154ea3cd,0x0000a1766083dff6,0x00004c303f307ff0}},
    {{0x000a3bd617b28c85,0x000b739773bead30,0x000e6a5cbfc5d377,0x000b7c4c6c6e78c1,0x00000d61b8f78b2a}, {0x000c03580dd94500,0x000a46fbbec9329f,0x0002e2a7f8ecd27a,0x000a1d5130a155fc,0x0000416b151ab706}, {0x0008d7efe9c136b0,0x000cd58e44b2056a,0x000b57e0abbd07e5,0x000e8d2afe62fda1,0x0000191a2af74277}},
},
{   /* slot=6 [{1,2,3,..,8} * 16^(2*6)] * G) */
    {{0x0006f74bc53c1431,0x000ce2072eddece1,0x0005b23ee72b9725,0x000c908b8b9c36fb,0x00007e2e0e450b5c}, {0x00062b434f460efb,0x000d4a63607d69fe,0x0007a0da24ded303,0x0005b93f052210eb,0x0000237e7dbe0054}, {0x000575ed6701b430,0x000e69f0bfd10013,0x0003e47f22231094,0x00055e375320f158,0x000071afa699b111}},
    {{0x000e6f9b3953b61d,0x000eaafa141e665c,0x0009f759fec65839,0x000c28e0f435ffda,0x0000021142e9c2b1}, {0x00023c1c473b50d6,0x0001f3b38ef10ea4,0x0002c9be9551e87a,0x0009a1c9b84bf5fb,0x000000731fbc78f8}, {0x0000c71848f81880,0x000225ecec119e43,0x000bba15e3bf960c,0x0005808b6dae0836,0x00004c4d6f3347e1}},
    {{0x0007eccfc17d1fc9,0x000a651403c1418f,0x0007ee0cdf6c75f5,0x0007a22dbde712bf,0x0000193fddaaa7e4}, {0x000cddfc988f1970,0x00027b0b9f51b2f0,0x00079176be6b9162,0x0009fa86ec7b6c47,0x000038bf9500a88f}, {0x0002c93c37e8876f,0x0005a18d1462c1fd,0x0009241276a2f61e,0x00049695080f5823,0x00006a6fb99ebf0d}},
    {{0x0006c1bb560855eb,0x00038f893f09d6a4,0x000f71acc12416bb,0x00096ead71d11378,0x000075f76914a318}, {0x000122b5b6e423c6,0x00010f286ff8eeeb,0x000dcf5d8c939d70,0x000eb1090a92a831,0x0000136fda9f42c5}, {0x000cdfb1a305bdd1,0x0009d9ff82c08f94,0x0003bb588a0f364b,0x000dcba2a87d8a5c,0x0000022183510be8}},
    {{0x000766385ead2d14,0x00080ca7c58304af,0x0000211e3da08ed8,0x0006c030d13a6e61,0x00006a071ce17b80}, {0x000a710143307a7f,0x0009ec47da45f9d5,0x000e927ad3b063de,0x000426c22bbfe52b,0x00001387c441fd40}, {0x0003c3d187978af8,0x0003d7f0e4413b5d,0x000b477ca0722b5a,0x000dc920d7b4848b,0x00003171b26aaf1e}},
    {{0x000f319097564ca8,0x0004c2275e119a92,0x0004875150ff7bb8,0x000835a4f55fe37a,0x0000221fd4873cf0}, {0x000db7d8b28a47d1,0x000d61770a4f1a60,0x0003ddbd58a6bf14,0x00043e9d4a1f8935,0x00006c514a633442}, {0x0002204f3a156341,0x000e9ba0a032d232,0x00010f030efb73e0,0x0004aaafce0dd4c4,0x000048daa596fb92}},
    {{0x000a8e665ca59cc7,0x0004b2e38aca06ec,0x00021e17cea84725,0x0004af731afc708d,0x0000676dd6fccad8}, {0x00061d5dc84c9793,0x000e3ef41820614f,0x00046277ac9941f9,0x00079a9cdf5b88f3,0x000058c837fa0e8a}, {0x0009688596fc9058,0x000f37b56a01b0cf,0x000935d66a1ddcbb,0x0007f0adcc2e77d4,0x00001c4f73f2c6a5}},
    {{0x000a4fbd305fa0bb,0x000e054c663ad0e7,0x000fe33848829d4c,0x0004c42f421c3832,0x0000795ac80d1bf6}, {0x000e706efc7c3484,0x000b4c3c1cf61b36,0x00081cc7e573dfc9,0x000675ceb1d79c97,0x000070459adb7daf}, {0x0001db4991b42bb3,0x000234b02dcca1b9,0x000f8c78dc572696,0x0001fd39fdf9ee51,0x00005fe162848ce2}},
},
{   /* slot=7 [{1,2,3,..,8} * 16^(2*7)] * G) */
    {{0x0009214fe194961a,0x000c70d71cd4f4e5,0x000b50f22d49be7d,0x00072329300cfd23,0x00004789d446fc91}, {0x0009852d5d7cb208,0x00070687df2e7287,0x0001687891b8dedd,0x000aa35dc0bffab2,0x00002b44c043677d}, {0x000c87ab074eb78e,0x0008e99daf4671a1,0x00084f9067fac6d1,0x000a4e43eacbbcd4,0x000060c52eef2bb9}},
    {{0x000d89bc3bfd8bf1,0x00037c9f3551a0b5,0x00053028f5b06b92,0x000caab0e4c16b0d,0x000010bc9c312ccf}, {0x000bc5c27cae6d11,0x0009b54a48cab702,0x000a492eb244c769,0x000676defbc4056b,0x000070d77248d9b6}, {0x000ae84b3ec2a05b,0x000f4ed1781e0aa8,0x00008e85d198699e,0x000f413794513e47,0x000063755bd3a976}},
    {{0x000fa03e2ad10853,0x000909ee63569b55,0x000e69b890356f75,0x0006f849ff9f1fdb,0x00000d8cc1c48bc1}, {0x0007101897f1acb7,0x0005ec165bbd83dc,0x000fa1020f5dda7d,0x0002a56508e5b9c0,0x00002763751737c5}, {0x000402d36eb419a9,0x0007e77b460a5029,0x00043c4956f0b44e,0x00066e7cfa86230d,0x000070c2dd8a7ad1}},
    {{0x000194509f6fec0e,0x000a946c6518d656,0x0007e09b5cee2e7e,0x00084959733c1f36,0x00002e0fac636394}, {0x0004967db8ed7e13,0x0000ad776817a91d,0x000d85256474252f,0x0003ce5e40982e00,0x000032b8613816a5}, {0x0007f7bee448cd64,0x00067087886d079e,0x0000e4db2e6ac83a,0x0004f41f89fd4d9a,0x00004179215c735a}},
    {{0x000094e7d7dced2a,0x000c347d39c708c7,0x000906d90297fb8a,0x0009d76e13be033a,0x0000700344a30cd9}, {0x000e33b9286bcd34,0x000b6559dd6dce4a,0x0003d38e1fb7ef7e,0x000c286278b141fb,0x000031fa85662241}, {0x00026c422e3622f4,0x000879833502daf8,0x000b389123c12029,0x00024899bc1b7e12,0x000024bb2312a995}},
    {{0x0008ed1732de67c3,0x00018461b4948b1a,0x0006cfbcd23cb494,0x00080088ebd43437,0x00000fee3e871e18}, {0x00080c2af5f85c6b,0x000c304fa679441f,0x0003ba1bad687284,0x0005d168945df99a,0x00000d1d2af9ffeb}, {0x000a8aa132621edf,0x000a159226579a9d,0x00079ac19330b822,0x0001d764004197ba,0x000016acd7971853}},
    {{0x000f72af2d9b1d3d,0x00036a432245a72d,0x0006b3963763462a,0x00023093ecea0791,0x0000123e0ef6b930}, {0x0009c6c57887b6ad,0x000ad5f90febac95,0x000342f50494e19e,0x000170016e24e62a,0x0000164ed34b1816}, {0x000ed94c192fe69a,0x000ea3a911513487,0x0009a4de2761ae2c,0x000f3eb877bf6d3b,0x000078da0fc61073}},
    {{0x00015d28e52bc66a,0x0001870f01a8e5bf,0x0006c28bdd2c47e3,0x000173a2419afbc0,0x00002d25deeb256b}, {0x000f80f1680c3a94,0x000151ae9e7e6a29,0x000801797371f77e,0x0008ddd1100f1584,0x0000054aa4b316b3}, {0x0008468d19267cb8,0x0009c66e54dafdfc,0x00066eec170b2878,0x000a7602aeb1d2a6,0x0000134610a6ab7d}},
},
{   /* slot=8 [{1,2,3,..,8} * 16^(2*8)] * G) */
    {{0x00038ec78df6b0fe,0x00089e575f51b511,0x00017af1b95397da,0x000d65009207a1d7,0x00002102fdba2b20}, {0x000a65e777d1f515,0x000878faa60f1cd2,0x000abc06e5548991,0x000c9fbb1b73bbcd,0x0000654878cba97c}, {0x000ee405055ce6a1,0x000681251ad29969,0x000a7da41536bca7,0x000b2ba3a1af517a,0x00000ad725db29ec}},
    {{0x000267b1834e2457,0x000b570ce1bc5dc4,0x0007d15ed7b67544,0x00036501af07a0bf,0x00004aefcffb71a0}, {0x0007bc0c9b056f85,0x00068e7f5ffd7fec,0x000312aefa537d52,0x0009fd977afc6624,0x00004f675f530239}, {0x000d36360415171e,0x000118998483bc32,0x0000945110cd2bef,0x0006561870a6eadd,0x00000bccbb72a2a8}},
    {{0x000e962feab1a9c8,0x0003565147dcd185,0x000b5b6df286e7e6,0x000b73eb092e031b,0x00004024f0ab59d6}, {0x000d5e4c50fe1296,0x00082fee89f7e186,0x00007031b0e0397b,0x00037c23bc7f6c55,0x00006678fd69108f}, {0x0006fa31636863c2,0x00048572d33f2158,0x00089eaefc07f68c,0x00047014f73cc9f7,0x00002d42e2108ead}},
    {{0x0005131594dfd29b,0x0005d313f4c6a97f,0x0008455010615598,0x000d322eba13f070,0x0000676b2608b8d2}, {0x00017b0d0f537593,0x0000b131e064c217,0x00052ae09f914e69,0x0003c6e1bb687ae7,0x0000420bf3a79b42}, {0x0008ba651c5b2b47,0x000ec311b1b80813,0x000c3135b08671b6,0x000f1e07bff0cb1b,0x0000745d2ffa9c0c}},
    {{0x00025a1e2bc9c8bd,0x0000826479d81bf5,0x000f0155dbea5b26,0x000f5d0d511c70ed,0x00001ae23ceb960c}, {0x0006df5721d34e6a,0x00027997bb3d0603,0x0008756afab1db88,0x000c839d3c209c3c,0x000006e15be54c1d}, {0x00025d871932994a,0x000b5ceb1dab05b7,0x000ab7ca0532351c,0x000c1f77dc41549d,0x000058ded861278e}},
    {{0x00073793f266c55c,0x000c5cc454e49d81,0x000c26c3a8c8c976,0x000f6f95ce382f8b,0x00002ff39de85485}, {0x000b5ba8b6c2c9a8,0x0008ef52c598c2df,0x00012d157348eeef,0x0005bd833809107f,0x000008ba696b531d}, {0x000d3eeec3efc57a,0x00017d4ff481177e,0x0001a671cb04e055,0x000fe54ea3d7a3ff,0x0000120633b4947c}},
    {{0x0004987891610042,0x0003cecebfae80b9,0x0004f0a4c04ee7b1,0x000918570be73959,0x000035d30a99b4d5}, {0x000d31474912100a,0x0006d7e6fbe0682b,0x0001ea79c6de237b,0x0003bdee11e76191,0x000007433be3cb39}, {0x000944c05ce997f4,0x000e4b05c51a3ff7,0x000a76847c575d3d,0x000da9f583381fd5,0x00002d873ede7af6}},
    {{0x000a316443373409,0x000eef4aa81d9157,0x0005a64806fab8b7,0x000a7b6b093fee6f,0x00002e773654707f}, {0x000202e14e5df981,0x000175015e1f5aa6,0x000ae21d6ca20d59,0x000025318a275d3b,0x00000543618a0160}, {0x000abdf4974c23c1,0x000259dce46930de,0x00029aba2caa6f0a,0x000960d04202cb8a,0x00004b1443362d07}},
},
{   /* slot=9 [{1,2,3,..,8} * 16^(2*9)] * G) */
    {{0x0004b7c7b66e1f7a,0x00025f50c2f7eccc,0x00013eaf1c44157e,0x00063f73ef06dfc7,0x0000582f446752da}, {0x000c54e91c529ccb,0x0009264c635fb967,0x000812196530f626,0x0006f5c2747aff47,0x000017038418eaf6}, {0x00017bd320324ce4,0x000e8a4488bc4c63,0x000e5a1364a81042,0x0008dc9b21ef18b4,0x00000c2a1c4bcda2}},
    {{0x000dc7d06f1f0447,0x0003edb87c059d24,0x000bb2d28fb2269e,0x0004877d15b0272f,0x00007c558bd1c6f6}, {0x0004814869bd6945,0x0007dbe1c8d22edc,0x00055cc5ab0d6d90,0x000dc83c63bd212d,0x00005a6a9b30a314}, {0x000c1524d396463d,0x0008ac35a24f0d0e,0x000cbc5fa412bb62,0x000afc3a50c3a791,0x00000404a5ca0afb}},
    {{0x000f40070aa743d6,0x000cb5b265ee88c1,0x00068fd2deccbad0,0x0009633574b046b6,0x000046395bfdcadd}, {0x000c9e1b2a416fd1,0x00028e350598b62b,0x000d5d6967b5c6f7,0x000ee9804343fd83,0x000039527516e7f8}, {0x000fdb2d1a5d9a9c,0x000bcd1005c2a117,0x0004d56fea9c7745,0x000d016efd4bef15,0x000076579a29e822}},
    {{0x00068e7e49c02a17,0x000a2bca9a37f45b,0x000c224c1b23cd51,0x000bdb13ed65f11e,0x000043a384dc9e05}, {0x000cb51352b434f2,0x0004993de80e1333,0x00050d35ced83228,0x00077c1b55128877,0x000002c514bb2a27}, {0x000bd5da8bf1b645,0x0007ef6b54b53684,0x0009b0d253fb8bd3,0x0008059313916d7a,0x0000116092096154}},
    {{0x000d166929dacfaa,0x0004c8413598fb44,0x00053d5559da529f,0x0008e0be9ef63ca4,0x0000351e125bc569}, {0x00085616369b4dcd,0x000a7655c35637a3,0x0004f1802175c02c,0x000e0427dc21bf9d,0x00002f637d7491e6}, {0x00049b461af67bbe,0x0007ac8ab8961d4b,0x0009a699fbd60303,0x0002a9a71dee19ff,0x00007f182d06e7ce}},
    {{0x000c8e64ab0168ec,0x0005515edc5437a7,0x0007cd0edacb5a4a,0x00093b0095519d34,0x000067d4ac8c343e}, {0x00054b728e217522,0x000f4d484b8d8094,0x000f46903caa58e8,0x0005217d358254d7,0x000044acc043241c}, {0x000d6bbb4f7a5777,0x000d4918313e11c7,0x00096b46848b35fe,0x00071bd4adca1c6c,0x0000556d1c8312ad}},
    {{0x000f40e30c8d3982,0x0003e15a3fa3417e,0x000773646e31f707,0x0004eff4f21f3cb0,0x0000746c6c6d1d82}, {0x00006756b11be821,0x0002310a3f3dd81f,0x000a99465d0faff8,0x0007f05f8b2d0556,0x0000097abe38cc8c}, {0x0009c9877ea52da4,0x000559bdc1d430c4,0x0007ccebd24c4369,0x00084bd022c3809f,0x0000577e14a34bee}},
    {{0x000268ac61a73b0a,0x000103791a5f5f0e,0x000b6d00e9f2fafa,0x0008f42c1e13e826,0x000060fa7ee96fd7}, {0x000ecebebd4dd72b,0x000da060f221194f,0x0000c8d1fff46a4f,0x0009295124a5977c,0x0000705304b8fb00}, {0x000d1d354d296ec6,0x0003e5fad31d8b63,0x0004bd42ecf3c305,0x00053fd670b958cb,0x000021398e0ca163}},
},
{   /* slot=10 [{1,2,3,..,8} * 16^(2*10)] * G) */
    {{0x0005058a382b33f3,0x0000bad48c0b489f,0x00053db36e5ae2ba,0x00032e68f93b503a,0x00005aa3ed9d95a2}, {0x0008aaf9b4b75601,0x000135c8dad72279,0x0001b7a0235eac72,0x0007d4ed2ceaa616,0x00001bbfb284e98f}, {0x000777e9c7d96561,0x0005472c78036656,0x0009506eeecb2b12,0x00057cc65053299d,0x00004a07e14e5e89}},
    {{0x000412cb980df999,0x0006f3c6ec7714ee,0x00025c77fda315d7,0x0003402bba5edde9,0x00003f0bac391d31}, {0x000b58cdc477a49b,0x000de6447f017240,0x0007c86aadfd38da,0x000a08119928d32a,0x000050af7aed84af}, {0x000fde0115f65be5,0x00021216109b26e4,0x000badd6d9299826,0x000d006780205810,0x00001921a316baeb}},
    {{0x00022f7edfb870fc,0x000eb4f76b3bd894,0x0006c24df72c296b,0x000aeb00738f1d43,0x00006458df41e273}, {0x000aad9ad9f3c18b,0x000ef60b1c19cd75,0x00055c0ed9566a0e,0x000c7f53e9a0bac2,0x00007b049deca062}, {0x000be37a35444483,0x000330fedbe93dcc,0x0002c5dd87758879,0x0000e64786004c31,0x00006093dccbc295}},
    {{0x00039a8585e0706d,0x000d8b3e739331ff,0x00018f453b36d0a5,0x000a97c43b9f2e17,0x000057d1ea084827}, {0x000eeebe6084034b,0x000b6780fb8546bd,0x00062d06953199c2,0x0007d90973376abb,0x00006e3180c98b64}, {0x000ab6e7a128b071,0x0006d93a88baaee7,0x0002216130a4c159,0x000bd18f7b4de82b,0x0000363e999ddd97}},
    {{0x000843c135ee1fc4,0x0005508e4c8cf96a,0x00058cd330976eb3,0x000052bb42f6801b,0x000048ee9b78693a}, {0x000848dce24baec6,0x00055babcaf602f1,0x000cefe931769b72,0x000b35590cb3c6e3,0x0000231f979bc6f9}, {0x0001de4bcc2af3c6,0x00030fe208d1f5c3,0x00014fb466b04bb0,0x0002413b78d7009c,0x0000079bfa9b0879}},
    {{0x00003a51da300df4,0x000233da95ab0e39,0x000b356480843964,0x0007194ed3cf12d0,0x0000038c77f68481}, {0x0009ed80a2d54245,0x0007877f63952f3c,0x00010854750aa08b,0x000636bd76dac63d,0x00001ef4fb159470}, {0x000e5ee65b167bec,0x0004296d0cdc2854,0x000810219959590a,0x000ff5672b2df349,0x0000575ee92a4a0b}},
    {{0x000080908a182fcf,0x000c299489dbdd4c,0x0002f733de30e170,0x000fd0005babd575,0x000043d4e7112cd3}, {0x0006bc450aa4d801,0x00027a533b9d85d4,0x000b8906c2c3af12,0x000581b389e3b262,0x0000200a1e7e382f}, {0x000db967eaf93ac5,0x0009b056652c0518,0x00067197f571bc98,0x0004e38fe2b85d95,0x0000050eca52651e}},
    {{0x00031ade453f0c9c,0x0005eff703b9bc34,0x000d847b3de9f504,0x000f4c6fcd97ac9e,0x00004b0ee6c21c58}, {0x000c397660e668ea,0x000fe153ab49797a,0x0004eca79f9b19bb,0x000ae574cb179b53,0x00006151c09fa131}, {0x00055c0dfdf05d96,0x000e02ab4ee7a3af,0x0002171709dd262e,0x000030b11b2bb871,0x00001fef24fa800f}},
},
{   /* slot=11 [{1,2,3,..,8} * 16^(2*11)] * G) */
    {{0x000653fb1aa73196,0x000303fd7641837d,0x000b3a17b20f9495,0x000613ead200b09f,0x0000544d49292fc8}, {0x0002aff530976b86,0x00006c2d2460422d,0x000de5bae58d90b8,0x0000c17dca1896c4,0x000028005fe6c834}, {0x000fba9f34528688,0x0009425107da16ae,0x0006d94b365c1bff,0x0006dfaf75bbbcd6,0x000072e472930f31}},
    {{0x0005208c9781084f,0x0000b23450ee1269,0x0003efde02b1502a,0x000a34cfd9daea60,0x00005a9d2e8c2733}, {0x0003f635d32a7627,0x000865f6566f007f,0x0008d044507aaa4d,0x00064383c85e7972,0x00001fee7f000fe0}, {0x000305da03dbf7e5,0x000491434cdbd765,0x00024a88eca4daf2,0x00005437b4ad5cdd,0x000000f94051ee04}},
    {{0x00056b23c3d330b2,0x0009bb0471b068d3,0x000e42b83cf21c8b,0x000b10db36c316c6,0x000007d79c7e8bea}, {0x000f93bb07af9753,0x000cf3db766a7d7e,0x000e0b1ec5583ed0,0x0000452ce6998bf6,0x000047b7ffd25dd4}, {0x000bfb9cbc08dd12,0x0003ae1eec29b87f,0x000b1fc1bf8a066b,0x0004bb60d57242bd,0x00001c3520a35ea6}},
    {{0x000253a6bccba34a,0x000a13838219b80d,0x000882e3963e61c3,0x000e66f90c3b6019,0x00001c3d05775d0e}, {0x00086f40216bc059,0x0001d12bcd87ecda,0x0007c709901fbb23,0x0002e55b4956a9e1,0x000038750c3b66d1}, {0x000ef1409422e51a,0x0003c2b5df671692,0x00044ce029cbc0c7,0x000487c21014fe77,0x00000621e2c7d330}},
    {{0x000860cc8259838d,0x000c1c69f9adcaf9,0x0005581e3090ea48,0x000a5bc652648376,0x00000007d6097bd3}, {0x000e1796b0dbf0f3,0x000b9e17ce196b7a,0x0009aaa3b454dfaf,0x0002e9d25923071e,0x00005d8e589ca100}, {0x000f1d950842a94b,0x00063588f2e3ec0b,0x000b51e2efb2d3c3,0x000bf860a961438b,0x00001583d7783c1c}},
    {{0x000ea2ef5da27ae1,0x0001455670174ece,0x000609167a597c3a,0x0008f70c9a62a126,0x0000252a5f2e81ed}, {0x00034704cc9d28c7,0x0009ef72cc58f900,0x000e5b87261d1b67,0x000580a16e12b5fb,0x00004958064e83c5}, {0x000894265066e80d,0x00085307c8c6b0d2,0x000c1112fdfcc3f7,0x000b3881b53da780,0x0000079c170bd843}},
    {{0x0006ece464fa6fff,0x0001e6205e523050,0x0001b8ea42bee343,0x000fb00357942245,0x00006dec05e34ac9}, {0x0006cd50c0d5d056,0x0006dbb03573bcdd,0x0003c3ef489af768,0x0008acc3ca6723ff,0x00006768c0d7317b}, {0x000625e5f155c1b3,0x000a7997b7b9194b,0x000d6b2600417bf3,0x00052f4c22cbddc6,0x000051445e14ddcd}},
    {{0x00002b4b3b144951,0x0006b444bbcb3575,0x00066385db8e67ff,0x00095c8b8bd69271,0x000013186f31e392}, {0x000147ab2bbea455,0x0004f92079129893,0x000e30f7a78c53a2,0x000d43d4b49f948b,0x000012e990086e4f}, {0x000c96b37fdfbb2e,0x0005e121ceaf9f10,0x000a5b983f9f9a93,0x00099afdf1136c43,0x000077b2e3f05d3e}},
},
{   /* slot=12 [{1,2,3,..,8} * 16^(2*12)] * G) */
    {{0x000fa9c59c2ec4de,0x000bf4f84f3cb296,0x0007a8f908bc8b61,0x000255d1c7706d91,0x000063b795fc7ad3}, {0x0008639c12ddb0a4,0x00030c024866bd59,0x0008fce460a5d19f,0x0005e8ad17c2f035,0x000007a195152e09}, {0x00068f02389e5fc8,0x00002cf8de43ba83,0x000541264390433b,0x0000137afa1fd5dc,0x00003e8fe83d032f}},
    {{0x000b15b90570a294,0x00070670845492f8,0x0001bbfd8494f242,0x0004007de1c5ae16,0x000075ba3b797fac}, {0x00004c8de8efd13c,0x0008e33e03731087,0x000260cde3dfc51a,0x0008c86a59d5da51,0x000022d60899a625}, {0x0009dbc070cdd196,0x0008b6c7d8a9a623,0x000b40126060fe8a,0x0009e5eb38847bce,0x00000904d07b8777}},
    {{0x000e1fd4ddba919c,0x0003ec74c8daab4c,0x000d86cc51cf31db,0x000de072c63cc63a,0x000043e2143fbc1d}, {0x00022d6648f940b9,0x0000cbd2d0c39f43,0x000081f93106952f,0x0002a6c167697ada,0x00006240aacebaf7}, {0x0004749c5ba295a0,0x0005bca37d25af83,0x0007c9316ad6947c,0x0000cac66f13ba7e,0x000056bdaf238db4}},
    {{0x000ab9e3f53533eb,0x000d56eb93d40362,0x000d5a5572338568,0x00013189e0e14521,0x00001d24a86d8374}, {0x0000d36cc19d3bb2,0x000b7622386b9131,0x0007a14f5c062a6b,0x00057547c9b8591d,0x000003aa31507e1e}, {0x000c7648ffd4ce1f,0x000f054ac8c1cf4e,0x000d09357ce045ea,0x000485988d225821,0x000043b261dc9aeb}},
    {{0x000b1e1988bb79bb,0x0007dc17a359de55,0x00003dea33a09ed0,0x0006bc2b02c2ee26,0x0000326055cf5b27}, {0x00013d8b6c951364,0x00026000bf47b195,0x00054f956794fe71,0x0000964028d10ddd,0x000002b4d5e24294}, {0x000155cb28d18df2,0x00046186ce508b4a,0x000c824389eacc46,0x0003410c49cf4936,0x000027a6c809ae5d}},
    {{0x0006ebcd1f0db188,0x0003a675a5be88ba,0x0005f5585a37d3d7,0x000a17ef22edfa31,0x00002cb67174ff60}, {0x000c270ac43d6954,0x000576a66cab2cd2,0x0009d7036cdd4a3e,0x000259979fa59246,0x0000221503603d8c}, {0x000ecdf9390be1d0,0x00044728ce3f159e,0x000a94f0f4a94220,0x000f43682891c667,0x00007b1df4b73890}},
    {{0x0002f2e0b3b2a224,0x000062b551160e49,0x000d7f7b0e7c6c9e,0x000599215eb8fe20,0x000061fcef2658fc}, {0x000e221807f8f58c,0x0009fd49409d45f2,0x000fb6a630e3555c,0x000e03db2aaa88d1,0x000068698245d352}, {0x00015d852a18187a,0x000d386ddacd7dbb,0x000ff6c482f3e4aa,0x00001cf44bae2810,0x000046cf4c473daf}},
    {{0x000525ed9ec4e5f9,0x0000116903303426,0x000be5cadc0e5eda,0x0005f4072b1a7f2c,0x000029387bcd14eb}, {0x000c6ea7f1498140,0x000f8392b4854213,0x000629ceba7c1e7e,0x000c5bb2488c38c5,0x00001065aae50d8c}, {0x000c4525df200d57,0x000d6bfca674a1c2,0x00018340305c3b2d,0x000e7160a07e7b1e,0x000069a198e64f1c}},
},
{   /* slot=13 [{1,2,3,..,8} * 16^(2*13)] * G) */
    {{0x0002b2e0d91a78bc,0x0009cc8509667906,0x00005070b847c988,0x000a1bf9df54a664,0x00007369e6a92493}, {0x00014434dcc5caed,0x000963c84fb33e10,0x000d86a0e747ed5d,0x000f9e470019576e,0x000025b2697bd267}, {0x00073ffb13986864,0x000d9415dc7b89d6,0x000f273b5e3ca5fb,0x0004cd2e04ecc3bd,0x00001420683db54e}},
    {{0x0008bd1e249dd197,0x000005e58c102b47,0x000cbaac5c620c35,0x000a72dfb02d32fc,0x000060b63bebf508}, {0x000ebb6fc1cc5ad0,0x000e99646ac8b34e,0x00066bde536a1b0c,0x00081c1d3b0da49a,0x000031e83b4161d0}, {0x0008c7129e062b4f,0x0004f29320ad897e,0x000f18683f49e48f,0x00003175bece14b6,0x000055cf1eb62d55}},
    {{0x0009101065c23d58,0x0006d5094819c587,0x0002c55fa78b9d08,0x00091d4e2402fa91,0x0000669a65645708}, {0x0006b5e37df58c52,0x000dde799cc36307,0x000913ee20d73ab9,0x0000133bd831ce34,0x00001a56fbaa62ba}, {0x000e6b505c9dc9ec,0x000bba77c371a943,0x0001347651302557,0x0008a5c9873ae564,0x000013c4836799c5}},
    {{0x000a5d465ab3e1b9,0x00087c7f13f61423,0x000cb5b9b6fc13c1,0x000b60719f83664e,0x000066f80c93a637}, {0x000cfb6a5d8bd080,0x000ec571a4842c4d,0x0008e55365deebc4,0x000b827d4b2e883b,0x000050bdc87dc8e5}, {0x000d37836edfe111,0x00015f011abd9606,0x0005b73b9632353e,0x000d5ae64b03ac32,0x00001dd56444725f}},
    {{0x00047ff83362127d,0x000c471cd7c158fa,0x0009220c8bbc9f6a,0x000732e6e7145434,0x00000e645912219f}, {0x0007e60008bac89a,0x00011eae1c3e0c29,0x000fe7977c7d4cea,0x00005cdf3e38be19,0x00003a3a450f63a3}, {0x000f2f31d8394627,0x00083de94a510078,0x0007996f80389d31,0x000a87bd1e36c6d1,0x0000318c8d9393a9}},
    {{0x00045d032afffe19,0x000497f24db66f27,0x000a8598ef0c9f3c,0x0005314bc98d3e3b,0x0000224c7c679a1d}, {0x00069e29ab1dd398,0x00058342d9e3b5d6,0x00035973cdfc9216,0x0000af655851dfdf,0x0000509a41c32595}, {0x00006edca6f925e9,0x000f4641b1f33bdc,0x000d833e89793ef3,0x000138982ec12809,0x000005bff02328a1}},
    {{0x0002137023cae00b,0x0000ad1accf59363,0x00021a1c88544acf,0x00044a796741049d,0x0000780b8cc3fa2a}, {0x0001a0dd0dc512e4,0x000c844a5fafe688,0x000f4a52404fe70d,0x000a3ea1f748e6b8,0x0000576277cdee01}, {0x00038abc234f305f,0x000bd1405de081ef,0x0004e62a0d9a577f,0x000b7a15e82a5143,0x00005ff418726271}},
    {{0x000e080c1789db9d,0x00025f3e778f5398,0x0006bd035da76020,0x00066befa98894c0,0x0000106a03dc25a9}, {0x000b47e813b69540,0x0003b432610e1e5d,0x0008781276f35d2a,0x000cb69ac1f26e93,0x000029d4db8ca0a0}, {0x000d0aaf333353d0,0x000a5acd309e5d9a,0x000888f7f038669d,0x000befa3c57658ac,0x00004ab38a51052c}},
},
{   /* slot=14 [{1,2,3,..,8} * 16^(2*14)] * G) */
    {{0x000c2b256768d593,0x000574422ca13da7,0x000a0ace1d98c1c0,0x000a690f1a80bd5c,0x000029cdd1adc088}, {0x000fd1ef5fddc09c,0x000fdf7575dced6c,0x00001634c2e82b3e,0x0002b9b25d56b5d2,0x00003041c6bb04ed}, {0x0002f2f9d956e148,0x000759f356b2e0ff,0x000f6c025cade797,0x0009a7b1a4698bb5,0x0000104bbd681404}},
    {{0x0000fd3168f1ed67,0x000cdd86f3bc251f,0x0004d2f2de2c811d,0x000714944dc5c430,0x00005be8cc57092a}, {0x000d9a5fd67ff163,0x0009d4cc75681a95,0x000e20f257e92be6,0x0002df5b7f8024cd,0x0000204f2a20fb07}, {0x00043b3d30ebb079,0x0005abd652e30c81,0x000f6d5c31758915,0x000161f653c3c318,0x00002570fb17c279}},
    {{0x000a367f2cb61575,0x000761cd6026c3ef,0x0005b52562f5f96f,0x0000acde8c7142a6,0x00003dcb65ea5303}, {0x000ea9550bb8245a,0x000a88f9050d1192,0x0008a4c935c8e6fb,0x00086687986ea2d8,0x0000241c5f91de01}, {0x0008172940de6caa,0x000f022d9733a28d,0x00035b01d18fbf2c,0x000f0e516d7fcdd2,0x000008420edd5fcd}},
    {{0x000f20ab8362fa4a,0x000d4e21a3e6ecdf,0x000c39e62b57e118,0x00069fde3179617f,0x00000d9a53efbc17}, {0x0008c34e04f410ce,0x0005a276e0685035,0x000bb91521b6135b,0x000889c5d9670c7e,0x000004d654f321db}, {0x000dc116ddbdb5d5,0x000b68da5dd2d5e7,0x000334a2922954de,0x0001ad71cb608173,0x00004a7a4f261899}},
    {{0x000718025fb15f95,0x000346b5c1b8ff4a,0x0000e011123df65f,0x0001848cdfcf0850,0x000011b50c4cddd3}, {0x0003b291af372a4b,0x00070718147f224c,0x0006899ef293da82,0x000ee33dd8485648,0x00004a96314223e0}, {0x0008274408a4ffd6,0x0007e9c1576d9a6e,0x000d02b3f2738e17,0x000cc51773348b63,0x00004f4bce4dce6b}},
    {{0x000fce5ae2242584,0x0005692f58a9ea71,0x000cea3cf426ea72,0x00001e6d21a09d71,0x000073fcdd14b71c}, {0x0002616ec49d0b6f,0x0008fcaec231730e,0x00026b4fa6e45671,0x0005f3748eb409bf,0x00003042cee56159}, {0x000e7079449bac41,0x0006dbce2310a427,0x000f841a7c855ae3,0x000e1d64cae76215,0x0000389e740c9a9c}},
    {{0x000cb3ae34dcb9ce,0x00023e348d0ad64f,0x0002c6381b975003,0x000678845b3f07d6,0x000061545379465a}, {0x000d78f6570eac28,0x0003227919ce1c9b,0x00019b91ede55b0b,0x000369065fc3eaba,0x000025c425e5d626}, {0x000e06a6f1d7de6e,0x000278e0623083f3,0x000e8a6c773ef976,0x00047598c14f6264,0x00006539a0891548}},
    {{0x00021f74c3d2f773,0x0004125c46845e9d,0x0009b99e33c15054,0x000186c624e5ce8f,0x000011c5e4aac5cd}, {0x0004dbd414bb4a19,0x0003c98424f8eddc,0x0006ca716919b2bc,0x000bd9048a89fd73,0x00000f65320ef019}, {0x0006d1b1cafde0c6,0x000e3163b5181d48,0x000af2939a4f3fe6,0x000072a59a8af0df,0x00004cabc7bdec33}},
},
{   /* slot=15 [{1,2,3,..,8} * 16^(2*15)] * G) */
    {{0x000e9624089c0a2e,0x000c03afe4738239,0x00064fa12ac748c4,0x000858217dbed2a7,0x0000639b93f0321c}, {0x000f788f3f78d289,0x0002ca1404d9fc08,0x000f65cc9dfe30a7,0x0002021f2778bfcc,0x00007ee498165acb}, {0x000508e39111a1c3,0x000d4809074897bd,0x000e72fd192b2b90,0x00002a6e7d2aec2a,0x00000edf493c85b6}},
    {{0x000c8158599b5a68,0x0000febade20eaec,0x0002b67f07ea574f,0x0004fb44fe41d742,0x0000403b92e3019d}, {0x0007c4d284764113,0x0003ff7f5f835676,0x000ae6bedea09040,0x000a3691c8fcffac,0x000004c00c54d1df}, {0x00022f818b465cf8,0x0005a1480eff84dc,0x0004c7d65771a0f3,0x00076f4aee8bfad0,0x0000355bb12ab261}},
    {{0x000e64cc7493bbf4,0x000d9eca3b0c3a71,0x000a05e785e5bd84,0x000c3120a6bc50cf,0x00000f9b8132182e}, {0x0001dac75a8c7318,0x0009db3ceaa11a30,0x000bae3f2ded9003,0x000ad8e6f077cbf3,0x00007518eaf8e052}, {0x000859c41b7f6c32,0x000bcf4383298a48,0x0009b1d1d90f2d60,0x00055c41815a929c,0x000047c3871bbb17}},
    {{0x0004539771ec4f48,0x0007dc98c5d6e514,0x0007c3c66bf805b1,0x00099dcf762c11a4,0x000000b89b857646}, {0x00065d50c85066b0,0x000b0b3a299b0fbe,0x00041ae8e062ecc4,0x0008d5fe53754ea4,0x000008fea02ce8d4}, {0x000ddd7668deead0,0x000204b685d23824,0x000d89d665c86445,0x000d537b514cfcd5,0x0000473829a74f75}},
    {{0x0002da754679c418,0x000d8b2618df082d,0x000c47eb0ae63bd7,0x000c6b4355eef24a,0x00002078684c4833}, {0x0009533aad3902c9,0x000ceef03588f23d,0x000fe12fb464c2dd,0x000d39015257390c,0x00006c668b4d44e4}, {0x0008cf217a78820c,0x000b281273e973b4,0x000c8eed7bf76a0a,0x000433fa96c65a78,0x00007411a6054f8a}},
    {{0x00059d32b99dc86d,0x00075603af1154d6,0x000cc2e488044cdc,0x00034ffb34c712cd,0x00007c136574fb81}, {0x000ae53d18b175b4,0x00059f392a102579,0x000eef35f5687131,0x000398f8455ecba1,0x00001ec9a872458c}, {0x0006a4d400a2509b,0x000020bc882b4b8e,0x00019575619b81d7,0x000646057e7cc9bf,0x00003add88a5c7cd}},
    {{0x00095770b635dcf2,0x0006cf66c1fbcab8,0x000eb6d18702dfef,0x0009e7485530268b,0x0000249929fccc87}, {0x000298d459393046,0x000985ff659ec85c,0x0002f66e3a8f7e35,0x000a7201d2ca22af,0x000061ba1131a406}, {0x0000a0f116959029,0x0006cba7ebd89a3d,0x0006783307023b6b,0x000ece77bf15a3e2,0x00005620310cbbd8}},
    {{0x000993434934d643,0x00006a51222f5528,0x0003f41c22b9dbf8,0x00097308f6d878fc,0x000037676a2a4d9d}, {0x0006b5f477e285d6,0x000676c8f6193664,0x000bb594dd40e8ff,0x000ec4da6ec7311a,0x00007ec846f3658c}, {0x000e8f3f1da22ec7,0x000776c01cd139b5,0x0002989fb8130f1d,0x0009dd5214c8fcfa,0x00006daaf723399b}},
},
{   /* slot=16 [{1,2,3,..,8} * 16^(2*16)] * G) */
    {{0x000a7562eb3dbe47,0x000548ebda0b85f3,0x0005747299f7ea38,0x000d55100c3e5314,0x00001304e9e71627}, {0x000b04bfacad8ea2,0x000e8148be884583,0x000810c5db29b743,0x000bbaa2b1e583b0,0x00002b5449e58eb3}, {0x000814d26adc9cfe,0x0003f8b48dd0b789,0x000979c60a3c1bab,0x000d693da0fe1fff,0x00004468de2d7c2d}},
    {{0x000b355e9419469e,0x0004c23ddc75451b,0x00047f996233e6dc,0x000bd6393a5b6d64,0x00006cce7c6ffb44}, {0x000ad8c6f86307ce,0x00031435d0c284b9,0x00057a772c211135,0x0007352d4a866c56,0x00005da6427e6324}, {0x0004c688deac22ca,0x000f7bbae1ff81a9,0x000d59580fb9066e,0x0002ca888ad8c388,0x000058f29abfe79f}},
    {{0x000ecfab8de73e68,0x0009f377e76a5e90,0x000e01598254036f,0x0001e36f0495b0bb,0x0000577629c4a7f4}, {0x000a64bf710ecdf6,0x00038462c293c4b5,0x00050b3ab9b14ce5,0x00048703643d056d,0x00006af93724185b}, {0x0000024509c6a888,0x000134b558973322,0x000c33289fd2e036,0x000c18f83e236233,0x0000701f25bb0cae}},
    {{0x0008b0f8e4616ced,0x0000e9e25a87dc3a,0x0004bca59cf70066,0x0000be961e3061ff,0x00002e0c92bfbdc4}, {0x0008f6d97cbec113,0x000e674bfdbe49d1,0x000c4e60d6844a06,0x0005e5120f5b522a,0x0000720a5bc05095}, {0x000f09439b805a35,0x000376242abfc0c3,0x000c229346e84e8b,0x000f0ec691417f35,0x00000e9b9cbb144e}},
    {{0x000ad48ffb5720ad,0x0006bdbf90d0efbb,0x00035543bfee8191,0x0007bd8d48131526,0x0000221104eb3f33}, {0x000e9bd55db1beee,0x000370a723fb98de,0x000c68d791c9c3ab,0x0003cde44a8f1bf1,0x0000366d44191cfd}, {0x000c1743f2bc8c14,0x000fcb5856c3b9e3,0x0008a7fb972eda26,0x0003244ccb82f0e6,0x00004167a4e6bc59}},
    {{0x000b9d2876f62700,0x000400e7668eb643,0x0001fc06845d1d9d,0x000246a1b4b43032,0x00007938bb7e2255}, {0x000e2665f8ce8fee,0x00014e880d62cc2b,0x000f364eeee967ff,0x000d2f6f12e6e7e2,0x000034b33370cb7e}, {0x000591ee8681d6cc,0x0009ced85a753cdc,0x0008808883ce0210,0x00065e4ed7485c15,0x00001176fc6e2dfe}},
    {{0x000f6cd05b9c619b,0x000f4b2a58480b4a,0x000be94dc42ddfc9,0x0005f343d4fa502e,0x000008fc3a4c677d}, {0x0000e28949770eb8,0x0002aacf440a3db9,0x000ed7879b98fbcc,0x00006b621354ffed,0x00001f6a3e54f269}, {0x0004c199d30734ea,0x000b631165cd660a,0x000759829540c085,0x00000d1e2333e23f,0x00004f2fad0116b9}},
    {{0x000eb24194ae4e54,0x000511857ef6c44b,0x00068d04985f541c,0x000f7aba61e6b2d3,0x0000445484a4972e}, {0x000cd91db73bb638,0x000aafc129c08962,0x0003b61689e60577,0x000ee816f619b39f,0x00003451995f2944}, {0x0002fcd09fea7d7c,0x00094b0935cf6915,0x0007285c404a816c,0x00093b7258e9aaa4,0x000010b89ca60428}},
},
{   /* slot=17 [{1,2,3,..,8} * 16^(2*17)] * G) */
    {{0x000947499718289c,0x000c524533f263d5,0x0004c3ef1512ebf8,0x000518e0262bfcb1,0x000020b878d577b7}, {0x000941be5a45f06e,0x000ed6d9c5f65753,0x0002ff51b6d07cae,0x0004da911776b9c7,0x000017d2d1d9ef0d}, {0x0002af18073f3e6a,0x00019d752106927f,0x000ca60022fd3fe5,0x000c6a722e3b72c3,0x000072214f63cc65}},
    {{0x00037f405307a693,0x000d72f336795b4e,0x0003761099aba714,0x000cbc9d6fbd0a77,0x00005fdf48c58171}, {0x000db7b9f43b29c9,0x0004a4f518f751d9,0x00012f9dc4d60582,0x00045b0f2c072bd3,0x00001f24ac855a15}, {0x000608328e9505aa,0x000d10c1420ee24d,0x0006fb25a24748c1,0x00095e6c7ffe45c0,0x000000ba739e2ae3}},
    {{0x000e98de5c8790d6,0x000d345c2a2df592,0x0009b49922e5bfb7,0x00078f3115a3b60f,0x000003283a3e67ad}, {0x000426f5ea88bb26,0x000d984973bfbae4,0x0006694e50360679,0x000d2265c9f030c2,0x000072297de7d518}, {0x00041dc7be0cb939,0x0004d8b633080482,0x000228930832f19b,0x0001945d3dfc90d0,0x000005e129684627}},
    {{0x0002eeb32d9c495a,0x000fcf12bb97cba8,0x0003b5d1e0ceefc8,0x0008d9bb02dabae9,0x000039c00c9c1369}, {0x000fbbc8242c4550,0x000ecd03081d9adb,0x0005c8df92bcc80c,0x000ce4c843566a6f,0x000078cf25d38258}, {0x000e6b8e31489d68,0x000ab9c2bf08715a,0x00004efa05aa851c,0x000f832c9a75a97f,0x0000006b52076b3f}},
    {{0x0000cfe19d95781c,0x00018966310e229e,0x0000516b39b681df,0x000612257df39d37,0x00004d57e3443bc7}, {0x000b7e16b9ce082d,0x0004c417abc29f5c,0x000bf4a7ab3407f1,0x00075ced4b36bce2,0x00007de2e9561a9f}, {0x0000d4f4b6a55ecb,0x0007f5d85db99de7,0x0003ee9a81480152,0x00029eddbc9c440d,0x00006b2a90af1a60}},
    {{0x0003f4fc9ae61e97,0x0001de03f5fd1692,0x0006edd12d573528,0x0003e4aa764ae43e,0x00005fd8f4e9d12d}, {0x000bf3245bb2d80a,0x000472fb9079b77e,0x000cee7333d8301b,0x0002109c647e6f24,0x0000465812c8276c}, {0x0003beb22a1062d9,0x000753831dc164d4,0x000e2968d77065fb,0x0006790180d4a7bd,0x000005b32c2b1cb1}},
    {{0x00005eccd24da8fd,0x000ac05dfef83c8c,0x000df9cd61a1cf1a,0x0001e99dbbeeff27,0x00003b5556a37b47}, {0x000ca42c7ad58195,0x0006e4333f3ccf7f,0x00040b979d321428,0x00007e1b6c29d0d3,0x000031771a485673}, {0x0000c524e14dd482,0x000541a2ba4b632b,0x00082b5af3edb351,0x00036eba3d160482,0x00004fc079d27a73}},
    {{0x000938b089bf2f7f,0x0006502dfe9a751c,0x000880e4532497bd,0x0008e92ffffc09c7,0x0000124567cecaf9}, {0x00048b440c86c50d,0x000c9cc94e651dc3,0x00043e3cb91337cb,0x000cd086422f74d6,0x0000241170c2bae3}, {0x0009ab860ac473b4,0x000ee0113e4353ff,0x000bc6c4aff0911d,0x000000d4ae75060e,0x00003f8612966c87}},
},
{   /* slot=18 [{1,2,3,..,8} * 16^(2*18)] * G) */
    {{0x000a0cc9782a0dde,0x000b2ea718385559,0x0001ef238c551dcd,0x000613d7f62865b3,0x0000504aa7767973}, {0x0008fcfa36048d13,0x000b373899ddd9c1,0x000f92d0aa29159d,0x00019d4dc9f350b9,0x000026f57eee878a}, {0x000b2cd55687efb1,0x00062247af17b0ca,0x000f5a24675180d1,0x000306985c15a344,0x00004041943d9dba}},
    {{0x0000eeba43ebcc96,0x0009c26ea9cafc3c,0x000c77ccc68d749c,0x000340fd9fa95ee1,0x00001420a1d97684}, {0x00017743a26caadd,0x00024648ab7ce4b2,0x0003fbc9e347a6b4,0x000d019cb1d4f7a0,0x000012d931429800}, {0x00067799d337594f,0x00040b23aa47b00c,0x00035ff3955e3c51,0x000a01244182854e,0x00001b4f92314359}},
    {{0x000c109d89150951,0x000912de9696a3e5,0x00075f302039cefa,0x0002dae20eae43f9,0x0000239b572a7f13}, {0x000f3030a49866b1,0x000d2215f485933c,0x0001def4f6251f73,0x00023f6ab82aa405,0x00005ff191d56f9a}, {0x000ed433ac2d9068,0x000795fc98523819,0x000593eb3d2883ab,0x00036cbef4572805,0x0000020c526a758f}},
    {{0x000834f89ed8dbbc,0x000f9dc7ca46c779,0x0003e1b074c8f2aa,0x0003877a9524cdca,0x000002aacc461531}, {0x0001ef59f042cc89,0x0009d8e124bb6e93,0x000ec759972c589c,0x000c50cadc8e18aa,0x0000452cfe0a5602}, {0x0000f7a0647877df,0x000270e607c9f86a,0x0001fb11c9bbc464,0x000877bab17ea25f,0x00004cfb7d7b304b}},
    {{0x00043d6cb89b75fe,0x000d99c6adc8072b,0x000ee34c9f54c694,0x0005364b8c3aa373,0x000014b4622b3907}, {0x000699c29789ef12,0x00071df57190de28,0x000cc970d02b6ecd,0x0003ac5c343c857e,0x00005b1d4cbc434d}, {0x000b2615cc0a9f26,0x0002bb88dcce5b6f,0x000369a7053a4f0e,0x0002dd11301498b3,0x00002f98f7125859}},
    {{0x0004a74cb50f9e56,0x000a98e8e13200c9,0x0002300f675b1ff4,0x000aaf99a2acc218,0x00003a6ae249d806}, {0x0002ae444f54a701,0x000f0a9cbd7de2e1,0x0005835de0fcfe3e,0x0004554cebf890d7,0x00001d8062e9e761}, {0x000ada85a9907c5a,0x000b591b90f62657,0x000f34b4e91a0ea8,0x0005ff38d0e1dfbd,0x0000298b8ce8aef2}},
    {{0x00027953eff70cb2,0x0002a791570762a9,0x0000a7cf6a4b89c9,0x000e4859418457a3,0x000034b8a8404d5c}, {0x000a72ea0a2165de,0x000b40bcf79f6837,0x000738ae703fab07,0x000d7dc521636c77,0x00006ba6271803a7}, {0x000eecb583693335,0x000df63b5fefdc26,0x0004b22573d5a813,0x0001c6aa293aa9aa,0x000071d62bdd465e}},
    {{0x0003cc28d378df80,0x000790a0fa4b4653,0x000701da5af6db43,0x0002ba4e3645ff9f,0x000074d5f317f317}, {0x000db5dab1f75ef5,0x000cf16b065f5cd2,0x000f49f085d77f95,0x0002b3d14571fea3,0x00001c333621262b}, {0x000fe55467d9ca81,0x000752b298c37a86,0x0003ac623b398b7c,0x000d98cda6d0892e,0x00004aebcc4547e9}},
},
{   /* slot=19 [{1,2,3,..,8} * 16^(2*19)] * G) */
    {{0x0000071b276d01c9,0x000c586c48c7012f,0x0001d6fba9e7b8ba,0x000b7925308129b7,0x00005d88fbf95a3d}, {0x00008d9e7354b610,0x000535ba85b6e0b4,0x000a58a207806b32,0x000df2cdbe63a034,0x0000173bd9ddc9a1}, {0x00000f1efe5872df,0x0002ed43918c12b5,0x0009673ae058d658,0x000a319e6ed278ec,0x000006e1cd13b19e}},
    {{0x0000ad516f166f23,0x000931fab6abe40d,0x00004d088e118e32,0x00062663fe35e14a,0x00003080603526e1}, {0x000baf629e5b0353,0x00090278d0447472,0x000643bf273baa0b,0x0007b130c785f469,0x00007f3a6a1a8d83}, {0x000644395d3d800b,0x00055c901edf6f7e,0x00092c633995a8d5,0x000307e68cd78305,0x000030d0fded2e51}},
    {{0x00094d1af21233b3,0x0008ef0cc4d9ce05,0x000f499a771bdbe7,0x00098686965187f8,0x00000a9214202c09}, {0x0004971e68b84750,0x000296664bbcf9cb,0x0002fa412ba09572,0x00089d95c8de7267,0x00004615084351c5}, {0x000019c0aeb9a02e,0x0000d16034caebc9,0x00059932ec55c711,0x0005dfe0e6df5016,0x00003bca0d2895ca}},
    {{0x000031bc3c5d62a4,0x0003ecff07a6040f,0x00030fb54519fc8b,0x00013cd98183da21,0x00005631deddae8f}, {0x00088eb69ecc01bf,0x000ada644896f9c6,0x000f7a9fe2f0bc83,0x0008241ca2d955f5,0x00004ea8b4038df2}, {0x000d460af1cad202,0x00005a48cee832ae,0x0009f11a5f463053,0x000a463912177454,0x000024ce0930542c}},
    {{0x000890f5fd06c106,0x000355d8810f21fe,0x000e8caf3eb5c468,0x000d74b827808fe6,0x000041d4e3c28a06}, {0x000fa155fdf30b85,0x0008e36372ea43fc,0x000492f844d2f716,0x0004280b2e064de6,0x0000549928a7324f}, {0x000e32a763ee1a2e,0x000b7d25ffdeaf26,0x00017f4d69ae91e4,0x000ff6abc3bd33bd,0x0000491b66dec0dc}},
    {{0x0005b13dc7ea32a7,0x000cc7e16db9898f,0x000bf8d947e3d5f8,0x000e4acac0abf52c,0x000008f338d0c85e}, {0x00004a8ed0da64a1,0x000af67e2284b75f,0x000f7b7ba4ed222c,0x0008b678234a3791,0x00004cf6b8b0b701}, {0x0003a821991a73bd,0x00001df320c7ac38,0x0004777063ab27bc,0x0008a99c13d331b8,0x0000530d4a82eb07}},
    {{0x000c3630e1f94825,0x000268cab535a004,0x000c84ff8b7e2d78,0x00070b9c7482323c,0x000065ea753f1017}, {0x000973456c9abf9e,0x000fc4900a8806d6,0x0008cfb850257fb2,0x000bd5b2bacf412c,0x00000db3e7e00cbf}, {0x0006fc3ee2096363,0x0007f61b5cb6b3d6,0x0003443b1a81d62c,0x000a1db0fbe04421,0x000002a4ec1921e1}},
    {{0x0006259a3b24b8a2,0x000cc45afa0b85ce,0x000ba07037b8577a,0x00009bfcccbe6e88,0x00003d143c511278}, {0x00086162f1cf795f,0x0001926ee57f2f5c,0x000c063578118c86,0x0007fcf172124851,0x000036d12b5dec06}, {0x000d279179154557,0x0005cfc783a0a126,0x000f179bacd5e48f,0x000285936bdb6e8d,0x00002ef517885ba8}},
},
{   /* slot=20 [{1,2,3,..,8} * 16^(2*20)] * G) */
    {{0x0007974e8c58aedc,0x000fbabf041a4463,0x000980718ab9ef22,0x000a8a6e185d956e,0x00002f1b78fab143}, {0x000ebffb305b2f51,0x000ad889596b896e,0x0006d5dd25d3f938,0x0000095f0f52dc74,0x000057968290bb3a}, {0x000ab8430a20e101,0x0008d24f0ec47f71,0x000ee2eed1f39365,0x000a3e1cf7509a86,0x00007dc43e35dc2a}},
    {{0x00066665887dd9c3,0x000314bb05355859,0x000f2079b1c90f9b,0x000c12fc6e08df8e,0x00007ef72016758c}, {0x00082a5c273e9718,0x000995e4efd945a7,0x000f237d3e3576c6,0x0000a990f2ed8051,0x0000044fb81d82d5}, {0x000f18c5a907e3d9,0x0001dce4c6359c1d,0x000201bb4957b337,0x000dd2eca704534b,0x00007f79823f9c30}},
    {{0x0004d239a3b513e8,0x000d4b91fa8d8833,0x000590bd33c13670,0x000d9b412b54136f,0x00000a4e0373d784}, {0x000c1ff068f587ba,0x0004e0050c8de6a9,0x000ded5be7082789,0x000d6f03cbf99557,0x000064a9b0431c06}, {0x0003d6a15b7d2919,0x000a0d53a82352eb,0x0009a45d47b0b4f6,0x000346c7156ce438,0x0000071a7d0ace18}},
    {{0x00072daac887ba0b,0x00005bfa562eed30,0x0000ef768b012629,0x0007e9ccf543002c,0x00002c3bcc7146ea}, {0x000c355220e14431,0x0000709b15141cc0,0x00009d5f360d6595,0x00055d39af5621b2,0x00007c69bcf76177}, {0x0000d7eb04e8295f,0x000252f50f37d07f,0x00071798d710db18,0x000a51de951a9a31,0x00006f5a9a7322ac}},
    {{0x0001000c2f41c6c5,0x000c10cfefb9b8ba,0x000cc51c9fc49f79,0x000afca4efa47703,0x0000494e21a2e147}, {0x0009d4eba3d944be,0x000408078af9ee72,0x0007869c038d9e09,0x0003b244525567a4,0x000002ab9680ee8d}, {0x00048a85dde50d9a,0x0004e0fb9a249efa,0x00091ef6d9219a22,0x000bb34fa091f1dd,0x00006b5d76cbea46}},
    {{0x0007556cec0cd994,0x0006f5cd01dba885,0x000f42b4776472dc,0x0007354af0169148,0x00000ae333f68527}, {0x000941171e782522,0x00074036936d3e0f,0x0000fcc746f1e6ae,0x000313e408b3ea2d,0x000016fb869c03dd}, {0x000e199733b60962,0x000b4d8abe133288,0x000991d03e24fc72,0x000d0754811f7ed0,0x00003f81e38b8f70}},
    {{0x00010fcc7ed9affe,0x000a12465874b7f9,0x000b0c4704545cb8,0x0000993a8397ed24,0x000050510fc104f5}, {0x000b7f355f17c824,0x000c3d74299a40ad,0x000bf8eaf774b923,0x000dc3dd57c3e8bc,0x00000ad3e2d34cde}, {0x000c0fc5336e249d,0x00019c331cfd96f0,0x0009eefe1c745ede,0x0001ebef2d6fd000,0x0000127c158bf0fa}},
    {{0x00097c422e9879a2,0x000d452ca3647f61,0x000b4eaccba44add,0x0004f689b413fc14,0x0000354ef87d07ef}, {0x00028fc4ae51b974,0x000d3744dfe96dea,0x00073848a81d9973,0x000df956240680b8,0x00004ed82479d167}, {0x0003b52260c5d975,0x000fceb41b0b8fee,0x0009f6653c50352e,0x000236d8808ac30a,0x0000302d92d20539}},
},
{   /* slot=21  [{1,2,3,..,8} * 16^(2*21)] * G) */
    {{0x0003c1a2bca4283d,0x00091a1863dd9781,0x000268fa86ed62f0,0x000ae4caec7bcb8c,0x000010e5d3b76f1c}, {0x000c6fb6e4e0f177,0x00029a4bd6a932db,0x00087af6e804e1bf,0x000d0605e1966d47,0x00000edc5f5eb426}, {0x0003bfd653da8e67,0x000ec24a9f641545,0x0003578a23e9dc1e,0x000ba72bf87263b0,0x000045b46c51361c}},
    {{0x00002abf314f7fa1,0x000dc8e8cf450a94,0x0003a8be84e257f1,0x000713b1dbbd54b2,0x00002177bfa36dcb}, {0x000d4ddd8a7fe3e4,0x0005676620e30ce9,0x00030e9958ab1364,0x00029df4b594f7bb,0x00005c1c0aef3212}, {0x00081bbcfa79db8f,0x0001ec25f59b3370,0x000c832487604881,0x000b5bb087a76659,0x00004ae619387d8a}},
    {{0x000bf6aa5344a32e,0x000b4b41b40788dd,0x000a130d607d88ea,0x0003e035eb0eb974,0x00001a00d91b17bf}, {0x00017e44985bfb83,0x0002a71963136611,0x000425904bfce046,0x0003d6483ac3448d,0x000075685abe5ba4}, {0x00060933eb61f2b2,0x000a8c9ff49526e9,0x000af66569543d0f,0x000e6aadf7275107,0x0000135529b623b0}},
    {{0x0000dbd7add1d518,0x00088cfc11f1118f,0x000114759b979f78,0x0003a018732e1f07,0x000079b5b81a65ca}, {0x000716bce22e83fe,0x00019e80985c1f5c,0x0004254aaeb42beb,0x000a613ec9da6371,0x00005972ea051590}, {0x0004ac20dc8f7811,0x00094ac4d4fa80fd,0x00033604349a9ad2,0x0003bdbc01b2d64b,0x00004f7e9c95905f}},
    {{0x00074bbc5781302e,0x0003989addc0f626,0x0003fbd9c6d8520f,0x0008e4c8c2999ae5,0x000031993ad92e63}, {0x0008443d355299fe,0x0001cdbebead771c,0x0001a494668bcd3b,0x000adc88092499ef,0x00001942eec4a144}, {0x000c5319ae234992,0x000910cea3e927da,0x00053c11222c1b3d,0x000ca75553ce4942,0x00002a0a65314ef9}},
    {{0x0007937ff7f927c2,0x0000617d0a6352db,0x000155af76db741f,0x0002ded5982f3a21,0x00004cf6e218647c}, {0x00061acd3c1c793a,0x000ac5a35bc3bcf3,0x0008cda6ab2f9ebc,0x0001a1360e860e9a,0x0000055dc39b6dea}, {0x0009227cc28d5bb6,0x000bc774dffabb11,0x0004a32c8907e24e,0x00024b6a83c78cee,0x0000121a307710aa}},
    {{0x000b5d5e9f034a97,0x000093034bc2de4d,0x000551d3b1e153fc,0x000e52d460546919,0x0000333fc76c7a40}, {0x0009713ec77483c9,0x00077b82b96afd65,0x000097bcd388bfe0,0x0003a9b289e28231,0x0000527bb94a6ced}, {0x000d992a995b482e,0x0007c6e383801563,0x000f64d8e53405d0,0x000a9f7485035de2,0x00006b89069b20a7}},
    {{0x000aa0416270220d,0x000faf9245b4e812,0x000072ef05995a89,0x000eb73ffadc4ce5,0x000023bc2103aa73}, {0x0002fa8cb5c7db77,0x000f8c734c155408,0x0006e7a57e068686,0x0009bcf29e6c8d9f,0x00000473d308a763}, {0x000e792603589e05,0x0001246dcc492cae,0x000601a94f2b4b42,0x000341a02a1ef74e,0x0000102f73bfde04}},
},
{   /* slot=22  [{1,2,3,..,8} * 16^(2*22)] * G) */
    {{0x0008b9ab7f5745c6,0x000ee5787c690eb1,0x000df7afa9023a8a,0x000013db72712da2,0x000036597d25ea5c}, {0x0004dae0b5511c9a,0x000292bffff06a2b,0x00055042347ac860,0x000a12d981f375df,0x00003f6bd725da4e}, {0x000d8d7b106058ac,0x0009e6fc6905f734,0x000202932dd94057,0x000d6d06466f8f99,0x00007b7ecc19da60}},
    {{0x0002373c695c690d,0x000660642906e78c,0x000ae12bd2dd252e,0x0003956951d44444,0x00004235ad760174}, {0x000e4a51a77cfa9b,0x00054e7a386506da,0x000f2d82db822636,0x000caba09bbffcd8,0x000003bedc661bf5}, {0x0008cb0d078975f5,0x000549189f298625,0x0002e36ee4492942,0x00066a1a0cab423e,0x00000e7ce2b0cdf0}},
    {{0x0004643ac48c85a3,0x000f43c6139adc49,0x000ae94d48fd361d,0x000674a09db17dd3,0x0000666e0a5d8fb4}, {0x0006fedfd94b70f9,0x00051c1fcba2dfea,0x000f2fab89f130c0,0x000eeb54882d47e7,0x0000615256138aec}, {0x000bf64e4870cb0d,0x000f0aa458b6b2ab,0x0005e8985dcd65bc,0x000dee49abe4eba7,0x00007f0bc810d514}},
    {{0x00006ba426f4136f,0x0009e57e03035b90,0x000f463c288d6736,0x000dbf5cbc8dfd94,0x00000d1f8dbcf8ee}, {0x000c9dad737213a0,0x000ba2ef72e9883a,0x0003ec69579ff6f8,0x000ab75311e2edd4,0x00001d3a907ddec5}, {0x000693313ed081dc,0x000ad851b3480ba1,0x00030321cb29329f,0x000fde30128013c0,0x000000011b44a31b}},
    {{0x000fa06c3fc66c0c,0x0008e4dd60dd23fd,0x00068e4d715d40e3,0x00057e17ae38b382,0x00003ac48d916e83}, {0x00061f696a0aa75c,0x0005c5852bd6a165,0x000a7966adc1bf72,0x000102611a8dd7f9,0x000063d988a2d285}, {0x00020753afbd232e,0x000b8fdd8f683001,0x0004e72b91e92bce,0x000a066f81669b38,0x000033fad52b2368}},
    {{0x000649c6c5e41e16,0x00030333f7735540,0x000305e7460af864,0x000dca7b2acfcd2f,0x000016c0f429a256}, {0x000cc8d0c422cfe8,0x0007b05a13acb8d2,0x000cf6a56f072b4f,0x00071e2a3feb6e6e,0x00003cc355ccb90a}, {0x00069443903e9131,0x000cb7a5637cee9b,0x000aba9244b8a494,0x0007568c87cd1a4b,0x0000631eaf426bae}},
    {{0x00090410da66fe9f,0x000526c16e5a6b3e,0x000ef9bf8385dd4b,0x00019b5bc3d97611,0x00005599648b1ea9}, {0x000975b9a3700de8,0x000fbe2f8055247d,0x0002e45de17280c5,0x00080b553658f273,0x0000431f2c7f665f}, {0x00026344858f7b19,0x0002fa1ea514ad60,0x000090a9d714ab35,0x0003b268900441a2,0x00007b04715f9125}},
    {{0x000dbd28acf6ae43,0x0008b7d5c7ab483e,0x0007eb2c4486357c,0x000583fc0404769b,0x000059b37bf5c2f6}, {0x0006c280c4e6bac6,0x000dd6d1d9b0bb37,0x00050bf944970ed3,0x000e223b09a95584,0x000048d0acfa57cd}, {0x000f26e47dabe671,0x00097622f3a37b60,0x0009960394f1d1a1,0x0003bdb4208ce7ee,0x000016234191336d}},
},
{   /* slot=23  [{1,2,3,..,8} * 16^(2*23)] * G) */
    {{0x000499def6267ff6,0x0007b742c0843b9e,0x0009a4f2b17772ca,0x000500623a0153fe,0x00002cdfdfecd5d0}, {0x00099cd61ff38640,0x000c3063625a0dd4,0x000dd73dc329cd9b,0x000923151e2d8023,0x00004a25707a203b}, {0x0007668a53f6ed6a,0x000581dd170a12ab,0x000ae20161304242,0x00049fc4000144c3,0x00005721896d248e}},
    {{0x000e5517fd181bae,0x0009f2bb963b40b6,0x0002064625902262,0x00013da5509bce93,0x0000578edd74f63c}, {0x000d5091a1d0da4e,0x000a7b5fe3e08285,0x00019393b34baa6f,0x00030fd63e5177ce,0x000003c935afc4b0}, {0x000276c6492b0c3d,0x000c4dfe205fc997,0x000d623a3c47ccc2,0x000c7a2dcd29b84d,0x00003ec2ab590288}},
    {{0x0000d27be4d87bb9,0x000eb61391aeda1a,0x0003cb9b83a98b4d,0x000cace99a0ddd07,0x00002dd5c25a200f}, {0x00013a09ae32d1cb,0x000df40f5c2d5a72,0x00081eab290f2b87,0x000ac5e0baea4c6e,0x00000e1bf66c6adb}, {0x000bd5e9792c887e,0x00018cb926d5de2a,0x000aae5f1e1a0200,0x0008f5fbfba69cdb,0x0000730548b35ae8}},
    {{0x000551a3cba8b8ee,0x0001db2115f16c43,0x000b8c385065a26f,0x000b8ca760f4f52a,0x00003043443b411d}, {0x000b094ba1d6e334,0x0007709353f19805,0x000622702bbf3ef1,0x00045dd423f06cb0,0x0000585a2277d878}, {0x000a5f8233d48962,0x000b5ec78257fa18,0x00073e41ff6698c4,0x000981fa78e6fa53,0x00007656278950ef}},
    {{0x0003cf59d51fc8c0,0x000fd0506b6f238c,0x000b570e8f9bedd2,0x00046a626bf109fa,0x00003f4160a8c1b8}, {0x000073a3ea86cf9d,0x000b707155fdce17,0x0001838a8e3a8cfb,0x000f6164853e7fc3,0x000028bbf484b613}, {0x00012f5c6f136c7c,0x00007f6dd11bef26,0x0003de6f33afead1,0x000f75d527e9ad21,0x00001e79cb358188}},
    {{0x000436c3eef7e3f1,0x0007ffe9e10f8013,0x000cf9defc828b6a,0x00038317ff908e5b,0x000065d7951b3a3b}, {0x000953d8f5e08181,0x00044299dded977e,0x00064525e584a50c,0x000f2f4dc6c2d0c8,0x0000478ab52d39d1}, {0x0006a4d39252d159,0x000bc871ac80766a,0x0006c1c96fe5dde1,0x0002214b82c6b40a,0x000016d87a411a21}},
    {{0x000d7e5a42066215,0x000cd0c5a24c1b3b,0x0006f994b7879be3,0x0008ca657c05db1d,0x000028f87c8165f3}, {0x0004d5e2d54e0583,0x000d72ebd99fafba,0x000ee9778fe21faf,0x0006dde497ac2736,0x00001f990b577a5a}, {0x00044ead1be8f7d6,0x000ebacea798fa33,0x00020de0527d1e50,0x0006d3e77c6569e5,0x000045882fe1534d}},
    {{0x0009345d757983d6,0x0001117aa11a6666,0x00085e128f62b6ed,0x000f6dd7ddd18579,0x0000688fe5b8f626}, {0x000c9929943c6fe4,0x00061a38392a2d8a,0x000ec89af3b5f9f1,0x000f0742699db13b,0x00007dcf843ce405}, {0x0000d6484a4732c0,0x000fdca5632996c9,0x00015dc6e1d52143,0x000191bb3be28c39,0x00006739687e7327}},
},
{   /* slot=24  [{1,2,3,..,8} * 16^(2*24)] * G) */
    {{0x00082014385675a6,0x00030aafda9e8ef7,0x000cdfa8cba2649f,0x000c0b34cd1eb505,0x000046115aba1d4d}, {0x000dcc9dc80c1ac0,0x000f41b38a436a66,0x0005dbd7c697a05c,0x0007daba7ebf3be9,0x00007da0b8f68d7e}, {0x000f1953c3b5da76,0x0007321119e9bd40,0x000eb259601dac6f,0x0004b4b03cc6021f,0x00005a5f887e8367}},
    {{0x000301cf70a13d11,0x00015350dd0c48f6,0x0004bca47ecfceb8,0x0001434f70297d4a,0x00003669b656e44d}, {0x000628d3a0a643b9,0x00000e6c320649e9,0x000c2dec32b5c3cb,0x000c70c9b5302897,0x000043e37ae2d5d1}, {0x000e3f06eda6e133,0x0005199a13ac0387,0x000626381167301d,0x000e9bebd5ad8f83,0x00006a21e6cd4fd5}},
    {{0x0006170a3046e65f,0x0002a00d23524f1c,0x000c82b75558712a,0x000ff5769dbbd3c8,0x0000586bf9f1a195}, {0x000129126699b2e3,0x00047708d1301ef4,0x000182b0bd71d308,0x0008b36325432d01,0x000045371b07001e}, {0x000b088d5ef8790b,0x000dc610937e5a6d,0x0001a16eb85278f0,0x0002179ac0349d26,0x00000eafb03790e5}},
    {{0x000555c13748042f,0x000e6820baa11960,0x0003486d0c219a41,0x000c6611c81f7387,0x0000309acc675a02}, {0x0000805e0f75ae1d,0x000e32662cc30514,0x000a92396dec02fb,0x0005bb32cebdf1ee,0x000044ae3344c543}, {0x000289b9bba543ee,0x0009d5ac971429cf,0x000f9360aaf3760e,0x000678f1d82e5c64,0x000062d5221b7f94}},
    {{0x000c299c18d0936d,0x0006c8a0c1a0c524,0x000b4a8631c86bb5,0x0004562a375052ed,0x00005c0efde4bc75}, {0x0005d4263af77a3c,0x00011fee9144d758,0x0009f7193ddfae7b,0x0002037a50670805,0x000014f29a538392}, {0x00017edc25b2d7f5,0x000db99b53040df7,0x0003ed4c6221f970,0x000093eda9234b7c,0x00005e72365c7bee}},
    {{0x000bfc074571217f,0x0005d0694d95b575,0x0004191e33377967,0x000eabc9a0a37bbf,0x000077f1104c47b4}, {0x000339062f08b33e,0x000e5df9f32be7d9,0x000f9ebdfd5b9659,0x00049b7acff3dad1,0x000070b20555cb73}, {0x000113c555112c4c,0x0003a9a881fcdbe5,0x000e503b47668842,0x000404a446677855,0x00000e34398f4a06}},
    {{0x000d22d93ecebde8,0x0004127822f07b67,0x00005b6d8d09b3e8,0x0002372743fa61fb,0x00005e5405368a36}, {0x00030b093e4b1928,0x0000e73f3f640189,0x0003395d6f7de3e1,0x0009c3ef43217da7,0x00006f8aded6ca37}, {0x0000123dfdb7b29a,0x000e1a21ab291e34,0x000de6949e487b97,0x000de97f9967d02f,0x0000780de72ec8d3}},
    {{0x00028545089ae7bc,0x000cf1c7f4d060ae,0x000a4811b8388dde,0x0008ce438ac15510,0x00000eb28bf67192}, {0x000feaf300f42772,0x0002a2a8c41aa671,0x00073732928f72eb,0x00087a629a17fd79,0x00001defc6ad32b5}, {0x000bbe1aef5195a7,0x00077917b15edaf5,0x000ae5da2e148c12,0x00028672991f7fb7,0x0000467d201bf8dd}},
},
{   /* slot=25  [{1,2,3,..,8} * 16^(2*25)] * G) */
    {{0x000e919a74ef4fad,0x000ecf6a308a295f,0x0009a47b013a827b,0x000c797964e01d30,0x000071c43c4f5ba3}, {0x000ef4bd567ae7a9,0x000b2d64498bdbc1,0x000c1f4ec83f624c,0x0004001e41064d22,0x00002ef9c5a5ba38}, {0x000d6df6fa9e74cd,0x000bce4af267ab6f,0x0001ef990ef18278,0x000f2938255b3d0f,0x00005a758ca390c5}},
    {{0x00072710d9462495,0x000d2d57d5003a2b,0x0000b487ca3aa8c6,0x00072ece3d400bfa,0x00002dbae244b3eb}, {0x0000918b1d61dc94,0x000469a8130668ce,0x000fe8aad38ded36,0x000d43fd4e6a829a,0x00000a738027f639}, {0x000f4a2f57ffe1cc,0x0000de1839843980,0x0009fb15fd00670d,0x000a69c105c3f4a4,0x00002698ca635126}},
    {{0x0005318832b0ba78,0x000f7925cff8be76,0x0000291fcc381831,0x000eb0708a81b91a,0x00001fb43dcc49ca}, {0x000d702f5e3dd90e,0x00018e4d253862e3,0x00024da96a9e3f09,0x00033325e773ef60,0x00003c004b0c4afa}, {0x000946ac06f4b82b,0x000a5a806c4f39aa,0x0006cd47871ca284,0x000d2173ed3265fc,0x00006b43fd01cd1f}},
    {{0x00075d4b4697c544,0x00048df0fffbfc7a,0x000a46785a15fdf8,0x000f7142868b9eba,0x00005a68d7105b52}, {0x000742583e760ef3,0x000b9ee0ab990b5c,0x00072b923f75dc52,0x000d9f0bf1427c20,0x000073420b2d6ff0}, {0x000cf6cb9e851e06,0x00013c62238c4af2,0x0009fbf3738f5939,0x000bc9eda8ab8969,0x00003db5632fea34}},
    {{0x000eee2bf75dd9d8,0x000f6396759a5f46,0x00099e72730d17b1,0x0005f131bf2d1314,0x000004321adf49d7}, {0x000990b1829825d5,0x000873e9a89912e4,0x000c704af8edeaeb,0x0002b0eeef03d394,0x000059197ea495df}, {0x00016019e4e55aae,0x0007a7e2f92e904e,0x000f159aa4e77b43,0x0000cc0c7ce2dc16,0x000045eafdc1f4d7}},
    {{0x000401858045d72b,0x000a2cf2f0651698,0x000b222dc64c22fa,0x000dade941a36656,0x00005a5eebc80362}, {0x000e4624cfccb1ed,0x00092bd5c0395b60,0x000c0481c959dbc2,0x000d94031a09d1dd,0x00003f73ceea5d56}, {0x0007bfd10a4e8dc6,0x0007e44c9b339b7a,0x000557aefabe5700,0x00018db60c1207f1,0x0000260588912662}},
    {{0x000704a68360ff04,0x000de7661e6f459f,0x0002873551c3d93f,0x0005d57831b2a731,0x000054ad0c2e4e61}, {0x00018e3cc676e542,0x0009303ceccad4c8,0x0004129f085e422c,0x00043b8ec07cccab,0x00000dedfa10b244}, {0x000b67d5b82b522a,0x000469fa5c1ebee3,0x000ec19fd336f163,0x0009408a5b4d2f26,0x000062ecb2baa77a}},
    {{0x000d795261152b3d,0x0007d0eddd7d1e5e,0x00096b4c71496235,0x000d8be7482c8d0b,0x00002e59f919a966}, {0x00072836afb62874,0x0008579e104a5920,0x000630a14a5fcd5e,0x0003f985aad01adc,0x000061913d507566}, {0x00062d361a3231da,0x00032942002700dc,0x000f9594cefa4758,0x0005d5c02d801513,0x00003ddbc2a131c0}},
},
{   /* slot=26  [{1,2,3,..,8} * 16^(2*26)] * G) */
    {{0x000c0ff9ce5ec54b,0x0006b8c2f130d9ad,0x0000f89515039c2a,0x000b36b028007c7f,0x000078968314ac04}, {0x000a57a22796bb14,0x000b79b07da21f3a,0x0001a0391c883aba,0x00005f9e54be2183,0x00005ee7fb38d832}, {0x000dfdcb41446a8e,0x000a9434937f9538,0x00063c8c78a5acfd,0x0000d0946af908d2,0x000061d0633c9bca}},
    {{0x00044935ffdb2566,0x00089780b68bb637,0x00053eec03c5bd6b,0x000d7f56f1b32805,0x00006e965fd847ae}, {0x000328bcf8fc73df,0x0005da6f037fcada,0x0008c2a909ee8469,0x0007bdc637fb4db3,0x00005b23ac2df806}, {0x0002b953ee80527b,0x000aafade6d8d9ad,0x00050e82cfe88f19,0x000dedc0e7117041,0x000079b9bbb9dd95}},
    {{0x000355406a3126c2,0x000a868c8c393ebb,0x0005b97a82d26383,0x00021476c0c6429e,0x00005065f158c9fd}, {0x00097dae8e9f7374,0x000f8cfbb0816d19,0x000d445f0aa032a2,0x000b834cd6cba126,0x00001ba811460acc}, {0x000169fb0c429954,0x000acd76ecf67708,0x0000e645bae14600,0x000faf22eaab98a7,0x00003981f39e58a4}},
    {{0x000b8a7559230a93,0x0006960e6f45d18f,0x0004a93cb51d168f,0x000d0fd3a85a9451,0x000038dc083705ac}, {0x0005dfa56de66fde,0x000002c40483ac84,0x0007b4f632e152a5,0x0001b65e9d2e163c,0x000030f4452edcbc}, {0x000d2782c5759740,0x00069f99cbecc856,0x0000ea4e71fa1345,0x00024698844fc73c,0x0000632d9a1a593f}},
    {{0x000b6b15b807cba6,0x000dfbc54f0d7f6b,0x000e29670b1823c7,0x0004a57bb1d97036,0x00000b24f48847ed}, {0x0009fd11ed0c84a7,0x000810d9f693abf0,0x0007cf877963f071,0x0004ba221908c2d5,0x00003a5a7df28af6}, {0x000ad4be511beac7,0x00075ed26ccf2dcd,0x00005f9a65a45380,0x0001f63e19cff9f0,0x000034fcf7447548}},
    {{0x0007e04c789767ca,0x000cb38d9467dc19,0x0003f95fa8b8714d,0x00063f755de88828,0x00003d3bdc164dfa}, {0x000b1dab78cfaa98,0x00067190b72f2a5b,0x000a92608e5ceda2,0x00074b09309c9110,0x00000119a3042fb3}, {0x0002d89ce8c2177d,0x000f66895d0c167a,0x000282a2b0669da5,0x0000a73f56598e5b,0x000056c088f1ede2}},
    {{0x000d3d1110a86e17,0x000320b75b2fa336,0x0005072988d7f388,0x0008b87f91533762,0x000009674c6b9910}, {0x000b5fac24f38f02,0x000febae30cbd581,0x000acf92f0a90be9,0x000038f9a2169028,0x0000038b7ea48359}, {0x000ef82199316ff8,0x00082eaa78d4f9f4,0x000aef31742f49d2,0x000eb650971a5ab5,0x00006e5e31025969}},
    {{0x000c62f587e593fb,0x000deca5d3e71b16,0x0004cc3e6d4999ed,0x000dba8b491c1e01,0x000008f5114789a8}, {0x0004fb0e63066222,0x0008987acba3f330,0x000c1061a3fb3506,0x0008620bd1924778,0x00003058ad43d183}, {0x000c0ffde57663d0,0x00038a22ea610323,0x000c994f9a05c3df,0x000dc99bdc78abda,0x000026549fa4efe3}},
},
{   /* slot=27  [{1,2,3,..,8} * 16^(2*27)] * G) */
    {{0x000d5a461e6bf9d6,0x000fc7777a581741,0x000474d3d92305b3,0x000e0ffd45574a26,0x00001926e1dc6401}, {0x00068549af3f666e,0x00004f14a0ea5db4,0x0004ba0c47d77fcf,0x0003c853df23ff7a,0x00003a10dfe132ce}, {0x000f4e8aea17cea0,0x000463a1fc1fde07,0x0001f2c0f12fd515,0x0005d15175322fd3,0x00001fa1d01d861e}},
    {{0x000055947d599832,0x000da37f15520cc8,0x000e0593201e4656,0x000cf3399f6f7744,0x0000773563bc6a75}, {0x000cac00d1df94ab,0x000ddd1080de938d,0x000dd5e2622e712b,0x00001e57f13e93ef,0x000073fced18ee9a}, {0x0001e90863139cb3,0x00067c5a03ecd06b,0x000d638932a493da,0x0004f448d77cec8a,0x00001f426b701b86}},
    {{0x0009264c41911c01,0x000b817a22c25efc,0x00030f1447f1a3b7,0x000b0905875da6bf,0x00004e1af5271d31}, {0x000e35c891a12552,0x00053575e9c76f17,0x000d9b723eb76b81,0x000e438fa83406f0,0x00000b76bb1b3fa7}, {0x0008c1f97f92939b,0x000cbd444ab6e08b,0x0009bb8017be6771,0x000a95522e564639,0x00007b6dd61eb772}},
    {{0x000dc1e850f33d92,0x0004f608cd5cfb7a,0x000dfc5bdb7998fa,0x0002f4fad962dbd8,0x0000703e9bceaf1d}, {0x0000abf9ab01d2c7,0x000dc40143b18573,0x0000cbb28116fb76,0x0006afe866cbe65a,0x000053fa9b659bff}, {0x0004c8e994885455,0x0006665aed4e56c1,0x000cd65af1843a5d,0x0001f50181bb73eb,0x0000398d93e5c4c6}},
    {{0x000bd16733e248f3,0x0008715bf0a5f1c4,0x00010b0376bd9e12,0x0001b13d43f8cf0a,0x000053b09b5ddf19}, {0x00077c60d2e7e3f2,0x000a030828bb1c38,0x00039ef1383b34aa,0x0000577283e26e77,0x0000699c9c9002c3}, {0x0006a7235946f1cc,0x000b5cce5d97df30,0x0001b4e975921718,0x000d90728cdd2478,0x000051caf30c6fcd}},
    {{0x000ba7427674e00a,0x00070a17a7bf3a60,0x000f3324cc630e85,0x000fdaa3758563dc,0x00005504aa292383}, {0x000af99a18ac54c7,0x000dcc51cb30f737,0x000ce10cc7903378,0x000e99a2b89bc334,0x000012ae29c189f8}, {0x000ec0cb1f0d01cf,0x000cc3a34f7aea99,0x00009c4e220dd1ef,0x000a5ea55ca7521d,0x00005fd14fe958eb}},
    {{0x000c2ddf2845ab2c,0x000b10a7fe993b5d,0x000002e346069491,0x00074d14daaf3d64,0x0000093ff26e5864}, {0x0002fe5ebf93cb8e,0x0005136d4565f3c4,0x00084220e8bedfa8,0x000d128e0f0859e8,0x00007dd73f960725}, {0x000d24fe68059829,0x00072dbaf23e5b10,0x000457ac29757306,0x00070a41367253ab,0x00002f59bcbc86b4}},
    {{0x00047d429917135f,0x0001f567d03d7838,0x000e77aad1ad1b91,0x000af4a7e7748d9b,0x00005458b42e2e51}, {0x0001d560b691c301,0x0003fadd7e71e704,0x000133558585201b,0x00028b116c2e1631,0x00002aa55e3d0108}, {0x000192e60c07444f,0x0002d74421d10ed5,0x000db5c86442c54e,0x0008664352b4c82f,0x000013e9004a8a76}},
},
{   /* slot=28  [{1,2,3,..,8} * 16^(2*28)] * G) */
    {{0x000d8845832fcedb,0x000c9ae6bf863739,0x00074ffef7fa38d6,0x000e45e32bc0dcab,0x000073937e8814bc}, {0x000e00c9193b877f,0x00090e0dc506bbb2,0x0006de649fece3a8,0x0009e1aecf3b7c03,0x00005f46040898de}, {0x00037116297bf48d,0x00022d4f06834b90,0x000696bdc6a9d13b,0x000e835e19715574,0x00002cf8a4e891d5}},
    {{0x0003fd8707110f67,0x000d37c38b5496d9,0x0002736a86dd4c09,0x0002a097cb16a4cc,0x00002049bd6e5825}, {0x0005487e17d06ba2,0x0001c3950196b2cb,0x0005978a3024d238,0x000a4f6d7659c818,0x00007a6f7f2891d6}, {0x0009fd8d6a9aef49,0x000be5b3db90b7d0,0x00019ebfd4f0ee60,0x000941d4c21b52c5,0x00006011aadfc545}},
    {{0x0007926dcf95f83c,0x00061712890715f6,0x00098f7a5b7c7e85,0x000f9e0d6a1e7f39,0x00006fc5cc1b0b62}, {0x000ed0c802cbf890,0x000ca0dff6aaa63d,0x0009b6ed99fbd098,0x0000b1e624d0afdb,0x000069ce18b77934}, {0x000f5528b29879cb,0x0003cd47e9092d1e,0x00089f2352dd1aae,0x00001f1127e04421,0x000015596b3ae571}},
    {{0x000739d23f9179a2,0x0003197d6ddcf462,0x0003f2148aff8312,0x0004dda1307deb55,0x00000d2237687b5f}, {0x000f31167e5124ca,0x0008bd9c745df09f,0x000ef556e50be415,0x000d138292b7d227,0x00003aa4e241afb6}, {0x000138bf2a3305f5,0x0008fa2e926c32cc,0x000549d2eb48583f,0x000a36c083ab1a25,0x000032fcaa6e4687}},
    {{0x00056e8dc57d9af5,0x000ed9df0bdf27bc,0x0002efe4a33e0bd2,0x0006a5caac014de2,0x00004627e9cefebd}, {0x0007a4732787ccdf,0x00008f213e3f8320,0x00060d964e17e319,0x0000be9d5b2ecd7f,0x0000746f6336c260}, {0x000af345ab6c971c,0x000729943731f3f4,0x000344186de288eb,0x000629333596a8a0,0x00007b4917007ed6}},
    {{0x0005fb5cab84b064,0x000d289f3bc142d8,0x000b15ce0c497810,0x000fd7b476adc447,0x0000122ba376f844}, {0x00041b28dd53a2dd,0x0005bdf42fc3f543,0x000dd2f8f4aa1790,0x000d37d0ff592d94,0x00001d03620fe08c}, {0x000232cda2b4e554,0x00042115d187fc20,0x000dd479d99ed0fd,0x000ec4c2eabb4be7,0x000002c70bf52b68}},
    {{0x0007ec4b5d0b2fbb,0x00090074882caa28,0x0001d0815c415c57,0x000f5e0e044a61ec,0x000026334f0a409e}, {0x000532bf458d72e1,0x000e07cb73cb5ace,0x000e8bbde75be768,0x0003a0356cf7d94e,0x00006b0697e3feb4}, {0x0008f04adf62a3c0,0x000ef076da45db6c,0x0009f0d2a93ef000,0x0002fae9c9cb9584,0x00001cc37f43441b}},
    {{0x000f565a5cc7324f,0x000c0e506a922508,0x000c45ac19d061c4,0x000314afb18abdb5,0x00006c6809c10380}, {0x000656f1c9ceaeb9,0x000f818e5656ad76,0x00044c23341c5b15,0x000683826e728328,0x00003a346f772f19}, {0x00055112e2da6ac8,0x00031b1e851edd2d,0x000ec67262e9bd03,0x000c5d0960746dd8,0x000005911b9f6ef7}},
},
{   /* slot=29  [{1,2,3,..,8} * 16^(2*29)] * G) */
    {{0x00039983f5df0ebb,0x0008f512c4cacc13,0x000bb398e1c0f375,0x0000c622cf1130a0,0x00006b3cecf9aa27}, {0x0009acf3512eeaef,0x000d31cc1cb49534,0x00099a688d20c141,0x0002d1724180c07a,0x0000555ef9d1c64b}, {0x000770ba3b73bd08,0x00008a3afbf0c36a,0x00040946f2624aef,0x000749d5737ff98b,0x0000675f4de13381}},
    {{0x000c52036b1782fc,0x000816cad83b40e2,0x000964073e64816c,0x000c520d0dcbdd96,0x000013d99df70164}, {0x000ff6d93bdab31d,0x0000f9d652dfea12,0x000abe94870725d8,0x0003c43019c4ff39,0x000060f450b882cd}, {0x000b5ec321e5c0ca,0x000c9d719bfa2014,0x00050023a04fcb69,0x000ac804e5f1c187,0x00001c06de9e55ed}},
    {{0x000f7ad6a33ec4e2,0x00038be2ee08e990,0x00032845156608f9,0x000b60d9ca143c56,0x00004cf38a1fec2d}, {0x00052b40ff6d69aa,0x00018dc4049bbffd,0x00034d989734530b,0x000ba2d5e4a5c2fa,0x000078096f8e7d32}, {0x000aaa650dfa5ce7,0x0002a48b5478ca0a,0x000003725bf9c49e,0x0001abe4f09cc7d7,0x0000373cad3a2609}},
    {{0x0004634d82c9f57c,0x000e124934536b29,0x00018cdb5a1fcbfd,0x00019fc9e9c4db34,0x00000040f3d94544}, {0x000ea8fb89ddbbad,0x000bc61aeaecbf1b,0x000f9b8d9d3bcb2c,0x000a6868f58a7bb1,0x000021547eda5112}, {0x000de939fd5986d3,0x00089510a380cdef,0x000b3119b9f4272c,0x0004df4b72ba407b,0x000063550a334a25}},
    {{0x0007d6edb569cf37,0x000b00ca52ee1650,0x000b6bd65d178429,0x0008f51ea7c0090e,0x00003eea62c7daf7}, {0x000a584572547b49,0x000fae2c408e09bb,0x000734f18df305c6,0x000767a60e8fa69c,0x000039a92bafaa7d}, {0x0004c713e693274e,0x0007768dbd3759d2,0x000b8ab39a5f6385,0x000c4cd70525560e,0x000068436a0665c9}},
    {{0x000235e8202f3f27,0x000e264f975b0bc0,0x00038c2416c75c00,0x00089f991a4e9d5a,0x000017b6e7f68ab7}, {0x0006d317e820107c,0x00044840ae9651e5,0x00020ffc7ac52668,0x0001472c1e0a1c63,0x00005373669c9161}, {0x000814ab9a0e5257,0x00084c9cab3fc5d2,0x000b2d1eca908f20,0x0007d11afcaf5885,0x00001cb4b5a678f8}},
    {{0x0004c06b394afc6c,0x0002498da5fb1b66,0x000bcad8340c88de,0x00034a24f8d03164,0x0000330bca78de74}, {0x0004aa62a2a007e7,0x000b0f071c7b16b7,0x00000be223f311e0,0x0006eac5707e4380,0x00002dc0fd2d82ef}, {0x000eff841119744e,0x000962b074724982,0x000fc953fbf9695e,0x0001cf5c58ac14fb,0x00003c31be1b369f}},
    {{0x0004864d08948aee,0x000ee91ba1c6fb0f,0x0006aca15807dc19,0x000d4bb7975cdaea,0x0000330b61134262}, {0x0008bc93f9cb4272,0x0001fc7cedb98c16,0x0004ac8d7aaeb871,0x00055bb7f0e52aa3,0x000041cec1097e7d}, {0x000619d7a26d808a,0x0009e1d9e156df79,0x000ba1df27bb1fd4,0x000777d73d7c36cd,0x000026b44cd91f28}},
},
{   /* slot=30  [{1,2,3,..,8} * 16^(2*30)] * G) */
    {{0x000048478f387475,0x000f49cbecb3c51f,0x00099f2055b25dbc,0x000a5d69aab1244d,0x00002c709e6c1c10}, {0x0007f29362730383,0x000ffebca8a2ce1b,0x000fd413144b5279,0x000610fdafc778ab,0x00007deb10149c72}, {0x0002af6a8766ee7a,0x000045553cd0ecb6,0x000f0be4b566cbec,0x000e2ea588001380,0x000008e68e9ff62c}},
    {{0x000d500a4bc130ad,0x000493d0bd49c34a,0x00000a89be8d38db,0x0003b09a25c3d985,0x00002f1f3f87eeba}, {0x000d09d50ab8f2f9,0x0008dc55923df2f2,0x0003766cb9acb921,0x00019f54a8f34267,0x00004cb13bd738f7}, {0x00048c75e515b64a,0x000badb4a9038f78,0x000f751b50a59501,0x0002ee8c20d313f3,0x000019a1e353c0ae}},
    {{0x000c7560bafa05c3,0x000a0c6e55e617d1,0x0000d66473b3e1a0,0x0003486e3529718c,0x000041546b11c20c}, {0x000172cdd596bdbd,0x0004398eefc40b42,0x00044109b593e045,0x000ae349fb15347b,0x0000736bd3990266}, {0x00032d509334b3b4,0x0004b60816573855,0x00025c837546fd11,0x000ab5ccc5f5f304,0x0000412295a2b87f}},
    {{0x00099b88f57ed6e9,0x000266df8c82519c,0x00030ad2735393cb,0x0002e345cee3213b,0x000014e153ebb52d}, {0x00055261e293eac6,0x000032133acdb2e6,0x000900996b845a92,0x000dd80460975cb7,0x00000760bb8d195a}, {0x000e1a17cde6818a,0x000a9ed69a084413,0x0006caccb157156d,0x000c5f22cbf268f4,0x00006b34be9bc33a}},
    {{0x000f2f643a78c0b2,0x0001ef22e027cf3d,0x0009c1b5a34c3e97,0x000dd2dec7d1c5e4,0x00002012c18f0922}, {0x000c69656571f2d3,0x00045530e737a11f,0x0004fe5035c6c9e8,0x000d30be33ae7a2d,0x000001b9c7b62e6d}, {0x000b55e55ac89d29,0x0001f45a0a763880,0x0002e76c1f148324,0x000ade83d36efdfc,0x000008af5b784e4b}},
    {{0x000499dc881f2533,0x000da779323b6283,0x00073441f49d0525,0x000168d897addfb6,0x000032b79d71163a}, {0x000314d289cc2c4b,0x00011a287178de27,0x000a3364ce4be4bd,0x000826e18d528d6f,0x00006423c1d5afd9}, {0x0005f8d9edfcb36a,0x0008f3746e5f9cc8,0x0009e5d3cd22bcc2,0x0002dcce49de338f,0x0000480a5efbc13e}},
    {{0x0001e70b01622071,0x000cf8b1dafc50b5,0x000f5aabcd06b505,0x000bf312c6bb061e,0x000047aa27600cb7}, {0x00014ce442ce221f,0x000cc4c053928b66,0x000c1cbe036e199d,0x0008e06663fb4a4d,0x000024b31d47691c}, {0x00041eedc015f8c3,0x0007e7c693f7c2a5,0x000ea278d611a4fe,0x000a094f0af66134,0x0000545b585d14dd}},
    {{0x000f275ea0d43a0f,0x00034089beebe67b,0x000479e72eade68e,0x00054544289134cd,0x00000f62f9c332ba}, {0x0004e4d0e3b321e1,0x0007a28ff1e95620,0x000b99bd9e3baa63,0x000d0710b0ccffd5,0x00004d22dc3e64c8}, {0x00046589d63b5f39,0x0003f57cbcf61fcb,0x00053afa055cae6a,0x0001436febac2d29,0x00001c0fa01a3637}},
},
{   /* slot=31  [{1,2,3,..,8} * 16^(2*31)] * G) */
    {{0x000604b622943dff,0x000ce44cfb3a0d2c,0x0007808678bc8cbe,0x000a6bf5d254ff39,0x00000fa3614f3b1c}, {0x00082b0e8c936a50,0x00035c1dac5b6690,0x0004dfb634f9c9a0,0x000c1406fb73e54c,0x00004005419b1d2b}, {0x0003febdb9be82f0,0x000af3a44ac90a00,0x000954fa8e2089c1,0x000ab42f8499f911,0x00001fba218aef40}},
    {{0x00049448fac8f53e,0x0009a7ba63741ab5,0x000c2b5e0181f6e8,0x0006e4274fd6c7d6,0x0000392e3acaa8c8}, {0x000e57043e7b0194,0x000ee08daaf7f4f3,0x0009dcdef1a81d3e,0x00061d5c839c6ab9,0x00006c535d13ff77}, {0x000d34e93e8a35af,0x000445887e8164cb,0x00029ab0ab2e0781,0x000c13b19319c76f,0x000025e17fe4d50a}},
    {{0x00089bd71e04f676,0x00052d6420f950a2,0x0004691fab208e1c,0x000b3515186d8b03,0x0000255751442a9f}, {0x000f7ff576f121a7,0x000272fcd87e3915,0x000d1be526c34a32,0x000899bccba2fde4,0x00006bba828f8969}, {0x0001bc6690fe3901,0x00018a0997ad5e2d,0x000f8460d44cb54a,0x0007be4971d6914a,0x0000559d504f7f6b}},
    {{0x00038378b3eb54d5,0x00066a5553c7ca77,0x00092800ba1d69d3,0x00032170a26cf62f,0x000001ab12d5807e}, {0x000891e7f6d266fd,0x0009b0307781b9c4,0x000061e23b0744a1,0x000d50e88388f1d6,0x0000123ea6a3354b}, {0x000d189041e32d96,0x000c2d8315848118,0x00083245d9b9ede3,0x000a1541eab4271d,0x00004a3961e2c918}},
    {{0x000c3be0f8e6bba0,0x000347effe30a71d,0x00013a476ad6cef8,0x000b763a992425fe,0x00002cd6bce3fb1d}, {0x0007d644f3233f1e,0x0000e34fcf016032,0x0002dab979499a26,0x000111f83b5a716f,0x000068aceead9bd4}, {0x0004c90ef3d7c210,0x00024b7ad040c38b,0x0007e73e23308e6e,0x000f5973860d9f1b,0x0000595760d5b508}},
    {{0x0009bfe104aa6397,0x00008a4a7fccb612,0x000d9094588f9600,0x00091a93f8bc0897,0x0000709fa43edcb2}, {0x000acbebfd022790,0x00005c4115760882,0x000d3473f489af33,0x0005a2b65f492e37,0x00002cb2c5df5451}, {0x000a5d8c63fd2aca,0x000662e694effeb0,0x0008cbb03ad22bc1,0x000131f2723f36ef,0x000070f029ecf0c8}},
    {{0x000307b32eed3e33,0x00033a45581e7461,0x00095f0366ae042f,0x0004858c94449d31,0x00000b7d5d8a6c31}, {0x000aafaa5e10b0b9,0x00070ef041aa92a6,0x000a3ad61f78f0a3,0x000d9e1773efb77a,0x000044eca5a2a74b}, {0x000448327b95d543,0x00000a3340f1d25d,0x0000e1c52b70d383,0x000e9e4de1c531c6,0x0000272224512c7d}},
    {{0x000c92af49c5342e,0x00011b2e6fad01ab,0x000cc84e29ffeed8,0x000c543efa28c8df,0x000011b5df18a44c}, {0x000bbb8a42a975fc,0x0007796ada358bf7,0x000dedaa488c5c39,0x00020a6e27fc76fc,0x000019735fd7f6bc}, {0x000b90d042c84266,0x0000f7f19547ee3a,0x0005a497b9eb848e,0x000895f2503a1d06,0x00000fef911191df}},
},
};
/* clang-format on */

#endif /* #if (_MBX>=_MBX_K1) */

#endif /* #define IFMA_ED25519_PRECOMP_H */
