#NEXUS

BEGIN TAXA;
	DIMENSIONS NTAX = 8;
	TAXLABELS
		'B_FR_83_HXB2_ACC_K03455' 'B_US_83_RF_ACC_M17451' 'B_US_86_JRFL_ACC_U63632' 'B_US_90_WEAU160_ACC_U21135' 'D_CD_83_ELI_ACC_K03454' 'D_CD_83_NDK_ACC_M27323' 'D_CD_84_84ZR085_ACC_U88822' 'D_UG_94_94UG114_ACC_U88824' ;
END;

BEGIN CHARACTERS;
	DIMENSIONS NCHAR = 1320;
	FORMAT
		DATATYPE = DNA
		GAP=-
		MISSING=?
	;

MATRIX
	'B_FR_83_HXB2_ACC_K03455'     CCCATTAGCCCTATTGAGACTGTACCAGTAAAATTAAAGCCAGGAATGGATGGCCCAAAAGTTAAACAATGGCCATTGACAGAAGAAAAAATAAAAGCATTAGTAGAAATTTGTACAGAGATGGAAAAGGAAGGGAAAATTTCAAAAATTGGGCCTGAAAATCCATACAATACTCCAGTATTTGCCATAAAGAAAAAAGACAGTACTAAATGGAGAAAATTAGTAGATTTCAGAGAACTTAATAAGAGAACTCAAGACTTCTGGGAAGTTCAATTAGGAATACCACATCCCGCAGGGTTAAAAAAGAAAAAATCAGTAACAGTACTGGATGTGGGTGATGCATATTTTTCAGTTCCCTTAGATGAAGACTTCAGGAAGTATACTGCATTTACCATACCTAGTATAAACAATGAGACACCAGGGATTAGATATCAGTACAATGTGCTTCCACAGGGATGGAAAGGATCACCAGCAATATTCCAAAGTAGCATGACAAAAATCTTAGAGCCTTTTAGAAAACAAAATCCAGACATAGTTATCTATCAATACATGGATGATTTGTATGTAGGATCTGACTTAGAAATAGGGCAGCATAGAACAAAAATAGAGGAGCTGAGACAACATCTGTTGAGGTGGGGACTTACCACACCAGACAAAAAACATCAGAAAGAACCTCCATTCCTTTGGATGGGTTATGAACTCCATCCTGATAAATGGACAGTACAGCCTATAGTGCTGCCAGAAAAAGACAGCTGGACTGTCAATGACATACAGAAGTTAGTGGGGAAATTGAATTGGGCAAGTCAGATTTACCCAGGGATTAAAGTAAGGCAATTATGTAAACTCCTTAGAGGAACCAAAGCACTAACAGAAGTAATACCACTAACAGAAGAAGCAGAGCTAGAACTGGCAGAAAACAGAGAGATTCTAAAAGAACCAGTACATGGAGTGTATTATGACCCATCAAAAGACTTAATAGCAGAAATACAGAAGCAGGGGCAAGGCCAATGGACATATCAAATTTATCAAGAGCCATTTAAAAATCTGAAAACAGGAAAATATGCAAGAATGAGGGGTGCCCACACTAATGATGTAAAACAATTAACAGAGGCAGTGCAAAAAATAACCACAGAAAGCATAGTAATATGGGGAAAGACTCCTAAATTTAAACTGCCCATACAAAAGGAAACATGGGAAACATGGTGGACAGAGTATTGGCAAGCCACCTGGATTCCTGAGTGGGAGTTTGTTAATACCCCTCCCTTAGTGAAATTATGGTACCAGTTAGAGAAAGAACCCATAGTAGGAGCAGAAACCTTC
	'B_US_83_RF_ACC_M17451'       CCCATTAGTCCTATTGAAACTGTACCAGTAAAATTAAAGCCAGGAATGGATGGCCCAAAAGTTAAACAATGGCCATTGACAGAGGAAAAAATAAAAGCATTGGTAGAAATTTGTACAGAAATGGAAAAGGAAGGAAAAATTTCCAAAATTGGGCCTGAAAATCCATACAATACTCCAGTATTTGCCATAAAGAAAAAAGACAGTACTAAATGGAGAAAATTAGTAGATTTCAGAGAACTTAATAAGAGAACTCAAGACTTCTGGGAAGTTCAGTTAGGAATACCACATCCTGCAGGGTTAAAAAAGAAGAAATCAGTAACAGTATTGGATGTGGGTGATGCATATTTTTCAGTTCCCTTAGATAAAGAGTTCAGGAAGTATACTGCATTTACCATACCTAGTATAAACAATGAAACACCACGGATTAGATATCAGTACAATGTGCTTCCACAAGGGTGGAAAGGATCACCAGCAATATTCCAAAGTAGTATGACAAAAATCTTAGAGCCTTTTAAAAAACAAAATCCAGAAATAGTTATCTATCAATACATGGATGATTTGTATGTAGGATCTGATTTAGAAATAGGGCAGCATAGAATAAAAATAGAGGAACTGAGAGAACATCTGTTAAAGTGGGGGTTTACCACACCGGACAAGAAACATCAGAAAGAACCTCCATTTCTTTGGATGGGTTATGAACTCCATCCTGATAAATGGACAGTACAGCCTATAGTGCTGCCAGAAAAAGACAGCTGGACTGTCAATGACATACAGAAGTTAGTGGGAAAATTGAATTGGGCAAGTCAGATTTATGCAGGGATTAAAGTAAAGCAATTATGTAAACTCCTTAGGGGAACCAAAGCACTAACAGAAGTAGTACAACTAACAAAAGAAGCAGAGCTAGAACTGGCAGAAAATAGGGAGATTCTAAAAGAACCAGTACATGGAGTGTATTATGACCCATCAAAAGACTTAATAGCAGAAATACAGAAGCAGGGGCAAGGCCAATGGACATACCAAATTTATCAAGAGCCATTTAAAAACCTGAAAACAGGAAAGTATGCAAGAATGAGGGGTGCCCACACTAATGATGTAAAACAATTAACAGAGGCAGTACAAAAAGTAGCCACAGAAAGCATAGTAATATGGGGAAAGACTCCTAAATTTAAACTACCCATACAAAAAGAAACATGGGAGGCATGGTGGACAGAGTATTGGCAAGCCACCTGGATTCCTGAGTGGGAGTTTGTCAATACCCCTCCCTTAGTAAAATTGTGGTACCAGTTAGAAAAAGAACCCATAATAGGAGCAGAAACTTTC
	'B_US_86_JRFL_ACC_U63632'     CCCATTAGTCCTATTGAAACTGTACCAGTAAAATTAAAGCCAGGAATGGATGGCCCAAAAGTCAAACAATGGCCATTGACAGAAGAAAAAATAAAAGCATTAGTAGAAATTTGTACAGAAATGGAAAAGGAAGGGAAAATTTCAAAAATTGGGCCTGAAAATCCATACAATACTCCAGTATTTGCCATAAAGAAAAAGGACAGTACTAAATGGAGAAAATTAGTAGATTTCAGAGAACTTAATAAGAAAACTCAAGACTTCTGGGAAGTTCAATTAGGAATACCACATCCCGCAGGGTTAAAAAAGAGAAAATCAGTAACAGTACTGGATGTGGGTGATGCATATTTTTCAGTTCCCTTAGATAAAGACTTCAGGAAATATACTGCATTTACCATACCTAGTATAAACAATGAGACACCAGGGATTAGGTATCAGTACAATGTGCTTCCGCAGGGATGGAAAGGATCACCAGCAATATTCCAAAGTAGCATGACAAAAATCTTAGAGCCTTTTAGAAAACAAAATCCAGACATAATTATCTATCAATACATGGATGATTTGTATGTAGGATCTGACTTAGAGATAGGGCAGCATAGAGCAAAAATAGAGGAATTGAGACAACATCTGTTGAGGTGGGGGTTTACCACACCAGACAAAAAACATCAGAAAGAACCTCCATTCCTTTGGATGGGTTATGAACTCCATCCTGACAAATGGACAGTACAGCCTATAGTGCTGCCAGAAAAAGACAGCTGGACTGTCAATGACATACAGAAGTTAGTGGGAAAATTAAATTGGGCAAGTCAGATTTACGCAGGGATTAAAGTAAAGCAATTATGTAAACTCCTTAGGGGAACCAAAGCACTAACAGAAGTAATACCACTAACAGAAGAAGCAGAGCTAGAACTGGCAGAAAACAGGGAGATTCTAAAAGAGCCAGTACATGGAGTGTATTATGACCCATCAAAAGACTTAATAGCAGAACTACAGAAGCAGGGGCAAGGCCAATGGACATATCAAATTTATCAAGAGCCATTTAAAATTCTGAAAACAGGAAAATATGCAAGAACGAGGGGTGCCCACACTAATGATGTAAAACAATTAACAGAGGCAGTGCAAAAAATAGCCAATGAAAGCATAGTAATATGGGGAAAGATTCCTAAATTTAAATTACCCATACAAAAAGAAACATGGGAAACATGGTGGACAGAGTATTGGCAAGCCACCTGGATTCCTGAGTGGGAGTTTGTCAATACCCCTCCCTTAGTGAAATTATGGTACCAGTTAGAGAAAGAACCCATAGTAGGAGCAGAAACTTTC
	'B_US_90_WEAU160_ACC_U21135'  CCCATTAGTCCTATTGAAACTGTACCAGTAAAATTAAAGCCAGGAATGGATGGCCCAAAAGTTAAACAATGGCCATTGACAGAAGAGAAAATAAAAGCATTAGTAGAAATTTGTACAGAAATGGAAAAGGAAGGAAAAATTTCAAAAATTGGGCCTGAAAATCCATATAATACTCCAGTATTTGCCATAAAGAAAAAAGACAGTACTAAATGGAGAAAATTAGTAGATTTCAGAGAACTTAATAAGAGAACTCAAGACTTCTGGGAAGTTCAATTAGGAATACCACATCCTTCAGGGTTAAAAAAGAAAAAATCAGTAACAGTACTGGATGTGGGTGATGCATATTTTTCAGTACCCTTAGATGAAGACTTCAGGAAGTACACTGCATTTACCATACCTAGTATAAACAATGAAACACCAGGGATTAGATATCAGTACAATGTGCTTCCACAGGGATGGAAAGGATCACCAGCAATATTCCAAAGTAGCATGACAAAAATATTAGAGCCTTTTAGAAAACAAAATCCAGACATAGTTATCTATCAATACATGGATGATTTGTATGTAGGATCTGACTTAGAAATAGGGCAGCATAGAACAAAAATAGAGGAGCTGAGACAACATCTGTTGAGGTGGGGATTTACCACACCAGACAAAAAACATCAAAAAGACCCTCCATTCCTTTGGATGGGTTATGAACTCCATCCTGATAAATGGACAGTACAGCCTATAAAGCTGCCAGAAAAAGAAAGTTGGACTGTCAATGACATACAGAAGTTAGTGGGAAAATTGAATTGGGCAAGTCAGATTTACGCAGGGATTAAAGTAAAGCAACTATGTAAACTCCTTAGGGGGACCAAAGCACTAACAGAAATAATACCAATAACAGAAGAAGCAGAGCTAGAGCTGGCAGAAAACAGGGAAATTCTAAAAGAACCGGTACATGGAGTGTATTATGACCCATCAAAAGACTTAATAGCAGAGCTACAGAAGCAGGGGCAAGGCCAATGGACATATCAGATTTATCAAGAGCCATTTAAAAATCTGAAAACAGGAAAGTATGCAAGAGTGAGGGGTGCCCACACTAATGATGTAAAACAATTAACAGAGGCAGTGCAGAAAATAACCACAGAAAGCATAGTAATATGGGGAAAGACTCCTAAATTTAAACTACCCATACAAAAAGAAACATGGGAAACATGGTGGACAGAGTATTGGCAAGCCACCTGGATTCCTGAGTGGGAGTTTGTCAATACCCCTCCCTTAGTGAAATTATGGTATCAGTTAGAGAAAGAACCCATAGTAGGAGCAGAAACTTTC
	'D_CD_83_ELI_ACC_K03454'      CCAATTAGTCCTATTGAAACTGTACCAGTAAAATTAAAGCCAGGAATGGATGGCCCAAAAGTTAAACAATGGCCATTGACAGAAGAAAAAATAAAAGCATTAACAGAAATTTGTACAGATATGGAAAAGGAAGGAAAAATTTCAAGAATTGGGCCTGAAAATCCATACAATACTCCAATATTTGCCATAAAGAAAAAAGACAGTACCAAGTGGAGAAAATTAGTAGATTTCAGAGAACTTAATAAGAGAACTCAAGATTTCTGGGAAGTTCAATTAGGAATACCGCATCCTGCAGGGCTGAAAAAGAAAAAATCAGTAACAGTACTGGATGTGGGTGATGCATATTTTTCAGTTCCCTTAGATGAAGATTTTAGGAAATATACCGCCTTTACCATATCTAGTATAAACAATGAGACACCAGGGATTAGATATCAGTACAATGTGCTTCCACAGGGATGGAAAGGATCACCGGCAATATTCCAAAGTAGCATGACAAAAATCTTAGAGCCCTTTAGAAAACAAAATCCAGAAATGGTTATCTATCAATACATGGATGATTTGTATGTAGGATCTGACTTAGAAATAGGGCAGCATAGGACAAAAATAGAGAAATTAAGAGAACATCTATTGAGGTGGGGATTTACCAGACCAGATAAAAAACATCAGAAAGAACCCCCATTTCTTTGGATGGGTTATGAACTCCATCCTGATAAATGGACAGTACAGTCTATAAAACTGCCAGAAAAGGAGAGCTGGACTGTCAATGATATACAGAACTTAGTGGAGAGATTAAACTGGGCAAGCCAGATTTATCCAGGAATTAAAGTAAGACAATTATGTAAACTCCTTAGGGGAACCAAAGCACTAACAGAAGTAATACCACTAACAGAAGAAGCAGAATTAGAACTGGCAGAAAACAGGGAAATTTTAAAAGAACCAGTACATGGAGTGTATTATGACCCATCAAAAGACTTAATAGCAGAAATACAGAAACAAGGGCACGGCCAATGGACATACCAAATTTATCAAGAACCATTTAAAAATCTGAAAACAGGAAAGTATGCAAGAATGAGGGGTGCCCACACTAATGATGTAAAGCAATTAGCAGAGGCAGTGCAAAGAATATCCACAGAAAGCATAGTGATATGGGGAAGGACTCCTAAATTTAGACTACCCATACAAAAGGAAACATGGGAAACATGGTGGGCAGAGTATTGGCAAGCCACTTGGATTCCTGAGTGGGAATTTGTCAATACCCCTCCTTTAGTAAAATTATGGTACCAGTTAGAGAAGGAACCCATAATAGGAGCAGAAACTTTC
	'D_CD_83_NDK_ACC_M27323'      CCAATTAGTCCTATTGAAACTGTACCAGTAAAATTAAAGCCAGGAATGGATGGCCCAAAAGTTAAACAATGGCCATTGACAGAAGAAAAAATAAAAGCATTAACAGAAATTTGTACAGAAATGGAAAAGGAAGGAAAAATTTCAAGAATTGGGCCTGAAAATCCATATAATACTCCAATATTTGCCATAAAGAAAAAAGACAGTACCAAGTGGAGAAAATTAGTAGATTTCAGAGAACTTAATAAGAGAACTCAAGATTTCTGGGAGGTTCAATTAGGAATACCGCATCCTGCAGGGCTGAAAAAGAAAAAATCAGTAACAGTACTGGATGTGGGTGATGCATATTTCTCAGTTCCCTTAGATGAAGATTTTAGGAAATATACCGCATTTACCATACCTAGTATAAACAATGAGACACCAGGGATTAGATATCAGTACAATGTGCTCCCACAGGGATGGAAAGGATCACCGGCAATATTCCAAAGTAGCATGACAAAAATCTTAGAGCCCTTTAGAAAACAAAATCCAGAAATAGTTATCTATCAATACATGGATGATTTGTATGTAGGATCTGACTTAGAAATAGGGCAGCATAGAACAAAAATAGAGGAATTAAGAGAACATCTATTGAGGTGGGGATTTACCACACCAGATAAAAAACATCAGAAAGAACCTCCATTTCTTTGGATGGGTTATGAACTCCATCCTGATAAATGGACAGTACAGCCTATAAACCTGCCAGAAAAAGAAAGCTGGACTGTCAATGATATACAGAAGTTAGTGGGGAAATTAAACTGGGCAAGCCAGATTTATGCAGGAATTAAAGTAAAGCAATTATGTAAACTCCTTAGGGGAACCAAAGCACTAACAGAAGTAGTACCACTAACAGAAGAAGCAGAATTAGAACTGGCAGAAAACAGGGAAATTCTAAAAGAACCAGTACATGGAGTGTATTATGACCCATCAAAAGACTTAATAGCAGAACTACAGAAACAAGGGGACGGCCAATGGACATACCAAATTTATCAAGAACCATTTAAAAATCTAAAAACAGGAAAGTATGCAAGAACGAGGGGTGCCCACACTAATGATGTAAAACAATTAACAGAGGCAGTGCAAAAAATAGCCACAGAAAGCATAGTGATATGGGGAAAGACTCCTAAATTTAAACTACCCATACAAAAGGAAACATGGGAAACATGGTGGATAGAGTATTGGCAAGCCACCTGGATTCCTGAGTGGGAATTTGTCAATACCCCTCCTTTAGTAAAATTATGGTACCAGTTAGAGAAGGAACCCATAATAGGAGCAGAAACTTTC
	'D_CD_84_84ZR085_ACC_U88822'  CCAATTAGTCCTATTGAAACTGTACCAGTAAAATTAAAGCCAGGAATGGATGGCCCAAAAGTTAAACAATGGCCGTTGACAGAAGAAAAAATAAAAGCATTAACAGAAATTTGTACAGATATGGAAAAGGAAGGAAAAATTTCAAGAATTGGGCCTGAAAATCCATACAATACTCCAATATTTGCCATAAAGAAAAAAGACAGTACTAAGTGGAGAAAATTAGTAGATTTCAGAGAACTTAATAAGAGAACTCAAGACTTCTGGGAAGTTCAATTAGGGATACCACATCCTGCAGGATTAAAGAAGAAAAAGTCAATAACAGTACTGGATGTGGGCGATGCATATTTTTCAATTCCCTTATGTGAAGACTTTAGGAAGTACACTGCATTTACCATACCTAGTATAAACAATGAGACACCAGGGATTAGATATCAGTACAATGTACTTCCACAGGGATGGAAAGGATCACCAGCAATATTCCAAAGTAGCATGATAAAAATCTTAGAGCCCTTTAGAAAACAAAATCCAGAAGTAGTTATCTATCAATACATGGATGATTTGTATGTAGGATCTGATTTAGAAATAGGACAGCATAGAGCAAAAATAGAGAAATTAAGAGAACATCTGTTGAGGTGGGGGCTTACCACACCAGACAAAAAACATCAGAAAGAACCTCCATTTCTTTGGATGGGTTATGAACTCCATCCTGATAAGTGGACAGTACAGTCTATAACACTGCCAGAGAAAGAAAGCTGGACTGTCAATGATATACAGAAGTTAGTGGGAAAATTAAATTGGGCAAGCCAGATTTATCCAGGAATTAAAGTAAAGCAATTATGTAAACTCCTTAGGGGAACCAAGGCACTAACAGAGGTAATACCACTAACAGAAGAAGCAGAATTAGAACTGGCAGAAAACAGGGAGATTCTAAAGGAACCAATGCATGGAGTGTATTATGACCCATCAAAAGACTTAATAGCAGAATTACAGAAACAAGGGCAAGGTCAATGGACATATCAAATTTATCAAGAACCATTTAAAAATCTGAAAACAGGAAAGTATGCAAGAATGAGGGGTGCCCACACTAATGATGTAAAACAGTTAACAGAGGCAGTGCAAAAAATAGCCATAGAAAGCATAGTGATATGGGGAAAGACTCCTAAATTTAGACTACCCATACAAAAGGAAACATGGGAAACATGGTGGATAGACTATTGGCAAGCCACCTGGATTCCTGAGTGGGAATTTGTCAATACCCCTCCTTTAGTAAAATTATGGTACCAGTTAGAGAAGGAACCCATAATAGGAGCAGAAACTTTC
	'D_UG_94_94UG114_ACC_U88824'  CCAATTAGTCCTATTGAAACTGTACCAGTAAAATTAAAGCCAGGGATGGATGGCCCAAAAGTTAAACAATGGCCGTTGACAGAAGAAAAAATAAAAGCACTAATAGAAATTTGTTCAGAACTAGAAAAGGAAGGAAAAATTTCAAAAATTGGGCCTGAAAACCCATACAATACTCCAATATTTGCCATAAAGAAAAAAGACAGTACTAAGTGGAGAAAATTAGTAGATTTCAGAGAACTTAATAAGAGAACTCAAGACTTTTGGGAAGTTCAACTAGGAATACCACATCCTGCAGGGCTAAAAAAGAAAAAATCAGTAACAGTACTGGATGTGGGTGACGCATATTTTTCAGTTCCCTTACATGAAGACTTTAGAAAATATACCGCATTCACCATACCTAGTACAAACAATGAGACACCAGGAATTAGATATCAGTACAATGTGCTTCCACAAGGATGGAAAGGATCACCAGCAATATTCCAAAGTAGCATGACAAAAATCTTAGAACCTTTTAGAAAACAAAATCCAGAAATGATTATCTATCAATACATGGATGATTTGTATGTAGGATCTGACTTAGAAATAGGGCAGCATAGAATAAAAATAGAGGAATTAAGGGGACACCTCTTGAAGTGGGGATTTACCACACCAGACAAAAAGTATCAGAAAGAACCCCCATTTCTTTGGATGGGTTATGAACTCCATCCTGATAAGTGGACAGTACAGCCTATACATCTGCCAGAAAAGGAAAGCTGGACTGTCAATGATATACAGAAGTTAGTGGGAAAATTAAATTGGGCAAGCCAGATTTATCCAGGAATTAAAGTAAGACAATTATGCAAATGCCTTAGGGGAGCCAAAGCACTGACAGAAGTAATACCACTGACAGCAGAAGCAGAATTAGAACTGGCAGAAAACAGGGAAATACTAAAAGAACCAGTACATGGAGCGTATTATGACCCATCAAAAGACTTAATAGCAGAAATACAGAAACAAGGGCAAGATCAATGGACATATCAAATATATCAAGAACAATATAAAAATCTGAAAACAGGAAAGTATGCGAAAATGAGGGGTACCCACACTAATGATGTAAAACAATTAACAGAGGCAGTGCAGAAAATAGCCCAAGAATGTATAGTAATATGGGGAAAGACTCCTAAATTTAGACTACCCATACAAAAGGAAACATGGGAAACATGGTGGACAGAGTATTGGCAGGCCACCTGGATTCCTGAGTGGGAGTATGTCAACACCCCTCCTTTAGTTAAATTATGGTATCAGTTAGAGAAGGAACCCATAGTAGGAGCAGAAACTTTC;
END;

BEGIN TREES;
	TREE tree = ((((D_CD_83_ELI_ACC_K03454,D_CD_83_NDK_ACC_M27323),D_UG_94_94UG114_ACC_U88824),D_CD_84_84ZR085_ACC_U88822),B_US_83_RF_ACC_M17451,((B_FR_83_HXB2_ACC_K03455,B_US_86_JRFL_ACC_U63632),B_US_90_WEAU160_ACC_U21135));
END;

BEGIN HYPHY;

/* test preamble */

	_testDescription 		= " fit the HKY+gamma model to an HIV-1 RT (p51) alignment with 8 sequences and 1320 nucleotides and perform marginal site-by-site reconstruction";
	_expectedLL 			= -3286.0978773303;
	ExecuteAFile 			("../Shared/TestInstrumentation.bf");
	startTestTimer 			(_testDescription);

/* end test preamble */

global SmallCodon_part_Shared_TVTS=1;
global SmallCodon_part_Shape=0.5;
SmallCodon_part_Shape:>0.01;
SmallCodon_part_Shape:<100;
SmallCodon_part_Categ.weights={
{              0.25}
{              0.25}
{              0.25}
{              0.25}
}
;


category SmallCodon_part_Categ=(4,SmallCodon_part_Categ.weights,MEAN,GammaDist(_x_,SmallCodon_part_Shape,SmallCodon_part_Shape),CGammaDist(_x_,SmallCodon_part_Shape,SmallCodon_part_Shape),0,1e+25,CGammaDist(_x_,SmallCodon_part_Shape+1,SmallCodon_part_Shape));
SmallCodon_part_HKY85={4,4};
SmallCodon_part_HKY85[0][1]:=t*SmallCodon_part_Shared_TVTS*SmallCodon_part_Categ;
SmallCodon_part_HKY85[0][2]:=t*SmallCodon_part_Categ;
SmallCodon_part_HKY85[0][3]:=t*SmallCodon_part_Shared_TVTS*SmallCodon_part_Categ;
SmallCodon_part_HKY85[1][0]:=t*SmallCodon_part_Shared_TVTS*SmallCodon_part_Categ;
SmallCodon_part_HKY85[1][2]:=t*SmallCodon_part_Shared_TVTS*SmallCodon_part_Categ;
SmallCodon_part_HKY85[1][3]:=t*SmallCodon_part_Categ;
SmallCodon_part_HKY85[2][0]:=t*SmallCodon_part_Categ;
SmallCodon_part_HKY85[2][1]:=t*SmallCodon_part_Shared_TVTS*SmallCodon_part_Categ;
SmallCodon_part_HKY85[2][3]:=t*SmallCodon_part_Shared_TVTS*SmallCodon_part_Categ;
SmallCodon_part_HKY85[3][0]:=t*SmallCodon_part_Shared_TVTS*SmallCodon_part_Categ;
SmallCodon_part_HKY85[3][1]:=t*SmallCodon_part_Categ;
SmallCodon_part_HKY85[3][2]:=t*SmallCodon_part_Shared_TVTS*SmallCodon_part_Categ;

SmallCodon_part_Freqs={
{    0.404450757576}
{    0.166287878788}
{    0.209564393939}
{    0.219696969697}
}
;
Model SmallCodon_part_HKY85_model=(SmallCodon_part_HKY85,SmallCodon_part_Freqs);

UseModel (SmallCodon_part_HKY85_model);
Tree SmallCodon_tree=((((D_CD_83_ELI_ACC_K03454,D_CD_83_NDK_ACC_M27323)Node3,D_UG_94_94UG114_ACC_U88824)Node2,D_CD_84_84ZR085_ACC_U88822)Node1,B_US_83_RF_ACC_M17451,((B_FR_83_HXB2_ACC_K03455,B_US_86_JRFL_ACC_U63632)Node10,B_US_90_WEAU160_ACC_U21135)Node9);

SmallCodon_tree.Node2.t=0;
SmallCodon_tree.D_CD_83_ELI_ACC_K03454.t=0;
SmallCodon_tree.D_UG_94_94UG114_ACC_U88824.t=0;
SmallCodon_tree.Node1.t=0;
SmallCodon_tree.D_CD_84_84ZR085_ACC_U88822.t=0;
SmallCodon_tree.D_CD_83_NDK_ACC_M27323.t=0;
SmallCodon_tree.Node3.t=0;
SmallCodon_tree.B_US_83_RF_ACC_M17451.t=0;
SmallCodon_tree.B_FR_83_HXB2_ACC_K03455.t=0;
SmallCodon_tree.B_US_86_JRFL_ACC_U63632.t=0;
SmallCodon_tree.Node10.t=0;
SmallCodon_tree.B_US_90_WEAU160_ACC_U21135.t=0;
SmallCodon_tree.Node9.t=0;
DataSet SmallCodon = ReadDataFile(USE_NEXUS_FILE_DATA);

DataSetFilter SmallCodon_part = CreateFilter(SmallCodon,1,"","4,5,7,6,1,0,2,3");
LikelihoodFunction SmallCodon_LF = (SmallCodon_part,SmallCodon_tree);

AUTO_PARALLELIZE_OPTIMIZE = 3;
OPTIMIZATION_PRECISION    = 0.001;

Optimize(res_SmallCodon_LF,SmallCodon_LF);


expectedConditionalProbabilities =
{
{    0.166238705839,    0.164203697858,    0.148535535877,   0.0702168402446}
{    0.166238705839,    0.164203697858,    0.148535535877,   0.0702168402446}
{ 7.38658166722e-07, 3.11860538125e-05,  0.00025731587261,  0.00109420284125}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{    0.219644366738,     0.21746500173,    0.200520523252,    0.109793534398}
{    0.219644366738,     0.21746500173,    0.200520523252,    0.109793534398}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{    0.209466628291,    0.205435979931,    0.175419907202,   0.0547630843276}
{ 1.83661195511e-06, 7.75805035614e-05, 0.000642558662221,  0.00276510223348}
{    0.166238705839,    0.164203697858,    0.148535535877,   0.0702168402446}
{    0.166238705839,    0.164203697858,    0.148535535877,   0.0702168402446}
{    0.219644366738,     0.21746500173,    0.200520523252,    0.109793534398}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{    0.219644366738,     0.21746500173,    0.200520523252,    0.109793534398}
{    0.219644366738,     0.21746500173,    0.200520523252,    0.109793534398}
{    0.209466628291,    0.205435979931,    0.175419907202,   0.0547630843276}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{ 4.26094355493e-06, 0.000179813528012,  0.00147831910146,  0.00618625232335}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{    0.166238705839,    0.164203697858,    0.148535535877,   0.0702168402446}
{    0.219644366738,     0.21746500173,    0.200520523252,    0.109793534398}
{    0.209466628291,    0.205435979931,    0.175419907202,   0.0547630843276}
{    0.219644366738,     0.21746500173,    0.200520523252,    0.109793534398}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{    0.166238705839,    0.164203697858,    0.148535535877,   0.0702168402446}
{    0.166238705839,    0.164203697858,    0.148535535877,   0.0702168402446}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{    0.209466628291,    0.205435979931,    0.175419907202,   0.0547630843276}
{    0.219644366738,     0.21746500173,    0.200520523252,    0.109793534398}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{    0.219644366738,     0.21746500173,    0.200520523252,    0.109793534398}
{    0.219644366738,     0.21746500173,    0.200520523252,    0.109793534398}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{    0.209466628291,    0.205435979931,    0.175419907202,   0.0547630843276}
{    0.166238705839,    0.164203697858,    0.148535535877,   0.0702168402446}
{    0.166238705839,    0.164203697858,    0.148535535877,   0.0702168402446}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{    0.209466628291,    0.205435979931,    0.175419907202,   0.0547630843276}
{    0.209466628291,    0.205435979931,    0.175419907202,   0.0547630843276}
{ 2.21580726116e-05, 0.000934146944386,  0.00761592498171,   0.0294481352427}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{    0.219644366738,     0.21746500173,    0.200520523252,    0.109793534398}
{    0.209466628291,    0.205435979931,    0.175419907202,   0.0547630843276}
{    0.209466628291,    0.205435979931,    0.175419907202,   0.0547630843276}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{    0.219644366738,     0.21746500173,    0.200520523252,    0.109793534398}
{    0.209466628291,    0.205435979931,    0.175419907202,   0.0547630843276}
{    0.209466628291,    0.205435979931,    0.175419907202,   0.0547630843276}
{    0.166238705839,    0.164203697858,    0.148535535877,   0.0702168402446}
{    0.166238705839,    0.164203697858,    0.148535535877,   0.0702168402446}
{    0.166238705839,    0.164203697858,    0.148535535877,   0.0702168402446}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{    0.209466628291,    0.205435979931,    0.175419907202,   0.0547630843276}
{    0.219644366738,     0.21746500173,    0.200520523252,    0.109793534398}
{ 2.79624651168e-06, 0.000118106492323, 0.000977521826166,  0.00417921511147}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{    0.166238705839,    0.164203697858,    0.148535535877,   0.0702168402446}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{    0.219644366738,     0.21746500173,    0.200520523252,    0.109793534398}
{    0.209466628291,    0.205435979931,    0.175419907202,   0.0547630843276}
{    0.209466628291,    0.205435979931,    0.175419907202,   0.0547630843276}
{    0.166238705839,    0.164203697858,    0.148535535877,   0.0702168402446}
{    0.166238705839,    0.164203697858,    0.148535535877,   0.0702168402446}
{ 7.88847971872e-10, 1.41796625714e-06, 0.000103290486744,  0.00299568594427}
{    0.219644366738,     0.21746500173,    0.200520523252,    0.109793534398}
{    0.219644366738,     0.21746500173,    0.200520523252,    0.109793534398}
{    0.209466628291,    0.205435979931,    0.175419907202,   0.0547630843276}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{    0.166238705839,    0.164203697858,    0.148535535877,   0.0702168402446}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{    0.209466628291,    0.205435979931,    0.175419907202,   0.0547630843276}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{ 1.02019455151e-05,  0.00043045265715,  0.00353362917585,    0.014508561498}
{    0.209466628291,    0.205435979931,    0.175419907202,   0.0547630843276}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{ 7.69864375107e-06, 0.000324780097948,  0.00266296785967,   0.0108781605597}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{    0.219644366738,     0.21746500173,    0.200520523252,    0.109793534398}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{    0.209466628291,    0.205435979931,    0.175419907202,   0.0547630843276}
{    0.166238705839,    0.164203697858,    0.148535535877,   0.0702168402446}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{ 9.55104590897e-06, 0.000403328269813,  0.00333221475702,   0.0139772453133}
{    0.219644366738,     0.21746500173,    0.200520523252,    0.109793534398}
{ 1.02019455151e-05,  0.00043045265715,  0.00353362917585,    0.014508561498}
{ 9.38186261623e-06, 0.000394741564219,  0.00316804707249,   0.0111107216435}
{ 2.70756352035e-10, 4.87582062747e-07, 3.60435524331e-05,  0.00115070853772}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{    0.209466628291,    0.205435979931,    0.175419907202,   0.0547630843276}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{    0.219644366738,     0.21746500173,    0.200520523252,    0.109793534398}
{    0.219644366738,     0.21746500173,    0.200520523252,    0.109793534398}
{    0.219644366738,     0.21746500173,    0.200520523252,    0.109793534398}
{    0.209466628291,    0.205435979931,    0.175419907202,   0.0547630843276}
{    0.219644366738,     0.21746500173,    0.200520523252,    0.109793534398}
{ 2.30487308997e-06, 9.74776307459e-05, 0.000815382916642,  0.00379977662246}
{    0.166238705839,    0.164203697858,    0.148535535877,   0.0702168402446}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{    0.209466628291,    0.205435979931,    0.175419907202,   0.0547630843276}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{ 2.25346531639e-17,  1.7345720108e-12, 1.16999990872e-09, 3.42991187508e-07}
{ 1.74455049396e-06, 7.37804825819e-05, 0.000617160517941,  0.00287603782287}
{    0.219644366738,     0.21746500173,    0.200520523252,    0.109793534398}
{ 2.21546415155e-05, 0.000927995234234,  0.00717699579814,    0.018486850731}
{    0.209466628291,    0.205435979931,    0.175419907202,   0.0547630843276}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{    0.209466628291,    0.205435979931,    0.175419907202,   0.0547630843276}
{    0.209466628291,    0.205435979931,    0.175419907202,   0.0547630843276}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{    0.209466628291,    0.205435979931,    0.175419907202,   0.0547630843276}
{    0.209466628291,    0.205435979931,    0.175419907202,   0.0547630843276}
{  6.2870984938e-07,  2.6731172332e-05, 0.000233761242124,  0.00154653710575}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{    0.219644366738,     0.21746500173,    0.200520523252,    0.109793534398}
{    0.219644366738,     0.21746500173,    0.200520523252,    0.109793534398}
{    0.219644366738,     0.21746500173,    0.200520523252,    0.109793534398}
{    0.166238705839,    0.164203697858,    0.148535535877,   0.0702168402446}
{ 8.03182216087e-07, 3.39296336015e-05, 0.000281284579091,  0.00124487616694}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{ 1.10457535612e-09, 1.98206712799e-06, 0.000142364455313,  0.00371357194388}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{    0.219644366738,     0.21746500173,    0.200520523252,    0.109793534398}
{    0.219644366738,     0.21746500173,    0.200520523252,    0.109793534398}
{    0.209466628291,    0.205435979931,    0.175419907202,   0.0547630843276}
{    0.209466628291,    0.205435979931,    0.175419907202,   0.0547630843276}
{    0.209466628291,    0.205435979931,    0.175419907202,   0.0547630843276}
{    0.166238705839,    0.164203697858,    0.148535535877,   0.0702168402446}
{    0.166238705839,    0.164203697858,    0.148535535877,   0.0702168402446}
{    0.219644366738,     0.21746500173,    0.200520523252,    0.109793534398}
{    0.209466628291,    0.205435979931,    0.175419907202,   0.0547630843276}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{ 9.55104590897e-06, 0.000403328269813,  0.00333221475702,   0.0139772453133}
{    0.166238705839,    0.164203697858,    0.148535535877,   0.0702168402446}
{    0.166238705839,    0.164203697858,    0.148535535877,   0.0702168402446}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{    0.219644366738,     0.21746500173,    0.200520523252,    0.109793534398}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{ 2.98802423149e-11, 5.37651121173e-08,  3.9486661381e-06,  0.00012088071666}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{    0.219644366738,     0.21746500173,    0.200520523252,    0.109793534398}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{    0.166238705839,    0.164203697858,    0.148535535877,   0.0702168402446}
{    0.219644366738,     0.21746500173,    0.200520523252,    0.109793534398}
{    0.166238705839,    0.164203697858,    0.148535535877,   0.0702168402446}
{    0.166238705839,    0.164203697858,    0.148535535877,   0.0702168402446}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{ 9.38186261623e-06, 0.000394741564219,  0.00316804707249,   0.0111107216435}
{    0.219644366738,     0.21746500173,    0.200520523252,    0.109793534398}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{    0.219644366738,     0.21746500173,    0.200520523252,    0.109793534398}
{    0.219644366738,     0.21746500173,    0.200520523252,    0.109793534398}
{    0.219644366738,     0.21746500173,    0.200520523252,    0.109793534398}
{    0.209466628291,    0.205435979931,    0.175419907202,   0.0547630843276}
{    0.166238705839,    0.164203697858,    0.148535535877,   0.0702168402446}
{    0.166238705839,    0.164203697858,    0.148535535877,   0.0702168402446}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{    0.219644366738,     0.21746500173,    0.200520523252,    0.109793534398}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{    0.209466628291,    0.205435979931,    0.175419907202,   0.0547630843276}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{ 6.48727777487e-06, 0.000273707326406,  0.00224624497732,  0.00923816223587}
{    0.209466628291,    0.205435979931,    0.175419907202,   0.0547630843276}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{    0.166238705839,    0.164203697858,    0.148535535877,   0.0702168402446}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{    0.209466628291,    0.205435979931,    0.175419907202,   0.0547630843276}
{    0.219644366738,     0.21746500173,    0.200520523252,    0.109793534398}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{    0.166238705839,    0.164203697858,    0.148535535877,   0.0702168402446}
{ 1.77487499003e-06, 7.50246822393e-05, 0.000625179517055,  0.00287728854194}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{ 9.38148581793e-06, 0.000394064486396,   0.0031188816339,  0.00975455935601}
{    0.219644366738,     0.21746500173,    0.200520523252,    0.109793534398}
{    0.209466628291,    0.205435979931,    0.175419907202,   0.0547630843276}
{    0.209466628291,    0.205435979931,    0.175419907202,   0.0547630843276}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{    0.209466628291,    0.205435979931,    0.175419907202,   0.0547630843276}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{    0.219644366738,     0.21746500173,    0.200520523252,    0.109793534398}
{    0.219644366738,     0.21746500173,    0.200520523252,    0.109793534398}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{    0.209466628291,    0.205435979931,    0.175419907202,   0.0547630843276}
{    0.219644366738,     0.21746500173,    0.200520523252,    0.109793534398}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{    0.209466628291,    0.205435979931,    0.175419907202,   0.0547630843276}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{    0.219644366738,     0.21746500173,    0.200520523252,    0.109793534398}
{    0.219644366738,     0.21746500173,    0.200520523252,    0.109793534398}
{    0.219644366738,     0.21746500173,    0.200520523252,    0.109793534398}
{    0.166238705839,    0.164203697858,    0.148535535877,   0.0702168402446}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{    0.209466628291,    0.205435979931,    0.175419907202,   0.0547630843276}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{    0.209466628291,    0.205435979931,    0.175419907202,   0.0547630843276}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{    0.166238705839,    0.164203697858,    0.148535535877,   0.0702168402446}
{    0.219644366738,     0.21746500173,    0.200520523252,    0.109793534398}
{    0.219644366738,     0.21746500173,    0.200520523252,    0.109793534398}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{    0.219644366738,     0.21746500173,    0.200520523252,    0.109793534398}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{    0.209466628291,    0.205435979931,    0.175419907202,   0.0547630843276}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{ 6.48603603158e-06, 0.000271481039546,  0.00208739930959,  0.00521107241223}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{    0.166238705839,    0.164203697858,    0.148535535877,   0.0702168402446}
{    0.219644366738,     0.21746500173,    0.200520523252,    0.109793534398}
{    0.166238705839,    0.164203697858,    0.148535535877,   0.0702168402446}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{    0.209466628291,    0.205435979931,    0.175419907202,   0.0547630843276}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{ 1.77480458955e-06, 7.48976242837e-05, 0.000615617190139,  0.00252882917831}
{    0.219644366738,     0.21746500173,    0.200520523252,    0.109793534398}
{    0.219644366738,     0.21746500173,    0.200520523252,    0.109793534398}
{ 9.55064057807e-06, 0.000402598639786,  0.00327845613921,   0.0123030325578}
{    0.219644366738,     0.21746500173,    0.200520523252,    0.109793534398}
{    0.209466628291,    0.205435979931,    0.175419907202,   0.0547630843276}
{    0.209466628291,    0.205435979931,    0.175419907202,   0.0547630843276}
{    0.209466628291,    0.205435979931,    0.175419907202,   0.0547630843276}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{ 3.47322153253e-06, 0.000146799205253,  0.00122219889735,  0.00563162205063}
{    0.209466628291,    0.205435979931,    0.175419907202,   0.0547630843276}
{    0.219644366738,     0.21746500173,    0.200520523252,    0.109793534398}
{    0.219644366738,     0.21746500173,    0.200520523252,    0.109793534398}
{    0.166238705839,    0.164203697858,    0.148535535877,   0.0702168402446}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{ 1.02019455151e-05,  0.00043045265715,  0.00353362917585,    0.014508561498}
{ 9.55104590897e-06, 0.000403328269813,  0.00333221475702,   0.0139772453133}
{    0.219644366738,     0.21746500173,    0.200520523252,    0.109793534398}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{    0.209466628291,    0.205435979931,    0.175419907202,   0.0547630843276}
{    0.209466628291,    0.205435979931,    0.175419907202,   0.0547630843276}
{ 1.10302475445e-05, 0.000465322449213,  0.00381541353889,   0.0156935932933}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{    0.219644366738,     0.21746500173,    0.200520523252,    0.109793534398}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{    0.166238705839,    0.164203697858,    0.148535535877,   0.0702168402446}
{    0.166238705839,    0.164203697858,    0.148535535877,   0.0702168402446}
{ 4.11769224283e-06, 0.000173853512346,  0.00143701229445,  0.00660320200352}
{    0.166238705839,    0.164203697858,    0.148535535877,   0.0702168402446}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{    0.219644366738,     0.21746500173,    0.200520523252,    0.109793534398}
{    0.166238705839,    0.164203697858,    0.148535535877,   0.0702168402446}
{    0.166238705839,    0.164203697858,    0.148535535877,   0.0702168402446}
{ 2.70982019297e-07, 1.15087723766e-05,  9.9613603471e-05, 0.000590520639472}
{ 4.14837388999e-07, 1.73831561172e-05, 0.000134892789696, 0.000360648266411}
{    0.166238705839,    0.164203697858,    0.148535535877,   0.0702168402446}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{    0.209466628291,    0.205435979931,    0.175419907202,   0.0547630843276}
{    0.209466628291,    0.205435979931,    0.175419907202,   0.0547630843276}
{ 1.10282407115e-05, 0.000461723328786,  0.00355796204548,  0.00904961737758}
{ 4.23722314807e-07, 1.82190640527e-05, 0.000172442571143,  0.00141288850809}
{    0.219644366738,     0.21746500173,    0.200520523252,    0.109793534398}
{ 4.11769224283e-06, 0.000173853512346,  0.00143701229445,  0.00660320200352}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{ 1.10302475445e-05, 0.000465322449213,  0.00381541353889,   0.0156935932933}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{    0.209466628291,    0.205435979931,    0.175419907202,   0.0547630843276}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{ 6.48727777487e-06, 0.000273707326406,  0.00224624497732,  0.00923816223587}
{ 1.02019455151e-05,  0.00043045265715,  0.00353362917585,    0.014508561498}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{ 1.10302475445e-05, 0.000465322449213,  0.00381541353889,   0.0156935932933}
{    0.219644366738,     0.21746500173,    0.200520523252,    0.109793534398}
{    0.166238705839,    0.164203697858,    0.148535535877,   0.0702168402446}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{ 1.10282407115e-05, 0.000461723328786,  0.00355796204548,  0.00904961737758}
{    0.219644366738,     0.21746500173,    0.200520523252,    0.109793534398}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{    0.166238705839,    0.164203697858,    0.148535535877,   0.0702168402446}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{    0.209466628291,    0.205435979931,    0.175419907202,   0.0547630843276}
{    0.219644366738,     0.21746500173,    0.200520523252,    0.109793534398}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{ 4.39717980769e-06, 0.000185347051972,  0.00150863918172,  0.00566885418334}
{    0.219644366738,     0.21746500173,    0.200520523252,    0.109793534398}
{    0.209466628291,    0.205435979931,    0.175419907202,   0.0547630843276}
{    0.209466628291,    0.205435979931,    0.175419907202,   0.0547630843276}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{    0.219644366738,     0.21746500173,    0.200520523252,    0.109793534398}
{    0.209466628291,    0.205435979931,    0.175419907202,   0.0547630843276}
{    0.219644366738,     0.21746500173,    0.200520523252,    0.109793534398}
{    0.209466628291,    0.205435979931,    0.175419907202,   0.0547630843276}
{    0.209466628291,    0.205435979931,    0.175419907202,   0.0547630843276}
{    0.209466628291,    0.205435979931,    0.175419907202,   0.0547630843276}
{ 4.75444133113e-06, 0.000200814439054,  0.00166204426545,   0.0071214899314}
{    0.209466628291,    0.205435979931,    0.175419907202,   0.0547630843276}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{ 9.55104590897e-06, 0.000403328269813,  0.00333221475702,   0.0139772453133}
{    0.209466628291,    0.205435979931,    0.175419907202,   0.0547630843276}
{    0.166238705839,    0.164203697858,    0.148535535877,   0.0702168402446}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{    0.219644366738,     0.21746500173,    0.200520523252,    0.109793534398}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{    0.219644366738,     0.21746500173,    0.200520523252,    0.109793534398}
{    0.219644366738,     0.21746500173,    0.200520523252,    0.109793534398}
{    0.219644366738,     0.21746500173,    0.200520523252,    0.109793534398}
{  1.4970509901e-06,  6.3289801906e-05, 0.000527769233348,  0.00239305307311}
{    0.219644366738,     0.21746500173,    0.200520523252,    0.109793534398}
{    0.166238705839,    0.164203697858,    0.148535535877,   0.0702168402446}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{ 1.10282407115e-05, 0.000461723328786,  0.00355796204548,  0.00904961737758}
{    0.219644366738,     0.21746500173,    0.200520523252,    0.109793534398}
{ 8.00785502416e-07, 3.38470196483e-05, 0.000281750747817,  0.00125740093634}
{    0.166238705839,    0.164203697858,    0.148535535877,   0.0702168402446}
{    0.166238705839,    0.164203697858,    0.148535535877,   0.0702168402446}
{    0.166238705839,    0.164203697858,    0.148535535877,   0.0702168402446}
{    0.219644366738,     0.21746500173,    0.200520523252,    0.109793534398}
{    0.219644366738,     0.21746500173,    0.200520523252,    0.109793534398}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{ 2.56457348507e-12, 4.60989985599e-09, 3.35776437422e-07, 9.65195307678e-06}
{ 1.10302475445e-05, 0.000465322449213,  0.00381541353889,   0.0156935932933}
{    0.219644366738,     0.21746500173,    0.200520523252,    0.109793534398}
{ 3.15841782486e-10,  5.6449997324e-07, 3.92576557353e-05, 0.000811248788564}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{    0.209466628291,    0.205435979931,    0.175419907202,   0.0547630843276}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{ 4.44294416632e-12, 8.00828554034e-09, 5.96685321849e-07, 2.06716864805e-05}
{    0.219644366738,     0.21746500173,    0.200520523252,    0.109793534398}
{    0.219644366738,     0.21746500173,    0.200520523252,    0.109793534398}
{ 4.04412355929e-06,  0.00017070809095,  0.00140587025629,  0.00580935691889}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{    0.209466628291,    0.205435979931,    0.175419907202,   0.0547630843276}
{ 2.21546415155e-05, 0.000927995234234,  0.00717699579814,    0.018486850731}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{ 3.04439637348e-11, 5.61579600475e-08,  4.9252593617e-06, 0.000298736590453}
{    0.219644366738,     0.21746500173,    0.200520523252,    0.109793534398}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{ 7.18302583913e-11, 1.29424753944e-07, 9.61246872775e-06, 0.000321206627814}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{    0.166238705839,    0.164203697858,    0.148535535877,   0.0702168402446}
{ 4.23722314807e-07, 1.82190640527e-05, 0.000172442571143,  0.00141288850809}
{    0.209466628291,    0.205435979931,    0.175419907202,   0.0547630843276}
{    0.166238705839,    0.164203697858,    0.148535535877,   0.0702168402446}
{ 5.70427287032e-07, 2.40904241153e-05, 0.000199269036849, 0.000868942291988}
{    0.219644366738,     0.21746500173,    0.200520523252,    0.109793534398}
{    0.219644366738,     0.21746500173,    0.200520523252,    0.109793534398}
{ 9.55104590897e-06, 0.000403328269813,  0.00333221475702,   0.0139772453133}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{    0.166238705839,    0.164203697858,    0.148535535877,   0.0702168402446}
{    0.166238705839,    0.164203697858,    0.148535535877,   0.0702168402446}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{    0.219644366738,     0.21746500173,    0.200520523252,    0.109793534398}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{ 3.12293746506e-06, 0.000131635365032,  0.00107142128944,  0.00402887895612}
{    0.166238705839,    0.164203697858,    0.148535535877,   0.0702168402446}
{    0.219644366738,     0.21746500173,    0.200520523252,    0.109793534398}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{    0.209466628291,    0.205435979931,    0.175419907202,   0.0547630843276}
{    0.219644366738,     0.21746500173,    0.200520523252,    0.109793534398}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{ 9.55104590897e-06, 0.000403328269813,  0.00333221475702,   0.0139772453133}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{    0.166238705839,    0.164203697858,    0.148535535877,   0.0702168402446}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{    0.219644366738,     0.21746500173,    0.200520523252,    0.109793534398}
{    0.209466628291,    0.205435979931,    0.175419907202,   0.0547630843276}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{ 3.89403405406e-10, 6.95979470025e-07, 4.84025049793e-05, 0.000999270358126}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{    0.166238705839,    0.164203697858,    0.148535535877,   0.0702168402446}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{    0.166238705839,    0.164203697858,    0.148535535877,   0.0702168402446}
{    0.166238705839,    0.164203697858,    0.148535535877,   0.0702168402446}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{ 4.16089505722e-07, 1.74443054768e-05, 0.000135917520361, 0.000374600376156}
{    0.209466628291,    0.205435979931,    0.175419907202,   0.0547630843276}
{ 2.21546415155e-05, 0.000927995234234,  0.00717699579814,    0.018486850731}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{    0.219644366738,     0.21746500173,    0.200520523252,    0.109793534398}
{    0.219644366738,     0.21746500173,    0.200520523252,    0.109793534398}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{    0.209466628291,    0.205435979931,    0.175419907202,   0.0547630843276}
{ 6.48727777487e-06, 0.000273707326406,  0.00224624497732,  0.00923816223587}
{    0.219644366738,     0.21746500173,    0.200520523252,    0.109793534398}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{    0.219644366738,     0.21746500173,    0.200520523252,    0.109793534398}
{    0.166238705839,    0.164203697858,    0.148535535877,   0.0702168402446}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{    0.209466628291,    0.205435979931,    0.175419907202,   0.0547630843276}
{    0.219644366738,     0.21746500173,    0.200520523252,    0.109793534398}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{    0.166238705839,    0.164203697858,    0.148535535877,   0.0702168402446}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{    0.219644366738,     0.21746500173,    0.200520523252,    0.109793534398}
{    0.209466628291,    0.205435979931,    0.175419907202,   0.0547630843276}
{    0.219644366738,     0.21746500173,    0.200520523252,    0.109793534398}
{ 1.10282407115e-05, 0.000461723328786,  0.00355796204548,  0.00904961737758}
{    0.166238705839,    0.164203697858,    0.148535535877,   0.0702168402446}
{    0.219644366738,     0.21746500173,    0.200520523252,    0.109793534398}
{  1.4970509901e-06,  6.3289801906e-05, 0.000527769233348,  0.00239305307311}
{    0.166238705839,    0.164203697858,    0.148535535877,   0.0702168402446}
{    0.166238705839,    0.164203697858,    0.148535535877,   0.0702168402446}
{ 6.48727777487e-06, 0.000273707326406,  0.00224624497732,  0.00923816223587}
{    0.166238705839,    0.164203697858,    0.148535535877,   0.0702168402446}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{ 1.07882883884e-09, 1.92915624507e-06, 0.000134687209892,   0.0028251875274}
{    0.209466628291,    0.205435979931,    0.175419907202,   0.0547630843276}
{    0.209466628291,    0.205435979931,    0.175419907202,   0.0547630843276}
{ 1.02019455151e-05,  0.00043045265715,  0.00353362917585,    0.014508561498}
{    0.219644366738,     0.21746500173,    0.200520523252,    0.109793534398}
{    0.209466628291,    0.205435979931,    0.175419907202,   0.0547630843276}
{    0.209466628291,    0.205435979931,    0.175419907202,   0.0547630843276}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{    0.209466628291,    0.205435979931,    0.175419907202,   0.0547630843276}
{    0.209466628291,    0.205435979931,    0.175419907202,   0.0547630843276}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{    0.219644366738,     0.21746500173,    0.200520523252,    0.109793534398}
{    0.166238705839,    0.164203697858,    0.148535535877,   0.0702168402446}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{    0.166238705839,    0.164203697858,    0.148535535877,   0.0702168402446}
{    0.166238705839,    0.164203697858,    0.148535535877,   0.0702168402446}
{ 4.11769224283e-06, 0.000173853512346,  0.00143701229445,  0.00660320200352}
{    0.209466628291,    0.205435979931,    0.175419907202,   0.0547630843276}
{    0.166238705839,    0.164203697858,    0.148535535877,   0.0702168402446}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{    0.219644366738,     0.21746500173,    0.200520523252,    0.109793534398}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{    0.219644366738,     0.21746500173,    0.200520523252,    0.109793534398}
{    0.219644366738,     0.21746500173,    0.200520523252,    0.109793534398}
{    0.166238705839,    0.164203697858,    0.148535535877,   0.0702168402446}
{    0.166238705839,    0.164203697858,    0.148535535877,   0.0702168402446}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{    0.209466628291,    0.205435979931,    0.175419907202,   0.0547630843276}
{    0.219644366738,     0.21746500173,    0.200520523252,    0.109793534398}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{    0.209466628291,    0.205435979931,    0.175419907202,   0.0547630843276}
{ 4.39717980769e-06, 0.000185347051972,  0.00150863918172,  0.00566885418334}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{    0.219644366738,     0.21746500173,    0.200520523252,    0.109793534398}
{    0.209466628291,    0.205435979931,    0.175419907202,   0.0547630843276}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{ 4.75420425548e-06, 0.000200387610598,  0.00163054969894,  0.00612462773546}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{    0.219644366738,     0.21746500173,    0.200520523252,    0.109793534398}
{ 6.06080603885e-07, 2.55625247516e-05, 0.000209094431733, 0.000815898502028}
{    0.219644366738,     0.21746500173,    0.200520523252,    0.109793534398}
{    0.219644366738,     0.21746500173,    0.200520523252,    0.109793534398}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{    0.209466628291,    0.205435979931,    0.175419907202,   0.0547630843276}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{ 2.21546415155e-05, 0.000927995234234,  0.00717699579814,    0.018486850731}
{    0.166238705839,    0.164203697858,    0.148535535877,   0.0702168402446}
{    0.166238705839,    0.164203697858,    0.148535535877,   0.0702168402446}
{ 2.70756352035e-10, 4.87582062747e-07, 3.60435524331e-05,  0.00115070853772}
{    0.219644366738,     0.21746500173,    0.200520523252,    0.109793534398}
{    0.219644366738,     0.21746500173,    0.200520523252,    0.109793534398}
{    0.219644366738,     0.21746500173,    0.200520523252,    0.109793534398}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{ 1.02000541866e-05, 0.000427061389771,  0.00329146826665,  0.00835551793455}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{    0.166238705839,    0.164203697858,    0.148535535877,   0.0702168402446}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{    0.219644366738,     0.21746500173,    0.200520523252,    0.109793534398}
{    0.166238705839,    0.164203697858,    0.148535535877,   0.0702168402446}
{    0.166238705839,    0.164203697858,    0.148535535877,   0.0702168402446}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{    0.209466628291,    0.205435979931,    0.175419907202,   0.0547630843276}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{ 1.29120766248e-07, 5.45461961984e-06, 4.52347104522e-05,  0.00020348800546}
{ 1.10302475445e-05, 0.000465322449213,  0.00381541353889,   0.0156935932933}
{    0.219644366738,     0.21746500173,    0.200520523252,    0.109793534398}
{ 4.13354206585e-10, 7.44021259511e-07,  5.4794288451e-05,  0.00171449826313}
{  6.8600809737e-10, 1.22633392157e-06, 8.54022615927e-05,  0.00175919963497}
{    0.219644366738,     0.21746500173,    0.200520523252,    0.109793534398}
{    0.219644366738,     0.21746500173,    0.200520523252,    0.109793534398}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{    0.219644366738,     0.21746500173,    0.200520523252,    0.109793534398}
{    0.166238705839,    0.164203697858,    0.148535535877,   0.0702168402446}
{    0.219644366738,     0.21746500173,    0.200520523252,    0.109793534398}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{    0.219644366738,     0.21746500173,    0.200520523252,    0.109793534398}
{    0.166238705839,    0.164203697858,    0.148535535877,   0.0702168402446}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{    0.219644366738,     0.21746500173,    0.200520523252,    0.109793534398}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{    0.166238705839,    0.164203697858,    0.148535535877,   0.0702168402446}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{    0.219644366738,     0.21746500173,    0.200520523252,    0.109793534398}
{    0.209466628291,    0.205435979931,    0.175419907202,   0.0547630843276}
{    0.209466628291,    0.205435979931,    0.175419907202,   0.0547630843276}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{    0.219644366738,     0.21746500173,    0.200520523252,    0.109793534398}
{    0.209466628291,    0.205435979931,    0.175419907202,   0.0547630843276}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{    0.219644366738,     0.21746500173,    0.200520523252,    0.109793534398}
{    0.219644366738,     0.21746500173,    0.200520523252,    0.109793534398}
{    0.219644366738,     0.21746500173,    0.200520523252,    0.109793534398}
{    0.209466628291,    0.205435979931,    0.175419907202,   0.0547630843276}
{    0.219644366738,     0.21746500173,    0.200520523252,    0.109793534398}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{    0.219644366738,     0.21746500173,    0.200520523252,    0.109793534398}
{    0.209466628291,    0.205435979931,    0.175419907202,   0.0547630843276}
{    0.219644366738,     0.21746500173,    0.200520523252,    0.109793534398}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{    0.209466628291,    0.205435979931,    0.175419907202,   0.0547630843276}
{    0.209466628291,    0.205435979931,    0.175419907202,   0.0547630843276}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{    0.219644366738,     0.21746500173,    0.200520523252,    0.109793534398}
{    0.166238705839,    0.164203697858,    0.148535535877,   0.0702168402446}
{    0.219644366738,     0.21746500173,    0.200520523252,    0.109793534398}
{    0.209466628291,    0.205435979931,    0.175419907202,   0.0547630843276}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{ 1.27116833184e-10, 2.28662463171e-07, 1.67542418254e-05, 0.000503191862781}
{    0.219644366738,     0.21746500173,    0.200520523252,    0.109793534398}
{    0.219644366738,     0.21746500173,    0.200520523252,    0.109793534398}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{    0.209466628291,    0.205435979931,    0.175419907202,   0.0547630843276}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{ 6.48727777487e-06, 0.000273707326406,  0.00224624497732,  0.00923816223587}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{    0.219644366738,     0.21746500173,    0.200520523252,    0.109793534398}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{    0.209466628291,    0.205435979931,    0.175419907202,   0.0547630843276}
{    0.209466628291,    0.205435979931,    0.175419907202,   0.0547630843276}
{ 1.10282407115e-05, 0.000461723328786,  0.00355796204548,  0.00904961737758}
{    0.166238705839,    0.164203697858,    0.148535535877,   0.0702168402446}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{    0.209466628291,    0.205435979931,    0.175419907202,   0.0547630843276}
{    0.166238705839,    0.164203697858,    0.148535535877,   0.0702168402446}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{    0.219644366738,     0.21746500173,    0.200520523252,    0.109793534398}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{    0.209466628291,    0.205435979931,    0.175419907202,   0.0547630843276}
{ 7.24560290628e-06, 0.000305786041853,  0.00251509318058,   0.0105187580341}
{ 1.76968328634e-10,  3.1842725594e-07, 2.34001028093e-05, 0.000745687980282}
{ 2.52624106064e-10, 4.54447935738e-07, 3.33048057032e-05, 0.000994855059673}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{    0.219644366738,     0.21746500173,    0.200520523252,    0.109793534398}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{    0.209466628291,    0.205435979931,    0.175419907202,   0.0547630843276}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{    0.209466628291,    0.205435979931,    0.175419907202,   0.0547630843276}
{ 3.81405554332e-10, 6.81957180523e-07, 4.75885693622e-05,  0.00101626915347}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{ 1.31923737849e-10, 2.38375254857e-07, 1.81031967943e-05, 0.000694505170305}
{ 6.80218571444e-11, 1.22553080053e-07, 9.09644166661e-06, 0.000302717905056}
{    0.219644366738,     0.21746500173,    0.200520523252,    0.109793534398}
{ 9.38186261623e-06, 0.000394741564219,  0.00316804707249,   0.0111107216435}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{    0.209466628291,    0.205435979931,    0.175419907202,   0.0547630843276}
{ 2.21580726116e-05, 0.000934146944386,  0.00761592498171,   0.0294481352427}
{ 6.68919167555e-08, 2.80573649241e-06, 2.19527261671e-05, 6.36820603625e-05}
{ 2.21580726116e-05, 0.000934146944386,  0.00761592498171,   0.0294481352427}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{    0.166238705839,    0.164203697858,    0.148535535877,   0.0702168402446}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{ 9.55104590897e-06, 0.000403328269813,  0.00333221475702,   0.0139772453133}
{    0.166238705839,    0.164203697858,    0.148535535877,   0.0702168402446}
{    0.219644366738,     0.21746500173,    0.200520523252,    0.109793534398}
{ 2.20821696622e-11, 3.97585746748e-08, 2.93460826021e-06, 9.26199697283e-05}
{    0.219644366738,     0.21746500173,    0.200520523252,    0.109793534398}
{    0.219644366738,     0.21746500173,    0.200520523252,    0.109793534398}
{ 1.02000541866e-05, 0.000427061389771,  0.00329146826665,  0.00835551793455}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{ 1.07882883884e-09, 1.92915624507e-06, 0.000134687209892,   0.0028251875274}
{    0.209466628291,    0.205435979931,    0.175419907202,   0.0547630843276}
{    0.219644366738,     0.21746500173,    0.200520523252,    0.109793534398}
{    0.209466628291,    0.205435979931,    0.175419907202,   0.0547630843276}
{    0.209466628291,    0.205435979931,    0.175419907202,   0.0547630843276}
{    0.209466628291,    0.205435979931,    0.175419907202,   0.0547630843276}
{    0.209466628291,    0.205435979931,    0.175419907202,   0.0547630843276}
{ 5.32329077802e-15, 4.10161515627e-10, 2.78522089515e-07, 7.97961111153e-05}
{ 3.97554643405e-11, 7.16404381747e-08, 5.32602330007e-06, 0.000179592564946}
{    0.219644366738,     0.21746500173,    0.200520523252,    0.109793534398}
{    0.219644366738,     0.21746500173,    0.200520523252,    0.109793534398}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{    0.166238705839,    0.164203697858,    0.148535535877,   0.0702168402446}
{    0.166238705839,    0.164203697858,    0.148535535877,   0.0702168402446}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{ 2.95554868249e-07, 1.24650975462e-05, 0.000101932005869, 0.000397152611601}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{    0.166238705839,    0.164203697858,    0.148535535877,   0.0702168402446}
{    0.166238705839,    0.164203697858,    0.148535535877,   0.0702168402446}
{ 1.02019455151e-05,  0.00043045265715,  0.00353362917585,    0.014508561498}
{    0.209466628291,    0.205435979931,    0.175419907202,   0.0547630843276}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{ 1.77480458955e-06, 7.48976242837e-05, 0.000615617190139,  0.00252882917831}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{ 1.02019455151e-05,  0.00043045265715,  0.00353362917585,    0.014508561498}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{ 2.21580726116e-05, 0.000934146944386,  0.00761592498171,   0.0294481352427}
{ 9.55064057807e-06, 0.000402598639786,  0.00327845613921,   0.0123030325578}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{    0.219644366738,     0.21746500173,    0.200520523252,    0.109793534398}
{    0.166238705839,    0.164203697858,    0.148535535877,   0.0702168402446}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{ 7.69719652028e-06, 0.000322185435532,  0.00247786349579,  0.00619525495981}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{    0.209466628291,    0.205435979931,    0.175419907202,   0.0547630843276}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{ 6.06099749236e-07, 2.55971438085e-05, 0.000211739415081, 0.000922186020803}
{    0.166238705839,    0.164203697858,    0.148535535877,   0.0702168402446}
{    0.166238705839,    0.164203697858,    0.148535535877,   0.0702168402446}
{ 1.39620251334e-10, 2.51639921043e-07, 1.87287916431e-05, 0.000629298513284}
{    0.166238705839,    0.164203697858,    0.148535535877,   0.0702168402446}
{    0.166238705839,    0.164203697858,    0.148535535877,   0.0702168402446}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{    0.219644366738,     0.21746500173,    0.200520523252,    0.109793534398}
{    0.219644366738,     0.21746500173,    0.200520523252,    0.109793534398}
{ 7.07034502174e-07, 3.00441242197e-05, 0.000260831496113,  0.00150219140425}
{    0.166238705839,    0.164203697858,    0.148535535877,   0.0702168402446}
{    0.219644366738,     0.21746500173,    0.200520523252,    0.109793534398}
{    0.219644366738,     0.21746500173,    0.200520523252,    0.109793534398}
{    0.219644366738,     0.21746500173,    0.200520523252,    0.109793534398}
{    0.209466628291,    0.205435979931,    0.175419907202,   0.0547630843276}
{    0.209466628291,    0.205435979931,    0.175419907202,   0.0547630843276}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{    0.219644366738,     0.21746500173,    0.200520523252,    0.109793534398}
{    0.209466628291,    0.205435979931,    0.175419907202,   0.0547630843276}
{    0.209466628291,    0.205435979931,    0.175419907202,   0.0547630843276}
{    0.209466628291,    0.205435979931,    0.175419907202,   0.0547630843276}
{    0.219644366738,     0.21746500173,    0.200520523252,    0.109793534398}
{    0.219644366738,     0.21746500173,    0.200520523252,    0.109793534398}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{    0.219644366738,     0.21746500173,    0.200520523252,    0.109793534398}
{    0.209466628291,    0.205435979931,    0.175419907202,   0.0547630843276}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{    0.166238705839,    0.164203697858,    0.148535535877,   0.0702168402446}
{    0.219644366738,     0.21746500173,    0.200520523252,    0.109793534398}
{    0.166238705839,    0.164203697858,    0.148535535877,   0.0702168402446}
{    0.166238705839,    0.164203697858,    0.148535535877,   0.0702168402446}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{    0.219644366738,     0.21746500173,    0.200520523252,    0.109793534398}
{    0.166238705839,    0.164203697858,    0.148535535877,   0.0702168402446}
{    0.166238705839,    0.164203697858,    0.148535535877,   0.0702168402446}
{    0.219644366738,     0.21746500173,    0.200520523252,    0.109793534398}
{    0.209466628291,    0.205435979931,    0.175419907202,   0.0547630843276}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{ 2.79624651168e-06, 0.000118106492323, 0.000977521826166,  0.00417921511147}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{ 7.88847971872e-10, 1.41796625714e-06, 0.000103290486744,  0.00299568594427}
{    0.219644366738,     0.21746500173,    0.200520523252,    0.109793534398}
{    0.209466628291,    0.205435979931,    0.175419907202,   0.0547630843276}
{    0.209466628291,    0.205435979931,    0.175419907202,   0.0547630843276}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{    0.166238705839,    0.164203697858,    0.148535535877,   0.0702168402446}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{    0.209466628291,    0.205435979931,    0.175419907202,   0.0547630843276}
{    0.219644366738,     0.21746500173,    0.200520523252,    0.109793534398}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{    0.166238705839,    0.164203697858,    0.148535535877,   0.0702168402446}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{    0.209466628291,    0.205435979931,    0.175419907202,   0.0547630843276}
{ 8.93130258593e-11, 1.60734565472e-07, 1.18224041659e-05, 0.000366080942495}
{    0.166238705839,    0.164203697858,    0.148535535877,   0.0702168402446}
{    0.219644366738,     0.21746500173,    0.200520523252,    0.109793534398}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{    0.219644366738,     0.21746500173,    0.200520523252,    0.109793534398}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{ 1.55590347932e-15, 1.19592920124e-10,  7.9693960482e-08, 2.05821992493e-05}
{  2.2937287084e-17, 1.76710003177e-12, 1.20050283217e-09, 3.70219657392e-07}
{ 3.61676678882e-17, 2.78998689219e-12, 1.91202606642e-09, 5.77793145894e-07}
{    0.166238705839,    0.164203697858,    0.148535535877,   0.0702168402446}
{    0.219644366738,     0.21746500173,    0.200520523252,    0.109793534398}
{    0.209466628291,    0.205435979931,    0.175419907202,   0.0547630843276}
{    0.166238705839,    0.164203697858,    0.148535535877,   0.0702168402446}
{    0.166238705839,    0.164203697858,    0.148535535877,   0.0702168402446}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{    0.209466628291,    0.205435979931,    0.175419907202,   0.0547630843276}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{ 1.10302475445e-05, 0.000465322449213,  0.00381541353889,   0.0156935932933}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{ 4.13354206585e-10, 7.44021259511e-07,  5.4794288451e-05,  0.00171449826313}
{    0.209466628291,    0.205435979931,    0.175419907202,   0.0547630843276}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{ 5.00188951251e-17, 3.84715180774e-12, 2.57905313807e-09, 7.22649273899e-07}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{    0.209466628291,    0.205435979931,    0.175419907202,   0.0547630843276}
{ 3.31822261532e-06,  0.00013984674255,  0.00113691804158,  0.00423588029312}
{    0.219644366738,     0.21746500173,    0.200520523252,    0.109793534398}
{    0.209466628291,    0.205435979931,    0.175419907202,   0.0547630843276}
{    0.209466628291,    0.205435979931,    0.175419907202,   0.0547630843276}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{    0.166238705839,    0.164203697858,    0.148535535877,   0.0702168402446}
{    0.219644366738,     0.21746500173,    0.200520523252,    0.109793534398}
{    0.209466628291,    0.205435979931,    0.175419907202,   0.0547630843276}
{    0.219644366738,     0.21746500173,    0.200520523252,    0.109793534398}
{    0.166238705839,    0.164203697858,    0.148535535877,   0.0702168402446}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{    0.219644366738,     0.21746500173,    0.200520523252,    0.109793534398}
{    0.209466628291,    0.205435979931,    0.175419907202,   0.0547630843276}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{ 4.04412355929e-06,  0.00017070809095,  0.00140587025629,  0.00580935691889}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{    0.219644366738,     0.21746500173,    0.200520523252,    0.109793534398}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{    0.166238705839,    0.164203697858,    0.148535535877,   0.0702168402446}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{    0.209466628291,    0.205435979931,    0.175419907202,   0.0547630843276}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{ 2.95508496221e-07, 1.23820059768e-05, 9.60329859378e-05, 0.000256125883425}
{    0.219644366738,     0.21746500173,    0.200520523252,    0.109793534398}
{    0.219644366738,     0.21746500173,    0.200520523252,    0.109793534398}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{    0.209466628291,    0.205435979931,    0.175419907202,   0.0547630843276}
{    0.219644366738,     0.21746500173,    0.200520523252,    0.109793534398}
{    0.209466628291,    0.205435979931,    0.175419907202,   0.0547630843276}
{    0.209466628291,    0.205435979931,    0.175419907202,   0.0547630843276}
{ 7.24420263976e-06, 0.000303275058098,  0.00233564634075,  0.00590701131793}
{ 4.33917795294e-11, 7.81583757536e-08, 5.80052587072e-06, 0.000214230085252}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{ 7.24560290628e-06, 0.000305786041853,  0.00251509318058,   0.0105187580341}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{    0.219644366738,     0.21746500173,    0.200520523252,    0.109793534398}
{    0.219644366738,     0.21746500173,    0.200520523252,    0.109793534398}
{ 2.90507028364e-10, 5.21803018517e-07, 3.78011684714e-05,   0.0010813967308}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{ 1.77487499003e-06, 7.50246822393e-05, 0.000625179517055,  0.00287728854194}
{    0.219644366738,     0.21746500173,    0.200520523252,    0.109793534398}
{    0.209466628291,    0.205435979931,    0.175419907202,   0.0547630843276}
{    0.209466628291,    0.205435979931,    0.175419907202,   0.0547630843276}
{    0.209466628291,    0.205435979931,    0.175419907202,   0.0547630843276}
{    0.166238705839,    0.164203697858,    0.148535535877,   0.0702168402446}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{    0.209466628291,    0.205435979931,    0.175419907202,   0.0547630843276}
{ 4.04407904728e-06, 0.000170627852692,  0.00139989116725,  0.00560856612921}
{    0.166238705839,    0.164203697858,    0.148535535877,   0.0702168402446}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{    0.209466628291,    0.205435979931,    0.175419907202,   0.0547630843276}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{    0.219644366738,     0.21746500173,    0.200520523252,    0.109793534398}
{    0.219644366738,     0.21746500173,    0.200520523252,    0.109793534398}
{    0.219644366738,     0.21746500173,    0.200520523252,    0.109793534398}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{ 7.07034502174e-07, 3.00441242197e-05, 0.000260831496113,  0.00150219140425}
{ 2.70577727033e-19, 2.07616856039e-14, 1.36442761435e-11, 3.22259085102e-09}
{    0.166238705839,    0.164203697858,    0.148535535877,   0.0702168402446}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{    0.209466628291,    0.205435979931,    0.175419907202,   0.0547630843276}
{    0.209466628291,    0.205435979931,    0.175419907202,   0.0547630843276}
{ 9.38186261623e-06, 0.000394741564219,  0.00316804707249,   0.0111107216435}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{    0.219644366738,     0.21746500173,    0.200520523252,    0.109793534398}
{    0.219644366738,     0.21746500173,    0.200520523252,    0.109793534398}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{    0.209466628291,    0.205435979931,    0.175419907202,   0.0547630843276}
{    0.219644366738,     0.21746500173,    0.200520523252,    0.109793534398}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{ 4.35588032899e-15, 3.34486950957e-10,  2.2123240436e-07, 5.51428234213e-05}
{ 7.74638299433e-10,  1.3852375884e-06, 9.67356645525e-05,  0.00203807213046}
{    0.166238705839,    0.164203697858,    0.148535535877,   0.0702168402446}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{ 3.31839358328e-06, 0.000140154487326,  0.00115958701938,    0.004944012748}
{    0.219644366738,     0.21746500173,    0.200520523252,    0.109793534398}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{    0.219644366738,     0.21746500173,    0.200520523252,    0.109793534398}
{    0.209466628291,    0.205435979931,    0.175419907202,   0.0547630843276}
{ 9.55104590897e-06, 0.000403328269813,  0.00333221475702,   0.0139772453133}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{ 9.55064057807e-06, 0.000402598639786,  0.00327845613921,   0.0123030325578}
{  1.1942794233e-06, 5.05426372181e-05, 0.000425025988981,  0.00203383727267}
{    0.166238705839,    0.164203697858,    0.148535535877,   0.0702168402446}
{    0.166238705839,    0.164203697858,    0.148535535877,   0.0702168402446}
{    0.219644366738,     0.21746500173,    0.200520523252,    0.109793534398}
{    0.219644366738,     0.21746500173,    0.200520523252,    0.109793534398}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{    0.209466628291,    0.205435979931,    0.175419907202,   0.0547630843276}
{ 4.26010081287e-06, 0.000178302438228,  0.00137040032253,   0.0034161865421}
{    0.209466628291,    0.205435979931,    0.175419907202,   0.0547630843276}
{    0.209466628291,    0.205435979931,    0.175419907202,   0.0547630843276}
{ 7.69864375107e-06, 0.000324780097948,  0.00266296785967,   0.0108781605597}
{ 2.21580726116e-05, 0.000934146944386,  0.00761592498171,   0.0294481352427}
{    0.166238705839,    0.164203697858,    0.148535535877,   0.0702168402446}
{    0.166238705839,    0.164203697858,    0.148535535877,   0.0702168402446}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{ 1.10302475445e-05, 0.000465322449213,  0.00381541353889,   0.0156935932933}
{    0.209466628291,    0.205435979931,    0.175419907202,   0.0547630843276}
{    0.166238705839,    0.164203697858,    0.148535535877,   0.0702168402446}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{    0.166238705839,    0.164203697858,    0.148535535877,   0.0702168402446}
{    0.219644366738,     0.21746500173,    0.200520523252,    0.109793534398}
{ 2.21580726116e-05, 0.000934146944386,  0.00761592498171,   0.0294481352427}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{    0.166238705839,    0.164203697858,    0.148535535877,   0.0702168402446}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{    0.209466628291,    0.205435979931,    0.175419907202,   0.0547630843276}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{ 1.10302475445e-05, 0.000465322449213,  0.00381541353889,   0.0156935932933}
{ 7.69719652028e-06, 0.000322185435532,  0.00247786349579,  0.00619525495981}
{    0.219644366738,     0.21746500173,    0.200520523252,    0.109793534398}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{ 8.76321126884e-11, 1.57987080905e-07, 1.17973810143e-05, 0.000427867526874}
{    0.219644366738,     0.21746500173,    0.200520523252,    0.109793534398}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{    0.166238705839,    0.164203697858,    0.148535535877,   0.0702168402446}
{  8.0315731476e-07, 3.38845930855e-05, 0.000277835184284,  0.00110403219807}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{ 6.06080603885e-07, 2.55625247516e-05, 0.000209094431733, 0.000815898502028}
{    0.219644366738,     0.21746500173,    0.200520523252,    0.109793534398}
{ 2.21580726116e-05, 0.000934146944386,  0.00761592498171,   0.0294481352427}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{    0.166238705839,    0.164203697858,    0.148535535877,   0.0702168402446}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{ 1.02000541866e-05, 0.000427061389771,  0.00329146826665,  0.00835551793455}
{ 1.74455049396e-06, 7.37804825819e-05, 0.000617160517941,  0.00287603782287}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{    0.209466628291,    0.205435979931,    0.175419907202,   0.0547630843276}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{    0.209466628291,    0.205435979931,    0.175419907202,   0.0547630843276}
{    0.166238705839,    0.164203697858,    0.148535535877,   0.0702168402446}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{    0.209466628291,    0.205435979931,    0.175419907202,   0.0547630843276}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{ 9.38186261623e-06, 0.000394741564219,  0.00316804707249,   0.0111107216435}
{ 4.04412355929e-06,  0.00017070809095,  0.00140587025629,  0.00580935691889}
{    0.219644366738,     0.21746500173,    0.200520523252,    0.109793534398}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{    0.209466628291,    0.205435979931,    0.175419907202,   0.0547630843276}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{ 7.69864375107e-06, 0.000324780097948,  0.00266296785967,   0.0108781605597}
{    0.166238705839,    0.164203697858,    0.148535535877,   0.0702168402446}
{    0.219644366738,     0.21746500173,    0.200520523252,    0.109793534398}
{    0.209466628291,    0.205435979931,    0.175419907202,   0.0547630843276}
{    0.209466628291,    0.205435979931,    0.175419907202,   0.0547630843276}
{    0.166238705839,    0.164203697858,    0.148535535877,   0.0702168402446}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{    0.209466628291,    0.205435979931,    0.175419907202,   0.0547630843276}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{ 4.39717980769e-06, 0.000185347051972,  0.00150863918172,  0.00566885418334}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{    0.209466628291,    0.205435979931,    0.175419907202,   0.0547630843276}
{ 4.26010081287e-06, 0.000178302438228,  0.00137040032253,   0.0034161865421}
{    0.209466628291,    0.205435979931,    0.175419907202,   0.0547630843276}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{ 3.61293055628e-11, 6.66796562552e-08, 5.86780119034e-06, 0.000359232242266}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{    0.219644366738,     0.21746500173,    0.200520523252,    0.109793534398}
{ 2.30491071709e-06, 9.75452343241e-05,  0.00082028287345,  0.00392522322259}
{ 3.12293746506e-06, 0.000131635365032,  0.00107142128944,  0.00402887895612}
{    0.219644366738,     0.21746500173,    0.200520523252,    0.109793534398}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{ 1.10302475445e-05, 0.000465322449213,  0.00381541353889,   0.0156935932933}
{    0.209466628291,    0.205435979931,    0.175419907202,   0.0547630843276}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{ 6.48727777487e-06, 0.000273707326406,  0.00224624497732,  0.00923816223587}
{    0.166238705839,    0.164203697858,    0.148535535877,   0.0702168402446}
{    0.166238705839,    0.164203697858,    0.148535535877,   0.0702168402446}
{ 7.69864375107e-06, 0.000324780097948,  0.00266296785967,   0.0108781605597}
{ 1.10282407115e-05, 0.000461723328786,  0.00355796204548,  0.00904961737758}
{    0.219644366738,     0.21746500173,    0.200520523252,    0.109793534398}
{ 1.10302475445e-05, 0.000465322449213,  0.00381541353889,   0.0156935932933}
{    0.166238705839,    0.164203697858,    0.148535535877,   0.0702168402446}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{    0.219644366738,     0.21746500173,    0.200520523252,    0.109793534398}
{    0.209466628291,    0.205435979931,    0.175419907202,   0.0547630843276}
{    0.209466628291,    0.205435979931,    0.175419907202,   0.0547630843276}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{    0.209466628291,    0.205435979931,    0.175419907202,   0.0547630843276}
{ 9.55104590897e-06, 0.000403328269813,  0.00333221475702,   0.0139772453133}
{    0.209466628291,    0.205435979931,    0.175419907202,   0.0547630843276}
{    0.219644366738,     0.21746500173,    0.200520523252,    0.109793534398}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{    0.219644366738,     0.21746500173,    0.200520523252,    0.109793534398}
{    0.219644366738,     0.21746500173,    0.200520523252,    0.109793534398}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{    0.219644366738,     0.21746500173,    0.200520523252,    0.109793534398}
{    0.209466628291,    0.205435979931,    0.175419907202,   0.0547630843276}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{    0.166238705839,    0.164203697858,    0.148535535877,   0.0702168402446}
{    0.166238705839,    0.164203697858,    0.148535535877,   0.0702168402446}
{    0.166238705839,    0.164203697858,    0.148535535877,   0.0702168402446}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{    0.219644366738,     0.21746500173,    0.200520523252,    0.109793534398}
{    0.166238705839,    0.164203697858,    0.148535535877,   0.0702168402446}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{    0.209466628291,    0.205435979931,    0.175419907202,   0.0547630843276}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{    0.166238705839,    0.164203697858,    0.148535535877,   0.0702168402446}
{    0.219644366738,     0.21746500173,    0.200520523252,    0.109793534398}
{    0.219644366738,     0.21746500173,    0.200520523252,    0.109793534398}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{    0.219644366738,     0.21746500173,    0.200520523252,    0.109793534398}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{    0.209466628291,    0.205435979931,    0.175419907202,   0.0547630843276}
{    0.166238705839,    0.164203697858,    0.148535535877,   0.0702168402446}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{    0.209466628291,    0.205435979931,    0.175419907202,   0.0547630843276}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{ 7.69864375107e-06, 0.000324780097948,  0.00266296785967,   0.0108781605597}
{ 1.97053966273e-24, 6.70941114441e-18, 5.26707807363e-14,   3.575717291e-10}
{    0.219644366738,     0.21746500173,    0.200520523252,    0.109793534398}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{    0.166238705839,    0.164203697858,    0.148535535877,   0.0702168402446}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{    0.209466628291,    0.205435979931,    0.175419907202,   0.0547630843276}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{ 9.38186261623e-06, 0.000394741564219,  0.00316804707249,   0.0111107216435}
{    0.166238705839,    0.164203697858,    0.148535535877,   0.0702168402446}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{ 9.38186261623e-06, 0.000394741564219,  0.00316804707249,   0.0111107216435}
{    0.209466628291,    0.205435979931,    0.175419907202,   0.0547630843276}
{    0.209466628291,    0.205435979931,    0.175419907202,   0.0547630843276}
{    0.209466628291,    0.205435979931,    0.175419907202,   0.0547630843276}
{  1.4166957907e-07,  5.9727119408e-06, 4.86934913252e-05, 0.000185697264747}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{ 3.24169091676e-07, 1.36854373337e-05, 0.000112875773141, 0.000484406609502}
{    0.209466628291,    0.205435979931,    0.175419907202,   0.0547630843276}
{ 2.21546415155e-05, 0.000927995234234,  0.00717699579814,    0.018486850731}
{ 3.05814230858e-10, 5.50166223805e-07, 4.03399579628e-05,  0.00120945451007}
{    0.166238705839,    0.164203697858,    0.148535535877,   0.0702168402446}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{    0.219644366738,     0.21746500173,    0.200520523252,    0.109793534398}
{    0.209466628291,    0.205435979931,    0.175419907202,   0.0547630843276}
{    0.209466628291,    0.205435979931,    0.175419907202,   0.0547630843276}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{    0.166238705839,    0.164203697858,    0.148535535877,   0.0702168402446}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{    0.219644366738,     0.21746500173,    0.200520523252,    0.109793534398}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{  3.5535152826e-11, 6.41720598054e-08, 4.85506241991e-06, 0.000187267339044}
{    0.166238705839,    0.164203697858,    0.148535535877,   0.0702168402446}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{ 7.69864375107e-06, 0.000324780097948,  0.00266296785967,   0.0108781605597}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{    0.219644366738,     0.21746500173,    0.200520523252,    0.109793534398}
{ 2.30491071709e-06, 9.75452343241e-05,  0.00082028287345,  0.00392522322259}
{    0.219644366738,     0.21746500173,    0.200520523252,    0.109793534398}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{    0.219644366738,     0.21746500173,    0.200520523252,    0.109793534398}
{    0.166238705839,    0.164203697858,    0.148535535877,   0.0702168402446}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{    0.209466628291,    0.205435979931,    0.175419907202,   0.0547630843276}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{ 9.38186261623e-06, 0.000394741564219,  0.00316804707249,   0.0111107216435}
{    0.166238705839,    0.164203697858,    0.148535535877,   0.0702168402446}
{ 1.74450511764e-06, 7.36984210754e-05, 0.000610881476131,  0.00261690066484}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{    0.219644366738,     0.21746500173,    0.200520523252,    0.109793534398}
{ 2.30491071709e-06, 9.75452343241e-05,  0.00082028287345,  0.00392522322259}
{    0.219644366738,     0.21746500173,    0.200520523252,    0.109793534398}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{  6.7476648497e-07, 2.84939142369e-05,  0.00023548891647,   0.0010194047666}
{ 4.39740323869e-06, 0.000185749262116,  0.00153828494069,  0.00659847201982}
{    0.166238705839,    0.164203697858,    0.148535535877,   0.0702168402446}
{    0.219644366738,     0.21746500173,    0.200520523252,    0.109793534398}
{ 3.47246733786e-06, 0.000145445627288,   0.0011247726583,  0.00295086249714}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{    0.166238705839,    0.164203697858,    0.148535535877,   0.0702168402446}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{    0.209466628291,    0.205435979931,    0.175419907202,   0.0547630843276}
{    0.209466628291,    0.205435979931,    0.175419907202,   0.0547630843276}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{ 6.28647226098e-07, 2.66161860174e-05, 0.000223965801359, 0.000972404350203}
{    0.219644366738,     0.21746500173,    0.200520523252,    0.109793534398}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{    0.219644366738,     0.21746500173,    0.200520523252,    0.109793534398}
{    0.209466628291,    0.205435979931,    0.175419907202,   0.0547630843276}
{    0.166238705839,    0.164203697858,    0.148535535877,   0.0702168402446}
{ 2.21580726116e-05, 0.000934146944386,  0.00761592498171,   0.0294481352427}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{ 2.21546415155e-05, 0.000927995234234,  0.00717699579814,    0.018486850731}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{ 7.69864375107e-06, 0.000324780097948,  0.00266296785967,   0.0108781605597}
{ 1.90586431651e-11, 3.43730551744e-08, 2.57283371039e-06, 9.10994872729e-05}
{    0.209466628291,    0.205435979931,    0.175419907202,   0.0547630843276}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{    0.209466628291,    0.205435979931,    0.175419907202,   0.0547630843276}
{    0.209466628291,    0.205435979931,    0.175419907202,   0.0547630843276}
{    0.209466628291,    0.205435979931,    0.175419907202,   0.0547630843276}
{    0.209466628291,    0.205435979931,    0.175419907202,   0.0547630843276}
{    0.219644366738,     0.21746500173,    0.200520523252,    0.109793534398}
{ 2.21546415155e-05, 0.000927995234234,  0.00717699579814,    0.018486850731}
{    0.166238705839,    0.164203697858,    0.148535535877,   0.0702168402446}
{    0.166238705839,    0.164203697858,    0.148535535877,   0.0702168402446}
{    0.166238705839,    0.164203697858,    0.148535535877,   0.0702168402446}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{    0.166238705839,    0.164203697858,    0.148535535877,   0.0702168402446}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{    0.166238705839,    0.164203697858,    0.148535535877,   0.0702168402446}
{    0.219644366738,     0.21746500173,    0.200520523252,    0.109793534398}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{    0.219644366738,     0.21746500173,    0.200520523252,    0.109793534398}
{    0.209466628291,    0.205435979931,    0.175419907202,   0.0547630843276}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{    0.219644366738,     0.21746500173,    0.200520523252,    0.109793534398}
{    0.209466628291,    0.205435979931,    0.175419907202,   0.0547630843276}
{    0.219644366738,     0.21746500173,    0.200520523252,    0.109793534398}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{ 7.24560290628e-06, 0.000305786041853,  0.00251509318058,   0.0105187580341}
{    0.166238705839,    0.164203697858,    0.148535535877,   0.0702168402446}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{ 1.10302475445e-05, 0.000465322449213,  0.00381541353889,   0.0156935932933}
{    0.219644366738,     0.21746500173,    0.200520523252,    0.109793534398}
{    0.219644366738,     0.21746500173,    0.200520523252,    0.109793534398}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{ 7.24560290628e-06, 0.000305786041853,  0.00251509318058,   0.0105187580341}
{    0.166238705839,    0.164203697858,    0.148535535877,   0.0702168402446}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{    0.209466628291,    0.205435979931,    0.175419907202,   0.0547630843276}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{    0.209466628291,    0.205435979931,    0.175419907202,   0.0547630843276}
{    0.209466628291,    0.205435979931,    0.175419907202,   0.0547630843276}
{    0.166238705839,    0.164203697858,    0.148535535877,   0.0702168402446}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{    0.209466628291,    0.205435979931,    0.175419907202,   0.0547630843276}
{    0.219644366738,     0.21746500173,    0.200520523252,    0.109793534398}
{ 1.02000541866e-05, 0.000427061389771,  0.00329146826665,  0.00835551793455}
{    0.166238705839,    0.164203697858,    0.148535535877,   0.0702168402446}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{ 4.21884918542e-10,    7.58532704e-07, 5.53729996482e-05,  0.00164385591601}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{ 7.24560290628e-06, 0.000305786041853,  0.00251509318058,   0.0105187580341}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{ 1.02019455151e-05,  0.00043045265715,  0.00353362917585,    0.014508561498}
{    0.219644366738,     0.21746500173,    0.200520523252,    0.109793534398}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{ 3.40824731647e-16, 2.60358909669e-11, 1.65055770486e-08, 3.01261885201e-06}
{    0.166238705839,    0.164203697858,    0.148535535877,   0.0702168402446}
{    0.166238705839,    0.164203697858,    0.148535535877,   0.0702168402446}
{ 1.74455049396e-06, 7.37804825819e-05, 0.000617160517941,  0.00287603782287}
{ 1.53272722928e-16, 1.18000076779e-11, 7.96573632617e-09, 2.25680652696e-06}
{  6.7476648497e-07, 2.84939142369e-05,  0.00023548891647,   0.0010194047666}
{    0.209466628291,    0.205435979931,    0.175419907202,   0.0547630843276}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{ 2.30487308997e-06, 9.74776307459e-05, 0.000815382916642,  0.00379977662246}
{    0.209466628291,    0.205435979931,    0.175419907202,   0.0547630843276}
{ 9.55064057807e-06, 0.000402598639786,  0.00327845613921,   0.0123030325578}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{    0.219644366738,     0.21746500173,    0.200520523252,    0.109793534398}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{    0.209466628291,    0.205435979931,    0.175419907202,   0.0547630843276}
{    0.219644366738,     0.21746500173,    0.200520523252,    0.109793534398}
{ 1.10457535612e-09, 1.98206712799e-06, 0.000142364455313,  0.00371357194388}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{    0.219644366738,     0.21746500173,    0.200520523252,    0.109793534398}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{    0.219644366738,     0.21746500173,    0.200520523252,    0.109793534398}
{    0.209466628291,    0.205435979931,    0.175419907202,   0.0547630843276}
{    0.209466628291,    0.205435979931,    0.175419907202,   0.0547630843276}
{    0.209466628291,    0.205435979931,    0.175419907202,   0.0547630843276}
{    0.209466628291,    0.205435979931,    0.175419907202,   0.0547630843276}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{ 7.24560290628e-06, 0.000305786041853,  0.00251509318058,   0.0105187580341}
{    0.209466628291,    0.205435979931,    0.175419907202,   0.0547630843276}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{ 2.79609981892e-06, 0.000117842441171, 0.000958070039042,  0.00357105888348}
{    0.219644366738,     0.21746500173,    0.200520523252,    0.109793534398}
{    0.166238705839,    0.164203697858,    0.148535535877,   0.0702168402446}
{    0.166238705839,    0.164203697858,    0.148535535877,   0.0702168402446}
{    0.219644366738,     0.21746500173,    0.200520523252,    0.109793534398}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{    0.219644366738,     0.21746500173,    0.200520523252,    0.109793534398}
{    0.219644366738,     0.21746500173,    0.200520523252,    0.109793534398}
{    0.219644366738,     0.21746500173,    0.200520523252,    0.109793534398}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{ 1.55533949002e-10, 2.79822157891e-07,   2.053944763e-05, 0.000644077175039}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{ 2.79609981892e-06, 0.000117842441171, 0.000958070039042,  0.00357105888348}
{    0.219644366738,     0.21746500173,    0.200520523252,    0.109793534398}
{ 4.26094355493e-06, 0.000179813528012,  0.00147831910146,  0.00618625232335}
{    0.166238705839,    0.164203697858,    0.148535535877,   0.0702168402446}
{    0.166238705839,    0.164203697858,    0.148535535877,   0.0702168402446}
{    0.166238705839,    0.164203697858,    0.148535535877,   0.0702168402446}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{    0.219644366738,     0.21746500173,    0.200520523252,    0.109793534398}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{    0.166238705839,    0.164203697858,    0.148535535877,   0.0702168402446}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{ 9.88726524934e-11, 1.78042288416e-07, 1.31404660133e-05, 0.000396623682975}
{    0.209466628291,    0.205435979931,    0.175419907202,   0.0547630843276}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{    0.166238705839,    0.164203697858,    0.148535535877,   0.0702168402446}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{    0.219644366738,     0.21746500173,    0.200520523252,    0.109793534398}
{    0.209466628291,    0.205435979931,    0.175419907202,   0.0547630843276}
{    0.209466628291,    0.205435979931,    0.175419907202,   0.0547630843276}
{    0.209466628291,    0.205435979931,    0.175419907202,   0.0547630843276}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{ 1.02019455151e-05,  0.00043045265715,  0.00353362917585,    0.014508561498}
{ 1.02019455151e-05,  0.00043045265715,  0.00353362917585,    0.014508561498}
{    0.166238705839,    0.164203697858,    0.148535535877,   0.0702168402446}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{    0.219644366738,     0.21746500173,    0.200520523252,    0.109793534398}
{    0.209466628291,    0.205435979931,    0.175419907202,   0.0547630843276}
{    0.209466628291,    0.205435979931,    0.175419907202,   0.0547630843276}
{    0.219644366738,     0.21746500173,    0.200520523252,    0.109793534398}
{    0.209466628291,    0.205435979931,    0.175419907202,   0.0547630843276}
{    0.209466628291,    0.205435979931,    0.175419907202,   0.0547630843276}
{ 7.24560290628e-06, 0.000305786041853,  0.00251509318058,   0.0105187580341}
{ 4.28136049566e-11, 7.72325072341e-08,  5.7900535492e-06, 0.000205299357641}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{    0.209466628291,    0.205435979931,    0.175419907202,   0.0547630843276}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{ 4.49875578531e-07, 1.88636507879e-05, 0.000147156826309,  0.00040912024442}
{    0.219644366738,     0.21746500173,    0.200520523252,    0.109793534398}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{    0.219644366738,     0.21746500173,    0.200520523252,    0.109793534398}
{    0.219644366738,     0.21746500173,    0.200520523252,    0.109793534398}
{    0.209466628291,    0.205435979931,    0.175419907202,   0.0547630843276}
{    0.209466628291,    0.205435979931,    0.175419907202,   0.0547630843276}
{    0.166238705839,    0.164203697858,    0.148535535877,   0.0702168402446}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{ 2.21580726116e-05, 0.000934146944386,  0.00761592498171,   0.0294481352427}
{    0.209466628291,    0.205435979931,    0.175419907202,   0.0547630843276}
{    0.166238705839,    0.164203697858,    0.148535535877,   0.0702168402446}
{    0.166238705839,    0.164203697858,    0.148535535877,   0.0702168402446}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{    0.166238705839,    0.164203697858,    0.148535535877,   0.0702168402446}
{ 3.12293746506e-06, 0.000131635365032,  0.00107142128944,  0.00402887895612}
{    0.219644366738,     0.21746500173,    0.200520523252,    0.109793534398}
{    0.209466628291,    0.205435979931,    0.175419907202,   0.0547630843276}
{    0.209466628291,    0.205435979931,    0.175419907202,   0.0547630843276}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{    0.219644366738,     0.21746500173,    0.200520523252,    0.109793534398}
{    0.219644366738,     0.21746500173,    0.200520523252,    0.109793534398}
{    0.166238705839,    0.164203697858,    0.148535535877,   0.0702168402446}
{    0.166238705839,    0.164203697858,    0.148535535877,   0.0702168402446}
{    0.219644366738,     0.21746500173,    0.200520523252,    0.109793534398}
{    0.209466628291,    0.205435979931,    0.175419907202,   0.0547630843276}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{    0.209466628291,    0.205435979931,    0.175419907202,   0.0547630843276}
{    0.219644366738,     0.21746500173,    0.200520523252,    0.109793534398}
{    0.209466628291,    0.205435979931,    0.175419907202,   0.0547630843276}
{    0.209466628291,    0.205435979931,    0.175419907202,   0.0547630843276}
{    0.209466628291,    0.205435979931,    0.175419907202,   0.0547630843276}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{ 7.30883496508e-10, 1.31000036004e-06, 9.32123837054e-05,  0.00226258894081}
{    0.219644366738,     0.21746500173,    0.200520523252,    0.109793534398}
{ 2.30491071709e-06, 9.75452343241e-05,  0.00082028287345,  0.00392522322259}
{    0.219644366738,     0.21746500173,    0.200520523252,    0.109793534398}
{    0.209466628291,    0.205435979931,    0.175419907202,   0.0547630843276}
{    0.219644366738,     0.21746500173,    0.200520523252,    0.109793534398}
{ 1.83651239827e-06, 7.74012868262e-05, 0.000629349019288,  0.00234964337631}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{ 9.55104590897e-06, 0.000403328269813,  0.00333221475702,   0.0139772453133}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{    0.166238705839,    0.164203697858,    0.148535535877,   0.0702168402446}
{    0.166238705839,    0.164203697858,    0.148535535877,   0.0702168402446}
{    0.166238705839,    0.164203697858,    0.148535535877,   0.0702168402446}
{    0.166238705839,    0.164203697858,    0.148535535877,   0.0702168402446}
{    0.219644366738,     0.21746500173,    0.200520523252,    0.109793534398}
{    0.166238705839,    0.164203697858,    0.148535535877,   0.0702168402446}
{    0.166238705839,    0.164203697858,    0.148535535877,   0.0702168402446}
{ 4.04412355929e-06,  0.00017070809095,  0.00140587025629,  0.00580935691889}
{    0.219644366738,     0.21746500173,    0.200520523252,    0.109793534398}
{    0.219644366738,     0.21746500173,    0.200520523252,    0.109793534398}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{    0.209466628291,    0.205435979931,    0.175419907202,   0.0547630843276}
{    0.219644366738,     0.21746500173,    0.200520523252,    0.109793534398}
{ 9.35116950494e-12,  1.7040453329e-08, 1.38150362443e-06, 7.51560707659e-05}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{    0.219644366738,     0.21746500173,    0.200520523252,    0.109793534398}
{    0.219644366738,     0.21746500173,    0.200520523252,    0.109793534398}
{ 1.02019455151e-05,  0.00043045265715,  0.00353362917585,    0.014508561498}
{    0.219644366738,     0.21746500173,    0.200520523252,    0.109793534398}
{    0.209466628291,    0.205435979931,    0.175419907202,   0.0547630843276}
{    0.209466628291,    0.205435979931,    0.175419907202,   0.0547630843276}
{    0.219644366738,     0.21746500173,    0.200520523252,    0.109793534398}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{  1.9063641886e-10, 3.42879664564e-07,   2.509391952e-05, 0.000742234529884}
{    0.166238705839,    0.164203697858,    0.148535535877,   0.0702168402446}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{    0.209466628291,    0.205435979931,    0.175419907202,   0.0547630843276}
{    0.219644366738,     0.21746500173,    0.200520523252,    0.109793534398}
{    0.219644366738,     0.21746500173,    0.200520523252,    0.109793534398}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{    0.209466628291,    0.205435979931,    0.175419907202,   0.0547630843276}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{ 1.02000541866e-05, 0.000427061389771,  0.00329146826665,  0.00835551793455}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{ 9.38148581793e-06, 0.000394064486396,   0.0031188816339,  0.00975455935601}
{    0.209466628291,    0.205435979931,    0.175419907202,   0.0547630843276}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{    0.166238705839,    0.164203697858,    0.148535535877,   0.0702168402446}
{    0.166238705839,    0.164203697858,    0.148535535877,   0.0702168402446}
{    0.166238705839,    0.164203697858,    0.148535535877,   0.0702168402446}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{    0.219644366738,     0.21746500173,    0.200520523252,    0.109793534398}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{ 8.99087331922e-11, 1.64106651761e-07, 1.34053404113e-05, 0.000658885328381}
{    0.219644366738,     0.21746500173,    0.200520523252,    0.109793534398}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{    0.209466628291,    0.205435979931,    0.175419907202,   0.0547630843276}
{    0.209466628291,    0.205435979931,    0.175419907202,   0.0547630843276}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{    0.209466628291,    0.205435979931,    0.175419907202,   0.0547630843276}
{    0.166238705839,    0.164203697858,    0.148535535877,   0.0702168402446}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{    0.209466628291,    0.205435979931,    0.175419907202,   0.0547630843276}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{    0.404345118213,    0.399972705468,    0.366265123406,    0.195033733691}
{    0.166238705839,    0.164203697858,    0.148535535877,   0.0702168402446}
{ 1.83661195511e-06, 7.75805035614e-05, 0.000642558662221,  0.00276510223348}
{    0.219644366738,     0.21746500173,    0.200520523252,    0.109793534398}
{    0.219644366738,     0.21746500173,    0.200520523252,    0.109793534398}
{    0.166238705839,    0.164203697858,    0.148535535877,   0.0702168402446}
};

exepectedRateClassAssignments =
{
{                 0,                 0,                 3,                 0,                 0,                 0,                 0,                 0,                 3,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 3,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 3,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 3,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 3,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 3,                 0,                 0,                 3,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 3,                 0,                 3,                 3,                 3,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 3,                 0,                 0,                 0,                 0,                 3,                 3,                 0,                 3,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 3,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 3,                 0,                 3,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 3,                 0,                 0,                 0,                 0,                 0,                 3,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 3,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 3,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 3,                 0,                 0,                 3,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 3,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 3,                 0,                 0,                 3,                 0,                 0,                 0,                 0,                 0,                 3,                 0,                 0,                 0,                 0,                 0,                 3,                 3,                 0,                 0,                 0,                 0,                 3,                 0,                 0,                 0,                 0,                 0,                 3,                 0,                 0,                 0,                 0,                 0,                 3,                 3,                 0,                 0,                 0,                 0,                 3,                 3,                 0,                 3,                 0,                 0,                 3,                 0,                 0,                 0,                 0,                 3,                 3,                 0,                 0,                 3,                 0,                 0,                 0,                 3,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 3,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 3,                 0,                 0,                 3,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 3,                 0,                 0,                 0,                 3,                 0,                 3,                 0,                 0,                 0,                 0,                 0,                 0,                 3,                 3,                 0,                 3,                 0,                 0,                 0,                 0,                 3,                 0,                 0,                 3,                 0,                 0,                 3,                 0,                 0,                 3,                 0,                 0,                 3,                 0,                 0,                 3,                 0,                 0,                 3,                 0,                 0,                 3,                 0,                 0,                 0,                 0,                 0,                 0,                 3,                 0,                 0,                 0,                 0,                 0,                 0,                 3,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 3,                 0,                 0,                 0,                 0,                 0,                 0,                 3,                 0,                 3,                 0,                 0,                 0,                 0,                 0,                 3,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 3,                 0,                 0,                 3,                 0,                 0,                 3,                 0,                 0,                 3,                 0,                 0,                 3,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 3,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 3,                 0,                 0,                 0,                 0,                 3,                 0,                 0,                 0,                 0,                 0,                 0,                 3,                 0,                 0,                 0,                 0,                 0,                 3,                 0,                 0,                 3,                 0,                 0,                 0,                 0,                 3,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 3,                 3,                 0,                 3,                 3,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 3,                 0,                 0,                 0,                 0,                 0,                 3,                 0,                 0,                 0,                 0,                 0,                 3,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 3,                 3,                 3,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 3,                 0,                 3,                 3,                 0,                 3,                 0,                 0,                 3,                 3,                 3,                 0,                 0,                 0,                 3,                 0,                 0,                 3,                 0,                 0,                 3,                 0,                 3,                 0,                 0,                 0,                 0,                 0,                 0,                 3,                 3,                 0,                 0,                 0,                 0,                 0,                 0,                 3,                 0,                 0,                 0,                 3,                 0,                 0,                 3,                 0,                 0,                 3,                 0,                 0,                 3,                 3,                 0,                 0,                 0,                 0,                 3,                 0,                 0,                 0,                 0,                 0,                 3,                 0,                 0,                 3,                 0,                 0,                 0,                 0,                 0,                 3,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 3,                 0,                 0,                 3,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 3,                 0,                 0,                 0,                 0,                 0,                 3,                 3,                 3,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 3,                 0,                 0,                 3,                 0,                 0,                 3,                 0,                 0,                 3,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 3,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 3,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 3,                 3,                 0,                 3,                 0,                 0,                 0,                 3,                 0,                 0,                 3,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 3,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 3,                 3,                 0,                 0,                 0,                 0,                 3,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 3,                 3,                 0,                 0,                 0,                 3,                 0,                 0,                 0,                 0,                 3,                 0,                 0,                 0,                 3,                 3,                 0,                 0,                 0,                 0,                 0,                 0,                 3,                 0,                 0,                 3,                 3,                 0,                 0,                 0,                 0,                 3,                 0,                 0,                 0,                 0,                 0,                 3,                 0,                 0,                 0,                 0,                 0,                 3,                 3,                 0,                 0,                 3,                 0,                 0,                 0,                 3,                 0,                 3,                 0,                 3,                 0,                 0,                 0,                 3,                 3,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 3,                 3,                 0,                 0,                 0,                 0,                 3,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 3,                 0,                 0,                 3,                 0,                 0,                 3,                 0,                 0,                 3,                 3,                 0,                 0,                 0,                 0,                 3,                 0,                 0,                 3,                 0,                 0,                 3,                 3,                 0,                 3,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 3,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 3,                 3,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 3,                 0,                 0,                 3,                 0,                 0,                 0,                 3,                 0,                 3,                 0,                 3,                 3,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 3,                 0,                 0,                 3,                 0,                 0,                 3,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 3,                 0,                 3,                 0,                 0,                 3,                 0,                 0,                 0,                 0,                 0,                 3,                 3,                 0,                 0,                 3,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 3,                 0,                 0,                 0,                 0,                 0,                 3,                 0,                 3,                 0,                 3,                 3,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 3,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 3,                 0,                 0,                 3,                 0,                 0,                 0,                 3,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 3,                 0,                 0,                 3,                 0,                 3,                 0,                 3,                 0,                 0,                 3,                 0,                 0,                 3,                 3,                 3,                 0,                 0,                 0,                 3,                 0,                 3,                 0,                 0,                 0,                 0,                 0,                 3,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 3,                 0,                 0,                 3,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 3,                 0,                 3,                 0,                 3,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 3,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 3,                 3,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 3,                 3,                 0,                 0,                 0,                 3,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 3,                 0,                 0,                 0,                 0,                 0,                 3,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 3,                 0,                 3,                 0,                 0,                 0,                 3,                 0,                 0,                 3,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 3,                 0,                 0,                 0,                 0,                 0,                 3,                 0,                 0,                 0,                 0,                 0,                 3,                 0,                 0,                 0,                 0,                 0,                 3,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 3,                 0,                 0,                 3,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 3,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 3,                 0,                 0,                 0}
};

ExecuteAFile ("../Shared/REL_utils.bf");
marginalErrors = checkMarginalReconstruction ( expectedConditionalProbabilities, exepectedRateClassAssignments, "SmallCodon_LF");

/* test epilogue */
	timeMatrix = endTestTimer 				  (_testDescription);
	if (logTestResult (Abs (res_SmallCodon_LF[1][0] - _expectedLL) < 2*OPTIMIZATION_PRECISION && marginalErrors[0] < 0.0001 && marginalErrors[1] == 0))
	{
		return timeMatrix;
	}
	return 0;
/* end test epilogue */

END;
