/***************************************************************************
 *   Copyright (C) 2004, 2005, 2006 by Stephen McInerney                   *
 *   spm@stedee.id.au                                                      *
 *                                                                         *
 *   $Id: messages.h 58 2006-01-02 10:40:49Z steve $
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

/************************************************************************
 ************************************************************************
 * messages.h
 *
 *  All the various messages to be used
 *
 ************************************************************************
 ************************************************************************/

#ifndef DNSHISTORY_MESSAGES_H
#define DNSHISTORY_MESSAGES_H 1

#define VERBOSE0 0
#define VERBOSE1 1
#define VERBOSE2 2
#define VERBOSE3 3
#define VERBOSE4 4
#define VERBOSE5 5
#define VERBOSE_MAX VERBOSE5

/************************************************************************
 *                              MACROS                                  *
 ************************************************************************/
/* Where verbosity is a global, set once ONLY, defining what level of verboseness we are at */
#define VPRINT(level, message, ...) if (g_verbosity >= (level)) { printf((message), __VA_ARGS__); }
#define ERRVPRINT(level, message, ...) fflush (stdout); if (g_verbosity >= (level)) { fprintf(stderr, (message), __VA_ARGS__); }


/************************************************************************
 *                              GLOBALS                                 *
 ************************************************************************/
extern int g_verbosity;                         /* How many extra stuff to show. If 0, none
                                                   Bigger numbers, show more. */

/************************************************************************
 *                              MESSAGES                                *
 *                                                                      *
 * Are of the format msg_<level>_<name>                                 *
 *  Where level is:                                                     *
 *    I :- Informational                                                *
 *    W :- Warning                                                      *
 *    E :- Error, but not fatal                                         *
 *    F :- Fatal Error                                                  *
 *                                                                      *
 *    vx : - where x is numerical from 1 (1,2,3 etc)                    *
 *              is a debugging/verbosity message                        *
 *              The higher the number, the less likely to be seen       *
 ************************************************************************/
extern const char *msg_I_number_bad_lines;


extern const char *msg_W_exceeded_verbosity;
extern const char *msg_W_line_too_big;
extern const char *msg_W_re_match_failed;
extern const char *msg_W_re_match_error;
extern const char *msg_W_mismatched_lines;
extern const char *msg_W_import_line_too_long;
extern const char *msg_W_import_line_failure;

extern const char *msg_namelookup_try_agin;
extern const char *msg_namelookup_default;


extern const char *msg_v1_hashdb;
extern const char *msg_v2_create_hashdb;
extern const char *msg_v2_create_dbcache;
extern const char *msg_v2_no_dbcache;


extern const char *msg_E_log_misordered;
extern const char *msg_E_re_too_many_substrings;
extern const char *msg_E_ip_conversion;

extern const char *msg_E_pcre_unknown;
extern const char *msg_E_pcre_no_memory;
extern const char *msg_E_substring_extraction;
extern const char *msg_E_pcre_nonexist_substring;

extern const char *msg_E_thread_stack_resize;
extern const char *msg_E_thread_creation;
extern const char *msg_E_thread_lock;
extern const char *msg_E_thread_unlock;


extern const char *msg_F_db_create;
extern const char *msg_F_db_cache;
extern const char *msg_F_db_close;
extern const char *msg_F_db_cursor;

extern const char *msg_F_file_open;
extern const char *msg_F_mem_alloc_hash;
extern const char *msg_F_memory_alloc;

extern const char *msg_F_pcre_failed_compilation;
extern const char *msg_F_run_start_datetime;
extern const char *msg_F_vital_substring;

extern const char *msg_F_incompatible_options;
extern const char *msg_F_mismatched_lines;
extern const char *msg_F_early_log_termination;

#endif          /* DNSHISTORY_MESSAGES_H */

/************************************************************************
 ************************************************************************
 *                      END OF FILE                                     *
 ************************************************************************
 ************************************************************************/
