#include "org.kbinani.media.helper.h"

static HWAVEOUT wave_out = NULL;
static WAVEFORMATEX wave_format;
static WAVEHDR wave_header[NUM_BUF];
static DWORD *wave[NUM_BUF];
static bool wave_done[NUM_BUF];
static int buffer_index = 0; // ̃f[^ރobt@̔ԍ
static int buffer_loc = 0; // ̃f[^ވʒu
static CRITICAL_SECTION locker;
static bool abort_required;
static int block_size = 4410; // ubNTCY
static int block_size_used; // SoundPrepareŏꂽubNTCY

#ifdef __cplusplus
extern "C" {
#endif

void SoundUnprepare() {
    if ( NULL == wave_out ) {
        return;
    }

    EnterCriticalSection( &locker );
    for ( int i = 0; i < NUM_BUF; i++ ) {
        waveOutUnprepareHeader( wave_out,
                                &(wave_header[i]),
                                sizeof( WAVEHDR ) );
        free( wave_header[i].lpData );
    }
    waveOutClose( wave_out );
    wave_out = NULL;
    LeaveCriticalSection( &locker );
}

void SoundInit() {
    InitializeCriticalSection( &locker );
}

void SoundKill() {
    SoundExit();
    DeleteCriticalSection( &locker );
}

double SoundGetPosition() {
    if ( NULL == wave_out ) {
        return 0.0;
    }

    MMTIME mmt;
    mmt.wType = TIME_MS;
    EnterCriticalSection( &locker );
    waveOutGetPosition( wave_out, &mmt, sizeof( MMTIME ) );
    LeaveCriticalSection( &locker );
    float ms = 0.0f;
    switch ( mmt.wType ) {
        case TIME_MS:
            return mmt.u.ms * 0.001;
        case TIME_SAMPLES:
            return (double)mmt.u.sample / (double)wave_format.nSamplesPerSec;
        case TIME_BYTES:
            return (double)mmt.u.cb / (double)wave_format.nAvgBytesPerSec;
        default:
            return 0.0;
    }
    return 0.0;
}

void SoundWaitForExit() {
    if ( NULL == wave_out ) {
        return;
    }

    EnterCriticalSection( &locker );
    // buffer_indexNUM_BUFȂA܂1waveOutWriteĂȂ̂ŁA
    if ( buffer_index < NUM_BUF ) {
        for ( int i = 0; i < buffer_index; i++ ) {
            if( abort_required ) break;
            wave_done[i] = false;
            waveOutWrite( wave_out, &(wave_header[i]), sizeof( WAVEHDR ) );
        }
    }

    // ܂łȂobt@ꍇAc
    if ( buffer_loc != 0 ) {
        int act_buffer_index = buffer_index % NUM_BUF;

        // obt@gp̏ꍇAgpIƂȂ̂҂󂯂
        while ( !wave_done[act_buffer_index] ) {
            if( abort_required ) break;
            Sleep( 0 );
        }

        if( !abort_required ){
            // 㔼0Ŗ߂
            for ( int i = buffer_loc; i < block_size_used; i++ ) {
                wave[act_buffer_index][i] = MAKELONG( 0, 0 );
            }

            buffer_loc = 0;
            buffer_index++;

            wave_done[act_buffer_index] = false;
            waveOutWrite( wave_out, &wave_header[act_buffer_index], sizeof( WAVEHDR ) );
        }
    }

    // NUM_BUF̃obt@ׂĂwave_doneƂȂ̂҂B
    while ( !abort_required ) {
        bool all_done = true;
        for ( int i = 0; i < NUM_BUF; i++ ) {
            if ( !wave_done[i] ) {
                all_done = false;
                break;
            }
        }
        if ( all_done ) {
            break;
        }
    }
    LeaveCriticalSection( &locker );

    // Zbg
    SoundExit();
}

void SoundSetResolution( int resolution ){
    block_size = resolution;
}

void SoundAppend( double *left, double *right, int length ) {
    if ( NULL == wave_out ) {
        return;
    }
    EnterCriticalSection( &locker );
    int appended = 0; // ]f[^̌
    while ( appended < length ) {
        // ̃[vł́Aobt@1Âf[^]

        // obt@gp̏ꍇAgpIƂȂ̂҂󂯂
        int act_buffer_index = buffer_index % NUM_BUF;
        while ( !wave_done[act_buffer_index] && !abort_required ) {
            Sleep( 0 );
        }

        int t_length = block_size_used - buffer_loc; // ]f[^̌
        if ( t_length > length - appended ) {
            t_length = length - appended;
        }
        for ( int i = 0; i < t_length && !abort_required; i++ ) {
            wave[act_buffer_index][buffer_loc + i] = MAKELONG( (WORD)(left[appended + i] * 32768.0), (WORD)(right[appended + i] * 32768.0) );
        }
        appended += t_length;
        buffer_loc += t_length;
        if ( buffer_loc == block_size_used ) {
            // obt@ςɂȂ悤
            buffer_index++;
            buffer_loc = 0;
            if ( buffer_index >= NUM_BUF ) {
                // ŏNUM_BUF̃obt@́AׂẴobt@ɓ]I܂
                // waveOutWriteȂ悤ɂĂ̂ŁAwaveOutWriteB
                if ( buffer_index == NUM_BUF ) {
                    for ( int i = 0; i < NUM_BUF; i++ ) {
                        if( abort_required ) break;
                        wave_done[i] = false;
                        waveOutWrite( wave_out, &wave_header[i], sizeof( WAVEHDR ) );
                    }
                } else {
                    wave_done[act_buffer_index] = false;
                    if( !abort_required ){
                        waveOutWrite( wave_out, &wave_header[act_buffer_index], sizeof( WAVEHDR ) );
                    }
                }
            }
        }
    }
    LeaveCriticalSection( &locker );
}

/// <summary>
/// R[obN֐Bobt@̍ĐIo邽߂ɎgpB
/// </summary>
/// <param name="hwo"></param>
/// <param name="uMsg"></param>
/// <param name="dwInstance"></param>
/// <param name="dwParam1"></param>
/// <param name="dwParam2"></param>
void SoundCallback(
    HWAVEOUT hwo,
    UINT uMsg,
    DWORD dwInstance,
    DWORD dwParam1,
    DWORD dwParam2 ) {
    if ( uMsg != MM_WOM_DONE ) {
        return;
    }

    for ( int i = 0; i < NUM_BUF; i++ ) {
        if ( &wave_header[i] != (WAVEHDR*)dwParam1 ) {
            continue;
        }
        wave_done[i] = true;
        break;
    }
}

/// <summary>
/// foCX
/// </summary>
/// <param name="sample_rate"></param>
int SoundPrepare( int sample_rate ) {
    // foCXgp̏ꍇAgp~
    if ( NULL != wave_out ) {
        SoundExit();
        SoundUnprepare();
    }

    EnterCriticalSection( &locker );
    // tH[}bgw
    wave_format.wFormatTag = WAVE_FORMAT_PCM;
	wave_format.nChannels = 2;
    wave_format.wBitsPerSample = 16;
    wave_format.nBlockAlign
        = wave_format.nChannels * wave_format.wBitsPerSample / 8;
    wave_format.nSamplesPerSec = sample_rate;
    wave_format.nAvgBytesPerSec
        = wave_format.nSamplesPerSec * wave_format.nBlockAlign;

    // foCXJ
    MMRESULT ret = 
		waveOutOpen( 
			&wave_out,
            WAVE_MAPPER,
            &wave_format,
            (DWORD_PTR)SoundCallback,
            NULL,
            CALLBACK_FUNCTION );

    // obt@
    block_size_used = block_size;
    for ( int i = 0; i < NUM_BUF; i++ ) {
        wave[i] = (DWORD *)malloc( (int)(sizeof( DWORD ) * block_size_used) );
        wave_header[i].lpData = (LPSTR)wave[i];
        wave_header[i].dwBufferLength = sizeof( DWORD ) * block_size_used;
        wave_header[i].dwFlags = WHDR_BEGINLOOP | WHDR_ENDLOOP;
        wave_header[i].dwLoops = 1;
        waveOutPrepareHeader( wave_out, &wave_header[i], sizeof( WAVEHDR ) );

        wave_done[i] = true;
    }

    buffer_index = 0;
    buffer_loc = 0;
    abort_required = false;

    LeaveCriticalSection( &locker );

	return (int)ret;
}

/// <summary>
/// ĐƂ߂B
/// </summary>
void SoundExit() {
    if ( NULL != wave_out ) {
        abort_required = true;
        EnterCriticalSection( &locker );
        waveOutReset( wave_out );
        LeaveCriticalSection( &locker );
    }
}

#ifdef __cplusplus
} // extern "C"
#endif
