#ifndef FFMPEG_FILLPLUGINS_H
#define FFMPEG_FILLPLUGINS_H

#include "infotypes.h"
#include "avm_fourcc.h"

#include "avm_avformat.h"
//#include "libavcodec/opt.h"

#include <string.h>
#include <stdlib.h>
//#include <stdio.h> // remove

AVM_BEGIN_NAMESPACE;

#define FFCSTR(name) \
    static const char ffstr_ ## name[] = #name

FFCSTR(dr1);

struct FCodec {
    const char* const ffname;	// name in ffmpeg library
    const char* const optname;	// "ff" + optional name for user, 0 = "ff" + "ffname"
    const char* const info;	// short info
    const char* const about;	// long about, 0 = repeat last
    const fourcc_t* const fcc;	// list of FourCC's
    const GUID* const guid;	// list of FourCC's

};

static void libffmpeg_get_attr(avm::vector<AttributeInfo>& a, AVCodec* codec)
{
    if (!codec)
	return;
#if 0
    AVCodecContext* ctx = avcodec_alloc_context();
    static bool first = true;
    const AVOption* o = ctx->av_class->option;
    while (first) {
	if (o->name)
	    printf("OPT %s\n", o->name);
	else
	    first = false;
	o++;
    }
    free(ctx);
#endif

#if 0
    if (c) {
	const AVOption *stack[FF_OPT_MAX_DEPTH];
	int depth = 0;
	for (;;) {
	    //printf("NAME  %s\n", c->name);
	    if (!c->name) {
		if (c->help) {
		    stack[depth++] = c;
		    c = (const AVOption*)c->help;
		} else {
		    if (depth == 0)
			break; // finished
		    c = stack[--depth];
		    c++;
		}
	    } else {
		int t = c->type & FF_OPT_TYPE_MASK;
		char* arr[100];
		char* dealloc;
#if 0
		printf("Config	 %s  %s\n",
		       t == FF_OPT_TYPE_BOOL ? "bool   " :
		       t == FF_OPT_TYPE_DOUBLE ? "double  " :
		       t == FF_OPT_TYPE_INT ? "integer" :
		       t == FF_OPT_TYPE_STRING ? "string " :
		       "unknown??", c->name);
#endif
		switch (t) {
		case FF_OPT_TYPE_BOOL:
		    a.push_back(AttributeInfo(c->name, c->help,
					      AttributeInfo::Integer,
					      0, 1, (int)c->defval));
		    break;
		case FF_OPT_TYPE_DOUBLE:
		    a.push_back(AttributeInfo(c->name, c->help,
					      c->defval, c->min,c->max));
		    break;
		case FF_OPT_TYPE_INT:
		    a.push_back(AttributeInfo(c->name, c->help,
					      AttributeInfo::Integer,
					      (int)c->min, (int)c->max,
					      (int)c->defval));
		    break;
		case FF_OPT_TYPE_STRING:
		    t = 0;
		    dealloc = 0;
		    if (c->defstr)
		    {
			char* tmp = dealloc = strdup(c->defstr);
			if (tmp)
			{
			    char* semi;
			    while (tmp && (semi = strchr(tmp, ';')))
			    {
				*semi++ = 0;
				arr[t++] = tmp;
				if (t > 97)
				    break; // weird - too many string options ???
				tmp = semi;
			    }
			    arr[t++] = tmp;
			}
			arr[t] = 0;
		    }
		    //printf("%d   %s\n", i, cnf->name);
		    a.push_back((t > 1) ? AttributeInfo(c->name, c->help, (const char**)arr, (int)c->defval)
				: AttributeInfo(c->name, c->help, AttributeInfo::String));
		    if (dealloc)
			free(dealloc);
		    break;
/*
		    if (c->defstr) {
			char* d = av_strdup(c->defstr);
			char* f = strchr(d, ',');
			if (f)
			    *f = 0;
			i += sprintf(def + i, "%s%s=%s",
				     col, c->name, d);
			av_free(d);
		    }
		    break;
		    */
		}
		c++;
	    }
	}
    }
#endif
}

static void libffmpeg_fill_decattr(avm::vector<AttributeInfo>& a, const char* cd)
{
    a.clear();
    a.push_back(AttributeInfo(ffstr_dr1, "Direct Rendering 1", AttributeInfo::Integer, 0, 1, 1));
    if (cd) libffmpeg_get_attr(a, avcodec_find_decoder_by_name(cd));
}

static void libffmpeg_fill_encattr(avm::vector<AttributeInfo>& a, const char* cd)
{
    a.clear();
    libffmpeg_get_attr(a, avcodec_find_encoder_by_name(cd));
}

static void libffmpeg_add(avm::vector<CodecInfo>& ci, const FCodec* s, CodecInfo::Media m, CodecInfo::Direction d)
{
    char loptname[40] = "ff";
    char linfo[50] = "FF ";
    char labout[300] = "FFMPEG ";
    avm::vector<AttributeInfo> da;
    if (m == CodecInfo::Video)
	libffmpeg_fill_decattr(da, 0);
    while (s->fcc) {
	const char* coder;
	strcpy(loptname + 2,  s->optname ? s->optname : s->ffname);
	strcpy(linfo + 3, s->info);
	strcpy(labout + 7, (s->about) ? s->about : s->info);
	switch (d) {
	case CodecInfo::Decode: coder = " decoder"; break;
	case CodecInfo::Encode: coder = " encoder"; break;
	case CodecInfo::Both:
	default: coder = " codec"; break;
	}
	strcat(labout, coder);

	ci.push_back(CodecInfo(s->fcc, linfo, s->ffname, labout, CodecInfo::Plugin, loptname,
			       m,  d, s->guid, 0, da));
	s++;
    }
}

static void libffmpeg_add_video(avm::vector<CodecInfo>& ci)
{
    const fourcc_t s_DIV3[] = {
	fccDIV3, fccdiv3, fccDIV4, fccdiv4,
	fccDIV5, fccdiv5, fccDIV6, fccdiv6,
	fccMP41, fccMP43, RIFFINFO_MPG3, RIFFINFO_mpg3,
	fccAP41, fccap41, fccAP42, fccap42,
	mmioFOURCC('C', 'O', 'L', '1'), // Cool codec
	mmioFOURCC('c', 'o', 'l', '1'),
	mmioFOURCC('C', 'O', 'L', '0'),
	mmioFOURCC('c', 'o', 'l', '0'),
	mmioFOURCC('3', 'I', 'V', 'D'), // 3ivx.com
	mmioFOURCC('3', 'i', 'v', 'd'),
	0 };
    const fourcc_t s_DIVX[] = { // OpenDivX
	fccDIVX, fccdivx, fccMP4S, fccmp4s,
	RIFFINFO_XVID, RIFFINFO_XviD, RIFFINFO_xvid,
	mmioFOURCC('m', 'p', '4', 'v'),
	mmioFOURCC('U', 'M', 'P', '4'),
	mmioFOURCC('3', 'I', 'V', '1'),
	mmioFOURCC('3', 'I', 'V', '2'),
	mmioFOURCC('3', 'i', 'v', '2'),
	mmioFOURCC('F', 'M', 'P', '4'),
	0x4, 0 };
    const fourcc_t s_MPEG12[] = { RIFFINFO_MPG1, RIFFINFO_MPG2,
	0x10000001, 0x10000002,	// mplayer's MPEG-PES 1/2
	mmioFOURCC('M', 'P', 'E', 'G'),
	0 };
    const fourcc_t s_DX50[] = { fccDX50, fccdx50, 0 };
    const fourcc_t s_WMV1[] = { fccWMV1, fccwmv1, 0 };
    const fourcc_t s_WMV2[] = { fccWMV2, fccwmv2, 0 };
    const fourcc_t s_WMV3[] = { RIFFINFO_WMV3, RIFFINFO_wmv3, 0 };
    const fourcc_t s_MP41[] = { fccMPG4, fccmpg4, fccDIV1, fccdiv1, 0 };
    const fourcc_t s_MP42[] = { fccMP42, fccmp42, fccDIV2, fccdiv2, 0 };
    const fourcc_t s_VP3[] = { fccVP31, fccvp31, fccVP30, fccVP30, 0 };
    const fourcc_t s_PIM1[] = { fccPIM1, 0 };
    const fourcc_t s_SVQ1[] = { mmioFOURCC('S', 'V', 'Q', '1'), 0 };
    const fourcc_t s_SVQ3[] = { mmioFOURCC('S', 'V', 'Q', '3'), 0 };
    const fourcc_t s_MJPG[] = {
	fccMJPG, fccmjpg,
	mmioFOURCC('A', 'V', 'R', 'n'),
	mmioFOURCC('A', 'V', 'D', 'J'),
	mmioFOURCC('J', 'P', 'E', 'G'),
	mmioFOURCC('j', 'p', 'e', 'g'),
	mmioFOURCC('m', 'j', 'p', 'b'),
	0 };
    const fourcc_t s_H264[] = {
	mmioFOURCC('H', '2', '6', '4'),
	mmioFOURCC('h', '2', '6', '4'),
	mmioFOURCC('a', 'v', 'c', '1'),
	mmioFOURCC('d', 'a', 'v', 'c'),
	mmioFOURCC('D', 'A', 'V', 'C'),
	0 };
    const fourcc_t s_H263[] = {
	fccH263, fcch263, fccU263, fccu263,
	mmioFOURCC('s', '2', '6', '3'),
	0 };
    const fourcc_t s_I263[] = { fccI263, fcci263, 0 };
    const fourcc_t s_DV[] = {
	fccDVSD, fccdvsd, fccdvhd, fccdvsl,
	mmioFOURCC('D', 'V', 'C', 'S'),
	mmioFOURCC('d', 'v', 'c', 's'),
	mmioFOURCC('d', 'v', 'c', 'p'),
	mmioFOURCC('d', 'v', 'c', ' '),
	0 };
    const fourcc_t s_HUF[] = { fccHFYU, 0 };
    const fourcc_t s_INDEO3[] = {
	RIFFINFO_IV31, RIFFINFO_iv31, RIFFINFO_IV32, RIFFINFO_iv31, 0
    };
    const fourcc_t s_ASV1[] = { fccASV1, 0 };
    const fourcc_t s_ASV2[] = { fccASV1, 0 };
    const fourcc_t s_FFV1[] = { mmioFOURCC('F', 'F', 'V', '1'), 0 };
    const fourcc_t s_VCR1[] = { fccVCR1, 0 };
    const fourcc_t s_VCR2[] = { fccVCR2, 0 };
    const fourcc_t s_MSVIDEO1[] = {
	fccCRAM, fcccram, fccMSVC,
	mmioFOURCC('m', 's', 'v', 'c'),
	mmioFOURCC('w', 'h', 'a', 'm'),
	mmioFOURCC('W', 'H', 'A', 'M'),
	0
    };
    const fourcc_t s_FLV1[] = {
	mmioFOURCC('F', 'L', 'V', '1'),
	mmioFOURCC('f', 'l', 'v', '1'),
	0
    };
    const fourcc_t s_WVC1[] = {
	mmioFOURCC('W', 'V', 'C', '1'),
	mmioFOURCC('w', 'v', 'c', '1'),
	0
    };

    const fourcc_t s_CODECID[] = {
	CodecInfo::FFMPEG,
	0
    };

    // video decoders
    const FCodec dec_video[] = {
	{ "mpeg4", "dx50", "DivX5", "DivX 5.0", s_DX50, 0 }, // both
	{ "huffyuv", 0, "Huffyuv", 0, s_HUF, 0 }, //both
	{
	    "msmpeg4", "divx", "DivX ;-)",
	    "LGPL version of popular M$ MPEG-4 video codec v3. "
	    "Advanced compression technologies allow it to "
	    "compress 640x480x25 video with a perfect "
	    "quality into 100-150 kbytes/s ( 3-4 times "
	    "less than MPEG-2 ).", s_DIV3, 0 },
	{ "mpeg4", "odivx", "OpenDivX", "OpenDivX MPEG-4", s_DIVX, 0 },
	{ "wmv1", 0, "Windows Media Video 7", "Windows Media Video 7/WMV1", s_WMV1, 0 },
	{ "wmv2", 0, "Windows Media Video 8", "Windows Media Video 8/WMV2", s_WMV2, 0 },
	{ "wmv3", 0, "Windows Media Video 9", "Windows Media Video 9/WMV3", s_WMV3, 0 },
	{ "msmpeg4v1", "mp41", "M$ MPEG-4 v1", 0, s_MP41, 0 },
	{ "msmpeg4v2", "mp42", "M$ MPEG-4 v2", 0, s_MP42, 0 },
	{ "mpegvideo", "mpeg", "MPEG 1/2", 0, s_MPEG12, 0 },
	{ "vp3", 0, "VP3", 0, s_VP3, 0 },
	{ "mpegvideo", "pim1", "PinnacleS PIM1", 0, s_PIM1, 0 },
	{ "svq1", 0, "SVQ1", "Sorenson 1", s_SVQ1, 0 },
	{ "svq3", 0, "SVQ3", "Sorenson 3", s_SVQ3, 0 },
	{ "mjpeg", 0, "Motion JPEG", 0, s_MJPG, 0 },
	{ "h264", 0, "H264", 0, s_H264, 0 },
	{ "h263", 0, "H263+", 0, s_H263, 0 },
	{ "h263i", 0, "I263", 0, s_I263, 0 },
	{ "dvvideo", "dv", "DV Video", 0, s_DV, 0 },
	{ "indeo3", 0, "Indeo 3", 0, s_INDEO3, 0 },
	{ "asv1", 0, "ASUS V1", 0, s_ASV1, 0 },
	{ "asv2", 0, "ASUS V2", 0, s_ASV2, 0 },
	{ "vcr1", 0, "VCR1", "ATI VCR-1", s_VCR1, 0 },
	{ "vcr2", 0, "VCR2", "ATI VCR-2", s_VCR2, 0 },
	{ "ffv1", 0, "FFV1", "FFV1 looseless", s_FFV1, 0 },
	{ "flv", 0, "FLV", "FLV", s_FLV1, 0 },
	{ "vc1", 0, "WVC", "WVC", s_WVC1, 0 },
	{ "msvideo1", "video1", "MSVideo1", "Microsoft Video 1", s_MSVIDEO1, 0 },
	{ "vcodec", 0, "FFMPEG", "Universal FFMPEG Video Codec", s_CODECID, 0 },

/*	ci.push_back(CodecInfo(msvideo1_codecs, "FF MSVideo1", "msvideo1",
			       "FF Microsoft Video 1 codec", CodecInfo::Plugin, "ffvideo1",
			       CodecInfo::Video, CodecInfo::Decode, 0, 0, da));
			       */
	{ 0, 0, 0, 0, 0, 0 }
    };
    libffmpeg_add(ci, dec_video, CodecInfo::Video, CodecInfo::Decode);
}
//da.push_back(AttributeInfo("Hue", "Hue", AttributeInfo::Integer, 0, 100));
//libffmpeg_fill_decattr(da, mpeg4_str);
//avm::vector<AttributeInfo> va;
//libffmpeg_fill_encattr(va, mpeg4_str);


static void libffmpeg_add_audio(avm::vector<CodecInfo>& ci)
{
    const fourcc_t s_MP2[] = { WAVE_FORMAT_MPEG, 0 };
    const fourcc_t s_MP3[] = { WAVE_FORMAT_MPEGLAYER3,
	mmioFOURCC('.', 'm', 'p', '3'),
	mmioFOURCC('L', 'A', 'M', 'E'),
	mmioFOURCC('M', 'P', '3', ' '),
	0 };
    const fourcc_t s_MS[] = { WAVE_FORMAT_ADPCM, 0 };
    const fourcc_t s_ALAW[] = { WAVE_FORMAT_ALAW, 0 };
    const fourcc_t s_ULAW[] = { WAVE_FORMAT_MULAW, 0 };
    const fourcc_t s_IMAWAV[] = { WAVE_FORMAT_DVI_ADPCM, 0 }; // unsure
    const fourcc_t s_IMAQT[] = { 0x11, ('m' | ('i' << 8)), // ima4 0x34616d69
	0 }; // unsure
    const fourcc_t s_YAMAHA[] = { WAVE_FORMAT_YAMAHA_ADPCM, 0 };
    const fourcc_t s_G726[] = { WAVE_FORMAT_SPG726, 0 };
    const fourcc_t s_IMA_DK4[] = { WAVE_FORMAT_ESPCM, 0 };
    const fourcc_t s_IMA_DK3[] = { WAVE_FORMAT_VOXWARE, 0 };
    const fourcc_t s_WMA1[] = { WAVE_FORMAT_MSAUDIO1, 0 };
    const fourcc_t s_WMA2[] = { WAVE_FORMAT_MSAUDIO2, 0 };
    const fourcc_t s_DVAUDIO[] = { (('D' << 8) | 'A'), 0 };
    const fourcc_t s_MACE6[] = { ('A' | ('M' << 8)), 0 }; // unsure
    const fourcc_t s_RA144[] = { mmioFOURCC('1', '4', '_', '4'), 0x3431, 0 };
    const fourcc_t s_RA288[] = { mmioFOURCC('2', '8', '_', '8'), 0x3431, 0 };
    const fourcc_t s_AAC[] = {
	('m' | ('p' << 8)), ('M' | ('P' << 8)),
	mmioFOURCC('m', 'p', '4', 'a'), mmioFOURCC('M', 'P', '4', 'A'),
	0 };
    const fourcc_t s_AC3[] = { WAVE_FORMAT_DVM, 0 };
    const fourcc_t s_DTS[] = { 0x2001, 0x10, 0 };
    const fourcc_t s_EXTENSIBLE[] = { WAVE_FORMAT_EXTENSIBLE, 0 };
    const GUID vorbis_guid = {
        0x6bA47966, 0x3F83, 0x4178,
	{0x96, 0x65, 0x00, 0xF0, 0xBF, 0x62, 0x92, 0xE5}
    };

    const FCodec dec_audio[] = {
	{ "mp2", 0, "MPEG Layer-2", "MPEG Layer-II", s_MP2, 0 },
	{ "mp3", 0, "MPEG Layer-3", "MPEG Layer-III", s_MP3, 0 },
	{ "adpcm_ms", "adpcmms", "MS ADPCM", 0, s_MS, 0 },
	{ "pcm_alaw", "alaw", "ALaw", 0, s_ALAW, 0 },
	{ "pcm_mulaw", "mulaw", "uLaw", 0, s_ULAW, 0 },
	{ "wmav1", 0, "WMA v1", "Windows Media Audio v1", s_WMA1, 0 },
	{ "wmav2", 0, "WMA v2", "Windows Media Audio v2", s_WMA2, 0 },
	{ "adpcm_ima_qt", "imaqt", "IMA Qt", 0, s_IMAQT, 0 },
	{ "adpcm_ima_wav", "imawav", "IMA WAV", 0, s_IMAWAV, 0 },
	{ "dvaudio", "dva", "DV Audio", 0, s_DVAUDIO, 0 },
	{ "mace6", "mac6", "MACE6 Qt", "Macintosh Audio Compression and Expansion 6:1", s_MACE6, 0 },
	{ "real_144", "ra144", "Real 144", "Real Audio 14.4kbps", s_RA144, 0 },
	{ "real_288", "ra288", "Real 288", "Real Audio 28.8kbps", s_RA288, 0 },
	{ "ac3", 0, "AC3", "ATSC A/52A AC-3", s_AC3, 0 },
	{ "eac3", 0, "EAC3", "ATSC A/52B (AC-3, E-AC-3)", s_AC3, 0 },
	{ "dts", 0, "DTS", 0, s_DTS, 0 },
	{ "libfaad", "aac", "FAAD (runtime)", "FAAD - MPEG2/MPEG4 AAC Freeware Advanced Audio Decoder, "
	"http://www.audiocoding.com/ Copyright (C) 2002 M. Bakker", s_AAC, 0 },
	{ "acodec", 0, "FFMPEG", "Universal FFMPEG Audio Codec", s_EXTENSIBLE, &CodecInfo::FFMPEG_GUID },
	{ 0, 0, 0, 0, 0, 0 }
    };
    libffmpeg_add(ci, dec_audio, CodecInfo::Audio, CodecInfo::Decode);
}

static void ffmpeg_FillPlugins(avm::vector<CodecInfo>& ci)
{
    libffmpeg_add_video(ci);
    libffmpeg_add_audio(ci);
}

AVM_END_NAMESPACE;

#endif // FFMPEG_FILLPLUGINS_H
