/*
 * Simple X11 client-side cursor
 * Header file
 *
 * $Id: xcursor.h,v 1.2 2003/02/09 10:11:10 hsteoh Exp hsteoh $
 */

#ifndef XCURSOR_H
#define XCURSOR_H

#include "xsprite.h"
#include "xutil.h"


class xcursor {
  xsprite_engine *eng;			// [R]
  Drawable d;
  xflatsprite *cursor;			// [R]
  xsavebuf bckgnd;
  int visible:1;
  int x,y;				// last known cursor position

  void draw();
public:
  xcursor(xsprite_engine *eng, Drawable d, xflatsprite *cursor, int max_wd,
          int max_ht);
  ~xcursor();

  void set_sprite(xflatsprite *cursor);

  // Turn cursor on/off.
  void on();
  void off();

  void move(int x, int y);

  // Access functions
  int is_on() { return visible; }
  int is_off() { return !visible; }
  int xcoor() { return x; }
  int ycoor() { return y; }
};


#endif // XCURSOR_H
