/********************************************************************************
* Copyright (c) Erik Kunze 1998
*
* Permission to use, distribute, and sell this software and its documentation
* for any purpose is hereby granted without fee, provided that the above
* copyright notice appear in all copies and that both that copyright notice and
* this permission notice appear in supporting documentation, and that the name
* of the copyright holder not be used in advertising or publicity pertaining to
* distribution of the software without specific, written prior permission.  The
* copyright holder makes no representations about the suitability of this
* software for any purpose.  It is provided "as is" without express or implied
* warranty. THE CODE MAY NOT BE MODIFIED OR REUSED WITHOUT PERMISSION!
*
* THE COPYRIGHT HOLDER DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
* INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO
* EVENT SHALL THE COPYRIGHT HOLDER BE LIABLE FOR ANY SPECIAL, INDIRECT OR
* CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
* DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
* TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
* PERFORMANCE OF THIS SOFTWARE.
*
* Author: Erik Kunze
*******************************************************************************/
#ifdef HAVE_CONFIG_H
# include "config.h"
#endif
#ifdef NAS_AUDIO
#ifndef lint
static char rcsid[] = "$Id: nas.c,v 4.4 1998/12/14 13:44:06 erik Rel $";
#endif
#include <sys/types.h>
#include <signal.h>
#include <audio/audiolib.h>
#include "debug.h"
#include "resource.h"
#include "util.h"
#include "audio.h"
#ifdef DEBUG
#define DEB(x)				{ if (GETCFG(debug) & D_AUDIO) { x } }
#else
#define DEB(x)
#endif
static AuBool nasIoError(AuServer *);
static AuServer *nasServer = (AuServer *)0;
static AuDeviceID nasDevice = AuNone;
static AuFlowID nasChannel;
static sigset_t blockingSet;
int
OsdOpenAudioDevice(char *device, int sample)
{
AuElement elements[2];
int i;
if (!(nasServer = AuOpenServer(NULL, 0, NULL, 0, NULL, NULL)))
{
Msg(M_ERR, "couldn't connect to audio server");
return -1;
}
for (i = 0; i < AuServerNumDevices(nasServer); i++)
{
if ((AuDeviceKind(AuServerDevice(nasServer, i)) ==
AuComponentKindPhysicalOutput)
&& AuDeviceNumTracks(AuServerDevice(nasServer, i)) == 1)
{
nasDevice = AuDeviceIdentifier(AuServerDevice(nasServer, i));
break;
}
}
if (nasDevice == AuNone)
{
Msg(M_ERR, "couldn't find output device");
goto error;
}
if (!(nasChannel = AuCreateFlow(nasServer, NULL)))
{
Msg(M_ERR, "couldn't create flow");
goto error;
}
DEB(Msg(M_DEBUG, "AU: server           %s",
AuServerString(nasServer));
Msg(M_DEBUG, "AU: min sample rate  %5u",
AuServerMinSampleRate(nasServer));
Msg(M_DEBUG, "AU: max sample rate  %5u",
AuServerMaxSampleRate(nasServer)););
(void)AuSetIOErrorHandler(nasServer, nasIoError);
AuMakeElementImportClient(&elements[0],
(unsigned short)sample, AuFormatLinearUnsigned8,
(unsigned char)1,
AuTrue,
(AuUint32)1000, (AuUint32)0,
0, NULL);
AuMakeElementExportDevice(&elements[1], 0,
nasDevice,
(unsigned short)sample, AuUnlimitedSamples,
0, NULL);
AuSetElements(nasServer, nasChannel, AuTrue, 2, elements, NULL);
AuStartFlow(nasServer, nasChannel, NULL);
sigemptyset(&blockingSet);
sigaddset(&blockingSet, SIGALRM);
return sample;
error:
AuCloseServer(nasServer);
nasServer = (AuServer *)0;
return -1;
}
void
OsdCloseAudioDevice(void)
{
if (nasServer)
{
AuStopFlow(nasServer, nasChannel, NULL);
AuCloseServer(nasServer);
nasServer = (AuServer *)0;
}
}
int
OsdDrainAudioDevice(void)
{
AuFlush(nasServer);
return 0;
}
size_t
OsdGetAudioFreespace(void)
{
return (size_t)1024;
}
size_t
OsdPlayAudioBuffer(unsigned char *buf, size_t len)
{
sigset_t oldSet;
size_t written;
AuStatus status;
(void)sigprocmask(SIG_BLOCK, &blockingSet, &oldSet);
AuWriteElement(nasServer, nasChannel, 0, (AuUint32)len, (AuPointer)buf,
AuFalse, &status);
if (!sigismember(&oldSet, SIGALRM))
{
(void)sigprocmask(SIG_UNBLOCK, &blockingSet, NULL);
}
return len;
}
static AuBool
nasIoError(AuServer *server)
{
Quit(1);
return AuTrue;
}
#endif
