#include <stdio.h>

#include <xview/xview.h>
#include <xview/panel.h>
#include "generic.h"

typedef struct {
	ltgenericd g;
	Panel_item t;	/* xview panel item */
	int (*do_events)();
	} ltpbuttond, *ltpbutton;

int tpbutton_right_side(t)
ltpbutton t;
{
	/* check type */
	if(t==NULL)
		return(0);
	if(titem_type(t)!=lt_pbutton)
		return(0);
	
	return(xv_get(t->t, XV_X)+xv_get(t->t, XV_WIDTH));
}

int tpbutton_bottom_side(t)
ltpbutton t;
{
	/* check type */
	if(t==NULL)
		return(0);
	if(titem_type(t)!=lt_pbutton)
		return(0);
	
	return(xv_get(t->t, XV_Y)+xv_get(t->t, XV_HEIGHT));
}

Panel_setting tpbutton_notify(item, e)
Panel_item item;
Event *e;
{
    ltpbutton t;
    int a;
	tevent te;

    t=(ltpbutton)xv_get(item, PANEL_CLIENT_DATA);

    if(t->do_events!=NULL)
	{
		te=tevent_create_from_xviewevent(e, event_x(e), event_y(e), 0, 0);
		a=(*t->do_events)(t, te);
		tevent_free(te);
	}
    return(XV_OK);
}

tpbutton tpbutton_new(parent, x,y,w,h,right,below, name)
tpanel parent;
int x,y,w,h;
titem right,below;
char *name;
{
	ltpbutton tmp;

	/* check types */
	if(parent==NULL)
		return(NULL);
	if(titem_type(parent)!=lt_panel)
		return(NULL);
	
	if(name==NULL)
		name="Button Item";
	
	tmp=(ltpbutton)titem_new(parent, lt_pbutton, sizeof(ltpbuttond));
	if(tmp==NULL)
		return(NULL);
	
	tmp->t=(Panel_item)xv_create(tpanel_xview(parent), PANEL_BUTTON,
		PANEL_LABEL_STRING, name,
		XV_WIDTH, w,
		XV_HEIGHT, h,
		NULL);
	
	if(right!=NULL)
		x=tp_right_side(right);
	if(below!=NULL)
		y=tp_bottom_side(below);

	xv_set(tmp->t,
		XV_X, x,
		XV_Y, y,
		PANEL_CLIENT_DATA, tmp,
		PANEL_NOTIFY_PROC, tpbutton_notify,
		NULL);

	tmp->do_events=NULL;

	return(tmp);
}

tpbutton tpbutton_new_image(parent, x,y,w,h,right,below, pic)
tpanel parent;
int x,y,w,h;
titem right,below;
tpic pic;
{
	ltpbutton tmp;

	/* check types */
	if(parent==NULL)
		return(NULL);
	if(titem_type(parent)!=lt_panel)
		return(NULL);
	
	if(pic==NULL)
		return(NULL);
	
	tmp=(ltpbutton)titem_new(parent, lt_pbutton, sizeof(ltpbuttond));
	if(tmp==NULL)
		return(NULL);
	
	tmp->t=(Panel_item)xv_create(tpanel_xview(parent), PANEL_BUTTON,
		PANEL_LABEL_IMAGE, tpic_xview(pic),
		XV_WIDTH, w,
		XV_HEIGHT, h,
		NULL);
	
	if(right!=NULL)
		x=tp_right_side(right);
	if(below!=NULL)
		y=tp_bottom_side(below);

	xv_set(tmp->t,
		XV_X, x,
		XV_Y, y,
		PANEL_CLIENT_DATA, tmp,
		PANEL_NOTIFY_PROC, tpbutton_notify,
		NULL);

	tmp->do_events=NULL;

	return(tmp);
}

int tpbutton_free(t)
ltpbutton t;
{
	/* check type */
	if(t==NULL)
		return(0);
	if(titem_type(t)!=lt_pbutton)
		return(0);
	
	xv_destroy_safe(t->t);
	return(titem_free(t));
}

int tpbutton_enable(t)
ltpbutton t;
{
	/* check type */
	if(t==NULL)
		return(0);
	if(titem_type(t)!=lt_pbutton)
		return(0);
	
	xv_set(t->t, PANEL_INACTIVE, FALSE, NULL);
	return(1);
}

int tpbutton_disable(t)
ltpbutton t;
{
	/* check type */
	if(t==NULL)
		return(0);
	if(titem_type(t)!=lt_pbutton)
		return(0);
	
	xv_set(t->t, PANEL_INACTIVE, TRUE, NULL);
	return(1);
}

int tpbutton_set_event_procedure(t, do_events)
ltpbutton t;
int (*do_events)();
{
	/* check type */
	if(t==NULL)
		return(0);
	if(titem_type(t)!=lt_pbutton)
		return(0);
	
	t->do_events=do_events;
	return(1);
}

tpbutton_set_color(b, p)
ltpbutton b;
unsigned long p;
{
	/* check type */
	if(b==NULL)
		return(0);
	if(titem_type(b)!=lt_pbutton)
		return(0);
	
	xv_set(b->t, PANEL_ITEM_COLOR, p, NULL);
}
