/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.layout;

import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public final class FormLayout
extends Layout {
    public int marginWidth = 0;
    public int marginHeight = 0;
    public int spacing = 0;

    int computeHeight(FormData formData) {
        FormAttachment formAttachment = formData.getTopAttachment(this.spacing);
        FormAttachment formAttachment2 = formData.getBottomAttachment(this.spacing);
        FormAttachment formAttachment3 = formAttachment2.minus(formAttachment);
        if (formAttachment3.numerator == 0) {
            if (formAttachment2.numerator == 0) {
                return formAttachment2.offset;
            }
            if (formAttachment2.numerator == formAttachment2.denominator) {
                return -formAttachment.offset;
            }
            if (formAttachment2.offset <= 0) {
                return -formAttachment.offset * formAttachment.denominator / formAttachment2.numerator;
            }
            int n = formAttachment2.denominator - formAttachment2.numerator;
            return formAttachment2.denominator * formAttachment2.offset / n;
        }
        return formAttachment3.solveY(formData.cacheHeight);
    }

    protected Point computeSize(Composite composite, int n, int n2, boolean bl) {
        Point point = this.layout(composite, false, 0, 0, 0, 0, bl);
        point.x += this.marginWidth * 2;
        point.y += this.marginHeight * 2;
        return point;
    }

    Point computeSize(Control control, boolean bl) {
        FormData formData = (FormData)control.getLayoutData();
        if (formData == null) {
            formData = new FormData();
            control.setLayoutData(formData);
        }
        return control.computeSize(formData.width, formData.height, bl);
    }

    int computeWidth(FormData formData) {
        FormAttachment formAttachment = formData.getLeftAttachment(this.spacing);
        FormAttachment formAttachment2 = formData.getRightAttachment(this.spacing);
        FormAttachment formAttachment3 = formAttachment2.minus(formAttachment);
        if (formAttachment3.numerator == 0) {
            if (formAttachment2.numerator == 0) {
                return formAttachment2.offset;
            }
            if (formAttachment2.numerator == formAttachment2.denominator) {
                return -formAttachment.offset;
            }
            if (formAttachment2.offset <= 0) {
                return -formAttachment.offset * formAttachment.denominator / formAttachment.numerator;
            }
            int n = formAttachment2.denominator - formAttachment2.numerator;
            return formAttachment2.denominator * formAttachment2.offset / n;
        }
        return formAttachment3.solveY(formData.cacheWidth);
    }

    protected void layout(Composite composite, boolean bl) {
        Rectangle rectangle = composite.getClientArea();
        int n = rectangle.x + this.marginWidth;
        int n2 = rectangle.y + this.marginHeight;
        int n3 = Math.max(0, rectangle.width - 2 * this.marginWidth);
        int n4 = Math.max(0, rectangle.height - 2 * this.marginHeight);
        this.layout(composite, true, n, n2, n3, n4, bl);
    }

    Point layout(Composite composite, boolean bl, int n, int n2, int n3, int n4, boolean bl2) {
        FormData formData;
        Object object;
        Control[] controlArray = composite.getChildren();
        int n5 = 0;
        while (n5 < controlArray.length) {
            Control control = controlArray[n5];
            object = this.computeSize(control, bl2);
            formData = (FormData)control.getLayoutData();
            formData.cacheWidth = ((Point)object).x;
            formData.cacheHeight = ((Point)object).y;
            formData.cacheBottom = null;
            formData.cacheTop = null;
            formData.cacheRight = null;
            formData.cacheLeft = null;
            ++n5;
        }
        Rectangle[] rectangleArray = null;
        int n6 = 0;
        while (n6 < controlArray.length) {
            object = controlArray[n6];
            formData = (FormData)((Control)object).getLayoutData();
            if (bl) {
                int n7 = formData.getLeftAttachment(this.spacing).solveX(n3);
                int n8 = formData.getTopAttachment(this.spacing).solveX(n4);
                int n9 = formData.getRightAttachment(this.spacing).solveX(n3);
                int n10 = formData.getBottomAttachment(this.spacing).solveX(n4);
                if (rectangleArray == null) {
                    rectangleArray = new Rectangle[controlArray.length];
                }
                rectangleArray[n6] = new Rectangle(n + n7, n2 + n8, n9 - n7, n10 - n8);
            } else {
                n3 = Math.max(this.computeWidth(formData), n3);
                n4 = Math.max(this.computeHeight(formData), n4);
            }
            ++n6;
        }
        n6 = 0;
        while (n6 < controlArray.length) {
            object = controlArray[n6];
            formData = (FormData)((Control)object).getLayoutData();
            formData.cacheHeight = 0;
            formData.cacheWidth = 0;
            formData.cacheBottom = null;
            formData.cacheTop = null;
            formData.cacheRight = null;
            formData.cacheLeft = null;
            ++n6;
        }
        if (bl) {
            n6 = 0;
            while (n6 < controlArray.length) {
                controlArray[n6].setBounds(rectangleArray[n6]);
                ++n6;
            }
        }
        return bl ? null : new Point(n3, n4);
    }
}

