=begin
 * Name: SiSU - Simple information Structuring Universe - Structured information, Serialized Units
 * Author: Ralph Amissah
   * http://www.jus.uio.no/sisu
   * http://www.jus.uio.no/sisu/SiSU/download
 * Description: Skin prepared for The Wealth of Networks, Yochai Benkler
 * License: Same as SiSU see http://www.jus.uio.no/sisu
 * Notes: Site default appearance variables set in defaults.rb
     Generic site wide modifications set here scribe_skin.rb, and this file required by other "scribes" instead of defaults.rb
=end
module SiSU_Viz
  require "#{SiSU_lib}/defaults"
  class Path
    def root                                                                     # the only parameter that cannot be changed here
      './sisu/'
    end
    def rel
      '../'
    end
  end
  class Url
    def home
      'http://www.benkler.org'
    end
    def txt                                                                      # text to go with url usually stripped url
      'www.benkler.org'
    end
  end
  class Color
    def band1
      '"#ffffff"'      
    end
  end
  class Txt
    def hp
      'www.benkler.org'
    end
    def home
      'Jochai Benkler'
    end
  end
  class Icon
    def home_button
      'won_benkler.png'
    end
    def home_banner
      home_button
    end
  end
  class Banner
    def home_button
      %{<table summary="home button" border="0" cellpadding="3" cellspacing="0"><tr><td align="left" bgcolor=#{@color.white}><a href="#{@url.home}">#{@png.home}</a></td></tr></table>\n}
    end
    def home_and_index_buttons
      %{<table><tr><td width="20%"><table summary="home and index buttons" border="0" cellpadding="3" cellspacing="0"><tr><td align="left" bgcolor=#{@color.white}><a href="#{@url.home}" target="_top">#{@png.home}</a></td><td width="40%"><center><table summary="buttons" border="1" cellpadding="3" cellspacing="0"><tr><td align="center" bgcolor="#f1e8de"><font face="arial" size="2"><a href="toc.html" target="_top">&nbsp;This&nbsp;text&nbsp;sub-&nbsp;<br />&nbsp;Table&nbsp;of&nbsp;Contents&nbsp;</a></font>#{@table.close}</center></td><td width="20%">&nbsp;#{@table.close}}
    end
    def band
      %{<table summary="band" border="0" cellpadding="3" cellspacing="0"><tr><td align="left" bgcolor=#{@color.white}><a href="#{@url.home}" target="_top">#{@png.home}</a>#{@table.close}}
    end
  end
  class Credits
    def credits
      %{<table summary="credits" align="center" bgcolor="#ffffff"><tr><td><font color="black"><center>
<a href="http://www.benkler.org/wonchapters.html">The original pdf is available online</a> at<br /><a href="http://www.benkler.org/">www.benkler.org</a><br />
<a href="http://www.benkler.org/wealth_of_networks/index.php/Main_Page"><img border="0" align="center" src="../_sisu/image_local/won_benkler_book.png" alt="available at Amazon.com"></a><br />
available at<br /><a href="http://www.amazon.com/exec/obidos/tg/detail/-/0300110561/">Amazon.com</a> and <br />
<a href="http://search.barnesandnoble.com/booksearch/isbnInquiry.asp?isbn=0300110561">Barnes & Noble</a><br />
This book is Copyright Yochai Benkler © 2006<br />
Under a Creative Commons License, that permits non-commercial use of this work, provided attribution is given.<br />
<a href="http://creativecommons.org/licenses/by-nc-sa/2.5/">http://creativecommons.org/licenses/by-nc-sa/2.5/</a><br />#{@widget.sisu}</center></font></td></tr></table>}
    end
  end
  class Tex
    def header_center
	    "\\chead{\\href{#{@url.home}}{www.benkler.org}}"
    end
    def home_url
	    "\\href{#{@url.home}}{www.benkler.org}"
    end
    def home
	    "\\href{#{@url.home}}{Yochai Benkler}"
    end
    def owner_chapter
      "Document owner details"
    end
    def stmp
	    "\\copyright Ralph Amissah, licence GPL \\\\\n www.jus.uio.no/sisu/"
    end
  end
end
