/*
 * (C) Finite State Machine Labs Inc. 1999-2000 <business@fsmlabs.com>
 *
 * Released under the terms of GPL 2.
 * Open RTLinux makes use of a patented process described in
 * US Patent 5,995,745. Use of this process is governed
 * by the Open RTLinux Patent License which can be obtained from
 * www.fsmlabs.com/PATENT or by sending email to
 * licensequestions@fsmlabs.com
 */

#ifndef __RTL_TRACEDUMP_H__
#define __RTL_TRACEDUMP_H__

/* this is user-space code */
#include <rtl_tracer.h>

extern struct rtl_trace_eventinfo_struct *rtl_trace_event_info;

const char *eventname(int event_id)
{
	if ((unsigned) event_id >= RTL_TRACE_MAX_EVENTS) {
		return "unknown";
	}

	return rtl_trace_event_info[event_id].name;
}

void rtl_trace_dump (struct rtl_trace_buffer *buf, void (*do_dump)(const char *string))
{
	int s;
	int i;
	char sbuf[80];
	long long prevts = 0;
	long diff = 0;

	if (!buf->state || buf->len == 0) {
		do_dump("trace buffer empty\n");
	}
	s = buf->pos - buf->len;
	if (s < 0) {
		s += RTL_TNRECORDS;
	}
	for (i = 0; i < buf->len; i++) {
		diff = buf->trace[s].timestamp - prevts;
		prevts = buf->trace[s].timestamp;
		sprintf(sbuf, "P%1d %6ld %-23s %#10lx <%08lx>\n",
			buf->trace[s].cpu,
			diff,
			eventname(buf->trace[s].event_id),
			buf->trace[s].event_data,
			buf->trace[s].eip
				/*,
			(unsigned) (buf->trace[s].timestamp >> 32),
			(unsigned) (buf->trace[s].timestamp & 0xffffffff) */
			);
		do_dump(sbuf);
		s++;
		if (s >= RTL_TNRECORDS) {
			s = 0;
		}
	}
	sprintf(sbuf, "That was trace # %d\n", buf->timestamp);
	do_dump(sbuf);
}

#endif
