/*
 * Copyright (c) 1999 Apple Computer, Inc. All rights reserved.
 *
 * @APPLE_LICENSE_HEADER_START@
 * 
 * Portions Copyright (c) 1999 Apple Computer, Inc.  All Rights
 * Reserved.  This file contains Original Code and/or Modifications of
 * Original Code as defined in and that are subject to the Apple Public
 * Source License Version 1.1 (the "License").  You may not use this file
 * except in compliance with the License.  Please obtain a copy of the
 * License at http://www.apple.com/publicsource and read it before using
 * this file.
 * 
 * The Original Code and all software distributed under the License are
 * distributed on an "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, EITHER
 * EXPRESS OR IMPLIED, AND APPLE HEREBY DISCLAIMS ALL SUCH WARRANTIES,
 * INCLUDING WITHOUT LIMITATION, ANY WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE OR NON- INFRINGEMENT.  Please see the
 * License for the specific language governing rights and limitations
 * under the License.
 * 
 * @APPLE_LICENSE_HEADER_END@
 */
/*
	File:		UDPSocket.h

	Contains:	Adds additional Socket functionality specific to UDP.

	$Log: UDPSocket.h,v $
	Revision 1.2  1999/02/19 23:14:16  ds
	Created
	
	
*/


#ifndef __UDPSOCKET_H__
#define __UDPSOCKET_H__

#ifndef __MW_
#include <sys/socket.h>
#include <sys/uio.h>
#endif

#include "Socket.h"
#include "UDPDemuxer.h"


class	UDPSocket : public Socket
{
	public:
	
		//Another socket type flag (in addition to the ones defined in Socket.h).
		//The value of this can't conflict with those!
		enum
		{
			kWantsDemuxer = 0x0100 //UInt32
		};
	
		UDPSocket(UInt32 inSocketType, Task* inTask);
		virtual ~UDPSocket() { if (fDemuxer != NULL) delete fDemuxer; }

		//Open
		QTSS_ErrorCode 	Open() { return Socket::Open(SOCK_DGRAM); }

		QTSS_ErrorCode 	JoinMulticast(UInt32 inRemoteAddr, UInt16 timeToLive);
		QTSS_ErrorCode 	LeaveMulticast(UInt32 inRemoteAddr);

		//returns an ERRNO
		QTSS_ErrorCode		SendTo(UInt32 inRemoteAddr, UInt16 inRemotePort,
									char* inBuffer, UInt32 inLength);
						
		QTSS_ErrorCode		RecvFrom(UInt32* outRemoteAddr, UInt16* outRemotePort,
										char* ioBuffer, UInt32 inBufLen, UInt32* outRecvLen);
		
		QTSS_ErrorCode		RecvPacket(UInt32* outDestAddr, char* ioBuffer, UInt32 inBufLen,
											UInt32* outRecvLen);

		//A UDP socket may or may not have a demuxer associated with it. The demuxer
		//is a data structure so the socket can associate incoming data with the proper
		//task to process that data (based on source IP addr & port)
		UDPDemuxer*			GetDemuxer()	{ return fDemuxer; }
		
	private:
	
		QTSS_ErrorCode 	CheckError(UInt32* outRecvLen);

		UDPDemuxer* fDemuxer;

		union ControlData
		{
			struct 	cmsghdr	cmsgHdr;
			char	pad[100];
		};
		ControlData			fCmsgData;
		struct msghdr		fMsgHdr;
		struct sockaddr_in	fMsgAddr;
		struct iovec		fMsgIovec;
};
#endif // __UDPSOCKET_H__

