/*
 * Copyright (c) 1999 Apple Computer, Inc. All rights reserved.
 *
 * @APPLE_LICENSE_HEADER_START@
 * 
 * Portions Copyright (c) 1999 Apple Computer, Inc.  All Rights
 * Reserved.  This file contains Original Code and/or Modifications of
 * Original Code as defined in and that are subject to the Apple Public
 * Source License Version 1.1 (the "License").  You may not use this file
 * except in compliance with the License.  Please obtain a copy of the
 * License at http://www.apple.com/publicsource and read it before using
 * this file.
 * 
 * The Original Code and all software distributed under the License are
 * distributed on an "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, EITHER
 * EXPRESS OR IMPLIED, AND APPLE HEREBY DISCLAIMS ALL SUCH WARRANTIES,
 * INCLUDING WITHOUT LIMITATION, ANY WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE OR NON- INFRINGEMENT.  Please see the
 * License for the specific language governing rights and limitations
 * under the License.
 * 
 * @APPLE_LICENSE_HEADER_END@
 */
/*
	File:		StringTranslator.cpp

	Contains:	implements StringTranslator class
					
	
	$Log: StringTranslator.cpp,v $
	Revision 1.2  1999/02/19 23:13:20  ds
	Created
	
	
*/


#include <string.h>
#include <ctype.h>
#include <stdio.h>

#include "StringTranslator.h"
#include "MyAssert.h"


SInt32 StringTranslator::DecodeURL(const char* inSrc, SInt32 inSrcLen, char* ioDest, SInt32 inDestLen)
{
	Assert(inSrc != NULL);
	Assert(ioDest != NULL);
	
	if ((inSrc == NULL) || (ioDest == NULL))
		return QTSS_BadArgument;
	
	SInt32 theLengthWritten = 0;
	
	while (inSrcLen > 0)
	{
		if (theLengthWritten == inDestLen)
			return QTSS_NotEnoughSpace;
			
		if (*inSrc == '%')
		{
			if (inSrcLen < 3)
				return QTSS_BadURLFormat;

			//if there is a special character in this URL, extract it
			char tempbuff[3];
			inSrc++;
			if (!isxdigit(*inSrc))
				return QTSS_BadURLFormat;
			tempbuff[0] = *inSrc;
			inSrc++;
			if (!isxdigit(*inSrc))
				return QTSS_BadURLFormat;
			tempbuff[1] = *inSrc;
			inSrc++;
			tempbuff[2] = '\0';
			int temp;
			sscanf(tempbuff, "%x", &temp);
			Assert(temp < 256);
			*ioDest = temp;

			inSrcLen -= 3;		
		}
		else if (*inSrc == '\0')
		{
			*ioDest = '\0';
			return theLengthWritten;
		}
		else
		{
			*ioDest = *inSrc;
			inSrcLen--;
			inSrc++;
		}
		theLengthWritten++;
		ioDest++;
	}
	return theLengthWritten;
}

#if STRINGTRANSLATORTESTING
bool StringTranslator::Test()
{
	//static char* test1 = "/%5D%3f%7eAveryweird%7C/and/long/path/ya/%5d%3F%7eAveryweird%7C/and/long/p%40/ya/%5D%3F%7EAveryweird%7C/and/long/path/ya/%5D%3F%7EAveryweird%7C/and/long/path/ya/%2560%2526a%20strange%3B%23%3D%25filename"
	static char dest[1000];
	static char* test1 = "Hello%23%20 I want%28don't%29";
	SInt32 err = DecodeURL(test1, strlen(test1), dest, 1000);
	if (err != 21)
		return false;
	if (strcmp(dest, "Hello#  I want(don't)") != 0)
		return false;
	err = DecodeURL(test1, 15, dest, 1000);
	if (err != 11)
		return false;
	if (strncmp(dest, "Hello#  I w", 11) != 0)
		return false;
	err = DecodeURL(test1, 50, dest, 1000);
	if (err != 21)
		return false;
	if (strcmp(dest, "Hello#  I want(don't)") != 0)
		return false;
		
	err = DecodeURL(test1, strlen(test1), dest, 20);
	if (err != QTSS_NotEnoughSpace)
		return false;
	static char* test2 = "THis%2h is a bad %28 URL!";
	err = DecodeURL(test2, strlen(test2), dest, 1000);
	if (err != QTSS_BadURLFormat)
		return false;
	return true;
}
#endif	
