/* MEXTRL.f -- translated by f2c (version 19960827).
   You must link the resulting object file with the libraries:
	-lf2c -lm   (in that order)
*/

#include "Data_f2c.h"
#include <Data_Data.h>
/* Common Block Declarations */

/*extern __Data_API struct {*/
extern struct {
    doublereal rootab[930]	/* was [465][2] */, hiltab[930]	/* was [465][
	    2] */, hi0tab[31];
} mlgdrtl_;

#define mlgdrtl_1 mlgdrtl_

/* Subroutine */ int mmextrl_(ndegre, rootlg)
integer *ndegre;
doublereal *rootlg;
{
    /* System generated locals */
    integer i__1;

    /* Local variables */
    static integer iadd, ideb, ndeg2, nmod2, ii, ibb;
    extern integer mnfndeb_();
    static integer kpt;
    extern /* Subroutine */ int mgenmsg_();



/* < */
/* **NOTICE */
/*  THIS SOFTWARE IS THE PROPERTY OF CISIGRAPH. */
/*  THIS CODE MUST NOT BE DISTRIBUTED OR COPIED WITHOUT THE PRIOR */
/*  WRITTEN PERMISSION OF CISIGRAPH AND IS ONLY TO BE USED ON THE */
/*  SITE WHERE IT IS INSTALLED BY CISIGRAPH */
/* **NOTICE */

/* ********************************************************************** 
*/

/*     FONCTION : */
/*     ---------- */
/* Extrait du Common LDGRTL les racines du polynome de Legendre */
/* de degre NDEGRE defini sur [-1,1]. */

/*     MOTS CLES : */
/*     ----------- */
/*     TOUS, AB_SPECIFI::COMMON&, EXTRACTION, &RACINE, &LEGENDRE. */

/*     ARGUMENTS D'ENTREE : */
/*     ------------------ */
/*   NDEGRE : Degre mathematique du polynome de Legendre. On doit avoir */
/*            2 <= NDEGRE <= 61. */

/*     ARGUMENTS DE SORTIE : */
/*     ------------------- */
/*   ROOTLG : Le tableau des racines du polynome de Legendre de degre */
/*            NDEGRE et defini sur [-1,1]. */

/*     COMMONS UTILISES   : */
/*     ---------------- */
/*     MLGDRTL */

/*     REFERENCES APPELEES   : */
/*     ----------------------- */

/*     DESCRIPTION/REMARQUES/LIMITATIONS : */
/*     ----------------------------------- */
/*     ATTENTION: La condition sur NDEGRE ( 2 <= NDEGRE <= 61) n'est */
/*     pas testee. A l'appelant de faire le test. */

/* $    HISTORIQUE DES MODIFICATIONS   : */
/*     -------------------------------- */
/*     23-03-90 : RBD ; Ajout commentaires + declarations. */
/*     15-01-90 : NAK ; MLGDRTL PAR INCLUDE MMLGDRT */
/*     04-03-88 : JJM ; Raccoursissement de MLGDRTL. */
/*     22-02-88 : JJM ; Appel MFNDEB -> MNFNDEB */
/*     23-10-87 : JJM ; Cree par JJM */
/* > */
/* ********************************************************************** 
*/


/*   Le nom de la routine */


/*   Le common MLGDRTL: */
/*   Ce common comprend les racines POSITIVES des polynomes de Legendre */
/*   ET les poids des formules de quadrature de Gauss sur toutes les */
/*   racines POSITIVES des polynomes de Legendre. */


/*     INCLUDE MMLGDRT */
/* < */
/* **NOTICE */
/*  THIS SOFTWARE IS THE PROPERTY OF CISIGRAPH. */
/*  THIS CODE MUST NOT BE DISTRIBUTED OR COPIED WITHOUT THE PRIOR */
/*  WRITTEN PERMISSION OF CISIGRAPH AND IS ONLY TO BE USED ON THE */
/*  SITE WHERE IT IS INSTALLED BY CISIGRAPH */
/* **NOTICE */

/* ***********************************************************************
 */

/*     FONCTION : */
/*     ---------- */
/*   Le common des racines de Legendre. */

/*     MOTS CLES : */
/*     ----------- */
/*        BASE LEGENDRE */

/*     DEMSCRIPTION/REMARQUES/LIMITATIONS : */
/*     ----------------------------------- */

/* $    HISTORIQUE DES MODIFICATIONS : */
/*     ------------------------------ */
/*     11-01-90 : NAK  ; Creation version originale */
/* > */
/* ***********************************************************************
 */




/*   ROOTAB : Tableau de toutes les racines des polynomes de Legendre */
/*   comprises entre ]0,1]. Elles sont rangees pour des degres croissants 
*/
/*   de 2 a 61. */
/*   HILTAB : Tableau des interpolants de Legendre concernant ROOTAB. */
/*   L' adressage est le meme. */
/*   HI0TAB : Tableau des interpolants de Legendre pour la racine x=0 */
/*   des polynomes de degre IMPAIR. */
/*   RTLTB0 : Tableau des Li(uk) ou les uk sont les racines d' un */
/*  polynome de Legendre de degre PAIR. */
/*   RTLTB1 : Tableau des Li(uk) ou les uk sont les racines d' un */
/*  polynome de Legendre de degre IMPAIR. */


/************************************************************************
*****/
    /* Parameter adjustments */
    --rootlg;

    /* Function Body */
    ibb = mnfndeb_();
    if (ibb >= 3) {
	mgenmsg_("MMEXTRL", 7L);
    }

    ndeg2 = *ndegre / 2;
    nmod2 = *ndegre % 2;

/*   Adresse de la 1ere racine strictement positive du polynome de */
/*   Legendre de degre NDEGRE dans MLGDRTL. */

    iadd = ndeg2 * (ndeg2 - 1) / 2 + 1;

/*   Indice, dans ROOTLG, de la 1ere racine strictement positive du */
/*   polynome de Legendre de degre NDEGRE. */

    ideb = (*ndegre + 1) / 2 + 1;

/*   Lecture des racines strictement positives. */

    i__1 = *ndegre;
    for (ii = ideb; ii <= i__1; ++ii) {
	kpt = iadd + ii - ideb;
	rootlg[ii] = mlgdrtl_1.rootab[kpt + nmod2 * 465 - 1];
/* L100: */
    }

/*   Les racines strictement negatives sont egales aux racines positives 
*/
/*   au signe pres i.e RT(1) = -RT(NDEGRE), RT(2) = -RT(NDEGRE-1), etc... 
*/

    i__1 = ndeg2;
    for (ii = 1; ii <= i__1; ++ii) {
	rootlg[ii] = -rootlg[*ndegre + 1 - ii];
/* L200: */
    }

/*   Cas NDEGRE impair, 0 est racine du polynome de Legendre. */

    if (nmod2 == 1) {
	rootlg[ndeg2 + 1] = 0.;
    }

/* -------------------------------- THE END ----------------------------- 
*/

    if (ibb >= 3) {
	mgenmsg_("MMEXTRL", 7L);
    }
    return 0;
} /* mmextrl_ */

