// File generated by CPPExt (Transient)
//
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _WOKUnix_Path_HeaderFile
#define _WOKUnix_Path_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Handle_WOKUnix_Path_HeaderFile
#include <Handle_WOKUnix_Path.hxx>
#endif

#ifndef _Handle_TCollection_HAsciiString_HeaderFile
#include <Handle_TCollection_HAsciiString.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _WOKUnix_StatBuf_HeaderFile
#include <WOKUnix_StatBuf.hxx>
#endif
#ifndef _MMgt_TShared_HeaderFile
#include <MMgt_TShared.hxx>
#endif
#ifndef _Standard_CString_HeaderFile
#include <Standard_CString.hxx>
#endif
#ifndef _WOKUnix_TimeStat_HeaderFile
#include <WOKUnix_TimeStat.hxx>
#endif
#ifndef _WOKUnix_Extension_HeaderFile
#include <WOKUnix_Extension.hxx>
#endif
class TCollection_HAsciiString;
class WOKUnix_FDescr;


//! Supplee aux insuffisances de OSD_File <br>
class WOKUnix_Path : public MMgt_TShared {

public:
 // Methods PUBLIC
 // 

//! Instantiates Path from WOKUnix <br>
Standard_EXPORT WOKUnix_Path();


Standard_EXPORT WOKUnix_Path(const Standard_CString apath);

//! Instantiates Path from WOKUnix using an asciistring <br>
Standard_EXPORT WOKUnix_Path(const Handle(TCollection_HAsciiString)& apath);

//! Instantiates Path from WOKUnix using an directory and <br>
//!          a name <br>
Standard_EXPORT WOKUnix_Path(const Handle(TCollection_HAsciiString)& adir,const Handle(TCollection_HAsciiString)& aname);

//! Instantiates Path from WOKUnix using an directory and <br>
//!          a name <br>
Standard_EXPORT WOKUnix_Path(const Standard_CString adir,const Standard_CString aname);

  Standard_Boolean CheckStats() ;


Standard_EXPORT   Standard_Boolean GetStats() ;
//! returns PathName <br>
 const Handle_TCollection_HAsciiString& Name() const;

//! sets path <br>
Standard_EXPORT   void SetName(const Handle(TCollection_HAsciiString)& apath) ;

//! Builds a WOKUnix_FDescr to manipulate Path <br>
Standard_EXPORT   WOKUnix_FDescr BuildFDescr() const;

//! Tests existency of path on disk <br>
Standard_EXPORT   Standard_Boolean Exists() const;

//! Creates path as a directory <br>
Standard_EXPORT   Standard_Boolean CreateDirectory(const Standard_Boolean CreateParents = Standard_False) ;

//! Creates path as a file on disk <br>
Standard_EXPORT   Standard_Boolean CreateFile(const Standard_Boolean CreateParents = Standard_False) ;


Standard_EXPORT   Standard_Boolean IsSymLink() ;


Standard_EXPORT   Standard_Boolean IsFile() ;


Standard_EXPORT   Standard_Boolean IsDirectory() ;


Standard_EXPORT   Standard_Boolean CreateSymLinkTo(const Handle(WOKUnix_Path)& apath) ;


Standard_EXPORT   Standard_Boolean RemoveDirectory(const Standard_Boolean RemoveChilds = Standard_False) ;


Standard_EXPORT   Standard_Boolean RemoveFile() ;

//! Renames file to destpath Failes if mypath and dest <br>
//!          path are not on the same file system <br>
//!          mypath is changed to which of adestpath <br>
Standard_EXPORT   Standard_Boolean MoveTo(const Handle(WOKUnix_Path)& adestpath) ;

//! reduces Path as much as possible (reads links) <br>
Standard_EXPORT   Handle_WOKUnix_Path ReducedPath() const;

//! Tests is me corresponds to the same <br>
//!          file as <another> (reads links) <br>
Standard_EXPORT   Standard_Boolean IsSamePath(const Handle(WOKUnix_Path)& another) const;

//! Teste si deux fichiers ont le meme <br>
//!          contenu (typiquement utilise a l'extraction) <br>
Standard_EXPORT   Standard_Boolean IsSameFile(const Handle(WOKUnix_Path)& another) const;
//! returns known date of path <br>
  WOKUnix_TimeStat MDate() ;

  void ResetMDate() ;


Standard_EXPORT   Standard_Boolean IsOlder(const Handle(WOKUnix_Path)& another) ;


Standard_EXPORT   Standard_Boolean IsNewer(const Handle(WOKUnix_Path)& another) ;


Standard_EXPORT   Standard_Boolean IsWriteAble() const;

//! extracts Extension of file <br>
Standard_EXPORT   WOKUnix_Extension Extension() const;

//! extracts Extension of file <br>
Standard_EXPORT   Handle_TCollection_HAsciiString ExtensionName() const;

//! returns the basename of File <br>
Standard_EXPORT   Handle_TCollection_HAsciiString BaseName() const;

//! returns the dirname of file <br>
Standard_EXPORT   Handle_TCollection_HAsciiString DirName() const;

//! returns the filename (<BaseName>.<Extension>) of path <br>
Standard_EXPORT   Handle_TCollection_HAsciiString FileName() const;
//Standard_EXPORT ~WOKUnix_Path();




 // Type management
 //
 Standard_EXPORT const Handle(Standard_Type)& DynamicType() const;
 //Standard_EXPORT Standard_Boolean	       IsKind(const Handle(Standard_Type)&) const;

protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
Handle_TCollection_HAsciiString mypath;
Standard_Boolean myacces;
WOKUnix_StatBuf mystats;


};


#include <WOKUnix_Path.lxx>



// other Inline functions and methods (like "C++: function call" methods)
//


#endif
