// File generated by CPPExt (Transient)
//
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _TNaming_Naming_HeaderFile
#define _TNaming_Naming_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Handle_TNaming_Naming_HeaderFile
#include <Handle_TNaming_Naming.hxx>
#endif

#ifndef _TNaming_Name_HeaderFile
#include <TNaming_Name.hxx>
#endif
#ifndef _TDF_Attribute_HeaderFile
#include <TDF_Attribute.hxx>
#endif
#ifndef _Handle_TNaming_NamedShape_HeaderFile
#include <Handle_TNaming_NamedShape.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _Handle_TDF_Attribute_HeaderFile
#include <Handle_TDF_Attribute.hxx>
#endif
#ifndef _Handle_TDF_RelocationTable_HeaderFile
#include <Handle_TDF_RelocationTable.hxx>
#endif
#ifndef _Handle_TDF_DataSet_HeaderFile
#include <Handle_TDF_DataSet.hxx>
#endif
#ifndef _Standard_OStream_HeaderFile
#include <Standard_OStream.hxx>
#endif
class Standard_GUID;
class TDF_Label;
class TNaming_NamedShape;
class TopoDS_Shape;
class TNaming_Name;
class TDF_LabelMap;
class TDF_Attribute;
class TDF_RelocationTable;
class TDF_DataSet;
class TDF_IDFilter;
class TDF_AttributeIndexedMap;


//!  This attribute  store the  topological  naming of any <br>
//!           selected   shape,  when this  shape  is  not  already <br>
//!           attached to a specific label. This class is also used <br>
//!            to solve  it when  the argumentsof the  toipological <br>
//!           naming are modified. <br>
class TNaming_Naming : public TDF_Attribute {

public:
 // Methods PUBLIC
 // 

//! following code from TDesignStd <br>
//!          ============================== <br>
Standard_EXPORT static const Standard_GUID& GetID() ;


Standard_EXPORT static  Handle_TNaming_Naming Insert(const TDF_Label& under) ;

//! Creates  a   Namimg  attribute  at  label <where>   to <br>
//!             identify  the   shape   <Selection>.    Geometry is <br>
//!          Standard_True  if   we  are  only  interested  by  the <br>
//!                 underlying   geometry     (e.g.     setting   a <br>
//!          constraint). <Context> is  used to find neighbours  of <br>
//!          <S> when required by the naming. <br>//! instance method <br>
//!          =============== <br>
Standard_EXPORT static  Handle_TNaming_NamedShape Name(const TDF_Label& where,const TopoDS_Shape& Selection,const TopoDS_Shape& Context,const Standard_Boolean Geometry = Standard_False) ;


Standard_EXPORT TNaming_Naming();


Standard_EXPORT   Standard_Boolean IsDefined() const;


Standard_EXPORT  const TNaming_Name& GetName() const;


Standard_EXPORT   TNaming_Name& ChangeName() ;

//!  regenerate only the Name associated to me <br>
Standard_EXPORT   Standard_Boolean Regenerate(TDF_LabelMap& scope) ;

//! Regenerate recursively the  whole name with scope.  If <br>
//!          scope  is empty it  means that  all the labels  of the <br>
//!          framework are valid. <br>
Standard_EXPORT   Standard_Boolean Solve(TDF_LabelMap& scope) ;

//! Deferred methods from TDF_Attribute <br>
//!          =================================== <br>
Standard_EXPORT virtual const Standard_GUID& ID() const;


Standard_EXPORT   Handle_TDF_Attribute NewEmpty() const;


Standard_EXPORT   void Restore(const Handle(TDF_Attribute)& With) ;


Standard_EXPORT   void Paste(const Handle(TDF_Attribute)& Into,const Handle(TDF_RelocationTable)& RT) const;


Standard_EXPORT virtual  void References(const Handle(TDF_DataSet)& aDataSet) const;


Standard_EXPORT virtual  Standard_OStream& Dump(Standard_OStream& anOS) const;


Standard_EXPORT virtual  void ExtendedDump(Standard_OStream& anOS,const TDF_IDFilter& aFilter,TDF_AttributeIndexedMap& aMap) const;
//Standard_EXPORT ~TNaming_Naming();




 // Type management
 //
 Standard_EXPORT const Handle(Standard_Type)& DynamicType() const;
 //Standard_EXPORT Standard_Boolean	       IsKind(const Handle(Standard_Type)&) const;

protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
TNaming_Name myName;


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
