// File generated by CPPExt (Transient)
//
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _ShapeFix_FixSmallFace_HeaderFile
#define _ShapeFix_FixSmallFace_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Handle_ShapeFix_FixSmallFace_HeaderFile
#include <Handle_ShapeFix_FixSmallFace.hxx>
#endif

#ifndef _TopoDS_Shape_HeaderFile
#include <TopoDS_Shape.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _ShapeAnalysis_CheckSmallFace_HeaderFile
#include <ShapeAnalysis_CheckSmallFace.hxx>
#endif
#ifndef _ShapeFix_Root_HeaderFile
#include <ShapeFix_Root.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
class TopoDS_Shape;
class TopoDS_Face;
class TopoDS_Edge;
class TopoDS_Compound;



class ShapeFix_FixSmallFace : public ShapeFix_Root {

public:
 // Methods PUBLIC
 // 


Standard_EXPORT ShapeFix_FixSmallFace();


Standard_EXPORT   void Init(const TopoDS_Shape& S) ;


//! Fixing case of spot face <br>
Standard_EXPORT   void Perform() ;

//! Fixing case of spot face, if tol = -1 used local tolerance. <br>
Standard_EXPORT   TopoDS_Shape FixSpotFace() ;

//! Compute average vertex and replacing vertices by new one. <br>
Standard_EXPORT   Standard_Boolean ReplaceVerticesInCaseOfSpot(TopoDS_Face& F,const Standard_Real tol) const;

//! Remove spot face from compound <br>
Standard_EXPORT   Standard_Boolean RemoveFacesInCaseOfSpot(const TopoDS_Face& F) const;

//! Fixing case of strip face, if tol = -1 used local tolerance <br>
Standard_EXPORT   TopoDS_Shape FixStripFace(const Standard_Boolean wasdone = Standard_False) ;

//! Replace veretces and edges. <br>
Standard_EXPORT   Standard_Boolean ReplaceInCaseOfStrip(TopoDS_Face& F,TopoDS_Edge& E1,TopoDS_Edge& E2,const Standard_Real tol) const;

//! Remove strip face from compound. <br>
Standard_EXPORT   Standard_Boolean RemoveFacesInCaseOfStrip(const TopoDS_Face& F) const;

//! Compute average edge for strip face <br>
Standard_EXPORT   TopoDS_Edge ComputeSharedEdgeForStripFace(const TopoDS_Face& F,const TopoDS_Edge& E1,const TopoDS_Edge& E2,const TopoDS_Face& F1,const Standard_Real tol) const;


Standard_EXPORT   TopoDS_Shape FixSplitFace(const TopoDS_Shape& S) ;

//! Split faces by splitting vertices <br>
Standard_EXPORT   TopoDS_Shape SplitFaces() ;

//! Compute data for face splitting. <br>
Standard_EXPORT   Standard_Boolean SplitOneFace(TopoDS_Face& F,TopoDS_Compound& theSplittedFaces) ;

//! Remove small faces from compound. <br>
Standard_EXPORT   TopoDS_Shape RemoveSmallFaces() ;


Standard_EXPORT   TopoDS_Face FixFace(const TopoDS_Face& F) ;


Standard_EXPORT   TopoDS_Shape FixShape() ;


Standard_EXPORT   TopoDS_Shape Shape() ;


Standard_EXPORT   Standard_Boolean FixPinFace(TopoDS_Face& F) ;
//Standard_EXPORT ~ShapeFix_FixSmallFace();




 // Type management
 //
 Standard_EXPORT const Handle(Standard_Type)& DynamicType() const;
 //Standard_EXPORT Standard_Boolean	       IsKind(const Handle(Standard_Type)&) const;

protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
TopoDS_Shape myShape;
TopoDS_Shape myResult;
Standard_Integer myStatus;
ShapeAnalysis_CheckSmallFace myAnalyzer;


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
