// File generated by CPPExt (Transient)
//
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _SelectMgr_CompositionFilter_HeaderFile
#define _SelectMgr_CompositionFilter_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Handle_SelectMgr_CompositionFilter_HeaderFile
#include <Handle_SelectMgr_CompositionFilter.hxx>
#endif

#ifndef _SelectMgr_ListOfFilter_HeaderFile
#include <SelectMgr_ListOfFilter.hxx>
#endif
#ifndef _SelectMgr_Filter_HeaderFile
#include <SelectMgr_Filter.hxx>
#endif
#ifndef _Handle_SelectMgr_Filter_HeaderFile
#include <Handle_SelectMgr_Filter.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _TopAbs_ShapeEnum_HeaderFile
#include <TopAbs_ShapeEnum.hxx>
#endif
class SelectMgr_Filter;
class SelectMgr_ListOfFilter;


//! A framework to define a compound filter composed of <br>
//! two or more simple filters. <br>
class SelectMgr_CompositionFilter : public SelectMgr_Filter {

public:
 // Methods PUBLIC
 // 

//! Adds the filter afilter to a filter object created by a <br>
//! filter class inheriting this framework. <br>
Standard_EXPORT   void Add(const Handle(SelectMgr_Filter)& afilter) ;

//! Removes the filter aFilter from this framework. <br>
Standard_EXPORT   void Remove(const Handle(SelectMgr_Filter)& aFilter) ;

//! Returns true if this framework is empty. <br>
Standard_EXPORT   Standard_Boolean IsEmpty() const;

//! Returns true if the filter aFilter is in this framework. <br>
Standard_EXPORT   Standard_Boolean IsIn(const Handle(SelectMgr_Filter)& aFilter) const;
//! Returns the list of stored filters from this framework. <br>
 const SelectMgr_ListOfFilter& StoredFilters() const;

//! Clears the filters used in this framework. <br>
Standard_EXPORT   void Clear() ;


Standard_EXPORT virtual  Standard_Boolean ActsOn(const TopAbs_ShapeEnum aStandardMode) const;
//Standard_EXPORT ~SelectMgr_CompositionFilter();




 // Type management
 //
 Standard_EXPORT const Handle(Standard_Type)& DynamicType() const;
 //Standard_EXPORT Standard_Boolean	       IsKind(const Handle(Standard_Type)&) const;

protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //
SelectMgr_ListOfFilter myFilters;


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //


};


#include <SelectMgr_CompositionFilter.lxx>



// other Inline functions and methods (like "C++: function call" methods)
//


#endif
