// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _STEPConstruct_Tool_HeaderFile
#define _STEPConstruct_Tool_HeaderFile

#ifndef _Handle_XSControl_WorkSession_HeaderFile
#include <Handle_XSControl_WorkSession.hxx>
#endif
#ifndef _Handle_Transfer_FinderProcess_HeaderFile
#include <Handle_Transfer_FinderProcess.hxx>
#endif
#ifndef _Handle_Transfer_TransientProcess_HeaderFile
#include <Handle_Transfer_TransientProcess.hxx>
#endif
#ifndef _Handle_Interface_HGraph_HeaderFile
#include <Handle_Interface_HGraph.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _Handle_Interface_InterfaceModel_HeaderFile
#include <Handle_Interface_InterfaceModel.hxx>
#endif
class XSControl_WorkSession;
class Transfer_FinderProcess;
class Transfer_TransientProcess;
class Interface_HGraph;
class Interface_InterfaceModel;
class Interface_Graph;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

//! Provides basic functionalities for tools which are intended <br>
//!          for encoding/decoding specific STEP constructs <br>
class STEPConstruct_Tool  {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 

//! Creates an empty tool <br>
Standard_EXPORT STEPConstruct_Tool();

//! Creates a tool and loads it with worksession <br>
Standard_EXPORT STEPConstruct_Tool(const Handle(XSControl_WorkSession)& WS);
//! Returns currently loaded WorkSession <br>
 const Handle_XSControl_WorkSession& WS() const;
//! Returns current model (Null if not loaded) <br>
  Handle_Interface_InterfaceModel Model() const;
//! Returns current graph (recomputing if necessary) <br>
 const Interface_Graph& Graph(const Standard_Boolean recompute = Standard_False) const;
//! Returns TransientProcess (reading; Null if not loaded) <br>
 const Handle_Transfer_TransientProcess& TransientProcess() const;
//! Returns FinderProcess (writing; Null if not loaded) <br>
 const Handle_Transfer_FinderProcess& FinderProcess() const;





protected:

 // Methods PROTECTED
 // 

//! Load worksession; returns True if succeeded <br>
//!          Returns False if either FinderProcess of TransientProcess <br>
//!          cannot be obtained or are Null <br>
Standard_EXPORT   Standard_Boolean SetWS(const Handle(XSControl_WorkSession)& WS) ;


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
Handle_XSControl_WorkSession myWS;
Handle_Transfer_FinderProcess myFinderProcess;
Handle_Transfer_TransientProcess myTransientProcess;
Handle_Interface_HGraph myHGraph;


};


#include <STEPConstruct_Tool.lxx>



// other Inline functions and methods (like "C++: function call" methods)
//


#endif
