// File generated by CPPExt (Storable)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _IGESData_DefSwitch_HeaderFile
#define _IGESData_DefSwitch_HeaderFile

#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _Standard_Storable_HeaderFile
#include <Standard_Storable.hxx>
#endif
#ifndef _IGESData_DefType_HeaderFile
#include <IGESData_DefType.hxx>
#endif
#ifndef _Standard_PrimitiveTypes_HeaderFile
#include <Standard_PrimitiveTypes.hxx>
#endif


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

Standard_EXPORT Handle_Standard_Type& IGESData_DefSwitch_Type_();

//! description of a directory componant which can be either <br>
//!           undefined (let Void), defined as a Reference to an entity, <br>
//!           or as a Rank, integer value adressing a builtin table <br>
//!           The entity reference is not included here, only reference <br>
//!           status is kept (because entity type must be adapted) <br>
class IGESData_DefSwitch  {

public:
    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }

 // Methods PUBLIC
 // 

//! creates a DefSwitch as Void <br>
Standard_EXPORT IGESData_DefSwitch();

//! sets DefSwitch to "Void" status (in file : Integer = 0) <br>
Standard_EXPORT   void SetVoid() ;

//! sets DefSwitch to "Reference" Status (in file : Integer < 0) <br>
Standard_EXPORT   void SetReference() ;

//! sets DefSwitch to "Rank" with a Value (in file : Integer > 0) <br>
Standard_EXPORT   void SetRank(const Standard_Integer val) ;

//! returns DefType status (Void,Reference,Rank) <br>
Standard_EXPORT   IGESData_DefType DefType() const;

//! returns Value as Integer (sensefull for a Rank) <br>
Standard_EXPORT   Standard_Integer Value() const;
    Standard_Integer _CSFDB_GetIGESData_DefSwitchtheval() const { return theval; }
    void _CSFDB_SetIGESData_DefSwitchtheval(const Standard_Integer p) { theval = p; }




 // Type management
 //
 Standard_EXPORT friend Handle_Standard_Type& IGESData_DefSwitch_Type_();

protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
Standard_Integer theval;


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
