// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _BOPTools_RoughShapeIntersector_HeaderFile
#define _BOPTools_RoughShapeIntersector_HeaderFile

#ifndef _BooleanOperations_PShapesDataStructure_HeaderFile
#include <BooleanOperations_PShapesDataStructure.hxx>
#endif
#ifndef _Handle_Bnd_HArray1OfBox_HeaderFile
#include <Handle_Bnd_HArray1OfBox.hxx>
#endif
#ifndef _Handle_BOPTools_HArray2OfIntersectionStatus_HeaderFile
#include <Handle_BOPTools_HArray2OfIntersectionStatus.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _BOPTools_IntersectionStatus_HeaderFile
#include <BOPTools_IntersectionStatus.hxx>
#endif
class Bnd_HArray1OfBox;
class BOPTools_HArray2OfIntersectionStatus;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

//! The class RoughShapeIntersector describes the algorithm of <br>
//!         intersection of bounding boxes of <br>
//!         shapes stored in ShapesDataStructure. <br>
//!         It stores statuses of intersection in 2 dimension array. <br>
class BOPTools_RoughShapeIntersector  {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 


//! Initializes algorithm by shapes data structure <br>
Standard_EXPORT BOPTools_RoughShapeIntersector(const BooleanOperations_PShapesDataStructure& PDS);


//! Perform computations. <br>
Standard_EXPORT   void Perform() ;


//!  Returns 2 dimension array of status flags. <br>
//! First indices of the array corresponds to indices of <br>
//! subshapes of Object of myPDS. <br>
//! Second indices of array corresponds to indices of <br>
//! subshapes of Tool of myPDS. <br>
Standard_EXPORT  const Handle_BOPTools_HArray2OfIntersectionStatus& TableOfStatus() const;


//! Returns False if some errors occured during <br>
//! computations or method Perform <br>
//! was not invoked before, <br>
//! otherwise returns True. <br>
Standard_EXPORT   Standard_Boolean IsDone() const;





protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


Standard_EXPORT   void Prepare() ;


Standard_EXPORT   void PropagateForSuccessors1(const Standard_Integer AncestorsIndex1,const Standard_Integer AncestorsIndex2,const BOPTools_IntersectionStatus theStatus) ;


Standard_EXPORT   void PropagateForSuccessors2(const Standard_Integer AncestorsIndex1,const Standard_Integer AncestorsIndex2,const BOPTools_IntersectionStatus theStatus) ;


 // Fields PRIVATE
 //
BooleanOperations_PShapesDataStructure myPDS;
Handle_Bnd_HArray1OfBox myBoundingBoxes;
Handle_BOPTools_HArray2OfIntersectionStatus myTableOfStatus;
Standard_Boolean myIsDone;


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
