/* $Id: nntpcache.h,v 1.2 1998/08/02 20:35:03 proff Exp $
 * $Copyright$
 */

#ifndef NNTPCACHE_H
#define NNTPCACHE_H

enum cmds {c_post, c_group, c_ihave, c_listgroup, c_newnews, c_newgroups, c_xgtitle, c_list, c_xover, c_xhdr, c_article, c_head, c_body, c_stat, c_mode, c_noop, c_slave, c_quit, c_next, c_last, c_xpath, c_authinfo, c_date, c_help, c_none};
struct command
{
	char *cmd;
	enum cmds val;
	char *desc;
};

enum auth_state {none, user, valid};
enum task_state {nc_none=0, nc_master, nc_client, nc_update, nc_expire, nc_nocem, nc_oneshot, nc_http, nc_last};

struct task_info 
{
    char *ti_name;
    struct server_cfg *ti_CurrentScfg;
    time_t ti_started;
    int ti_pid;
    int ti_idx;
    enum task_state ti_state;
    int ti_ArtRead;
    int ti_GroupsEntered;
    int ti_PostsReceived;
    int ti_PostsRejected;
    char ti_client_host[128 + 1 + MAX_HOST];
    char ti_CurrentGroup[MAX_GROUP];
    char ti_status_line[128];
};

#define CurrentScfg (Task->ti_CurrentScfg)
#define ArtRead (Task->ti_ArtRead)
#define GroupsEntered (Task->ti_GroupsEntered)
#define CurrentGroup (Task->ti_CurrentGroup)
#define PostsReceived (Task->ti_PostsReceived)
#define PostsRejected (Task->ti_PostsRejected)

#include "nntpcache.ext"

#endif /* NNTPCACHE_H */
