#line 1 "cfunc.mod"
#include "cm.h"
#line 1 "cfunc.mod"
/* ===========================================================================
FILE    cfunc.mod

MEMBER OF process XSPICE

Copyright 1991
Georgia Tech Research Corporation
Atlanta, Georgia 30332
All Rights Reserved

PROJECT A-8503

AUTHORS

    9/12/91  Bill Kuhn

MODIFICATIONS

    <date> <person name> <nature of modifications>

SUMMARY

    This file contains the definition of an inductor code model
    with current initial conditions.

INTERFACES

    cm_inductor()

REFERENCED FILES

    None.

NON-STANDARD FEATURES

    None.

=========================================================================== */

void *malloc(int);
void  free(void *);


#define LI  0


void cm_inductor (Mif_Private_t *private)
{
    Complex_t   ac_gain;
    double      partial;
    double      ramp_factor;
    double      *li;

    /* Get the ramp factor from the .option ramptime */
    ramp_factor = cm_analog_ramp_factor();

    /* Initialize/access instance specific storage for capacitor voltage */
    if(private->circuit.init) {
        li = cm_analog_alloc(LI, sizeof(double));
        *li = private->param[1]->element[0].rvalue * ramp_factor;
    }
    else {
        li = cm_analog_get_ptr(LI, 0);
    }

    /* Compute the output */
    if(private->circuit.anal_type == DC) {
        private->conn[0]->port[0]->output.rvalue = private->param[1]->element[0].rvalue * ramp_factor;
         private->conn[0]->port[0]->partial[0].port[0] = 0.0;
    }
    else if(private->circuit.anal_type == AC) {
        ac_gain.real = 0.0;
        ac_gain.imag = 1.0 * private->circuit.frequency * private->param[0]->element[0].rvalue;
         private->conn[0]->port[0]->ac_gain[0].port[0] = ac_gain;
    }
    else if(private->circuit.anal_type == TRANSIENT) {
        if(ramp_factor < 1.0) {
            *li = private->param[1]->element[0].rvalue * ramp_factor;
            private->conn[0]->port[0]->output.rvalue = *li;
             private->conn[0]->port[0]->partial[0].port[0] = 0.0;
        }
        else {
            cm_analog_integrate(private->conn[0]->port[0]->input.rvalue / private->param[0]->element[0].rvalue, li, &partial);
            partial /= private->param[0]->element[0].rvalue;
            private->conn[0]->port[0]->output.rvalue = *li;
             private->conn[0]->port[0]->partial[0].port[0] = partial;
        }
    }
}

