/****************************************************************************
**
** Copyright (C) 2001-2004 Tilo Riemer <riemer@lincvs.org>
**
**
**----------------------------------------------------------------------------
**
**----------------------------------------------------------------------------
**
** LinCVS is available under two different licenses:
**
** If LinCVS is linked against the GPLed version of Qt 
** LinCVS is released under the terms of GPL also.
**
** If LinCVS is linked against a nonGPLed version of Qt 
** LinCVS is released under the terms of the 
** LinCVS License for non-Unix platforms (LLNU)
**
**
** LinCVS License for non-Unix platforms (LLNU):
**
** Redistribution and use in binary form, without modification, 
** are permitted provided that the following conditions are met:
**
** 1. Redistributions in binary form must reproduce the above copyright
**    notice, this list of conditions and the following disclaimer in the
**    documentation and/or other materials provided with the distribution.
** 2. It is not permitted to distribute the binary package under a name
**    different than LinCVS.
** 3. The name of the authors may not be used to endorse or promote
**    products derived from this software without specific prior written
**    permission.
** 4. The source code is the creative property of the authors.
**    Extensions and development under the terms of the Gnu Public License
**    are limited to the Unix platform. Any distribution or compilation of 
**    the source code against libraries licensed other than gpl requires 
**    the written permission of the authors.
**
**
** THIS SOFTWARE IS PROVIDED BY THE AUTHOR "AS IS" AND ANY EXPRESS OR 
** IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
** WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
** ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY 
** DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL 
** DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE 
** GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
** INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
** WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING 
** NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS 
** SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
**
**
**
** LinCVS License for Unix platforms:
**
** This program is free software; you can redistribute it and/or modify 
** it under the terms of the GNU General Public License as published by 
** the Free Software Foundation; either version 2 of the License, or 
** (at your  option) any later version.  This program is distributed in 
** the hope that it will be useful, but WITHOUT ANY WARRANTY; without 
** even the implied warranty of MERCHANTABILITY or FITNESS FOR A 
** PARTICULAR PURPOSE.
**
** See the GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software Foundation,
** Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
**
*****************************************************************************/

#include "config.h"

//----------------------------------------------------------------------------

#include <qwhatsthis.h>
#include <qpushbutton.h>
#include <qcombobox.h>
#include <qlineedit.h>
#include <qmessagebox.h>

//----------------------------------------------------------------------------

#include "globals.h"
#include "EditProfilesDialogImpl.h"

//----------------------------------------------------------------------------

CEditProfilesDialogImpl::CEditProfilesDialogImpl(QStringList *pUserList,
                                                 QStringList *pServerList,
                                                 QStringList *pRepositoryList,
                                                 QStringList profileNameList,
                                                 const QIconSet &whatsThisIconSet,
                                                 QWidget* parent /*= 0*/, const char* name /*= 0*/)
//   : CEditProfilesDialog (LookAndFeel::g_b0AsParent ? 0 : parent, name, true, 
   : CEditProfilesDialog (parent, name, true, LookAndFeel::g_modalF),
     m_pUserList(pUserList), m_pServerList(pServerList),
     m_pRepositoryList(pRepositoryList), m_profileNameList(profileNameList),
     m_allowedName(QString::null)
{
   m_pWhatsThis->setIconSet(whatsThisIconSet);
   m_pWhatsThis->setMaximumWidth(m_pWhatsThis->height());

   fillCtrls(false);
}

//----------------------------------------------------------------------------

CEditProfilesDialogImpl::CEditProfilesDialogImpl(QStringList *pUserList,
                                                 QStringList *pServerList,
                                                 QStringList *pRepositoryList,
                                                 QStringList profileNameList,
                                                 CLincvsProfile profile,
                                                 const QIconSet &whatsThisIconSet,
                                                 QWidget* parent /*= 0*/, const char* name /*= 0*/)
/*   : CEditProfilesDialog (LookAndFeel::g_b0AsParent ? 0 : parent, name, true, 
                          Qt::WStyle_SysMenu | Qt::WStyle_MinMax | 
                          Qt::WStyle_DialogBorder | Qt::WType_Dialog),*/
   : CEditProfilesDialog (parent, name, true, LookAndFeel::g_modalF),
     m_pUserList(pUserList), m_pServerList(pServerList),
     m_pRepositoryList(pRepositoryList), m_profileNameList(profileNameList),
     m_profile(profile), m_allowedName(profile.name())
{
   m_pWhatsThis->setIconSet(whatsThisIconSet);
   m_pWhatsThis->setMaximumWidth(m_pWhatsThis->height());

   fillCtrls(true);
}

//----------------------------------------------------------------------------

void CEditProfilesDialogImpl::fillCtrls(const bool bEdit)
{
   m_pUserList->sort();
   m_pServerList->sort();
   m_pRepositoryList->sort();
   
   m_pUserBox->insertStringList(*m_pUserList);
   m_pServerBox->insertStringList(*m_pServerList);
   m_pRepositoryBox->insertStringList(*m_pRepositoryList);
   
   if (bEdit) {
      m_pNameEdit->setText(m_profile.name());
      m_pUserBox->setCurrentText(m_profile.user());
      m_pServerBox->setCurrentText(m_profile.server());
      m_pRepositoryBox->setCurrentText(m_profile.repository());
      m_pAccessBox->setCurrentItem(m_profile.method());
      accessMode(m_profile.method());
      m_pSshSettingsBox->setCurrentItem(m_profile.sshClientPreset());
   } else {
      m_pUserBox->setCurrentText("");
      m_pServerBox->setCurrentText("");
      m_pRepositoryBox->setCurrentText("");
      m_pAccessBox->setCurrentItem(LOCAL);
      accessMode(LOCAL);
      m_pSshSettingsBox->setCurrentItem(NOSSH);
   }
}

//----------------------------------------------------------------------------

void CEditProfilesDialogImpl::accessMode(int m)
{
   bool b = true;
   if (m == LOCAL) b = false;

   m_pUserBox->setEnabled(b);
   m_pServerBox->setEnabled(b);
   
   if (m == RSH) m_pSshSettingsBox->setEnabled(true);
   else m_pSshSettingsBox->setEnabled(false);
}

//----------------------------------------------------------------------------

void CEditProfilesDialogImpl::accept()
{
   if (m_pNameEdit->text().isEmpty()) {
      QString msg = tr("Please enter a profile name!");
      QMessageBox::critical(this, tr("Error"), msg, 0);
      return;
   }

   if (!checkName()) {
      QString msg = tr("The name of the profile must be unique.");
      msg += "\n";
      msg += tr("\'%1\' is already used.");
      QMessageBox::critical(this, tr("Error"),
                            msg.arg(m_pNameEdit->text()), 0);
      return;
   }

   // add entries to lists
   adaptQStringList(m_pUserBox->currentText().stripWhiteSpace(), m_pUserList, HistorySize::g_profiles);
   adaptQStringList(m_pServerBox->currentText().stripWhiteSpace(), m_pServerList, HistorySize::g_profiles);
   adaptQStringList(m_pRepositoryBox->currentText().stripWhiteSpace(), m_pRepositoryList, HistorySize::g_profiles);
   
   // fill data into profile
   m_profile.name(m_pNameEdit->text().stripWhiteSpace());
   m_profile.user(m_pUserBox->currentText().stripWhiteSpace());
   m_profile.server(m_pServerBox->currentText().stripWhiteSpace());
   m_profile.repository(m_pRepositoryBox->currentText().stripWhiteSpace());
   m_profile.method(m_pAccessBox->currentItem());
   m_profile.sshClientPreset(m_pSshSettingsBox->currentItem());
   
   CEditProfilesDialog::accept();
}

//----------------------------------------------------------------------------

void CEditProfilesDialogImpl::reject()
{
   adaptQStringList(m_pUserBox->currentText().stripWhiteSpace(), m_pUserList, HistorySize::g_profiles);
   adaptQStringList(m_pServerBox->currentText().stripWhiteSpace(), m_pServerList, HistorySize::g_profiles);
   adaptQStringList(m_pRepositoryBox->currentText().stripWhiteSpace(), m_pRepositoryList, HistorySize::g_profiles);

   CEditProfilesDialog::reject();
}

//----------------------------------------------------------------------------

bool CEditProfilesDialogImpl::checkName()
{
   QString curName = m_pNameEdit->text().stripWhiteSpace();
   QStringList::const_iterator it;
   for (it = m_profileNameList.begin(); it != m_profileNameList.end(); it++) {
      if ((*it == curName) && (*it != m_allowedName)) return false;
   }
   
   return true;
}

//----------------------------------------------------------------------------

void CEditProfilesDialogImpl::enterWhatsThisMode()
{
   QWhatsThis::enterWhatsThisMode();
}

//----------------------------------------------------------------------------
