/****************************************************************************
**
** $Id: qt-compat-3.0.x.cpp,v 1.7 2004/01/11 19:52:54 riemer Exp $
**
** Copyright (C) 2001-2004 Tilo Riemer <riemer@lincvs.org>,
**                         Iztok Kobal <iztok.kobal@iskrasistemi.si>
**
**
**----------------------------------------------------------------------------
**
** Many thanks to Iztok Kobal for adding backword compatibility
**
**----------------------------------------------------------------------------
**
** LinCVS is available under two different licenses:
**
** If LinCVS is linked against the GPLed version of Qt 
** LinCVS is released under the terms of GPL also.
**
** If LinCVS is linked against a nonGPLed version of Qt 
** LinCVS is released under the terms of the 
** LinCVS License for non-Unix platforms (LLNU)
**
**
** LinCVS License for non-Unix platforms (LLNU):
**
** Redistribution and use in binary form, without modification, 
** are permitted provided that the following conditions are met:
**
** 1. Redistributions in binary form must reproduce the above copyright
**    notice, this list of conditions and the following disclaimer in the
**    documentation and/or other materials provided with the distribution.
** 2. It is not permitted to distribute the binary package under a name
**    different than LinCVS.
** 3. The name of the authors may not be used to endorse or promote
**    products derived from this software without specific prior written
**    permission.
** 4. The source code is the creative property of the authors.
**    Extensions and development under the terms of the Gnu Public License
**    are limited to the Unix platform. Any distribution or compilation of
**    the source code against libraries licensed other than gpl requires
**    the written permission of the authors.
**
**
** THIS SOFTWARE IS PROVIDED BY THE AUTHOR "AS IS" AND ANY EXPRESS OR
** IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
** WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
** ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY
** DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
** DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE
** GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
** INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
** WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
** NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
** SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
**
**
**
** LinCVS License for Unix platforms:
**
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your  option) any later version.  This program is distributed in
** the hope that it will be useful, but WITHOUT ANY WARRANTY; without
** even the implied warranty of MERCHANTABILITY or FITNESS FOR A
** PARTICULAR PURPOSE.
**
** See the GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software Foundation,
** Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
**
*****************************************************************************/

#include "config.h"

//----------------------------------------------------------------------------

#if QT_VERSION < 0x030100


//----------------------------------------------------------------------------

//we must include before qt headers because we need Q_INLINE_TEMPLATES

//----------------------------------------------------------------------------

#include <qobjectdefs.h>
#include <qdatatable.h>
#include <qmetaobject.h>

//----------------------------------------------------------------------------

// copied from qt-3.2's qobject.cpp
/*!
    \internal

    Returns TRUE if \a object inherits \a superClass within
    the meta object inheritance chain; otherwise returns FALSE.

    \sa inherits()
*/
void *qt_inheritedBy( QMetaObject *superClass, const QObject *object )
{
    if (!object)
      return 0;
    register QMetaObject *mo = object->metaObject();
    while (mo) {
      if (mo == superClass)
        return (void*)object;
      mo = mo->superClass();
    }
    return 0;
}

//----------------------------------------------------------------------------

// ********** class QTableSelection *****************

// copied from Qt-3.2.0b2 src/table/qtable.cpp
/*!
    Creates an active selection, starting at \a start_row and \a
    start_col, ending at \a end_row and \a end_col.
*/
// We must use the right symbols here to call the base class' constructor
#define QTableSelection QTableSelection
QTableSelectionEx::QTableSelectionEx( int start_row, int start_col, int end_row, int end_col )
    : QTableSelection()
{
    init( start_row, start_col );
    expandTo( end_row, end_col );
};
// Now we can use the fake ones
#define QTableSelection QTableSelectionEx
//----------------------------------------------------------------------------

// ********** class QTable **************************

// copied from Qt-3.2.0b2 src/table/qtable.cpp
/*! Selects the row \a row.

  \sa QTableSelection
*/
// ### Make this virtual in 4.0 and remove hack for QDataTable
void QTableEx::selectRow( int row ) {
  row = QMIN(numRows()-1, row);
  bool isDataTable = FALSE;
#ifndef QT_NO_SQL
  isDataTable = ::qt_cast<QDataTable*>(this) != 0;
#endif
  if ( isDataTable || selectionMode() == SingleRow ) {
    setCurrentCell( row, currentColumn() );
  } else {
    QTableSelection sel( row, 0, row, numCols() - 1 );
    addSelection( sel );
  }
}; // end of QTableX::selectRow

//----------------------------------------------------------------------------

//----------------------------------------------------------------------------

// ********** class QClipboard **************************


#ifndef QT_NO_MIMECLIPBOARD
#define QClipboard QClipboard
// functions are not implemented as in src/kernel/qclipboard_x11.cpp - to much code to copy ... sigh !
QMimeSource* QClipboardEx::data( Mode mode ) const
{
  return ((QClipboard*)this)->data();
}
void QClipboardEx::setData( QMimeSource* src, Mode mode )
{
  ((QClipboard*)this)->setData(src);
}
#define QClipboard QClipboardEx
#endif


//----------------------------------------------------------------------------

// ********** class QTextEdit **************************


#endif // QT_VERSION < 0x030100
