gset Copyright {Copyright (c) 1996--1999 Geoff Pike.
All rights reserved.

Floater is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

This software is provided "as is" and comes with absolutely no
warranties.  Geoff Pike is not liable for damages under any
circumstances.  Support is not provided.  Use at your own risk.

Personal, non-commercial use is allowed.  Attempting to make money
from Floater or products or code derived from Floater is not allowed
without prior written consent from Geoff Pike.  Anything that remotely
involves commercialism, including (but not limited to) systems that
show advertisements while being used and systems that collect
information on users that is later sold or traded require prior
written consent from Geoff Pike.
}
gset Readme {			    Floater 1.2b1
		  for Unix and for Microsoft Windows
			  September 14, 1999

		       http:slashslashwww.floater.org/

                            by Geoff Pike
			  geoff@floater.org


Please check the ever growing Floater web page at
http:slashslashwww.floater.org/ for the most up-to-date
documentation and information, including everything here and much more.

Floater is a free program for duplicate bridge play on the Internet.
It also supports non-duplicate bridge and 3-player hearts.

Floater 1.2 is a minor upgrade to 1.1 that includes several changes:
  o  Faster server
  o  New installer for Microsoft Windows users
  o  Some bug fixes

Version 1.2 is not interoperable with older versions.

To install, Microsoft Windows users should download and run the
installer from the Floater web page.  Unix users will need to rebuild
from scratch as described below.

Please report bugs to bugs@floater.org.

Floater for Macintosh will be available soon.  Sorry for the delay.

Please read this file as well as the files called BUGS and CONFUSING.

Microsoft Windows Installation Instructions:
--------------------------------------------

Download and run the installer, inst12b1.exe, available at
http:slashslashwww.floater.org/inst12b1.exe.  The installer has two basic
steps.  Step 1: the installer checks for Tcl/Tk 8.0 and offers to
download and install it for you if necessary.  Step 2: the installer
downloads the Floater executable and associated files from floater.org
and creates a shortcut to Floater from the Desktop and from the
Start Menu.

After installing Floater, you may delete the installer.

Unix Installation instructions:
-------------------------------

Please be aware that these instructions are for installation only.
See the web page for other, ultimately more useful, information.

Please read carefully.  Unlike the Mac and Microsoft Windows versions,
you must compile Floater yourself for Unix.  If you have never edited
a Makefile before, you may find this difficult.

If you have problems, please consult the web page to see if there are
notes from others who may have tried compiling Floater on your
architecture/OS.  Send bugs to bugs@floater.org, and also please send
descriptions of what you had to modify to get Floater to work on your
system.  When sending email about problems that you have not yet been
able to solve, please clearly indicate what you have tried so far.
Due to the high volume of email, responses may be slow.

Almost all of the difficult-to-port features of Floater are
implemented by using Tcl and Tk, which have already been ported to
many different machines.  Floater should run on a variety of machines
with no problem.  It is known to compile on SunOS, Solaris,
Linux, HPs (HP/UX), and Silicon Graphics (IRIX), among others.  Don't
be intimidated by the amount of software you may need to install---the
autoconf scripts really work and next to nothing needs to be fixed by hand.

Floater for Unix has two versions---textual and graphical.  Both
require Tcl and Tk, which are freely available.  In addition, the text
version requires System V style curses or ncurses (GNU's free
replacement for curses).  Tcl/Tk 8.0 is required.  You should use the
latest patch level, which as of September, 1999, is 8.0.5.  (Floater
does not work with Tcl/Tk 8.1 or 8.2.  If you port it to Tcl/Tk 8.2
let us know!)

By default, the graphical and textual versions are in the same
executable.  You may build an executable that does not include the
textual version, which is useful if you have X and don't want to deal
with curses (see Makefile for details).

BSD users without ncurses should have it installed anyway, as the
maintainer of BSD curses has publically announced that he is no longer
supporting it and he encourages people to switch to ncurses.  If you
are unsure whether you need ncurses to use Floater, try it first
without ncurses.  You may get ncurses by anonymous ftp from
prep.ai.mit.edu in the /pub/gnu directory.  Or, it is too much
trouble, you may compile only the X user interface (see Makefile for
details).

Detailed instructions follow.  For easier ftp'ing, the Floater
web page (http:slashslashwww.cs.berkeley.edu/~pike/floater/release.html)
allows you to download the appropriate files.

To install Floater 1.2b1 for Unix:
----------------------------------

0. Floater more or less requires UNIX and 32-bit integers.  Brave
souls who try to install it without those things may succeed but with
some difficulty.

1. If your site doesn't have it, install Tcl/Tk, available from the
Tcl/Tk web page at http:slashslashwww.scriptics.com.  Note that Tcl/Tk 8.0.5
is what you should try to use, but 8.0.x is fine.  See above.

2. You may or may not need ncurses.  System V users and many BSD users
should either not need it or already have it.  See above.

3. Get the compressed Floater tar file from the Floater web page.
Uncompress and untar the file by doing:
        gzip -c -d floater1.2b1.tar.gz | tar xvf -

(You may remove floater1.2b1.tar.gz now.)

4. Run the configure script by doing changing to the floater1.2b1
directory and running ./configure.  The flags accepted by the
configure script are as follows:
  --with-tcl=/some/path
     will look for tcl headers files and libs in /some/path/include
     and /some/path/lib

  --with-tk=/some/path
     same as --with-tcl but for tk

  --with-curses=/some/path
     same as above but for curses (it tries to look for ncurses and
     then curses but may not be perfect...)

  --without-curses
     doesn't look for curses at all and defines GUI_ONLY when
     building.

If the configure script runs successfully, it creates a Makefile.
(Thanks to Andrew Swan for creating the new and improved configure script!)

5. Do "make".  It may or may not work.  If it doesn't work, edit the
file Makefile.in to try to set up the paths for various libraries,
etc., as necessary.  More instructions are in that file.  Each time
you edit Makefile.in, do "make Makefile" to regenerate the Makefile,
and then do (just) "make" again.  (On some systems you can just do
"make" and it will automatically recreate the Makefile and then try to
recompile.)  If desperate, you may also want to refer to
Makefile.pike, which is a Makefile that is known to work on at least
one system somewhere.

6. Once you have successfully built Floater, a common problem when you
first run it is an error message about being unable to find init.tcl
in certain directories.  The easiest solution, if you have Tcl and Tk
in sibling directories, is to create a directory called lib, sibling
to those two, and do:
        cd lib
        ln -s ../tk8.0/library tk8.0
        ln -s ../tcl8.0/library tcl8.0

Another solution is to find init.tcl and put a copy of it in one of
the directories in which it is looking when you start up Floater.
Another is, before running Floater, to do "setenv TCL_LIBRARY <dir>"
where <dir> is the directory containing init.tcl (typically
<something>/tcl8.0/library).  A third is to properly install Tcl by
doing "make install" in the tcl8.0/unix directory---but you probably
have to be root to do this.

(Once you fix that, the analogous problem will likely crop up with Tk.
It will complain that it can't find a usable tk.tcl.  The same fixes
apply, but be sure to copy all the .tcl files in tk8.0/library if you
choose that solution.)
}
gset Confusing {This file is intended to list some of the more confusing aspects of
using Floater.

1. Floater relies on self-alerts.  If playing formally, you are
expected to explain your bidding and carding agreements as carefully
as you would at a tournament.  In any case, you alert by using the
commands `alert,' `redalert' and `explain.'   You should alert
at the same time or before you take an alertable action.  There are no
fixed rules as to what agreements are alertable---use your judgment
and do unto others as you would have them do unto you.

The easy way to alert an action is to type "!" (or "!!" for redalert)
on the same line as the command to perform that action---and
optionally put an explanation at the end.  For example, you could type
"2D!weak two in either major" to bid and alert your own bid
simultaneously.  See also the help on `alert,' `redalert' and
`explain.'

If you are using the graphical user interface, you may click on the
"Alert" or "Redalert" checkboxes BEFORE clicking on the call you wish
to make.  For example, clicking on "1C" when the "Alert" checkbox is
highlighted will have the same effect as typing "1C!" on the keyboard.

Everyone at the table except partner sees your alerts.

2. See also the file called BUGS.
}
gset Bugs {This file lists some of the known bugs and limitations of Floater.
Please read it.  You may assume everything listed here is being worked
on and will be eventually fixed.  Older bugs are at toward the bottom;
newer bugs are toward the top.  An asterisk after the numeral
indicates that the bug has been fixed.  (Some of the listings may be
cryptic or incomprehensible---my apologies.)

Send bug reports to bugs@floater.org.

8. When I host, scoring method defaults to whatever it was at the
previous table.  Furthermore, when I do, say, "score imp," the list of
tables isn't updated immediately.

7. When using the GUI, occasionally I have had the menu bar at the
top disappear and not come back.  This appears to be a Tcl/Tk bug.  If
it happens, iconify Floater and then restore it, and the menu bar
will reappear.

6. The review command sometimes puts your side's actions in parens.
I think it should always put the other guys' actions in parens.

5.. Pseudomail works but doesn't correctly report whether it succeeded.
(It always reports success.)

4. The documentation is a work in progress.  For the latest, look at:
     http:slashslashwww.floater.org/doc

3. Curses may be confused about your screen size or terminal attributes.
Putting the following in your .cshrc may do the trick:
    setenv TERM vt100

    set noglob
    eval `tset -s`
    unset noglob

Another possible fix is to try doing:
    eval `resize`

2. Logging in disconnects you from the table.  (This is becuase the other
players would become confused if your name suddenly changed.  But it
can be fixed.)

1. Sometimes after being shunted (when you do the `host' command) you
find that you do not get connected properly to the table tree.  When
this happens, try again a few times.  As a last resort, you may do
`host <tablename>' to try to join the table tree at that location.
}
gset help_texts {Copyright Readme Confusing Bugs}
