/* Copyright (c) 1996--1999 Geoff Pike. */
/* All rights reserved. */

/* Floater is distributed in the hope that it will be useful, */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. */

/* This software is provided "as is" and comes with absolutely no */
/* warranties.  Geoff Pike is not liable for damages under any */
/* circumstances.  Support is not provided.  Use at your own risk. */

/* Personal, non-commercial use is allowed.  Attempting to make money */
/* from Floater or products or code derived from Floater is not allowed */
/* without prior written consent from Geoff Pike.  Anything that remotely */
/* involves commercialism, including (but not limited to) systems that */
/* show advertisements while being used and systems that collect */
/* information on users that is later sold or traded require prior */
/* written consent from Geoff Pike. */
#ifndef __COMMANDHASH_H__
#define __COMMANDHASH_H__

#define AMBIGUOUS ((char *) 1)

#define NEW_ISSTRINGCOMMAND(s) \
	atob(TclDo3("uplevel #0 {info exists {isstringcommand(", \
		    itoa((long) s), ")}}"))
#define OLD_ISSTRINGCOMMAND(s) (((long) s) & 1)
#define ISSTRINGCOMMAND(s) \
  (using_old_isstringcommand ? OLD_ISSTRINGCOMMAND(s) : NEW_ISSTRINGCOMMAND(s))
extern bool using_old_isstringcommand;

typedef int (*commandptr)(char *);

commandptr commandhash(char *s);
void cmdbind(char *s, commandptr binding);
void stringbind(char *s, char *binding);

void hashdump(void);

#endif
