/* Copyright (c) 1996--1999 Geoff Pike. */
/* All rights reserved. */

/* Floater is distributed in the hope that it will be useful, */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. */

/* This software is provided "as is" and comes with absolutely no */
/* warranties.  Geoff Pike is not liable for damages under any */
/* circumstances.  Support is not provided.  Use at your own risk. */

/* Personal, non-commercial use is allowed.  Attempting to make money */
/* from Floater or products or code derived from Floater is not allowed */
/* without prior written consent from Geoff Pike.  Anything that remotely */
/* involves commercialism, including (but not limited to) systems that */
/* show advertisements while being used and systems that collect */
/* information on users that is later sold or traded require prior */
/* written consent from Geoff Pike. */
#ifndef __BR_H__
#define __BR_H__

#include "message.h"
#include "deal.h"

extern bool competitive;
extern bool new_competitive;

/* how many scoring methods use (worldwide) identical random hands */
#define NUMPAIRGAMES 2
#define DUPLICATE(scoremethod) ((scoremethod) < NUMPAIRGAMES)
#define NONCOMPETITIVE() (scoremethod < NUMPAIRGAMES && !competitive)

typedef void (*startupfn)(void);
typedef void (*seedfn)(void);
typedef void (*playfn)(void);

typedef struct {
  char *scoringname;
  int numplayers;
  startupfn startup;
  seedfn seed;
  /* playfn play; */
} scoring;

/* hearts stuff */
extern bool playinghearts;
extern int cardsperhand;
extern bool passisover(char *, int);
extern void updatepassstate(char *, char *);
extern bool isnewinfo(char *, char *);
extern void reportpassstatus(char *);
extern void adjusthands(char *, int, int *);
void broadcast_curpassstate(void);

extern int scoremethod; /* index into scoringmethods[] */
#define numscoringmethods 4
extern scoring scoringmethods[numscoringmethods];
/* #define numscoringmethods (sizeof(scoringmethods)/sizeof(scoringmethods[0])) */
bool isrubber(int n);
bool ishearts(int n);
bool isrubberstring(char *s);
bool isheartsstring(char *s);

void parseheartsgstate(char *, int *, int *, int *);
void parserubbergstate(char *, bool *, bool *, int *, int *, int *, int *);

#define passedout(auction) streq(auction, " p p p p")
#define numcards_(play) (isin('!', (play)) ? 52 : (strlen(play) / 2))
#define numcalls(a) (strlen(a) / 2)
#define numcards(p) \
    (isin('!', (p)) ? ((strlen(p) / 2) - 1) : (strlen(p) / 2))

extern bool seated;

extern int myseat;
extern int rhoseat;

extern char playerport[4][MAXPORTLEN+1];
extern char playeraddr[4][MAXADDRLEN+1];
#define rhoaddr playeraddr[rhoseat]
#define rhoport playerport[rhoseat]
bool auctionisover(char *auction);
bool playisover(char *auction, char *play);
void sit(char *name, char seat, char *addr, char *port);
void cleartable(void);
char *contract(char *auction);
char declarer(char *auction, int dealer);
char seat_to_char(int seat);
bool myturntobid(void);
bool myturntoplay(void);
bool silentmyturntobid(void);
bool silentmyturntoplay(void);
void followsmall(void);
bool executebid(char *b);
bool executeplay(char *p);
void generatedeal(void);
char *setscoringmethod(char *method);
char *prettyauction(char *auction);
char *prettyprintcardset(char *w);
void showprevioushand(void);
void reviewauction(void);
void showlasttrick(void);
char *display_of_previous_trick(void);

void makerandombid(void);
void makerandomplay(void);

void playsmall(char suit); /* try to play my smallest card of given suit */
bool follow(char *card); /* follow suit with the named card */

bool filehandinfo(message *m);
void tellseatstatus(char *connstr);
void tellhandstatus(char *name, char *connstr);
void tellcc(char *connstr);
void ccupdate(char *who, char *cc);
bool unoccupied(char seat);
void persongone(char *name);
void nobridge(void);
void parseseen(char seat, int index, char *seen);
bool haveseen(int i, int num);
#define loadseen() TclDo("loadseen")

/* a `column', e.g. declarercolumn, is an integer from 0 to 3:
   3 means me, 0 means lho, 1 means partner, 2 means rho */
/* In three-handed hearts, 2 means me, 0 means lho, 1 means rho */
/* columns are used a lot in UI.c and seldom if ever elsewhere */
/* a `seat' is an integer meaning North, South, East, or West
   (see deal.h -- North is 0, East is 1, ... ) */
#define bcol_to_seat(column, pov) (((column) + 1 + (pov)) % 4)
#define bseat_to_col(seat, pov) (((seat) + 3 - (pov)) % 4)
#define hcol_to_seat(column, pov) (((column) + 1 + (pov)) % 3)
#define hseat_to_col(seat, pov) (((seat) + 2 - (pov)) % 3)
#define col_to_seat(column, pov, hearts) \
  ((hearts) ? hcol_to_seat((column), (pov)) : bcol_to_seat((column), (pov)))
#define seat_to_col(seat, pov, hearts) \
  ((hearts) ? hseat_to_col((seat), (pov)) : bseat_to_col((seat), (pov)))

#define validseat(seat) (((seat) <= 3) && ((seat) >= 0))

#define declaring() (seated && (curdeclarer == myseat))
#define defending() \
	(seated && validseat(curdeclarer) && ((curdeclarer ^ myseat) & 1))

int computeleader(char *pstate, int cardsplayed, int trumpsuit, int declarer,
		  bool hearts);
void computecontract(char *auction, int dealer, char *contract,
		     int *declarer, int *trump);
void computetrickswon(char *pstate, int tricks,
		      int trump, int declarer, int *decl, int *defense);
void computeresult(char *contract, char *play, int declarer, bool vul,
		   int *resulttricks, int *resultpoints, int *legs);

void showinitialcards(int seat);
void down(char *s);
void make(char *s);
void claim(char *s);
void acceptclaim(void);
void retractclaim(void);
void rejectclaim(void);
void handleclaimmessage(char kind, char *handID,
			int tricks, char *from); /* called by comm.c */

void resetseen(void);

char *bridge_statusbar(char *s, int start, int end, bool *center);

void parse_you_have_seen(char *set, char *msg);
int handnum(char *handname);
char *handname_to_setname(char *handname);
char *handname_to_weekname(char *handname);

#ifdef LOGINSERVER
void announce_seen(char *connstr, char *name);
#endif

#define isCompetitiveHandname(n) (!isin('-', (n)))

typedef void (*insertcharfn)(char *);

bool insert_default_action(bool needSlash, insertcharfn f);

#endif
