/* Copyright (c) 1996--1999 Geoff Pike. */
/* All rights reserved. */

/* Floater is distributed in the hope that it will be useful, */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. */

/* This software is provided "as is" and comes with absolutely no */
/* warranties.  Geoff Pike is not liable for damages under any */
/* circumstances.  Support is not provided.  Use at your own risk. */

/* Personal, non-commercial use is allowed.  Attempting to make money */
/* from Floater or products or code derived from Floater is not allowed */
/* without prior written consent from Geoff Pike.  Anything that remotely */
/* involves commercialism, including (but not limited to) systems that */
/* show advertisements while being used and systems that collect */
/* information on users that is later sold or traded require prior */
/* written consent from Geoff Pike. */
#ifndef __ui_H__
#define __ui_H__

extern char *vulnames[];

#define fulltable()
#define notfulltable()

void UIstate(int state);
void UIwrongpassword(void);
void UInameinuse(void);
void UIupdate(void);
void UIplayergone(int which);
void UIsit(char *name, char ch, int myseat);
void UIsetstatusline(void);
void UIspec(void);
void UItablehost(void);
void UIheartshandover(int ns, int es, int ss);
void UIpassset(char *t);
void UItogglepassedcard(char *p);
#define Tsetstatusline(s) TclSet("statusline", (s))
#define Tsetinfoline(s) TclSet("infoline", (s))
#define Gsetstatusline(s) TclDo3(".stat configure -text {", (s), "}")
#define Gsetinfoline(s) TclDo3(".infoline configure -text {", (s), "}")
#define setinfoline(s) { if (hasWindows) { Gsetinfoline(s); } \
  else { Tsetinfoline(s); } }
#define setstatusline(s) { if (hasWindows) { Gsetstatusline(s); } \
  else { Tsetstatusline(s); } }

#define beepatmyturn() atob(TclGet("beepAtMyTurn_"))

#define GUIbeep() TclDo("catch {Floater_bell; Floater_deiconify}")

#ifdef GUI_ONLY
#define UIbeep() GUIbeep()
#else
#define UIbeep() (hasWindows ? GUIbeep() : (flash(), beep(), NULL))
#endif /* GUI_ONLY */

#endif /* __ui_H__ */

