
#include <qstring.h>
#include <qwidget.h>
#include <qlabel.h>
#include <qvbox.h>
#include <qlayout.h>
#include <qpixmap.h>
#include <qgroupbox.h>
#include <qcheckbox.h>
#include <qslider.h>
#include <qpushbutton.h>
#include <X11/Xlib.h>
#define XMD_H 1
#include <X11/extensions/xf86vmode.h>

class TVoutAdjustPage: public QWidget
{
  Q_OBJECT

  public:
    TVoutAdjustPage ( QWidget *parent=0) ;

  private slots:
    void OnTVStd( int std );
    void OnTVOn ( bool on );
    void OnTVPosLeft (void);
    void OnTVPosRight (void);
    void OnTVPosUp (void);
    void OnTVPosDown (void);
    void OnTVSizeSmaler(void);
    void OnTVSizeWider(void);
    void OnTVSizeLower(void);
    void OnTVSizeHigher(void);
    void OnTVStartLeft(void);
    void OnTVStartRight(void);
    void OnSliderTVColor ( int Value );
    void OnApply ( int *Accept );
    void OnCancel (  ) ;
    void OnActivate ( int nPage );

  private:
    void Init ( ) ;
    void    ReadCurrentSettings ( ) ;
    bool    m_Init ;
    bool    m_TVOStdChanged;
    bool    m_TVOOnOffChanged;
    bool    m_TVOAdjSizeChanged;
    bool    m_TVOAdjPosChanged;
    bool    m_TVOAdjColorChanged;

    int     m_PressLeft;
    int     m_TVConnect;
    int     m_TVStd;
    int     m_MVMode;
    int     m_tvHSizeAdj;
    int     m_tvVSizeAdj;
    int     m_tvHPosAdj;
    int     m_tvVPosAdj; 
    int     m_tvHStartAdj;
    int     m_tvColorAdj; 
    int     m_CurrentTVConnect;
    int     m_CurrentTVStd;
    int     m_CurrentMVMode;
    int     m_CurrenttvHSizeAdj;
    int     m_CurrenttvVSizeAdj;
    int     m_CurrenttvHPosAdj;
    int     m_CurrenttvVPosAdj;
    int     m_CurrenttvHStartAdj;
    int     m_CurrenttvColorAdj;
 
    QCheckBox       *pTVOn ;
    QPushButton     *pTVLeft, *pTVRight, *pTVUp, *pTVDown ;
    QPushButton     *pTVWider, *pTVSmaler, *pTVHigher, *pTVLower ;
    QPushButton     *pTVStartLeft, *pTVStartRight;
    QButtonGroup    *pTVSTD ;
    QSlider         *pSliderTVColor;
    QButtonGroup    *pTVPosition;
    QButtonGroup    *pTVSize;
    QButtonGroup    *pTVStart;
    QLabel          *pTextSliderTVColor;
    QLabel          *pTextPosH;
    QLabel          *pTextPosV;
    QLabel          *pTextSizeH;
    QLabel          *pTextSizeV;
    QLabel          *pTextStartH;
    QLabel          *pTextInfo;


} ;

