#include "FireGLControl.h"
#include "watermark.xpm"
#include "monitor1.xpm"
#include "monitor2.xpm"
#include "single.xpm"
#include "disable.xpm"
#include "left.xpm"
#include "right.xpm"
#include "top.xpm"
#include "bottom.xpm"

#ifdef FGLRX_USE_XEXTENSIONS
#include "FGLRXExtensions.h"
#endif // FGLRX_USE_XEXTENSIONS

#include <stdlib.h>
#include <unistd.h>
#include <errno.h>
#include <string.h>
#include <sys/types.h>
#include <sys/wait.h>

#ifdef DEBUG
#define DEB(s)  s
#else
#define DEB(s)
#endif // DEBUG


DualScreenPage::DualScreenPage ( QWidget *parent ) : QWidget ( parent, (const char *)0 )
{
  m_Init = FALSE ;
  m_Changed = FALSE ;
}

void DualScreenPage::Init ( )
{
  QRadioButton *pPrimary1, *pPrimary2 ;
  QRadioButton *pDisabled, *pClone, *pHorizontal, *pVertical ;
  QFrame       *pMonitorFrame ;
  QPixmap       pixmap ( watermark ) ;
  QPixmap       imonitor1 ( monitor1 ) ;
  QPixmap       imonitor2 ( monitor2 ) ;
  QPixmap       isingle ( single ) ;
  QPixmap       idisable ( disable ) ;
  QPixmap       ileft ( left ) ;
  QPixmap       iright ( right ) ;
  QPixmap       itop ( top ) ;
  QPixmap       ibottom ( bottom ) ;

  ReadCurrentSettings ( ) ;
  setBackgroundPixmap ( pixmap ) ;

  pPrimary = new QButtonGroup ( tr("Set Primary Monitor"), this ) ;
  pPrimary->setGeometry ( 8, 10, 430, 80 ) ;
  pPrimary->setBackgroundPixmap ( pixmap ) ;
  pPrimary->setBackgroundOrigin ( QWidget::ParentOrigin ) ;

  pPrimary1 = new QRadioButton ( "", pPrimary ) ;
  pPrimary1->setGeometry ( 18, 30, 55, 32 ) ;
  pPrimary1->setPixmap ( monitor1 ) ;
  pPrimary1->setFocusPolicy ( QWidget::StrongFocus ) ;

  pPrimary2 = new QRadioButton ( "", pPrimary ) ;
  pPrimary2->setGeometry ( 350, 30, 55, 32 ) ;
  pPrimary2->setPixmap ( monitor2 ) ;
  pPrimary2->setFocusPolicy ( QWidget::StrongFocus ) ;

  pPrimary->show ( ) ;
  pPrimary->setButton ( m_Primary ) ;
  connect ( pPrimary, SIGNAL(clicked(int)), SLOT( OnPrimary(int) ) ) ;


  pDesktop = new QButtonGroup ( tr("Desktop Setup"), this ) ;
  pDesktop->setGeometry ( 8, 100, 430, 140 ) ;
  pDesktop->setBackgroundPixmap ( pixmap ) ;
  pDesktop->setBackgroundOrigin ( QWidget::ParentOrigin ) ;

  pDisabled = new QRadioButton ( tr("Single Mode"), pDesktop ) ;
  pDisabled->setGeometry ( 18, 25, 100, 20 ) ;
  pDisabled->setAutoResize ( TRUE ) ;
  pDisabled->setFocusPolicy ( QWidget::StrongFocus ) ;

  pClone = new QRadioButton ( tr("Clone Mode"), pDesktop ) ;
  pClone->setGeometry ( 18, 50, 100, 20 ) ;
  pClone->setAutoResize ( TRUE ) ;
  pClone->setFocusPolicy ( QWidget::StrongFocus ) ;

  pHorizontal = new QRadioButton ( tr("Big Desktop Horizontal"), pDesktop ) ;
  pHorizontal->setGeometry ( 18, 75, 100, 20 ) ;
  pHorizontal->setAutoResize ( TRUE ) ;
  pHorizontal->setFocusPolicy ( QWidget::StrongFocus ) ;

  pVertical = new QRadioButton ( tr("Big Desktop Vertical"), pDesktop ) ;
  pVertical->setGeometry ( 18, 100, 100, 20 ) ;
  pVertical->setAutoResize ( TRUE ) ;
  pVertical->setFocusPolicy ( QWidget::StrongFocus ) ;

  pDesktop->show ( ) ;
  pDesktop->setButton ( m_Desktop ) ;
  connect ( pDesktop, SIGNAL(clicked(int)), SLOT( OnDesktop(int) ) ) ;

  pMonitorFrame = new QFrame ( this ) ;
  pMonitorFrame->setGeometry ( 260, 120, 170, 110 ) ;
  pMonitorFrame->setBackgroundPixmap ( pixmap ) ;
  pMonitorFrame->setBackgroundOrigin ( QWidget::ParentOrigin ) ;
  pMonitorFrame->setFrameStyle ( QFrame::Panel | QFrame::Sunken ) ;
  pMonitorFrame->show ( ) ;

  pSingle1 = new QLabel ( "", this ) ;
  pSingle1->setGeometry ( 308, 164, 32, 32 ) ;
  pSingle1->setPixmap ( single ) ;

  pSingle2 = new QLabel ( "", this ) ;
  pSingle2->setGeometry ( 350, 164, 32, 32 ) ;
  pSingle2->setPixmap ( single ) ;

  pDisable = new QLabel ( "", this ) ;
  pDisable->setGeometry ( 350, 164, 32, 32 ) ;
  pDisable->setPixmap ( disable ) ;

  pLeft = new QLabel ( "", this ) ;
  pLeft->setGeometry ( 308, 164, 32, 32 ) ;
  pLeft->setPixmap ( left ) ;

  pRight = new QLabel ( "", this ) ;
  pRight->setGeometry ( 350, 164, 32, 32 ) ;
  pRight->setPixmap ( right ) ;

  pTop = new QLabel ( "", this ) ;
  pTop->setGeometry ( 329, 138, 32, 32 ) ;
  pTop->setPixmap ( top ) ;

  pBottom = new QLabel ( "", this ) ;
  pBottom->setGeometry ( 329, 180, 32, 32 ) ;
  pBottom->setPixmap ( bottom ) ;

  ArrangeMonitors ( ) ;

//  pPrimary->setFocus ( ) ;
}

void DualScreenPage::ReadCurrentSettings ( )
{
  FGLRXDisplaySettingsRec DisplaySettings;
  int desktop_setup;

  ExtGetDisplaySettings(&DisplaySettings);
  desktop_setup = DisplaySettings.Desktop ;
  //Convert desktop setup 
  switch ( desktop_setup )
  {
      case DESKTOP_SETUP_SINGLE_FIRST  : // Single
      case DESKTOP_SETUP_SINGLE_SECOND : 
      case DESKTOP_SETUP_MIRROR :  // Mirror
          {
              m_Desktop = 0;
              break ;
          }
      case DESKTOP_SETUP_CLONE : //Clone Mode
          {
              m_Desktop = 1;
              break ;
          }
      case DESKTOP_SETUP_HORIZONTAL : //Extended Desktop Horizontal
      case DESKTOP_SETUP_HORIZONTAL_REVERSE : 
          {
              m_Desktop = 2;
              break ;
          }
      case DESKTOP_SETUP_VERTICAL: //Extended Desktop Vertical
      case DESKTOP_SETUP_VERTICAL_REVERSE : 
          {
              m_Desktop = 3;
              break ;
          }
  }

  /* Is desktop reversed ? */
  m_Primary = (desktop_setup & ( DESKTOP_SETUP_HORIZONTAL_REVERSE | DESKTOP_SETUP_VERTICAL_REVERSE)) ? 1 : 0;

}

void DualScreenPage::OnPrimary ( int id )
{
  m_Changed = TRUE ;
  m_Primary = id ;
}

void DualScreenPage::OnDesktop ( int id )
{
  m_Changed = TRUE ;
  m_Desktop = id ;
  ArrangeMonitors ( ) ;
}

void DualScreenPage::ArrangeMonitors ( )
{
  switch ( m_Desktop )
  {
      case 0 :// Single
    {
      pSingle1->show ( ) ;
      pSingle2->hide ( ) ;
      pDisable->show ( ) ;
      pLeft->hide ( ) ;
      pRight->hide ( ) ;
      pTop->hide ( ) ;
      pBottom->hide ( ) ;
      break ;
    }
    case 1: //Clone Mode
    {
      pSingle1->show ( ) ;
      pSingle2->show ( ) ;
      pDisable->hide ( ) ;
      pLeft->hide ( ) ;
      pRight->hide ( ) ;
      pTop->hide ( ) ;
      pBottom->hide ( ) ;
      break ;
    }
    case 2: // Horizontal
    {
      pSingle1->hide ( ) ;
      pSingle2->hide ( ) ;
      pDisable->hide ( ) ;
      pLeft->show ( ) ;
      pRight->show ( ) ;
      pTop->hide ( ) ;
      pBottom->hide ( ) ;
      break ;
    }
    case 3: // Vertical
    {
      pSingle1->hide ( ) ;
      pSingle2->hide ( ) ;
      pDisable->hide ( ) ;
      pLeft->hide ( ) ;
      pRight->hide ( ) ;
      pTop->show ( ) ;
      pBottom->show ( ) ;
      break ;
    }
  }
}

void DualScreenPage::OnActivate ( int nPage )
{
  if ( nPage != DUALSCREEN_PAGE ) return ;
  if ( m_Init ) return ;

  Init ( ) ;
  m_Init = TRUE ;
}

/* Warning when error occurs running aticonfig */
void DualScreenPage::AticonfigErrorMsgBox()
{
    QString Str ;

    Str = tr("Error running aticonfig\n") ;
    Str += tr("\n") ;
    Str += tr("Run aticonfig manually.") ;
    QMessageBox::information( 0, tr("Error!"), Str, QMessageBox::Ok + QMessageBox::Default) ;
    return;
}


void DualScreenPage::OnApply ( int *Accept )
{
  FGLRXDisplaySettingsRec DisplaySettings;
  char OptionStr[40];
  int i;
  int status;
  pid_t pid;

  if ( !m_Init ) return ;
  if ( !m_Changed ) return ;
  DisplaySettings.Primary = m_Primary;
  DisplaySettings.Desktop = m_Desktop;

  switch ( m_Desktop )
  {
      case 0 : //Disable SecondaryMonitor
          sprintf(OptionStr,"--dtop=single");
          break ;
      case 1 : //Clone Mode
          sprintf(OptionStr,"--dtop=clone");
          break ;
      case 2 : //Extended Desktop Horizontal
          // Reversed?
          if (m_Primary) { 
              sprintf(OptionStr,"--dtop=horizontal,reverse");
          }
          else {
              sprintf(OptionStr,"--dtop=horizontal");
          }
          break ;
      case 3 : //Extended Desktop Vertical
          // Reversed?
          if (m_Primary) { 
              sprintf(OptionStr,"--dtop=vertical,reverse");
          }
          else {
              sprintf(OptionStr,"--dtop=vertical");
          }
          break ;
      default:
          m_Changed = FALSE ;
          *Accept |= APPLY_OK_RESTART ;
          break;
  }

  pid = fork();
  switch(pid)
  {
      case -1: /* error in thread creation */
          AticonfigErrorMsgBox();
          return;
      case  0: /* child thread - execution path */
          /* Run aticonfig */
          execlp("aticonfig", "aticonfig ", OptionStr, NULL);
          exit(1);
          break;

      default : /* main thread - got a valid pid */       
          i = waitpid(pid, &status, 0);
          switch(pid)
          {
              case -1: /* error */
                  AticonfigErrorMsgBox();
                  return;
              case 0: /* WNOHANG - no child available */
                  AticonfigErrorMsgBox();
                  return;
              default : /* pid of queried thread got returned */
                  if ( WIFEXITED(status) )
                  {
                      if( WEXITSTATUS(status)==0 )
                      {
                          break;
                      }
                      else
                      {
                          AticonfigErrorMsgBox();
                          return;
                      }
                  }
                  else
                  {
                          AticonfigErrorMsgBox();
                          return;
                  }
          }
  }

  m_Changed = FALSE ;
  *Accept |= APPLY_OK_RESTART ;
}





