
/*
 * LOGIT.C
 *
 */

#include "defs.h"

Prototype void logit(int priority, const char *ctl, ...);
Prototype void vlogit(int priority, const char *ctl, va_list va);

void
logit(int priority, const char *ctl, ...)
{
    va_list va;

    va_start(va, ctl);
    vlogit(priority, ctl, va);
    va_end(va);
}

void
vlogit(int priority, const char *ctl, va_list va)
{
    vsyslog(priority, ctl, va);

    if (DebugOpt > 1) {
	vprintf(ctl, va);
	printf("\n");
    }
}

