/** 
 *  Yudit Unicode Editor Source File
 *
 *  GNU Copyright (C) 2002  Gaspar Sinai <gsinai@yudit.org>  
 *  GNU Copyright (C) 2001  Gaspar Sinai <gsinai@yudit.org>  
 *  GNU Copyright (C) 2000  Gaspar Sinai <gsinai@yudit.org>  
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License, version 2,
 *  dated June 1991. See file COPYYING for details.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#include <stdio.h>
#include <string.h>
#include <swidget/SFrame.h>
#include <swidget/SLayout.h>
#include <swidget/STextEdit.h>
#include <stoolkit/SEvent.h>
#include <stoolkit/SHashtable.h>
#include <stoolkit/SIO.h>

//static void quicktest();
class WML : public SFrameListener
{
public:
  virtual bool close (SPanel* comp) 
  {
    fprintf (stderr, "Closing window %lx\n", (unsigned long) comp);
    return true;
  };
};

int
main (int argc, char* argv[])
{
  //quicktest();
  //return 0;
  SFontImplVector list;
  /* if you use native fonts you need this */
  //SStringVector ml("kana.ttf,kanjia.ttf,cyberbit.ttf");
  //SStringVector ml("-sony-fixed-medium-r-normal--24-230-75-75-c-120-iso8859-1");
  //SStringVector ml("-*-*-*-*-*--*-*-*-*-*-*-jisx0208.1983-0");
  //SStringVector ml(".ttf,arial.ttf,jisx0208.1983-0,iso8859-1,cyberbit.ttf");
  SFrame *frame = new SFrame();
  SFontImpl::guessPath ();

  SStringVector ml("-gnu-unifont-medium-r-normal--16-160-75-75-c-80-iso10646-1,*-iso8859-1");
  unsigned int h;
  for (h=0; h<ml.size(); h++)
  {
    SFontImpl impl (ml[h], ml[h]);
    list.append (impl);
    SFont::put ("BitMap", list);
  }
  ml = SStringVector("cyberbit.ttf,arial.ttf,msgothic.ttf,gulim.ttf,cyberbit.ttf");
  //ml = SStringVector("cyberbit.ttf");
  list.clear();
  for (h=0; h<ml.size(); h++)
  {
    if (ml[h] == "kanjia.ttf")
    {
      SFontImpl impl (ml[h], "-*-*-*-*-*--*-*-*-*-*-*-iso8859-1");
      list.append (impl);
    }
    else
    {
      SFontImpl impl (ml[h], ml[h]);
      list.append (impl);
    }
    SFont::put ("TrueType", list);
  }

  WML *windowListener = new WML();
  frame->setFrameListener (windowListener);

  //STextEdit *text = new STextEdit ("Gáspár 優子 \nHelloo Belloo Hello,World!\r\n한국ီ日本語ارابغصفoنت ာも出来るよ。");
 // STextEdit *text = new STextEdit ("DOS\r\nUNIX\nMAC\rPS LS ");
  STextEdit *text = 0;
  if (argc == 2)
  {
     SFile f(argv[1]);
     if (f.size() < 0)
     {
      char st[256];
       sprintf (st, "could not open %s", argv[1]);
       text = new STextEdit (st);
     }
     else
     {
       SFileImage im = f.getFileImage();
       SString str (im.array(), f.size());
       SEncoder en;
       text = new STextEdit (en.encode(en.decode(str)));
     }
  }
  else
  {
    text = new STextEdit ();
  }
  STextEdit* field = new STextEdit ();
  //text->setFont ("TrueType", 12.0);
  //field->setFont ("TrueType", 16.0);
  SDimension ps = text->getPreferredSize();
  //printf ("PreferredSize=%d, %d\n", ps.width, ps.height);
  SLocation loc = text->getLocation();
  //printf ("Location=%d, %d\n", loc.x, loc.y);

  //text->resize (SDimension (580,380-field->getPreferredSize().height));
  //text->move (SLocation (loc.x + 10, loc.y + 10));
  //frame->forceLayout (SLayout ( SLocation (0,0), SLocation (590,390)));

  frame->forceLayout (SLayout ( SLocation (0,0), SLocation (300,200)));
       

  SLayout layout(
       SLocation (5, 5), 
       SLocation (295, 195 - field->getPreferredSize().height),
       SLocation (0, 0),
       SLocation (100, 100));

  text->forceLayout (layout);
  field->forceLayout (
    SLayout (
       SLocation (5, 195-field->getPreferredSize().height), 
       SLocation (295, 195),
       SLocation (0, 100),
       SLocation (100, 100)
    )
  );
    
  //field->resize (SDimension(580, field->getPreferredSize().height));
  //field->move (SLocation (loc.x + 10, loc.y + 10 + text->getSize().height));

  SColor c("gray50");
  frame->setBackground (c);
  text->setBackground (c);
  field->setBackground (c);
  text->setTextBackground (SColor("moccasin"));
  //text->setTextBackground (SColor("black"));
  //text->setForeground (SColor("green"), SColor("yellow"));
  //text->setEditor(SEditor("\r\n"));
  field->setTextBackground (SColor("moccasin"));
  //field->setForeground (SColor("green"), SColor("red"));
  //field->setForeground (SColor("green"), SColor("yellow"));
  text->setMultiline (true);
  field->setMultiline (false);
  frame->add (text);
  frame->add (field);
  frame->resize(SDimension(600, 400));
  text->setLineEndMark (true);
  frame->setTitle ("A decent text editor: Yudit");
  frame->show();
  text->setFocus ();
  SEventHandler::start();
  return 0;
}
#if 0
static void quicktest()
{
  SHashtable<SString> h;
  h.put ("One", "1", false);
  h.put ("One", "11", false);
  for (unsigned int i=0; i<h.size(); i++)
  {
    for (unsigned int j=0; j<h.size(i); j++)
    {
      fprintf (stderr, "i=%u j=%u\n", i, j);
      if (h.get (i,j))
      {
         SString key = h.key(i,j);
         SString vle = SString(*h.get(i,j));
         fprintf (stderr, "%*.*s -> %*.*s\n", SSARGS(key), SSARGS(vle));
      }
    }
  }
}
#endif
