#include <stdio.h>
#include <windows.h>
#include <commctrl.h>
#include "resource.h"

#define MAXTIME 30
#define MAXCOUNT 100

HINSTANCE hInst;
int sound_state = 1;
char sound_filename[256] = "se1.wav";
int message_open = 1;
int message_close = 1;
int message_disp = 5;
int max_message_count = 50;

BOOL reg_read_option();
void remove_message(int num);

int get_sound_state()
{
	return sound_state;
}

void set_sound_state(int ss)
{
	sound_state = ss;
	return;
}

void get_sound_filename(char *filename)
{
	strcpy(filename, sound_filename);
	return;
}

void set_sound_filename(char *filename)
{
    strcpy(sound_filename, filename);
	return;
}

int get_message_open()
{
	return message_open;
}

void set_message_open(int value)
{
    message_open = value;
	return;
}

int get_message_close()
{
	return message_close;
}

void set_message_close(int value)
{
    message_close = value;
	return;
}

int get_message_disp_seconds()
{
	return message_disp;
}

void set_message_disp_seconds(int value)
{
	message_disp = value;
	return;
}

int get_max_message_count()
{
	return max_message_count;
}

void set_max_message_count(int value)
{
	max_message_count = value;
	return;
}

void w_youbin_init_option(HINSTANCE hInstance)
{
	hInst = hInstance;
	reg_read_option();
}

static void change_state_sound(HWND hdwnd, int i)
{
	HWND hdcwnd;

	hdcwnd=GetDlgItem(hdwnd,IDC3_STX_FILENAME);
	EnableWindow(hdcwnd,i);
	hdcwnd=GetDlgItem(hdwnd,IDC3_EBX_FILENAME);
	EnableWindow(hdcwnd,i);
	hdcwnd=GetDlgItem(hdwnd,IDC3_BTN_REFERENCE);
	EnableWindow(hdcwnd,i);
}

static void change_state_disp_seconds(HWND hdwnd, int i)
{
	HWND hdcwnd;

	hdcwnd=GetDlgItem(hdwnd,IDC3_STX_DISP_SECONDS);
	EnableWindow(hdcwnd,i);
	hdcwnd=GetDlgItem(hdwnd,IDC3_EBX_DISP_SECONDS);
	EnableWindow(hdcwnd,i);
	hdcwnd=GetDlgItem(hdwnd,IDC3_SPN_DISP_SECONDS);
	EnableWindow(hdcwnd,i);
}

static void change_state_message_close(HWND hdwnd, int i)
{
	HWND hdcwnd;

	hdcwnd=GetDlgItem(hdwnd,IDC3_CBX_MESSAGE_CLOSE);
	EnableWindow(hdcwnd,i);
	hdcwnd=GetDlgItem(hdwnd,IDC3_STX_MAX_MESSAGE_NUM);
	EnableWindow(hdcwnd,i);
	hdcwnd=GetDlgItem(hdwnd,IDC3_EBX_MAX_MESSAGE_NUM);
	EnableWindow(hdcwnd,i);
	hdcwnd=GetDlgItem(hdwnd,IDC3_SPN_MAX_MESSAGE_NUM);
	EnableWindow(hdcwnd,i);

	if(i == 1)
		i = (int)SendDlgItemMessage(hdwnd, IDC3_CBX_MESSAGE_CLOSE,
					BM_GETCHECK, 0, 0);
	change_state_disp_seconds(hdwnd, i);
}

static void init_dialog_func_message_option(HWND hdwnd)
{
	/* ̲ */
	SetDlgItemText(hdwnd, IDC3_EBX_FILENAME, sound_filename);
	if(sound_state) SendDlgItemMessage(hdwnd,IDC3_CBX_SOUND,BM_SETCHECK,1,0);
	change_state_sound(hdwnd, sound_state);
	/* å */
	if(message_open)  SendDlgItemMessage(hdwnd,IDC3_CBX_MESSAGE_OPEN,BM_SETCHECK,1,0);
	if(message_close) SendDlgItemMessage(hdwnd,IDC3_CBX_MESSAGE_CLOSE,BM_SETCHECK,1,0);
	change_state_message_close(hdwnd, message_open);
}

static void get_option_data(HWND hdwnd)
{
	int value;

	/* sound_state */
	value = (int)SendDlgItemMessage(hdwnd, IDC3_CBX_SOUND, BM_GETCHECK, 0, 0);
	sound_state = value;
	/* sound_filename */
	GetDlgItemText(hdwnd, IDC3_EBX_FILENAME, sound_filename, 256);

	/* message_open */
	value = (int)SendDlgItemMessage(hdwnd, IDC3_CBX_MESSAGE_OPEN, BM_GETCHECK, 0, 0);
	message_open = value;
	/* message_close */
	value = (int)SendDlgItemMessage(hdwnd, IDC3_CBX_MESSAGE_CLOSE, BM_GETCHECK, 0, 0);
	message_close = value;
	/* message_disp */
	value = GetDlgItemInt(hdwnd, IDC3_EBX_DISP_SECONDS, NULL, 1);
	if(value) message_disp = value;
	/* max_message_count */
    value = GetDlgItemInt(hdwnd, IDC3_EBX_MAX_MESSAGE_NUM, NULL, 1);
	if(value){
	if(max_message_count > value)
	    remove_message(value);
		max_message_count = value;
	}
}

BOOL CALLBACK dialog_func_message_option(HWND hdwnd,
		UINT message, WPARAM wParam, LPARAM lParam)
{
	int i;
	HWND hebxwnd, hudwnd;
	OPENFILENAME filename;
	char s_filename[64]="";
	char full_filename[256]="";
	char filefilter[] = {'W','A','V','E','\0','*','w','a','v','\0','\0','\0'};

	switch(message){
	case WM_INITDIALOG:
		hebxwnd = GetDlgItem(hdwnd, IDC3_EBX_DISP_SECONDS);
		hudwnd = CreateUpDownControl(
				     WS_CHILD | WS_BORDER | WS_VISIBLE |
					 UDS_SETBUDDYINT | UDS_ALIGNRIGHT,
					 10, 10, 50, 50,
					 hdwnd,
					 IDC3_SPN_DISP_SECONDS,
					 hInst,
					 hebxwnd,
					 MAXTIME, 1, message_disp);
		hebxwnd = GetDlgItem(hdwnd, IDC3_EBX_MAX_MESSAGE_NUM);
		hudwnd = CreateUpDownControl(
				     WS_CHILD | WS_BORDER | WS_VISIBLE |
					 UDS_SETBUDDYINT | UDS_ALIGNRIGHT,
					 10, 10, 50, 50,
					 hdwnd,
					 IDC3_SPN_MAX_MESSAGE_NUM,
					 hInst,
					 hebxwnd,
					 MAXCOUNT, 1, max_message_count);
		init_dialog_func_message_option(hdwnd);
		return 1;
	case WM_COMMAND:
		switch(LOWORD(wParam)){
		case IDC3_BTN_OK:
			get_option_data(hdwnd);
			EndDialog(hdwnd, 1);
			return 1;
		case IDC3_BTN_CANCEL:
			EndDialog(hdwnd, 1);
			return 1;
		case IDC3_BTN_ADAPT:
			get_option_data(hdwnd);
			return 1;
		case IDC3_CBX_SOUND:
			i = (int)SendDlgItemMessage(hdwnd, IDC3_CBX_SOUND,
						BM_GETCHECK, 0, 0);
			change_state_sound(hdwnd, i);
			return 1;
		case IDC3_BTN_REFERENCE:
			memset(&filename, 0, sizeof(OPENFILENAME));
			filename.lStructSize = sizeof(OPENFILENAME);
			filename.hwndOwner = hdwnd;
			filename.lpstrFilter = filefilter;
			filename.nFilterIndex = 1;
			filename.lpstrFile = full_filename;
			filename.nMaxFile = sizeof(full_filename);
			filename.lpstrFileTitle = s_filename;
			filename.nMaxFileTitle = sizeof(s_filename) - 1;
			filename.Flags = OFN_FILEMUSTEXIST | OFN_PATHMUSTEXIST | OFN_HIDEREADONLY;
			if(GetOpenFileName(&filename)){
				SetDlgItemText(hdwnd, IDC3_EBX_FILENAME, full_filename);
			}
			return 1;
		case IDC3_CBX_MESSAGE_OPEN:
			i = (int)SendDlgItemMessage(hdwnd, IDC3_CBX_MESSAGE_OPEN,
						BM_GETCHECK, 0, 0);
			change_state_message_close(hdwnd, i);
			return 1;
		case IDC3_CBX_MESSAGE_CLOSE:
			i = (int)SendDlgItemMessage(hdwnd, IDC3_CBX_MESSAGE_CLOSE,
						BM_GETCHECK, 0, 0);
			change_state_disp_seconds(hdwnd, i);
			return 1;
		}
	}
	return 0;
}
