#ifndef YNET_H
#define YNET_H

#include <sys/types.h>
#include "ytypes.h"
#include "ysound.h"
#include "playstack.h"

/*
 *      Standard inputs and protocol for inputs of all YNetParse*()
 *      functions:
 */
#define YCNP_STD_INPUTS_PROTO \
	YConnectionNumber con_num, \
	const u_int8_t *buf, \
	u_int32_t chunk_length, \
	u_int16_t major_op_code, \
	u_int16_t minor_op_code

#define YCNP_STD_INPUTS \
	con_num, \
	buf, \
	chunk_length, \
	major_op_code, \
	minor_op_code


/*
 *	Functions:
 */
extern int YNetSendAudioChangePreset(
	YConnectionNumber con_num,
	const char *audio_mode_name
);
extern int YNetSendAudioChangeValues(
	YConnectionNumber con_num,
	int sample_size,
	int channels,
	YDataLength sample_rate,
	int direction,
	int allow_fragmenting,
	int num_fragments,
	int fragment_size
);
extern int YNetParseAudioChange(YCNP_STD_INPUTS_PROTO);

extern int YNetSendServerStats(
	YConnectionNumber con_num,
	int protocol_version_major,
	int protocol_version_minor,
	Coefficient cycle_load,
	unsigned long start_time,
	const char *vendor_name,
	const char *server_name,
	const char *sound_name
);
extern int YNetParseServerStats(YCNP_STD_INPUTS_PROTO);

extern int YNetSendCycleChange(YConnectionNumber con_num, long cycle_us);
extern int YNetParseCycleChange(YCNP_STD_INPUTS_PROTO);

extern int YNetSendDisconnect(YConnectionNumber con_num, u_int16_t reason);
extern int YNetParseDisconnect(YCNP_STD_INPUTS_PROTO);

extern int YNetSendSetHost(
	YConnectionNumber con_num,
	u_int16_t minor_op_code,
	const YIPUnion *ip
);
extern int YNetParseSetHost(YCNP_STD_INPUTS_PROTO);

extern int YNetSendSetMixerDevice(
	YConnectionNumber con_num,
	int mixer_code,
	Coefficient value1, Coefficient value2,
	Coefficient value3, Coefficient value4
);
extern int YNetParseMixerDevice(YCNP_STD_INPUTS_PROTO);

extern int YNetSendSoundObjectPlay(
	YConnectionNumber con_num, YID yid,
	YDataPosition position, YDataLength length,
	int repeats, int total_repeats,
	YVolumeStruct *volume,
	int sample_rate
);
extern int YNetParseSoundObjectPlay(YCNP_STD_INPUTS_PROTO);

extern int YNetSendSoundObjectKill(YConnectionNumber con_num, YID yid);
extern int YNetParseSoundObjectKill(YCNP_STD_INPUTS_PROTO);

extern int YNetSendSoundObjectAttributes(
	YConnectionNumber con_num,
	const char *path,
	int format, 
	int sample_size,
	int channels,
	int sample_rate,
	YDataLength length
);
extern int YNetParseSoundObjectAttributes(YCNP_STD_INPUTS_PROTO);

extern int YNetSendShutdown(YConnectionNumber con_num, u_int16_t reason);
extern int YNetParseShutdown(YCNP_STD_INPUTS_PROTO);

extern int YNetSendSync(YConnectionNumber con_num, long us);
extern int YNetParseSync(YCNP_STD_INPUTS_PROTO);

extern int YNetSendAudioStats(
	YConnectionNumber con_num,
	Audio *audio
);
extern int YNetParseAudioStats(YCNP_STD_INPUTS_PROTO);

extern int YNetSendListAudioModes(
	YConnectionNumber con_num,
	const char *audio_mode_name,
	int sample_rate, int channels,
	int sample_size, int fragment_size_bytes,
	char direction, char allow_fragmenting, int num_fragments
);
extern int YNetParseListAudioModes(YCNP_STD_INPUTS_PROTO);

extern int YNetSendPlaySoundObjectValues(
	YConnectionNumber con_num,
	PlayStack *ps_ptr
);
extern int YNetParsePlaySoundObjectValues(YCNP_STD_INPUTS_PROTO);

extern int YNetSendClientMessage(
	YConnectionNumber con_num, int format, int type,
	const char *message, YDataLength length
);
extern int YNetParseClientMessage(YCNP_STD_INPUTS_PROTO);

extern int YNetSendYSHMSoundOpen(
	YConnectionNumber con_num, int yshm_id
);
extern int YNetSendYSHMSoundClose(
	YConnectionNumber con_num, int yshm_id
);
extern int YNetParseYSHMSoundOpen(YCNP_STD_INPUTS_PROTO);
extern void YNetDoNotifyAllYSHMSoundClose(void);

extern int YNetSendListAudioCDTracks(
	YConnectionNumber con_num,
	int track_number,
	unsigned long track_start_time,
	unsigned long track_length,
	const char *track_name
);
extern int YNetParseListAudioCDTracks(YCNP_STD_INPUTS_PROTO);


extern int YNetRecv(YConnectionNumber con_num);


#endif	/* YNET_H */
