/*
                           Comfermation Dialog
 */

#ifndef CDIALOG_H
#define CDIALOG_H

#include <sys/types.h>

#include <gtk/gtk.h>
#include "guiutils.h"

#ifndef gbool
# define gbool	guchar
#endif


/*
 *	Message icon codes, specifies the icon displayed next to
 *	the message:
 */
#define CDIALOG_ICON_INFO	0
#define CDIALOG_ICON_WARNING    1
#define CDIALOG_ICON_ERROR	2
#define CDIALOG_ICON_QUESTION	3


/*
 *	Response codes:
 */
#define CDIALOG_RESPONSE_NOT_AVAILABLE	-1
#define CDIALOG_RESPONSE_NO		0
#define CDIALOG_RESPONSE_YES		1
#define CDIALOG_RESPONSE_YES_TO_ALL	2
#define CDIALOG_RESPONSE_CANCEL		3
#define CDIALOG_RESPONSE_OK		4
#define CDIALOG_RESPONSE_HELP		5


/*
 *	Button flags:
 */
#define CDIALOG_BTNFLAG_OK		(1 << 0)
#define CDIALOG_BTNFLAG_YES		(1 << 1)
#define CDIALOG_BTNFLAG_YES_TO_ALL	(1 << 2)
#define CDIALOG_BTNFLAG_NO		(1 << 3)
#define CDIALOG_BTNFLAG_CANCEL		(1 << 4)
#define CDIALOG_BTNFLAG_IGNORE		(1 << 5)
#define CDIALOG_BTNFLAG_RETRY		(1 << 6)
#define CDIALOG_BTNFLAG_ABORT		(1 << 7)
#define CDIALOG_BTNFLAG_HELP		(1 << 8)



typedef struct {

	gbool initialized;
	gbool map_state;

	gint last_icon_code;

	GtkWidget	*toplevel,
			*main_vbox,
			*label_hbox,
			*icon_pm,
			*icon_fixed,
			*label,
			*help_vbox,
			*help_icon_pm,
			*help_icon_fixed,
			*help_label,
			*button_hbox;

	GtkWidget	*ok_btn,
			*yes_btn,
			*yes_to_all_btn,
			*no_btn,
			*cancel_btn,
			*ignore_btn,
			*retry_btn,
			*abort_btn,
			*help_btn;

} cdialog_struct;



extern int CDialogInit(void);
extern void CDialogSetTransientFor(GtkWidget *w);
extern gbool CDialogIsQuery(void);
extern void CDialogBreakQuery(void);
extern int CDialogGetResponse(
	const char *title,
	const char *message,
	const char *explaination,
	int icon_code,
	unsigned int show_buttons,
	unsigned int default_button
);
extern void CDialogMap(cdialog_struct *d);
extern void CDialogUnmap(cdialog_struct *d);
extern void CDialogShutdown(void);


#endif	/* CDIALOG_H */
