#include <uc++/plugin.h>

#include "guile-script.h"
#include "guile-loader.h"

#ifdef SIGC_CXX_NAMESPACES
using namespace std;
using namespace SigC;
using namespace SigC::Threads;
#endif

namespace uC
{

namespace Script
{

class GuilePlugin : public Plugin,
		    public SigC::Threads::Thread, 
		    public SigC::StandardDispatcher
{
  public:
    GuilePlugin(PluginManager *mgr);
    virtual ~GuilePlugin();
    virtual std::string name() const { return "guile"; }
    virtual std::string description() const { return "Guile support"; }
    Language& language() { return *lang_; }

    // thread main routine
    virtual void *main(void *arg);
  private:
    Language *lang_;
    Script::guileObjectFactory obj_factory_;
    Script::guileObject root_ns_;
    ThreadTunnel tunnel_;
};



GuilePlugin::GuilePlugin(PluginManager *mgr)
  : Plugin(mgr), root_ns_(obj_factory_), tunnel_(this)
{
  lang_ = manage(new Language(root_ns_.namespace_interface(), 
			      obj_factory_, &tunnel_));
}


GuilePlugin::~GuilePlugin()
{
  //manager()->unregister_language("guile");
}

static void main_prog(int argc, char *argv[])
{
  GuilePlugin *gplug = (GuilePlugin *)argv[0];
  
  gplug->run();
}

void *GuilePlugin::main(void *arg)
{
  char *argv[2];

  argv[0] = (char *)this;
  argv[1] = 0;
  
  gh_enter(1, argv, main_prog);

  return arg;
}

} // Script

} // uC

extern "C" uC::Plugin *ucxx_guile_plugin_init(uC::PluginManager *mgr)
{
  try
  {
    uC::Script::GuilePlugin *plugin = 
      SigC::manage(new uC::Script::GuilePlugin(mgr));
    
    plugin->start();
    
    mgr->load_plugin("ucxx"); // We need to pre-load this
    mgr->register_language("guile", plugin->language());
    mgr->register_plugin_loader(manage(new uC::guilePluginLoader(mgr)));
    
    return(plugin);
  }
  catch (...)
  {
    mgr->set_error("GuilePlugin initialisation failed");
    return 0;
  }
}
