
/*
 * Copyright (C) 2004-2005 Maximilian Schwerin
 *
 * This file is part of oxine a free media player.
 * Most of this file was copied from the xine-ui project.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * $Id: weather.h 2392 2007-06-30 11:06:30Z mschwerin $
 *
 */

#ifndef HAVE_WEATHER_H
#define HAVE_WEATHER_H

#ifdef HAVE_WEATHER

#include "list.h"


typedef struct {
    int length;
    char **names;
    char **values;

    char *station_id;
    char *station_name;

    char *update_time;
    char *icon_name;

    time_t retrieval_time;
} weather_t;


typedef struct {
    /// Linked list containing the weather stations.
    l_list_t *stations;

    /// Name of this country.
    char *name;

    /// Index of last station visible in list.
    int last_station_i;
} weather_country_t;


typedef struct {
    /// Name of this weather station.
    char *name;

    /// ID of this weather station.
    char *id;

    /// The country this station is in.
    weather_country_t *country;
} weather_station_t;

weather_t *get_current_weather (const char *station_id);
void weather_free (weather_t * weather);

bool start_weather_thread (void);
void stop_weather_thread (void);

void weather_locations_init (void);
void weather_locations_free (void);

weather_country_t *weather_country_get_first (void);
weather_country_t *weather_country_get_next (weather_country_t * c);

#endif /* HAVE_WEATHER */
#endif /* HAVE_WEATHER_H */
