
/*
 * Copyright (C) 2006 Maximilian Schwerin
 *
 * This file is part of oxine a free media player.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * $Id: shoutcast.h 2298 2007-06-25 13:44:36Z mschwerin $
 *
 */

#ifndef HAVE_SHOUTCAST_H
#define HAVE_SHOUTCAST_H
#ifdef __cplusplus
extern "C" {
#endif

#include "filelist.h"

#ifdef HAVE_SHOUTCAST

/// This contains additional information about a shoutcast station.
typedef struct {
    /// The bitrate.
    int bitrate;
    /// the genre.
    char *genre;
} shoutcast_station_t;


/// Reads the shoutcast stations into a filelist.
void shoutcast_stationlist_read (filelist_t *filelist);


/// Reads the specified station.
void shoutcast_station_read (filelist_t *filelist);


#endif /* HAVE_SHOUTCAST */

#ifdef __cplusplus
}
#endif
#endif /* HAVE_SHOUTCAST_H */
