
/*
 * Copyright (C) 2004-2005 Maximilian Schwerin
 *
 * This file is part of oxine a free media player.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * $Id: odk_event.h 2393 2007-06-30 16:24:23Z mschwerin $
 *
 */

#ifndef HAVE_ODK_EVENT_H
#define HAVE_ODK_EVENT_H

#include "event.h"

/// Priorities of ODK event handlers.
typedef enum {
    /// Low priority
    EVENT_HANDLER_PRIORITY_LOW,
    /// Normal priority
    EVENT_HANDLER_PRIORITY_NORMAL,
    /// High priority
    EVENT_HANDLER_PRIORITY_HIGH
} odk_event_handler_priority_t;


/// Enter the ODK event loop.
void odk_run (odk_t * odk);


/// Exit the ODK event loop.
void odk_exit (odk_t * odk);


/// Tell ODK to listen to the plugin specified by the ID.
void odk_listen_to (odk_t * odk, const char *id);


/// Add the specified event handler.
void odk_add_event_handler (odk_t * odk, event_handler_t eh, void *data,
                            odk_event_handler_priority_t priority);


/// Remove the specified event handler.
void odk_del_event_handler (odk_t * odk, event_handler_t eh);


/// Sends an event to the registered event handler.
void odk_oxine_event_send (odk_t * odk, oxine_event_t * event);


/**
 * Send an event to the xine engine.
 *
 * @param odk                   The ODK data structure.
 * @param force                 Force sending of the event.
 * @param type                  The type of the event to send.
 */
void odk_xine_event_send (odk_t * odk, bool force, int type);


/// Are we forwarding events to the xine engine.
bool odk_get_forward_events_to_xine (odk_t * odk);


/// Are we to forward events to the xine engine.
void odk_set_forward_events_to_xine (odk_t * odk, bool forward);

#endif /* HAVE_ODK_EVENT_H */
