
/*
 * Copyright (C) 2002-2003 Stefan Holst
 * Copyright (C) 2004-2005 Maximilian Schwerin
 *
 * This file is part of oxine a free media player.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * $Id: heap.h,v 1.3 2005/09/30 07:31:25 mschwerin Exp $
 */

#ifndef HAVE_HEAP_H
#define HAVE_HEAP_H

#include <string.h>
#include <stdlib.h>
#include <sys/types.h>

#ifdef USE_OXINE_HEAP_MANAGEMENT

/* semipublic functions*/
void *_gen_malloc (size_t, const char *, char *, int);
void *_gen_free (void *);
void *_gen_realloc (void *, size_t, char *, int);
void *_gen_strdup (const char *, char *, int);

void heapstat (void);

#define ho_malloc(size)             (_gen_malloc((size_t)size,NULL,__FILE__,__LINE__))
#define ho_realloc(hObj, size)      (_gen_realloc((hObj), (size_t)(size),__FILE__,__LINE__))
#define ho_free(hObj)               (_gen_free(hObj))

#define ho_new(type)                (_gen_malloc(sizeof(type),NULL,__FILE__,__LINE__))
#define ho_strdup(lpSrc)            (_gen_strdup(lpSrc,__FILE__,__LINE__))

#else

void *_gen_malloc (size_t);
void *_gen_free (void *);

void heapstat (void);

#define ho_malloc(size)             (_gen_malloc ((size_t)size))
#define ho_realloc(ptr, size)       (realloc (ptr, (size_t)size))
#define ho_free(ptr)                (_gen_free (ptr))

#define ho_new(type)                (_gen_malloc ((size_t)sizeof(type)))
#define ho_strdup(ptr)              (strdup (ptr))

#endif

#endif
