--
-- PostgreSQL database dump
--

SET client_encoding = 'UTF8';
SET standard_conforming_strings = off;
SET check_function_bodies = false;
SET client_min_messages = warning;
SET escape_string_warning = off;

SET search_path = public, pg_catalog;

SET default_tablespace = '';

SET default_with_oids = false;

--
-- Name: country_name; Type: TABLE; Schema: public; Owner: twain; Tablespace: 
--

CREATE TABLE country_name (
    country_code character varying(2),
    name keyvalue[],
    country_default_language_code character varying(2)
);


ALTER TABLE public.country_name OWNER TO twain;

--
-- Data for Name: country_name; Type: TABLE DATA; Schema: public; Owner: twain
--

COPY country_name (country_code, name, country_default_language_code) FROM stdin;
gb	{"(official_name:sv,\\"Förenade konungariket Storbritannien och Nordirland\\")","(official_name:sl,\\"Združeno kraljestvo Velike Britanije in Severne Irske\\")","(official_name:sk,\\"Spojené kráľovstvo Veľkej Británie a Severného Írska\\")","(official_name:ru,\\"Соединенное Королевство Великобритании и Северной Ирландии\\")","(official_name:pt,\\"Reino Unido da Grã-Bretanha e Irlanda do Norte\\")","(official_name:pl,\\"Zjednoczone Królestwo Wielkiej Brytanii\\")","(official_name:lb,\\"Vereenegt Kinnekräich vu Groussbritannien an Nordirland\\")","(official_name:ja,グレートブリテン及び北アイルランド連合王国)","(official_name:id,\\"Perserikatan Kerajaan Britania Raya dan Irlandia Utara\\")","(official_name:fr,\\"Royaume-Uni de Grande-Bretagne et d'Irlande du Nord\\")","(official_name:et,\\"Suurbritannia ja Põhja-Iiri Ühendkuningriik\\")","(official_name:es,\\"Reino Unido de Gran Bretaña\\")","(official_name:el,\\"Ηνωμένο Βασίλειο της Μεγάλης Βρετανίας και της Βορείου Ιρλανδίας\\")","(official_name:br,\\"Rouantelezh Unanet Breizh-Veur ha Norzhiwerzhon\\")","(official_name:be,\\"Злучанае Каралеўства Вялікабрытаніі і Паўночнай Ірландыі\\")","(official_name,\\"United Kingdom of Great Britain and Northern Ireland\\")","(name:zh_pyt,Yīngguó)","(name:zh_py,Yingguo)","(name:zh,英国)","(name:vi,\\"Liên hiệp Vương quốc Anh và Bắc Ireland\\")","(name:uk,Великобританія)","(name:tr,\\"Birleşik Krallık\\")","(name:th,สหราชอาณาจักร)","(name:sv,Storbritannien)","(name:sl,\\"Velika Britanija\\")","(name:sk,\\"Spojené kráľovstvo\\")","(name:ru,\\"Соединенное Королевство\\")","(name:pt,\\"Reino Unido\\")","(name:pl,\\"Wielka Brytania\\")","(name:no,Storbritania)","(name:nl,\\"Verenigd Koninkrijk\\")","(name:nds,\\"Vereenigd Königriek\\")","(name:mn,\\"Нэгдсэн Вант Улс\\")","(name:lt,\\"Jungtinė Karalystė\\")","(name:li,\\"Vereineg Keuninkriek\\")","(name:lb,\\"Groussbritannien an Nordirland\\")","(name:la,\\"Britanniarum Regnum\\")","(name:ja,イギリス)","(name:it,\\"Gran Bretagna\\")","(name:is,Bretland)","(name:id,\\"Britania Raya\\")","(name:hy,\\"Միացյալ Թագավորություն\\")","(name:hu,Nagy-Britannia)","(name:hr,\\"Velika Britanija\\")","(name:he,בריטניה)","(name:gv,\\"Reeriaght Unnaneysit\\")","(name:gd,\\"An Rìoghachd Aonaichte\\")","(name:ga,\\"An Ríocht Aontaithe\\")","(name:fy,Grut-Brittanje)","(name:fr,Royaume-Uni)","(name:fi,\\"Yhdistynyt kuningaskunta\\")","(name:fa,بریتانیا)","(name:et,Suurbritannia)","(name:es,\\"Gran Bretaña\\")","(name:eo,\\"Unuiĝinta Reĝlando\\")","(name:el,\\"Ηνωμένο Βασίλειο\\")","(name:de,\\"Vereinigtes Königreich\\")","(name:da,Storbritannien)","(name:cy,\\"Y Deyrnas Unedig\\")","(name:ca,\\"Regne Unit\\")","(name:br,\\"Rouantelezh Unanet\\")","(name:be,Вялікабрытанія)","(name:ar,\\"المملكة المتحدة\\")","(name:af,\\"Verenigde Koninkryk\\")","(name,\\"United Kingdom\\")","(alt_name,\\"United Kingdom; UK; Britain; Great Britain\\")"}	en
us	{"(official_name:vi,\\"Hợp chúng quốc Hoa Kỳ\\")","(official_name:sv,\\"Amerikas förenta stater\\")","(official_name:pt,\\"Estados Unidos da América\\")","(official_name:fr,\\"États-Unis d'Amérique\\")","(name:zh_pyt,Měiguó)","(name:zh_py,Meiguo)","(name:zh,美国)","(name:vi,\\"Hoa Kỳ\\")","(name:uk,\\"Сполучені Штати Америки\\")","(name:tr,\\"Amerika Birleşik Devletleri\\")","(name:th,สหรัฐอเมริกา)","(name:sv,USA)","(name:sl,\\"Združene države Amerike\\")","(name:ru,\\"Соединённые Штаты Америки\\")","(name:pt,\\"Estados Unidos\\")","(name:pl,\\"Stany Zjednoczone Ameryki\\")","(name:no,USA)","(name:nn,USA)","(name:nl,\\"Verenigde Staten van Amerika\\")","(name:nb,USA)","(name:mn,\\"Америкийн Нэгдсэн Улс\\")","(name:lt,\\"Jungtinės Amerikos Valstijos\\")","(name:li,\\"Vereinegde State van Amerika\\")","(name:lb,\\"Vereenegt Staate vun Amerika\\")","(name:la,\\"Civitates Foederatae Americae\\")","(name:ja,アメリカ合衆国)","(name:it,\\"Stati Uniti d'America\\")","(name:is,Bandaríkin)","(name:id,\\"Amerika Serikat\\")","(name:hy,\\"Ամերիկայի Միացյալ Նահանգներ\\")","(name:hu,\\"Amerikai Egyesült Államok\\")","(name:hr,\\"Sjedinjene Američke Države\\")","(name:he,\\"ארצות הברית של אמריקה\\")","(name:gd,\\"Na Stàitean Aonaichte\\")","(name:ga,\\"Stáit Aontaithe Mheiriceá\\")","(name:fy,\\"de Feriene Steaten fan Amearika\\")","(name:fr,États-Unis)","(name:fi,Yhdysvallat)","(name:fa,\\"ایالات متحده آمریکا\\")","(name:et,\\"Ameerika Ühendriigid\\")","(name:es,\\"Estados Unidos\\")","(name:eo,Usono)","(name:en,\\"United States of America\\")","(name:el,\\"Ηνωμένες Πολιτείες της Αμερικής\\")","(name:de,\\"Vereinigte Staaten von Amerika\\")","(name:da,USA)","(name:cy,\\"Unol Daleithiau America\\")","(name:ca,\\"Estats Units d'Amèrica\\")","(name:br,\\"Stadoù Unanet Amerika\\")","(name:be,\\"Злучаныя Штаты Амерыкі\\")","(name:ar,\\"الولايات المتحدة الأمريكية\\")","(name:af,\\"Verenigde State van Amerika\\")","(name,\\"United States of America\\")","(alt_name,\\"USA;US;The States\\")"}	en
de	{"(official_name:vi,\\"Cộng hoà Liên bang Đức\\")","(official_name:sv,\\"Förbundsrepubliken Tyskland\\")","(official_name:sk,\\"Nemecká spolková republika\\")","(official_name:pt,\\"República Federal da Alemanha\\")","(official_name:lt,\\"Vokietijos Federacinė Respublika\\")","(official_name:lb,\\"Bundesrepublik Däitschland\\")","(official_name:it,\\"Repubblica Federale Tedesca\\")","(official_name:id,\\"Republik Federal Jerman\\")","(official_name:gd,\\"Poblachd Caidreachail na Gearmailt\\")","(official_name:fr,\\"République fédérale d'Allemagne\\")","(official_name:el,\\"Ομοσπονδιακή Δημοκρατία της Γερμανίας\\")","(name:zh_pyt,Déguó)","(name:zh_py,Deguo)","(name:zh,德国)","(name:vls,Duutsland)","(name:vi,Đức)","(name:uk,Німеччина)","(name:tr,Almanya)","(name:th,ประเทศเยอรมนี)","(name:sv,Tyskland)","(name:sl,Nemčija)","(name:sk,Nemecko)","(name:ru,Германия)","(name:pt,Alemanha)","(name:pl,Niemcy)","(name:nl,Duitsland)","(name:nds,Düütschland)","(name:mn,Герман)","(name:lv,Vācija)","(name:lt,Vokietija)","(name:li,Duutsland)","(name:lb,Däitschland)","(name:la,Germania)","(name:ko,독일)","(name:ka,გერმანია)","(name:ja,ドイツ)","(name:it,Germania)","(name:is,Þýskaland)","(name:id,Jerman)","(name:hy,Գերմանիա)","(name:hu,Németország)","(name:hr,Njemačka)","(name:he,גרמניה)","(name:haw,Kelemānia)","(name:gd,\\"A' Ghearmailt\\")","(name:ga,\\"An Ghearmáin\\")","(name:fy,Dútslân)","(name:fr,Allemagne)","(name:fi,Saksa)","(name:fa,آلمان)","(name:eu,Alemania)","(name:et,Saksamaa)","(name:es,Alemania)","(name:eo,Germanio)","(name:en,Germany)","(name:el,Γερμανία)","(name:da,Tyskland)","(name:cy,\\"Yr Almaen\\")","(name:ca,Alemanya)","(name:br,Alamagn)","(name:bg,Германия)","(name:be,Германія)","(name:az,Almaniya)","(name:ar,ألمانيا)","(name:af,Duitsland)","(name,Deutschland)"}	de
fr	{"(official_name:vi,\\"Cộng hòa Pháp\\")","(official_name:sv,\\"Republiken Frankrike\\")","(official_name:sk,\\"Francúzska republika\\")","(official_name:pt,\\"República Francesa\\")","(official_name:lt,\\"Prancūzijos Respublika\\")","(official_name:lb,\\"Franséisch Republik\\")","(official_name:id,\\"Republik Perancis\\")","(official_name:gd,\\"Poblachd na Frainge\\")","(official_name:et,\\"Prantsuse Vabariik\\")","(official_name:el,\\"Γαλλική Δημοκρατία\\")","(official_name:be,\\"Французская Рэспубліка\\")","(official_name,\\"République française\\")","(name:zh_pyt,Fǎguó)","(name:zh_py,Faguo)","(name:zh,法国)","(name:vi,Pháp)","(name:uk,Франція)","(name:tr,Fransa)","(name:th,ประเทศฝรั่งเศส)","(name:sv,Frankrike)","(name:sl,Francija)","(name:sk,Francúzsko)","(name:ru,Франция)","(name:pt,França)","(name:pl,Francja)","(name:nl,Frankrijk)","(name:nds,Frankriek)","(name:mn,Франц)","(name:lv,Francija)","(name:lt,Prancūzija)","(name:li,Frankriek)","(name:lb,Frankräich)","(name:la,Francia)","(name:ko,프랑스)","(name:ka,საფრანგეთი)","(name:ja,フランス)","(name:it,Francia)","(name:is,Frakkland)","(name:id,Perancis)","(name:hy,Ֆրանսիա)","(name:hu,Franciaország)","(name:hr,Francuska)","(name:he,צרפת)","(name:haw,Palani)","(name:gv,\\"Yn Rank\\")","(name:gd,\\"An Fhraing\\")","(name:ga,\\"An Fhrainc\\")","(name:fy,Frankryk)","(name:fr,France)","(name:fi,Ranska)","(name:fa,فرانسه)","(name:et,Prantsusmaa)","(name:es,Francia)","(name:eo,Francio)","(name:en,France)","(name:el,Γαλλία)","(name:de,Frankreich)","(name:da,Frankrig)","(name:cy,Ffrainc)","(name:ca,França)","(name:br,Frañs)","(name:bg,Франция)","(name:be,Францыя)","(name:az,Fransa)","(name:ar,فرنسا)","(name:af,Frankryk)","(name,France)"}	fr
ch	{"(official_name:vi,\\"Liên bang Thụy Sĩ\\")","(official_name:sv,\\"Schweiziska edsförbundet\\")","(official_name:sk,\\"Švajčiarska konfederácia\\")","(official_name:rm,\\"Confederaziun svizra\\")","(official_name:lb,\\"Schwäizeresch Eidgenossenschaft\\")","(official_name:la,\\"Confoederatio Helvetica\\")","(official_name:ja,スイス連邦)","(official_name:it,\\"Confederazione Svizzera\\")","(official_name:id,\\"Konfederasi Swiss\\")","(official_name:fr,\\"Confédération suisse\\")","(official_name:en,\\"Swiss Confederation\\")","(official_name:el,\\"Ελβετική Συνομοσπονδία\\")","(official_name:de,\\"Schweizerische Eidgenossenschaft\\")","(name:zh-yue,瑞士)","(name:zh_pyt,Ruìshì)","(name:zh_py,Ruishi)","(name:zh-min-nan,Sūi-se)","(name:zh-classical,瑞士)","(name:zh,瑞士)","(name:zea,Zwitserland)","(name:yi,שווייץ)","(name:xal,\\"Свисн Һазр\\")","(name:wuu,瑞士)","(name:wo,Suwis)","(name:war,Swiza)","(name:vo,Jveizän)","(name:vi,\\"Thụy Sĩ\\")","(name:vec,Svìzera)","(name:ur,\\"سویٹزر لینڈ\\")","(name:uk,Швейцарія)","(name:ug,Shwétsariye)","(name:udm,Швейцария)","(name:tr,İsviçre)","(name:tl,Suwisa)","(name:th,ประเทศสวิตเซอร์แลนด์)","(name:tg,Швейтсария)","(name:tet,Suisa)","(name:te,స్విట్జర్లాండ్)","(name:ta,சுவிட்சர்லாந்து)","(name:szl,Szwajcaryjo)","(name:sw,Uswisi)","(name:sv,Schweiz)","(name:stq,Swaits)","(name:sr,Швајцарска)","(name:sq,Zvicra)","(name:so,Iswiizerlaan)","(name:sl,Švica)","(name:sk,Švajčiarsko)","(name:simple,Switzerland)","(name:se,Šveica)","(name:sco,Swisserland)","(name:scn,Svìzzira)","(name:sah,Швейцария)","(name:sa,स्विटजरलैंड)","(name:ru,Швейцария)","(name:ro,Elveţia)","(name:rm,Svizra)","(name:qu,Suwisa)","(name:pt,Suíça)","(name:pnt,Ελβετία)","(name:pms,Svìssera)","(name:pl,Szwajcaria)","(name:pih,Switsaland)","(name:pdc,Schweiz)","(name:pam,Suiza)","(name:pag,Switzerland)","(name:os,Швейцари)","(name:oc,Soïssa)","(name:nrm,Suisse)","(name:nov,Suisia)","(name:no,Sveits)","(name:nn,Sveits)","(name:nl,Zwitserland)","(name:ne,स्विजरल्याण्ड)","(name:nds-nl,Zwitserlaand)","(name:nds,Swiez)","(name:nap,Sguizzera)","(name:nah,Suiza)","(name:na,Switzerland)","(name:ms,Switzerland)","(name:mr,स्वित्झर्लंड)","(name:mn,Швейцари)","(name:ml,സ്വിറ്റ്സര്‍ലാന്റ്)","(name:mk,Швајцарија)","(name:mhr,Швейцарий)","(name:mg,Soisa)","(name:mdf,Швейцария)","(name:lv,Šveice)","(name:lt,Šveicarija)","(name:ln,Swisi)","(name:lmo,Svìzzera)","(name:lij,Svissëa)","(name:li,Zweitserland)","(name:lb,Schwäiz)","(name:lad,Suisa)","(name:la,Helvetia)","(name:ky,Швейцария)","(name:kw,Swistir)","(name:kv,Швейцария)","(name:ku,Swîsre)","(name:ksh,Shwäĳz)","(name:ko,스위스)","(name:kn,ಸ್ವಿಟ್ಜರ್ಲ್ಯಾಂಡ್)","(name:kl,Schweizi)","(name:kk,Швейцария)","(name:kg,Suisi)","(name:ka,შვეიცარია)","(name:jv,Swiss)","(name:jbo,elvetias)","(name:ja,スイス)","(name:it,Svizzera)","(name:is,Sviss)","(name:io,Suisia)","(name:ilo,Switzerland)","(name:ie,Svissia)","(name:id,Swiss)","(name:ia,Suissa)","(name:hy,Շվեյցարիա)","(name:hu,Svájc)","(name:ht,Swis)","(name:hsb,Šwicarska)","(name:hr,Švicarska)","(name:hif,Switzerland)","(name:hi,स्विट्ज़रलैंड)","(name:he,שוויץ)","(name:haw,Kuikilani)","(name:gv,\\"Yn Elveeish\\")","(name:gl,Suíza)","(name:gd,\\"An Eilbheis\\")","(name:ga,\\"An Eilbhéis\\")","(name:fy,Switserlân)","(name:fur,Svuizare)","(name:frp,Suisse)","(name:fr,Suisse)","(name:fo,Sveis)","(name:fiu-vro,Sveits)","(name:fi,Sveitsi)","(name:fa,سوئیس)","(name:eu,Suitza)","(name:et,Šveits)","(name:es,Suiza)","(name:eo,Svislando)","(name:en,Switzerland)","(name:eml,Svézzra)","(name:el,Ελβετία)","(name:ee,Switzerland)","(name:dz,སུའིཊ་ཛར་ལེན་)","(name:dv,ސުވިޒަލޭންޑު)","(name:dsb,Šwicarska)","(name:diq,İswiçre)","(name:de,Schweiz)","(name:da,Schweiz)","(name:cy,\\"Y Swistir\\")","(name:cv,Швейцари)","(name:csb,Szwajcarskô)","(name:cs,Švýcarsko)","(name:ceb,Swisa)","(name:ca,Suïssa)","(name:bs,Švicarska)","(name:br,Suis)","(name:bpy,সুইজারল্যান্ড)","(name:bo,སུད་སི།)","(name:bg,Швейцария)","(name:be-x-old,Швейцарыя)","(name:be,Швейцарыя)","(name:bcl,Suisa)","(name:bat-smg,Šveicarėjė)","(name:bar,Schweiz)","(name:az,İsveçrə)","(name:ast,Suiza)","(name:arz,سويسرا)","(name:arc,ܣܘܝܣܪܐ)","(name:ar,سويسرا)","(name:ang,Sƿissland)","(name:an,Suiza)","(name:am,ስዊዘርላንድ)","(name:als,Schweiz)","(name:af,Switserland)","(name,Switzerland)"}	\N
ba	{"(official_name:pt,\\"República da Bósnia e Herzegovina\\")","(official_name:lv,\\"Bosnijas un Hercegovinas Republika\\")","(official_name:id,\\"Republik Bosnia dan Herzegovina\\")","(name:zh-yue,波斯尼亞)","(name:zh_pyt,\\"Bōsīníyà hé Hēisāigēwéinà\\")","(name:zh_py,\\"Bosiniya he Heisaigeweina\\")","(name:zh-min-nan,\\"Bosna kap Hercegovina\\")","(name:zh,波斯尼亚和黑塞哥维纳)","(name:wuu,波斯尼亚)","(name:wo,Bosni)","(name:war,\\"Bosnya ngan Hersegovina\\")","(name:vo,\\"Bosnän e Härzegovän\\")","(name:vi,\\"Bosna và Hercegovina\\")","(name:vec,\\"Bosnia e Erzegòvina\\")","(name:uz,\\"Bosniya va Gerzegovina\\")","(name:ur,\\"بوسنیا و ہرزیگووینا\\")","(name:uk,\\"Боснія і Герцеговина\\")","(name:ug,\\"بوسنىيە ۋە ھېرسېگوۋىنا\\")","(name:udm,\\"Босния но Герцеговина\\")","(name:tr,\\"Bosna Hersek\\")","(name:tl,\\"Bosnia at Herzegovina\\")","(name:th,ประเทศบอสเนียและเฮอร์เซโกวีนา)","(name:tg,\\"Босния ва Ҳерсеговина\\")","(name:te,\\"బోస్నియా మరియు హెర్జెగొవీనా\\")","(name:ta,\\"பொசுனியா எர்செகோவினா\\")","(name:szl,\\"Bośńa a Hercegowina\\")","(name:sw,\\"Bosnia na Herzegovina\\")","(name:sv,\\"Bosnien och Hercegovina\\")","(name:stq,\\"Bosnien un Herzegowina\\")","(name:srn,Bosnikondre)","(name:sr,\\"Босна и Херцеговина\\")","(name:sq,\\"Bosnja dhe Hercegovina\\")","(name:sl,\\"Bosna in Hercegovina\\")","(name:sk,\\"Bosna a Hercegovina\\")","(name:simple,\\"Bosnia and Herzegovina\\")","(name:sh,\\"Bosna i Hercegovina\\")","(name:se,\\"Bosnia ja Hercegovina\\")","(name:sco,\\"Bosnie an Herzegovinae\\")","(name:scn,Bosnia-Erzegovina)","(name:sah,\\"Босния уонна Херцеговина\\")","(name:sa,बास्निया)","(name:ru,\\"Босния и Герцеговина\\")","(name:roa-rup,\\"Bosna shi Hertsegovina\\")","(name:ro,\\"Bosnia şi Herţegovina\\")","(name:rm,Bosnia-Erzegovina)","(name:qu,Busna-Hirsiquwina)","(name:pt,\\"Bósnia e Herzegovina\\")","(name:ps,\\"بوسنيا او هېرزګوينا\\")","(name:pnt,\\"Βοσνία και Ερζεγοβίνη\\")","(name:pnb,\\"بوسنیا تے ہرزیگوونا\\")","(name:pms,\\"Bòsnia e Erzegòvina\\")","(name:pl,\\"Bośnia i Hercegowina\\")","(name:pih,\\"Bosnya a' Hersegowinya\\")","(name:pap,\\"Bosnia Herzogovina\\")","(name:pam,\\"Bosnia and Herzegovina\\")","(name:os,\\"Босни æмæ Герцеговинæ\\")","(name:oc,\\"Bòsnia e Ercegovina\\")","(name:nov,\\"Bosnia e Hertsegovina\\")","(name:no,Bosnia-Hercegovina)","(name:nn,Bosnia-Hercegovina)","(name:nl,\\"Bosnië en Herzegovina\\")","(name:ne,\\"बोस्निया र हर्जगोविना\\")","(name:nds,Bosnien-Herzegowina)","(name:nap,Bosnia-Erzegovina)","(name:nah,\\"Bosna īhuān Hertzegovina\\")","(name:na,\\"Bosnia me Herzegowina\\")","(name:mt,\\"Bożnija u Ħerżegovina\\")","(name:ms,\\"Bosnia dan Herzegovina\\")","(name:mr,\\"बॉस्निया आणि हर्झगोव्हिना\\")","(name:mn,Босни-Герцеговин)","(name:ml,\\"ബോസ്നിയ ഹെര്‍സെഗോവിന\\")","(name:mk,\\"Босна и Херцеговина\\")","(name:lv,\\"Bosnija un Hercegovina\\")","(name:lt,\\"Bosnija ir Hercogovina\\")","(name:ln,\\"Bosnia na Erzegovina\\")","(name:lmo,\\"Bosnia e Erzegovina\\")","(name:lij,Bòsnia-Erçegòvina)","(name:li,\\"Bosnië en Hercegovina\\")","(name:lb,Bosnien-Herzegowina)","(name:la,\\"Bosnia et Herzegovina\\")","(name:kw,Bosni–Hercegovina)","(name:kv,\\"Босния да Герцеговина\\")","(name:ku,\\"Bosniya û Herzegovîna\\")","(name:ks,बास्निया)","(name:ko,\\"보스니아 헤르체고비나\\")","(name:kn,\\"ಬೊಸ್ನಿಯ ಮತ್ತು ಹೆರ್ಜೆಗೊವಿನ\\")","(name:kk,\\"Босния және Герцеговина\\")","(name:kg,Bosna)","(name:ka,\\"ბოსნია და ჰერცეგოვინა\\")","(name:jv,Bosnia-Herzegovina)","(name:ja,ボスニア・ヘルツェゴビナ)","(name:it,Bosnia-Erzegovina)","(name:is,\\"Bosnía og Hersegóvína\\")","(name:ie,\\"Bosnia e Herzegovina\\")","(name:id,\\"Bosnia dan Herzegovina\\")","(name:ia,\\"Bosnia e Herzegovina\\")","(name:hy,\\"Բոսնիա և Հերցեգովինա\\")","(name:hu,Bosznia-Hercegovina)","(name:ht,\\"Bosni ak Erzegovin\\")","(name:hsb,\\"Bosniska a Hercegowina\\")","(name:hr,\\"Bosna i Hercegovina\\")","(name:hif,\\"Bosnia and Herzegovina\\")","(name:hi,\\"बॉस्निया और हर्ज़ेगोविना\\")","(name:he,\\"בוסניה הרצגובינה\\")","(name:haw,\\"Bosenia me Hesegowina\\")","(name:gv,\\"Bosnia as Herzegovina\\")","(name:gn,\\"Vonia ha Hesegovina\\")","(name:gl,\\"Bosnia e Hercegovina\\")","(name:gd,\\"Bosna agus Heartsagobhana\\")","(name:ga,\\"An Bhoisnia-Heirseagaivéin\\")","(name:fy,Bosnje)","(name:frp,Bosnie-Hèrzègovena)","(name:fr,Bosnie-Herzégovine)","(name:fiu-vro,\\"Bosnia ja Hertsegoviina\\")","(name:fi,\\"Bosnia ja Hertsegovina\\")","(name:fa,\\"بوسنی و هرزگووین\\")","(name:eu,Bosnia-Herzegovina)","(name:et,\\"Bosnia ja Hertsegoviina\\")","(name:es,\\"Bosnia y Herzegovina\\")","(name:eo,\\"Bosnio kaj Hercegovino\\")","(name:en,\\"Bosnia and Herzegovina\\")","(name:el,\\"Βοσνία και Ερζεγοβίνη\\")","(name:ee,\\"Bosnia and Herzegovina\\")","(name:dv,\\"ބޮސްނިޔާ ހަރުޒެގޮވީނާ\\")","(name:dsb,Bosniska-Hercegowinska)","(name:diq,Bosna-Hersek)","(name:de,\\"Bosnien und Herzegowina\\")","(name:da,Bosnien-Hercegovina)","(name:cy,\\"Bosna a Hercegovina\\")","(name:cv,\\"Босни тата Герцеговина\\")","(name:cu,Босна́)","(name:csb,\\"Bòsnijô ë Hercegòwina\\")","(name:cs,\\"Bosna a Hercegovina\\")","(name:crh,\\"Bosna ve Hersek\\")","(name:chr,ᏉᏍᏂᏯ)","(name:ceb,\\"Bosnia ug Herzegovina\\")","(name:ca,\\"Bòsnia i Hercegovina\\")","(name:bs,\\"Bosna i Hercegovina\\")","(name:br,Bosnia-ha-Herzegovina)","(name:bpy,\\"বসনিয়া বারো হার্জেগোভিনা\\")","(name:bn,\\"বসনিয়া ও হার্জেগোভিনা\\")","(name:bg,\\"Босна и Херцеговина\\")","(name:be-x-old,\\"Босьнія і Герцагавіна\\")","(name:be,\\"Боснія і Герцагавіна\\")","(name:bcl,\\"Bosnya asin Hersegobina\\")","(name:bat-smg,\\"Bosnėjė ėr Hercuogovėna\\")","(name:az,\\"Bosniya və Herseqovina\\")","(name:ast,Bosnia-Herzegovina)","(name:arz,\\"البوسنه و الهرسك\\")","(name:arc,\\"ܒܘܣܢܐ ܘܗܪܣܟ\\")","(name:ar,\\"البوسنة والهرسك\\")","(name:ang,\\"Bosnia and Herzegovina\\")","(name:an,\\"Bosnia e Erzegobina\\")","(name:als,Bosnie-Herzegowina)","(name:af,Bosnië-Herzegowina)","(name,\\"Bosna i Hercegovina\\")"}	\N
my	{"(official_name:pl,\\"Federacja Malezji\\")","(official_name:lv,\\"Malaizijas Federācija\\")","(name:zh_pyt,Mǎláixīyà)","(name:zh_py,Malaixiya)","(name:zh,马来西亚)","(name:uk,Малайзія)","(name:tr,Malezya)","(name:th,ประเทศมาเลเซีย)","(name:sv,Malaysia)","(name:sl,Malezija)","(name:ru,Малайзия)","(name:pl,Malezja)","(name:nl,Maleisië)","(name:mn,Малайз)","(name:lv,Malaizija)","(name:lt,Malaizija)","(name:la,Malaesia)","(name:ja,マレーシア)","(name:it,Malesia)","(name:is,Malasía)","(name:hu,Malajzia)","(name:hr,Malezija)","(name:he,מלזיה)","(name:haw,Malaisia)","(name:gd,Malaidhsia)","(name:ga,\\"An Mhalaeisia\\")","(name:fy,Maleizje)","(name:fr,Malaisie)","(name:fi,Malesia)","(name:fa,مالزی)","(name:et,Malaisia)","(name:es,Malasia)","(name:eo,Malajzio)","(name:en,Malaysia)","(name:el,Μαλαισία)","(name:ca,Malàisia)","(name:br,Malaysia)","(name:be,Малайзія)","(name:az,Malayziya)","(name:ar,ماليزي)","(name:af,Maleisië)","(name,Malaysia)"}	\N
gw	{"(official_name:vi,\\"Cộng hòa Guiné-Bissau\\")","(official_name:sv,\\"Republiken Guinea-Bissau\\")","(official_name:lv,\\"Gvinejas-Bisavas Republika\\")","(official_name:lt,\\"Bisau Gvinėjos Respublika\\")","(official_name:id,\\"Republik Guinea-Bissau\\")","(official_name:gd,\\"Poblachd Ghini-Bissau\\")","(official_name:et,\\"Guinea-Bissau Vabariik\\")","(official_name:el,\\"Δημοκρατία της Γουινέας-Μπισσάου\\")","(official_name:be,\\"Рэспубліка Гвінэя-Бісаў\\")","(official_name,\\"República da Guiné-Bissau\\")","(name:zh_pyt,\\"Jīnèiyà Bǐshào\\")","(name:zh_py,\\"Jineiya Bishao\\")","(name:zh,几内亚比绍)","(name:uk,Гвінея-Бісау)","(name:tr,\\"Gine Bissau\\")","(name:th,ประเทศกินี-บิสเซา)","(name:sv,Guinea-Bissau)","(name:sl,\\"Gvineja Bissau\\")","(name:ru,Гвинея-Бисау)","(name:pl,\\"Gwinea Bissau\\")","(name:nl,Guinee-Bissau)","(name:mn,Гвиней-Бисау)","(name:lv,Gvineja-Bisava)","(name:lt,\\"Bisau Gvinėja\\")","(name:li,Guinee-Bissau)","(name:lb,Guinea-Bissau)","(name:la,\\"Guinea Bissaviensis\\")","(name:it,Guinea-Bissau)","(name:is,Gínea-Bissá)","(name:id,Guinea-Bissau)","(name:hu,Bissau-Guinea)","(name:hr,\\"Gvineja Bisau\\")","(name:he,\\"גינאה ביסאו\\")","(name:gd,Gini-Bissau)","(name:ga,Guine-Bhissau)","(name:fy,Guinee-Bissau)","(name:fr,Guinée-Bissau)","(name:fi,Guinea-Bissau)","(name:fa,\\"گینه بیسائو\\")","(name:et,Guinea-Bissau)","(name:es,Guinea-Bissau)","(name:eo,\\"Gvineo Bisaŭa\\")","(name:en,Guinea-Bissau)","(name:el,Γουινέα-Μπισσάου)","(name:de,Guinea-Bissau)","(name:da,Guinea-Bissau)","(name:cy,Guiné-Bissau)","(name:ca,\\"Guinea Bissau\\")","(name:br,Ginea-Bissau)","(name:be,Гвінея-Бісаў)","(name:ar,غينيا-بيساو)","(name:af,Guinee-Bissau)","(name,Guiné-Bissau)"}	\N
ml	{"(official_name:vi,\\"Cộng hòa Mali\\")","(official_name:sv,\\"Republiken Mali\\")","(official_name:lv,\\"Mali Republika\\")","(official_name:lt,\\"Malio Respublika\\")","(official_name:ja,マリ共和国)","(official_name:id,\\"Republik Mali\\")","(official_name:en,\\"Republic of Mali\\")","(official_name:el,\\"Δημοκρατία του Μάλι\\")","(official_name:be,\\"Рэспубліка Малі\\")","(official_name,\\"République du Mali\\")","(name:zh,马里)","(name:uk,Малі)","(name:th,ประเทศมาลี)","(name:sv,Mali)","(name:ru,Мали)","(name:pl,Mali)","(name:mn,Мали)","(name:lv,Mali)","(name:lt,Malis)","(name:la,Malium)","(name:ja,マリ)","(name:it,Mali)","(name:is,Malí)","(name:hu,Mali)","(name:he,מאלי)","(name:haw,Māli)","(name:gd,Màili)","(name:ga,Mailí)","(name:fy,Maly)","(name:fr,Mali)","(name:fi,Mali)","(name:fa,مالی)","(name:es,Malí)","(name:eo,Malio)","(name:en,Mali)","(name:el,Μάλι)","(name:da,Mali)","(name:br,Mali)","(name:be,Малі)","(name:ar,مالي)","(name,Mali)"}	\N
al	{"(official_name:vi,\\"Cộng hoà Albania\\")","(official_name:sv,\\"Republiken Albanien\\")","(official_name:sk,\\"Albánska republika\\")","(official_name:pt,\\"República da Albânia\\")","(official_name:pl,\\"Republika Albanii\\")","(official_name:lb,\\"Republik Albanien\\")","(official_name:ja,アルバニア共和国)","(official_name:fr,\\"République d'Albanie\\")","(official_name:et,\\"Albaania Vabariik\\")","(official_name:es,\\"República de Albania\\")","(official_name:en,\\"Republic of Albania\\")","(official_name:el,\\"Δημοκρατία της Αλβανίας\\")","(official_name:be,\\"Рэспубліка Албанія\\")","(official_name,\\"Republika e Shqipërisë\\")","(name:zh-yue,阿爾巴尼亞)","(name:zh_pyt,Āěrbāníyà)","(name:zh_py,Aerbaniya)","(name:zh-min-nan,Shqipëria)","(name:zh,阿尔巴尼亚)","(name:zea,Albanië)","(name:yo,Albania)","(name:yi,אלבאניע)","(name:xal,\\"Арнаутн Орн Нутг\\")","(name:wuu,阿尔巴尼亚)","(name:wo,Albaani)","(name:war,Albanya)","(name:vo,Lalbanän)","(name:vi,Albania)","(name:vec,Albania)","(name:uz,Albaniya)","(name:ur,البانیا)","(name:uk,Албанія)","(name:ug,ئالبانىيە)","(name:udm,Албания)","(name:tt,Албания)","(name:tr,Arnavutluk)","(name:tpi,Albenia)","(name:tl,Albanya)","(name:th,ประเทศแอลเบเนีย)","(name:tg,Албания)","(name:tet,Albánia)","(name:te,అల్బేనియా)","(name:ta,அல்பேனியா)","(name:szl,Albańijo)","(name:sw,Albania)","(name:sv,Albanien)","(name:su,Albania)","(name:stq,Albanien)","(name:ss,I-Alibheniya)","(name:srn,Albanikondre)","(name:sr,Албанија)","(name:sq,Shqipëria)","(name:sl,Albanija)","(name:sk,Albánsko)","(name:simple,Albania)","(name:sh,Albanija)","(name:se,Albánia)","(name:sco,Albanie)","(name:scn,Albanìa)","(name:sc,Albania)","(name:sah,Албания)","(name:sa,अल्बानिया)","(name:ru,Албания)","(name:roa-rup,Arbinishia)","(name:ro,Albania)","(name:rmy,Shkiperiya)","(name:rm,Albania)","(name:qu,Albanya)","(name:pt,Albânia)","(name:ps,البانيا)","(name:pnt,Αλβανία)","(name:pnb,البانیا)","(name:pms,Albanìa)","(name:pl,Albania)","(name:pih,Elbanya)","(name:pdc,Albaani)","(name:pam,Albania)","(name:os,Албани)","(name:oc,Albania)","(name:nov,Albania)","(name:no,Albania)","(name:nn,Albania)","(name:nl,Albanië)","(name:ne,अल्बानिया)","(name:nds,Albanien)","(name:nah,Albania)","(name:na,Albania)","(name:mzn,آلباني)","(name:mt,Albanija)","(name:ms,Albania)","(name:mr,आल्बेनिया)","(name:mn,Албани)","(name:ml,അല്‍ബേനിയ)","(name:mk,Албанија)","(name:mg,Albania)","(name:lv,Albānija)","(name:lt,Albanija)","(name:ln,Albania)","(name:lmo,Albania)","(name:lij,Albania)","(name:li,Albanië)","(name:lb,Albanien)","(name:lad,אלבאניה)","(name:la,Albania)","(name:ky,Албания)","(name:kv,Албания)","(name:ku,Albanya)","(name:ko,알바니아)","(name:kn,ಅಲ್ಬೇನಿಯ)","(name:km,អាល់បានី)","(name:kk,Албания)","(name:kg,Albania)","(name:ka,ალბანეთი)","(name:jv,Albania)","(name:ja,アルバニア)","(name:it,Albania)","(name:is,Albanía)","(name:io,Albania)","(name:ilo,Albania)","(name:ie,Albania)","(name:id,Albania)","(name:hy,Ալբանիա)","(name:hu,Albánia)","(name:ht,Albani)","(name:hsb,Albanska)","(name:hr,Albanija)","(name:hif,Albania)","(name:hi,अल्बानिया)","(name:he,אלבניה)","(name:haw,‘Alepania)","(name:gv,\\"Yn Albaan\\")","(name:gn,Avaña)","(name:gl,Albania)","(name:gd,Albàinia)","(name:ga,\\"An Albáin\\")","(name:fy,Albaanje)","(name:fur,Albanie)","(name:frp,Albanie)","(name:fr,Albanie)","(name:fo,Albania)","(name:fiu-vro,Albaania)","(name:fi,Albania)","(name:fa,آلبانی)","(name:ext,Albánia)","(name:eu,Albania)","(name:et,Albaania)","(name:es,Albania)","(name:eo,Albanio)","(name:en,Albania)","(name:eml,Albanî)","(name:el,Αλβανία)","(name:ee,Albania)","(name:dz,ཨལ་བཱ་ནི་ཡ།)","(name:dsb,Albańska)","(name:diq,Arnawutiye)","(name:de,Albanien)","(name:da,Albanien)","(name:cy,Albania)","(name:cv,Албани)","(name:csb,Albańskô)","(name:cs,Albánie)","(name:crh,Arnavutlıq)","(name:co,Albania)","(name:chr,ᎠᎸᏇᏂᏯ)","(name:ceb,Albanya)","(name:ce,Албани)","(name:ca,Albània)","(name:bs,Albanija)","(name:br,Albania)","(name:bpy,আলবেনিয়া)","(name:bo,ཨར་པ་ཉི་ཡ།)","(name:bn,আলবেনিয়া)","(name:bg,Албания)","(name:be-x-old,Альбанія)","(name:be,Албанія)","(name:bcl,Albanya)","(name:bat-smg,Albanėjė)","(name:bar,Albanien)","(name:az,Albaniya)","(name:ast,Albania)","(name:arz,ألبانيا)","(name:arc,ܐܠܒܢܝܐ)","(name:ar,ألبانيا)","(name:ang,Albania)","(name:an,Albania)","(name:am,አልባኒያ)","(name:als,Albanie)","(name:af,Albanië)","(name:ace,Albania)","(name,Shqipëria)"}	\N
tg	{"(official_name:vi,\\"Cộng hòa Togo\\")","(official_name:sv,\\"Republiken Togo\\")","(official_name:pt,\\"República Togolesa\\")","(official_name:lt,\\"Togo Respublika\\")","(official_name:lb,\\"Republik Togo\\")","(official_name:id,\\"Republik Togo\\")","(official_name:gd,\\"Poblachd Thògo\\")","(official_name:el,\\"Δημοκρατία του Τόγκο\\")","(official_name:br,\\"Republik Togo\\")","(official_name,\\"République Togolaise\\")","(name:zh_pyt,Duōgē)","(name:zh_py,Duoge)","(name:zh,多哥)","(name:uk,Того)","(name:th,ประเทศโตโก)","(name:sv,Togo)","(name:ru,Того)","(name:pt,Togo)","(name:pl,Togo)","(name:mn,Того)","(name:lt,Togas)","(name:la,Togum)","(name:it,Togo)","(name:is,Tógó)","(name:hu,Togo)","(name:he,טוגו)","(name:haw,Tōkō)","(name:gd,Tògo)","(name:ga,Tóga)","(name:fr,Togo)","(name:fi,Togo)","(name:fa,توگو)","(name:es,Togo)","(name:eo,Togo)","(name:en,Togo)","(name:el,Τόγκο)","(name:da,Togo)","(name:br,Togo)","(name:be,Тога)","(name:ar,توغو)","(name,Togo)"}	\N
fo	{"(official_name:lv,\\"Fēru salas\\")","(name:zh_pyt,Fǎluóqúndǎo)","(name:zh_py,Faluoqundao)","(name:zh-min-nan,\\"Mî-iûⁿ Kûn-tó\\")","(name:zh,法罗群岛)","(name:wuu,法罗群岛)","(name:wo,\\"Duni Faarow\\")","(name:war,\\"Feroe nga Islas\\")","(name:vi,\\"Quần đảo Faroe\\")","(name:vec,\\"Ixołe Fær Øer\\")","(name:uk,\\"Фарерські острови\\")","(name:tr,\\"Faroe Adaları\\")","(name:tl,\\"Kapuluang Peroe\\")","(name:th,หมู่เกาะแฟโร)","(name:tg,\\"Ҷазираҳои Фаро\\")","(name:ta,\\"பரோயே தீவுகள்\\")","(name:sw,\\"Visiwa vya Faroe\\")","(name:sv,Färöarna)","(name:sr,\\"Фарска острва\\")","(name:sq,\\"Ishujt Faroe\\")","(name:sl,\\"Ferski otoki\\")","(name:sk,\\"Faerské ostrovy\\")","(name:simple,\\"Faroe Islands\\")","(name:sh,\\"Farski Otoci\\")","(name:se,Fearsullot)","(name:sco,\\"Faroe Islands\\")","(name:scn,\\"Ìsuli Fær Øer\\")","(name:ru,\\"Фарерские острова\\")","(name:ro,\\"Insulele Feroe\\")","(name:rmy,\\"Dvipa Faroe\\")","(name:qu,Pharuy)","(name:pt,\\"Ilhas Feroe\\")","(name:pms,Faròe)","(name:pl,\\"Wyspy Owcze\\")","(name:pih,\\"Faaro Ailen\\")","(name:pam,\\"Faroe Islands\\")","(name:os,\\"Фарераг сакъадæхтæ\\")","(name:oc,\\"Illas Feròe\\")","(name:no,Færøyene)","(name:nn,Færøyane)","(name:nl,Faeröer)","(name:nds-nl,Faeröer)","(name:ms,\\"Kepulauan Faroe\\")","(name:mr,\\"फेरो द्वीपसमूह\\")","(name:mn,\\"Фарерын Арлууд\\")","(name:mk,\\"Фарски Острови\\")","(name:lv,\\"Farēru (Fēru) salas\\")","(name:lt,Farerai)","(name:lmo,Faroe)","(name:lij,\\"Isoe Farœ\\")","(name:li,Faeröer)","(name:la,\\"Insulae Faeroae\\")","(name:kw,\\"Ynysow Faroe\\")","(name:ku,\\"Giravên Faroe\\")","(name:ko,\\"페로 제도\\")","(name:kl,Savalimmiut)","(name:kk,\\"Фарер аралдары\\")","(name:ka,\\"ფარერის კუნძულები\\")","(name:jv,\\"Kapuloan Faroe\\")","(name:ja,フェロー諸島)","(name:it,\\"Isole Fær Øer\\")","(name:is,Færeyjar)","(name:io,Faero)","(name:id,\\"Kepulauan Faroe\\")","(name:hu,Feröer)","(name:hsb,Färöje)","(name:hr,Føroyar)","(name:hi,\\"फ़रो द्वीप\\")","(name:he,\\"איי פארו\\")","(name:gv,\\"Ellanyn ny Geyrragh\\")","(name:gle,\\"Na Scigirí\\")","(name:gl,\\"Illas Feroe\\")","(name:gd,\\"Na h-Eileanan Fàro\\")","(name:ga,\\"Oileáin Fharó\\")","(name:fy,Faeröer)","(name:frp,\\"Iles Fèroè\\")","(name:fr,\\"Îles Féroé\\")","(name:fo,Føroyar)","(name:fi,Färsaaret)","(name:fa,فارو)","(name:ext,\\"Islas Feroes\\")","(name:eu,\\"Faroe Uharteak\\")","(name:et,\\"Fääri saared\\")","(name:es,\\"Islas Feroe\\")","(name:eo,Ferooj)","(name:en,\\"Faroe Islands\\")","(name:el,\\"Νήσοι Φερόες\\")","(name:dv,\\"ފަރޮއޭ ޖަޒީރާ\\")","(name:de,Färöer)","(name:da,Færøerne)","(name:cy,Føroyar)","(name:cs,\\"Faerské ostrovy\\")","(name:ce,\\"Фарерийн гІайренаш\\")","(name:ca,\\"Illes Fèroe\\")","(name:bs,\\"Farska ostrva\\")","(name:br,\\"Inizi Faero\\")","(name:bpy,\\"ফারো দ্বীপমালা\\")","(name:bg,\\"Фарьорски острови\\")","(name:be-x-old,\\"Фарэрскія выспы\\")","(name:be,\\"Фарэрскія астравы\\")","(name:bar,Färöer)","(name:az,\\"Farer adaları\\")","(name:ast,\\"Islles Feroe\\")","(name:ar,\\"جزر فارو\\")","(name:ang,\\"Faroisca Īega\\")","(name:am,\\"ፋሮ ደሴቶች\\")","(name:als,Färöer)","(name:af,Faroëreilande)","(name,Føroyar/Færøerne)","(alt_name,\\"Faeroe Islands;Faroes;Faeroes\\")"}	\N
jp	{"(official_name:pt,\\"Império do Japão\\")","(official_name:ca,\\"Estat del Japó\\")","(name:zu,iJapani)","(name:zh-yue,日本)","(name:zh_pyt,Rìběn)","(name:zh_py,Riben)","(name:zh-min-nan,Ji̍t-pún)","(name:zh-classical,日本)","(name:zh,日本)","(name:za,Nditbonj)","(name:yo,Japan)","(name:yi,יאפאן)","(name:xal,Японь)","(name:wuu,日本)","(name:wo,Sapoŋ)","(name:war,Hapon)","(name:vo,Yapän)","(name:vi,\\"Nhật Bản\\")","(name:vec,Giapòn)","(name:uz,Yaponiya)","(name:ur,جاپان)","(name:uk,Японія)","(name:ug,ياپونىيە)","(name:udm,Япония)","(name:ty,Tāpōnē)","(name:tr,Japonya)","(name:tpi,Siapan)","(name:tl,Hapon)","(name:tk,Ýaponiýa)","(name:ti,ጃፓን)","(name:th,ประเทศญี่ปุ่น)","(name:tg,Ҷопон)","(name:te,జపాన్)","(name:ta,ஜப்பான்)","(name:szl,Japůńijo)","(name:sw,Japani)","(name:sv,Japan)","(name:su,Jepang)","(name:ss,IJaphani)","(name:sr,Јапан)","(name:sq,Japonia)","(name:so,Jabaan)","(name:sm,Iapani)","(name:sl,Japonska)","(name:sk,Japonsko)","(name:simple,Japan)","(name:si,ජපානය)","(name:se,Japána)","(name:sd,جاپان)","(name:sco,Japan)","(name:scn,Giappuni)","(name:sc,Giappone)","(name:sah,Дьоппуон)","(name:sa,जापान)","(name:ru,Япония)","(name:ro,Japonia)","(name:qu,Nihun)","(name:pt,Japão)","(name:ps,جاپان)","(name:pnb,جاپان)","(name:pms,Giapon)","(name:pl,Japonia)","(name:pap,Hapon)","(name:pam,Hapon)","(name:os,Япон)","(name:or,ଜାପାନ)","(name:oc,Japon)","(name:nv,Bina'adaałtzózí)","(name:nrm,Japon)","(name:nov,Japan)","(name:no,Japan)","(name:nn,Japan)","(name:nl,Japan)","(name:new,जापान)","(name:ne,जापान)","(name:nds-nl,Japan)","(name:nds,Japan)","(name:nap,Giappone)","(name:nah,Xapon)","(name:na,Djapan)","(name:my,ဂျပန်နိုင်ငံ)","(name:mwl,Japon)","(name:ms,Jepun)","(name:mr,जपान)","(name:mn,Япон)","(name:ml,ജപ്പാന്‍)","(name:mk,Јапонија)","(name:mi,Nipono)","(name:mhr,Японий)","(name:mg,Japana)","(name:mdf,Япунмастор)","(name:lv,Japāna)","(name:lt,Japonija)","(name:lo,ປະເທດຍີ່ປຸ່ນ)","(name:ln,Zapɔ́)","(name:lmo,Giapun)","(name:lij,Giappon)","(name:li,Japan)","(name:lb,Japan)","(name:la,Iaponia)","(name:ky,Жапония)","(name:kw,Nihon)","(name:kv,Япония)","(name:ku,Japan)","(name:ks,जापान)","(name:ko,일본)","(name:kn,ಜಪಾನ್)","(name:km,ជប៉ុន)","(name:kk,Жапония)","(name:ka,იაპონია)","(name:jv,Jepang)","(name:jbo,pongu'e)","(name:ja_rm,Nippon)","(name:ja,日本)","(name:iu,ᓃᑉᐊᓐ/niipan)","(name:it,Giappone)","(name:is,Japan)","(name:io,Japonia)","(name:ilo,Japon)","(name:ie,Japan)","(name:id,Jepang)","(name:ia,Japon)","(name:hy,Ճապոնիա)","(name:hu,Japán)","(name:ht,Japon)","(name:hsb,Japanska)","(name:hr,Japan)","(name:hif,Japan)","(name:hi,जापान)","(name:he,יפן)","(name:haw,Iāpana)","(name:hak,Ngi̍t-pún)","(name:ha,Japan)","(name:gv,\\"Yn Çhapaan\\")","(name:gu,જાપાન)","(name:gl,\\"Xapón - 日本\\")","(name:gd,Iapan)","(name:gan,日本)","(name:ga,\\"An tSeapáin\\")","(name:fy,Japan)","(name:frp,J·apon)","(name:fr,Japon)","(name:fo,Japan)","(name:fi,Japani)","(name:fa,ژاپن)","(name:eu,Japonia)","(name:et,Jaapan)","(name:es,Japón)","(name:eo,Japanio)","(name:en,Japan)","(name:el,Ιαπωνία)","(name:ee,Japan)","(name:dz,ཇ་པཱན)","(name:dv,ޖަޕާނު)","(name:dsb,Japańska)","(name:diq,Japonya)","(name:de,Japan)","(name:da,Japan)","(name:cy,Japan)","(name:cv,Япони)","(name:cu,Ꙗпѡні́ꙗ)","(name:csb,Japòńskô)","(name:cs,Japonsko)","(name:crh,Yaponiya)","(name:chr,ᏣᏆᏂ)","(name:ceb,Hapon)","(name:cdo,Nĭk-buōng)","(name:cbk-zam,Japón)","(name:ca,Japó)","(name:bxr,Жибэн)","(name:bug,ᨍᨛᨄ)","(name:bs,Japan)","(name:br,Japan)","(name:bpy,জাপান)","(name:bo,རི་པིན།)","(name:bn,জাপান)","(name:bg,Япония)","(name:be-x-old,Японія)","(name:be,Японія)","(name:bcl,Hapon)","(name:bat-smg,Japuonėjė)","(name:bar,Japan)","(name:ba,Япония)","(name:az,Yaponiya)","(name:ast,Xapón)","(name:as,জাপান)","(name:arz,اليابان)","(name:arc,ܝܦܢ)","(name:ar,اليابان)","(name:ang,Iapan)","(name:an,Chapón)","(name:am,ጃፓን)","(name:als,Japan)","(name:af,Japan)","(name,\\"日本 (Japan)\\")"}	\N
gq	{"(official_name:vi,\\"Cộng hòa Guinea Xích Đạo\\")","(official_name:sv,\\"Republiken Ekvatorialguinea\\")","(official_name:pt,\\"República da Guiné Equatorial\\")","(official_name:lv,\\"Ekvatoriālās Gvinejas Republika\\")","(official_name:lt,\\"Pusiaujo Gvinėjos Respublika\\")","(official_name:id,\\"Republik Guinea Khatulistiwa\\")","(official_name:et,\\"Ekvatoriaal-Guinea Vabariik\\")","(official_name:el,\\"Δημοκρατία της Ισημερινής Γουινέας\\")","(official_name,\\"República de Guinea Ecuatorial;République de Guinée équatoriale;República da Guiné Equatorial\\")","(name:zh_pyt,\\"Chìdào Jīnèiyà\\")","(name:zh_py,\\"Chidao Jineiya\\")","(name:zh-min-nan,\\"Chhiah-tō Guinea\\")","(name:zh,赤道几内亚)","(name:zea,\\"Equatoriaol Hunea\\")","(name:wo,\\"Gineg yamoo\\")","(name:vo,Kveatora-Gineyän)","(name:vi,\\"Guinea Xích Đạo\\")","(name:vec,\\"Guinea Equatorial\\")","(name:uz,\\"Ekvatorli Gvineya\\")","(name:ur,\\"استوائی گنی\\")","(name:uk,\\"Екваторіальна Гвінея\\")","(name:ug,\\"Ékwator Gwinéyisi\\")","(name:ts,\\"Equatorial Guinea\\")","(name:tr,\\"Ekvator Ginesi\\")","(name:tl,\\"Equatorial Guinea\\")","(name:th,ประเทศอิเควทอเรียลกินี)","(name:tg,\\"Гвинеяи Истивоӣ\\")","(name:ta,\\"எக்குவடோரியல் கினி\\")","(name:sw,\\"Guinea ya Ikweta\\")","(name:sv,Ekvatorialguinea)","(name:stq,\\"Äquatorioal Guinea\\")","(name:sr,\\"Екваторијална Гвинеја\\")","(name:sq,\\"Guineja Ekuatoriale\\")","(name:sl,\\"Ekvatorialna Gvineja\\")","(name:sk,\\"Rovníková Guinea\\")","(name:simple,\\"Equatorial Guinea\\")","(name:sh,\\"Ekvatorijalna Gvineja\\")","(name:se,\\"Beaivvedási Guinea\\")","(name:scn,\\"Guinia Ecuaturiali\\")","(name:sc,\\"Guinea Ecuadoriale\\")","(name:sah,\\"Экуатор Гуинеята\\")","(name:ru,\\"Экваториальная Гвинея\\")","(name:ro,\\"Guineea Ecuatorială\\")","(name:qu,\\"Chawpipacha Khiniya\\")","(name:pt,\\"Guiné Equatorial\\")","(name:ps,\\"اېکواټوريال ګوينا\\")","(name:pnb,\\"استوائی گنی\\")","(name:pms,\\"Guinea Equatorial\\")","(name:pl,\\"Gwinea Równikowa\\")","(name:pam,\\"Equatorial Guinea\\")","(name:os,\\"Экваториалон Гвиней\\")","(name:oc,\\"Guinèa Eqüatoriala\\")","(name:nov,\\"Equatoral Gini\\")","(name:no,Ekvatorial-Guinea)","(name:nn,Ekvatorial-Guinea)","(name:nl,Equatoriaal-Guinea)","(name:nds,Äquatoriaal-Guinea)","(name:nb,Ekvatorial-Guinea)","(name:nah,\\"Guinea Tlahcotlālticpac\\")","(name:ms,\\"Guinea Khatulistiwa\\")","(name:mr,\\"इक्वेटोरीयल गिनी\\")","(name:mn,\\"Экваторын Гвиней\\")","(name:ml,\\"ഇക്വറ്റോറിയല്‍ ഗിനി\\")","(name:mk,\\"Екваторијална Гвинеја\\")","(name:lv,\\"Ekvatoriālā Gvineja\\")","(name:lt,\\"Pusiaujo Gvinėja\\")","(name:ln,Gine-Ekwatorial)","(name:lmo,\\"Guinea Equaturiala\\")","(name:lij,\\"Guinea Equatoriâ\\")","(name:li,\\"Equatoriaal Guinee\\")","(name:lb,Equatorialguinea)","(name:la,\\"Guinea Aequatorensis\\")","(name:kw,\\"Gyni Ekwadoriel\\")","(name:ku,\\"Gînêya Rojbendî\\")","(name:ko,\\"적도 기니\\")","(name:kn,\\"ವಿಷುವದ್ರೇಖೆಯ ಗಿನಿ\\")","(name:kk,\\"Екуатор Гиния\\")","(name:ka,\\"ეკვატორული გვინეა\\")","(name:jv,\\"Guinea Khatulistiwa\\")","(name:ja,赤道ギニア)","(name:it,\\"Guinea Equatoriale\\")","(name:is,Miðbaugs-Gínea)","(name:io,\\"Equatorala Guinea\\")","(name:ie,\\"Equatorial Guinéa\\")","(name:id,\\"Guinea Khatulistiwa\\")","(name:ia,\\"Guinea Equatorial\\")","(name:hu,Egyenlítői-Guinea)","(name:ht,\\"Gine ekwateryal\\")","(name:hr,\\"Ekvatorska Gvineja\\")","(name:hif,\\"Equatorial Guinea\\")","(name:hi,\\"ईक्वीटोरियल गिनी\\")","(name:he,\\"גינאה המשוונית\\")","(name:gv,\\"Guinea Chryss ny Cruinney\\")","(name:gl,\\"Guinea Ecuatorial\\")","(name:gd,\\"Gini Mheadhan-Chriosach\\")","(name:ga,\\"An Ghuine Mheánchriosach\\")","(name:fy,\\"Ekwatoriaal Guinee\\")","(name:frp,\\"Guinê èquatoriâla\\")","(name:fr,\\"Guinée équatoriale\\")","(name:fo,Ekvatorguinea)","(name:fiu-vro,Ekvatoriaal-Ginea)","(name:fi,\\"Päiväntasaajan Guinea\\")","(name:fa,\\"گینه استوایی\\")","(name:eu,\\"Ekuatore Ginea\\")","(name:et,Ekvatoriaal-Guinea)","(name:es,\\"Guinea Ecuatorial\\")","(name:eo,\\"Ekvatora Gvineo\\")","(name:en,\\"Equatorial Guinea\\")","(name:el,\\"Ισημερινή Γουινέα\\")","(name:dv,\\"އިކުއެޓޯރިއަލް ގިނީ\\")","(name:diq,\\"Gineya Ekwatori\\")","(name:de,Äquatorialguinea)","(name:da,Ækvatorialguinea)","(name:cy,\\"Guinea Gyhydeddol\\")","(name:cv,\\"Экваториаллă Гвиней\\")","(name:cs,\\"Rovníková Guinea\\")","(name:crh,\\"Ekvatorial Gvineya\\")","(name:co,\\"Guinea Equatoriale\\")","(name:ceb,\\"Guinea Ecuatorial\\")","(name:ca,\\"Guinea Equatorial\\")","(name:bs,\\"Ekvatorijalna Gvineja\\")","(name:br,\\"Ginea ar C’heheder\\")","(name:bpy,\\"একুয়াটরিয়াল গায়ানা\\")","(name:bm,\\"Cemajan Gine\\")","(name:bg,\\"Екваториална Гвинея\\")","(name:be-x-old,\\"Экватарыяльная Ґвінэя\\")","(name:be,\\"Экватарыяльная Гвінея\\")","(name:bcl,\\"Guineyang Ekwatoryal\\")","(name:bat-smg,\\"Ekvatuorė Gvinėjė\\")","(name:az,\\"Ekvatorial Qvineya\\")","(name:ast,\\"Guinea Ecuatorial\\")","(name:arz,\\"جينيا الاستوائيه\\")","(name:ar,\\"غينيا الاستوائية\\")","(name:an,\\"Guinea Ecuatorial\\")","(name:am,\\"ኢኳቶሪያል ጊኔ\\")","(name:als,Äquatorialguinea)","(name:af,Ekwatoriaal-Guinee)"}	\N
io	{"(name:zh_pyt,\\"Yīngshǔ Yìndùyáng Lǐngdì\\")","(name:zh_py,\\"Yingshu Yinduyang Lingdu\\")","(name:zh,英属印度洋领地)","(name:vi,\\"Lãnh thổ Ấn Độ Dương thuộc Anh\\")","(name:uk,\\"Британська територія в Індійському океані\\")","(name:tr,\\"Britanya Hint Okyanusu Toprakları\\")","(name:ta,\\"பிரித்தானிய இந்தியப் பெருங்கடல் மண்டலம்\\")","(name:sw,\\"Eneo la Uingereza katika Bahari Hindi\\")","(name:sv,\\"Brittiska territoriet i Indiska oceanen\\")","(name:sr,\\"Британска територија Индијског океана\\")","(name:sl,\\"Britanski teritorij v Indijskem oceanu\\")","(name:sk,\\"Britské indickooceánske územie\\")","(name:sh,\\"Britanski teritorij Indijskog oceana\\")","(name:ru,\\"Британская территория в Индийском океане\\")","(name:ro,\\"Teritoriul Britanic din Oceanul Indian\\")","(name:pt,\\"Território Britânico do Oceano Índico\\")","(name:pl,\\"Brytyjskie Terytorium Oceanu Indyjskiego\\")","(name:no,\\"Det britiske territoriet i Indiahavet\\")","(name:nl,\\"Brits Territorium in de Indische Oceaan\\")","(name:ms,\\"Wilayah Lautan Hindi British\\")","(name:mr,\\"ब्रिटीश हिंदी महासागर क्षेत्र\\")","(name:lv,\\"Indijas okeāna Britu teritorija\\")","(name:lt,\\"Indijos vandenyno Britų sritis\\")","(name:ko,\\"영국령 인도양 지역\\")","(name:ka,\\"ბრიტანეთის ინდოეთის ოკეანის ტერიტორია\\")","(name:ja,イギリス領インド洋地域)","(name:it,\\"Territorio britannico dell'oceano Indiano\\")","(name:is,\\"Breska Indlandshafseyjar\\")","(name:id,\\"Teritorial Britania di Samudra Hindia\\")","(name:hu,\\"Brit Indiai-óceáni Terület\\")","(name:hr,\\"Britanski indijskooceanski teritoriji\\")","(name:hi,\\"ब्रिटिश हिंद महासागर क्षेत्र\\")","(name:he,\\"הטריטוריה הבריטית באוקיינוס ההודי\\")","(name:gl,\\"Territorio Británico do Océano Índico\\")","(name:ga,\\"Críoch Aigéan Indiach na Breataine\\")","(name:fy,\\"Britske Yndyske-Oseaanterritoarium\\")","(name:fr,\\"Territoire britannique de l'océan Indien\\")","(name:fi,\\"Brittiläinen Intian valtameren alue\\")","(name:et,\\"Briti India ookeani ala\\")","(name:es,\\"Territorio Británico del Océano Índico\\")","(name:eo,\\"Brita Hindoceana Teritorio\\")","(name:en,\\"British Indian Ocean Territory\\")","(name:el,\\"Βρετανικό Έδαφος Ινδικού Ωκεανού\\")","(name:de,\\"Britisches Territorium im Indischen Ozean\\")","(name:da,\\"Britiske Indiske Ocean\\")","(name:cs,\\"Britské indickooceánské území\\")","(name:ca,\\"Territori Britànic de l'Oceà Índic\\")","(name:bs,\\"Britanski teritorij Indijskog okeana\\")","(name:br,\\"Tiriadoù Breizhveuriat Mor Indez\\")","(name:bg,\\"Британска индоокеанска територия\\")","(name:be-x-old,\\"Брытанская тэрыторыя ў Індыйскім акіяне\\")","(name:be,\\"Брытанскія Індыйска-акіянскія тэрыторыі\\")","(name:ar,\\"إقليم المحيط الهندي البريطاني\\")","(name:an,\\"Territorio Britanico de l'Ozián Indico\\")","(name:af,\\"Britse Indiese Oseaan Gebied\\")","(name,\\"British Indian Ocean Territory\\")","(loc_name,\\"Chagos Islands\\")"}	\N
pk	{"(official_name:vi,\\"Cộng hoà Hồi giáo Pakistan\\")","(official_name:ur,\\"اسلامی جمہوریۂ پاکستان\\")","(official_name:sv,\\"Islamiska republiken Pakistan\\")","(official_name:pl,\\"Islamska Republika Pakistanu\\")","(official_name:lv,\\"Pakistānas Islāma Republika\\")","(official_name:lt,\\"Pakistano Islamo Respublika\\")","(official_name:lb,\\"Islamische Republik Pakistan\\")","(official_name:it,\\"Repubblica Islamica del Pakistan\\")","(official_name:id,\\"Republik Islam Pakistan\\")","(official_name:fr,\\"République islamique du Pakistan\\")","(official_name:el,\\"Ισλαμική Δημοκρατία του Πακιστάν\\")","(official_name:br,\\"Republik islamek Pakistan\\")","(official_name:af,\\"Islamistiese Republiek van Pakistan\\")","(official_name,\\"Islamic Republic of Pakistan\\")","(name:zh-yue,巴基斯坦)","(name:zh_pyt,Bājīsītǎn)","(name:zh_py,Bajisitan)","(name:zh-min-nan,Pakistan)","(name:zh-classical,巴基斯坦)","(name:zh,巴基斯坦)","(name:yo,Pakistan)","(name:yi,פאקיסטאן)","(name:wuu,巴基斯坦)","(name:wo,Pakistaan)","(name:war,Pakistan)","(name:wa,Pakistan)","(name:vo,Pakistän)","(name:vi,Pakistan)","(name:vec,Pakistan)","(name:uz,Pokiston)","(name:ur,پاکستان)","(name:uk,Пакистан)","(name:ug,پاكىستان)","(name:udm,Пакистан)","(name:tr,Pakistan)","(name:tl,Pakistan)","(name:tk,Päkistan)","(name:th,ประเทศปากีสถาน)","(name:tg,Покистон)","(name:te,పాకిస్తాన్)","(name:ta,பாக்கித்தான்)","(name:szl,Pakistan)","(name:sw,Pakistan)","(name:sv,Pakistan)","(name:su,Pakistan)","(name:sr,Пакистан)","(name:sq,Pakistani)","(name:sl,Pakistan)","(name:sk,Pakistan)","(name:simple,Pakistan)","(name:sh,Pakistan)","(name:se,Pakistan)","(name:sd,پاکستان)","(name:sco,Pakistan)","(name:scn,Pakistan)","(name:sah,Пакистан)","(name:sa,पाकिस्तान)","(name:ru,Пакистан)","(name:ro,Pakistan)","(name:rmy,Pakistan)","(name:qu,Pakistan)","(name:pt,Paquistão)","(name:ps,پاکستان)","(name:pnb,پاکستان)","(name:pms,Pakistan)","(name:pl,Pakistan)","(name:pap,Pakistan)","(name:pam,Pakistan)","(name:pa,ਪਾਕਿਸਤਾਨ)","(name:os,Пакистан)","(name:or,ପାକିସ୍ତାନ)","(name:oc,Paquistan)","(name:nov,Pakistan)","(name:no,Pakistan)","(name:nn,Pakistan)","(name:nl,Pakistan)","(name:nds,Pakistan)","(name:nb,Pakistan)","(name:nah,Paquistan)","(name:mt,Pakistan)","(name:ms,Pakistan)","(name:mr,पाकिस्तान)","(name:mn,Пакистан)","(name:ml,പാകിസ്താന്‍)","(name:mk,Пакистан)","(name:mhr,Пакистан)","(name:mdf,Пакистан)","(name:lv,Pakistāna)","(name:lt,Pakistanas)","(name:ln,Pakistáni)","(name:lmo,Pakistan)","(name:lij,Pakistan)","(name:li,Pakistan)","(name:lb,Pakistan)","(name:la,Pakistania)","(name:ky,Пакистан)","(name:kw,Pakistan)","(name:kv,Пакистан)","(name:ku,Pakistan)","(name:ks,पाकिस्‍तान)","(name:ko,파키스탄)","(name:kn,ಪಾಕಿಸ್ತಾನ)","(name:kl,Pakistan)","(name:kk,Пәкістан)","(name:kab,Pakistan)","(name:ka,პაკისტანი)","(name:jv,Pakistan)","(name:jbo,kisygu'e)","(name:ja,パキスタン)","(name:iu,ᐸᑭᔅᑕᓐ/pakistan)","(name:it,Pakistan)","(name:is,Pakistan)","(name:io,Pakistan)","(name:ilo,Pakistan)","(name:ie,Pakistan)","(name:id,Pakistan)","(name:hy,Պակիստան)","(name:hu,Pakisztán)","(name:ht,Pakistan)","(name:hsb,Pakistan)","(name:hr,Pakistan)","(name:hif,Pakistan)","(name:hi,पाकिस्तान)","(name:he,פקיסטן)","(name:haw,Pakitana)","(name:hak,Pâ-kî-sṳ̂-thán)","(name:ha,Pakistan)","(name:gv,\\"Yn Phakistaan\\")","(name:gu,પાકિસ્તાન)","(name:gn,Pakistán)","(name:gl,Paquistán)","(name:gd,Pagastàn)","(name:gan,巴基斯坦)","(name:ga,\\"An Phacastáin\\")","(name:fy,Pakistan)","(name:frp,Paquistan)","(name:fr,Pakistan)","(name:fi,Pakistan)","(name:fa,پاکستان)","(name:eu,Pakistan)","(name:et,Pakistan)","(name:es,Pakistán)","(name:eo,Pakistano)","(name:en,Pakistan)","(name:el,Πακιστάν)","(name:dv,ޕާކިސްތާން)","(name:dsb,Pakistan)","(name:diq,Pakıstan)","(name:de,Pakistan)","(name:da,Pakistan)","(name:cy,Pakistan)","(name:cv,Пакистан)","(name:csb,Pakistan)","(name:cs,Pákistán)","(name:crh,Pakistan)","(name:ceb,Pakistan)","(name:cbk-zam,Pakistan)","(name:ca,Pakistan)","(name:bs,Pakistan)","(name:br,Pakistan)","(name:bpy,পাকিস্তান)","(name:bo,པ་ཀི་སི་ཏན།)","(name:bn,পাকিস্তান)","(name:bg,Пакистан)","(name:be-x-old,Пакістан)","(name:be,Пакістан)","(name:bcl,Pakistan)","(name:bat-smg,Pakėstans)","(name:ba,Пакистан)","(name:az,Pakistan)","(name:ast,Paquistán)","(name:as,পাকিস্তান)","(name:arz,باكيستان)","(name:arc,ܦܩܝܣܛܢ)","(name:ar,باكستان)","(name:an,Pakistán)","(name:als,Pakistan)","(name:af,Pakistan)","(name:ace,Pakistan)","(name,پاکستان)"}	\N
be	{"(official_name:vi,\\"Vương quốc Bỉ\\")","(official_name:sv,\\"Konungariket Belgien\\")","(official_name:sk,\\"Belgické kráľovstvo\\")","(official_name:pt,\\"Reino da Bélgica\\")","(official_name:pl,\\"Królestwo Belgii\\")","(official_name:nl,\\"Koninkrijk België\\")","(official_name:lv,\\"Beļģijas Karaliste\\")","(official_name:lt,\\"Belgijos Karalystė\\")","(official_name:ja,ベルギー王国)","(official_name:id,\\"Kerajaan Belgia\\")","(official_name:fr,\\"Royaume de Belgique\\")","(official_name:es,\\"Reino de Bélgica\\")","(official_name:en,\\"Kingdom of Belgium\\")","(official_name:el,\\"Βασίλειο του Βελγίου\\")","(official_name:de,\\"Königreich Belgien\\")","(official_name:da,\\"Koninkrijk België\\")","(official_name:be,\\"Каралеўства Бельгія\\")","(official_name,\\"Koninkrijk België;Royaume de Belgique;Königreich Belgien\\")","(name:zh-yue,比利時)","(name:zh_pyt,Bǐlìshí)","(name:zh_py,Bilishi)","(name:zh-min-nan,Belgien)","(name:zh,比利时)","(name:zea,Belhië)","(name:yo,Belgium)","(name:yi,בעלגיע)","(name:wuu,比利时)","(name:wo,Belsik)","(name:war,Belhika)","(name:wa,Beldjike)","(name:vo,Belgän)","(name:vls,België)","(name:vi,Bỉ)","(name:vec,Belgio)","(name:uz,Belgiya)","(name:ur,بلجئیم)","(name:uk,Бельгія)","(name:ug,بېلگىيە)","(name:udm,Бельгия)","(name:tt,Бельгия)","(name:tr,Belçika)","(name:tpi,Beljiam)","(name:tl,Belhika)","(name:th,ประเทศเบลเยียม)","(name:tg,Белгия)","(name:tet,Béljika)","(name:te,బెల్జియం)","(name:ta,பெல்ஜியம்)","(name:szl,Belgijo)","(name:sw,Ubelgiji)","(name:sv,Belgien)","(name:su,Bélgia)","(name:stq,Belgien)","(name:srn,Belgikondre)","(name:sr,Белгија)","(name:sq,Belgjika)","(name:sl,Belgija)","(name:sk,Belgicko)","(name:simple,Belgium)","(name:sh,Belgija)","(name:se,Belgia)","(name:sco,Belgium)","(name:scn,Belgiu)","(name:sah,Бельгия)","(name:sa,बेल्जियम)","(name:rw,\\"U Bubiligi\\")","(name:ru,Бельгия)","(name:roa-rup,Belghia)","(name:ro,Belgia)","(name:rmy,Beljiya)","(name:rm,Belgia)","(name:qu,Bilhika)","(name:pt,Bélgica)","(name:pnt,Βέλγιον)","(name:pnb,بیلجیم)","(name:pms,Belgi)","(name:pl,Belgia)","(name:pih,Beljum)","(name:pdc,Belgien)","(name:pap,Bélgika)","(name:pam,Belgium)","(name:os,Бельги)","(name:oc,Belgica)","(name:nrm,Belgique)","(name:nov,Belgia)","(name:no,Belgia)","(name:nn,Belgia)","(name:nl,België)","(name:ne,बेल्जियम)","(name:nds-nl,België)","(name:nds,Belgien)","(name:nb,Belgia)","(name:nap,Belge)","(name:nah,Belgica)","(name:na,Belgium)","(name:mt,Belġju)","(name:ms,Belgium)","(name:mr,बेल्जियम)","(name:mn,Бельги)","(name:ml,ബെല്‍ജിയം)","(name:mk,Белгија)","(name:mg,Belzika)","(name:mdf,Бельгия)","(name:lv,Beļģija)","(name:lt,Belgija)","(name:ln,Bɛ́ljika)","(name:lij,Belgiò)","(name:li,Belsj)","(name:lb,Belsch)","(name:lad,Beljika)","(name:la,Belgia)","(name:ky,Бельгия)","(name:kw,\\"Pow Belg\\")","(name:kv,Бельгия)","(name:ku,Belgiya)","(name:ksh,Belljie)","(name:ko,벨기에)","(name:kl,Belgia)","(name:kk,Белгия)","(name:kab,Biljik)","(name:ka,ბელგია)","(name:jv,Bèlgia)","(name:jbo,beldjym)","(name:ja,ベルギー)","(name:it,Belgio)","(name:is,Belgía)","(name:io,Belgia)","(name:ilo,Belgium)","(name:ie,Belgia)","(name:id,Belgia)","(name:ia,Belgica)","(name:hy,Բելգիա)","(name:hu,Belgium)","(name:ht,Bèljik)","(name:hsb,Belgiska)","(name:hr,Belgija)","(name:hif,Belgium)","(name:he,בלגיה)","(name:haw,Pelekiuma)","(name:hak,Pí-li-sṳ)","(name:gv,\\"Yn Velg\\")","(name:gl,Bélxica)","(name:gd,\\"A' Bheilg\\")","(name:ga,\\"An Bheilg\\")","(name:fy,Belgje)","(name:fur,Belgjo)","(name:frp,Bèlg·ique)","(name:fr,Belgique)","(name:fo,Belgia)","(name:fiu-vro,Belgiä)","(name:fi,Belgia)","(name:fa,بلژیک)","(name:eu,Belgika)","(name:et,Belgia)","(name:es,Bélgica)","(name:eo,Belgio)","(name:en,Belgium)","(name:el,Βέλγιο)","(name:ee,Belgium)","(name:dz,བེལ་ཇིཡམ)","(name:dv,ބެލްޖިއަމް)","(name:dsb,Belgiska)","(name:diq,Belçıka)","(name:de,Belgien)","(name:da,Belgien)","(name:cy,\\"Gwlad Belg\\")","(name:cv,Бельги)","(name:csb,Belgijskô)","(name:cs,Belgie)","(name:crh,Belçika)","(name:co,Belgica)","(name:ckb,به‌لجیكا)","(name:ceb,Belhika)","(name:ce,Бельге)","(name:ca,Bèlgica)","(name:bs,Belgija)","(name:br,Belgia)","(name:bpy,বেলজিয়াম)","(name:bo,པེར་ཅིན།)","(name:bn,বেলজিয়াম)","(name:bg,Белгия)","(name:be-x-old,Бэльґія)","(name:be,Бельгія)","(name:bcl,Belhika)","(name:bat-smg,Belgėjė)","(name:bar,Belgien)","(name:az,Belçika)","(name:ast,Bélxica)","(name:arz,بلجيكا)","(name:arc,ܒܠܓܝܟܐ)","(name:ar,بلجيكا)","(name:ang,Belgice)","(name:an,Belchica)","(name:am,ቤልጅግ)","(name:als,Belgie)","(name:af,België)","(name,\\"België - Belgique - Belgien\\")"}	\N
eg	{"(official_name:vi,\\"Cộng hòa Ả Rập Ai Cập\\")","(official_name:sv,\\"Arabrepubliken Egypten\\")","(official_name:pt,\\"República Árabe do Egito\\")","(official_name:lv,\\"Ēģiptes Arābu Republika\\")","(official_name:lt,\\"Egipto Arabų Respublika\\")","(official_name:lb,\\"Arabesch Republik vun Egypten\\")","(official_name:id,\\"Republik Arab Mesir\\")","(official_name:et,\\"Egiptuse Araabia Vabariik\\")","(official_name:en,\\"Arab Republic of Egypt\\")","(official_name:el,\\"Αραβική Δημοκρατία της Αιγύπτου\\")","(official_name:ca,\\"República Àrab d'Egipte\\")","(official_name:br,\\"Republik arab Egipt\\")","(official_name:af,\\"Arabiese Republiek van Egipte\\")","(official_name,\\"جمهورية مصر العربية\\")","(name:zh-yue,埃及)","(name:zh_pyt,Āijí)","(name:zh_py,Aiji)","(name:zh-min-nan,Ai-ki̍p)","(name:zh-classical,埃及)","(name:zh,埃及)","(name:yo,Egypt)","(name:yi,עגיפטן)","(name:wuu,埃及)","(name:wo,Isipt)","(name:war,Ehipto)","(name:wa,Edjipe)","(name:vo,Lägüptän)","(name:vls,Egypte)","(name:vi,\\"Ai Cập\\")","(name:vec,Egito)","(name:uz,Misr)","(name:ur,مصر)","(name:uk,Єгипет)","(name:ug,مىسىر)","(name:tt,Мисыр)","(name:ts,Egypt)","(name:tr,Mısır)","(name:tpi,Ijip)","(name:tl,Ehipto)","(name:th,ประเทศอียิปต์)","(name:tg,Миср)","(name:tet,Ejitu)","(name:te,ఈజిప్టు)","(name:ta,எகிப்து)","(name:szl,Egipt)","(name:sw,Misri)","(name:sv,Egypten)","(name:stq,Ägypten)","(name:ss,IGibhithe)","(name:sr,Египат)","(name:sq,Egjipti)","(name:sm,Aikupito)","(name:sl,Egipt)","(name:sk,Egypt)","(name:simple,Egypt)","(name:sh,Egipat)","(name:se,Egypta)","(name:sco,Egyp)","(name:scn,Eggittu)","(name:sah,Эгипет)","(name:sa,ईजिप्ट)","(name:ru,Египет)","(name:ro,Egipt)","(name:qu,Ihiptu)","(name:pt,Egito)","(name:ps,مصر)","(name:pnt,Αίγυπτος)","(name:pnb,مصر)","(name:pms,Egit)","(name:pl,Egipt)","(name:pam,Ejiptu)","(name:pa,Egypt)","(name:os,Мысыр)","(name:oc,Egipte)","(name:nrm,Êgypte)","(name:nov,Egiptia)","(name:no,Egypt)","(name:nn,Egypt)","(name:nl,Egypte)","(name:new,मिस्र)","(name:ne,इजिप्ट)","(name:nds-nl,Egypte)","(name:nds,Ägypten)","(name:nap,Naggitto)","(name:nah,Egipto)","(name:na,Egypt)","(name:mzn,مەسر)","(name:ms,Mesir)","(name:mr,इजिप्त)","(name:mn,Египет)","(name:ml,ഈജിപ്റ്റ്‌)","(name:mk,Египет)","(name:mg,Ejipta)","(name:mdf,Египет)","(name:lv,Ēģipte)","(name:lt,Egiptas)","(name:ln,Ejipte)","(name:lmo,Egit)","(name:lij,Egitto)","(name:li,Egypte)","(name:lb,Egypten)","(name:la,Aegyptus)","(name:kw,Ejyp)","(name:kv,Египет)","(name:ku,Misir)","(name:ks,مِسر)","(name:ko,이집트)","(name:kn,ಈಜಿಪ್ಟ್)","(name:kk,Мысыр)","(name:kg,Misiri)","(name:kab,Maṣer)","(name:ka,ეგვიპტე)","(name:jv,Mesir)","(name:jbo,misrygu'e)","(name:ja,エジプト)","(name:it,Egitto)","(name:is,Egyptaland)","(name:io,Egiptia)","(name:ilo,Ehipto)","(name:ie,Egypt)","(name:id,Mesir)","(name:ia,Egypto)","(name:hy,Եգիպտոս)","(name:hu,Egyiptom)","(name:ht,Ejip)","(name:hsb,Egyptowska)","(name:hr,Egipat)","(name:hif,Egypt)","(name:hi,मिस्र)","(name:he,מצריים)","(name:haw,‘Aikupika)","(name:hak,Âi-khi̍p)","(name:gv,\\"Yn Egypt\\")","(name:gl,\\"Exipto - مصر\\")","(name:gd,\\"An Èipheit\\")","(name:gan,埃及)","(name:ga,\\"An Éigipt\\")","(name:fy,Egypte)","(name:fur,Egjit)","(name:frp,Èg·ipte)","(name:fr,Égypte)","(name:fo,Egyptaland)","(name:fj,Ijipta)","(name:fi,Egypti)","(name:fa,مصر)","(name:eu,Egipto)","(name:et,Egiptus)","(name:es,Egipto)","(name:eo,Egiptujo)","(name:en,Egypt)","(name:el,Αίγυπτος)","(name:dv,މިޞްރު)","(name:dsb,Egyptojska)","(name:diq,Mısır)","(name:de,Ägypten)","(name:da,Egypten)","(name:cy,\\"Yr Aifft\\")","(name:cu,Єгѷптъ)","(name:cs,Egypt)","(name:crh,Mısır)","(name:ceb,Ehipto)","(name:ce,Миср)","(name:ca,Egipte)","(name:bs,Egipat)","(name:br,Egipt)","(name:bpy,মিশর)","(name:bo,ཨའི་ཅི)","(name:bn,মিশর)","(name:bm,Misra)","(name:bg,Египет)","(name:be-x-old,Эгіпет)","(name:be,Егіпет)","(name:bcl,Ehipto)","(name:bat-smg,Egėpts)","(name:bar,Ägyptn)","(name:ba,Мысыр)","(name:az,Misir)","(name:ast,Exipto)","(name:arz,مصر)","(name:arc,ܡܨܪܝܢ)","(name:ar,مصر)","(name:ang,Ǣgypt)","(name:an,Echipto)","(name:am,ግብፅ)","(name:als,Ägypte)","(name:af,Egipte)","(name:ace,Mesir)","(name,\\"Egypt / مصر\\")"}	\N
jo	{"(official_name:sv,\\"Hashemitiska konungariket Jordanien\\")","(official_name:pl,\\"Jordańskie Królestwo Haszymidzkie\\")","(official_name:lv,\\"Jordānijas Hāšimītu Karaliste\\")","(official_name:lt,\\"Jordanijos Hašimitų Karalystė\\")","(official_name:lb,\\"Haschimitescht Kinnekräich Jordanien\\")","(official_name:it,\\"Regno Hascemita di Giordania\\")","(official_name:id,\\"Kerajaan Hasyimiyah Yordania\\")","(official_name:gd,\\"Rioghachd Hashemach na Iòrdain\\")","(official_name:et,\\"Jordaania Hašimiidi Kuningriik\\")","(official_name:en,\\"Hashemite Kingdom of Jordan\\")","(official_name:el,\\"Χασεμιτικό Βασίλειο της Ιορδανίας\\")","(official_name:br,\\"Rouantelezh hachemit Jordania\\")","(official_name,\\"المملكة الأردنية الهاشمية\\")","(name:zh_pyt,Yuēdàn)","(name:zh_py,Yuedan)","(name:zh-min-nan,Iok-tàn)","(name:zh,约旦)","(name:yi,יארדאניע)","(name:wuu,约旦)","(name:wo,Jordaani)","(name:war,Hordanya)","(name:vo,Yordän)","(name:vi,Jordan)","(name:uz,Iordan)","(name:ur,اردن)","(name:uk,Йорданія)","(name:ug,ئىئوردانىيە)","(name:udm,Иордания)","(name:tr,Ürdün)","(name:tl,Jordan)","(name:th,ประเทศจอร์แดน)","(name:te,జోర్డాన్)","(name:ta,ஜோர்தான்)","(name:szl,Jordańijo)","(name:sw,Yordani)","(name:sv,Jordanien)","(name:sr,Јордан)","(name:sq,Jordania)","(name:sl,Jordanija)","(name:sk,Jordánsko)","(name:simple,Jordan)","(name:sh,Jordan)","(name:se,Jordánia)","(name:scn,Giurdania)","(name:sah,Иордания)","(name:sa,जार्डन)","(name:ru,Иордания)","(name:ro,Iordania)","(name:qu,Hurdanya)","(name:pt,Jordânia)","(name:ps,اردن)","(name:pnb,اردن)","(name:pms,Giordania)","(name:pl,Jordania)","(name:pam,Jordan)","(name:os,Иордани)","(name:oc,Jordania)","(name:nov,Jordan)","(name:no,Jordan)","(name:nn,Jordan)","(name:nl,Jordanië)","(name:nds,Jordanien)","(name:nah,Iordania)","(name:na,Jordan)","(name:mzn,اوردون)","(name:ms,Jordan)","(name:mr,जॉर्डन)","(name:mn,Йордан)","(name:ml,ജോര്‍ദാന്‍)","(name:mk,Јордан)","(name:lv,Jordānija)","(name:lt,Jordanija)","(name:lmo,Giurdania)","(name:lij,Giordannia)","(name:li,Jordanië)","(name:lb,Jordanien)","(name:la,Iordania)","(name:kw,Jordan)","(name:kv,Иордания)","(name:ku,Urdun)","(name:ks,जार्डन)","(name:ko,요르단)","(name:kk,Иордан)","(name:kab,Urdun)","(name:ka,იორდანია)","(name:jv,Yordania)","(name:jbo,jorgu'e)","(name:ja,ヨルダン)","(name:it,Giordania)","(name:is,Jórdanía)","(name:io,Jordania)","(name:ilo,Jordan)","(name:ie,Jordania)","(name:id,Yordania)","(name:ia,Jordania)","(name:hy,Հորդանան)","(name:hu,Jordánia)","(name:ht,Jòdani)","(name:hsb,Jordaniska)","(name:hr,Jordan)","(name:hif,Jordan)","(name:hi,जार्डन)","(name:he,ירדן)","(name:haw,Ioredāne)","(name:hak,Yok-tan)","(name:gv,\\"Yn Jordaan\\")","(name:gl,Xordania)","(name:gd,Iòrdan)","(name:ga,\\"An Iordáin\\")","(name:fy,Jordaanje)","(name:frp,J·ordanie)","(name:fr,Jordanie)","(name:fiu-vro,Jordaania)","(name:fi,Jordania)","(name:fa,اردن)","(name:eu,Jordania)","(name:et,Jordaania)","(name:es,Jordania)","(name:eo,Jordanio)","(name:en,Jordan)","(name:el,Ιορδανία)","(name:dv,އުރުދުން)","(name:dsb,Jordanska)","(name:diq,Urdun)","(name:de,Jordanien)","(name:cy,\\"Gwlad Iorddonen\\")","(name:cv,Иордани)","(name:cs,Jordánsko)","(name:crh,Urdun)","(name:ceb,Jordan)","(name:ca,Jordània)","(name:bs,Jordan)","(name:br,Jordania)","(name:bpy,জর্ডান)","(name:bo,ཇོར་ཏའན)","(name:bn,জর্দান)","(name:bg,Йордания)","(name:be-x-old,Ярданія)","(name:be,Іарданія)","(name:bcl,Yordanya)","(name:bat-smg,Juordanėjė)","(name:az,İordaniya)","(name:ast,Xordania)","(name:arz,الاردن)","(name:arc,ܝܘܪܕܢܢ)","(name:ar,الأردن)","(name:ang,Jordan)","(name:an,Chordania)","(name:als,Jordanien)","(name:af,Jordanië)","(name:ace,Yordania)","(name,\\"Jordan / الأُرْدُن\\")"}	\N
tn	{"(official_name:vi,\\"Cộng hòa Tunisia\\")","(official_name:sv,\\"Republiken Tunisien\\")","(official_name:pt,\\"República da Tunísia\\")","(official_name:lt,\\"Tuniso Respublika\\")","(official_name:lb,\\"Tunesesch Republik\\")","(official_name:ja,チュニジア共和国)","(official_name:id,\\"Republik Tunisia\\")","(official_name:et,\\"Tuneesia Vabariik\\")","(official_name:en,\\"Tunisian Republic\\")","(official_name:el,\\"Δημοκρατία της Τυνησίας\\")","(official_name:br,\\"Republik Tunizian\\")","(official_name,\\"الجمهورية التونسية\\")","(name:zh_pyt,Tūníxīyà)","(name:zh_py,Tunixiya)","(name:zh-min-nan,Tunisia)","(name:zh,突尼西亚)","(name:yo,Tunisia)","(name:wuu,突尼斯)","(name:wo,Tiniisi)","(name:war,Tunisia)","(name:wa,Tunizeye)","(name:vo,Tunisän)","(name:vi,Tunisia)","(name:vec,Tunixia)","(name:uz,Tunis)","(name:ur,تیونس)","(name:uk,Туніс)","(name:ug,تۇنىس)","(name:ts,Tunisia)","(name:tr,Tunus)","(name:tl,Tunisia)","(name:ti,ቱኒዢያ)","(name:th,ประเทศตูนิเซีย)","(name:tg,Тунис)","(name:te,ట్యునీషియా)","(name:ta,துனீசியா)","(name:szl,Tůnezyjo)","(name:sw,Tunisia)","(name:sv,Tunisien)","(name:sr,Тунис)","(name:sq,Tunizia)","(name:so,Tunisie)","(name:sl,Tunizija)","(name:sk,Tunisko)","(name:simple,Tunisia)","(name:sh,Tunis)","(name:se,Tunisia)","(name:scn,Tunisìa)","(name:sc,Tunisia)","(name:sah,Тунис)","(name:sa,टुनिशिया)","(name:ru,Тунис)","(name:ro,Tunisia)","(name:rm,Tunesia)","(name:qu,Tunisya)","(name:pt,Tunísia)","(name:pnb,ٹیونس)","(name:pms,Tunisìa)","(name:pl,Tunezja)","(name:pap,Tunesia)","(name:pam,Tunisia)","(name:oc,Tunisia)","(name:nov,Tunisia)","(name:no,Tunisia)","(name:nn,Tunisia)","(name:nl,Tunesië)","(name:nds,Tunesien)","(name:nah,Tunez)","(name:mzn,تونس)","(name:mt,Tuneżija)","(name:ms,Tunisia)","(name:mr,ट्युनिसिया)","(name:mn,Тунис)","(name:ml,ടുണീഷ്യ)","(name:mk,Тунис)","(name:mg,Tonizia)","(name:lv,Tunisija)","(name:lt,Tunisas)","(name:ln,Tunisia)","(name:lmo,Tünisia)","(name:lij,Tunixia)","(name:li,Tunesië)","(name:lb,Tunesien)","(name:lad,Tunesia)","(name:la,Tunesia)","(name:kw,Tunisi)","(name:ku,Tûnis)","(name:ks,टुनिशिया)","(name:ko,튀니지)","(name:kn,ಟುನೀಶಿಯ)","(name:kk,Тунис)","(name:kg,Tunisia)","(name:kab,Tunes)","(name:ka,ტუნისი)","(name:jv,Tunisia)","(name:ja,チュニジア)","(name:it,Tunisia)","(name:is,Túnis)","(name:io,Tunizia)","(name:ilo,Tunisia)","(name:ie,Tunisia)","(name:id,Tunisia)","(name:hu,Tunézia)","(name:ht,Tinizi)","(name:hsb,Tuneziska)","(name:hr,Tunis)","(name:hif,Tunisia)","(name:hi,टुनिशिया)","(name:he,טוניס)","(name:haw,Tunisia)","(name:gv,\\"Yn Tooneesh\\")","(name:gl,Tunisia)","(name:gd,Tuinisia)","(name:ga,\\"An Túinéis\\")","(name:fy,Tuneezje)","(name:frp,Tunisie)","(name:fr,Tunisie)","(name:fo,Tunesia)","(name:fi,Tunisia)","(name:fa,تونس)","(name:eu,Tunisia)","(name:et,Tuneesia)","(name:es,Túnez)","(name:eo,Tunizio)","(name:en,Tunisia)","(name:el,Τυνησία)","(name:diq,Tunıs)","(name:de,Tunesien)","(name:da,Tunesien)","(name:cy,Tunisia)","(name:cv,Тунис)","(name:cs,Tunisko)","(name:crh,Tunis)","(name:ceb,Tunisia)","(name:ca,Tunísia)","(name:bs,Tunis)","(name:br,Tunizia)","(name:bpy,তিউনিসিয়া)","(name:bn,তিউনিসিয়া)","(name:bm,Tunizi)","(name:bg,Тунис)","(name:be-x-old,Туніс)","(name:be,Туніс)","(name:bcl,Tunisya)","(name:az,Tunis)","(name:ast,Túnez)","(name:arz,تونس)","(name:arc,ܬܘܢܣ)","(name:ar,تونس)","(name:ang,Tunisia)","(name:an,Tunizia)","(name:am,ቱኒዚያ)","(name:als,Tunesien)","(name:af,Tunisië)","(name:ace,Tunisia)","(name,تونس)"}	\N
dz	{"(official_name:sv,\\"Demokratiska folkrepubliken Algeriet\\")","(official_name:sl,\\"Ljudska demokratična republika Alžirija\\")","(official_name:pt,\\"República Popular Democrática da Argélia\\")","(official_name:lb,\\"Demokratesch Volleksrepublik Algerien\\")","(official_name:fr,\\"République algérienne démocratique et populaire\\")","(official_name:en,\\"People's Democratic Republic of Algeria\\")","(official_name,アルジェリア民主人民共和国)","(name:zh-yue,阿爾及利亞)","(name:zh_pyt,Āěrjílìyà)","(name:zh_py,Aerjiliya)","(name:zh-min-nan,Algeria)","(name:zh,阿尔及利亚)","(name:zea,Alherije)","(name:yo,Algeria)","(name:yi,אלזשעריע)","(name:wuu,阿尔及利亚)","(name:wo,Alseeri)","(name:war,Alherya)","(name:wa,Aldjereye)","(name:vo,Laljerän)","(name:vi,Algiers)","(name:vec,Algeria)","(name:uz,Jazoir)","(name:ur,الجزائر)","(name:uk,Алжир)","(name:ug,ئالجىرىيە)","(name:ts,Algeria)","(name:tr,Cezayir)","(name:tl,Alherya)","(name:th,ประเทศแอลจีเรีย)","(name:tg,Алҷазоир)","(name:te,అల్జీరియా)","(name:ta,அல்சீரியா)","(name:szl,Algeryjo)","(name:sw,Algeria)","(name:sv,Algeriet)","(name:stq,Algerien)","(name:sr,Алжир)","(name:sq,Algjeria)","(name:so,Aljeeriya)","(name:sm,Algeria)","(name:sl,Alžirija)","(name:sk,Alžírsko)","(name:simple,Algeria)","(name:sh,Alžir)","(name:se,Algeria)","(name:scn,Algirìa)","(name:sc,Algerìa)","(name:sah,Алжир)","(name:sa,अल्जीरिया)","(name:ru,Алжир)","(name:ro,Algeria)","(name:rm,Algeria)","(name:qu,Alhirya)","(name:pt,Argélia)","(name:ps,الجېريا)","(name:pnb,الجزائر)","(name:pms,Algerìa)","(name:pl,Algieria)","(name:pih,Algeria)","(name:pdc,Altschieri)","(name:pap,Algeria)","(name:pam,Algeria)","(name:os,Алжир)","(name:oc,Argeria)","(name:nov,Algeria)","(name:no,Algerie)","(name:nn,Algerie)","(name:nl,Algerije)","(name:nds,Algerien)","(name:nah,Argelia)","(name:na,Algeria)","(name:mzn,الجزایر)","(name:mt,Alġerija)","(name:ms,Algeria)","(name:mr,अल्जीरिया)","(name:mn,Алжир)","(name:ml,അള്‍ജീറിയ)","(name:mk,Алжир)","(name:mg,Aljeria)","(name:lv,Alžīrija)","(name:lt,Alžyras)","(name:ln,Aljeria)","(name:lmo,Algeria)","(name:lij,Algeïa)","(name:li,Algerieë)","(name:lb,Algerien)","(name:lad,Arjelia)","(name:la,Algerium)","(name:ky,Алжир)","(name:kw,Aljeri)","(name:ku,Alcerya)","(name:ksh,Alljeerije)","(name:ko,알제리)","(name:kn,ಅಲ್ಜೀರಿಯ)","(name:kg,Djazairia)","(name:kab,Dzayer)","(name:ka,ალჟირი)","(name:jv,Aljazair)","(name:jbo,jexygu'e)","(name:ja,アルジェリア)","(name:it,Algeria)","(name:is,Alsír)","(name:io,Aljeria)","(name:ie,Algeria)","(name:id,Aljazair)","(name:ia,Algeria)","(name:hy,Ալժիր)","(name:hu,Algéria)","(name:ht,Aljeri)","(name:hsb,Algeriska)","(name:hr,Alžir)","(name:hif,Algeria)","(name:hi,अल्जीरिया)","(name:he,אלג'יר)","(name:haw,‘Alekelia)","(name:ha,Aljeriya)","(name:gv,\\"Yn Algear\\")","(name:gl,Alxeria)","(name:gd,Aildiria)","(name:ga,\\"An Ailgéir\\")","(name:fy,Algerije)","(name:frp,Alg·èrie)","(name:fr,Algérie)","(name:fiu-vro,Alžeeriä)","(name:fi,Algeria)","(name:fa,الجزایر)","(name:ext,Argélia)","(name:eu,Aljeria)","(name:et,Alžiir)","(name:es,Argelia)","(name:eo,Alĝerio)","(name:en,Algeria)","(name:el,Αλγερία)","(name:dz,ཨལ་ཇི་རི་ཡ།)","(name:dv,ޖަޒާއިރު)","(name:dsb,Algeriska)","(name:diq,Cezayir)","(name:de,Algerien)","(name:da,Algeriet)","(name:cy,Algeria)","(name:cv,Алжир)","(name:cs,Alžírsko)","(name:crh,Cezair)","(name:ceb,Algeria)","(name:ca,Algeria)","(name:bs,Alžir)","(name:br,Aljeria)","(name:bpy,আলজেরিয়া)","(name:bo,ཨར་གེ་རི་ཡ)","(name:bn,আলজেরিয়া)","(name:bm,Aljeri)","(name:bg,Алжир)","(name:ber,\\"ⴷⵥⴰⵢⴻⵔ (Dzayer)\\")","(name:be,Алжыр)","(name:bcl,Algerya)","(name:bat-smg,Alžīrs)","(name:az,Əlcəzair)","(name:ast,Arxelia)","(name:arz,الجزاير)","(name:arc,ܓܙܐܝܪ)","(name:ar,الجزائر)","(name:ang,Algeria)","(name:an,Alcheria)","(name:am,አልጄሪያ)","(name:als,Algerie)","(name:af,Algerië)","(name,الجزائر)"}	\N
ag	{"(name:zh,安提瓜和巴布达)","(name:vi,\\"Antigua và Barbuda\\")","(name:uk,\\"Антигуа і Барбуда\\")","(name:tr,\\"Antigua ve Barbuda\\")","(name:th,ประเทศแอนติกาและบาร์บูดา)","(name:sv,\\"Antigua och Barbuda\\")","(name:sl,\\"Antigva in Barbuda\\")","(name:ru,\\"Антигуа и Барбуда\\")","(name:pt,\\"Antígua e Barbuda\\")","(name:pl,\\"Antigua i Barbuda\\")","(name:no,\\"Antigua og Barbuda\\")","(name:nn,\\"Antigua og Barbuda\\")","(name:nl,\\"Antigua en Barbuda\\")","(name:nb,\\"Antigua og Barbuda\\")","(name:mn,\\"Антигуа ба Барбуда\\")","(name:lv,\\"Antigva un Barbuda\\")","(name:lt,\\"Antigva ir Barbuda\\")","(name:li,\\"Antigua en Barbuda\\")","(name:lb,\\"Antigua a Barbuda\\")","(name:la,\\"Antiqua et Barbuda\\")","(name:it,\\"Antigua e Barbuda\\")","(name:is,\\"Antígva og Barbúda\\")","(name:id,\\"Antigua dan Barbuda\\")","(name:hu,\\"Antigua és Barbuda\\")","(name:hr,\\"Antigva i Barbuda\\")","(name:he,\\"אנטיגואה וברבודה\\")","(name:gd,\\"Antigua agus Barbuda\\")","(name:ga,\\"Antigua agus Barbúda\\")","(name:fy,\\"Antigua en Barbûda\\")","(name:fr,Antigua-et-Barbuda)","(name:fi,\\"Antigua ja Barbuda\\")","(name:fa,\\"آنتیگوا و باربودا\\")","(name:eu,\\"Antigua eta Barbuda\\")","(name:et,\\"Antigua ja Barbuda\\")","(name:es,\\"Antigua y Barbuda\\")","(name:eo,Antigvo-Barbudo)","(name:en,\\"Antigua and Barbuda\\")","(name:el,\\"Αντίγκουα και Μπαρμπούντα\\")","(name:de,\\"Antigua und Barbuda\\")","(name:da,\\"Antigua og Barbuda\\")","(name:cy,\\"Antigua a Barbuda\\")","(name:ca,\\"Antigua i Barbuda\\")","(name:br,\\"Antigua ha Barbuda\\")","(name:be,\\"Антыгуа і Барбуда\\")","(name:az,\\"Antiqua və Barbuda\\")","(name:ar,\\"أنتيغوا وبربودا\\")","(name:af,\\"Antigua en Barbuda\\")","(name,\\"Antigua and Barbuda\\")"}	\N
fi	{"(official_name:vi,\\"Cộng hòa Phần Lan\\")","(official_name:sv,\\"Republiken Finland\\")","(official_name:sk,\\"Fínska republika\\")","(official_name:ru,\\"Финляндская Республика\\")","(official_name:pt,\\"República da Finlândia\\")","(official_name:no,\\"Republikken Finland\\")","(official_name:nn,\\"Republikken Finland\\")","(official_name:lt,\\"Suomijos Respublika\\")","(official_name:ja,フィンランド共和国)","(official_name:it,\\"Repubblica di Finlandia\\")","(official_name:is,\\"Lýðveldið Finnland\\")","(official_name:id,\\"Republik Finlandia\\")","(official_name:fr,\\"République de Finlande\\")","(official_name:fi,\\"Suomen tasavalta\\")","(official_name:et,\\"Soome Vabariik\\")","(official_name:es,\\"República de Finlandia\\")","(official_name:en,\\"Republic of Finland\\")","(official_name:el,\\"Δημοκρατία της Φινλανδίας\\")","(official_name:de,\\"Republik Finnland\\")","(official_name:da,\\"Repbulikken Finland\\")","(official_name:be,\\"Фінляндская Рэспубліка\\")","(official_name,\\"Suomen tasavalta\\")","(name:zh_pyt,Fēnlán)","(name:zh_py,Fenlan)","(name:zh-min-nan,Suomi)","(name:zh,芬兰)","(name:zea,Finland)","(name:yo,Finlandi)","(name:yi,פינלאנד)","(name:wo,Finlaand)","(name:war,Finlandya)","(name:wa,Finlande)","(name:vo,Suomiyän)","(name:vls,Finland)","(name:vi,\\"Phần Lan\\")","(name:vec,Finlandia)","(name:uz,Finlandiya)","(name:ur,\\"فن لینڈ\\")","(name:uk,Фінляндія)","(name:ug,فىنلاندىيە)","(name:udm,Финляндия)","(name:tt,Finlândiä)","(name:tr,Finlandiya)","(name:tpi,Pinlan)","(name:tl,Pinlandiya)","(name:th,ประเทศฟินแลนด์)","(name:tg,Финланд)","(name:tet,Finlándia)","(name:te,ఫిన్లెండ్)","(name:ta,பின்லாந்து)","(name:szl,Finlandyjo)","(name:sw,Ufini)","(name:sv,Finland)","(name:stq,Finlound)","(name:sr,Финска)","(name:sq,Finlanda)","(name:so,Finland)","(name:sm,Finalagi)","(name:sl,Finska)","(name:sk,Fínsko)","(name:sh,Finska)","(name:se,Suopma)","(name:sco,Finland)","(name:scn,Finlandia)","(name:sc,Finlandia)","(name:sah,Финляндия)","(name:sa,फिन्लैंड)","(name:ru,Финляндия)","(name:roa-rup,Finlanda)","(name:ro,Finlanda)","(name:rmy,Finland)","(name:rm,Finlanda)","(name:qu,Phinsuyu)","(name:pt,Finlândia)","(name:pnt,Φινλανδία)","(name:pms,Finlandia)","(name:pl,Finlandia)","(name:pih,Finland)","(name:pam,Finland)","(name:os,Финлянди)","(name:oc,Finlàndia)","(name:nrm,Fînlande)","(name:nov,Finlande)","(name:no,Finland)","(name:nn,Finland)","(name:nl,Finland)","(name:new,फिनल्यान्ड)","(name:ne,फिनल्याण्ड)","(name:nds-nl,Finlaand)","(name:nds,Finnland)","(name:nah,Fintlālpan)","(name:na,Finland)","(name:myv,\\"Суоми Мастор\\")","(name:mt,Finlandja)","(name:ms,Finland)","(name:mn,Финлянд)","(name:mk,Финска)","(name:mhr,\\"Суоми Эл\\")","(name:mdf,\\"Суоми мастор\\")","(name:lv,Somija)","(name:lt,Suomija)","(name:ln,Finilanda)","(name:lmo,Finlandia)","(name:lij,Finlandia)","(name:li,Finland)","(name:lg,Finilandi)","(name:lb,Finnland)","(name:la,Finnia)","(name:ky,Финляндия)","(name:kw,\\"Pow Finn\\")","(name:kv,Финляндия)","(name:ku,Fînland)","(name:ksh,Finnlandt)","(name:ks,फिन्लैंड)","(name:ko,핀란드)","(name:kl,Finlandi)","(name:kk,Финландия)","(name:ka,ფინეთი)","(name:jbo,finland)","(name:ja,フィンランド)","(name:it,Finlandia)","(name:is,Finnland)","(name:io,Finlando)","(name:ilo,Finlandia)","(name:ie,Finland)","(name:id,Finlandia)","(name:ia,Finlandia)","(name:hy,Ֆինլանդիա)","(name:hu,Finnország)","(name:ht,Fenlann)","(name:hsb,Finska)","(name:hr,Finska)","(name:hif,Finland)","(name:hi,फ़िनलैंड)","(name:he,פינלנד)","(name:haw,Pinilana)","(name:hak,Fûn-làn)","(name:gv,Finnlynn)","(name:gn,Hĩlandia)","(name:gl,Finlandia)","(name:gd,Suòmaidh)","(name:gan,芬蘭)","(name:ga,\\"An Fhionlainn\\")","(name:fy,Finlân)","(name:fur,Finlande)","(name:frp,Finlande)","(name:fr,Finlande)","(name:fo,Finnland)","(name:fiu-vro,Soomõ)","(name:fi,Suomi)","(name:fa,فنلاند)","(name:eu,Finlandia)","(name:et,Soome)","(name:es,Finlandia)","(name:eo,Finnlando)","(name:en,Finland)","(name:el,Φινλανδία)","(name:ee,Finland)","(name:dz,ཕིན་ལེནཌ་)","(name:dv,ފިންލޭންޑު)","(name:dsb,Finska)","(name:diq,Finlanda)","(name:de,Finnland)","(name:da,Finland)","(name:cy,\\"Y Ffindir\\")","(name:cv,Финлянди)","(name:cu,Соумь)","(name:csb,Fińskô)","(name:cs,Finsko)","(name:crh,Finlandiya)","(name:co,Finlandia)","(name:ceb,Finlandia)","(name:ce,Финлянди)","(name:ca,Finlàndia)","(name:bs,Finska)","(name:br,Finland)","(name:bpy,ফিনল্যান্ড)","(name:bo,ཧྥིན་ལན)","(name:bn,ফিনল্যান্ড)","(name:bm,Finland)","(name:bg,Финландия)","(name:be,Фінляндыя)","(name:bcl,Finlandya)","(name:bat-smg,Soumėjė)","(name:bar,Finnlånd)","(name:az,Finlandiya)","(name:ast,Finlandia)","(name:arc,ܦܢܠܢܕܐ)","(name:ar,فنلندا)","(name:ang,Finnland)","(name:an,Finlandia)","(name:am,ፊንላንድ)","(name:als,Finnland)","(name:af,Finland)","(name,Suomi)"}	\N
ge	{"(official_name:pt,\\"República da Geórgia\\")","(name:zh-yue,格魯吉亞)","(name:zh_pyt,Qiáozhìyà)","(name:zh_py,Qiaozhiya)","(name:zh-min-nan,Sakartvelo)","(name:zh,乔治亚)","(name:zea,Georhië)","(name:yo,Georgia)","(name:xal,\\"Гүрҗмүдн Орн Нутг\\")","(name:wuu,格鲁吉亚)","(name:wo,Jeoorji)","(name:war,Georgia)","(name:vo,Grusiyän)","(name:vi,Gruzia)","(name:uz,Gurjiston)","(name:ur,جارجیا)","(name:uk,Грузія)","(name:ug,گرۇزىيە)","(name:udm,Грузия)","(name:tt,Грузия)","(name:tr,Gürcistan)","(name:tl,Georgia)","(name:tk,Gruziýa)","(name:th,ประเทศจอร์เจีย)","(name:tg,Гурҷистон)","(name:te,జార్జియా)","(name:ta,சியார்சியா)","(name:szl,Gruzyjo)","(name:sw,Georgia)","(name:sv,Georgien)","(name:sr,Грузија)","(name:sq,Gjeorgjia)","(name:sl,Gruzija)","(name:sk,Gruzínsko)","(name:simple,Georgia)","(name:sh,Gruzija)","(name:se,Georgia)","(name:sco,Georgie)","(name:scn,Giorgia)","(name:sah,Грузия)","(name:ru,Грузия)","(name:ro,Georgia)","(name:qu,Kartulsuyu)","(name:pt,Geórgia)","(name:ps,جيورجيا)","(name:pnt,Γρουζία)","(name:pms,Geòrgia)","(name:pl,Gruzja)","(name:pih,Jorja)","(name:pam,Georgia)","(name:os,Гуырдзыстон)","(name:oc,Georgia)","(name:nov,Georgia)","(name:no,Georgia)","(name:nn,Georgia)","(name:nl,Georgië)","(name:new,ज्योर्जिया)","(name:nds,Georgien)","(name:na,Georgia)","(name:mzn,گورجئون)","(name:mt,Ġeorġja)","(name:ms,Georgia)","(name:mr,जॉर्जिया)","(name:mn,Гүрж)","(name:ml,ജോര്‍ജ്ജിയ)","(name:mk,Грузија)","(name:lv,Gruzija)","(name:lt,Gruzija)","(name:lmo,Georgia)","(name:lij,Geòrgia)","(name:li,Georgië)","(name:lb,Georgien)","(name:la,Georgia)","(name:ky,Грузия)","(name:kw,\\"Pow Grouzi\\")","(name:kv,Грузия)","(name:ku,Gurcistan)","(name:ksh,Gejorgije)","(name:ko,그루지야)","(name:kk,Гүржістан)","(name:ka,საქართველო)","(name:jv,Georgia)","(name:ja,グルジア)","(name:it,Georgia)","(name:is,Georgía)","(name:io,Georgia)","(name:ilo,Georgia)","(name:ie,Georgia)","(name:id,Georgia)","(name:ia,Georgia)","(name:hy,Վրաստան)","(name:hu,Grúzia)","(name:ht,Jeoji)","(name:hsb,Georgiska)","(name:hr,Gruzija)","(name:hif,Georgia)","(name:hi,जोर्जिया)","(name:he,גיאורגיה)","(name:haw,Keokia)","(name:gv,\\"Yn Çhorshey\\")","(name:gl,Xeorxia)","(name:gd,Gruisia)","(name:ga,\\"An tSeoirsia\\")","(name:fy,Geörgje)","(name:frp,Jôrg·ie)","(name:fr,Géorgie)","(name:fo,Georgia)","(name:fiu-vro,Gruusia)","(name:fi,Georgia)","(name:fa,گرجستان)","(name:eu,Georgia)","(name:et,Gruusia)","(name:es,Georgia)","(name:eo,Kartvelio)","(name:en,Georgia)","(name:el,Γεωργία)","(name:ee,Georgia)","(name:dsb,Georgiska)","(name:diq,Gurcıstan)","(name:de,Georgien)","(name:da,Georgien)","(name:cy,Georgia)","(name:cv,Грузи)","(name:cu,Гєѡргі́ꙗ)","(name:csb,Grëzóńskô)","(name:cs,Gruzie)","(name:crh,Gürcistan)","(name:ceb,Georgia)","(name:ca,Geòrgia)","(name:bs,Gruzija)","(name:br,Jorjia)","(name:bn,জর্জিয়া)","(name:bg,Грузия)","(name:be-x-old,Грузія)","(name:be,Грузія)","(name:bat-smg,Grozėjė)","(name:az,Gürcüstan)","(name:av,Гуржи)","(name:ast,Xorxa)","(name:arz,جورجيا)","(name:arc,ܓܘܪܓܝܐ)","(name:ar,جورجيا)","(name:an,Cheorchia)","(name:als,Georgie)","(name:af,Georgië)","(name:ab,\\"Қырҭтәыла Аҳәынҭқарра\\")","(name,\\"Georgia / საქართველო\\")"}	\N
gr	{"(official_name:vi,\\"Cộng hòa Hy Lạp\\")","(official_name:sv,\\"Republiken Grekland\\")","(official_name:sk,\\"Grécka republika\\")","(official_name:pt,\\"República Helênica\\")","(official_name:lt,\\"Graikijos Respublika\\")","(official_name:lb,\\"Hellenesch Republik\\")","(official_name:ja,ギリシャ共和国)","(official_name:it,\\"Repubblica Ellenica\\")","(official_name:id,\\"Republik Hellenik\\")","(official_name:et,\\"Kreeka Vabariik\\")","(official_name:br,\\"Republik hellenek\\")","(official_name:am,\\"የግሪክ ዲሞክራሲ\\")","(official_name,\\"Ελληνική Δημοκρατία\\")","(name:zu,IGrisi)","(name:zh-yue,希臘)","(name:zh_pyt,Xīlà)","(name:zh_py,Xila)","(name:zh-min-nan,Hi-lia̍p)","(name:zh-classical,希臘共和國)","(name:zh,希腊)","(name:yo,Gréésì)","(name:yi,גריכנלאנד)","(name:xal,\\"Эллинмүдн Орн Нутг\\")","(name:wuu,希腊)","(name:wo,Girees)","(name:war,Gresya)","(name:vo,Grikän)","(name:vi,\\"Hy Lạp\\")","(name:vec,Gresia)","(name:uz,Yunoniston)","(name:ur,یونان)","(name:uk,Греція)","(name:ug,Grétsiye)","(name:udm,Греция)","(name:tt,Греция)","(name:tr,Yunanistan)","(name:tpi,Gris)","(name:tl,Gresya)","(name:tk,Gresiýa)","(name:th,ประเทศกรีซ)","(name:tg,Юнон)","(name:tet,Grésia)","(name:te,గ్రీస్)","(name:ta,\\"கிரேக்க நாடு\\")","(name:szl,Grecyjo)","(name:sw,Ugiriki)","(name:sv,Grekland)","(name:stq,Griechenlound)","(name:sr,Грчка)","(name:sq,Greqia)","(name:so,Giriig)","(name:sl,Grčija)","(name:sk,Grécko)","(name:simple,Greece)","(name:sh,Grčka)","(name:se,Greika)","(name:sco,Greece)","(name:scn,Grecia)","(name:sah,Греция)","(name:sa,ग्रीस)","(name:rw,Ubugereki)","(name:ru,Греция)","(name:roa-rup,Gãrtsia)","(name:ro,Grecia)","(name:rm,Grezia)","(name:qu,Grisya)","(name:pt,Grécia)","(name:ps,يونان)","(name:pnt,Ελλάδα)","(name:pms,Grecia)","(name:pl,Grecja)","(name:pih,Griese)","(name:pam,Greece)","(name:os,Грекъ)","(name:oc,Grècia)","(name:nrm,Grêce)","(name:nov,Grekia)","(name:no,Hellas)","(name:nn,Hellas)","(name:nl,Griekenland)","(name:ne,ग्रीस)","(name:nds-nl,Griekenlaand)","(name:nds,Grekenland)","(name:nap,Gracia)","(name:nah,Grecia)","(name:na,Greece)","(name:mt,Greċja)","(name:ms,Greece)","(name:mr,ग्रीस)","(name:mn,Грек)","(name:ml,ഗ്രീസ്)","(name:mk,Грција)","(name:mhr,Греций)","(name:mdf,Грекмастор)","(name:lv,Grieķija)","(name:lt,Graikija)","(name:ln,Gresi)","(name:lmo,Grecia)","(name:lij,Greçia)","(name:li,Griekeland)","(name:lg,Buyonaani)","(name:lb,Griicheland)","(name:lad,Gresia)","(name:la,Graecia)","(name:ky,Греция)","(name:kw,\\"Pow Grek\\")","(name:kv,Греция)","(name:ku,Yewnanistan)","(name:ko,그리스)","(name:kn,ಗ್ರೀಸ್)","(name:kk,Грекия)","(name:kg,Gelesi)","(name:ka,საბერძნეთი)","(name:jv,Yunani)","(name:jbo,xesygu'e)","(name:ja,ギリシャ)","(name:it,Grecia)","(name:is,Grikkland)","(name:io,Grekia)","(name:ilo,Grecia)","(name:ie,Grecia)","(name:id,Yunani)","(name:ia,Grecia)","(name:hy,Հունաստան)","(name:hu,Görögország)","(name:ht,Grès)","(name:hsb,Grjekska)","(name:hr,Grčka)","(name:hif,Greece)","(name:hi,यूनान)","(name:he,יוון)","(name:haw,Helene)","(name:hak,Hî-lia̍p)","(name:gv,\\"Yn Ghreag\\")","(name:gn,Gyresia)","(name:gl,Grecia)","(name:gd,\\"A' Ghrèig\\")","(name:gan,希臘)","(name:ga,\\"An Ghréig\\")","(name:fy,Grikelân)","(name:fur,Grecie)","(name:frp,Grèce)","(name:fr,Grèce)","(name:fo,Grikkaland)","(name:fiu-vro,Kreeka)","(name:fi,Kreikka)","(name:fa,یونان)","(name:ext,Grécia)","(name:eu,Grezia)","(name:et,Kreeka)","(name:es,Grecia)","(name:eo,Grekio)","(name:en,Greece)","(name:el,Ελλάδα)","(name:ee,Greece)","(name:dz,གིརིསི་)","(name:dv,ޔޫނާން)","(name:dsb,Grichiska)","(name:diq,Yunanıstan)","(name:de,Griechenland)","(name:da,Grækenland)","(name:cy,\\"Gwlad Groeg\\")","(name:cv,Греци)","(name:cu,Грьци)","(name:csb,Greckô)","(name:cs,Řecko)","(name:crh,Yunanistan)","(name:ceb,Gresya)","(name:ce,Джелтимохк)","(name:ca,Grècia)","(name:bs,Grčka)","(name:br,Gres)","(name:bpy,গ্রীস)","(name:bo,ཧི་ལ།)","(name:bn,গ্রীস)","(name:bg,Гърция)","(name:be-x-old,Грэцыя)","(name:be,Грэцыя)","(name:bcl,Gresya)","(name:bat-smg,Graikėjė)","(name:bar,Griachaland)","(name:az,Yunanıstan)","(name:ast,Grecia)","(name:arz,اليونان)","(name:arc,ܝܘܢ)","(name:ar,اليونان)","(name:ang,Crecaland)","(name:an,Grezia)","(name:am,ግሪክ)","(name:als,Griecheland)","(name:af,Griekeland)","(name,Ελλάδα)"}	\N
ma	{"(official_name:vi,\\"Vương quốc Maroc\\")","(official_name:sv,\\"Konungariket Marocko\\")","(official_name:lv,\\"Marokas Karaliste\\")","(official_name:lt,\\"Maroko Karalystė\\")","(official_name:lb,\\"Kinnekräich Marokko\\")","(official_name:id,\\"Kerajaan Maroko\\")","(official_name:fr,\\"Royaume du Maroc\\")","(official_name:et,\\"Maroko Kuningriik\\")","(official_name:en,\\"Kingdom of Morocco\\")","(official_name:el,\\"Βασίλειο του Μαρόκου\\")","(official_name:br,\\"Rouantelezh Maroko\\")","(official_name:be,\\"Каралеўства Марока\\")","(official_name,\\"المملكة المغربية\\")","(name:zh-yue,摩洛哥)","(name:zh_pyt,Móluògē)","(name:zh_py,Moluoge)","(name:zh-min-nan,Morocco)","(name:zh,摩洛哥)","(name:zea,Marokko)","(name:yo,Mòrókò)","(name:yi,מאראקא)","(name:wo,Marok)","(name:war,Morocco)","(name:wa,Marok)","(name:vo,Marokän)","(name:vi,Maroc)","(name:vec,Maroco)","(name:uz,Marokash)","(name:ur,مراکش)","(name:uk,Марокко)","(name:ug,ماراكەش)","(name:ts,Morocco)","(name:tr,Fas)","(name:tl,Morocco)","(name:ti,ሞሮኮ)","(name:th,ประเทศโมร็อกโก)","(name:tg,Марокаш)","(name:te,మొరాకో)","(name:ta,மொரோக்கோ)","(name:szl,Maroko)","(name:sw,Moroko)","(name:sv,Marocko)","(name:stq,Marokko)","(name:sr,Мароко)","(name:sq,Maroku)","(name:so,Maroc)","(name:sl,Maroko)","(name:sk,Maroko)","(name:simple,Morocco)","(name:sh,Maroko)","(name:se,Marokko)","(name:scn,Maroccu)","(name:sc,Marocu)","(name:sah,Марокко)","(name:sa,मोराको)","(name:ru,Марокко)","(name:ro,Maroc)","(name:qu,Maruku)","(name:pt,Marrocos)","(name:ps,ماراکو)","(name:pnb,مراکش)","(name:pms,Maròch)","(name:pl,Maroko)","(name:pam,Morocco)","(name:os,Марокко)","(name:oc,Marròc)","(name:nov,Moroko)","(name:no,Marokko)","(name:nn,Marokko)","(name:nl,Marokko)","(name:nds,Marokko)","(name:nah,Marruecos)","(name:mt,Marokk)","(name:ms,Maghribi)","(name:mr,मोरोक्को)","(name:mn,Марокко)","(name:ml,മൊറോക്കൊ)","(name:mk,Мароко)","(name:lv,Maroka)","(name:lt,Marokas)","(name:ln,Marɔkɛ)","(name:lmo,Maroch)","(name:lij,Maròcco)","(name:li,Marokko)","(name:lb,Marokko)","(name:lad,Marroko)","(name:la,Marocum)","(name:kw,Marokk)","(name:ku,Maroko)","(name:ks,मोराको)","(name:ko,모로코)","(name:kn,ಮೊರಾಕೊ)","(name:kk,Мағрибия)","(name:kg,Magribia)","(name:kab,Merruk)","(name:ka,მაროკო)","(name:jv,Maroko)","(name:jbo,morgu'e)","(name:ja,モロッコ)","(name:it,Marocco)","(name:is,Marrokkó)","(name:io,Maroko)","(name:ilo,Morocco)","(name:ie,Morocco)","(name:id,Maroko)","(name:ia,Morocco)","(name:hu,Marokkó)","(name:ht,Mawòk)","(name:hsb,Marokko)","(name:hr,Maroko)","(name:hif,Morocco)","(name:hi,मोरक्को)","(name:he,מרוקו)","(name:haw,Moloko)","(name:gv,\\"Yn Varoc\\")","(name:gl,Marrocos)","(name:gd,Maroco)","(name:ga,Maracó)","(name:fy,Marokko)","(name:frp,Maroc)","(name:fr,Maroc)","(name:fo,Marokko)","(name:fi,Marokko)","(name:fa,مراکش)","(name:ext,Marruecus)","(name:eu,Maroko)","(name:et,Maroko)","(name:es,Marruecos)","(name:eo,Maroko)","(name:en,Morocco)","(name:el,Μαρόκο)","(name:dv,މައުރިބު)","(name:diq,Fas)","(name:de,Marokko)","(name:da,Marokko)","(name:cy,Moroco)","(name:cv,Марокко)","(name:cs,Maroko)","(name:crh,Mağrip)","(name:ceb,Morocco)","(name:ca,Marroc)","(name:bs,Maroko)","(name:br,Maroko)","(name:bpy,মরক্কো)","(name:bo,མའེ་ལོ་ཀོ)","(name:bn,মরোক্কো)","(name:bm,Maroko)","(name:bg,Мароко)","(name:be-x-old,Марока)","(name:be,Марока)","(name:bcl,Moroko)","(name:bat-smg,Maruoks)","(name:az,Mərakeş)","(name:ast,Marruecos)","(name:arz,المغرب)","(name:arc,ܡܓܪܒ)","(name:ar,المغرب)","(name:ang,Morocco)","(name:an,Marruecos)","(name:am,ሞሮኮ)","(name:af,Marokko)","(name:ace,Maroko)","(name,Maroc)"}	\N
sr	{"(official_name:sv,\\"Republiken Surinam\\")","(official_name:pl,\\"Republika Surinam\\")","(official_name:lt,\\"Surinamo Respublika\\")","(official_name:lb,\\"Republik Suriname\\")","(official_name:id,\\"Republik Suriname\\")","(official_name:es,\\"República de Surinam\\")","(official_name:en,\\"Republic of Suriname\\")","(official_name:el,\\"Δημοκρατία του Σουρινάμ\\")","(official_name:be,\\"Рэспубліка Сурынам\\")","(official_name,\\"Republiek van Suriname\\")","(name:zh,苏里南)","(name:uk,Суринам)","(name:tr,Surinam)","(name:th,ประเทศซูรินาเม)","(name:sv,Surinam)","(name:sl,Surinam)","(name:ru,Суринам)","(name:pl,Surinam)","(name:mn,Суринам)","(name:lt,Surinamas)","(name:la,Surinamia)","(name:ja,スリナム)","(name:is,Súrínam)","(name:hy,Սուրինամ)","(name:hu,Suriname)","(name:hr,Surinam)","(name:he,סורינאם)","(name:gd,Suranam)","(name:ga,Suranam)","(name:fr,Suriname)","(name:fi,Suriname)","(name:fa,سورینام)","(name:es,Surinam)","(name:eo,Surinamo)","(name:en,Suriname)","(name:el,Σουρινάμ)","(name:da,Surinam)","(name:ca,Surinam)","(name:br,Surinam)","(name:be,Сурынам)","(name:ar,سورينام)","(name,Suriname)"}	\N
tw	{"(official_name:vi,\\"Trung Hoa Dân Quốc\\")","(official_name:pt,\\"República da China\\")","(official_name:pl,\\"Republika Chińska\\")","(official_name:lt,\\"Taivanas (Kinijos provincija)\\")","(official_name:lb,\\"Republik China\\")","(official_name:la,\\"Res publica Sinarum\\")","(official_name:it,\\"Repubblica di Cina\\")","(official_name:id,\\"Republik Cina\\")","(official_name:gd,\\"Poblachd na Sìne\\")","(official_name:et,\\"Hiina Vabariik\\")","(name:zh_pyt,Táiwān)","(name:zh_py,Taiwan)","(name:zh-Hant,台灣)","(name:zh-Hans,台湾)","(name:zh,台湾)","(name:vi,\\"Đài Loan\\")","(name:uk,Тайвань)","(name:tr,Tayvan)","(name:th,ไต้หวัน)","(name:sv,Taiwan)","(name:sl,Tajvan)","(name:ru,Тайвань)","(name:pt,\\"Taiwan; Formosa\\")","(name:pl,Tajwan)","(name:mn,Тайвань)","(name:lt,Taivanas)","(name:la,Taivania)","(name:ja,台湾)","(name:it,Taiwan)","(name:is,\\"Lýðveldið Kína\\")","(name:hu,Tajvan)","(name:hr,Tajvan)","(name:he,טייואן)","(name:gd,Tai-Bhàn)","(name:ga,\\"An Téaváin\\")","(name:fr,Taïwan)","(name:fi,Taiwan)","(name:fa,تایوان)","(name:eo,Tajvano)","(name:en,Taiwan)","(name:da,Taiwan)","(name:br,Taiwan)","(name:be,Тайвань)","(name:ar,تايوان)","(name,Taiwan)"}	\N
ph	{"(official_name:vi,\\"Cộng hoà Philippines\\")","(official_name:tl,\\"Republika ng Pilipinas\\")","(official_name:sv,\\"Republiken Filippinerna\\")","(official_name:pl,\\"Republika Filipin\\")","(official_name:lt,\\"Filipinų Respublika\\")","(official_name:lb,\\"Republik vu de Philippinen\\")","(official_name:it,\\"Repubblica delle Filippine\\")","(official_name:id,\\"Republik Filipina\\")","(official_name:en,\\"Republic of the Philippines\\")","(official_name:el,\\"Δημοκρατία των Φιλιππίνων\\")","(official_name:br,\\"Republik Filipinez\\")","(official_name,\\"Republic of the Philippines\\")","(name:zh_pyt,Fēilǜbīn)","(name:zh_py,Feilübin)","(name:zh,菲律宾)","(name:uk,Філіппіни)","(name:tr,Filipinler)","(name:tl,Pilipinas)","(name:th,ประเทศฟิลิปปินส์)","(name:sv,Filippinerna)","(name:sl,Filipini)","(name:ru,Филиппины)","(name:pl,Filipiny)","(name:nl,Filipijnen)","(name:mn,Филиппин)","(name:lv,Filipīnas)","(name:lt,Filipinai)","(name:li,\\"De Filipiene\\")","(name:lb,Philippinen)","(name:la,Philippinae)","(name:ja,フィリピン)","(name:it,Filippine)","(name:is,Filippseyjar)","(name:id,Filipina)","(name:hu,Fülöp-szigetek)","(name:hr,Filipini)","(name:he,פיליפינים)","(name:haw,\\"ʻĀina Pilipino\\")","(name:gd,\\"Na h-Eileanan Filipineach\\")","(name:ga,\\"Na hOileáin Fhilipíneacha\\")","(name:fy,\\"de Filipinen\\")","(name:fr,Philippines)","(name:fi,Filippiinit)","(name:fa,فیلیپین)","(name:es,Filipinas)","(name:eo,Filipinoj)","(name:el,Φιλιππίνες)","(name:de,Philippinen)","(name:da,Filippinerne)","(name:cy,Pilipinas)","(name:ca,Filipines)","(name:br,Filipinez)","(name:be,Філіпіны)","(name:ar,الفلبين)","(name:af,Filippyne)","(name,Philippines)"}	\N
it	{"(official_name:vi,\\"Cộng hoà Ý\\")","(official_name:sv,\\"Republiken Italien\\")","(official_name:sk,\\"Talianska republika\\")","(official_name:lt,\\"Italijos Respublika\\")","(official_name:lb,\\"Italienisch Republik\\")","(official_name:it,\\"Repubblica Italiana\\")","(official_name:id,\\"Republik Italia\\")","(official_name:fr,\\"République italienne\\")","(official_name:et,\\"Itaalia Vabariik\\")","(official_name:el,\\"Ιταλική Δημοκρατία\\")","(official_name:be,\\"Італьянская Рэспубліка\\")","(official_name,\\"Repubblica Italiana\\")","(name:zh_pyt,Yìdàlì)","(name:zh_py,Yidali)","(name:zh,意大利)","(name:vi,Ý)","(name:uk,Італія)","(name:tr,İtalya)","(name:th,ประเทศอิตาลี)","(name:sv,Italien)","(name:sl,Italija)","(name:sk,Taliansko)","(name:ru,Италия)","(name:pl,Włochy)","(name:nl,Italië)","(name:mn,Итали)","(name:lv,Itālija)","(name:lt,Italija)","(name:li,Italië)","(name:lb,Italien)","(name:ja,イタリア)","(name:it,Italia)","(name:is,Ítalía)","(name:hy,Իտալիա)","(name:hu,Olaszország)","(name:hr,Italija)","(name:he,איטליה)","(name:haw,ʻĪkālia)","(name:gd,\\"An Eadailt\\")","(name:ga,\\"An Iodáil\\")","(name:fy,Itaalje)","(name:fur,Italie)","(name:fr,Italie)","(name:fi,Italia)","(name:fa,ایتالیا)","(name:et,Itaalia)","(name:eo,Italio)","(name:en,Italy)","(name:el,Ιταλία)","(name:de,Italien)","(name:da,Italien)","(name:cy,\\"Yr Eidal\\")","(name:ca,Itàlia)","(name:br,Italia)","(name:be,Італія)","(name:ar,إيطاليا)","(name:af,Italië)","(name,Italia)"}	\N
af	{"(official_name:vi,\\"Cộng hòa Hồi giáo Afghanistan\\")","(official_name:sv,\\"Islamska republiken Afghanistan\\")","(official_name:pt,\\"República Islâmica do Afeganistão\\")","(official_name:pl,\\"Islamska Republika Afganistanu\\")","(official_name:lt,\\"Afganistano Islamo Respublika\\")","(official_name:ja,アフガニスタン・イスラム共和国)","(official_name:it,\\"Repubblica Islamica dell'Afghanistan\\")","(official_name:id,\\"Republik Islam Afganistan\\")","(official_name:fr,\\"République islamique d'Afghanistan\\")","(official_name:fi,\\"Afganistanin islamilainen tasavalta\\")","(official_name:et,\\"Afganistani Islamivabariik\\")","(official_name:el,\\"Ισλαμική Δημοκρατία του Αφγανιστάν\\")","(name:zh_pyt,Āfùhàn)","(name:zh_py,Afuhan)","(name:zh,阿富汗)","(name:uk,Афганістан)","(name:tr,Afganistan)","(name:th,ประเทศอัฟกานิสถาน)","(name:sv,Afghanistan)","(name:sl,Afganistan)","(name:ru,Афганистан)","(name:pt,Afeganistão)","(name:pl,Afganistan)","(name:mn,Афганистан)","(name:lv,Afganistāna)","(name:lt,Afganistanas)","(name:li,Afganistan)","(name:la,Afgania)","(name:ko,아프가니스탄)","(name:ka,ავღანეთი)","(name:ja,アフガニスタン)","(name:it,Afghanistan)","(name:is,Afganistan)","(name:id,Afganistan)","(name:hy,Աֆղանստան)","(name:hu,Afganisztán)","(name:hr,Afganistan)","(name:he,אפגניסטן)","(name:haw,‘Apekanikana)","(name:gd,Afganastan)","(name:ga,\\"An Afganastáin\\")","(name:fy,Afganistan)","(name:fr,Afghanistan)","(name:fi,Afganistan)","(name:fa,افغانستان)","(name:et,Afganistan)","(name:es,Afganistán)","(name:eo,Afganio)","(name:en,Afghanistan)","(name:el,Αφγανιστάν)","(name:da,Afghanistan)","(name:cs_ascii,Afganistan)","(name:cs,Afghánistán)","(name:ca,Afganistan)","(name:br,Afghanistan)","(name:bg,Афганистан)","(name:be,Аўганістан)","(name:az,Əfqanıstan)","(name:ar,أفغانستان)","(name,Afghanistan)"}	\N
es	{"(official_name:vi,\\"Vương quốc Tây Ban Nha\\")","(official_name:sv,\\"Konungariket Spanien\\")","(official_name:sk,\\"Španielske kráľovstvo\\")","(official_name:pt,\\"Reino de Espanha\\")","(official_name:pl,\\"Królestwo Hiszpanii\\")","(official_name:lt,\\"Ispanijos Karalystė\\")","(official_name:lb,\\"Kinneksräich Spuenien\\")","(official_name:id,\\"Kerajaan Spanyol\\")","(official_name:gd,\\"Rìoghachd na Spàinne\\")","(official_name:fr,\\"Royaume d’Espagne\\")","(official_name:en,\\"Kingdom of Spain\\")","(official_name:el,\\"Βασίλειο της Ισπανίας\\")","(official_name:be,\\"Каралеўства Іспанія\\")","(official_name,\\"Reino de España\\")","(name:zh_pyt,Xībānyá)","(name:zh_py,Xibanya)","(name:zh,西班牙)","(name:vi,\\"Tây Ban Nha\\")","(name:uk,Іспанія)","(name:tr,İspanya)","(name:tl,Espanya)","(name:th,ประเทศสเปน)","(name:sv,Spanien)","(name:sl,Španija)","(name:sk,Španielsko)","(name:ru,Испания)","(name:pt,Espanha)","(name:pl,Hiszpania)","(name:no,Spania)","(name:nn,Spania)","(name:nl,Spanje)","(name:nb,Spania)","(name:mn,Испани)","(name:lv,Spānija)","(name:lt,Ispanija)","(name:lb,Spuenien)","(name:la,Hispania)","(name:ja,スペイン)","(name:it,Spagna)","(name:is,Spánn)","(name:id,Spanyol)","(name:hy,Իսպանիա)","(name:hu,Spanyolország)","(name:hr,Španjolska)","(name:he,ספרד)","(name:haw,Sepania)","(name:gd,\\"An Spàinn\\")","(name:ga,\\"An Spáinn\\")","(name:fy,Spanje)","(name:fr,Espagne)","(name:fi,Espanja)","(name:fa,اسپانیا)","(name:eu,Espainia)","(name:et,Hispaania)","(name:es,España)","(name:eo,Hispanio)","(name:en,Spain)","(name:el,Ισπανία)","(name:de,Spanien)","(name:da,Spanien)","(name:cy,Sbaen)","(name:ca,Espanya)","(name:br,Spagn)","(name:be,Іспанія)","(name:ar,إسبانيا)","(name:af,Spanje)","(name,España)"}	\N
th	{"(official_name:th,ราชอาณาจักรไทย)","(official_name:sv,\\"Konungariket Thailand\\")","(official_name:pt,\\"Reino da Tailândia\\")","(official_name:pl,\\"Królestwo Tajlandii\\")","(official_name:lt,\\"Tailando Karalystė\\")","(official_name:lb,\\"Kinnekräich Thailand\\")","(official_name:it,\\"Regno di Thailandia\\")","(official_name:id,\\"Kerajaan Thailand\\")","(official_name:et,\\"Tai Kuningriik\\")","(official_name:el,\\"Βασίλειο της Ταϊλάνδης\\")","(official_name:af,\\"Koninkryk van Thailand\\")","(name:zh-yue,泰國)","(name:zh-min-nan,Thài-kok)","(name:zh-classical,泰國)","(name:zh,泰国)","(name:zea,Thailand)","(name:za,Daigoz)","(name:yo,Thailandi)","(name:wu,泰国)","(name:wo,Taaylaand)","(name:war,Thailand)","(name:vo,Tayän)","(name:vi,\\"Thái Lan\\")","(name:vec,Thailandia)","(name:ur,\\"تھائی لینڈ\\")","(name:uk,Таїланд)","(name:ug,تايلاند)","(name:udm,Таиланд)","(name:tr,Tayland)","(name:tl,Taylandiya)","(name:tk,Taýland)","(name:th,ประเทศไทย)","(name:tg,Таиланд)","(name:te,థాయిలాండ్)","(name:ta,தாய்லாந்து)","(name:szl,Tajlandyjo)","(name:sw,Uthai)","(name:sv,Thailand)","(name:su,Thailand)","(name:stq,Thailound)","(name:sr,Тајланд)","(name:sq,Tailanda)","(name:sl,Tajska)","(name:sk,Thajsko)","(name:sh,Tajland)","(name:se,Thaieana)","(name:scn,Thailandia)","(name:sah,Тайлаан)","(name:sa,थाइलैंड)","(name:ru,Таиланд)","(name:ro,Thailanda)","(name:qu,Thaysuyu)","(name:pt,Tailândia)","(name:ps,تايلېنډ)","(name:pnb,\\"تھائی لینڈ\\")","(name:pms,Thailandia)","(name:pl,Tajlandia)","(name:pih,Thailand)","(name:pap,Thailand)","(name:pam,Thailand)","(name:os,Таиланд)","(name:oc,Tailàndia)","(name:nov,Tailande)","(name:no,Thailand)","(name:nn,Thailand)","(name:nl,Thailand)","(name:ne,थाइलेडं)","(name:nds-nl,Thailaand)","(name:nds,Thailand)","(name:nah,Taitlālpan)","(name:my,ထိုင်းနိုင်ငံ)","(name:ms,Thailand)","(name:mr,थायलंड)","(name:mn,Тайланд)","(name:ml,തായ്‌ലാന്റ്)","(name:mk,Тајланд)","(name:mhr,Таиланд)","(name:mg,Thaïlande)","(name:map-bms,Thailand)","(name:lv,Taizeme)","(name:lt,Tailandas)","(name:lo,ປະເທດໄທ)","(name:lmo,Thailandia)","(name:lij,Thailandia)","(name:li,Thailand)","(name:lb,Thailand)","(name:la,Thailandia)","(name:kw,\\"Pow Tay\\")","(name:kv,Таиланд)","(name:ku,Tayland)","(name:ks,थाइलैंड)","(name:ko,타이)","(name:kn,ಥೈಲ್ಯಾಂಡ್)","(name:km,ថៃ)","(name:kk,Таиланд)","(name:ka,ტაილანდი)","(name:jv,Thailand)","(name:ja,タイ王国)","(name:it,Thailandia)","(name:is,Taíland)","(name:io,Tailando)","(name:ilo,Thailand)","(name:ie,Thailand)","(name:id,Thailand)","(name:ia,Thailanda)","(name:hu,Thaiföld)","(name:ht,Tayilann)","(name:hsb,Thailand)","(name:hr,Tajland)","(name:hif,Thailand)","(name:hi,थाईलैंड)","(name:he,תאילנד)","(name:haw,Tailani)","(name:hak,Thai-koet)","(name:gv,\\"Yn Çheer Thai\\")","(name:gu,થાઇલેન્ડ)","(name:gl,Tailandia)","(name:gd,Tài-lann)","(name:gan,泰國)","(name:ga,\\"An Téalainn\\")","(name:fy,Tailân)","(name:frp,Tayilande)","(name:fr,Thaïlande)","(name:fiu-vro,Tai)","(name:fi,Thaimaa)","(name:fa,تایلند)","(name:eu,Tailandia)","(name:et,Tai)","(name:es,Tailandia)","(name:eo,Tajlando)","(name:en,Thailand)","(name:el,Ταϊλάνδη)","(name:dz,ཐཱའི་ལེནཌ)","(name:dv,ސިޔާމު)","(name:diq,Tayland)","(name:de,Thailand)","(name:da,Thailand)","(name:cy,\\"Gwlad Thai\\")","(name:cv,Таиланд)","(name:cs,Thajsko)","(name:crh,Tayland)","(name:ceb,Thailand)","(name:ca,Tailàndia)","(name:bs,Tajland)","(name:br,Thailand)","(name:bpy,টাইলান্ডিয়া)","(name:bo,ཐའེ་གོ)","(name:bn,থাইল্যান্ড)","(name:bg,Тайланд)","(name:be-x-old,Тайлянд)","(name:be,Тайланд)","(name:bcl,Tailandya)","(name:bat-smg,Tailands)","(name:az,\\"Tayland Krallığı\\")","(name:ast,Tailandia)","(name:as,থাইলেণ্ড)","(name:arz,تايلاندا)","(name:ar,تايلاند)","(name:an,Tailandia)","(name:als,Thailand)","(name:af,Thailand)","(name:ace,Muangthai)","(name,ประเทศไทย)"}	\N
pt	{"(official_name:vi,\\"Cộng hòa Bồ Đào Nha\\")","(official_name:sv,\\"Republiken Portugal\\")","(official_name:sk,\\"Portugalská republika\\")","(official_name:pt,\\"República Portuguesa\\")","(official_name:pl,\\"Republika Portugalska\\")","(official_name:mwl,\\"República Pertuesa\\")","(official_name:lt,\\"Portugalijos Respublika\\")","(official_name:lb,\\"Portugiesesch Republik\\")","(official_name:id,\\"Republik Portugal\\")","(official_name:fr,\\"République portugaise\\")","(official_name:es,\\"República Portuguesa\\")","(official_name:en,\\"Portuguese Republic\\")","(official_name:el,\\"Πορτογαλική Δημοκρατία\\")","(official_name:br,\\"Republik Portugal\\")","(official_name:be,\\"Рэспубліка Партугалія\\")","(official_name,\\"República Portuguesa\\")","(name:zh_pyt,Pútáoyá)","(name:zh_py,Putaoya)","(name:zh,葡萄牙)","(name:vi,\\"Bồ Đào Nha\\")","(name:uk,Португалія)","(name:tr,Portekiz)","(name:th,ประเทศโปรตุเกส)","(name:sv,Portugal)","(name:sl,Portugalska)","(name:sk,Portugalsko)","(name:ru,Португалия)","(name:pl,Portugalia)","(name:mn,Португал)","(name:lv,Portugāle)","(name:lt,Portugalija)","(name:la,Lusitania)","(name:ja,ポルトガル)","(name:it,Portogallo)","(name:is,Portúgal)","(name:hy,Պորտուգալիա)","(name:hu,Portugália)","(name:he,פורטוגל)","(name:haw,Potugala)","(name:gd,\\"A' Phortagail\\")","(name:ga,\\"An Phortaingéil\\")","(name:fy,Portegal)","(name:fr,Portugal)","(name:fi,Portugali)","(name:fa,پرتغال)","(name:eo,Portugalio)","(name:en,Portugal)","(name:el,Πορτογαλία)","(name:cy,Portiwgal)","(name:br,Portugal)","(name:be,Партугалія)","(name:ar,البرتغال)","(name,Portugal)"}	\N
ad	{"(official_name:vi,\\"Công quốc Andorra\\")","(official_name:sv,\\"Furstendömet Andorra\\")","(official_name:sk,\\"Andorrské kniežatstvo\\")","(official_name:pt,\\"Principado de Andorra\\")","(official_name:lv,\\"Andoras Firstiste\\")","(official_name:lt,\\"Andoros Kunigaikštystė\\")","(official_name:la,\\"Principatus Andorrae\\")","(official_name:ja,アンドラ公国)","(official_name:id,\\"Kepangeranan Andorra\\")","(official_name:fr,\\"Principauté d'Andorre\\")","(official_name:fi,\\"Andorran ruhtinaskunta\\")","(official_name:el,\\"Πριγκηπάτο της Ανδόρρας\\")","(name:zh_pyt,Āndàoěr)","(name:zh_py,Andaoer)","(name:zh,安道尔)","(name:uk,Андора)","(name:th,ประเทศอันดอร์รา)","(name:sv,Andorra)","(name:sl,Andora)","(name:sk,Andorra)","(name:sco,Andorrae)","(name:ru,Андорра)","(name:pt,Andorra)","(name:pl,Andora)","(name:oc,Andòrra)","(name:mn,Андорра)","(name:lv,Andora)","(name:lt,Andora)","(name:ko,안도라)","(name:ka,ანდორა)","(name:ja,アンドラ)","(name:it,Andorra)","(name:is,Andorra)","(name:hy,Անդորրա)","(name:hu,Andorra)","(name:hr,Andora)","(name:he,אנדורה)","(name:haw,‘Anakola)","(name:ga,Andóra)","(name:fr,Andorre)","(name:fi,Andorra)","(name:fa,آندورا)","(name:eo,Andoro)","(name:el,Ανδόρρα)","(name:ca,Andorra)","(name:br,Andorra)","(name:bg,Андора)","(name:be,Андора)","(name:ar,أندورا)","(name,Andorra)"}	\N
si	{"(official_name:vi,\\"Cộng hòa Slovenia\\")","(official_name:sv,\\"Republiken Slovenien\\")","(official_name:sk,\\"Slovinská republika\\")","(official_name:pt,\\"República da Eslovênia\\")","(official_name:lt,\\"Slovėnijos Respublika\\")","(official_name:lb,\\"Republik Slowenien\\")","(official_name:id,\\"Republik Slovenia\\")","(official_name:et,\\"Sloveenia Vabariik\\")","(official_name:el,\\"Σλοβενική Δημοκρατία\\")","(name:zh_pyt,Sīluòwénníyà)","(name:zh_py,Siluowenniya)","(name:zh,斯洛文尼亚)","(name:vi,Slovenia)","(name:uk,Словенія)","(name:tr,Slovenya)","(name:th,ประเทศสโลวีเนีย)","(name:sv,Slovenien)","(name:sl,Slovenija)","(name:sk,Slovinsko)","(name:ru,Словения)","(name:pt,Eslovênia)","(name:ps,سلووېنيا)","(name:pl,Słowenia)","(name:nl,Slovenië)","(name:ne,स्लोभेनिया)","(name:mn,Словени)","(name:lt,Slovėnija)","(name:li,Slovenië)","(name:lb,Slowenien)","(name:la,Slovenia)","(name:it,Slovenia)","(name:is,Slóvenía)","(name:id,Slovenia)","(name:hu,Szlovénia)","(name:he,סלובניה)","(name:haw,Solowenia)","(name:gd,Sloibhìnia)","(name:ga,\\"An tSlóivéin\\")","(name:fy,Sloveenje)","(name:fr,Slovénie)","(name:fi,Slovenia)","(name:fa,اسلوونی)","(name:et,Sloveenia)","(name:es,Eslovenia)","(name:eo,Slovenio)","(name:en,Slovenia)","(name:el,Σλοβενία)","(name:ee,Sloveenia)","(name:de,Slowenien)","(name:da,Slovenien)","(name:cy,Slofenia)","(name:cs,Slovinsko)","(name:ca,Eslovènia)","(name:br,Slovenia)","(name:be,Славенія)","(name:ar,سلوفينيا)","(name:af,Slowenië)","(name,Slovenija)"}	\N
do	{"(official_name:pl,\\"Republika Dominikańska\\")","(name:zh,多明尼加共和國)","(name:vi,\\"Cộng hòa Dominicana\\")","(name:uk,\\"Домініканська Республіка\\")","(name:tr,\\"Dominik Cumhuriyeti\\")","(name:th,สาธารณรัฐโดมินิกัน)","(name:sv,\\"Dominikanska republiken\\")","(name:sl,\\"Dominikanska republika\\")","(name:ru,\\"Доминиканская Республика\\")","(name:pl,Dominikana)","(name:nl,\\"Dominicaanse Republiek\\")","(name:mn,\\"Доминиканы Бүгд Найрамдах Улс\\")","(name:lv,\\"Dominikānas Republika\\")","(name:lt,\\"Dominikos Respublika\\")","(name:li,\\"Dominicaanse Rippebliek\\")","(name:lb,\\"Dominikanesch Republik\\")","(name:la,\\"Respublica Dominicana\\")","(name:it,\\"Repubblica Dominicana\\")","(name:is,\\"Dóminíska lýðveldið\\")","(name:id,\\"Republik Dominika\\")","(name:hu,\\"Dominikai Köztársaság\\")","(name:hr,\\"Dominikanska Republika\\")","(name:he,דומיניק)","(name:gd,\\"Poblachd Dhoiminicia\\")","(name:ga,\\"An Phoblacht Dhoiminiceach\\")","(name:fy,\\"de Dominikaanske Republyk\\")","(name:fr,\\"République Dominicaine\\")","(name:fi,\\"Dominikaaninen tasavalta\\")","(name:fa,\\"جمهوری دومینیکن\\")","(name:et,\\"Dominikaani Vabariik\\")","(name:eo,Domingo)","(name:en,\\"Dominican Republic\\")","(name:el,\\"Δομινικανή Δημοκρατία\\")","(name:do,\\"República Dominicána\\")","(name:de,\\"Dominikanische Republik\\")","(name:da,\\"Dominikanske Republik\\")","(name:cy,\\"Gweriniaeth Dominica\\")","(name:br,\\"Republik Dominikan\\")","(name:ar,\\"الجمهورية الدومينيكية\\")","(name:af,\\"Dominikaanse Republiek\\")","(name,\\"República Dominicana\\")"}	\N
nz	{"(name:zh,新西兰)","(name:vi,\\"Tân Tây Lan\\")","(name:uk,\\"Нова Зеландія\\")","(name:tr,\\"Yeni Zelanda\\")","(name:th,ประเทศนิวซีแลนด์)","(name:sv,\\"Nya Zeeland\\")","(name:sl,\\"Nova Zelandija\\")","(name:ru,\\"Новая Зеландия\\")","(name:pl,\\"Nowa Zelandia\\")","(name:nl,Nieuw-Zeeland)","(name:mn,\\"Шинэ Зеланд\\")","(name:mi,Aotearoa)","(name:lv,Jaunzēlande)","(name:lt,\\"Naujoji Zelandija\\")","(name:li,Nui-Zieland)","(name:lb,Neiséiland)","(name:la,\\"Nova Zelandia\\")","(name:ja,ニュージーランド)","(name:it,\\"Nuova Zelanda\\")","(name:is,Nýja-Sjáland)","(name:id,\\"Selandia Baru\\")","(name:hy,\\"Նոր Զելանդիա\\")","(name:hu,Új-Zéland)","(name:hr,\\"Novi Zeland\\")","(name:he,\\"ניו זילנד\\")","(name:gd,\\"Sealainn Nuadh\\")","(name:ga,\\"An Nua-Shéalainn\\")","(name:fy,Nij-Seelân)","(name:fr,Nouvelle-Zélande)","(name:fi,Uusi-Seelanti)","(name:fa,نیوزیلند)","(name:et,Uus-Meremaa)","(name:es,\\"Nueva Zelanda\\")","(name:eo,Nov-Zelando)","(name:en,\\"New Zealand\\")","(name:el,\\"Νέα Ζηλανδία\\")","(name:de,Neuseeland)","(name:cy,\\"Seland Newydd\\")","(name:ca,\\"Nova Zelanda\\")","(name:br,\\"Zeland Nevez\\")","(name:be,\\"Новая Зеландыя\\")","(name:ar,نيوزيلندا)","(name:af,Nieu-Seeland)","(name,\\"New Zealand\\")"}	\N
am	{"(official_name:vi,\\"Cộng hoà Armenia\\")","(official_name:sv,\\"Republiken Armenien\\")","(official_name:pl,\\"Republika Armenii\\")","(official_name:lv,\\"Armēnijas Republika\\")","(official_name:lt,\\"Armėnijos Respublika\\")","(official_name:it,\\"Repubblica di Armenia\\")","(official_name:id,\\"Republik Armenia\\")","(official_name:fr,\\"République d'Arménie\\")","(official_name:fi,\\"Armenian tasavalta\\")","(official_name:el,\\"Δημοκρατία της Αρμενίας\\")","(official_name,\\"Republic of Armenia\\")","(name:zh_pyt,Yàměiníyà)","(name:zh_py,Yameiniya)","(name:zh,亚美尼亚)","(name:uk,Вірменія)","(name:tr,Ermenistan)","(name:th,ประเทศอาร์เมเนีย)","(name:sv,Armenien)","(name:sl,Armenija)","(name:ru,Армения)","(name:pt,Armênia)","(name:pl,Armenia)","(name:nl,Armenië)","(name:mn,Армен)","(name:lv,Armēnija)","(name:lt,Armėnija)","(name:li,Armenië)","(name:lb,Armenien)","(name:ja,アルメニア)","(name:it,Armenia)","(name:is,Armenía)","(name:hy,Հայաստան)","(name:hu,Örményország)","(name:he,ארמניה)","(name:haw,‘Āmēnia)","(name:gd,Airmeinia)","(name:ga,\\"An Airméin\\")","(name:fy,Armeenje)","(name:fr,Arménie)","(name:fi,Armenia)","(name:fa,ارمنستان)","(name:eo,Armenio)","(name:en,Armenia)","(name:el,Αρμενία)","(name:de,Armenien)","(name:da,Armenien)","(name:ca,Armènia)","(name:br,Armenia)","(name:be,Арменія)","(name:az,Ermənistan)","(name:ar,أرمينيا)","(name:af,Armenië)","(name,Armenia)"}	\N
ar	{"(official_name:vi,\\"Cộng hòa Argentina\\")","(official_name:sv,\\"Republiken Argentina\\")","(official_name:pt,\\"República Argentina\\")","(official_name:pl,\\"Republika Argentyńska\\")","(official_name:lv,\\"Argentīnas Republika\\")","(official_name:lt,\\"Argentinos Respublika\\")","(official_name:lb,\\"Republik Argentinien\\")","(official_name:id,\\"Republik Argentina\\")","(official_name:fr,\\"République argentine\\")","(official_name:fi,\\"Argentiinan tasavalta\\")","(official_name:en,\\"Argentine Republic\\")","(official_name:el,\\"Δημοκρατία της Αργεντινής\\")","(official_name,\\"República Argentina\\")","(name:zh,阿根廷)","(name:uk,\\" Аргентина\\")","(name:tr,Arjantin)","(name:th,ประเทศอาร์เจนตินา)","(name:sv,Argentina)","(name:sl,Argentina)","(name:ru,Аргентина)","(name:pt,Argentina)","(name:pl,Argentyna)","(name:nl,Argentinië)","(name:mn,Аргентин)","(name:lv,Argentīna)","(name:li,Argentinië)","(name:lb,Argentinien)","(name:ja,アルゼンチン)","(name:it,Argentina)","(name:is,Argentína)","(name:hy,Արգենտինա)","(name:hu,Argentína)","(name:he,ארגנטינה)","(name:haw,‘Alekina)","(name:gd,\\"An Argantain\\")","(name:ga,\\"An Airgintín\\")","(name:fy,Argentynje)","(name:fr,Argentine)","(name:fi,Argentiina)","(name:fa,آرژانتین)","(name:eo,Argentino)","(name:en,Argentina)","(name:el,Αργεντινή)","(name:de,Argentinien)","(name:cy,\\"Yr Ariannin\\")","(name:br,Arc’hantina)","(name:be,Аргенціна)","(name:ar,الأرجنتين)","(name:af,Argentinië)","(name,Argentina)"}	\N
bb	{"(name:zh,巴巴多斯)","(name:uk,Барбадос)","(name:th,ประเทศบาร์เบโดส)","(name:sv,Barbados)","(name:ru,Барбадос)","(name:pt,Barbados)","(name:pl,Barbados)","(name:mn,Барбадос)","(name:lv,Barbadosa)","(name:lt,Barbadosas)","(name:la,Barbata)","(name:ja,バルバドス)","(name:it,Barbados)","(name:is,Barbados)","(name:hu,Barbados)","(name:he,ברבדוס)","(name:ga,Barbadós)","(name:fr,Barbade)","(name:fi,Barbados)","(name:fa,باربادوس)","(name:es,Barbados)","(name:eo,Barbado)","(name:en,Barbados)","(name:el,Μπαρμπάντος)","(name:da,Barbados)","(name:br,Barbados)","(name:be,Барбадас)","(name:ar,بربادوس)","(name,Barbados)"}	\N
bf	{"(name:zh_pyt,Bùjīnàfǎsuǒ)","(name:zh_py,Bujinafasuo)","(name:zh,布基纳法索)","(name:uk,Буркіна-Фасо)","(name:th,ประเทศบูร์กินาฟาโซ)","(name:sv,\\"Burkina Faso\\")","(name:ru,Буркина-Фасо)","(name:pt,\\"Burkina Faso\\")","(name:pl,\\"Burkina Faso\\")","(name:mn,\\"Буркина Фасо\\")","(name:lv,Burkinafaso)","(name:lt,\\"Burkina Fasas\\")","(name:la,Burkina)","(name:ja,ブルキナファソ)","(name:it,\\"Burkina Faso\\")","(name:is,\\"Búrkína Fasó\\")","(name:hu,\\"Burkina Faso\\")","(name:he,\\"בורקינה פאסו\\")","(name:haw,\\"Burakina Faso\\")","(name:gd,\\"Buirciona Faso\\")","(name:ga,\\"Buircíne Fasó\\")","(name:fy,\\"Bûrkina Faso\\")","(name:fr,\\"Burkina Faso\\")","(name:fi,\\"Burkina Faso\\")","(name:fa,بورکینافاسو)","(name:es,\\"Burkina Faso\\")","(name:eo,Burkino)","(name:en,\\"Burkina Faso\\")","(name:el,\\"Μπουρκίνα Φάσο\\")","(name:da,\\"Burkina Faso\\")","(name:br,\\"Burkina Faso\\")","(name:be,Буркіна-Фасо)","(name:ar,\\"بوركينا فاصو\\")","(name:af,\\"Burkina Faso\\")","(name,\\"Burkina Faso\\")"}	\N
bs	{"(official_name:sv,\\"Samväldet Bahamas\\")","(official_name:pt,\\"Comunidade das Bahamas\\")","(official_name:pl,\\"Wspólnota Bahamów\\")","(official_name:lv,\\"Bahamu Salu Sadraudzība\\")","(official_name:lt,\\"Bahamų Sandrauga\\")","(official_name:it,\\"Commonwealth delle Bahamas\\")","(official_name:id,\\"Persemakmuran Bahama\\")","(official_name:fi,\\"Bahaman kansainyhteisö\\")","(official_name:el,\\"Κοινοπολιτεία των Μπαχαμών\\")","(official_name:be,\\"Садружнасць Багамскіх астравоў\\")","(official_name,\\"Commonwealth of The Bahamas\\")","(name:zh,巴哈马)","(name:uk,\\"Багамські Острови\\")","(name:tr,Bahamalar)","(name:th,ประเทศบาฮามาส)","(name:sv,Bahamas)","(name:sl,Bahami)","(name:ru,Багамы)","(name:pt,Bahamas)","(name:pl,Bahamy)","(name:nl,Bahama's)","(name:mn,\\"Багамын арлууд\\")","(name:lv,\\"Bahamu salas\\")","(name:lt,Bahamos)","(name:li,Bahama-eilen)","(name:la,\\"Insulae Bahamenses\\")","(name:it,Bahamas)","(name:is,Bahamaeyjar)","(name:id,Bahama)","(name:hu,Bahama-szigetek)","(name:hr,Bahami)","(name:he,בהמה)","(name:gd,\\"Na h-Eileanan Bhathama\\")","(name:ga,\\"Na Bahámaí\\")","(name:fy,\\"de Bahama's\\")","(name:fr,Bahamas)","(name:fi,Bahama)","(name:fa,باهاما)","(name:eu,Bahamak)","(name:et,Bahama)","(name:eo,Bahamoj)","(name:en,Bahamas)","(name:el,Μπαχάμες)","(name:cy,\\"Y Bahamas\\")","(name:ca,Bahames)","(name:br,Bahamas)","(name:be,Багамы)","(name:az,\\"Baham adaları\\")","(name:ar,\\"جزر البهاما\\")","(name,Bahamas)"}	\N
by	{"(official_name:vi,\\"Cộng hòa Belarus\\")","(official_name:sv,\\"Republiken Vitryssland\\")","(official_name:sk,\\"Bieloruská republika\\")","(official_name:ru,\\"Республика Беларусь\\")","(official_name:pt,\\"República da Bielorrússia\\")","(official_name:pl,\\"Republika Białoruska\\")","(official_name:lv,\\"Baltkrievijas Republika\\")","(official_name:id,\\"Republik Belarus\\")","(official_name:et,\\"Valgevene Vabariik\\")","(official_name:es,\\"República de Belarús\\")","(official_name:en,\\"Republic of Belarus\\")","(official_name:el,\\"Δημοκρατία της Λευκορωσίας\\")","(official_name:br,\\"Republik Belarus\\")","(official_name:be,\\"Рэспубліка Беларусь\\")","(official_name,\\"Рэспубліка Беларусь\\")","(name:zh-yue,白俄羅斯)","(name:zh_pyt,Báiéluósī)","(name:zh_py,Baieluosi)","(name:zh-min-nan,Belarus)","(name:zh,白俄罗斯)","(name:yi,בעלארוס)","(name:xal,\\"Цаганoрсн Орн Нутг\\")","(name:wuu,白俄罗斯)","(name:wo,Belaarus)","(name:war,Bielorrusya)","(name:vo,Belarusän)","(name:vi,Belarus)","(name:vec,Biełorusia)","(name:uz,Belarus)","(name:ur,بیلارس)","(name:uk,Білорусь)","(name:ug,بېلورۇسسىيە)","(name:udm,Белоруссия)","(name:tt,Беларусия)","(name:tr,\\"Beyaz Rusya\\")","(name:tpi,Belaras)","(name:tl,Belarus)","(name:tk,Belarus)","(name:th,ประเทศเบลารุส)","(name:tg,Беларус)","(name:te,బెలారస్)","(name:ta,பெலருஸ்)","(name:szl,Bjołoruś)","(name:sw,Belarus)","(name:sv,Vitryssland)","(name:sr,Белорусија)","(name:sq,Bjellorusia)","(name:sl,Belorusija)","(name:sk,Bielorusko)","(name:simple,Belarus)","(name:sh,Belorusija)","(name:se,Vilges-Ruošša)","(name:sco,Belaroushie)","(name:scn,Bielorussia)","(name:sah,Беларусь)","(name:sa,बेलारूस)","(name:ru,Беларусь)","(name:roa-rup,\\"Arusia albã\\")","(name:ro,Belarus)","(name:rmy,Belarus)","(name:rm,Bielorussia)","(name:qu,Bilarus)","(name:pt,Bielorrússia)","(name:ps,بېلاروسيه)","(name:pnb,بیلارس)","(name:pms,Bielorussia)","(name:pl,Białoruś)","(name:pih,Belerus)","(name:pam,Belarus)","(name:os,Белорусси)","(name:oc,Bielorussia)","(name:nov,Belarus)","(name:no,Hviterussland)","(name:nn,Kviterussland)","(name:nl,Wit-Rusland)","(name:new,बेलारुस)","(name:ne,बेलारुस)","(name:nds-nl,Wit-Ruslaand)","(name:nds,Wittrussland)","(name:nah,Belarus)","(name:na,Belarus)","(name:mt,Belarus)","(name:ms,Belarus)","(name:mr,बेलारूस)","(name:mn,Беларусь)","(name:ml,ബെലാറസ്)","(name:mk,Белорусија)","(name:lv,Baltkrievija)","(name:lt,Baltarusija)","(name:ln,Bielorusia)","(name:lij,Bieloruscia)","(name:li,Wit-Rusland)","(name:lb,Wäissrussland)","(name:la,\\"Ruthenia Alba\\")","(name:ky,Беларусь)","(name:kw,Belarussi)","(name:kv,Беларусь)","(name:ku,Bêlarûs)","(name:ko,벨라루스)","(name:kn,ಬೆಲಾರುಸ್)","(name:kk,Беларус)","(name:kg,Belarusia)","(name:ka,ბელარუსი)","(name:jv,Belarus)","(name:jbo,belrus)","(name:ja,ベラルーシ)","(name:it,Bielorussia)","(name:is,Hvíta-Rússland)","(name:io,Bielorusia)","(name:ilo,Belarus)","(name:ie,Bielorussia)","(name:id,Belarus)","(name:ia,Bielorussia)","(name:hy,Բելառուս)","(name:hu,Fehéroroszország)","(name:ht,Byelorisi)","(name:hsb,Běłoruska)","(name:hr,Bjelorusija)","(name:hif,Belarus)","(name:hi,बेलारूस)","(name:he,בלארוס)","(name:haw,Belarusa)","(name:hak,Pha̍k-ngò-lò-sṳ̂)","(name:gv,\\"Yn Velaroosh\\")","(name:gn,Vielorrusia)","(name:gl,Bielorrusia)","(name:gd,\\"A' Bhealaruis\\")","(name:ga,\\"An Bhealarúis\\")","(name:fy,Wyt-Ruslân)","(name:frp,Bièlorussie)","(name:fr,Biélorussie)","(name:fo,Hvítarussland)","(name:fiu-vro,Valgõvinne)","(name:fi,Valko-Venäjä)","(name:fa,بلاروس)","(name:eu,Bielorrusia)","(name:et,Valgevene)","(name:es,Bielorrusia)","(name:eo,Belorusio)","(name:en,Belarus)","(name:el,Λευκορωσία)","(name:ee,Belarus)","(name:dz,བེ་ལ་རུ་སུ།)","(name:dv,ބެލާރުސް)","(name:dsb,Běłoruska)","(name:diq,Belarus)","(name:de_CH,Weissrussland)","(name:de,Weißrussland)","(name:da,Hviderusland)","(name:cy,Belarws)","(name:cv,Белоруси)","(name:cu,\\"Бѣла́ Роу́сь\\")","(name:csb,Biôłorëskô)","(name:cs,Bělorusko)","(name:crh,Belarus)","(name:chr,ᏇᎳᎷᏒ)","(name:ceb,Belarus)","(name:ce,Белороссе)","(name:ca,Bielorússia)","(name:bxr,Белорос)","(name:bs,Bjelorusija)","(name:br,Belarus)","(name:bpy,বেলারুস)","(name:bn,বেলারুশ)","(name:bg,Беларус)","(name:be-x-old,Беларусь)","(name:be,Беларусь)","(name:bcl,Belarus)","(name:bat-smg,Baltarosėjė)","(name:az,Belorusiya)","(name:ast,Bielorrusia)","(name:arc,ܒܠܪܘܣ)","(name:ar,بيلاروس)","(name:ang,Belarus)","(name:an,Belarrusia)","(name:am,ቤላሩስ)","(name:als,Wiissrussland)","(name:af,Wit-Rusland)","(name,Беларусь)"}	\N
ck	{"(name:zh,库克群岛)","(name:vi,\\"Quần đảo Cook\\")","(name:uk,\\"Острови Кука\\")","(name:tr,\\"Cook Adaları\\")","(name:th,หมู่เกาะคุก)","(name:sv,Cooköarna)","(name:sl,\\"Cookovo otočje\\")","(name:ru,\\"Острова Кука\\")","(name:rar,\\"Kūki 'Āirani\\")","(name:pl,\\"Wyspy Cooka\\")","(name:nl,Cookeilanden)","(name:mn,\\"Күүкийн Арлууд\\")","(name:lv,\\"Kuka salas\\")","(name:lt,\\"Kuko salos\\")","(name:lb,Cookinseln)","(name:la,\\"Insulae Cook\\")","(name:it,\\"Isole Cook\\")","(name:is,Cooks-eyjar)","(name:id,\\"Kepulauan Cook\\")","(name:hu,Cook-szigetek)","(name:hr,\\"Cookovi otoci\\")","(name:he,\\"איי קוק\\")","(name:ga,\\"Oileáin Cook\\")","(name:fy,\\"de Cookeilannen\\")","(name:fr,\\"Îles Cook\\")","(name:fi,Cookinsaaret)","(name:fa,\\"جزایر کوک\\")","(name:eu,\\"Cook Uharteak\\")","(name:et,\\"Cooki saared\\")","(name:es,\\"Islas Cook\\")","(name:eo,Kukinsuloj)","(name:en,\\"Cook Islands\\")","(name:el,\\"Νήσοι Κουκ\\")","(name:de,Cookinseln)","(name:da,Cook-øerne)","(name:cy,\\"Ynysoedd Cook\\")","(name:ca,\\"Illes Cook\\")","(name:br,\\"Inizi Cook\\")","(name:be,\\"Астравы Кука\\")","(name:ar,\\"جزر كوك\\")","(name:af,Cookeilande)","(name,\\"Cook Islands\\")"}	\N
cu	{"(official_name:vi,\\"Cộng hòa Cuba\\")","(official_name:sv,\\"Republiken Kuba\\")","(official_name:pl,\\"Republika Kuby\\")","(official_name:lv,\\"Kubas Republika\\")","(official_name:lt,\\"Kubos Respublika\\")","(official_name:lb,\\"Republik Kuba\\")","(official_name:it,\\"Repubblica di Cuba\\")","(official_name:id,\\"Republik Kuba\\")","(official_name:gd,\\"Poblachd Chùba\\")","(official_name:et,\\"Kuuba Vabariik\\")","(official_name:en,\\"Republic of Cuba\\")","(official_name:el,\\"Δημοκρατία της Κούβας\\")","(official_name:be,\\"Рэспубліка Куба\\")","(official_name,\\"República de Cuba\\")","(name:zh,古巴)","(name:uk,Куба)","(name:tr,Küba)","(name:th,ประเทศคิวบา)","(name:sv,Kuba)","(name:sl,Kuba)","(name:ru,Куба)","(name:pl,Kuba)","(name:mn,Куба)","(name:lv,Kuba)","(name:lt,Kuba)","(name:lb,Kuba)","(name:ja,キューバ)","(name:it,Cuba)","(name:is,Kúba)","(name:id,Kuba)","(name:hy,Կուբա)","(name:hu,Kuba)","(name:hr,Kuba)","(name:he,קובה)","(name:gd,Cùba)","(name:ga,Cúba)","(name:fy,Kuba)","(name:fr,Cuba)","(name:fi,Kuuba)","(name:fa,کوبا)","(name:eu,Kuba)","(name:et,Kuuba)","(name:eo,Kubo)","(name:en,Cuba)","(name:el,Κούβα)","(name:de,Kuba)","(name:br,Kuba)","(name:be,Куба)","(name:ar,كوبا)","(name:af,Kuba)","(name,Cuba)"}	\N
dj	{"(official_name:vi,\\"Cộng hòa Djibouti\\")","(official_name:sv,\\"Republiken Djibouti\\")","(official_name:pt,\\"República do Djibuti\\")","(official_name:lv,\\"Džibutijas Republika\\")","(official_name:et,\\"Djibouti Vabariik\\")","(official_name:en,\\"Republic of Djibouti\\")","(official_name:el,\\"Δημοκρατία του Τζιμπουτί\\")","(official_name:br,\\"Republik Djibouti\\")","(official_name:af,\\"Republiek van Djiboeti\\")","(official_name,\\"جمهورية جيبوتي;République de Djibouti\\")","(name:zh_pyt,Jíbùtí)","(name:zh_py,Jibuti)","(name:zh,吉布提)","(name:vi,Djibouti)","(name:uk,Джибуті)","(name:tr,Cibuti)","(name:th,ประเทศจิบูตี)","(name:sv,Djibouti)","(name:sl,Džibuti)","(name:ru,Джибути)","(name:pt,Djibuti)","(name:pl,Dżibuti)","(name:nl,Djibouti)","(name:mn,Джибути)","(name:lv,Džibutija)","(name:lt,Džibutis)","(name:li,Djiboeti)","(name:lb,Dschibuti)","(name:la,Dzibutum)","(name:ja,ジブチ)","(name:it,Gibuti)","(name:is,Djíbútí)","(name:id,Djibouti)","(name:hu,Dzsibuti)","(name:hr,Džibuti)","(name:he,ג'יבוטי)","(name:haw,Dibuti)","(name:gd,Diobutaidh)","(name:ga,Diobúití)","(name:fy,Dzjibûty)","(name:fr,Djibouti)","(name:fi,Djibouti)","(name:fa,جیبوتی)","(name:et,Djibouti)","(name:es,Yibuti)","(name:eo,Ĝibutio)","(name:en,Djibouti)","(name:el,Τζιμπουτί)","(name:de,Dschibuti)","(name:da,Djibouti)","(name:ca,Djibouti)","(name:br,Djibouti)","(name:be,Джыбуці)","(name:ar,جيبوتي)","(name:af,Djiboeti)","(name,جيبوتي;Djibouti)"}	\N
gs	{"(name:zh,南喬治亞島與南桑威奇群島)","(name:wo,\\"Jeoorji gu Bëj-saalum ak Duni Islaand yi Bëj-saalum\\")","(name:vi,\\"Quần đảo Nam Georgia và Nam Sandwich\\")","(name:uk,\\"Південна Джорджія та Південні Сандвічеві острови\\")","(name:tr,\\"Güney Georgia ve Güney Sandwich Adaları\\")","(name:th,เกาะเซาท์จอร์เจียและหมู่เกาะเซาท์แซนด์วิช)","(name:ta,\\"தெற்கு யோர்சியா மற்றும் தெற்கு சண்ட்விச் தீவுகள்\\")","(name:sv,\\"Sydgeorgien och Sydsandwichöarna\\")","(name:sr,\\"Јужна Џорџија и Јужна Сендвичка Острва\\")","(name:sq,\\"Gjeorgjia Jugore dhe Ishujt Jugorë Sanduiç\\")","(name:sl,\\"Južna Georgia in Južni Sandwichevi otoki\\")","(name:simple,\\"South Georgia and the South Sandwich Islands\\")","(name:se,\\"Lulli Georgia ja Lulli Sandwich-sullot\\")","(name:sah,\\"Соҕуруу Георгия уонна Соҕуруу Сэндуич арыылара\\")","(name:ru,\\"Южная Джорджия и Южные Сандвичевы острова\\")","(name:ro,\\"Georgia de Sud şi Insulele Sandwich de Sud\\")","(name:pt,\\"Ilhas Geórgia do Sul e Sandwich do Sul\\")","(name:pl,\\"Georgia Południowa i Sandwich Południowy\\")","(name:os,\\"Хуссар Джорджи æмæ Хуссар Сандвичы сакъадæхтæ\\")","(name:nov,\\"Sud Georgia e li Sud Sandwich Isles\\")","(name:no,\\"Sør-Georgia og Sør-Sandwichøyene\\")","(name:nn,\\"Sør-Georgia og Sør-Sandwichøyane\\")","(name:nl,\\"Zuid-Georgië en de Zuidelijke Sandwicheilanden\\")","(name:ms,\\"Georgia Selatan dan Kepulauan Sandwich Selatan\\")","(name:mr,\\"साउथ जॉर्जिया व साउथ सँडविच द्वीपसमूह\\")","(name:lv,\\"Dienviddžordžija un Dienvidsendviču salas\\")","(name:lt,\\"Pietų Džordžija ir Pietų Sandvičo salos\\")","(name:lij,\\"Geòrgia do Sud e isoe Sandwich meridionæ\\")","(name:kw,\\"Jeorji Dheghow hag Ynysow Sandwich Deghow\\")","(name:ko,\\"사우스조지아 사우스샌드위치 제도\\")","(name:ja,サウスジョージア・サウスサンドウィッチ諸島)","(name:it,\\"Georgia del Sud e isole Sandwich meridionali\\")","(name:is,\\"Suður-Georgía og Suður-Sandvíkureyjar\\")","(name:id,\\"Georgia Selatan dan Kepulauan Sandwich Selatan\\")","(name:hu,\\"Déli-Georgia és Déli-Sandwich-szigetek\\")","(name:hr,\\"Južna Georgija i otočje Južni Sandwich\\")","(name:he,\\"איי ג'ורג'יה הדרומית ואיי סנדוויץ' הדרומיים\\")","(name:gl,\\"Illas Xeorxia do Sur e Sandwich do Sur\\")","(name:gd,\\"Seòirsia-a-Deas is na h-Eileanan Shandwich-a-Deas\\")","(name:fy,\\"Súd-Geörgje en de Súdlike Sandwicheilannen\\")","(name:fr,\\"Géorgie du Sud-et-les Îles Sandwich du Sud\\")","(name:fi,\\"Etelä-Georgia ja Eteläiset Sandwichsaaret\\")","(name:fa,\\"جزایر جورجیای جنوبی و ساندویچ جنوبی\\")","(name:eu,\\"Hegoaldeko Georgiak eta Hegoaldeko Sandwich uharteak\\")","(name:et,\\"Lõuna-Georgia ja Lõuna-Sandwichi saared\\")","(name:es,\\"Islas Georgias del Sur y Sandwich del Sur\\")","(name:eo,\\"Sud-Georgio kaj Sud-Sandviĉinsuloj\\")","(name:en,\\"South Georgia and South Sandwich Islands\\")","(name:el,\\"Νότιος Γεωργία και Νότιοι Σάντουιτς Νήσοι\\")","(name:dsb,\\"Pódpołdnjowa Georgiska a kupy Pódpołdnjowy Sandwich\\")","(name:de,\\"Südgeorgien und die Südlichen Sandwichinseln\\")","(name:da,\\"Sydgeorgien og Sydsandwichøerne\\")","(name:cs,\\"Jižní Georgie a Jižní Sandwichovy ostrovy\\")","(name:ca,\\"Illes Geòrgia del Sud i Sandwich del Sud\\")","(name:bs,\\"Južna Džordžija i Južna Sendvička Ostrva\\")","(name:br,\\"Jorjia ar Su hag Inizi Sandwich ar Su\\")","(name:bg,\\"Южна Джорджия и Южни Сандвичеви острови\\")","(name:be-x-old,\\"Паўднёвая Георгія і Паўднёвыя Сэндвічавыя выспы\\")","(name:be,\\"Паўднёвая Георгія і Паўднёвыя Сэндвічавы астравы\\")","(name:ar,\\"جزر جورجيا الجنوبية وساندويتش الجنوبية\\")","(name:af,\\"Suid-Georgië en die Suidelike Sandwich-eilande\\")","(name,\\"South Georgia and South Sandwich Islands\\")"}	\N
hu	{"(official_name:sv,\\"Republiken Ungern\\")","(official_name:sk,\\"Maďarská republika\\")","(official_name:ru,\\"Венге́рская Респу́блика\\")","(official_name:pl,\\"Republika Węgier\\")","(official_name:lv,\\"Ungārijas Republika\\")","(official_name:lt,\\"Vengrijos Respublika\\")","(official_name:lb,\\"Republik Ungarn\\")","(official_name:ja,ハンガリー共和国)","(official_name:it,\\"Repubblica d'Ungheria\\")","(official_name:id,\\"Republik Hongaria\\")","(official_name:fr,\\"République de Hongrie\\")","(official_name:et,\\"Ungari Vabariik\\")","(official_name:es,\\"República de Hungría\\")","(official_name:en,\\"Republic of Hungary\\")","(official_name:el,\\"Δημοκρατία της Ουγγαρίας\\")","(official_name,\\"Magyar Köztársaság\\")","(name:zh_pyt,Xiōngyálì)","(name:zh_py,Xiongyali)","(name:zh,匈牙利)","(name:vi,Hungary)","(name:uk,Угорщина)","(name:tr,Macaristan)","(name:th,ประเทศฮังการี)","(name:sv,Ungern)","(name:sl,Madžarska)","(name:sk,Maďarsko)","(name:ru,Венгрия)","(name:ro,Ungaria)","(name:pl,Węgry)","(name:nl,Hongarije)","(name:mn,Унгар)","(name:lv,Ungārija)","(name:lt,Vengrija)","(name:lb,Ungarn)","(name:la,Hungaria)","(name:ja,ハンガリー)","(name:it,Ungheria)","(name:is,Ungverjaland)","(name:id,Hongaria)","(name:hy,Հունգարիա)","(name:hu,Magyarország)","(name:hr,Madžarska)","(name:he,הונגריה)","(name:haw,Hunakalia)","(name:gd,\\"An Ungair\\")","(name:ga,\\"An Ungáir\\")","(name:fy,Hongarije)","(name:fr,Hongrie)","(name:fi,Unkari)","(name:fa,مجارستان)","(name:et,Ungari)","(name:es,Hungría)","(name:eo,Hungario)","(name:en,Hungary)","(name:el,Ουγγαρία)","(name:de,Ungarn)","(name:da,Ungarn)","(name:cy,Hwngari)","(name:ca,Hongria)","(name:br,Hungaria)","(name:be,Венгрыя)","(name:ar,هنغاريا)","(name:af,Hongarye)","(name,Magyarország)"}	\N
ie	{"(official_name:vi,\\"Cộng hòa Ireland\\")","(official_name:pl,\\"Republika Irlandii\\")","(official_name:la,\\"Hibernia (res publica)\\")","(official_name:ja,アイルランド共和国)","(official_name:it,\\"Repubblica d'Irlanda\\")","(official_name:id,\\"Republik Irlandia\\")","(official_name:es,\\"República de Irlanda\\")","(official_name:el,\\"Δημοκρατία της Ιρλανδίας\\")","(official_name:be,\\"Рэспубліка Ірландыя\\")","(official_name:af,\\"Republiek van Ierland\\")","(official_name,\\"Republic of Ireland\\")","(name:zh_pyt,Àiěrlán)","(name:zh_py,Aierlan)","(name:zh,爱尔兰)","(name:uk,Ірландія)","(name:tr,İrlanda)","(name:th,สาธารณรัฐไอร์แลนด์)","(name:sv,Irland)","(name:sl,Irska)","(name:sk,Írsko)","(name:ru,Ирландия)","(name:pl,Irlandia)","(name:nl,Ierland)","(name:mn,Ирланд)","(name:lv,Īrija)","(name:lt,Airija)","(name:li,Ierland)","(name:lb,Irland)","(name:la,Hibernia)","(name:ja,アイルランド)","(name:it,Irlanda)","(name:is,Írland)","(name:id,Irlandia)","(name:hu,Írország)","(name:hr,Irska)","(name:he,אירלנד)","(name:haw,‘Ilelani)","(name:gv,Nerin)","(name:gd,\\"Poblachd na h-Èireann\\")","(name:ga,Éire)","(name:fy,Ierlân)","(name:fr,Irlande)","(name:fi,Irlanti)","(name:fa,ایرلند)","(name:et,Iirimaa)","(name:es,Irlanda)","(name:eo,Irlando)","(name:en,Ireland)","(name:el,Ιρλανδία)","(name:de,Irland)","(name:da,Irland)","(name:cy,Iwerddon)","(name:ca,Irlanda)","(name:br,Iwerzhon)","(name:be,Ірландыя)","(name:ar,أيرلندا)","(name:af,Ierland)","(name,Ireland)"}	\N
km	{"(official_name:vi,\\"Liên bang Comoros\\")","(official_name:sv,\\"Unionen Komorerna\\")","(official_name:pt,\\"União das Comores\\")","(official_name:pl,\\"Związek Komorów\\")","(official_name:lv,\\"Komoru Islāma Federatīvā Republika\\")","(official_name:lt,\\"Komorų Sąjunga\\")","(official_name:id,\\"Perserikatan Komoro\\")","(official_name:es,\\"Unión de las Comoras\\")","(official_name:en,\\"Union of the Comoros\\")","(official_name:el,\\"Ένωση των Κομορών\\")","(official_name:ar,\\"الاتّحاد القمريّ\\")","(official_name,\\"Union des Comores;الاتحاد ﺍﻟﻘﻤﺮي;Udzima wa Komori\\")","(name:zh_pyt,Kēmóluò)","(name:zh_py,Kemoluo)","(name:zh,科摩洛)","(name:vi,Comoros)","(name:uk,\\"Коморські Острови\\")","(name:tr,Komorlar)","(name:th,ประเทศคอโมโรส)","(name:sv,Komorerna)","(name:sl,Komori)","(name:ru,Коморы)","(name:pt,Comores)","(name:pl,Komory)","(name:nl,Comoren)","(name:mn,\\"Коморын арлууд\\")","(name:lv,\\"Komoru salas\\")","(name:lt,Komorai)","(name:lb,Komoren)","(name:la,\\"Insulae Comorianae\\")","(name:ja,コモロ)","(name:it,Comore)","(name:is,Kómoreyjar)","(name:id,Komoro)","(name:hu,Comore-szigetek)","(name:hr,Komori)","(name:he,קומורו)","(name:haw,Komorosa)","(name:gd,Comòras)","(name:ga,\\"Oileáin Chomóra\\")","(name:fy,\\"de Komoaren\\")","(name:fr,Comores)","(name:fi,Komorit)","(name:fa,\\"مجمع‌الجزایر قمر\\")","(name:eu,Komoreak)","(name:et,Komoorid)","(name:es,Comoras)","(name:eo,Komoroj)","(name:en,Comoros)","(name:el,Κομόρες)","(name:de,Komoren)","(name:da,Comorerne)","(name:cy,Comoros)","(name:ca,Comores)","(name:br,Komorez)","(name:ar,\\"جزر القمر\\")","(name:af,Komore)","(name,Comores;ﺍﻟﻘﻤﺮي;Komori)"}	\N
kp	{"(official_name:vi,\\"Cộng hòa Dân chủ Nhân dân Triều Tiên\\")","(official_name:uz,\\"Koreya Xalq Demokratik Respublikasi\\")","(official_name:sv,\\"Demokratiska folkrepubliken Korea\\")","(official_name:sk,\\"Kórejská ľudovodemokratická republika\\")","(official_name:sh,\\"Demokratska Narodna Republika Koreja\\")","(official_name:ru,\\"Народно-Демократическая Республика Корея\\")","(official_name:pt,\\"República Democrática Popular da Coreia\\")","(official_name:pl,\\"Koreańska Republika Ludowo-Demokratyczna\\")","(official_name:os,\\"Корейы Адæмон Демократон Республикæ\\")","(official_name:mk,\\"Демократска Народна Република Кореја\\")","(official_name:lv,\\"Korejas Tautas Demokrātiskā Republika\\")","(official_name:lb,\\"Demokratesch Volleksrepublik Korea\\")","(official_name:la,\\"Respublica Popularis Democratica Coreana\\")","(official_name:ko,조선민주주의인민공화국)","(official_name:ja,朝鮮民主主義人民共和国)","(official_name:it,\\"Repubblica Democratica Popolare di Corea\\")","(official_name:id,\\"Republik Demokratik Rakyat Korea\\")","(official_name:hu,\\"Koreai Népi Demokratikus Köztársaság\\")","(official_name:et,\\"Korea Rahvademokraatlik Vabariik\\")","(official_name:es,\\"República Popular Democrática de Corea (RPDC)\\")","(official_name:en,\\"Democratic People's Republic of Korea (DPRK)\\")","(official_name:csb,\\"Kòrejańskô Lëdowò-Demokratnô Repùblika\\")","(official_name:ca,\\"República Popular Democràtica de Corea\\")","(official_name:br,\\"Republik Poblel ha Demokratel Korea\\")","(official_name,조선민주주의인민공화국)","(name:zh_pyt,Cháoxiǎn)","(name:zh_py,Chaoxian)","(name:zh-min-nan,Tiâu-sián)","(name:zh,朝鲜)","(name:yi,\\"צפון קארעע\\")","(name:wuu,朝鲜)","(name:wo,\\"Kore gu Bëj-gànnaar\\")","(name:war,\\"Amihanan nga Korea\\")","(name:vo,Nolüda-Koreyän)","(name:vi,\\"Triều Tiên\\")","(name:uz,\\"Shimoliy Korea\\")","(name:ur,\\"شمالی کوریا\\")","(name:uk,\\"Північна Корея\\")","(name:ug,\\"شىمالىي چاۋشيەن\\")","(name:udm,\\"Корея Калык-Демократи Республика\\")","(name:tr,\\"Kuzey Kore\\")","(name:tpi,\\"Not Koria\\")","(name:tl,\\"Hilagang Korea\\")","(name:tk,\\"Demirgazyk Koreýa\\")","(name:th,ประเทศเกาหลีเหนือ)","(name:tg,\\"Куриёи Шимолӣ\\")","(name:te,\\"ఉత్తర కొరియా\\")","(name:ta,வடகொரியா)","(name:szl,\\"Půłnocno Koryjo\\")","(name:sw,\\"Korea Kaskazini\\")","(name:sv,Nordkorea)","(name:su,\\"Koréa Kalér\\")","(name:sr,\\"Северна Кореја\\")","(name:sq,\\"Koreja e Veriut\\")","(name:sl,\\"Severna Koreja\\")","(name:sk,\\"Severná Kórea\\")","(name:simple,\\"North Korea\\")","(name:sh,\\"Sjeverna Koreja\\")","(name:se,Davvi-Korea)","(name:scn,\\"Corea dû Nord\\")","(name:sah,\\"Хоту Кэриэйэ\\")","(name:ru,\\"Северная Корея\\")","(name:ro,\\"Coreea de Nord\\")","(name:qu,\\"Chinchay Kuriya\\")","(name:pt,\\"Coreia do Norte\\")","(name:ps,\\"د کوريا ولسواک خلق جمهوريت\\")","(name:pnb,\\"اتلا کوریا\\")","(name:pms,\\"Coréa dël Nòrd\\")","(name:pl,\\"Korea Północna\\")","(name:pam,\\"Pangulung Korea\\")","(name:os,\\"Цæгат Корей\\")","(name:oc,\\"Corèa del Nòrd\\")","(name:nov,\\"Nord Korea\\")","(name:no,Nord-Korea)","(name:nn,Nord-Korea)","(name:nl,Noord-Korea)","(name:nds,Noordkorea)","(name:nah,\\"Corea Mictlāmpa\\")","(name:na,\\"Republik Engame Korea\\")","(name:ms,\\"Korea Utara\\")","(name:mr,\\"उत्तर कोरिया\\")","(name:mn,\\"Хойд Солонгос\\")","(name:ml,\\"ഉത്തര കൊറിയ\\")","(name:mk,\\"Северна Кореја\\")","(name:mg,\\"Korea Avaratra\\")","(name:lv,Ziemeļkoreja)","(name:lt,\\"Šiaurės Korėja\\")","(name:lmo,\\"Corea del Nòrd\\")","(name:li,Noord-Korea)","(name:lb,Nordkorea)","(name:lad,\\"Korea del Nord\\")","(name:la,\\"Corea Septentrionalis\\")","(name:kw,\\"Korea Gledh\\")","(name:kv,\\"Корея Войтыр Демократия Республика\\")","(name:ku,\\"Korêya Bakur\\")","(name:kn,\\"ಉತ್ತರ ಕೊರಿಯಾ\\")","(name:kk,\\"Солтүстік Корея\\")","(name:ka,\\"ჩრდილოეთი კორეა\\")","(name:jv,\\"Koréa Lor\\")","(name:jbo,\\"berti zei .xanguk\\")","(name:ja,北朝鮮)","(name:it,\\"Corea del Nord\\")","(name:is,Norður-Kórea)","(name:io,Nord-Korea)","(name:ie,Nord-Korea)","(name:id,\\"Korea Utara\\")","(name:ia,\\"Corea del Nord\\")","(name:hy,\\"Հյուսիսային Կորեա\\")","(name:hu,Észak-Korea)","(name:ht,\\"Kore dinò\\")","(name:hsb,\\"Sewjerna Koreja\\")","(name:hr,\\"Sjeverna Koreja\\")","(name:hi,\\"उत्तर कोरिया\\")","(name:he,\\"קוריאה הצפונית\\")","(name:haw,\\"Kōlea ʻĀkau\\")","(name:hak,\\"Tsêu-siên Mìn-tsú Tsú-ngi Ngìn-mìn Khiung-fò-koet\\")","(name:gv,\\"Yn Chorea Twoaie\\")","(name:gl,\\"Corea do Norte\\")","(name:gd,\\"Coirea a Tuath\\")","(name:ga,\\"An Chóiré Thuaidh\\")","(name:fy,Noard-Korea)","(name:frp,\\"Corê du Nord\\")","(name:fr,\\"Corée du Nord\\")","(name:fo,Norðurkorea)","(name:fiu-vro,Põh'a-Korea)","(name:fi,Pohjois-Korea)","(name:fa,\\"کره شمالی\\")","(name:eu,\\"Ipar Korea\\")","(name:et,Põhja-Korea)","(name:es,\\"Corea del Norte\\")","(name:eo,Nord-Koreio)","(name:en,\\"North Korea\\")","(name:el,\\"Βόρεια Κορέα\\")","(name:dz,བྱང་ཀོ་རི་ཡ་)","(name:dv,\\"އުތުރު ކޮރެއާ\\")","(name:dsb,\\"Pódpołnocna Koreja\\")","(name:diq,\\"Korya Zımey\\")","(name:de,Nordkorea)","(name:da,Nordkorea)","(name:cy,\\"Gogledd Corea\\")","(name:csb,\\"Nordowô Kòreja\\")","(name:cs,\\"Severní Korea\\")","(name:crh,\\"Şimaliy Koreya\\")","(name:ceb,\\"Amihanang Korea\\")","(name:cbk-zam,\\"Corea del Norte\\")","(name:ca,\\"Corea del Nord\\")","(name:bs,\\"Sjeverna Koreja\\")","(name:br,\\"Korea an Norzh\\")","(name:bpy,\\"ঔয়াং কোরিয়া\\")","(name:bo,བྱང་ཀོ་རི་ཡ།)","(name:bn,\\"উত্তর কোরিয়া\\")","(name:bg,\\"Северна Корея\\")","(name:be-x-old,\\"Паўночная Карэя\\")","(name:be,\\"Паўночная Карэя\\")","(name:bcl,\\"North Korea\\")","(name:bat-smg,\\"Šiaurės Kuoriejė\\")","(name:az,\\"Şimali Koreya\\")","(name:ast,\\"Corea del Norte\\")","(name:ar,\\"كوريا الشمالية\\")","(name:an,\\"Corea d'o Norte\\")","(name:als,Nordkorea)","(name:af,Noord-Korea)","(name,북조선)"}	\N
kr	{"(official_name:uz,\\"Koreya Respublikasi\\")","(official_name:sv,\\"Republiken Korea\\")","(official_name:sk,\\"Kórejská republika\\")","(official_name:ru,\\"Республика Корея\\")","(official_name:pt,\\"República da Coreia\\")","(official_name:pl,\\"Republika Korei\\")","(official_name:os,\\"Республикæ Корей\\")","(official_name:mn,\\"Бүгд Найрамдах Солонгос Улс\\")","(official_name:lv,\\"Korejas Republika\\")","(official_name:lb,\\"Republik Korea\\")","(official_name:la,\\"Respublica Coreana\\")","(official_name:ja,大韓民国)","(official_name:it,\\"Repubblica di Corea\\")","(official_name:id,\\"Republik Korea\\")","(official_name:fr,\\"République de Corée\\")","(official_name:et,\\"Korea Vabariik\\")","(official_name:en,\\"Republic of Korea\\")","(official_name:el,\\"Δημοκρατία της Κορέας\\")","(official_name:cdo,\\"Dâi-hàng Mìng-guók\\")","(official_name:ca,\\"República de Corea\\")","(official_name:br,\\"Republik Korea\\")","(official_name:bat-smg,\\"Kuorėjės Respoblėka\\")","(official_name:af,\\"Republiek van Korea\\")","(official_name,대한민국)","(name:zh-yue,大韓民國)","(name:zh_pyt,Hánguó)","(name:zh_py,Hanguo)","(name:zh-min-nan,Hân-kok)","(name:zh,韩国)","(name:yi,\\"דרום קארעע\\")","(name:wuu,大韩民国)","(name:wo,\\"Kore gu Bëj-saalum\\")","(name:war,\\"Salatan nga Korea\\")","(name:vo,Sulüda-Koreyän)","(name:vi,\\"Hàn Quốc\\")","(name:vec,\\"Corea del Sud\\")","(name:uz,\\"Janubiy Koreya\\")","(name:ur,\\"جنوبی کوریا\\")","(name:uk,\\"Південна Корея\\")","(name:ug,\\"جەنۇبىي چاۋشيەن\\")","(name:udm,\\"Республика Корея\\")","(name:tr,\\"Güney Kore\\")","(name:tpi,\\"Saut Koria\\")","(name:tl,\\"Timog Korea\\")","(name:tk,\\"Günorta Koreýa\\")","(name:th,ประเทศเกาหลีใต้)","(name:tet,\\"Koreia Súl\\")","(name:te,\\"దక్షిణ కొరియా\\")","(name:ta,தென்கொரியா)","(name:szl,\\"Połedńowo Koryjo\\")","(name:sw,\\"Korea Kusini\\")","(name:sv,Sydkorea)","(name:su,\\"Koréa Kidul\\")","(name:sr,\\"Јужна Кореја\\")","(name:sq,\\"Koreja e Jugut\\")","(name:sm,\\"Kolea i Saute\\")","(name:sl,\\"Južna Koreja\\")","(name:sk,\\"Južná Kórea\\")","(name:simple,\\"South Korea\\")","(name:sh,\\"Južna Koreja\\")","(name:se,Mátta-Korea)","(name:scn,\\"Corea dû Sud\\")","(name:sah,\\"Соҕуруу Кэриэйэ\\")","(name:sa,\\"दक्षिण कोरिया\\")","(name:ru,\\"Южная Корея\\")","(name:ro,\\"Coreea de Sud\\")","(name:rm,\\"Corea dal sid\\")","(name:qu,\\"Urin Kuriya\\")","(name:pt,\\"Coreia do Sul\\")","(name:ps,\\"سوېلي کوريا\\")","(name:pnb,\\"دکھنی کوریا\\")","(name:pms,\\"Coréa dël Sud\\")","(name:pl,\\"Korea Południowa\\")","(name:pam,\\"Mauling Korea\\")","(name:os,\\"Хуссар Корей\\")","(name:oc,\\"Corèa del Sud\\")","(name:nrm,\\"Corée du Sud\\")","(name:nov,\\"Sud Korea\\")","(name:no,Sør-Korea)","(name:nn,Sør-Korea)","(name:nl,Zuid-Korea)","(name:ne,\\"दक्षिण कोरिया\\")","(name:nds,Süüdkorea)","(name:nap,\\"Corea d''o Sud\\")","(name:nah,\\"Corea Huitztlāmpa\\")","(name:my,တောင်ကိုရီးယားနိုင်ငံ)","(name:mt,\\"Korea t'Isfel\\")","(name:ms,\\"Korea Selatan\\")","(name:mr,\\"दक्षिण कोरिया\\")","(name:mn,\\"Өмнөд Солонгос\\")","(name:ml,\\"ദക്ഷിണ കൊറിയ\\")","(name:mk,\\"Република Кореја\\")","(name:mg,\\"Korea Atsimo\\")","(name:lv,Dienvidkoreja)","(name:lt,\\"Pietų Korėja\\")","(name:lmo,\\"Curea del Süd\\")","(name:lij,\\"Corea do Sud\\")","(name:li,Zuud-Korea)","(name:lb,Südkorea)","(name:la,\\"Corea Meridionalis\\")","(name:kw,\\"Korea Dhyhow\\")","(name:kv,\\"Корея Республика\\")","(name:ku,\\"Komara Korêyê\\")","(name:ks,\\"दक्षिण कोरिया\\")","(name:ko,대한민국)","(name:kn,\\"ದಕ್ಷಿಣ ಕೊರಿಯಾ\\")","(name:kk,\\"Оңтүстік Корея\\")","(name:ka,\\"სამხრეთი კორეა\\")","(name:jv,\\"Koréa Kidul\\")","(name:jbo,\\"snanu zei .xanguk\\")","(name:ja,韓国)","(name:it,\\"Corea del Sud\\")","(name:is,Suður-Kórea)","(name:io,Sud-Korea)","(name:ilo,\\"Abagatan a Korea\\")","(name:ie,Sud-Korea)","(name:id,\\"Korea Selatan\\")","(name:ia,\\"Corea del Sud\\")","(name:hy,\\"Հարավային Կորեա\\")","(name:hu,Dél-Korea)","(name:ht,\\"Kore disid\\")","(name:hsb,\\"Južna Koreja\\")","(name:hr,\\"Južna Koreja\\")","(name:hif,\\"South Korea\\")","(name:hi,\\"दक्षिण कोरिया\\")","(name:he,\\"קוריאה הדרומית\\")","(name:haw,\\"Kōlea Hema\\")","(name:hak,\\"Thai-hòn mìn-koet\\")","(name:gv,\\"Yn Chorea Yiass\\")","(name:gu,\\"દક્ષિણ કોરિયા\\")","(name:gl,\\"Corea do Sur\\")","(name:gd,\\"Coirea a Deas\\")","(name:gan,韓國)","(name:ga,\\"An Chóiré Theas\\")","(name:fy,Súd-Korea)","(name:frp,\\"Corê du Sud\\")","(name:fr,\\"Corée du Sud\\")","(name:fiu-vro,Lõunõ-Korea)","(name:fi,Etelä-Korea)","(name:fa,\\"کره جنوبی\\")","(name:eu,\\"Hego Korea\\")","(name:et,Lõuna-Korea)","(name:es,\\"Corea del Sur\\")","(name:eo,Sud-Koreio)","(name:en,\\"South Korea\\")","(name:el,\\"Νότια Κορέα\\")","(name:ee,\\"South Korea\\")","(name:dz,ལྷོ་ཀོ་རི་ཡ་)","(name:dv,\\"ދެކުނު ކޮރެއާ\\")","(name:dsb,\\"Pódpołdnjowa Koreja\\")","(name:diq,\\"Korya Veroci\\")","(name:de,Südkorea)","(name:da,Sydkorea)","(name:cy,\\"De Corea\\")","(name:csb,\\"Repùblika Kòreji\\")","(name:cs,\\"Jižní Korea\\")","(name:crh,\\"Cenübiy Koreya\\")","(name:chr,\\"ᎤᎦᎾᏭ ᎢᏗᎵ ᎪᎴᎠ\\")","(name:ceb,\\"Habagatang Korea\\")","(name:cdo,Hàng-guók)","(name:ca,\\"Corea del Sud\\")","(name:bs,\\"Južna Koreja\\")","(name:br,\\"Korea ar Su\\")","(name:bpy,\\"খা কোরিয়া\\")","(name:bo,ལྷོ་ཀོ་རི་ཡ།)","(name:bn,\\"দক্ষিণ কোরিয়া\\")","(name:bg,\\"Южна Корея\\")","(name:be-x-old,\\"Рэспубліка Карэя\\")","(name:be,\\"Паўднёвая Карэя\\")","(name:bcl,\\"Sur nin Korea\\")","(name:bat-smg,\\"Pėitū Kuoriejė\\")","(name:bar,Südkorea)","(name:az,\\"Cənubi Koreya\\")","(name:ast,\\"Corea del Sur\\")","(name:arz,\\"كوريا الجنوبيه\\")","(name:ar,\\"كوريا الجنوبية\\")","(name:an,\\"Corea d'o Sur\\")","(name:am,\\"ደቡብ ኮርያ\\")","(name:als,Südkorea)","(name:af,Suid-Korea)","(name:ace,\\"Korèa Seulatan\\")","(name,대한민국)"}	\N
ky	{"(name:zh,开曼群岛)","(name:vi,\\"Quần đảo Cayman\\")","(name:uk,\\"Кайманові острови\\")","(name:tr,\\"Kayman Adaları\\")","(name:th,หมู่เกาะเคย์แมน)","(name:sv,Caymanöarna)","(name:sl,\\"Kajmanski otoki\\")","(name:ru,\\"Каймановы острова\\")","(name:pt,\\"Ilhas Cayman\\")","(name:pl,Kajmany)","(name:nl,Kaaimaneilanden)","(name:mn,\\"Кайманы Арлууд\\")","(name:lv,\\"Kaimanu salas\\")","(name:lt,\\"Kaimanų salos\\")","(name:lb,Kaimaninselen)","(name:it,\\"Isole Cayman\\")","(name:is,Caymaneyjar)","(name:id,\\"Kepulauan Cayman\\")","(name:hu,Kajmán-szigetek)","(name:hr,\\"Kajmanski otoci\\")","(name:he,\\"איי קיימן\\")","(name:ga,\\"Oileáin Cayman\\")","(name:fy,\\"de Kaaimaneilannen\\")","(name:fr,\\"Îles Caïmans\\")","(name:fi,Caymansaaret)","(name:fa,\\"جزایر کایمان\\")","(name:et,Kaimanisaared)","(name:es,\\"Islas Caimán\\")","(name:eo,Kajmaninsuloj)","(name:en,\\"Cayman Islands\\")","(name:de,Kaimaninseln)","(name:da,Caymanøerne)","(name:cy,\\"Ynysoedd Cayman\\")","(name:ca,\\"Illes Caiman\\")","(name:br,\\"Inizi Cayman\\")","(name:be,\\"Кайманавы астравы\\")","(name:ar,\\"جزر الكايمان\\")","(name:af,Kaaimanseilande)","(name,\\"Cayman Islands\\")"}	\N
np	{"(official_name:vi,\\"Cộng hòa dân chủ liên bang Nepal\\")","(official_name:sv,\\"Demokratiska förbundsrepubliken Nepal\\")","(official_name:pl,\\"Federalna Demokratyczna Republika Nepalu\\")","(official_name:ne,\\"संघीय लोकतान्त्रिक गणतन्त्रात्मक नेपाल\\")","(official_name:lv,\\"Nepālas Karaliste\\")","(official_name:lt,\\"Nepalo Federacinė Demokratinė Respublika\\")","(official_name:it,\\"Repubblica Federale Democratica del Nepal\\")","(official_name:fr,\\"République démocratique fédérale du Népal\\")","(official_name:br,\\"Republik Demokratel Kevreadel Nepal\\")","(official_name,\\"Sanghiya Loktantrik Ganatantratmak Nepāl\\")","(name:zh_pyt,Níbóěr)","(name:zh_py,Niboer)","(name:zh,尼泊尔)","(name:uk,Непал)","(name:th,ประเทศเนปาล)","(name:sv,Nepal)","(name:ru,Непал)","(name:pl,Nepal)","(name:ne,नेपाल)","(name:mn,Балба)","(name:lv,Nepāla)","(name:lt,Nepalas)","(name:la,Nepalia)","(name:ja,ネパール)","(name:it,Nepal)","(name:is,Nepal)","(name:hu,Nepál)","(name:he,נפאל)","(name:haw,Nepala)","(name:gd,Neapàl)","(name:ga,Neipeal)","(name:fr,Népal)","(name:fi,Nepal)","(name:fa,نپال)","(name:eo,Nepalo)","(name:en,Nepal)","(name:el,Νεπάλ)","(name:br,Nepal)","(name:be,Непал)","(name:ar,نيبال)","(name,Nepal)"}	\N
pe	{"(official_name:vi,\\"Cộng hòa Peru\\")","(official_name:sv,\\"Republiken Peru\\")","(official_name:sk,\\"Peruánska republika\\")","(official_name:lv,\\"Peru Republika\\")","(official_name:lt,\\"Peru Respublika\\")","(official_name:lb,\\"Republik Peru\\")","(official_name:id,\\"Republik Peru\\")","(official_name:fr,\\"République du Pérou\\")","(official_name:et,\\"Peruu Vabariik\\")","(official_name:el,\\"Δημοκρατία του Περού\\")","(official_name,\\"República del Perú\\")","(name:zh,秘鲁)","(name:uk,Перу)","(name:th,ประเทศเปรู)","(name:sv,Peru)","(name:sk,Peru)","(name:ru,Перу)","(name:pl,Peru)","(name:mn,Перу)","(name:lv,Peru)","(name:la,Peruvia)","(name:ja,ペルー)","(name:it,Perù)","(name:is,Perú)","(name:hu,Peru)","(name:he,פרו)","(name:gd,Pearu)","(name:ga,Peiriú)","(name:fy,Perû)","(name:fr,Pérou)","(name:fi,Peru)","(name:fa,پرو)","(name:et,Peruu)","(name:es,Perú)","(name:eo,Peruo)","(name:en,Peru)","(name:el,Περού)","(name:da,Peru)","(name:cy,Periw)","(name:ca,Perú)","(name:br,Perou)","(name:be,Перу)","(name:ar,بيرو)","(name,Peru)"}	\N
pm	{"(official_name:lv,\\"Senpjēras un Mikelonas teritoriālā vienība\\")","(official_name:fr,Saint-Pierre-et-Miquelon)","(official_name,Saint-Pierre-et-Miquelon)","(name:uk,\\"Сен-П'єр і Мікелон\\")","(name:tr,\\"Saint-Pierre ve Miquelon\\")","(name:sv,\\"Saint-Pierre och Miquelon\\")","(name:mn,\\"Сент Пьер ба Микелон\\")","(name:lv,\\"Senpjēra un Mikelona\\")","(name:lt,\\"Sen Pjeras ir Mikelonas\\")","(name:hu,\\"Saint-Pierre és Miquelon\\")","(name:hr,\\"Sveti Petar i Mikelon\\")","(name:fr,Saint-Pierre-et-Miquelon)","(name:fi,\\"Saint-Pierre ja Miquelon\\")","(name:es,\\"San Pedro y Miguelón\\")","(name:eo,\\"Sankta-Piero kaj Mikelono\\")","(name:en,\\"Saint Pierre and Miquelon\\")","(name:de,\\"Saint-Pierre und Miquelon\\")","(name:da,\\"Saint Pierre og Miquelon\\")","(name:be,\\"Святы П’ер і Міквелон\\")","(name:af,\\"Saint-Pierre et Miquelon\\")","(name,Saint-Pierre-et-Miquelon)"}	\N
sa	{"(official_name:vi,\\"Vương quốc Ả Rập Saudi\\")","(official_name:sv,\\"Konungariket Saudiarabien\\")","(official_name:pt,\\"Reino da Arábia Saudita\\")","(official_name:pl,\\"Królestwo Arabii Saudyjskiej\\")","(official_name:lt,\\"Saudo Arabijos Karalystė\\")","(official_name:lb,\\"Kinnekräich Saudi-Arabien\\")","(official_name:it,\\"Regno arabo saudita\\")","(official_name:id,\\"Kerajaan Arab Saudi\\")","(official_name:fr,\\"Royaume d'Arabie saoudite\\")","(official_name:et,\\"Saudi Araabia Kuningriik\\")","(official_name:en,\\"Kingdom of Saudi Arabia\\")","(official_name:el,\\"Βασίλειο της Σαουδικής Αραβίας\\")","(official_name:br,\\"Rouantelezh Arabia Saoudat\\")","(official_name:af,\\"Koninkryk van Saoedi-Arabië\\")","(name:zh_pyt,\\"Shātè Ālābó\\")","(name:zh_py,\\"Shate Alabo\\")","(name:zh,沙特阿拉伯)","(name:vi,\\"Ả Rập Saudi\\")","(name:uk,\\"Саудівська Аравія\\")","(name:tr,\\"Suudi Arabistan\\")","(name:th,ประเทศซาอุดีอาระเบีย)","(name:sv,Saudiarabien)","(name:sl,\\"Saudova Arabija\\")","(name:ru,\\"Саудовская Аравия\\")","(name:pt,\\"Arábia Saudita\\")","(name:pl,\\"Arabia Saudyjska\\")","(name:nl,Saoedi-Arabië)","(name:mn,\\"Саудын Араб\\")","(name:lt,\\"Saudo Arabija\\")","(name:li,Saoedi-Arabië)","(name:lb,Saudi-Arabien)","(name:la,\\"Arabia Saudiana\\")","(name:ja,サウジアラビア)","(name:it,\\"Arabia Saudita\\")","(name:is,Sádí-Arabía)","(name:id,\\"Arab Saudi\\")","(name:hu,Szaúd-Arábia)","(name:hr,\\"Saudijska Arabija\\")","(name:he,\\"ערב הסעודית\\")","(name:haw,\\"Saudi ʻAlapia\\")","(name:gd,Saud-Aràibia)","(name:ga,\\"An Araib Shádach\\")","(name:fy,Saûdi-Araabje)","(name:fr,\\"Arabie saoudite\\")","(name:fi,Saudi-Arabia)","(name:fa,\\"عربستان سعودی\\")","(name:et,\\"Saudi Araabia\\")","(name:es,\\"Arabia Saudita\\")","(name:eo,\\"Saŭda Arabio\\")","(name:en,\\"Saudi Arabia\\")","(name:el,\\"Σαουδική Αραβία\\")","(name:de,Saudi-Arabien)","(name:da,Saudi-Arabien)","(name:ca,\\"Aràbia Saudita\\")","(name:br,\\"Arabia Saoudat\\")","(name:be,\\"Саудаўская Аравія\\")","(name:ar,\\"المملكة العربية السعودية\\")","(name:af,Saoedi-Arabië)","(name,\\"Saudi Arabia / السعودية\\")"}	\N
st	{"(official_name:vi,\\"Cộng hòa Dân chủ São Tomé và Príncipe\\")","(official_name:sv,\\"Demokratiska republiken São Tomé och Príncipe\\")","(official_name:pt,\\"República Democrática de São Tomé e Príncipe\\")","(official_name:lb,\\"Demokratesch Republik São Tomé a Príncipe\\")","(official_name:id,\\"Republik Demokratik Sao Tome dan Principe\\")","(official_name:fr,\\"République démocratique de Sao Tomé-et-Principe\\")","(name:zh_pyt,\\"Shèngduōměi hé Pǔlínxībǐ\\")","(name:zh_py,\\"Shengduomei he Pulinxibi\\")","(name:zh,圣多美和普林西比)","(name:vi,\\"São Tomé và Príncipe\\")","(name:uk,\\"Сан-Томе і Принсіпі\\")","(name:tr,\\"São Tomé ve Príncipe\\")","(name:th,ประเทศเซาตูเมและปรินซิปี)","(name:sv,\\"São Tomé och Príncipe\\")","(name:sl,\\"Sao Tome in Principe\\")","(name:ru,\\"Сан-Томе и Принсипи\\")","(name:pt,\\"São Tomé e Príncipe\\")","(name:pl,\\"Wyspy Świętego Tomasza i Książęca\\")","(name:nl,\\"Sao Tomé en Principe\\")","(name:mn,\\"Сан-Томе ба Принсипи\\")","(name:lt,\\"Sao Tomė ir Prinsipė\\")","(name:li,\\"São Tomé en Príncipe\\")","(name:lb,\\"São Tomé a Príncipe\\")","(name:la,\\"Insulae Sancti Thomae et Principis\\")","(name:is,\\"Saó Tóme og Prinsípe\\")","(name:id,\\"Sao Tome dan Principe\\")","(name:hu,\\"São Tomé és Príncipe\\")","(name:hr,\\"Sveti Toma i Princip\\")","(name:he,\\"סאו טומה ופרינסיפה\\")","(name:gd,\\"São Tomé agus Príncipe\\")","(name:ga,\\"São Tomé agus Príncipe\\")","(name:fy,\\"Sao Tomee en Prinsyp\\")","(name:fr,\\"Sao Tomé-et-Principe\\")","(name:fi,\\"São Tomé ja Príncipe\\")","(name:fa,\\"سائوتومه و پرینسیپ\\")","(name:et,\\"São Tomé ja Príncipe\\")","(name:es,\\"Santo Tomé y Príncipe\\")","(name:eo,\\"Sao-Tomeo kaj Principeo\\")","(name:en,\\"São Tomé and Príncipe\\")","(name:el,\\"Σάο Τομέ και Πρίνσιπε\\")","(name:de,\\"São Tomé und Príncipe\\")","(name:da,\\"São Tomé og Príncipe\\")","(name:cy,\\"São Tomé a Príncipe\\")","(name:ca,\\"São Tomé i Príncipe\\")","(name:br,\\"São Tomé ha Príncipe\\")","(name:ar,\\"سان تومي وبرينسيبي\\")","(name:af,\\"São Tomé en Principe\\")","(name,\\"São Tomé e Príncipe\\")"}	\N
tm	{"(official_name:vi,\\"Cộng hòa Turkmenistan\\")","(official_name:pt,\\"República do Turcomenistão\\")","(official_name:lb,\\"Presidialrepublik Turkmenistan\\")","(name:zh_pyt,Tǔkùmànsītǎn)","(name:zh_py,Tukumansitan)","(name:zh,土库曼斯坦)","(name:vi,Turkmenistan)","(name:uk,Туркменістан)","(name:tr,Türkmenistan)","(name:tk,Türkmenistan)","(name:th,ประเทศเติร์กเมนิสถาน)","(name:sv,Turkmenistan)","(name:sl,Turkmenistan)","(name:ru,Туркмения)","(name:pt,Turcomenistão)","(name:pl,Turkmenistan)","(name:nl,Turkmenistan)","(name:mn,Туркменистан)","(name:lv,Turkmenistāna)","(name:lt,Turkmenistanas)","(name:la,Turcomannia)","(name:ja,トルクメニスタン)","(name:it,Turkmenistan)","(name:is,Túrkmenistan)","(name:id,Turkmenistan)","(name:hu,Türkmenisztán)","(name:hr,Turkmenistan)","(name:he,טורקמניסטן)","(name:haw,Tukemenikana)","(name:gd,Turcmanastàn)","(name:ga,\\"An Tuircméanastáin\\")","(name:fr,Turkménistan)","(name:fi,Turkmenistan)","(name:fa,ترکمنستان)","(name:et,Türkmenistan)","(name:es,Turkmenistán)","(name:eo,Turkmenio)","(name:en,Turkmenistan)","(name:el,Τουρκμενιστάν)","(name:de,Turkmenistan)","(name:da,Turkmenistan)","(name:br,Turkmenistan)","(name:be,Туркменістан)","(name:az,Türkmənistan)","(name:ar,تركمانستان)","(name:af,Turkmenistan)","(name,Türkmenistan)","(alt_name,Turkmenia)"}	\N
tt	{"(official_name:vi,\\"Cộng hoà Trinidad và Tobago\\")","(official_name:sv,\\"Republiken Trinidad och Tobago\\")","(official_name:pt,\\"República de Trinidad e Tobago\\")","(official_name:lt,\\"Trinidado ir Tobago Respublika\\")","(official_name:ja,トリニダード・トバゴ共和国)","(official_name:id,\\"Republik Trinidad dan Tobago\\")","(official_name:fr,\\"République de Trinité-et-Tobago\\")","(official_name:et,\\"Trinidadi ja Tobago Vabariik\\")","(official_name:es,\\"República de Trinidad y Tobago\\")","(official_name:br,\\"Republik Trinidad ha Tobago\\")","(official_name:be,\\"Рэспубліка Трынідад і Табага\\")","(official_name,\\"Republic of Trinidad and Tobago\\")","(name:zh,特立尼达和多巴哥)","(name:vi,\\"Trinidad và Tobago\\")","(name:uk,\\"Трінідад та Тобаго\\")","(name:tr,\\"Trinidad ve Tobago\\")","(name:th,ประเทศตรินิแดดและโตเบโก)","(name:sv,\\"Trinidad och Tobago\\")","(name:sl,\\"Trinidad in Tobago\\")","(name:ru,\\"Тринидад и Тобаго\\")","(name:pt,\\"Trinidad e Tobago\\")","(name:pl,\\"Trynidad i Tobago\\")","(name:nl,\\"Trinidad en Tobago\\")","(name:mn,\\"Тринидад ба Тобаго\\")","(name:lt,\\"Trinidadas ir Tobagas\\")","(name:la,\\"Trinitas et Tabacum\\")","(name:ja,トリニダード・トバゴ)","(name:it,\\"Trinidad e Tobago\\")","(name:is,\\"Trínidad og Tóbagó\\")","(name:id,\\"Trinidad dan Tobago\\")","(name:hu,\\"Trinidad és Tobago\\")","(name:hr,\\"Trinidad i Tobago\\")","(name:he,\\"טרינידד וטובגו\\")","(name:gd,\\"Trianaid agus Tobago\\")","(name:ga,\\"Oileán na Tríonóide agus Tobága\\")","(name:fy,\\"Trinidad en Tobago\\")","(name:fr,Trinité-et-Tobago)","(name:fi,\\"Trinidad ja Tobago\\")","(name:fa,\\"ترینیداد و توباگو\\")","(name:et,\\"Trinidad ja Tobago\\")","(name:es,\\"Trinidad y Tobago\\")","(name:eo,\\"Trinidado kaj Tobago\\")","(name:en,\\"Trinidad and Tobago\\")","(name:de,\\"Trinidad und Tobago\\")","(name:da,\\"Trinidad og Tobago\\")","(name:cy,\\"Trinidad a Tobago\\")","(name:ca,\\"Trinitat i Tobago\\")","(name:br,\\"Trinidad ha Tobago\\")","(name:be,\\"Трынідад і Табага\\")","(name:ar,\\"ترينيداد وتوباغو\\")","(name:af,\\"Trinidad en Tobago\\")","(name,\\"Trinidad and Tobago\\")"}	\N
ye	{"(official_name:vi,\\"Cộng hòa Yemen\\")","(official_name:sv,\\"Republiken Jemen\\")","(official_name:pt,\\"República do Iêmen\\")","(official_name:pl,\\"Republika Jemeńska\\")","(official_name:lt,\\"Jemeno Respublika\\")","(official_name:ja,イエメン共和国)","(official_name:it,\\"Repubblica Unita dello Yemen\\")","(official_name:id,\\"Republik Yaman\\")","(official_name:fi,\\"Jemenin tasavalta\\")","(official_name:et,\\"Jeemeni Vabariik\\")","(official_name:en,\\"Republic of Yemen\\")","(official_name:el,\\"Δημοκρατία της Υεμένης\\")","(official_name:br,\\"Republik Yemen\\")","(name:zh_pyt,Yěmén)","(name:zh_py,Yemen)","(name:zh,也门)","(name:vi,Yemen)","(name:uk,Ємен)","(name:tr,Yemen)","(name:th,ประเทศเยเมน)","(name:sv,Jemen)","(name:sl,Jemen)","(name:ru,Йемен)","(name:pt,Iêmen)","(name:pl,Jemen)","(name:nl,Jemen)","(name:mn,Йемен)","(name:lt,Jemenas)","(name:li,Jeme)","(name:lb,Jemen)","(name:la,Iemenia)","(name:ja,イエメン)","(name:it,Yemen)","(name:is,Jemen)","(name:id,Yaman)","(name:hu,Jemen)","(name:hr,Jemen)","(name:he,תימן)","(name:haw,Iemene)","(name:gd,Iemen)","(name:ga,Éimin)","(name:fy,Jemen)","(name:fr,Yémen)","(name:fi,Jemen)","(name:fa,يمن)","(name:et,Jeemen)","(name:es,Yemen)","(name:eo,Jemeno)","(name:en,Yemen)","(name:el,Υεμένη)","(name:de,Jemen)","(name:da,Yemen)","(name:cy,Yemen)","(name:ca,Iemen)","(name:br,Yemen)","(name:be,Йемен)","(name:ar,اليمن)","(name:af,Jemen)","(name,\\"اليَمَن al-Yaman\\")"}	\N
zw	{"(official_name:vi,\\"Cộng hòa Zimbabwe\\")","(official_name:sv,\\"Republiken Zimbabwe\\")","(official_name:pt,\\"República do Zimbábue\\")","(official_name:lt,\\"Zimbabvės Respublika\\")","(official_name:lb,\\"Republik Simbabwe\\")","(official_name:ja,ジンバブエ共和国)","(official_name:id,\\"Republik Zimbabwe\\")","(official_name:gd,\\"Poblachd Shiombabue\\")","(official_name:el,\\"Δημοκρατία της Ζιμπάμπουε\\")","(official_name,\\"Republic of Zimbabwe;República de Zimbabue\\")","(name:zh_pyt,Jīnbābùwéi)","(name:zh_py,Jinbabuwei)","(name:zh,津巴布韦)","(name:vi,Zimbabwe)","(name:uk,Зімбабве)","(name:tr,Zimbabve)","(name:th,ประเทศซิมบับเว)","(name:sv,Zimbabwe)","(name:sl,Zimbabve)","(name:ru,Зимбабве)","(name:pt,Zimbábue)","(name:pl,Zimbabwe)","(name:mn,Зимбабве)","(name:lt,Zimbabvė)","(name:lb,Simbabwe)","(name:la,Zimbabua)","(name:ja,ジンバブエ)","(name:it,Zimbabwe)","(name:is,Simbabve)","(name:hu,Zimbabwe)","(name:hr,Zimbabve)","(name:he,זימבבווה)","(name:haw,Zimababue)","(name:gd,Siombabue)","(name:ga,\\"An tSiombáib\\")","(name:fy,Simbabwe)","(name:fr,Zimbabwe)","(name:fi,Zimbabwe)","(name:fa,زیمبابوه)","(name:es,Zimbabue)","(name:eo,Zimbabvo)","(name:en,Zimbabwe)","(name:el,Ζιμπάμπουε)","(name:de,Simbabwe)","(name:da,Zimbabwe)","(name:br,Zimbabwe)","(name:be,Зімбабве)","(name:ar,زمبابوي)","(name,Zimbabwe)"}	\N
bz	{"(name:zh,伯利兹)","(name:uk,Беліз)","(name:th,ประเทศเบลีซ)","(name:sv,Belize)","(name:ru,Белиз)","(name:pt,Belize)","(name:pl,Belize)","(name:mn,Белиз)","(name:lv,Beliza)","(name:lt,Belizas)","(name:la,Beliza)","(name:ja,ベリーズ)","(name:it,Belize)","(name:is,Belís)","(name:hu,Belize)","(name:gd,Beilise)","(name:ga,\\"An Bheilís\\")","(name:fr,Belize)","(name:fi,Belize)","(name:fa,بلیز)","(name:es,Belice)","(name:eo,Belizo)","(name:en,Belize)","(name:el,Μπελίζε)","(name:br,Belize)","(name:be,Беліз)","(name:ar,بليز)","(name,Belize)"}	\N
gt	{"(official_name:vi,\\"Cộng hoà Guatemala\\")","(official_name:sv,\\"Republiken Guatemala\\")","(official_name:lv,\\"Gvatemalas Republika\\")","(official_name:lt,\\"Gvatemalos Respublika\\")","(official_name:it,\\"Repubblica del Guatemala\\")","(official_name:id,\\"Republik Guatemala\\")","(official_name:gd,\\"Poblachd Ghuatamala\\")","(official_name:el,\\"Δημοκρατία της Γουατεμάλας\\")","(official_name:be,\\"Рэспубліка Гватэмала\\")","(official_name,\\"República de Guatemala\\")","(name:zh,危地马拉)","(name:uk,Гватемала)","(name:th,ประเทศกัวเตมาลา)","(name:sv,Guatemala)","(name:sl,Gvatemala)","(name:ru,Гватемала)","(name:pl,Gwatemala)","(name:mn,Гватемал)","(name:lv,Gvatemala)","(name:lt,Gvatemala)","(name:la,Guatimalia)","(name:ja,グアテマラ)","(name:it,Guatemala)","(name:is,Gvatemala)","(name:hu,Guatemala)","(name:hr,Gvatemala)","(name:he,גואטמלה)","(name:gd,Guatamala)","(name:ga,Guatamala)","(name:fy,Gûatemala)","(name:fr,Guatemala)","(name:fi,Guatemala)","(name:fa,گواتمالا)","(name:eo,Gvatemalo)","(name:en,Guatemala)","(name:el,Γουατεμάλα)","(name:da,Guatemala)","(name:br,Guatemala)","(name:be,Гватэмала)","(name:ar,غواتيمالا)","(name,Guatemala)"}	\N
an	{"(official_name:lv,\\"Nīderlandes Antiļas\\")","(name:zh-min-nan,\\"Kē-tē-kok Antilles\\")","(name:zh,荷属安的列斯)","(name:wuu,荷属安地列斯)","(name:vi,\\"Antille thuộc Hà Lan\\")","(name:vec,\\"Antiłe Ołandexi\\")","(name:uk,\\"Нідерландські Антильські острови\\")","(name:tr,\\"Hollanda Antilleri\\")","(name:th,เนเธอร์แลนด์แอนทิลลิส)","(name:tg,\\"Антил Ҳоланд\\")","(name:ta,\\"நெதர்லாந்து அண்டிலிசு\\")","(name:sw,\\"Antili za Kiholanzi\\")","(name:sv,\\"Nederländska Antillerna\\")","(name:sr,\\"Холандски Антили\\")","(name:sl,\\"Nizozemski Antili\\")","(name:sk,\\"Holandské Antily\\")","(name:simple,\\"Netherlands Antilles\\")","(name:sh,\\"Nizozemski Antili\\")","(name:sah,\\"Недерланд Антиллара\\")","(name:ru,\\"Нидерландские Антилы\\")","(name:ro,\\"Antilele Olandeze\\")","(name:pt,\\"Antilhas Holandesas\\")","(name:pms,\\"Antile Olandèise\\")","(name:pl,\\"Antyle Holenderskie\\")","(name:pap,\\"Antias Hulandes\\")","(name:nov,\\"Nederlandani Antiles\\")","(name:no,\\"De nederlandske Antillene\\")","(name:nn,\\"Dei nederlandske Antillane\\")","(name:ms,\\"Antillen Belanda\\")","(name:mr,\\"नेदरलँड्स अँटिल्स\\")","(name:mn,\\"Нидерландын Антиллийн Арлууд\\")","(name:lv,Antiļas)","(name:lt,\\"Nyderlandų Antilai\\")","(name:ln,\\"Antiya ya Holanda\\")","(name:lmo,\\"Antil Ulandes\\")","(name:lij,\\"Antille Olandeixi\\")","(name:li,\\"Nederlandse Antille\\")","(name:lb,\\"Hollännesch Antillen\\")","(name:la,\\"Antillae Nederlandiae\\")","(name:kw,\\"Antillys Iseldiryek\\")","(name:ko,\\"네덜란드령 안틸레스\\")","(name:kk,Антийлер)","(name:ka,\\"ნიდერლანდის ანტილები\\")","(name:jv,\\"Antillen Walanda\\")","(name:ja,オランダ領アンティル)","(name:it,\\"Antille Olandesi\\")","(name:is,\\"Hollensku Antillaeyjar\\")","(name:io,\\"Nederlandana Antili\\")","(name:id,\\"Antillen Belanda\\")","(name:ia,\\"Antillas Nederlandese\\")","(name:hu,\\"Holland Antillák\\")","(name:hr,\\"Nizozemski Antili\\")","(name:hi,\\"नीदरलैंड एंटीलीज़\\")","(name:he,\\"האנטילים ההולנדיים\\")","(name:gl,\\"Antillas Neerlandesas\\")","(name:ga,\\"Aintillí na hÍsiltíre\\")","(name:fy,\\"Nederlânske Antillen\\")","(name:frp,\\"Antiles nêrlandêses\\")","(name:fr,\\"Antilles néerlandaises\\")","(name:fo,\\"Niðurlendsku Antillurnar\\")","(name:fi,\\"Alankomaiden Antillit\\")","(name:fa,\\"آنتیل هلند\\")","(name:eu,\\"Holandarren Antillak\\")","(name:et,\\"Hollandi Antillid\\")","(name:es,\\"Antillas Neerlandesas;Antillas Holandesas;Indias Occidentales Holandesas\\")","(name:eo,\\"Nederlandaj Antiloj\\")","(name:en,\\"Netherlands Antilles\\")","(name:el,\\"Ολλανδικές Αντίλλες\\")","(name:dv,\\"ނެދަލޭންޑު އެންޓިލޭ\\")","(name:dsb,\\"Nižozemske Antile\\")","(name:de,\\"Niederländische Antillen\\")","(name:da,\\"Nederlandske Antiller\\")","(name:cy,\\"Antilles yr Iseldiroedd\\")","(name:cs,\\"Nizozemské Antily\\")","(name:ca,\\"Antilles Neerlandeses\\")","(name:bs,\\"Holandski Antili\\")","(name:br,\\"Antilhez Nederlandat\\")","(name:bpy,\\"নেদারল্যান্ড এন্টিল্লেস\\")","(name:bg,\\"Холандски Антили\\")","(name:be-x-old,\\"Нідэрляндзкія Антылы\\")","(name:be,\\"Нідэрландскія Антылы\\")","(name:ar,\\"جزر الأنتيل\\")","(name:an,\\"Antillas Neerlandesas\\")","(name:af,\\"Nederlandse Antille\\")","(name,\\"De Nederlandse Antillen\\")"}	\N
rs	{"(official_name:sv,\\"Republiken Serbien\\")","(official_name:sk,\\"Srbská republika\\")","(official_name:pt,\\"República da Sérvia\\")","(official_name:lt,\\"Serbijos Respublika\\")","(official_name:ja,セルビア共和国)","(official_name:id,\\"Republik Serbia\\")","(official_name:fr,\\"République de Serbie\\")","(official_name:et,\\"Serbia Vabariik\\")","(official_name:el,\\"Δημοκρατία της Σερβίας\\")","(official_name:br,\\"Republik Serbia\\")","(name:zh_pyt,Sāiěrwéiyà)","(name:zh_py,Saierweiya)","(name:zh,塞尔维亚)","(name:vi,Serbia)","(name:uk,Сербія)","(name:tr,Sırbistan)","(name:th,ประเทศเซอร์เบีย)","(name:sv,Serbien)","(name:sr,Србија)","(name:sl,Srbija)","(name:sk,Srbsko)","(name:ru,Сербия)","(name:pt,Sérvia)","(name:pl,Serbia)","(name:no,Serbia)","(name:nn,Serbia)","(name:nl,Servië)","(name:nb,Serbia)","(name:mn,Серби)","(name:lt,Serbija)","(name:li,Servië)","(name:lb,Serbien)","(name:la,Serbia)","(name:ja,セルビア)","(name:it,Serbia)","(name:is,Serbía)","(name:id,Serbia)","(name:hu,Szerbia)","(name:hr,Srbija)","(name:he,סרביה)","(name:haw,Seripia)","(name:gd,\\"An t-Sèarb\\")","(name:ga,\\"An tSeirbia\\")","(name:fy,Servje)","(name:fr,Serbie)","(name:fi,Serbia)","(name:fa,صربستان)","(name:et,Serbia)","(name:es,Serbia)","(name:eo,Serbio)","(name:en,Serbia)","(name:el,Σερβία)","(name:de,Serbien)","(name:da,Serbien)","(name:cy,Serbia)","(name:ca,Sèrbia)","(name:br,Serbia)","(name:be,Сербія)","(name:ar,صربيا)","(name:af,Serwië)","(name,\\"Србија (Serbia)\\")"}	\N
no	{"(official_name:vi,\\"Vương quốc Na Uy\\")","(official_name:sv,\\"Konungariket Norge\\")","(official_name:sk,\\"Nórske kráľovstvo\\")","(official_name:lt,\\"Norvegijos Karalystė\\")","(official_name:lb,\\"Kinneksräich Norwegen\\")","(official_name:ja,ノルウェー王国)","(official_name:it,\\"Regno di Norvegia\\")","(official_name:id,\\"Kerajaan Norwegia\\")","(official_name:en,\\"Kingdom of Norway\\")","(official_name:el,\\"Βασίλειο της Νορβηγίας\\")","(official_name:be,\\"Каралеўства Нарвегія\\")","(official_name,\\"Kongeriket Norge\\")","(name:zh_pyt,Nuówēi)","(name:zh_py,Nuowei)","(name:zh,挪威)","(name:vi,\\"Na Uy\\")","(name:uk,Норвегія)","(name:tr,Norveç)","(name:th,ประเทศนอร์เวย์)","(name:sv,Norge)","(name:sl,Norveška)","(name:sk,Nórsko)","(name:ru,Норвегия)","(name:pl,Norwegia)","(name:no,Norge)","(name:nl,Noorwegen)","(name:mn,Норвеги)","(name:lv,Norvēģija)","(name:lt,Norvegija)","(name:li,Noorwege)","(name:lb,Norwegen)","(name:la,Norvegia)","(name:ja,ノルウェー)","(name:it,Norvegia)","(name:is,Noregur)","(name:id,Norwegia)","(name:hy,Նորվեգիա)","(name:hu,Norvégia)","(name:hr,Norveška)","(name:he,נורווגיה)","(name:haw,Nolewai)","(name:gd,Nirribhidh)","(name:ga,\\"An Iorua\\")","(name:fy,Noarwegen)","(name:fr,Norvège)","(name:fi,Norja)","(name:fa,نروژ)","(name:et,Norra)","(name:es,Noruega)","(name:eo,Norvegio)","(name:en,Norway)","(name:el,Νορβηγία)","(name:de,Norwegen)","(name:cy,Norwy)","(name:ca,Noruega)","(name:br,Norvegia)","(name:be,Нарвегія)","(name:ar,النرويج)","(name:af,Noorweë)","(name,Norge)"}	\N
at	{"(official_name:vi,\\"Cộng hòa Áo\\")","(official_name:sv,\\"Republiken Österrike\\")","(official_name:sk,\\"Rakúska republika\\")","(official_name:lv,\\"Austrijas Republika\\")","(official_name:lt,\\"Austrijos Respublika\\")","(official_name:lb,\\"Republik Éisträich\\")","(official_name:ja,オーストリア共和国)","(official_name:it,\\"Repubblica d'Austria\\")","(official_name:id,\\"Republik Austria\\")","(official_name:fr,\\"République d'Autriche\\")","(official_name:el,\\"Δημοκρατία της Αυστρίας\\")","(name:zh_pyt,Àodìlì)","(name:zh_py,Audili)","(name:zh,奥地利)","(name:vi,Áo)","(name:uk,Австрія)","(name:tr,Avusturya)","(name:th,ประเทศออสเตรีย)","(name:sv,Österrike)","(name:sl,Avstrija)","(name:sk,Rakúsko)","(name:ru,Австрия)","(name:ro,Austria)","(name:pl,Austria)","(name:nl,Oostenrijk)","(name:mn,Австри)","(name:lv,Austrija)","(name:lt,Austrija)","(name:li,Oosteriek)","(name:lb,Éisträich)","(name:la,Austria)","(name:ja,オーストリア)","(name:it,Austria)","(name:is,Austurríki)","(name:id,Austria)","(name:hy,Ավստրիա)","(name:hu,Ausztria)","(name:hr,Austrija)","(name:he,אוסטריה)","(name:haw,‘Aukekulia)","(name:gd,\\"An Ostair\\")","(name:ga,\\"An Ostair\\")","(name:fy,Eastenryk)","(name:fr,Autriche)","(name:fi,Itävalta)","(name:fa,اتریش)","(name:et,Austria)","(name:es,Austria)","(name:eo,Aŭstrio)","(name:en,Austria)","(name:el,Αυστρία)","(name:da,Østrig)","(name:cy,Awstria)","(name:cs,Rakousko)","(name:ca,Àustria)","(name:br,Aostria)","(name:bg,Австрия)","(name:be,Аўстрыя)","(name:ar,النمسا)","(name:af,Oostenryk)","(name,Österreich)"}	\N
bh	{"(official_name:vi,\\"Vương quốc Bahrain\\")","(official_name:sv,\\"Konungariket Bahrain\\")","(official_name:pt,\\"Reino do Bahrein\\")","(official_name:pl,\\"Królestwo Bahrajnu\\")","(official_name:lv,\\"Bahreinas Karaliste\\")","(official_name:lt,\\"Bahreino Karalystė\\")","(official_name:ja,バーレーン王国)","(official_name:it,\\"Regno del Bahrain\\")","(official_name:id,\\"Kerajaan Bahrain\\")","(official_name:et,\\"Bahreini Kuningriik\\")","(official_name:en,\\"Kingdom of Bahrain\\")","(official_name:el,\\"Βασίλειο του Μπαχρέιν\\")","(official_name:br,\\"Rouantelezh Bahrein\\")","(official_name,\\"‎مملكة البحرين  (Mamlakat al-Baḥrayn)\\")","(name:zh_pyt,Bālín)","(name:zh_py,Balin)","(name:zh,巴林)","(name:vi,Bahrain)","(name:uk,Бахрейн)","(name:tr,Bahreyn)","(name:th,ประเทศบาห์เรน)","(name:sv,Bahrain)","(name:sl,Bahrajn)","(name:ru,Бахрейн)","(name:pt,Bahrein)","(name:pl,Bahrajn)","(name:nl,Bahrein)","(name:mn,Бахрейн)","(name:lv,Bahreina)","(name:lt,Bahreinas)","(name:li,Bahrein)","(name:lb,Bahrain)","(name:la,Baharina)","(name:ja,バーレーン)","(name:it,Bahrain)","(name:is,Barein)","(name:id,Bahrain)","(name:hu,Bahrein)","(name:hr,Bahrein)","(name:he,בחריין)","(name:haw,Baharaina)","(name:gd,Bachrain)","(name:ga,Bairéin)","(name:fy,\\"De Barein\\")","(name:fr,Bahreïn)","(name:fi,Bahrain)","(name:fa,بحرين)","(name:et,Bahrein)","(name:es,Bahréin)","(name:eo,Barejno)","(name:en,Bahrain)","(name:el,Μπαχρέιν)","(name:de,Bahrain)","(name:da,Bahrain)","(name:cy,Bahrain)","(name:ca,Bahrain)","(name:br,Bahrein)","(name:be,Бахрэйн)","(name:ar,البحرين)","(name:af,Bahrein)","(name,البحرين)"}	\N
nl	{"(official_name:vi,\\"Vương quốc Hà Lan\\")","(official_name:sv,\\"Konungariket Nederländerna\\")","(official_name:lb,\\"Kinneksräich Holland\\")","(official_name:fr,\\"Royaume des Pays-Bas\\")","(official_name:be,\\"Каралеўства Нідэрланды\\")","(official_name,\\"Koninkrijk der Nederlanden\\")","(name:zh_pyt,Hélán)","(name:zh_py,Helan)","(name:zh,荷兰)","(name:wo,Olaand)","(name:war,\\"Paises Bajos\\")","(name:wa,\\"Bas Payis\\")","(name:vo,Nedän)","(name:vls,Olland)","(name:vi,\\"Hà Lan\\")","(name:vec,\\"Paéxi Basi\\")","(name:uz,Niderlandlar)","(name:uk,Нідерланди)","(name:tr,Hollanda)","(name:to,Holani)","(name:tl,Netherlands)","(name:th,ประเทศเนเธอร์แลนด์)","(name:tg,Нидерланд)","(name:tet,Olanda)","(name:ta,நெதர்லாந்து)","(name:sw,Uholanzi)","(name:sv,Nederländerna)","(name:su,Walanda)","(name:st,Hôlanê)","(name:sr,Холандија)","(name:sq,Holanda)","(name:so,Nederland)","(name:sl,Nizozemska)","(name:sk,Holandsko)","(name:sh,Nizozemska)","(name:se,Vuolleeatnamat)","(name:rw,\\"U Buholandi\\")","(name:ru,Нидерланды)","(name:ro,Olanda)","(name:qu,Urasuyu)","(name:pt,\\"Países Baixos\\")","(name:ps,نېدرلانډ/هالېن)","(name:pl,Holandia)","(name:os,Нидерландтæ)","(name:oc,\\"Païses Basses\\")","(name:no,Nederland)","(name:nn,Nederland)","(name:nl,Nederland)","(name:na,\\"Eben Eyong\\")","(name:ms,Belanda)","(name:mr,नेदरलँड्स)","(name:mn,Нидерланд)","(name:mk,Холандија)","(name:lv,Nīderlande)","(name:lt,Nyderlandai)","(name:ln,Holanda)","(name:lb,Holland)","(name:la,Nederlandia)","(name:ku,Holanda)","(name:ks,नेदरलैंड्स)","(name:ko,네덜란드)","(name:ja,オランダ)","(name:it,\\"Paesi Bassi\\")","(name:is,Holland)","(name:io,Nederlando)","(name:ie,Nederland)","(name:id,Belanda)","(name:ia,\\"Pais Basse\\")","(name:hy,Նիդեռլանդներ)","(name:hu,Hollandia)","(name:ht,Peyiba)","(name:hr,Nizozemska)","(name:he,הולנד)","(name:haw,Hōlani)","(name:gv,\\"Yn Ollan\\")","(name:gn,Holanda)","(name:gl,\\"Países Baixos\\")","(name:gd,\\"Na Tìrean Ìsle\\")","(name:ga,\\"An Ísiltír\\")","(name:fy,Nederlân)","(name:fr,Pays-Bas)","(name:fo,Niðurlond)","(name:fi,Alankomaat)","(name:fa,هلند)","(name:eu,Herbehereak)","(name:et,Holland)","(name:es,\\"Países Bajos\\")","(name:eo,Nederlando)","(name:en,\\"The Netherlands\\")","(name:el,Ολλανδία)","(name:de_CH,Holland)","(name:de,Niederlande)","(name:da,Holland)","(name:cy,\\"Yr Iseldiroedd\\")","(name:cv,Нидерланды)","(name:cs,Nizozemsko)","(name:ce,Нидерланд)","(name:ca,\\"Països Baixos\\")","(name:bs,Holandija)","(name:br,Izelvroioù)","(name:bn,নেদারল্যান্ড্‌স)","(name:bg,Холандия)","(name:be,Нідэрланды)","(name:az,Niderland)","(name:ar,هولندا)","(name:an,\\"Países Baxos\\")","(name:af,Nederland)","(name,Nederland)"}	\N
ht	{"(official_name:sv,\\"Republiken Haiti\\")","(official_name:pl,\\"Republika Haiti\\")","(official_name:lv,\\"Haiti Republika\\")","(official_name:lt,\\"Haičio Respublika\\")","(official_name:ja,ハイチ共和国)","(official_name:it,\\"Repubblica di Haiti\\")","(official_name:id,\\"Republik Haiti\\")","(official_name:fr,\\"République d'Haïti\\")","(official_name:en,\\"Republic of Haiti\\")","(official_name:el,\\"Δημοκρατία της Αϊτής\\")","(official_name:br,\\"Republik Haiti\\")","(official_name:be,\\"Рэспубліка Гаіці\\")","(official_name,\\"Repiblik Ayiti\\")","(name:zh,海地)","(name:uk,Гаїті)","(name:th,ประเทศเฮติ)","(name:sv,Haiti)","(name:ru,Гаити)","(name:pl,Haiti)","(name:nl,Haïti)","(name:mn,Гайти)","(name:lv,Haiti)","(name:lt,Haitis)","(name:li,Haïti)","(name:la,Haitia)","(name:ja,ハイチ)","(name:it,Haiti)","(name:is,Haítí)","(name:hu,Haiti)","(name:he,האיטי)","(name:ga,Háití)","(name:fy,Haïty)","(name:fr,Haïti)","(name:fi,Haiti)","(name:fa,هائیتی)","(name:es,Haití)","(name:eo,Haitio)","(name:el,Αϊτή)","(name:da,Haiti)","(name:ca,Haití)","(name:br,Haiti)","(name:be,Гаіці)","(name:ar,هايتي)","(name:af,Haïti)","(name,Haiti)"}	\N
bj	{"(official_name:vi,\\"Cộng hoà Bénin\\")","(official_name:sv,\\"Republiken Benin\\")","(official_name:pt,\\"República do Benin\\")","(official_name:lv,\\"Beninas Republika\\")","(official_name:lt,\\"Benino Respublika\\")","(official_name:id,\\"Republik Benin\\")","(official_name:fi,\\"Beninin tasavalta\\")","(official_name,\\"République du Bénin\\")","(name:zh_pyt,Bèiníng)","(name:zh_py,Beining)","(name:zh,贝宁)","(name:uk,Бенін)","(name:tr,Benin)","(name:th,ประเทศเบนิน)","(name:sv,Benin)","(name:sl,Benin)","(name:ru,Бенин)","(name:pt,Benin)","(name:pl,Benin)","(name:nl,Benin)","(name:mn,Бенин)","(name:lv,Benina)","(name:lt,Beninas)","(name:li,Benin)","(name:lb,Benin)","(name:la,Beninum)","(name:ja,ベナン)","(name:it,Benin)","(name:is,Benín)","(name:id,Benin)","(name:hu,Benin)","(name:he,בנין)","(name:gd,Beinin)","(name:ga,Beinin)","(name:fy,Benyn)","(name:fr,Bénin)","(name:fi,Benin)","(name:fa,بنین)","(name:eu,Benin)","(name:et,Benin)","(name:es,Benín)","(name:eo,Benino)","(name:en,Benin)","(name:el,Μπενίν)","(name:de,Benin)","(name:da,Benin)","(name:cy,Benin)","(name:ca,Benín)","(name:br,Benin)","(name:be,Бенін)","(name:ar,بنن)","(name:af,Benin)","(name,Bénin)"}	\N
cr	{"(official_name:vi,\\"Cộng hoà Costa Rica\\")","(official_name:sv,\\"Republiken Costa Rica\\")","(official_name:pl,\\"Republika Kostaryki\\")","(official_name:lv,\\"Kostarikas Republika\\")","(official_name:lt,\\"Kosta Rikos Respublika\\")","(official_name:it,\\"Repubblica di Costa Rica\\")","(official_name:gd,\\"Poblachd Chosta Rica\\")","(official_name:en,\\"Republic of Costa Rica\\")","(official_name:el,\\"Δημοκρατία της Κόστα Ρίκα\\")","(official_name:be,\\"Рэспубліка Коста-Рыка\\")","(official_name,\\"República de Costa Rica\\")","(name:zh,哥斯大黎加)","(name:uk,Коста-Ріка)","(name:tr,\\"Kosta Rika\\")","(name:th,ประเทศคอสตาริกา)","(name:sv,\\"Costa Rica\\")","(name:sl,Kostarika)","(name:ru,Коста-Рика)","(name:pl,Kostaryka)","(name:mn,Коста-Рика)","(name:lv,Kostarika)","(name:lt,\\"Kosta Rika\\")","(name:la,\\"Ora Opulenta\\")","(name:ja,コスタリカ)","(name:it,\\"Costa Rica\\")","(name:is,\\"Kosta Ríka\\")","(name:id,\\"Kosta Rika\\")","(name:hu,\\"Costa Rica\\")","(name:hr,Kostarika)","(name:he,\\"קוסטה ריקה\\")","(name:ga,\\"Cósta Ríce\\")","(name:fy,\\"Kosta Rika\\")","(name:fr,\\"Costa Rica\\")","(name:fi,\\"Costa Rica\\")","(name:fa,کاستاریکا)","(name:eo,Kostariko)","(name:en,\\"Costa Rica\\")","(name:el,\\"Κόστα Ρίκα\\")","(name:da,\\"Costa Rica\\")","(name:br,\\"Costa Rica\\")","(name:be,\\"Коста Рыка\\")","(name:ar,كوستاريكا)","(name,\\"Costa Rica\\")"}	\N
dm	{"(official_name:vi,\\"Khối thịnh vượng chung Dominica\\")","(official_name:sv,\\"Samväldet Dominica\\")","(official_name:pt,\\"Comunidade da Dominica\\")","(official_name:pl,\\"Wspólnota Dominiki\\")","(official_name:lv,\\"Dominikas Sadraudzība\\")","(official_name:lt,\\"Dominikos Sandrauga\\")","(official_name:ja,ドミニカ共和国)","(official_name:id,\\"Persemakmuran Dominika\\")","(official_name:fr,\\"Commonwealth de Dominique\\")","(official_name:el,\\"Κοινοπολιτεία της Ντομίνικα\\")","(official_name:be,\\"Садружнасць Дамінікі\\")","(official_name,\\"Commonwealth of Dominica\\")","(name:zh,多明尼加)","(name:uk,Домініка)","(name:tr,Dominika)","(name:th,ประเทศโดมินิกา)","(name:sv,Dominica)","(name:sl,Dominika)","(name:ru,Доминика)","(name:pt,Dominica)","(name:pl,Dominika)","(name:mn,Доминика)","(name:lv,Dominika)","(name:lt,Dominika)","(name:ja,ドミニカ)","(name:it,Dominìca)","(name:is,Dóminíka)","(name:id,Dominika)","(name:hu,\\"Dominikai Közösség\\")","(name:hr,Dominika)","(name:he,דומיניקה)","(name:gd,Doiminicia)","(name:ga,Doiminice)","(name:fy,Dominika)","(name:fr,Dominique)","(name:fi,Dominica)","(name:fa,دومینیکا)","(name:eu,Dominika)","(name:es,Dominica)","(name:eo,Dominiko)","(name:en,Dominica)","(name:el,Ντομίνικα)","(name:br,Dominica)","(name:be,Дамініка)","(name:ar,دومينيكا)","(name:af,Dominika)","(name,Dominica)"}	\N
gm	{"(official_name:vi,\\"Cộng hòa Gambia\\")","(official_name:sv,\\"Republiken Gambia\\")","(official_name:pt,\\"República da Gâmbia\\")","(official_name:lv,\\"Gambijas Republika\\")","(official_name:ja,ガンビア共和国)","(official_name:id,\\"Republik Gambia\\")","(official_name:gd,\\"Poblachd na Gaimbia\\")","(official_name:et,\\"Gambia Vabariik\\")","(official_name:el,\\"Δημοκρατία της Γκάμπια\\")","(official_name:be,\\"Рэспубліка Гамбія\\")","(official_name,\\"Republic of The Gambia\\")","(name:zh_pyt,Gāngbǐyà)","(name:zh_py,Gangbiya)","(name:zh,冈比亚)","(name:vi,Gambia)","(name:uk,Гамбія)","(name:tr,Gambiya)","(name:th,ประเทศแกมเบีย)","(name:sv,Gambia)","(name:sl,Gambija)","(name:ru,Гамбия)","(name:pt,Gâmbia)","(name:pl,Gambia)","(name:no,Gambia)","(name:nn,Gambia)","(name:nl,Gambia)","(name:nb,Gambia)","(name:mn,Гамби)","(name:lv,Gambija)","(name:lt,Gambija)","(name:li,Gambia)","(name:lb,Gambia)","(name:la,Gambia)","(name:ja,ガンビア)","(name:it,Gambia)","(name:is,Gambía)","(name:id,Gambia)","(name:hu,Gambia)","(name:hr,Gambija)","(name:he,גמביה)","(name:gd,\\"A' Ghaimbia\\")","(name:ga,\\"An Ghaimbia\\")","(name:fy,Gambia)","(name:fr,Gambie)","(name:fi,Gambia)","(name:fa,گامبیا)","(name:et,Gambia)","(name:es,Gambia)","(name:eo,Gambio)","(name:el,Γκάμπια)","(name:de,Gambia)","(name:da,Gambia)","(name:cy,\\"Y Gambia\\")","(name:ca,Gàmbia)","(name:br,Gambia)","(name:be,Гамбія)","(name:ar,غامبيا)","(name:af,Gambië)","(name,\\"The Gambia\\")"}	\N
gn	{"(official_name:vi,\\"Cộng hòa nhân dân cách mạng Guinée\\")","(official_name:sv,\\"Republiken Guinea\\")","(official_name:pt,\\"República da Guiné\\")","(official_name:lv,\\"Gvinejas Republika\\")","(official_name:lt,\\"Gvinėjos Respublika\\")","(official_name:id,\\"Republik Guinea\\")","(official_name:gd,\\"Poblachd Ghini\\")","(official_name:et,\\"Guinea Vabariik\\")","(official_name:el,\\"Δημοκρατία της Γουινέας\\")","(name:zh_pyt,Jīnèiyà)","(name:zh_py,Jineiya)","(name:zh,几内亚)","(name:uk,Ґвінея)","(name:tr,Gine)","(name:th,ประเทศกินี)","(name:sv,Guinea)","(name:sl,Gvineja)","(name:ru,Гвинея)","(name:pt,Guiné)","(name:pl,Gwinea)","(name:nl,Guinee)","(name:mn,Гвиней)","(name:lv,Gvineja)","(name:lt,Gvinėja)","(name:lb,Guinea)","(name:la,Guinea)","(name:it,Guinea)","(name:is,Gínea)","(name:id,Guinea)","(name:hu,Guinea)","(name:hr,Gvineja)","(name:he,גינאה)","(name:gd,Gini)","(name:ga,\\"An Ghuine\\")","(name:fy,Guinee)","(name:fr,Guinée)","(name:fi,Guinea)","(name:fa,گینه)","(name:et,Guinea)","(name:es,Guinea)","(name:eo,Gvineo)","(name:en,Guinea)","(name:el,Γουινέα)","(name:de,Guinea)","(name:da,Guinea)","(name:cy,Guinée)","(name:ca,\\"República de Guinea\\")","(name:br,Ginea)","(name:be,Гвінея)","(name:ar,غينيا)","(name:af,Guinee)","(name,Guinée)"}	\N
hn	{"(official_name:vi,\\"Cộng hoà Honduras\\")","(official_name:sv,\\"Republiken Honduras\\")","(official_name:pl,\\"Republika Hondurasu\\")","(official_name:lv,\\"Hondurasas Republika\\")","(official_name:lt,\\"Hondūro Respublika\\")","(official_name:id,\\"Republik Honduras\\")","(official_name:el,\\"Δημοκρατία της Ονδούρας\\")","(official_name:be,\\"Рэспубліка Гандурас\\")","(official_name,\\"República de Honduras\\")","(name:zh,洪都拉斯)","(name:uk,Гондурас)","(name:th,ประเทศฮอนดูรัส)","(name:sv,Honduras)","(name:ru,Гондурас)","(name:pl,Honduras)","(name:mn,Гондурас)","(name:lv,Hondurasa)","(name:lt,Hondūras)","(name:la,Honduria)","(name:ja,ホンジュラス)","(name:it,Honduras)","(name:is,Hondúras)","(name:hu,Honduras)","(name:he,הונדורס)","(name:gd,Hondùras)","(name:ga,Hondúras)","(name:fy,Hondueras)","(name:fr,Honduras)","(name:fi,Honduras)","(name:fa,هندوراس)","(name:eo,Honduro)","(name:en,Honduras)","(name:el,Ονδούρα)","(name:da,Honduras)","(name:ca,Hondures)","(name:br,Honduras)","(name:be,Гандурас)","(name:ar,هندوراس)","(name,Honduras)"}	\N
il	{"(official_name:sv,\\"Staten Israel\\")","(official_name:ru,\\"Государство Израиль\\")","(official_name:pt,\\"Estado de Israel\\")","(official_name:pl,\\"Państwo Izraela\\")","(official_name:lv,\\"Izraēlas Valsts\\")","(official_name:lb,\\"Staat Israel\\")","(official_name:ja,イスラエル国)","(official_name:gd,\\"Stàit Iosrael\\")","(official_name:et,\\"Iisraeli Riik\\")","(official_name:es,\\"Estado de Israel\\")","(official_name:en,\\"State of Israel\\")","(official_name:el,\\"Κράτος του Ισραήλ\\")","(official_name,\\"מדינת ישראל\\")","(name:zh_pyt,Yǐsèliè)","(name:zh_py,Yiselie)","(name:zh,以色列)","(name:vi,Israel)","(name:uk,Ізра́їль)","(name:tr,İsrail)","(name:th,ประเทศอิสราเอล)","(name:sv,Israel)","(name:sl,Izrael)","(name:ru,Израиль)","(name:pt,Israel)","(name:pl,Izrael)","(name:nl,Israël)","(name:mn,Израйль)","(name:lv,Izraēla)","(name:lt,Izraelis)","(name:li,Israël)","(name:lb,Israel)","(name:la,Israel)","(name:ja,イスラエル)","(name:it,Israele)","(name:is,Ísrael)","(name:id,Israel)","(name:hy,Իսրայել)","(name:hu,Izrael)","(name:hr,Izrael)","(name:he,ישראל)","(name:haw,ʻIseraʻela)","(name:gd,Iosrael)","(name:ga,Iosrael)","(name:fy,Israel)","(name:fr,Israël)","(name:fi,Israel)","(name:fa,اسرائیل)","(name:et,Iisrael)","(name:es,Israel)","(name:eo,Israelo)","(name:en,Israel)","(name:el,Ισραήλ)","(name:de,Israel)","(name:da,Israel)","(name:cy,Israel)","(name:ca,Israel)","(name:br,Israel)","(name:be,Ізраіль)","(name:ar,إسرائيل)","(name:af,Israel)","(name,ישראל)"}	\N
lb	{"(official_name:vi,\\"Cộng hòa Liban\\")","(official_name:sv,\\"Republiken Libanon\\")","(official_name:pt,\\"República do Líbano\\")","(official_name:pl,\\"Republika Libańska\\")","(official_name:lv,\\"Libānas Republika\\")","(official_name:lb,\\"Republik Libanon\\")","(official_name:ja,レバノン共和国)","(official_name:it,\\"Repubblica Libanese\\")","(official_name:id,\\"Republik Lebanon\\")","(official_name:et,\\"Liibanoni Vabariik\\")","(official_name:en,\\"Republic of Lebanon\\")","(official_name:br,\\"Republik Liban\\")","(official_name,\\"Republic of Lebanon\\")","(name:zh_pyt,Líbānèn)","(name:zh_py,Libanen)","(name:zh,黎巴嫩)","(name:vi,Liban)","(name:uk,Ліван)","(name:tr,Lübnan)","(name:th,ประเทศเลบานอน)","(name:sv,Libanon)","(name:sl,Libanon)","(name:ru,Ливан)","(name:pt,Líbano)","(name:pl,Liban)","(name:no,Libanon)","(name:nn,Libanon)","(name:nl,Libanon)","(name:nb,Libanon)","(name:mn,Ливан)","(name:lv,Libāna)","(name:lt,Libanas)","(name:li,Libanon)","(name:lb,Libanon)","(name:la,Libanus)","(name:ja,レバノン)","(name:it,Libano)","(name:is,Líbanon)","(name:id,Lebanon)","(name:hu,Libanon)","(name:hr,Libanon)","(name:he,לבנון)","(name:haw,Lepanona)","(name:gd,Leabanon)","(name:ga,\\"An Liobáin\\")","(name:fy,Libanon)","(name:fr,Liban)","(name:fi,Libanon)","(name:fa,لبنان)","(name:et,Liibanon)","(name:es,Líbano)","(name:eo,Libano)","(name:en,Lebanon)","(name:el,Λίβανος)","(name:de,Libanon)","(name:da,Libanon)","(name:cy,Libanus)","(name:ca,Líban)","(name:br,Liban)","(name:be,Ліван)","(name:ar,لبنان)","(name:af,Libanon)","(name,\\"لبنان  Lebanon\\")"}	\N
lt	{"(official_name:vi,\\"Cộng hòa Litva\\")","(official_name:sv,\\"Republiken Litauen\\")","(official_name:sk,\\"Litovská republika\\")","(official_name:pl,\\"Republika Litewska\\")","(official_name:lv,\\"Lietuvas Republika\\")","(official_name:lt,\\"Lietuvos Respublika\\")","(official_name:it,\\"Repubblica di Lituania\\")","(official_name:id,\\"Republik Lituania\\")","(official_name:fr,\\"République de Lituanie\\")","(official_name:et,\\"Leedu Vabariik\\")","(official_name:es,\\"República de Lituania\\")","(official_name:en,\\"Republic of Lithuania\\")","(official_name:el,\\"Δημοκρατία της Λιθουανίας\\")","(official_name:be,\\"Літоўская Рэспубліка\\")","(official_name,\\"Republic of Lithuania\\")","(name:zh_pyt,Lìtáowǎn)","(name:zh_py,Litaowan)","(name:zh,立陶宛)","(name:vi,Litva)","(name:uk,Литва)","(name:tr,Litvanya)","(name:th,ประเทศลิทัวเนีย)","(name:sv,Litauen)","(name:sl,Litva)","(name:sk,Litva)","(name:ru,Литва)","(name:pl,Litwa)","(name:nl,Litouwen)","(name:mn,Литва)","(name:lv,Lietuva)","(name:li,Litauwe)","(name:lb,Litauen)","(name:la,Lituania)","(name:ja,リトアニア)","(name:it,Lituania)","(name:is,Litháen)","(name:id,Lituania)","(name:hu,Litvánia)","(name:hr,Litva)","(name:he,לטביה)","(name:haw,Lituania)","(name:gd,Liotuàinia)","(name:ga,\\"An Liotuáin\\")","(name:fy,Litouwen)","(name:fr,Lituanie)","(name:fi,Liettua)","(name:fa,لیتوانی)","(name:et,Leedu)","(name:es,Lituania)","(name:eo,Litovio)","(name:en,Lithuania)","(name:el,Λιθουανία)","(name:de,Litauen)","(name:da,Litauen)","(name:cy,Lithwania)","(name:ca,Lituània)","(name:br,Lituania)","(name:be,Літва)","(name:ar,ليتوانيا)","(name:af,Litaue)","(name,Lietuva)"}	\N
mk	{"(official_name:vi,\\"Cộng hòa Macedonia\\")","(official_name:sv,\\"Republiken Makedonien\\")","(official_name:sl,\\"Republika Makedonija\\")","(official_name:sk,\\"Macedónska republika\\")","(official_name:pt,\\"República da Macedônia\\")","(official_name:pl,\\"Republika Macedonii\\")","(official_name:lv,\\"Maķedonijas Republika\\")","(official_name:ja,マケドニア旧ユーゴスラビア共和国)","(official_name:it,\\"Repubblica di Macedonia\\")","(official_name:fr,\\"République de Macédoine\\")","(official_name:et,\\"Makedoonia Vabariik\\")","(official_name:es,\\"República de Macedonia\\")","(official_name:en,\\"Republic of Macedonia\\")","(official_name:ca,\\"Exrepública Iugoslava de Macedònia\\")","(official_name:br,\\"Republik Makedonia\\")","(official_name:be,\\"Рэспубліка Македонія \\")","(official_name:af,\\"Republiek van Masedonië\\")","(official_name,\\"Република Македонија\\")","(name:zh_pyt,Mǎqídùn)","(name:zh_py,Maqidun)","(name:zh,马其顿)","(name:vi,Macedonia)","(name:uk,Македонія)","(name:tr,Makedonya)","(name:th,ประเทศมาซิโดเนีย)","(name:sv,Makedonien)","(name:sl,Makedonija)","(name:sk,Macedónsko)","(name:ru,Македония)","(name:pt,Macedônia)","(name:pl,Macedonia)","(name:nl,Macedonië)","(name:mn,Македон)","(name:lv,Maķedonija)","(name:lt,Makedonija)","(name:li,Macedonië)","(name:lb,Makedonien)","(name:la,\\"Respublica Macedonica\\")","(name:ja,マケドニア)","(name:it,Macedonia)","(name:is,Makedónía)","(name:id,\\"Republik Makedonia\\")","(name:hu,Macedónia)","(name:hr,Makedonija)","(name:he,מקדוניה)","(name:haw,\\"Repupalika ‘o Makekonia\\")","(name:gd,Masadoinia)","(name:ga,\\"An Mhacadóin\\")","(name:fy,Massedoanje)","(name:fr,Macédoine)","(name:fi,Makedonia)","(name:fa,مقدونیه)","(name:et,Makedoonia)","(name:es,Macedonia)","(name:eo,Makedonio)","(name:en,Macedonia)","(name:de,Mazedonien)","(name:da,Makedonien)","(name:cy,\\"Gweriniaeth Macedonia\\")","(name:ca,Macedònia)","(name:br,Makedonia)","(name:be,Македонія)","(name:ar,مقدونيا)","(name:af,Masedonië)","(name,Македонија)"}	\N
nr	{"(official_name:vi,\\"Cộng hòa Nauru\\")","(official_name:sv,\\"Republiken Nauru\\")","(official_name:pl,\\"Republika Nauru\\")","(official_name:lv,\\"Nauru Republika\\")","(official_name:lt,\\"Nauru Respublika\\")","(official_name:lb,\\"Republik Nauru\\")","(official_name:id,\\"Republik Nauru\\")","(official_name:gd,\\"Poblachd Nauru\\")","(official_name:es,\\"República de Nauru\\")","(official_name:el,\\"Δημοκρατία του Ναουρού\\")","(official_name,\\"Republic of Nauru;Republik Naoero\\")","(name:zh,瑙魯)","(name:uk,Науру)","(name:th,ประเทศนาอูรู)","(name:sv,Nauru)","(name:ru,Науру)","(name:pl,Nauru)","(name:mn,Науру)","(name:lv,Nauru)","(name:li,Naoeroe)","(name:is,Nárú)","(name:hu,Nauru)","(name:he,נאורו)","(name:ga,Nárú)","(name:fy,Naurû)","(name:fr,Nauru)","(name:fi,Nauru)","(name:fa,نائورو)","(name:eo,Nauro)","(name:en,Nauru)","(name:el,Ναουρού)","(name:da,Nauru)","(name:br,Nauru)","(name:be,Наўру)","(name:ar,ناورو)","(name,Nauru)"}	\N
pg	{"(official_name:vi,\\"Quốc gia Độc lập Papua New Guinea\\")","(official_name:pl,\\"Niezależne Państwo Papui-Nowej Gwinei\\")","(official_name:lv,\\"Papua-Jaungvinejas Neatkarīgā Valsts\\")","(official_name:et,\\"Paapua Uus-Guinea Iseseisvusriik\\")","(official_name:es,\\"Estado Independiente de Papúa Nueva Guínea\\")","(official_name,\\"Independent State of Papua New Guinea;Independen Stet bilong Papua Niugini\\")","(name:zh,巴布亚新几内亚)","(name:uk,\\"Папуа-Нова Гвінея\\")","(name:tr,\\"Papua -Yeni Gine\\")","(name:th,ประเทศปาปัวนิวกินี)","(name:sv,\\"Papua Nya Guinea\\")","(name:sl,\\"Papua Nova Gvineja\\")","(name:ru,\\"Папуа-Новая Гвинея\\")","(name:pl,\\"Papua-Nowa Gwinea\\")","(name:nl,Papoea-Nieuw-Guinea)","(name:mn,\\"Папуа-Шинэ Гвиней\\")","(name:lv,Papua-Jaungvineja)","(name:lt,\\"Papua ir Naujoji Gvinėja\\")","(name:li,Papoea-Nui-Guinea)","(name:lb,Papua-Neiguinea)","(name:la,\\"Papua Nova Guinea\\")","(name:it,\\"Papua Nuova Guinea\\")","(name:is,\\"Papúa Nýja-Gínea\\")","(name:id,\\"Papua Nugini\\")","(name:hu,\\"Pápua Új-Guinea\\")","(name:hr,\\"Papua Nova Gvineja\\")","(name:he,\\"פפואה גינאה החדשה\\")","(name:gd,\\"Papua Gini-Nuadh\\")","(name:ga,\\"Nua-Ghuine Phapua\\")","(name:fy,\\"Papoea Nij-Guinea\\")","(name:fr,Papouasie-Nouvelle-Guinée)","(name:fi,Papua-Uusi-Guinea)","(name:fa,\\"پاپوآ گینه نو\\")","(name:et,\\"Paapua Uus-Guinea\\")","(name:es,\\"Papúa Nueva Guinea\\")","(name:eo,Papuo-Nov-Gvineo)","(name:en,\\"Papua New Guinea\\")","(name:de,Papua-Neuguinea)","(name:da,\\"Papua Ny Guinea\\")","(name:cy,\\"Papua Guinea Newydd\\")","(name:ca,\\"Papua Nova Guinea\\")","(name:br,\\"Papoua Ginea Nevez\\")","(name:be,\\"Папуа-Новая Гвінея \\")","(name:ar,\\"بابوا نيوغينيا\\")","(name:af,Papoea-Nieu-Guinee)","(name,\\"Papua New Guinea\\")"}	\N
re	{"(official_name:lv,\\"Francijas Reinjonas departaments\\")","(official_name,\\"Région de La Réunion\\")","(name:zh_pyt,Liúníwāng)","(name:zh_py,Liuniwang)","(name:zh,留尼汪)","(name:uk,Реюньйон)","(name:th,เรอูนียง)","(name:sv,Réunion)","(name:sl,Reunion)","(name:ru,Реюньон)","(name:pl,Reunion)","(name:mn,Реюньон)","(name:lv,Reinjona)","(name:lt,Reunionas)","(name:la,Reunio)","(name:it,Riunione)","(name:is,Réunion)","(name:hu,Réunion)","(name:he,ראוניון)","(name:fr,\\"La Réunion\\")","(name:fi,Réunion)","(name:fa,رئونیون)","(name:es,\\"La Reunión\\")","(name:eo,Reunio)","(name:el,Ρεϊνιόν)","(name:da,Reunion)","(name:ca,\\"Illa de la Reunió\\")","(name:br,\\"Ar Reunion\\")","(name:be,Руньён)","(name:ar,ريونيون)","(name:af,Réunion)","(name,Réunion)"}	\N
sd	{"(official_name:vi,\\"Cộng hòa Sudan\\")","(official_name:sv,\\"Republiken Sudan\\")","(official_name:pt,\\"República do Sudão\\")","(official_name:lb,\\"Republik Sudan\\")","(official_name:ja,スーダン共和国)","(official_name:id,\\"Republik Sudan\\")","(official_name:fr,\\"République du Soudan\\")","(official_name:et,\\"Sudaani Vabariik\\")","(official_name:en,\\"Republic of Sudan\\")","(official_name:el,\\"Δημοκρατία του Σουδάν\\")","(official_name:br,\\"Republik Soudan\\")","(official_name,\\"جمهورية السودان\\")","(name:zh_pyt,Sūdān)","(name:zh_py,Sudan)","(name:zh,苏丹)","(name:vi,Sudan)","(name:uk,Судан)","(name:tr,Sudan)","(name:th,ประเทศซูดาน)","(name:sv,Sudan)","(name:sl,Sudan)","(name:ru,Судан)","(name:pt,Sudão)","(name:pl,Sudan)","(name:nl,Soedan)","(name:mn,Судан)","(name:lv,Sudāna)","(name:lt,Sudanas)","(name:li,Soedaan)","(name:lb,Sudan)","(name:la,Sudania)","(name:ja,スーダン)","(name:it,Sudan)","(name:is,Súdan)","(name:id,Sudan)","(name:hu,Szudán)","(name:hr,Sudan)","(name:he,סודן)","(name:haw,Sudana)","(name:gd,Sudan)","(name:ga,\\"An tSúdáin\\")","(name:fy,Sûdan)","(name:fr,Soudan)","(name:fi,Sudan)","(name:fa,سودان)","(name:et,Sudaan)","(name:es,Sudán)","(name:eo,Sudano)","(name:en,Sudan)","(name:el,Σουδάν)","(name:de,Sudan)","(name:da,Sudan)","(name:cy,Sudan)","(name:ca,\\"Sudan \\")","(name:br,Soudan)","(name:be,Судан)","(name:ar,السودان)","(name:af,Soedan)","(name,\\"السودان ‎al-Sūdān\\")"}	\N
lu	{"(official_name:vi,\\"Đại công quốc Luxembourg\\")","(official_name:sv,\\"Storhertigdömet Luxemburg\\")","(official_name:sl,\\"Véliko vójvodstvo Lúksemburg\\")","(official_name:sk,\\"Luxemburské veľkovojvodstvo\\")","(official_name:pl,\\"Wielkie Księstwo Luksemburga\\")","(official_name:lv,\\"Luksemburgas Lielhercogiste\\")","(official_name:lt,\\"Liuksemburgo Didžioji Hercogystė\\")","(official_name:lb,\\"Groussherzogtum Lëtzebuerg\\")","(official_name:ja,ルクセンブルク大公国)","(official_name:it,\\"Granducato di Lussemburgo\\")","(official_name:id,\\"Keharyapatihan Luksemburg\\")","(official_name:fr,\\"Grand-Duché de Luxembourg\\")","(official_name:es,\\"Gran Ducado de Luxemburgo\\")","(official_name:el,\\"Μέγα Δουκάτο του Λουξεμβούργου\\")","(official_name:br,\\"Dugelezh Veur Luksembourg\\")","(official_name,\\"Groussherzogtum Lëtzebuerg\\")","(name:zh_pyt,Lúsenbao)","(name:zh_py,Lusenbao)","(name:zh,卢森堡)","(name:uk,Люксембург)","(name:tr,Lüksemburg)","(name:th,ประเทศลักเซมเบิร์ก)","(name:sv,Luxemburg)","(name:sl,Luksemburg)","(name:sk,Luxembursko)","(name:ru,Люксембург)","(name:pl,Luksemburg)","(name:nl,Luxemburg)","(name:mn,Люксембург)","(name:lv,Luksemburga)","(name:lt,Liuksemburgas)","(name:lb,Lëtzebuerg)","(name:la,Luxemburgum)","(name:ja,ルクセンブルク)","(name:it,Lussemburgo)","(name:is,Lúxemborg)","(name:id,Luksemburg)","(name:hy,Լյուքսեմբուրգ)","(name:hu,Luxemburg)","(name:hr,Luksemburg)","(name:he,לוקסמבורג)","(name:haw,Lukemapuka)","(name:gd,Lucsamburg)","(name:ga,Lucsamburg)","(name:fy,Lúksemboarch)","(name:fr,Luxembourg)","(name:fi,Luxemburg)","(name:fa,لوکزامبورگ)","(name:es,Luxemburgo)","(name:eo,Luksemburgo)","(name:en,Luxembourg)","(name:el,Λουξεμβούργο)","(name:de,Luxemburg)","(name:cy,Lwcsembwrg)","(name:ca,Luxemburg)","(name:br,Luksembourg)","(name:be,Люксембург)","(name:ar,لكسمبرغ)","(name:af,Luxemburg)","(name,Luxembourg)"}	\N
td	{"(official_name:vi,\\"Cộng hoà Tchad\\")","(official_name:sv,\\"Republiken Tchad\\")","(official_name:pt,\\"República do Chade\\")","(official_name:id,\\"Republik Chad\\")","(official_name:et,\\"Tšaadi Vabariik\\")","(official_name:en,\\"Republic of Chad\\")","(official_name:el,\\"Δημοκρατία του Τσαντ\\")","(official_name:br,\\"Republik Tchad\\")","(official_name,\\"République du Tchad;جمهورية تشاد ‎\\")","(name:zh_pyt,Zhàdé)","(name:zh_py,Zhade)","(name:zh,乍得)","(name:vi,Tchad)","(name:uk,Чад)","(name:tr,Çad)","(name:th,ประเทศชาด)","(name:sv,Tchad)","(name:sl,Čad)","(name:ru,Чад)","(name:pt,Chade)","(name:pl,Czad)","(name:nl,Tsjaad)","(name:mn,Чад)","(name:lt,Čadas)","(name:li,Tsjaad)","(name:lb,Tschad)","(name:la,Tzadia)","(name:it,Ciad)","(name:is,Tsjad)","(name:id,Chad)","(name:hu,Csád)","(name:hr,Čad)","(name:he,צ'אד)","(name:gd,\\"An t-Siad\\")","(name:ga,Sead)","(name:fy,Tsjaad)","(name:fr,Tchad)","(name:fi,Tšad)","(name:fa,چاد)","(name:et,Tšaad)","(name:es,Chad)","(name:eo,Ĉado)","(name:en,Chad)","(name:el,Τσαντ)","(name:de,Tschad)","(name:da,Tchad)","(name:cy,Tchad)","(name:ca,Txad)","(name:br,Tchad)","(name:be,Чад)","(name:ar,تشاد)","(name:af,Tsjaad)","(name,\\"Tchad / تشاد\\")"}	\N
vn	{"(official_name:sv,\\"Socialistiska republiken Vietnam\\")","(official_name:pt,\\"República Socialista do Vietnã\\")","(official_name:pl,\\"Socjalistyczna Republika Wietnamu\\")","(official_name:lb,\\"Sozialistesch Republik Vietnam\\")","(official_name:ja,ベトナム社会主義共和国)","(official_name:it,\\"Repubblica Socialista del Vietnam\\")","(official_name:id,\\"Republik Sosialis Vietnam\\")","(official_name:et,\\"Vietnami Sotsialistlik Vabariik\\")","(official_name:el,\\"Σοσιαλιστική Δημοκρατία του Βιετνάμ\\")","(official_name:ca,\\"República Socialista del Vietnam\\")","(official_name:be,\\"В'етнам \\")","(official_name,\\"Cộng Hòa Xã Hội Chủ Nghĩa Việt Nam\\")","(name:zh_pyt,Yuènán)","(name:zh_py,Yuenan)","(name:zh,越南)","(name:vi,\\"Việt Nam\\")","(name:uk,В'єтнам)","(name:tr,Vietnam)","(name:th,ประเทศเวียดนาม)","(name:sv,Vietnam)","(name:sl,Vietnam)","(name:ru,Вьетнам)","(name:pt,Vietnã)","(name:pl,Wietnam)","(name:nl,Vietnam)","(name:mn,Вьетнам)","(name:lv,Vjetnama)","(name:lt,Vietnamas)","(name:li,Viëtnam)","(name:lb,Vietnam)","(name:la,Vietnamia)","(name:ja,ベトナム)","(name:it,Vietnam)","(name:is,Víetnam)","(name:id,Vietnam)","(name:hy,Վիետնամ)","(name:hu,Vietnam)","(name:hr,Vietnam)","(name:he,ויאטנם)","(name:haw,Wiekanama)","(name:gd,Bhiet-Nam)","(name:ga,Vítneam)","(name:fy,Fietnam)","(name:fr,\\"Viêt Nam\\")","(name:fi,Vietnam)","(name:fa,ویتنام)","(name:et,Vietnam)","(name:es,Vietnam)","(name:eo,Vjetnamio)","(name:en,Vietnam)","(name:el,Βιετνάμ)","(name:de,Vietnam)","(name:da,Vietnam)","(name:cy,\\"Fiet Nam\\")","(name:ca,Vietnam)","(name:br,\\"Viêt Nam\\")","(name:be,В'етнам)","(name:ar,\\"فييت نام\\")","(name:af,Viëtnam)","(name,\\"Việt Nam\\")"}	\N
wf	{"(official_name:vi,\\"Lãnh thổ các đảo Wallis và Futuna\\")","(official_name:et,\\"Wallise ja Futuna ühisala\\")","(official_name:es,\\"Territorio de las Islas Wallis y Futuna\\")","(official_name:en,\\"Territory of Wallis and Futuna Islands\\")","(official_name,\\"Territoire des Îles Wallis et Futuna\\")","(name:zh-min-nan,\\"Wallis kap Futuna\\")","(name:zh,瓦利斯和富图纳群岛)","(name:wo,\\"Wallis ak Futuna\\")","(name:vi,\\"Wallis và Futuna\\")","(name:uk,\\"Волліс і Футуна\\")","(name:ug,\\"Wallis we Futuna Taqim Aralliri\\")","(name:tr,\\"Wallis ve Futuna Adaları\\")","(name:th,หมู่เกาะวาลลิสและหมู่เกาะฟุตูนา)","(name:ta,\\"வலிசும் புட்டூனாவும்\\")","(name:sw,\\"Wallis na Futuna\\")","(name:sv,\\"Wallis- och Futunaöarna\\")","(name:sr,\\"Валис и Футуна\\")","(name:sm,\\"Wallis and Futuna\\")","(name:sl,\\"Wallis in Futuna\\")","(name:sk,\\"Wallis a Futuna\\")","(name:simple,\\"Wallis and Futuna\\")","(name:sh,\\"Wallis i Futuna\\")","(name:se,\\"Wallis ja Futuna\\")","(name:ru,\\"Уоллис и Футуна\\")","(name:ro,\\"Wallis şi Futuna\\")","(name:pt,\\"Wallis e Futuna\\")","(name:pl,\\"Wallis i Futuna\\")","(name:oc,\\"Wallis e Futuna\\")","(name:no,\\"Wallis- og Futunaøyene\\")","(name:nn,\\"Wallis- og Futunaøyane\\")","(name:nl,\\"Wallis en Futuna\\")","(name:ms,\\"Wallis dan Futuna\\")","(name:mr,\\"वालिस व फुतुना\\")","(name:mn,\\"Уоллис ба Футуна\\")","(name:lv,\\"Volisa un Futuna\\")","(name:lt,\\"Walliso ir Futuna salos\\")","(name:lij,\\"Wallis e Fortuna\\")","(name:lb,\\"Wallis a Futuna\\")","(name:la,\\"Vallis et Futuna\\")","(name:kw,\\"Wallis ha Futuna\\")","(name:ko,\\"왈리스 퓌튀나\\")","(name:jv,\\"Wallis lan Futuna\\")","(name:ja,ウォリス・フツナ)","(name:it,\\"Wallis e Futuna\\")","(name:is,\\"Wallis- og Fútúnaeyjar\\")","(name:io,\\"Wallis e Futuna Insuli\\")","(name:id,\\"Wallis dan Futuna\\")","(name:hu,\\"Wallis és Futuna\\")","(name:hr,\\"Wallis i Futuna\\")","(name:he,\\"ואליס ופוטונה\\")","(name:gl,\\"Wallis e Futuna\\")","(name:ga,\\"Vailís agus Futúna\\")","(name:fy,\\"Wallis en Fûtûna\\")","(name:frp,Valis-et-Futuna)","(name:fr,Wallis-et-Futuna)","(name:fi,\\"Wallis- ja Futunasaaret\\")","(name:fa,\\"والیس و فوتونا\\")","(name:eu,\\"Wallis eta Futuna\\")","(name:et,\\"Wallis ja Futuna\\")","(name:es,\\"Wallis y Futuna\\")","(name:eo,\\"Valiso kaj Futuno\\")","(name:en,\\"Wallis and Futuna Islands\\")","(name:el,\\"Ουώλλις και Φουτούνα\\")","(name:dv,\\"ވާލީ އަދި ފުތޫނާ\\")","(name:de,\\"Wallis und Futuna\\")","(name:da,\\"Wallis og Futuna\\")","(name:cy,\\"Wallis a Futuna\\")","(name:cs,\\"Wallis a Futuna\\")","(name:ca,\\"Wallis i Futuna\\")","(name:br,\\"Wallis ha Futuna\\")","(name:bpy,\\"ৱাল্লিস বারো ফুটুনা\\")","(name:bg,\\"Уолис и Футуна\\")","(name:be-x-old,\\"Выспы Ўоліс і Футуна\\")","(name:be,\\"Уоліс і Футуна\\")","(name:ast,\\"Wallis y Futuna\\")","(name:ar,\\"جزر واليس وفوتونا\\")","(name:an,\\"Wallis e Futuna\\")","(name:af,Wallis-en-Futuna)","(name,Wallis-et-Futuna)"}	\N
za	{"(official_name:vi,\\"Cộng hòa Nam Phi\\")","(official_name:ve,\\"Riphabuḽiki ya Afurika Tshipembe\\")","(official_name:ts,\\"Riphabliki ra Afrika Dzonga\\")","(official_name:sv,\\"Republiken Sydafrika\\")","(official_name:sl,\\"Republika Južna Afrika\\")","(official_name:ru,\\"Южно-Африканская Республика\\")","(official_name:pt,\\"República da África do Sul\\")","(official_name:lb,\\"Republik Südafrika\\")","(official_name:ja,南アフリカ共和国)","(official_name:id,\\"Republik Afrika Selatan\\")","(official_name:gd,\\"Poblachd Afraga a Deas\\")","(official_name:fr,\\"République d'Afrique du Sud\\")","(official_name:en,\\"Republic of South Africa\\")","(official_name:br,\\"Republik Suafrika\\")","(official_name,\\"Republic of South Africa\\")","(name:zu,\\"Ningizimu Afrika\\")","(name:zh_pyt,\\"Nán Fēi\\")","(name:zh_py,\\"Nan Fei\\")","(name:zh,南非)","(name:xh,\\"uMzantsi Afrika\\")","(name:vi,\\"Nam Phi\\")","(name:ve,\\"Afurika Tshipembe\\")","(name:uk,\\"Південно-Африканська Республіка\\")","(name:ts,Afrika-Dzonga)","(name:tr,\\"Güney Afrika\\")","(name:tn,\\"Aferika Borwa\\")","(name:th,ประเทศแอฟริกาใต้)","(name:sv,Sydafrika)","(name:st,\\"Afrika Borwa\\")","(name:ss,\\"INingizimu Afrika\\")","(name:sl,\\"Južna Afrika\\")","(name:ru,\\"Южная Африка\\")","(name:pt,\\"África do Sul\\")","(name:pl,\\"Republika Południowej Afryki\\")","(name:nl,Zuid-Afrika)","(name:mn,\\"Өмнөд Африк\\")","(name:lt,\\"Pietų Afrikos Respublika\\")","(name:li,Zuud-Afrika)","(name:lb,Südafrika)","(name:la,\\"Africa Australis\\")","(name:ja,南アフリカ)","(name:it,Sudafrica)","(name:is,Suður-Afríka)","(name:id,\\"Afrika Selatan\\")","(name:hu,\\"Dél-Afrikai Köztársaság\\")","(name:hr,\\"Južnoafrička Republika\\")","(name:he,\\"דרום אפריקה\\")","(name:haw,\\"ʻApelika Hema\\")","(name:gd,\\"Afraga a Deas\\")","(name:ga,\\"An Afraic Theas\\")","(name:fy,Súd-Afrika)","(name:fr,\\"Afrique du Sud\\")","(name:fi,Etelä-Afrikka)","(name:fa,\\"آفریقای جنوبی\\")","(name:et,\\"Lõuna-Aafrika Vabariik\\")","(name:es,Sudáfrica)","(name:eo,Sudafriko)","(name:en,\\"South Africa\\")","(name:el,\\"Νότια Αφρική\\")","(name:de,Südafrika)","(name:da,Sydafrika)","(name:cy,\\"De Affrica\\")","(name:ca,Sud-àfrica)","(name:br,Suafrika)","(name:be,\\"Паўднёва-Афрыканская Рэспубліка\\")","(name:ar,\\"جنوب أفريقيا\\")","(name:af,Suid-Afrika)","(name,\\"South Africa\\")"}	\N
gg	{"(official_name:vi,\\"Địa hạt Guernsey\\")","(name:zh_pyt,\\"Géēnxī Dǎo\\")","(name:zh_py,\\"Geenxi Dao\\")","(name:zh,格恩西岛)","(name:uk,Гернсі)","(name:th,เกิร์นซีย์)","(name:sv,Guernsey)","(name:sk,Guernsey)","(name:ru,Гернси)","(name:pl,Guernsey)","(name:mn,Гернси)","(name:lv,Gērnsija)","(name:lt,Gernsis)","(name:la,Lisia)","(name:is,Guernsey)","(name:hu,Guernsey)","(name:he,גרנזי)","(name:ga,Geansaí)","(name:fr,Guernesey)","(name:fi,Guernsey)","(name:eo,Guernsey)","(name:en,Guernsey)","(name:el,Γκέρνσεϊ)","(name:cy,\\"Ynys y Garn\\")","(name:br,Gwernenez)","(name:be,Гернсі)","(name:ar,غويرنسي)","(name,Guernsey)"}	\N
ec	{"(official_name:vi,\\"Cộng hoà Ecuador\\")","(official_name:sv,\\"Republiken Ecuador\\")","(official_name:sk,\\"Ekvádorská republika\\")","(official_name:pt,\\"República do Equador\\")","(official_name:pl,\\"Republika Ekwadoru\\")","(official_name:lv,\\"Ekvadoras Republika\\")","(official_name:lt,\\"Ekvadoro Respublika\\")","(official_name:id,\\"Republik Ekuador\\")","(official_name:gd,\\"Poblachd Eacuador\\")","(official_name:fr,\\"République de l'Équateur\\")","(official_name:en,\\"Republic of Ecuador\\")","(official_name:el,\\"Δημοκρατία του Ισημερινού\\")","(official_name,\\"República del Ecuador\\")","(name:zh,厄瓜多尔)","(name:uk,Еквадор)","(name:tr,Ekvador)","(name:th,ประเทศเอกวาดอร์)","(name:sv,Ecuador)","(name:sl,Ekvador)","(name:sk,Ekvádor)","(name:ru,Эквадор)","(name:pt,Equador)","(name:pl,Ekwador)","(name:mn,Эквадор)","(name:lv,Ekvadora)","(name:lt,Ekvadoras)","(name:la,Aequatoria)","(name:ja,エクアドル)","(name:is,Ekvador)","(name:id,Ekuador)","(name:hu,Ecuador)","(name:hr,Ekvador)","(name:he,אקואדור)","(name:gd,Eacuador)","(name:ga,Eacuadór)","(name:fy,Ekwador)","(name:fr,Équateur)","(name:fi,Ecuador)","(name:fa,اکوادور)","(name:eu,Ekuador)","(name:eo,Ekvadoro)","(name:en,Ecuador)","(name:el,Ισημερινός)","(name:de,Ekuador)","(name:da,Ecuador)","(name:ca,Equador)","(name:br,Ecuador)","(name:be,Эквадор)","(name:ar,إكوادور)","(name,Ecuador)"}	\N
gf	{"(name:zh,法属圭亚那)","(name:vi,\\"Guyane thuộc Pháp\\")","(name:uk,\\"Французька Гвіана\\")","(name:tr,\\"Fransız Guyanası\\")","(name:th,เฟรนช์เกียนา)","(name:sv,\\"Franska Guyana\\")","(name:sl,\\"Francoska Gvajana\\")","(name:ru,\\"Французская Гвиана\\")","(name:pl,\\"Gujana Francuska\\")","(name:nl,Frans-Guyana)","(name:mn,\\"Франц Гвиана\\")","(name:lv,\\"Franču Gviāna\\")","(name:lt,\\"Prancūzijos Gviana\\")","(name:li,\\"Frans Guyana\\")","(name:la,\\"Guiana Francica\\")","(name:it,\\"Guyana francese\\")","(name:is,\\"Franska Gvæjana\\")","(name:id,\\"Guyana Perancis\\")","(name:hu,\\"Francia Guyana\\")","(name:hr,\\"Francuska Gvajana\\")","(name:he,\\"גיאנה הצרפתית\\")","(name:gd,\\"Guiana Fhrangach\\")","(name:ga,\\"Guáin na Fraince\\")","(name:fy,\\"Frânsk Guyana\\")","(name:fr,\\"Guyane française\\")","(name:fi,\\"Ranskan Guayana\\")","(name:fa,\\"گویان فرانسه\\")","(name:et,\\"Prantsuse Guajaana\\")","(name:es,\\"Guayana Francesa\\")","(name:eo,Gujano)","(name:en,\\"French Guiana\\")","(name:el,\\"Γαλλική Γουιάνα\\")","(name:de,Französisch-Guayana)","(name:da,\\"Fransk Guyana\\")","(name:cy,Guyane)","(name:ca,\\"Guaiana Francesa\\")","(name:br,\\"Gwiana c’hall\\")","(name:ar,غيانا)","(name:af,Frans-Guyana)","(name,\\"Guyane Française\\")"}	\N
sc	{"(official_name:vi,\\"Cộng hòa Seychelles\\")","(official_name:sv,\\"Republiken Seychellerna\\")","(official_name:pl,\\"Republika Seszeli\\")","(official_name:lt,\\"Seišelių Respublika\\")","(official_name:id,\\"Republik Seychelles\\")","(official_name:gd,\\"Poblachd na h-Eileanan Sheiseall\\")","(official_name:fr,\\"République des Seychelles\\")","(official_name:et,\\"Seišelli Vabariik\\")","(official_name:es,\\"República de las Seychelles\\")","(official_name:en,\\"Republic of Seychelles\\")","(official_name:el,\\"Δημοκρατία των Σεϋχελλών\\")","(official_name,\\"Repiblik Sesel\\")","(name:zh_pyt,\\"Sàishéěr Qúndǎo\\")","(name:zh_py,Saisheerqundao)","(name:zh,塞舌尔群岛)","(name:uk,\\"Сейшельські Острови\\")","(name:tr,Seyşeller)","(name:th,ประเทศเซเชลส์)","(name:sv,Seychellerna)","(name:sl,Sejšeli)","(name:ru,Сейшелы)","(name:pl,Seszele)","(name:nl,Seychellen)","(name:mn,\\"Сейшелийн арлууд\\")","(name:lt,Seišeliai)","(name:li,Seisjelle)","(name:lb,Seychellen)","(name:la,\\"Insulae Seisellenses\\")","(name:is,Seychelles-eyjar)","(name:hu,Seychelle-szigetek)","(name:hr,Sejšeli)","(name:he,סיישל)","(name:haw,Sekele)","(name:gd,\\"Na h-Eileanan Sheiseall\\")","(name:ga,\\"Na Séiséil\\")","(name:fy,\\"de Seysjellen\\")","(name:fr,Seychelles)","(name:fi,Seychellit)","(name:fa,سیشل)","(name:et,Seišellid)","(name:es,Seychelles)","(name:eo,Sejŝeloj)","(name:en,Seychelles)","(name:el,Σεϋχέλλες)","(name:de,Seychellen)","(name:da,Seychellerne)","(name:br,Sechelez)","(name:be,Сейшэлы)","(name:ar,سيشيل)","(name:af,Seychelle)","(name,Seychelles)"}	\N
ir	{"(official_name:vi,\\"Cộng hòa Hồi giáo Iran\\")","(official_name:sv,\\"Islamiska republiken Iran\\")","(official_name:sl,\\"Islamska republika Iran\\")","(official_name:pt,\\"República Islâmica do Irã\\")","(official_name:pl,\\"Islamska Republika Iranu\\")","(official_name:lb,\\"Islamesch Republik Iran\\")","(official_name:ja,イラン・イスラム共和国)","(official_name:it,\\"Repubblica Islamica dell'Iran\\")","(official_name:id,\\"Republik Islam Iran\\")","(official_name:et,\\"Iraani Islamivabariik\\")","(official_name:en,\\"Islamic Republic of Iran\\")","(official_name:el,\\"Ισλαμική Δημοκρατία του Ιράν\\")","(official_name:ca,\\"República Islàmica de l'Iran\\")","(official_name:br,\\"Republik Islamek Iran\\")","(official_name,\\"جمهوری اسلامی ایران\\")","(name:zh_pyt,Yīlǎng)","(name:zh_py,Yilang)","(name:zh,伊朗)","(name:vi,Iran)","(name:uk,Іран)","(name:tr,İran)","(name:th,ประเทศอิหร่าน)","(name:sv,Iran)","(name:sl,Iran)","(name:ru,Иран)","(name:pt,Irã)","(name:pl,Iran)","(name:nl,Iran)","(name:mn,Иран)","(name:lv,Irāna)","(name:lt,Iranas)","(name:li,Iraan)","(name:lb,Iran)","(name:la,Irania)","(name:ja,イラン)","(name:it,Iran)","(name:is,Íran)","(name:id,Iran)","(name:hy,Իրան)","(name:hu,Irán)","(name:hr,Iran)","(name:he,אירן)","(name:haw,‘Ilana)","(name:gd,Ioràn)","(name:ga,\\"An Iaráin\\")","(name:fy,Iran)","(name:fr,Iran)","(name:fi,Iran)","(name:fa,ایران)","(name:et,Iraan)","(name:es,Irán)","(name:eo,Irano)","(name:en,Iran)","(name:el,Ιράν)","(name:de,Iran)","(name:da,Iran)","(name:cy,Iran)","(name:ca,Iran)","(name:br,Iran)","(name:be,Іран)","(name:az,İran)","(name:ar,إيران)","(name:af,Iran)","(name,ایران)"}	\N
tr	{"(official_name:vi,\\"Cộng hoà Thổ Nhĩ Kỳ\\")","(official_name:sv,\\"Republiken Turkiet\\")","(official_name:sk,\\"Turecká republika\\")","(official_name:pt,\\"República da Turquia\\")","(official_name:pl,\\"Republika Turcji\\")","(official_name:lv,\\"Turcijas Republika\\")","(official_name:lb,\\"Republik Tierkei\\")","(official_name:it,\\"Repubblica di Turchia\\")","(official_name:id,\\"Republik Turki\\")","(official_name:et,\\"Türgi Vabariik\\")","(official_name:es,\\"República de Turquía\\")","(official_name:br,\\"Republik Turkia\\")","(official_name,\\"Türkiye Cumhuriyeti\\")","(name:zh_pyt,Tǔěrqí)","(name:zh_py,Tuerqi)","(name:zh,土耳其)","(name:vi,\\"Thổ Nhĩ Kỳ\\")","(name:uk,Турція)","(name:tr,Türkiye)","(name:th,ประเทศตุรกี)","(name:sv,Turkiet)","(name:sl,Turčija)","(name:sk,Turecko)","(name:ru,Турция)","(name:pt,Turquia)","(name:pl,Turcja)","(name:no,Tyrkia)","(name:nl,Turkije)","(name:lv,Turcija)","(name:lt,Turkija)","(name:li,Törkieë)","(name:lb,Tierkei)","(name:la,Turcia)","(name:ja,トルコ)","(name:it,Turchia)","(name:is,Tyrkland)","(name:id,Turki)","(name:hy,Թուրքիա)","(name:hu,Törökország)","(name:hr,Turska)","(name:he,טורקיה)","(name:haw,Tureke)","(name:gd,\\"An Tuirc\\")","(name:ga,\\"An Tuirc\\")","(name:fy,Turkije)","(name:fr,Turquie)","(name:fi,Turkki)","(name:fa,ترکیه)","(name:et,Türgi)","(name:es,Turquía)","(name:eo,Turkio)","(name:en,Turkey)","(name:el,Τουρκία)","(name:de,Türkei)","(name:da,Tyrkiet)","(name:cy,Twrci)","(name:ca,Turquia)","(name:br,Turkia)","(name:be,Турцыя)","(name:az,Türkiyə)","(name:ar,تركيا)","(name:af,Turkye)","(name,Türkiye)"}	\N
sz	{"(official_name:vi,\\"Vương quốc Swaziland\\")","(official_name:sv,\\"Konungariket Swaziland\\")","(official_name:sl,\\"Kraljevina Svazi\\")","(official_name:pt,\\"Reino da Suazilândia\\")","(official_name:lb,\\"Kinneksräich Swasiland\\")","(official_name:ja,スワジランド王国)","(official_name:id,\\"Kerajaan Swaziland\\")","(official_name:gd,\\"Dùthaich nan Suasaidh\\")","(official_name:et,\\"Svaasimaa Kuningriik\\")","(official_name:el,\\"Βασίλειο της Σουαζιλάνδης\\")","(official_name:ca,\\"Regne de Swazilàndia\\")","(official_name,\\"Kingdom of Swaziland;Umbuso weSwatini\\")","(name:zh_pyt,Sīwēishìlán)","(name:zh_py,Siweishilan)","(name:zh,斯威士兰)","(name:uk,Свазіленд)","(name:tr,Svaziland)","(name:th,ประเทศสวาซิแลนด์)","(name:sv,Swaziland)","(name:sl,Svazi)","(name:ru,Свазиленд)","(name:pt,Suazilândia)","(name:pl,Suazi)","(name:mn,Свазиланд)","(name:lt,Svazilendas)","(name:lb,Swasiland)","(name:la,Suazia)","(name:ja,スワジランド)","(name:it,Swaziland)","(name:is,Svasíland)","(name:hu,Szváziföld)","(name:hr,Svazi)","(name:he,סווזילנד)","(name:haw,Suazilana)","(name:gd,Suasalainn)","(name:ga,\\"An tSuasalainn\\")","(name:fy,Swazilân)","(name:fr,Swaziland)","(name:fi,Swazimaa)","(name:fa,سوازیلند)","(name:et,Svaasimaa)","(name:es,Suazilandia)","(name:eo,Svazilando)","(name:el,Σουαζιλάνδη)","(name:de,Swasiland)","(name:cy,\\"Gwlad Swazi\\")","(name:ca,Swazilàndia)","(name:br,Swaziland)","(name:be,Свазіленд)","(name:ar,سوازيلند)","(name,Swaziland)"}	\N
ae	{"(name:zh_pyt,\\"Ālābó Liánhé Qiúchángguó\\")","(name:zh_py,\\"Alabo Lianhe Qiuchangguo\\")","(name:zh,阿拉伯联合酋长国)","(name:vi,\\"Các Tiểu vương quốc Ả Rập Thống nhất\\")","(name:uk,\\"Об'єднані Арабські Емірати\\")","(name:tr,\\"Birleşik Arap Emirlikleri\\")","(name:th,สหรัฐอาหรับเอมิเรตส์)","(name:sv,\\"Förenade Arabemiraten\\")","(name:sl,\\"Združeni arabski emirati\\")","(name:ru,\\"Объединённые Арабские Эмираты\\")","(name:pt,\\"Emirados Árabes Unidos\\")","(name:pl,\\"Zjednoczone Emiraty Arabskie\\")","(name:nl,\\"Verenigde Arabische Emiraten\\")","(name:mn,\\"Арабын Нэгдсэн Эмирт Улс\\")","(name:lt,\\"Jungtiniai Arabų Emyratai\\")","(name:li,\\"Vereinegde Arabische Emirate\\")","(name:lb,\\"Vereenegt Arabesch Emirater\\")","(name:la,\\"Phylarchiarum Arabicarum Confoederatio\\")","(name:ja,アラブ首長国連邦)","(name:it,\\"Emirati Arabi Uniti\\")","(name:is,\\"Sameinuðu arabísku furstadæmin\\")","(name:id,\\"Uni Emirat Arab\\")","(name:hu,\\"Egyesült Arab Emírségek\\")","(name:hr,\\"Ujedinjeni Arapski Emirati\\")","(name:he,\\"איחוד האמירויות הערביות\\")","(name:gd,\\"Na h-Iomaratan Arabach Aonaichte\\")","(name:ga,\\"Aontas na nÉimíríochtaí Arabacha\\")","(name:fy,\\"de Feriene Arabyske Emiraten\\")","(name:fr,\\"Emirats Arabes Unis\\")","(name:fi,\\"Yhdistyneet arabiemiirikunnat\\")","(name:fa,\\"امارات متحده عربی\\")","(name:et,\\"Araabia Ühendemiraadid\\")","(name:es,\\"Emiratos Árabes Unidos\\")","(name:eo,\\"Unuiĝintaj Arabaj Emirlandoj\\")","(name:en,\\"United Arab Emirates\\")","(name:el,\\"Ηνωμένα Αραβικά Εμιράτα\\")","(name:de,\\"Vereinigte Arabische Emirate\\")","(name:da,\\"Forenede Arabiske Emirater\\")","(name:cy,\\"Yr Emiradau Arabaidd Unedig\\")","(name:ca,\\"Emirats Àrabs Units\\")","(name:br,\\"Emirelezhioù Arab Unanet\\")","(name:ar,\\"الإمارات العربية المتحدة\\")","(name:af,\\"Verenigde Arabiese Emirate\\")","(name,\\"United Arab Emirates\\")"}	\N
kn	{"(official_name:vi,\\"Liên bang Saint Kitts và Nevis\\")","(official_name:pt,\\"Federação de São Cristóvão e Nevis\\")","(official_name:pl,\\"Federacja Saint Kitts i Nevis\\")","(official_name:it,\\"Federazione di Saint Kitts e Nevis\\")","(official_name:id,\\"Federasi Saint Kitts dan Nevis\\")","(official_name:fr,\\"Fédération de Saint-Christophe-et-Niévès\\")","(official_name:es,\\"Federación de San Cristóbal y Nieves\\")","(official_name,\\"Federation of Saint Kitts and Nevis\\")","(name:zh,圣基茨和尼维斯)","(name:vi,\\"Saint Kitts và Nevis\\")","(name:uk,\\"Сент-Кіттс і Невіс\\")","(name:tr,\\"Saint Kitts ve Nevis\\")","(name:th,ประเทศเซนต์คิตส์และเนวิส)","(name:sv,\\"Saint Kitts och Nevis\\")","(name:sl,\\"Saint Kitts in Nevis\\")","(name:ru,\\"Сент-Китс и Невис\\")","(name:pt,\\"São Cristóvão e Nevis\\")","(name:pl,\\"Saint Kitts i Nevis\\")","(name:nl,\\"Saint Kitts en Nevis\\")","(name:mn,\\"Сент-Киттс ба Невис\\")","(name:lt,\\"Sen Kristoferis ir Nevis\\")","(name:li,Saint-Kitts)","(name:lb,\\"Saint Kitts a Nevis\\")","(name:it,\\"Saint Kitts e Nevis\\")","(name:is,\\"Sankti Kristófer og Nevis\\")","(name:id,\\"Saint Kitts dan Nevis\\")","(name:hu,\\"Saint Christopher és Nevis\\")","(name:hr,\\"Sveti Kristofor i Nevis\\")","(name:he,\\"סנט קיטס ונוויס\\")","(name:gd,\\"Naomh Crìstean agus Nibheis\\")","(name:ga,\\"San Críostóir-Nimheas\\")","(name:fy,\\"Sint Kitts en Nevis\\")","(name:fr,Saint-Christophe-et-Niévès)","(name:fi,\\"Saint Kitts ja Nevis\\")","(name:fa,\\"سنت کیتس و نویس\\")","(name:et,\\"Saint Kitts ja Nevis\\")","(name:es,\\"San Cristóbal y Nieves\\")","(name:eo,\\"Sankta-Kito kaj Neviso\\")","(name:de,\\"St. Kitts und Nevis\\")","(name:da,\\"Saint Kitts og Nevis\\")","(name:cy,\\"Saint Kitts a Nevis\\")","(name:ca,\\"Saint Kitts i Nevis\\")","(name:br,\\"Saint Kitts ha Nevis\\")","(name:be,\\"Святы Кітс і Невіс\\")","(name:ar,\\"سانت كيتس ونيفس\\")","(name:af,\\"Sint Kitts en Nevis\\")","(name,\\"Saint Kitts and Nevis\\")","(alt_name,\\"Federation of Saint Christopher and Nevis\\")"}	\N
ao	{"(official_name:sv,\\"Republiken Angola\\")","(official_name:pt,\\"República de Angola\\")","(official_name:lv,\\"Angolas Republika\\")","(official_name:lt,\\"Angolos Respublika\\")","(official_name:lb,\\"Republik Angola\\")","(official_name:id,\\"Republik Angola\\")","(official_name:gd,\\"Poblachd Angola\\")","(official_name:fr,\\"République d'Angola\\")","(official_name:fi,\\"Angolan tasavalta\\")","(official_name:en,\\"Republic of Angola\\")","(official_name:el,\\"Δημοκρατία της Αγκόλας\\")","(official_name,\\"República de Angola\\")","(name:zh_pyt,Āngēlā)","(name:zh_py,Angela)","(name:zh,安哥拉)","(name:uk,Ангола)","(name:th,ประเทศแองโกลา)","(name:sv,Angola)","(name:ru,Ангола)","(name:pt,Angola)","(name:pl,Angola)","(name:mn,Ангол)","(name:lv,Angola)","(name:la,Angolia)","(name:ja,アンゴラ)","(name:it,Angola)","(name:is,Angóla)","(name:hu,Angola)","(name:he,אנגולה)","(name:ga,Angóla)","(name:fy,Angoala)","(name:fr,Angola)","(name:fi,Angola)","(name:fa,آنگولا)","(name:es,Angola)","(name:eo,Angolo)","(name:en,Angola)","(name:el,Αγκόλα)","(name:co,Angola)","(name:ca,Angola)","(name:br,Angola)","(name:be,Ангола)","(name:az,Anqola)","(name:ar,أنغولا)","(name,Angola)"}	\N
bi	{"(official_name:vi,\\"Cộng hòa Burundi\\")","(official_name:sv,\\"Republiken Burundi\\")","(official_name:lv,\\"Burundijas Republika\\")","(official_name:lt,\\"Burundžio Respublika\\")","(official_name:lb,\\"Republik Burundi\\")","(official_name:fi,\\"Burundin tasavalta\\")","(official_name:el,\\"Δημοκρατία του Μπουρούντι\\")","(official_name,\\"Republika y'u Burundi;Republique du Burundi\\")","(name:zh_pyt,Bùlóngdí)","(name:zh_py,Bulongdi)","(name:zh,布隆迪)","(name:uk,Бурунді)","(name:th,ประเทศบุรุนดี)","(name:sv,Burundi)","(name:ru,Бурунди)","(name:pl,Burundi)","(name:mn,Бурунди)","(name:lv,Burundija)","(name:lt,Burundis)","(name:li,Boeroendi)","(name:la,Burundia)","(name:ja,ブルンジ)","(name:it,Burundi)","(name:is,Búrúndí)","(name:hu,Burundi)","(name:he,בורונדי)","(name:haw,Buruni)","(name:gd,Burundaidh)","(name:ga,\\"An Bhurúin\\")","(name:fy,Bûrûndy)","(name:fr,Burundi)","(name:fi,Burundi)","(name:fa,بوروندی)","(name:es,Burundi)","(name:eo,Burundo)","(name:en,Burundi)","(name:el,Μπουρούντι)","(name:da,Burundi)","(name:cy,Bwrwndi)","(name:br,Burundi)","(name:be,Бурундзі)","(name:ar,بوروندي)","(name:af,Burundi)","(name,Burundi)"}	\N
bn	{"(official_name:vi,\\"Vương quốc Hồi giáo Brunei\\")","(official_name:sv,\\"Brunei Darussalam\\")","(official_name:pt,\\"Estado do Brunei Darussalam\\")","(official_name:pl,\\"Państwo Brunei Darussalam\\")","(official_name:lv,\\"Brunejas Darusalamas Valsts\\")","(official_name:fi,\\"Brunei Darussalamin valtio\\")","(name:zh_pyt,Wénlái)","(name:zh_py,Wenlai)","(name:zh,文莱)","(name:vi,Brunei)","(name:uk,Бруней)","(name:tr,Bruney)","(name:th,ประเทศบรูไนดารุสซาลาม)","(name:sv,Brunei)","(name:sl,Brunej)","(name:ru,Бруней-Даруссалам)","(name:pt,Brunei)","(name:pl,Brunei)","(name:nl,Brunei)","(name:mn,Бруней)","(name:lv,Bruneja)","(name:lt,\\"Brunėjaus Darusalamas\\")","(name:li,Broenai)","(name:lb,Brunei)","(name:la,Bruneium)","(name:it,Brunei)","(name:is,Brúnei)","(name:id,Brunei)","(name:hu,Brunei)","(name:hr,Burneji)","(name:he,ברוניי)","(name:haw,Brunei)","(name:gd,Brùnaidh)","(name:ga,Brúiné)","(name:fy,Brûnei)","(name:fr,Brunei)","(name:fi,Brunei)","(name:fa,برونئی)","(name:eu,Brunei)","(name:et,Brunei)","(name:es,Brunéi)","(name:eo,Brunejo)","(name:en,\\"Brunei Darussalam\\")","(name:el,Μπρουνέι)","(name:da,Brunei)","(name:cy,Brunei)","(name:br,Brunei)","(name:be,Бруней)","(name:ar,\\"بروني دار السلام\\")","(name:af,Broenei)","(name,\\"Brunei Darussalam\\")"}	\N
bt	{"(official_name:vi,\\"Vương quốc Bhutan\\")","(official_name:sv,\\"Konungariket Bhutan\\")","(official_name:pt,\\"Reino do Butão\\")","(official_name:lv,\\"Butānas Karaliste\\")","(official_name:lt,\\"Butano Karalystė\\")","(official_name:it,\\"Regno del Bhutan\\")","(official_name:fi,\\"Bhutanin kuningaskunta\\")","(official_name:en,\\"Kingdom of Bhutan\\")","(official_name:el,\\"Βασίλειο του Μπουτάν\\")","(name:zh_pyt,Bùdān)","(name:zh_py,Budan)","(name:zh,不丹)","(name:uk,Бутан)","(name:th,ประเทศภูฏาน)","(name:sv,Bhutan)","(name:sl,Butan)","(name:ru,Бутан)","(name:pt,Butão)","(name:pl,Bhutan)","(name:mn,Бутан)","(name:lv,Butāna)","(name:lt,Butanas)","(name:li,Bhoetaan)","(name:la,Butania)","(name:ja,ブータン)","(name:it,Bhutan)","(name:is,Bútan)","(name:hu,Bhután)","(name:hr,Butan)","(name:he,בהוטן)","(name:haw,Butana)","(name:gd,Butàn)","(name:ga,\\"An Bhútain\\")","(name:fy,Bûtan)","(name:fr,Bhoutan)","(name:fi,Bhutan)","(name:fa,بوتان)","(name:es,Bután)","(name:eo,Butano)","(name:en,Bhutan)","(name:el,Μπουτάν)","(name:dz,འབྲུག་ཡུལ་)","(name:br,Bhoutan)","(name:be,Бутан)","(name:ar,بوتان)","(name:af,Bhoetan)","(name,Bhutan)"}	\N
cl	{"(official_name:vi,\\"Cộng hoà Chile\\")","(official_name:sv,\\"Republiken Chile\\")","(official_name:pt,\\"República do Chile\\")","(official_name:pl,\\"Republika Chile\\")","(official_name:lv,\\"Čīles Republika\\")","(official_name:lt,\\"Čilės Respublika\\")","(official_name:lb,\\"Republik Chile\\")","(official_name:ja,チリ共和国)","(official_name:it,\\"Repubblica del Cile\\")","(official_name:gd,\\"Poblachd na Sile\\")","(official_name:en,\\"Republic of Chile\\")","(official_name:el,\\"Δημοκρατία της Χιλής\\")","(official_name,\\"República de Chile\\")","(name:zh,智利)","(name:uk,Чілі)","(name:tr,Şili)","(name:th,ประเทศชิลี)","(name:sv,Chile)","(name:sl,Čile)","(name:ru,Чили)","(name:pt,Chile)","(name:pl,Chile)","(name:nl,Chili)","(name:mn,Чили)","(name:lv,Čīle)","(name:lt,Čilė)","(name:li,Chili)","(name:la,Chilia)","(name:ja,チリ)","(name:it,Cile)","(name:is,Chile)","(name:id,Chili)","(name:hu,Chile)","(name:hr,Čile)","(name:he,צילה)","(name:gd,\\"An t-Sile\\")","(name:ga,\\"An tSile\\")","(name:fy,Sily)","(name:fr,Chili)","(name:fi,Chile)","(name:fa,شیلی)","(name:eu,Txile)","(name:et,Tšiili)","(name:eo,Ĉilio)","(name:en,Chile)","(name:el,Χιλή)","(name:ca,Xile)","(name:br,Chile)","(name:be,Чылі)","(name:ar,شيلي)","(name:af,Chili)","(name,Chile)"}	\N
cv	{"(official_name:vi,\\"Cộng hòa Cabo Verde\\")","(official_name:sv,\\"Republiken Kap Verde\\")","(official_name:sl,\\"Republika Zelenortski otoki\\")","(official_name:pl,\\"Republika Zielonego Przylądka\\")","(official_name:lv,\\"Kaboverdes Republika\\")","(official_name:lt,\\"Žaliojo Kyšulio Respublika\\")","(official_name:he,\\"רפובליקת כֵּף וֶרְדֶּה\\")","(official_name:es,\\"República de Cabo Verde\\")","(official_name:en,\\"Republic of Cape Verde\\")","(official_name:el,\\"Δημοκρατία του Πράσινου Ακρωτηρίου\\")","(official_name:de,\\"Republik Kap Verde\\")","(official_name:be,\\"Рэспубліка Каба-Вердэ\\")","(official_name,\\"República de Cabo Verde\\")","(name:zh,佛得角)","(name:uk,Кабо-Верде)","(name:tr,\\"Yeşil Burun Adaları\\")","(name:th,ประเทศเคปเวิร์ด)","(name:sv,\\"Kap Verde\\")","(name:sl,\\"Zelenortski otoki\\")","(name:ru,Кабо-Верде)","(name:pl,\\"Wyspy Zielonego Przylądka\\")","(name:nl,Kaapverdië)","(name:mn,Кабо-Верде)","(name:lv,Kaboverde)","(name:lt,\\"Žaliasis Kyšulys\\")","(name:li,Kaapverdië)","(name:lb,\\"Kap Verde\\")","(name:la,\\"Promontorium Viride\\")","(name:it,\\"Capo Verde\\")","(name:is,Grænhöfðaeyjar)","(name:id,\\"Tanjung Verde\\")","(name:hu,Zöld-Fok)","(name:hr,\\"Zelenortski Otoci\\")","(name:he,\\"כף ורדה\\")","(name:gd,\\"Cape Verde\\")","(name:ga,\\"Rinn Verde\\")","(name:fy,Kaapverdje)","(name:fr,Cap-Vert)","(name:fi,\\"Kap Verde\\")","(name:fa,\\"کیپ ورد\\")","(name:et,Roheneemesaared)","(name:es,\\"Cabo Verde\\")","(name:eo,Kabo-Verdo)","(name:en,\\"Cape Verde\\")","(name:el,\\"Πράσινο Ακρωτήριο\\")","(name:de,\\"Kap Verde\\")","(name:da,\\"Kap Verde\\")","(name:cy,\\"Cabo Verde\\")","(name:ca,\\"Cap Verd\\")","(name:br,\\"Kab Glas\\")","(name:be,Каба-Вердэ)","(name:ar,\\"الرأس الأخضر\\")","(name:af,\\"Kaap Verde\\")","(name,\\"Cabo Verde\\")"}	\N
et	{"(old_name,Abyssinia)","(official_name:vi,\\"Cộng hòa Dân chủ Liên bang Ethiopia\\")","(official_name:sv,\\"Demokratiska förbundsrepubliken Etiopien\\")","(official_name:pt,\\"República Democrática Federal da Etiópia\\")","(official_name:lv,\\"Etiopijas Federatīvā Demokrātiskā Republika\\")","(official_name:lt,\\"Etiopijos Federacinė Demokratinė Respublika\\")","(official_name:lb,\\"Bundesrepublik Ethiopien\\")","(official_name:id,\\"Republik Demokratik Federal Ethiopia\\")","(official_name:en,\\"Federal Democratic Republic of Ethiopia\\")","(official_name:el,\\"Ομοσπονδιακή Δημοκρατία της Αιθιοπίας\\")","(official_name:be,\\"Федэратыўная Дэмакратычная Рэспубліка Эфіопія\\")","(official_name:af,\\"Federale Demokratiese Republiek Ethiopië\\")","(official_name,\\"Federal Democratic Republic of Ethiopia\\")","(name:zh_pyt,Āisàiébǐyà)","(name:zh_py,Aisaiebiya)","(name:zh,埃塞俄比亚)","(name:uk,Ефіопія)","(name:tr,Etiyopya)","(name:th,ประเทศเอธิโอเปีย)","(name:sv,Etiopien)","(name:sl,Etiopija)","(name:ru,Эфиопия)","(name:pt,Etiópia)","(name:pl,Etiopia)","(name:nl,Ethiopië)","(name:mn,Этиоп)","(name:lv,Etiopija)","(name:lt,Etiopija)","(name:li,Ethiopië)","(name:lb,Ethiopien)","(name:la,Aethiopia)","(name:ja,エチオピア)","(name:it,Etiopia)","(name:is,Eþíópía)","(name:hu,Etiópia)","(name:hr,Etiopija)","(name:he,אתיופיה)","(name:gd,\\"An Aetiòp\\")","(name:ga,\\"An Aetóip\\")","(name:fy,Etioopje)","(name:fr,Éthiopie)","(name:fi,Etiopia)","(name:fa,اتیوپی)","(name:eu,Etiopia)","(name:et,Etioopia)","(name:es,Etiopía)","(name:eo,Etiopio)","(name:en,Ethiopia)","(name:el,Αιθιοπία)","(name:de,Äthiopien)","(name:da,Etiopien)","(name:ca,Etiòpia)","(name:br,Etiopia)","(name:be,Эфіопія)","(name:ar,إثيوبيا)","(name:am,ኢትዮጵያ)","(name:af,Ethiopië)","(name,Ethiopia)"}	\N
fk	{"(official_name:lv,\\"Folklenda (Malvinu) salas\\")","(name:zh,福克兰群岛)","(name:vi,\\"Quần đảo Falkland\\")","(name:uk,\\"Фолклендські острови\\")","(name:tr,\\"Falkland Adaları\\")","(name:th,หมู่เกาะฟอล์กแลนด์)","(name:sv,Falklandsöarna)","(name:sl,Falklandi)","(name:ru,\\"Фолклендские Oстрова\\")","(name:pl,Falklandy)","(name:nl,Falklandeilanden)","(name:mn,\\"Фолклендийн Арлууд\\")","(name:lv,\\"Folklenda salas\\")","(name:lt,\\"Malvinų salos\\")","(name:la,\\"Insulae Malvinae\\")","(name:is,Falklandseyjar)","(name:id,\\"Kepulauan Falkland\\")","(name:hu,Falkland-szigetek)","(name:hr,\\"Falklandski Otoci\\")","(name:he,\\"איי פוקלנד\\")","(name:gd,\\"Na h-Eileanan Fàclainn\\")","(name:ga,\\"Oileáin Fháclainne\\")","(name:fy,Falklâneilannen)","(name:fr,\\"Îles Malouines\\")","(name:fi,Falklandinsaaret)","(name:fa,\\"جزایر فالکلند\\")","(name:et,\\"Falklandi saared\\")","(name:es,\\"Islas Malvinas\\")","(name:eo,Falklandoj)","(name:en,\\"Falkland Islands\\")","(name:de,Falklandinseln)","(name:da,Falklandsøerne)","(name:cy,\\"Ynysoedd y Falklands\\")","(name:ca,\\"Illes Malvines\\")","(name:br,\\"Inizi Maloù\\")","(name:be,\\"Фалклендскія астравы\\")","(name:ar,\\"جزر الفولكلاند\\")","(name:af,Falklandeilande)","(name,\\"Falkland Islands\\")"}	\N
fm	{"(official_name:vi,\\"Liên bang Micronesia\\")","(official_name:sv,\\"Mikronesiska federationen\\")","(official_name:sl,\\"Federativne države Mikronezije\\")","(official_name:pl,\\"Sfederowane Stany Mikronezji\\")","(official_name:lv,\\"Mikronēzijas Federatīvās Valstis\\")","(official_name:lt,\\"Mikronezijos Federacinės Valstijos\\")","(official_name:lb,\\"Federéiert Staten vu Mikronesien\\")","(official_name:et,\\"Mikroneesia Liiduriigid\\")","(official_name:es,\\"Estados Federados de Micronesia\\")","(official_name:be,\\"Федэратыўныя штаты Мікранэзіі\\")","(official_name,\\"Federated States of Micronesia\\")","(name:zh,密克罗尼西亚)","(name:uk,Мікронезія)","(name:tr,Mikronezya)","(name:th,ประเทศไมโครนีเซีย)","(name:sv,Mikronesien)","(name:sl,Mikronezija)","(name:ru,Микронезия)","(name:pl,Mikronezja)","(name:no,Mikronesia)","(name:mn,Микронези)","(name:lv,Mikronēzija)","(name:lt,Mikronezija)","(name:li,Micronesië)","(name:lb,Mikronesien)","(name:is,Míkrónesía)","(name:id,Mikronesia)","(name:hu,Mikronézia)","(name:hr,Mikronezija)","(name:he,מיקרונזיה)","(name:gd,\\"Na Meanbh Eileanan\\")","(name:ga,\\"An Mhicrinéis\\")","(name:fy,Mikroneezje)","(name:fr,Micronésie)","(name:fi,Mikronesia)","(name:fa,میکرونزی)","(name:et,Mikroneesia)","(name:eo,Mikronezio)","(name:en,Micronesia)","(name:de,Mikronesien)","(name:da,Mikronesien)","(name:ca,Micronèsia)","(name:br,Mikronezia)","(name:be,Мікранэзія)","(name:ar,ميكرونيزيا)","(name:af,Mikronesië)","(name,Micronesia)"}	\N
ga	{"(official_name:vi,\\"Cộng hòa Gabon\\")","(official_name:sv,\\"Republiken Gabon\\")","(official_name:pt,\\"República Gabonesa\\")","(official_name:lv,\\"Gabonas Republika\\")","(official_name:lt,\\"Gabono Respublika\\")","(official_name:id,\\"Republik Gabon\\")","(official_name:gd,\\"Poblachd Ghabon\\")","(official_name:en,\\"Gabonese Republic\\")","(official_name:el,\\"Δημοκρατία της Γκαμπόν\\")","(official_name,\\"République Gabonaise\\")","(name:zh_pyt,Jiāpéng)","(name:zh_py,Jiapeng)","(name:zh,加蓬)","(name:uk,Габон)","(name:th,ประเทศกาบอง)","(name:sv,Gabon)","(name:ru,Габон)","(name:pt,Gabão)","(name:pl,Gabon)","(name:mn,Габон)","(name:lv,Gabona)","(name:lt,Gabonas)","(name:lb,Gabun)","(name:la,Gabonia)","(name:ja,ガボン)","(name:it,Gabon)","(name:is,Gabon)","(name:hu,Gabon)","(name:he,גבון)","(name:ga,\\"An Ghabúin\\")","(name:fr,Gabon)","(name:fi,Gabon)","(name:fa,گابن)","(name:es,Gabón)","(name:eo,Gabono)","(name:en,Gabon)","(name:el,Γκαμπόν)","(name:de,Gabun)","(name:br,Gabon)","(name:be,Габон)","(name:ar,غابون)","(name:af,Gaboen)","(name,Gabon)"}	\N
gy	{"(official_name:sv,\\"Republiken Guyana\\")","(official_name:pt,\\"República Cooperativa da Guiana\\")","(official_name:pl,\\"Kooperacyjna Republika Gujany\\")","(official_name:lv,\\"Gajānas Kooperatīvā Republika\\")","(official_name:lt,\\"Gajanos Respublika\\")","(official_name:ja,ガイアナ共和国)","(official_name:id,\\"Republik Kooperatif Guyana\\")","(official_name:es,\\"República Cooperativa de Guyana\\")","(official_name:el,\\"Συνεργατική Δημοκρατία της Γουιάνας\\")","(official_name:be,\\"Кааператыўная Рэспубліка Гаяна\\")","(official_name,\\"Co-operative Republic of Guyana\\")","(name:zh,圭亚那)","(name:uk,Гаяна)","(name:th,ประเทศกายอานา)","(name:sv,Guyana)","(name:sl,Gvajana)","(name:ru,Гайана)","(name:pt,Guiana)","(name:pl,Gujana)","(name:mn,Гайана)","(name:lv,Gajāna)","(name:lt,Gajana)","(name:la,Guiana)","(name:ja,ガイアナ)","(name:is,Gvæjana)","(name:hu,Guyana)","(name:hr,Gvajana)","(name:he,גיאנה)","(name:gd,Guiana)","(name:ga,\\"An Ghuáin\\")","(name:fr,Guyana)","(name:fi,Guyana)","(name:fa,گویان)","(name:eo,Gujano)","(name:en,Guyana)","(name:el,Γουιάνα)","(name:da,Guyana)","(name:br,Guyana)","(name:be,Гаяна)","(name:ar,غيانا)","(name,Guyana)"}	\N
hr	{"(official_name:vi,\\"Cộng hòa Croatia\\")","(official_name:sv,\\"Republiken Kroatien\\")","(official_name:sk,\\"Chorvátska republika\\")","(official_name:pt,\\"República da Croácia\\")","(official_name:pl,\\"Republika Chorwacji\\")","(official_name:lv,\\"Horvātijas Republika\\")","(official_name:lt,\\"Kroatijos Respublika\\")","(official_name:id,\\"Republik Kroasia\\")","(official_name:et,\\"Horvaatia Vabariik\\")","(official_name:es,\\"República de Croacia\\")","(official_name:en,\\"Republic of Croatia\\")","(official_name:be,\\"Рэспубліка Харватыя\\")","(official_name,\\"Republika Hrvatska\\")","(name:zh_pyt,Kèluódìyà)","(name:zh_py,Keluodiya)","(name:zh,克罗地亚)","(name:vi,Croatia)","(name:uk,Хорватія)","(name:tr,Hırvatistan)","(name:th,ประเทศโครเอเชีย)","(name:sv,Kroatien)","(name:sl,Hrvaška)","(name:sk,Chorvátsko)","(name:ru,Хорватия)","(name:pt,Croácia)","(name:pl,Chorwacja)","(name:nl,Kroatië)","(name:mn,Хорват)","(name:lv,Horvātija)","(name:lt,Kroatija)","(name:li,Kroatië)","(name:lb,Kroatien)","(name:la,Croatia)","(name:ja,クロアチア)","(name:it,Croazia)","(name:is,Króatía)","(name:id,Kroasia)","(name:hy,Խորվաթիա)","(name:hu,Horvátország)","(name:he,קרואטיה)","(name:haw,Koloatia)","(name:gd,Croàisia)","(name:ga,\\"An Chróit\\")","(name:fy,Kroaasje)","(name:fr,Croatie)","(name:fi,Kroatia)","(name:fa,کرواسی)","(name:et,Horvaatia)","(name:es,Croacia)","(name:eo,Kroatio)","(name:en,Croatia)","(name:el,Κροατία)","(name:de,Kroatien)","(name:da,Kroatien)","(name:cy,Croatia)","(name:ca,Croàcia)","(name:br,Kroatia)","(name:be,Харватыя)","(name:ar,كرواتيا)","(name:af,Kroasië)","(name,Hrvatska)"}	\N
kg	{"(official_name:sv,\\"Republiken Kirgizistan\\")","(official_name:pl,\\"Republika Kirgistanu\\")","(official_name:lv,\\"Kirgizstānas Republika\\")","(official_name:lt,\\"Kirgizijos Respublika\\")","(official_name:lb,\\"Kirgisesch Republik\\")","(official_name:it,\\"Repubblica del Kirghizistan\\")","(official_name:et,\\"Kirgiisi Vabariik\\")","(official_name:el,\\"Δημοκρατία της Κιργιζίας\\")","(name:zh_pyt,Jíěrjísīsītǎn)","(name:zh_py,Jierjisisitan)","(name:zh,吉尔吉斯斯坦)","(name:uk,Киргизстан)","(name:tr,Kırgızistan)","(name:th,ประเทศคีร์กีซสถาน)","(name:sv,Kirgizistan)","(name:sl,Kirgizistan)","(name:ru,Киргизия)","(name:pl,Kirgistan)","(name:nl,Kirgizië)","(name:mn,Кыргызстан)","(name:lv,Kirgizstāna)","(name:lt,Kirgizija)","(name:li,Kirgizië)","(name:lb,Kirgisistan)","(name:la,Chirgisia)","(name:ky,Кыргызстан)","(name:it,Kirghizistan)","(name:is,Kirgistan)","(name:id,Kirgizstan)","(name:hu,Kirgizisztán)","(name:hr,Kirgistan)","(name:he,קירגיסטן)","(name:haw,Kaikikana)","(name:gd,Cirgiostàn)","(name:ga,\\"An Chirgeastáin\\")","(name:fy,Kirgyzje)","(name:fr,Kirghizistan)","(name:fi,Kirgisia)","(name:fa,قرقیزستان)","(name:et,Kõrgõzstan)","(name:es,Kirguistán)","(name:eo,Kirgizio)","(name:en,Kyrgyzstan)","(name:el,Κιργιζία)","(name:de,Kirgisistan)","(name:da,Kirgisistan)","(name:ca,Kirguizistan)","(name:br,Kirgizstan)","(name:be,Кыргызстан)","(name:az,Qırğızıstan)","(name:ar,قيرغيزستان)","(name:af,Kirgisië)","(name,Kyrgyzstan)"}	\N
kz	{"(official_name:vi,\\"Cộng hoà Kazakhstan\\")","(official_name:sv,\\"Republiken Kazakstan\\")","(official_name:pl,\\"Republika Kazachstanu\\")","(official_name:lv,\\"Kazahstānas Republika\\")","(official_name:lt,\\"Kazachstano Respublika\\")","(official_name:id,\\"Republik Kazakhstan\\")","(official_name:et,\\"Kasahstani Vabariik\\")","(official_name:be,\\"Рэспубліка Казахстан\\")","(official_name,\\"Republic of Kazakhstan\\")","(name:zh_pyt,Hāsàkèsītǎn)","(name:zh_py,Hasakesitan)","(name:zh,哈萨克斯坦)","(name:uk,Казахстан)","(name:tr,Kazakistan)","(name:th,ประเทศคาซัคสถาน)","(name:sv,Kazakstan)","(name:sl,Kazahstan)","(name:ru,Казахстан)","(name:pl,Kazachstan)","(name:nl,Kazachstan)","(name:mn,Казахстан)","(name:lv,Kazahstāna)","(name:lt,Kazachstanas)","(name:li,Kazachstan)","(name:lb,Kasachstan)","(name:la,Casachia)","(name:kk,\\"Қазақстан (Qazaqstan)\\")","(name:ja,カザフスタン)","(name:it,Kazakistan)","(name:is,Kasakstan)","(name:hu,Kazahsztán)","(name:hr,Kazahstan)","(name:he,קזחסטן)","(name:haw,Kasakana)","(name:gd,Casachstan)","(name:ga,\\"An Chasacstáin\\")","(name:fy,Kazachstan)","(name:fr,Kazakhstan)","(name:fi,Kazakstan)","(name:fa,قزاقستان)","(name:et,Kasahstan)","(name:es,Kazajistán)","(name:eo,Kazaĥio)","(name:en,Kazakhstan)","(name:de,Kasachstan)","(name:da,Kasakhstan)","(name:cy,Kazakstan)","(name:br,Kazakstan)","(name:be,Казахстан)","(name:az,Qazaxıstan)","(name:ar,كازاخستان)","(name:af,Kasakstan)","(name,Kazakhstan)"}	\N
lk	{"(official_name:vi,\\"Cộng hòa Dân chủ Xã hội chủ nghĩa Sri Lanka\\")","(official_name:sv,\\"Demokratiska socialistiska republiken Sri Lanka\\")","(official_name:pt,\\"República DemocráticaSocial do Sri Lanka\\")","(official_name:pl,\\"Demokratyczno-Socjalistyczna Republika Sri Lanki\\")","(official_name:lv,\\"Šrilankas Demokrātiskā Sociālistiskā Republika\\")","(official_name:lb,\\"Demokratesch Sozialistesch Republik Sri Lanka\\")","(official_name:it,\\"Repubblica Democratica Socialista dello Sri Lanka\\")","(official_name:id,\\"Republik Sosialis Demokratik Sri Lanka\\")","(official_name:gd,\\"Poblachd shòisealach dheomacrasach Sri Lanca\\")","(official_name:el,\\"Λαϊκή Σοσιαλιστική Δημοκρατία της Σρι Λάνκα\\")","(official_name:br,\\"Republik Demokratel ha Sokialour Sri Lanka\\")","(name:zh_pyt,Sīlǐlánkǎ)","(name:zh_py,Sililanka)","(name:zh,斯里兰卡)","(name:uk,Шрі-Ланка)","(name:tr,\\"Sri Lanka\\")","(name:th,ประเทศศรีลังกา)","(name:sv,\\"Sri Lanka\\")","(name:sl,Šrilanka)","(name:ru,Шри-Ланка)","(name:pt,\\"Sri Lanka\\")","(name:pl,\\"Sri Lanka\\")","(name:mn,Шри-Ланка)","(name:lv,Šrilanka)","(name:lt,\\"Šri Lanka\\")","(name:la,Taprobane)","(name:ja,スリランカ)","(name:it,\\"Sri Lanka\\")","(name:is,\\"Srí Lanka\\")","(name:hu,\\"Srí Lanka\\")","(name:he,\\"סרי לנקה\\")","(name:haw,Sililanaka)","(name:gd,\\"Sri Lanca\\")","(name:ga,\\"Srí Lanca\\")","(name:fy,\\"Sry Lanka\\")","(name:fr,\\"Sri Lanka\\")","(name:fi,\\"Sri Lanka\\")","(name:fa,سری‌لانکا)","(name:eo,Sri-Lanko)","(name:en,\\"Sri Lanka\\")","(name:el,\\"Σρι Λάνκα\\")","(name:da,\\"Sri Lanka\\")","(name:br,\\"Sri Lanka\\")","(name:be,Шры-Ланка)","(name:ar,\\"سري لنكا\\")","(name,\\"Sri Lanka\\")"}	\N
lr	{"(official_name:vi,\\"Cộng hòa Liberia\\")","(official_name:sv,\\"Republiken Liberia\\")","(official_name:lv,\\"Libērijas Republika\\")","(official_name:lt,\\"Liberijos Respublika\\")","(official_name:id,\\"Republik Liberia\\")","(official_name:et,\\"Libeeria Vabariik\\")","(official_name:be,\\"Рэспубліка Ліберыя\\")","(official_name,\\"Republic of Liberia\\")","(name:zh_pyt,Lìbǐlǐyà)","(name:zh_py,Libiliya)","(name:zh,利比里亚)","(name:uk,Ліберія)","(name:tr,Liberya)","(name:th,ประเทศไลบีเรีย)","(name:sv,Liberia)","(name:sl,Liberija)","(name:ru,Либерия)","(name:pl,Liberia)","(name:mn,Либери)","(name:lv,Libērija)","(name:lt,Liberija)","(name:it,Liberia)","(name:is,Líbería)","(name:hu,Libéria)","(name:he,ליבריה)","(name:gd,Libèiria)","(name:ga,\\"An Libéir\\")","(name:fy,Libearia)","(name:fr,Liberia)","(name:fi,Liberia)","(name:fa,لیبریا)","(name:et,Libeeria)","(name:es,Liberia)","(name:eo,Liberio)","(name:en,Liberia)","(name:el,Λιβερία)","(name:da,Liberia)","(name:ca,Libèria)","(name:br,Liberia)","(name:be,Ліберыя)","(name:ar,ليبريا)","(name:af,Liberië)","(name,Liberia)"}	\N
mv	{"(official_name:sv,\\"Republiken Maldiverna\\")","(official_name:pl,\\"Republika Malediwów\\")","(official_name:lv,\\"Maldīvijas Republika\\")","(official_name:lt,\\"Maldyvų Respublika\\")","(official_name:lb,\\"Republik Malediven\\")","(official_name:it,\\"Repubblica delle Maledive\\")","(official_name:id,\\"Republik Maladewa\\")","(official_name:et,\\"Maldiivi Vabariik\\")","(name:zh_pyt,Mǎěrdàifū)","(name:zh_py,Maerdaifu)","(name:zh,马尔代夫)","(name:uk,Мальдіви)","(name:tr,Maldivler)","(name:th,ประเทศมัลดีฟส์)","(name:sv,Maldiverna)","(name:sl,Maldivi)","(name:ru,Мальдивы)","(name:pl,Malediwy)","(name:nl,Malediven)","(name:mn,Мальдив)","(name:lv,Maldīvija)","(name:lt,Maldyvai)","(name:lb,Malediven)","(name:la,\\"Insulae Maldivae\\")","(name:it,Maldive)","(name:is,Maldíveyjar)","(name:id,Maladewa)","(name:hu,Maldív-szigetek)","(name:hr,Maldivi)","(name:he,\\"האיים המלדיביים\\")","(name:haw,Maladiwa)","(name:gd,\\"Na h-Eileanan Mhaladaibh\\")","(name:ga,\\"Oileáin Mhaildíve\\")","(name:fy,\\"de Maldiven\\")","(name:fr,Maldives)","(name:fi,Malediivit)","(name:fa,مالدیو)","(name:et,Maldiivid)","(name:es,Maldivas)","(name:eo,Maldivoj)","(name:en,Maldives)","(name:el,Μαλδίβες)","(name:de,Malediven)","(name:da,Maldiverne)","(name:br,Maldivez)","(name:be,Мальдзівы)","(name:ar,ملديف)","(name:af,Maldive)","(name,Maldives)"}	\N
mw	{"(official_name:vi,\\"Cộng hòa Malawi\\")","(official_name:sv,\\"Republiken Malawi\\")","(official_name:lv,\\"Malāvijas Republika\\")","(official_name:lt,\\"Malavio Respublika\\")","(official_name:lb,\\"Republik Malawi\\")","(official_name:id,\\"Republik Malawi\\")","(official_name,\\"Republic of Malaŵi;Dziko la Malaŵi\\")","(name:zh_pyt,Mǎlāwéi)","(name:zh_py,Malawei)","(name:zh,马拉维)","(name:uk,Малаві)","(name:tr,Malavi)","(name:th,ประเทศมาลาวี)","(name:sv,Malawi)","(name:sl,Malavi)","(name:ru,Малави)","(name:pl,Malawi)","(name:mn,Малави)","(name:lv,Malāvija)","(name:lt,Malavis)","(name:la,Malavium)","(name:ja,マラウイ)","(name:it,Malawi)","(name:is,Malaví)","(name:hu,Malawi)","(name:hr,Malavi)","(name:he,מלאווי)","(name:haw,Malaui)","(name:gd,Malabhaidh)","(name:ga,\\"An Mhaláiv\\")","(name:fy,Malawy)","(name:fr,Malawi)","(name:fi,Malawi)","(name:fa,مالاوی)","(name:es,Malaui)","(name:eo,Malavio)","(name:en,Malawi)","(name:el,Μαλάουι)","(name:br,Malawi)","(name:be,Малаві)","(name:ar,ملاوي)","(name,Malawi)"}	\N
mz	{"(official_name:vi,\\"Cộng hòa Mozambique\\")","(official_name:sv,\\"Republiken Moçambique\\")","(official_name:lv,\\"Mozambikas Republika\\")","(official_name:lt,\\"Mozambiko Respublika\\")","(official_name:id,\\"Republik Mozambik\\")","(official_name:gd,\\"Poblachd Mhòsaimbic\\")","(official_name:el,\\"Δημοκρατία της Μοζαμβίκης\\")","(official_name,\\"República de Moçambique;République du Mozambique\\")","(name:zh_pyt,Mòsāngbǐkè)","(name:zh_py,Mosangbike)","(name:zh,莫桑比克)","(name:uk,Мозамбік)","(name:tr,Mozambik)","(name:th,ประเทศโมซัมบิก)","(name:sv,Moçambique)","(name:sl,Mozambik)","(name:ru,Мозамбик)","(name:pt,Moçambique)","(name:pl,Mozambik)","(name:mn,Мозамбик)","(name:lv,Mozambika)","(name:lt,Mozambikas)","(name:li,Mozambiek)","(name:lb,Mosambik)","(name:la,Mozambicum)","(name:it,Mozambico)","(name:is,Mósambík)","(name:id,Mozambik)","(name:hu,Mozambik)","(name:hr,Mozambik)","(name:he,מוזמביק)","(name:haw,Mozamabika)","(name:gd,Mòsaimbic)","(name:ga,Mósaimbíc)","(name:fy,Mozambyk)","(name:fr,Mozambique)","(name:fi,Mosambik)","(name:fa,موزامبیک)","(name:et,Mosambiik)","(name:es,Mozambique)","(name:eo,Mozambiko)","(name:en,Mozambique)","(name:el,Μοζαμβίκη)","(name:de,Mosambik)","(name:cy,Mosambic)","(name:br,Mozambik)","(name:be,Мазамбік)","(name:ar,موزمبيق)","(name:af,Mosambiek)","(name,Mozambique)"}	\N
na	{"(official_name:vi,\\"Cộng hòa Namibia\\")","(official_name:sv,\\"Republiken Namibia\\")","(official_name:sl,\\"Republika Namibija\\")","(official_name:lv,\\"Namībijas Republika\\")","(official_name:lt,\\"Namibijos Respublika\\")","(official_name:lb,\\"Republik Namibien\\")","(official_name:id,\\"Republik Namibia\\")","(official_name:gd,\\"Poblachd Namibia\\")","(official_name:el,\\"Δημοκρατία της Ναμίμπιας\\")","(official_name,\\"Republic of Namibia;Republiek van Namibia;Republik Namibia\\")","(name:zh_pyt,Nàmǐbǐyà)","(name:zh_py,Namibiya)","(name:zh,纳米比亚)","(name:uk,Намібія)","(name:tr,Namibya)","(name:th,ประเทศนามิเบีย)","(name:sv,Namibia)","(name:sl,Namibija)","(name:ru,Намибия)","(name:pl,Namibia)","(name:nl,Namibië)","(name:mn,Намиби)","(name:lv,Namībija)","(name:lt,Namibija)","(name:li,Namibië)","(name:lb,Namibien)","(name:it,Namibia)","(name:is,Namibía)","(name:hu,Namíbia)","(name:he,נמיביה)","(name:gd,Naimibia)","(name:ga,\\"An Namaib\\")","(name:fy,Namybje)","(name:fr,Namibie)","(name:fi,Namibia)","(name:fa,نامیبیا)","(name:et,Namiibia)","(name:es,Namibia)","(name:eo,Namibio)","(name:en,Namibia)","(name:el,Ναμίμπια)","(name:ca,Namíbia)","(name:br,Namibia)","(name:be,Намібія)","(name:ar,ناميبيا)","(name:af,Namibië)","(name,Namibia)"}	\N
ne	{"(official_name:vi,\\"Cộng hoà Niger\\")","(official_name:sv,\\"Republiken Niger\\")","(official_name:lv,\\"Nigēras Republika\\")","(official_name:lt,\\"Nigerio Respublika\\")","(official_name:id,\\"Republik Niger\\")","(official_name:gd,\\"Poblachd Nìgeir\\")","(official_name:en,\\"Republic of Niger\\")","(official_name:el,\\"Δημοκρατία του Νίγηρα\\")","(official_name,\\"République du Niger\\")","(name:zh_pyt,Nírìěr)","(name:zh_py,Nirier)","(name:zh,尼日尔)","(name:uk,Нігер)","(name:tr,Nijer)","(name:th,ประเทศไนเจอร์)","(name:sv,Niger)","(name:ru,Нигер)","(name:pl,Niger)","(name:mn,Нигер)","(name:lv,Nigēra)","(name:lt,Nigeris)","(name:ja,ニジェール)","(name:it,Niger)","(name:is,Níger)","(name:hu,Niger)","(name:he,ניז'ר)","(name:haw,Naigera)","(name:gd,Nìgeir)","(name:ga,\\"An Nígir\\")","(name:fr,Niger)","(name:fi,Niger)","(name:fa,نیجر)","(name:es,Níger)","(name:eo,Niĝero)","(name:en,Niger)","(name:el,Νίγηρας)","(name:da,Niger)","(name:ca,Níger)","(name:br,Niger)","(name:be,Нігер)","(name:ar,النيجر)","(name,Niger)"}	\N
nf	{"(official_name:pl,\\"Terytorium Wyspy Norfolk\\")","(official_name:lv,\\"Norfolkas salas teritorija\\")","(official_name,\\"Territory of Norfolk Island\\")","(name:zh,诺福克岛)","(name:vi,\\"Đảo Norfolk\\")","(name:uk,\\"Острів Норфолк\\")","(name:tr,\\"Norfolk Adası\\")","(name:sv,Norfolkön)","(name:ru,\\"Остров Норфолк\\")","(name:pl,\\"Wyspa Norfolk\\")","(name:pih,\\"Norfuk Ailen\\")","(name:nl,Norfolk)","(name:mn,\\"Норфолк Арал\\")","(name:lv,\\"Norfolkas sala\\")","(name:lt,\\"Norfolko sala\\")","(name:la,\\"Insula Norfolcia\\")","(name:it,\\"Isola Norfolk\\")","(name:is,Norfolkeyja)","(name:id,\\"Pulau Norfolk\\")","(name:hu,Norfolk-sziget)","(name:hr,\\"Otok Norfolk\\")","(name:he,\\"האי נורפוק\\")","(name:ga,\\"Oileán Norfolk\\")","(name:fy,Norfolk)","(name:fr,\\"Île Norfolk\\")","(name:fi,Norfolkinsaari)","(name:et,\\"Norfolki saar\\")","(name:es,\\"Isla Norfolk\\")","(name:eo,Norfolkinsulo)","(name:en,\\"Norfolk Island\\")","(name:de,Norfolkinsel)","(name:da,Norfolk-øen)","(name:cy,\\"Ynys Norfolk\\")","(name:ca,\\"Illa Norfolk\\")","(name:br,\\"Enez Norfolk\\")","(name:be,Норфалк)","(name:ar,\\"جزيرة نورفولك\\")","(name:af,Norfolkeiland)","(name,\\"Norfolk Island\\")"}	\N
py	{"(official_name:sv,\\"Republiken Paraguay\\")","(official_name:pl,\\"Republika Paragwaju\\")","(official_name:lv,\\"Paragvajas Republika\\")","(official_name:lt,\\"Paragvajaus Respublika\\")","(official_name:id,\\"Republik Paraguay\\")","(official_name:gd,\\"Poblachd Pharaguaidh\\")","(official_name:el,\\"Δημοκρατία της Παραγουάης\\")","(official_name,\\"República del Paraguay\\")","(name:zh,巴拉圭)","(name:uk,Парагвай)","(name:th,ประเทศปารากวัย)","(name:sv,Paraguay)","(name:sl,Paragvaj)","(name:ru,Парагвай)","(name:pl,Paragwaj)","(name:mn,Парагвай)","(name:lv,Paragvaja)","(name:lt,Paragvajus)","(name:la,Paraguaia)","(name:ja,パラグアイ)","(name:is,Paragvæ)","(name:hu,Paraguay)","(name:hr,Paragvaj)","(name:he,פראגואי)","(name:gd,Paraguaidh)","(name:ga,Paragua)","(name:fr,Paraguay)","(name:fi,Paraguay)","(name:fa,پاراگوئه)","(name:eo,Paragvajo)","(name:en,Paraguay)","(name:el,Παραγουάη)","(name:da,Paraguay)","(name:ca,Paraguai)","(name:br,Paraguay)","(name:be,Парагвай)","(name:ar,باراغواي)","(name,Paraguay)"}	\N
rw	{"(official_name:vi,\\"Cộng hòa Rwanda\\")","(official_name:sv,\\"Republiken Rwanda\\")","(official_name:lv,\\"Ruandas Republika\\")","(official_name:lt,\\"Ruandos Respublika\\")","(official_name:lb,\\"Republik Ruanda\\")","(official_name:id,\\"Republik Rwanda\\")","(official_name:gd,\\"Poblachd Ruanda\\")","(official_name:el,\\"Δημοκρατία της Ρουάντα\\")","(official_name,\\"Republic of Rwanda;Repubulika y'u Rwanda;République du Rwanda\\")","(name:zh_pyt,Lúwàngdá)","(name:zh_py,Luwangda)","(name:zh,卢旺达)","(name:uk,Руанда)","(name:tr,Ruanda)","(name:th,ประเทศรวันดา)","(name:sv,Rwanda)","(name:sl,Ruanda)","(name:ru,Руанда)","(name:pl,Rwanda)","(name:mn,Руанда)","(name:lv,Ruanda)","(name:lt,Ruanda)","(name:li,Roeanda)","(name:lb,Ruanda)","(name:la,Ruanda)","(name:ja,ルワンダ)","(name:it,Ruanda)","(name:is,Rúanda)","(name:hu,Ruanda)","(name:hr,Ruanda)","(name:he,רואנדה)","(name:haw,Ruanada)","(name:gd,Ruanda)","(name:ga,Ruanda)","(name:fy,Rûanda)","(name:fr,Rwanda)","(name:fi,Ruanda)","(name:fa,رواندا)","(name:es,Ruanda)","(name:eo,Ruando)","(name:en,Rwanda)","(name:el,Ρουάντα)","(name:de,Ruanda)","(name:br,Rwanda)","(name:be,Руанда)","(name:ar,رواندا)","(name,Rwanda)"}	\N
sv	{"(official_name:vi,\\"Cộng hòa El Salvador\\")","(official_name:sv,\\"Republiken El Salvador\\")","(official_name:pl,\\"Republika Salwadoru\\")","(official_name:lv,\\"Salvadoras Republika\\")","(official_name:ja,エルサルバドル共和国)","(official_name:id,\\"Republik El Salvador\\")","(official_name:el,\\"Δημοκρατία του Ελ Σαλβαδόρ\\")","(official_name:be,\\"Рэспубліка Эль-Сальвадор\\")","(official_name,\\"República de El Salvador\\")","(name:zh,萨尔瓦多)","(name:uk,Сальвадор)","(name:th,ประเทศเอลซัลวาดอร์)","(name:sv,\\"El Salvador\\")","(name:sl,Salvador)","(name:ru,Эль-Сальвадор)","(name:pl,Salwador)","(name:mn,\\"Эль Сальвадор\\")","(name:lv,Salvadora)","(name:lt,\\"El Salvadoras\\")","(name:la,Salvatoria)","(name:ja,エルサルバドル)","(name:it,\\"El Salvador\\")","(name:is,\\"El Salvador\\")","(name:hu,\\"El Salvador\\")","(name:hr,Salvador)","(name:he,\\"אל סלבדור\\")","(name:gd,\\"El Salbhador\\")","(name:ga,\\"An tSalvadóir\\")","(name:fr,Salvador)","(name:fi,\\"El Salvador\\")","(name:fa,السالوادور)","(name:eo,Salvadoro)","(name:en,\\"El Salvador\\")","(name:el,\\"Ελ Σαλβαδόρ\\")","(name:da,\\"El Salvador\\")","(name:br,Salvador)","(name:be,Эль-Сальвадор)","(name:ar,السلفادور)"}	\N
sy	{"(official_name:sv,\\"Arabrepubliken Syrien\\")","(official_name:ru,\\"Сирийская Арабская Республика\\")","(official_name:pt,\\"República Árabe da Síria\\")","(official_name:pl,\\"Syryjska Republika Arabska\\")","(official_name:lt,\\"Sirijos Arabų Respublika\\")","(official_name:lb,\\"Arabesch Republik Syrien\\")","(official_name:it,\\"Repubblica Araba di Siria\\")","(official_name:id,\\"Republik Arab Suriah\\")","(official_name:gd,\\"Poblachd Arabach Shirianach\\")","(official_name:el,\\"Αραβική Δημοκρατία της Συρίας\\")","(official_name:ca,\\"República Àrab Siriana\\")","(official_name:br,\\"Republik Arab Siria\\")","(name:zh_pyt,Xùlìyà)","(name:zh_py,Xuliya)","(name:zh,叙利亚)","(name:vi,Syria)","(name:uk,Сирія)","(name:tr,Suriye)","(name:th,ประเทศซีเรีย)","(name:sv,Syrien)","(name:sl,Sirija)","(name:ru,Сирия)","(name:pt,Síria)","(name:pl,Syria)","(name:nl,Syrië)","(name:mn,Сири)","(name:lv,Sīrija)","(name:lt,Sirija)","(name:li,Syrië)","(name:lb,Syrien)","(name:la,Syria)","(name:ja,シリア)","(name:it,Siria)","(name:is,Sýrland)","(name:id,Suriah)","(name:hu,Szíria)","(name:hr,Sirija)","(name:he,סוריה)","(name:haw,Suria)","(name:gd,Siria)","(name:ga,\\"An tSiria\\")","(name:fy,Syrje)","(name:fr,Syrie)","(name:fi,Syyria)","(name:fa,سوریه)","(name:es,Siria)","(name:eo,Sirio)","(name:en,Syria)","(name:el,Συρία)","(name:de,Syrien)","(name:da,Syrien)","(name:ca,Síria)","(name:br,Siria)","(name:be,Сірыя)","(name:ar,سوريا)","(name:af,Sirië)","(name,\\"Sūriyya سوريا\\")"}	\N
tc	{"(official_name:et,\\"Turksi ja Caicose saarte asumaa\\")","(name:zh-min-nan,\\"Turks kap Caicos Kûn-tó\\")","(name:zh,特克斯和凱科斯群島)","(name:wo,\\"Turks and Caicos Islands\\")","(name:vi,\\"Quần đảo Turks và Caicos\\")","(name:uk,\\"Острови Теркс і Кайкос\\")","(name:ug,\\"Turks we Kaykos Taqim Aralliri\\")","(name:tr,\\"Turks ve Caicos Adaları\\")","(name:th,หมู่เกาะเติร์กและไคคอส)","(name:ta,\\"துர்கசு கைகோசு தீவுகள்\\")","(name:sw,\\"Visiwa vya Turks na Caicos\\")","(name:sv,\\"Turks- och Caicosöarna\\")","(name:sr,\\"Туркс и Кајкос\\")","(name:sq,\\"Turks dhe Kaikos\\")","(name:sk,\\"Turks a Caicos\\")","(name:simple,\\"Turks and Caicos Islands\\")","(name:sh,\\"Turks i Caicos Otoci\\")","(name:ru,\\"Острова Тёркс и Кайкос\\")","(name:ro,\\"Insulele Turks şi Caicos\\")","(name:pt,\\"Turks e Caicos\\")","(name:pms,\\"Turks e Caicos\\")","(name:pl,\\"Turks i Caicos\\")","(name:nov,\\"Turks e Kaikos Isles\\")","(name:no,\\"Turks- og Caicosøyene\\")","(name:nn,\\"Turks- og Caicosøyane\\")","(name:nl,\\"Turks- en Caicoseilanden\\")","(name:ms,\\"Kepulauan Turks dan Caicos\\")","(name:mr,\\"टर्क्स आणि कैकास द्वीपसमूह\\")","(name:mn,\\"Туркс ба Кайкосын Арлууд\\")","(name:lv,\\"Tērksas un Kaikosas\\")","(name:lt,\\"Terkso ir Kaikoso salos\\")","(name:lmo,\\"Turks e Caicos\\")","(name:lij,\\"Turks e Caicos\\")","(name:kw,\\"Turks ha Kaykos\\")","(name:ko,\\"터크스 케이커스 제도\\")","(name:jv,\\"Kapuloan Turks lan Caicos\\")","(name:ja,タークス・カイコス諸島)","(name:it,\\"Turks e Caicos\\")","(name:is,\\"Turks- og Caicoseyjar\\")","(name:io,\\"Turks e Kaikos-Insuli\\")","(name:id,\\"Kepulauan Turks dan Caicos\\")","(name:hu,\\"Turks- és Caicos-szigetek\\")","(name:hr,\\"Otoci Turks i Caicos\\")","(name:hi,\\"टर्क्स और केकोस द्वीप-समूह\\")","(name:he,\\"איי טרקס וקייקוס\\")","(name:gl,\\"Turks e Caicos\\")","(name:gd,\\"Oileáin na dTurcach agus Caicos\\")","(name:ga,\\"Oileáin na dTurcach agus Caicos\\")","(name:fy,\\"Turks- en Kaikoseilannen\\")","(name:frp,\\"Iles Turques et Cayiques\\")","(name:fr,\\"Îles Turques-et-Caïques\\")","(name:fi,\\"Turks- ja Caicossaaret\\")","(name:fa,\\"جزایر تورکس و کایکوس\\")","(name:eu,\\"Turks eta Caicos uharteak\\")","(name:et,\\"Turks ja Caicos\\")","(name:es,\\"Islas Turcas y Caicos\\")","(name:eo,\\"Turkoj kaj Kajkoj\\")","(name:en,\\"Turks and Caicos Islands\\")","(name:el,\\"Τερκς και Κάικος\\")","(name:dv,\\"ޓާކަސް އަދި ކައިކޯ ޖަޒީރާ\\")","(name:dsb,\\"Turks a Caicos\\")","(name:de,\\"Turks- und Caicosinseln\\")","(name:da,\\"Turks- og Caicosøerne\\")","(name:cy,\\"Ynysoedd Turks a Caicos\\")","(name:cv,\\"Тĕркс тата Кайкос\\")","(name:cs,\\"Turks a Caicos\\")","(name:ca,\\"Illes Turks i Caicos\\")","(name:bs,\\"Ostrva Turks i Caicos\\")","(name:br,\\"Inizi  Turks ha Caicos\\")","(name:bpy,\\"তার্কস বারো কাইকোস দ্বীপমালা\\")","(name:bn,\\"টার্কস্‌ ও কেইকোস দ্বীপপুঞ্জ\\")","(name:bg,\\"Търкс и Кайкос\\")","(name:be-x-old,\\"Тэркс і Кэйкас\\")","(name:ast,\\"Islles Turques y Caicos\\")","(name:ar,\\"جزر تركس وكايكوس\\")","(name:an,\\"Islas Turcas e Caicos\\")","(name:af,\\"Turks en Caicos Eilande\\")","(name,\\"Turks and Caicos Islands\\")"}	\N
to	{"(official_name:vi,\\"Vương quốc Tonga\\")","(official_name:sv,\\"Konungariket Tonga\\")","(official_name:ru,\\"Королевство Тонга\\")","(official_name:pt,\\"Reino de Tonga\\")","(official_name:pl,\\"Królestwo Tonga\\")","(official_name:lt,\\"Tongos Karalystė\\")","(official_name:lb,\\"Kinneksräich Tonga\\")","(official_name:id,\\"Kerajaan Tonga\\")","(official_name:es,\\"Reino de Tonga\\")","(official_name:en,\\"Kingdom of Tonga\\")","(official_name:br,\\"Rouantelezh Tonga\\")","(official_name,\\"Pule'anga Fakatu'i 'o Tonga\\")","(name:zh,汤加群岛)","(name:uk,Тонга)","(name:th,ประเทศตองกา)","(name:sv,Tonga)","(name:ru,Тонга)","(name:pt,Tonga)","(name:pl,Tonga)","(name:mn,Тонга)","(name:hu,Tonga)","(name:he,טונגה)","(name:ga,Tonga)","(name:fr,Tonga)","(name:fi,Tonga)","(name:fa,تونگا)","(name:eo,Tongo)","(name:en,Tonga)","(name:el,Τόνγκα)","(name:da,Tonga)","(name:br,Tonga)","(name:be,Тонга)","(name:ar,تونغا)","(name,Tonga)"}	\N
va	{"(official_name:vi,\\"Thành Quốc Vatican\\")","(official_name:sk,\\"Vatikánsky mestský štát\\")","(official_name:pl,\\"Państwo Watykańskie\\")","(official_name:lb,\\"Stat Vatikanstad\\")","(official_name:la,\\"Status Civitatis Vaticanae\\")","(official_name:fr,\\"État de la Cité du Vatican\\")","(official_name:el,\\"Κράτος της πόλης του Βατικανού\\")","(official_name,\\"Stato della Città del Vaticano\\")","(name:zh_pyt,Fàndìgāng)","(name:zh_py,Fandigang)","(name:zh,梵蒂冈)","(name:vi,\\"Thành Vatican\\")","(name:uk,Ватикан)","(name:tr,Vatikan)","(name:th,นครรัฐวาติกัน)","(name:sv,Vatikanstaten)","(name:sl,Vatikan)","(name:sk,Vatikán)","(name:ru,Ватикан)","(name:pt,\\"Cidade do Vaticano\\")","(name:pl,Watykan)","(name:nl,Vaticaanstad)","(name:mn,\\"Ватикан Хот Улс\\")","(name:lv,\\"Vatikāns (Svētais Krēsls)\\")","(name:lt,\\"Vatikano Miesto Valstybė\\")","(name:li,Vaticaanstad)","(name:lb,Vatikanstad)","(name:la,\\"Civitas Vaticana\\")","(name:it,\\"Città del Vaticano\\")","(name:is,Vatíkanið)","(name:id,Vatikan)","(name:hu,Vatikán)","(name:hr,Vatikan)","(name:he,ותיקן)","(name:haw,\\"Ka Watikano\\")","(name:gd,\\"Cathair na Bhatacain\\")","(name:ga,\\"Cathair na Vatacáine\\")","(name:fy,Fatikaanstêd)","(name:fr,Vatican)","(name:fi,Vatikaanivaltio)","(name:fa,واتیکان)","(name:eu,\\"Vatikano Hiria\\")","(name:et,Vatikan)","(name:es,\\"Ciudad del Vaticano\\")","(name:eo,Vatikanurbo)","(name:en,\\"Vatican City\\")","(name:el,Βατικανό)","(name:de,Vatikanstadt)","(name:da,Vatikanstaten)","(name:cy,\\"Dinas y Fatican\\")","(name:ca,\\"Ciutat del Vaticà\\")","(name:br,Vatikan)","(name:be,Ватыкан)","(name:ar,الفاتيكان)","(name:af,Vatikaanstad)","(name,\\"Città del Vaticano\\")"}	\N
ve	{"(official_name:vi,\\"Cộng hòa Bolivar Venezuela\\")","(official_name:sv,\\"Bolivarianska republiken Venezuela\\")","(official_name:pt,\\"República Bolivariana da Venezuela\\")","(official_name:pl,\\"Boliwariańska Republika Wenezueli\\")","(official_name:lt,\\"Venesuelos Bolivaro Respublika\\")","(official_name:id,\\"Republik Bolivar Venezuela\\")","(official_name:en,\\"Bolivarian Republic of Venezuela\\")","(official_name:be,\\"Баліварыянская Рэспубліка Венесуэла\\")","(official_name,\\"República Bolivariana de Venezuela\\")","(name:zh,委内瑞拉)","(name:uk,Венесуела)","(name:th,ประเทศเวเนซุเอลา)","(name:sv,Venezuela)","(name:ru,Венесуэла)","(name:pt,Venezuela)","(name:pl,Wenezuela)","(name:mn,Венесуэл)","(name:lv,Venecuēla)","(name:lt,Venesuela)","(name:la,Venetiola)","(name:ja,ベネズエラ)","(name:is,Venusúela)","(name:hu,Venezuela)","(name:he,ונצואלה)","(name:gd,\\"A' Bheiniseala\\")","(name:ga,Veiniséala)","(name:fy,Fenezuëla)","(name:fr,Venezuela)","(name:fi,Venezuela)","(name:fa,ونزوئلا)","(name:eo,Venezuelo)","(name:en,Venezuela)","(name:el,Βενεζουέλα)","(name:da,Venezuela)","(name:ca,Veneçuela)","(name:br,Venezuela)","(name:be,Венесуэла)","(name:ar,فنزويلا)","(name,Venezuela)"}	\N
vg	{"(name:zh,英属维尔京群岛)","(name:vi,\\"Quần đảo Virgin thuộc Anh\\")","(name:uk,\\"Британські Віргінські острови\\")","(name:tr,\\"Birleşik Krallık Virgin Adaları\\")","(name:th,หมู่เกาะบริติชเวอร์จิน)","(name:sv,\\"Brittiska Jungfruöarna\\")","(name:sl,\\"Britanski Deviški otoki\\")","(name:ru,\\"Британские Виргинские острова\\")","(name:pl,\\"Brytyjskie Wyspy Dziewicze\\")","(name:nl,\\"Britse Maagdeneilanden\\")","(name:mn,\\"Виржиний Арлууд, Британийн\\")","(name:lv,\\"Britu Virdžīnu salas\\")","(name:lt,\\"Mergelės salos (Britų)\\")","(name:lb,\\"Britesch Joffereninselen\\")","(name:la,\\"Britannicae Virginis Insulae\\")","(name:ja,イギリス領ヴァージン諸島)","(name:it,\\"Isole Vergini Britanniche\\")","(name:is,\\"Bresku Jómfrúaeyjar\\")","(name:id,\\"Kepulauan Virgin Britania Raya\\")","(name:hu,\\"Brit Virgin-szigetek\\")","(name:hr,\\"Britanski Djevičanski otoci\\")","(name:he,\\"איי הבתולה הבריטיים\\")","(name:ga,\\"Oileáin Bhriotanacha na Maighdean\\")","(name:fr,\\"Îles Vierges britanniques\\")","(name:fi,\\"Brittiläiset Neitsytsaaret\\")","(name:fa,\\"جزایر ویرجین بریتانیا\\")","(name:eu,\\"Birjina uharte britainiarrak\\")","(name:et,\\"Briti Neitsisaared\\")","(name:es,\\"Islas Vírgenes Británicas\\")","(name:eo,\\"Britaj Virgulininsuloj\\")","(name:en,\\"British Virgin Islands\\")","(name:de,\\"Britische Jungferninseln\\")","(name:da,\\"Britiske Jomfruøer\\")","(name:ca,\\"Illes Verges Britàniques\\")","(name:br,\\"Inizi Gwerc’h Breizhveuriat\\")","(name:be,\\"Брытанскія Вірджынскія астравы\\")","(name:ar,\\"جزر فيرجن البريطانية\\")","(name:af,Brits-Maagde-eilande)","(name,\\"British Virgin Islands\\")"}	\N
id	{"(official_name:vi,\\"Cộng hòa Indonesia\\")","(official_name:tl,\\"Republika ng Indonesya\\")","(official_name:sv,\\"Republiken Indonesien\\")","(official_name:pl,\\"Republika Indonezji\\")","(official_name:lv,\\"Indonēzijas Republika\\")","(official_name:lt,\\"Indonezijos Respublika\\")","(official_name:fr,\\"République d'Indonésie\\")","(official_name:et,\\"Indoneesia Vabariik\\")","(official_name:en,\\"Republic of Indonesia\\")","(official_name:el,\\"Δημοκρατία της Ινδονησίας\\")","(official_name,\\"Republik Indonesia\\")","(name:zh,印度尼西亚)","(name:uk,Індонезія)","(name:tr,Endonezya)","(name:tl,Indonesya)","(name:th,ประเทศอินโดนีเซีย)","(name:sv,Indonesien)","(name:sl,Indonezija)","(name:ru,Индонезия)","(name:pl,Indonezja)","(name:nl,Indonesië)","(name:mn,Индонез)","(name:lv,Indonēzija)","(name:lt,Indonezija)","(name:li,Indonesië)","(name:lb,Indonesien)","(name:ja,インドネシア)","(name:it,Indonesia)","(name:is,Indonesía)","(name:hu,Indonézia)","(name:hr,Indonezija)","(name:he,אינדונזיה)","(name:haw,‘Inidonesia)","(name:gd,\\"An Innd-Innse\\")","(name:ga,\\"An Indinéis\\")","(name:fy,Yndoneezje)","(name:fr,Indonésie)","(name:fi,Indonesia)","(name:fa,اندونزی)","(name:et,Indoneesia)","(name:eo,Indonezio)","(name:en,Indonesia)","(name:el,Ινδονησία)","(name:de,Indonesien)","(name:da,Indonesien)","(name:ca,Indonèsia)","(name:br,Indonezia)","(name:be,Інданэзія)","(name:az,İndoneziya)","(name:ar,إندونيسيا)","(name:af,Indonesië)","(name,Indonesia)"}	\N
mh	{"(official_name:vi,\\"Cộng hoà Quần đảo Marshal\\")","(official_name:sv,\\"Republiken Marshallöarna\\")","(official_name:sl,\\"Republika Marshallovi otoki\\")","(official_name:pt,\\"República das Ilhas Marshall\\")","(official_name:pl,\\"Republika Wysp Marshalla\\")","(official_name:lv,\\"Māršala Salu Republika\\")","(official_name:lt,\\"Maršalo Salų Respublika\\")","(official_name:lb,\\"Republik Marshallinselen\\")","(official_name:id,\\"Republik Kepulauan Marshall\\")","(official_name:es,\\"República de las Islas Marshall\\")","(official_name:be,\\"Маршалавы астравы\\")","(official_name,\\"Aolepān Aorōkin M̧ajeļ;Republic of the Marshall Islands\\")","(name:zh,马绍尔群岛)","(name:vi,\\"Quần đảo Marshall\\")","(name:uk,\\"Маршаллові Острови\\")","(name:tr,\\"Marshall Adaları\\")","(name:th,สาธารณรัฐหมู่เกาะมาร์แชลล์)","(name:sv,Marshallöarna)","(name:sl,\\"Marshallovi otoki\\")","(name:ru,\\"Маршалловы Острова\\")","(name:pt,\\"Ilhas Marshall\\")","(name:pl,\\"Wyspy Marshalla\\")","(name:nl,Marshalleilanden)","(name:mn,\\"Маршаллын арлууд\\")","(name:lv,\\"Māršala salas\\")","(name:lt,\\"Maršalo salos\\")","(name:li,Marshall-eilen)","(name:lb,Marshallinselen)","(name:la,\\"Insulae Marsalienses\\")","(name:it,\\"Isole Marshall\\")","(name:is,Marshalleyjar)","(name:id,\\"Kepulauan Marshall\\")","(name:hu,Marshall-szigetek)","(name:hr,\\"Maršalovi Otoci\\")","(name:he,\\"איי מרשל\\")","(name:gd,\\"Na h-Eileanan Mharshall\\")","(name:ga,\\"Oileáin Marshall\\")","(name:fy,\\"de Marshalleilannen\\")","(name:fr,\\"Îles Marshall\\")","(name:fi,Marshallinsaaret)","(name:fa,\\"جزایر مارشال\\")","(name:et,\\"Marshalli Saared\\")","(name:es,\\"Islas Marshall\\")","(name:eo,\\"Marŝala Insularo\\")","(name:en,\\"Marshall Islands\\")","(name:de,Marshallinseln)","(name:da,Marshalløerne)","(name:cy,\\"Ynysoedd Marshall\\")","(name:ca,\\"Illes Marshall\\")","(name:br,\\"Inizi Marshall\\")","(name:be,\\"Маршалавы астравы\\")","(name:ar,\\"جزر مارشال\\")","(name:af,Marshalleilande)","(name,\\"Marshall Islands\\")"}	\N
gl	{"(name:zh-yue,格陵蘭)","(name:zh_pyt,\\"Gélínglán Dǎo\\")","(name:zh_py,\\"Gelinglan Dao\\")","(name:zh-min-nan,Chheⁿ-tē)","(name:zh-classical,格陵蘭)","(name:zh,格陵兰岛)","(name:wuu,格陵兰)","(name:wo,Groenlaand)","(name:vi,Greenland)","(name:vec,Groenłandia)","(name:uk,Ґренландія)","(name:ug,Grénlandiye)","(name:tr,Grönland)","(name:tpi,Greenland)","(name:tl,Lupanlunti)","(name:th,กรีนแลนด์)","(name:tg,Гренландия)","(name:te,గ్రీన్‌లాండ్)","(name:ta,கிறீன்லாந்து)","(name:szl,Grynlandyjo)","(name:sw,Greenland)","(name:sv,Grönland)","(name:sr,Гренланд)","(name:sq,Grenlanda)","(name:sl,Grenlandija)","(name:sk,Grónsko)","(name:simple,Greenland)","(name:sh,Grenland)","(name:scn,Groenlannia)","(name:ru,Гренландия)","(name:ro,Groenlanda)","(name:qu,\\"Kalalit Nunat\\")","(name:pt,Gronelândia)","(name:pms,Groenlandia)","(name:pl,Grenlandia)","(name:pa,ਗਰੀਨਲੈਂਡ)","(name:os,Гренланди)","(name:oc,Groenlàndia)","(name:nov,Verdi-lande)","(name:no,Grønland)","(name:nn,Grønland)","(name:nl,Groenland)","(name:nds-nl,Gruunlaand)","(name:nds,Gröönland)","(name:nah,Groentlālpan)","(name:ms,Greenland)","(name:mr,ग्रीनलँड)","(name:mn,Гренланд)","(name:ml,ഗ്രീന്‍ലാന്‍ഡ്)","(name:mk,Гренланд)","(name:lv,Grenlande)","(name:lt,Grenlandija)","(name:lij,Gròenlandia)","(name:li,Greunland)","(name:lb,Grönland)","(name:la,Groenlandia)","(name:kw,Greunland)","(name:kv,Гренландия)","(name:ku,Gronland)","(name:ko,그린란드)","(name:kn,ಗ್ರೀನ್‍ಲ್ಯಾಂಡ್)","(name:kl,\\"Kalaallit Nunaat\\")","(name:kk,Гренландия)","(name:ka,გრენლანდია)","(name:jv,Greenland)","(name:ja,グリーンランド)","(name:iu,ᐊᑯᑭᑦᑐᑦ/akukittut)","(name:it,Groenlandia)","(name:is,Grænland)","(name:io,Grenlando)","(name:id,Greenland)","(name:ia,Groenlandia)","(name:hu,Grönland)","(name:hr,Grenland)","(name:hif,Greenland)","(name:he,גרינלנד)","(name:gv,Greenlynn)","(name:gl,Grenlandia)","(name:gd,\\"A' Ghraonlainn\\")","(name:ga,\\"An Ghraonlainn\\")","(name:fy,Grienlân)","(name:frp,Grônlande)","(name:fr,Groenland)","(name:fo,Grønland)","(name:fi,Grönlanti)","(name:fa,گرینلند)","(name:eu,Groenlandia)","(name:et,Gröönimaa)","(name:es,Groenlandia)","(name:eo,Gronlando)","(name:en,Greenland)","(name:el,Γροιλανδία)","(name:dv,ގުރީންލޭންޑު)","(name:dsb,Grónlandska)","(name:de,Grönland)","(name:da,Grønland)","(name:cy,\\"Yr Ynys Las\\")","(name:cv,Гренланди)","(name:cs,Grónsko)","(name:ca,Grenlàndia)","(name:bs,Grenland)","(name:br,Greunland)","(name:bpy,গ্রীনল্যান্ড)","(name:bo,གེ་རེན་ལ)","(name:bn,গ্রিনল্যান্ড)","(name:bg,Гренландия)","(name:be-x-old,Грэнляндыя)","(name:be,Грэнландыя)","(name:bat-smg,Grenlandėjė)","(name:bar,Grönland)","(name:ast,Groenlandia)","(name:ar,غرينلاند)","(name:ang,Grēneland)","(name:an,Gronlandia)","(name:am,ግሪንላንድ)","(name:af,Groenland)","(name,\\"Kalaallit Nunaat\\")"}	\N
se	{"(official_name:vi,\\"Vương quốc Thụy Điển\\")","(official_name:sv,\\"Konungariket Sverige\\")","(official_name:sk,\\"Švédske kráľovstvo\\")","(official_name:pt,\\"Reino da Suécia\\")","(official_name:lt,\\"Švedijos Karalystė\\")","(official_name:lb,\\"Kinneksräich Schweden\\")","(official_name:ja,スウェーデン王国)","(official_name:id,\\"Kerajaan Swedia\\")","(official_name:fr,\\"Royaume de Suède\\")","(official_name:et,\\"Rootsi Kuningriik\\")","(official_name:el,\\"Βασίλειο της Σουηδίας\\")","(official_name:be,\\"Каралеўства Швецыя\\")","(official_name:af,\\"Koninkryk Swede\\")","(official_name,\\"Konungariket Sverige\\")","(name:zh_pyt,Ruìdiǎn)","(name:zh_py,Ruidian)","(name:zh,瑞典)","(name:vi,\\"Thụy Điển\\")","(name:uk,Швеція)","(name:tr,İsveç)","(name:th,ประเทศสวีเดน)","(name:sv,Sverige)","(name:sl,Švedska)","(name:sk,Švédsko)","(name:ru,Швеция)","(name:pt,Suécia)","(name:pl,Szwecja)","(name:nl,Zweden)","(name:mn,Швед)","(name:lv,Zviedrija)","(name:lt,Švedija)","(name:li,Zwaede)","(name:lb,Schweden)","(name:la,Suecia)","(name:ja,スウェーデン)","(name:it,Svezia)","(name:is,Svíþjóð)","(name:id,Swedia)","(name:hy,Շվեդիա)","(name:hu,Svédország)","(name:hr,Švedska)","(name:he,שוודיה)","(name:haw,Kuekene)","(name:gd,\\"An t-Suain\\")","(name:ga,\\"An tSualainn\\")","(name:fy,Sweden)","(name:fr,Suède)","(name:fi,Ruotsi)","(name:fa,سوئد)","(name:et,Rootsi)","(name:es,Suecia)","(name:eo,Svedio)","(name:en,Sweden)","(name:el,Σουηδία)","(name:de,Schweden)","(name:cy,Sweden)","(name:ca,Suècia)","(name:br,Sveden)","(name:be,Швецыя)","(name:ar,السويد)","(name:af,Swede)","(name,Sverige)"}	\N
cy	{"(official_name:vi,\\"Cộng hòa Síp\\")","(official_name:tr,\\"Kıbrıs Cumhuriyeti\\")","(official_name:sv,\\"Republiken Cypern\\")","(official_name:pt,\\"República de Chipre\\")","(official_name:pl,\\"Republika Cypryjska\\")","(official_name:lv,\\"Kipras Republika\\")","(official_name:lt,\\"Kipro Respublika\\")","(official_name:lb,\\"Republik Zypern\\")","(official_name:ja,キプロス共和国)","(official_name:id,\\"Republik Siprus\\")","(official_name:et,\\"Küprose Vabariik\\")","(official_name:es,\\"República de Chipre\\")","(official_name:el,\\"Κυπριακή Δημοκρατία\\")","(official_name:br,\\"Republik Kiprenez\\")","(official_name,\\"Κυπριακή Δημοκρατία\\")","(name:zh_pyt,Sàipǔlùsī)","(name:zh_py,Saipulusi)","(name:zh,塞浦路斯)","(name:vi,Síp)","(name:uk,Кіпр)","(name:tr,Kıbrıs)","(name:th,ประเทศไซปรัส)","(name:sv,Cypern)","(name:sl,Ciper)","(name:ru,Кипр)","(name:pt,Chipre)","(name:pl,Cypr)","(name:nl,Cyprus)","(name:mn,Кипр)","(name:lv,Kipra)","(name:lt,Kipras)","(name:li,Cyprus)","(name:lb,Zypern)","(name:la,Cyprus)","(name:ja,キプロス)","(name:it,Cipro)","(name:is,Kýpur)","(name:id,Siprus)","(name:hu,Ciprus)","(name:hr,Cipar)","(name:he,קפריסין)","(name:haw,Kupelo)","(name:gd,Cìopras)","(name:ga,\\"An Chipir\\")","(name:fy,Syprus)","(name:fr,Chypre)","(name:fi,Kypros)","(name:fa,قبرس)","(name:et,Küpros)","(name:es,Chipre)","(name:eo,Kipro)","(name:en,Cyprus)","(name:el,Κύπρος)","(name:de,Zypern)","(name:da,Cypern)","(name:cy,Cyprus)","(name:ca,Xipre)","(name:br,Kiprenez)","(name:be,Кіпр)","(name:ar,قبرص)","(name:af,Siprus)","(name,Κύπρος)"}	\N
sg	{"(official_name:vi,\\"Cộng hòa Singapore\\")","(official_name:tl,\\"Republika ng Singgapur\\")","(official_name:sv,\\"Republiken Singapore\\")","(official_name:pl,\\"Republika Singapuru\\")","(official_name:lt,\\"Singapūro Respublika\\")","(official_name:lb,\\"Republik Singapur\\")","(official_name:it,\\"Repubblica di Singapore\\")","(official_name:id,\\"Republik Singapura\\")","(official_name:et,\\"Singapuri Vabariik\\")","(official_name:el,\\"Δημοκρατία της Σιγκαπούρης\\")","(official_name:br,\\"Republik Singapour\\")","(official_name,\\"Republic of Singapore\\")","(name:zh_pyt,Xīnjiāpō)","(name:zh_py,Xinjiapo)","(name:zh,新加坡)","(name:uk,Сінгапур)","(name:tr,Singapur)","(name:tl,Singgapur)","(name:th,ประเทศสิงคโปร์)","(name:sv,Singapore)","(name:sl,Singapur)","(name:ru,Сингапур)","(name:pl,Singapur)","(name:ms,Singapura)","(name:mn,Сингапур)","(name:lt,Singapūras)","(name:lb,Singapur)","(name:la,Singapura)","(name:it,Singapore)","(name:is,Singapúr)","(name:id,Singapura)","(name:hu,Szingapúr)","(name:hr,Singapur)","(name:he,סינגפור)","(name:haw,Sinapoa)","(name:gd,Siongapòr)","(name:ga,Singeapór)","(name:fr,Singapour)","(name:fi,Singapore)","(name:fa,سنگاپور)","(name:et,Singapur)","(name:es,Singapur)","(name:eo,Singapuro)","(name:el,Σιγκαπούρη)","(name:de,Singapur)","(name:ca,Singapur)","(name:br,Singapour)","(name:be,Сінгапур)","(name:ar,سنغافورة)","(name:af,Singapoer)","(name,Singapore)"}	\N
vu	{"(official_name:vi,\\"Cộng hòa Vanuatu\\")","(official_name:sv,\\"Republiken Vanuatu\\")","(official_name:pt,\\"República do Vanuatu\\")","(official_name:pl,\\"Republika Vanuatu\\")","(official_name:lt,\\"Vanuatu Respublika\\")","(official_name:lb,\\"Republik Vanuatu\\")","(official_name:ja,バヌアツ共和国)","(official_name:id,\\"Republik Vanuatu\\")","(official_name:fr,\\"République de Vanuatu\\")","(official_name:es,\\"República de Vanuatu\\")","(official_name:en,\\"Republic of Vanuatu\\")","(official_name:el,\\"Δημοκρατία του Βανουάτου\\")","(official_name,\\"Ripablik blong Vanuatu\\")","(name:zh,瓦努阿图)","(name:uk,Вануату)","(name:th,ประเทศวานูอาตู)","(name:sv,Vanuatu)","(name:ru,Вануату)","(name:pt,Vanuatu)","(name:pl,Vanuatu)","(name:mn,Вануату)","(name:ja,バヌアツ)","(name:is,Vanúatú)","(name:hu,Vanuatu)","(name:he,ונואטו)","(name:gd,Bhanuatu)","(name:ga,Vanuatú)","(name:fy,Fanuatû)","(name:fr,Vanuatu)","(name:fi,Vanuatu)","(name:fa,وانواتو)","(name:eo,Vanuatuo)","(name:el,Βανουάτου)","(name:da,Vanuatu)","(name:br,Vanuatu)","(name:be,Вануату)","(name:ar,فانواتو)","(name,Vanuatu)"}	\N
cn	{"(official_name:zh_pyt,\\"Zhōnghuá Rénmín Gònghéguó\\")","(official_name:zh_py,\\"Zhonghua Renmin Gongheguo\\")","(official_name:vi,\\"Cộng hòa Nhân dân Trung Hoa\\")","(official_name:sv,\\"Folkrepubliken Kina\\")","(official_name:sl,\\"Ljudska republika Kitajska\\")","(official_name:pt,\\"República Popular da China\\")","(official_name:pl,\\"Chińska Republika Ludowa\\")","(official_name:lv,\\"Ķīnas Tautas Republika\\")","(official_name:lt,\\"Kinijos Liaudies Respublika\\")","(official_name:lb,\\"Volleksrepublik China\\")","(official_name:la,\\"Res Publica Popularis Sinarum\\")","(official_name:ja,中華人民共和国)","(official_name:it,\\"Repubblica Popolare Cinese\\")","(official_name:id,\\"Republik Rakyat Cina\\")","(official_name:hy,\\"Չինաստանի Ժողովրդական Հանրապետություն\\")","(official_name:gd,\\"Sluagh-Phoblachd na Sìne\\")","(official_name:eu,\\"Txinako Herri Errepublika\\")","(official_name:en,\\"People's Republic of China\\")","(official_name:el,\\"Λαϊκή Δημοκρατία της Κίνας\\")","(official_name:br,\\"Republik Pobl Sina\\")","(official_name:af,\\"Volksrepubliek van Sjina\\")","(official_name,中华人民共和国)","(name:zh_pyt,Zhōngguó)","(name:zh_py,Zhongguo)","(name:zh,中国)","(name:vi,\\"Trung Hoa\\")","(name:uk,Китай)","(name:tr,\\"Çin Halk Cumhuriyeti\\")","(name:tl,Tsina)","(name:th,ประเทศจีน)","(name:sv,Kina)","(name:sl,Kitajska)","(name:ru,Китай)","(name:pt,China)","(name:pl,Chiny)","(name:no,Kina)","(name:nn,Kina)","(name:nl,China)","(name:nb,Kina)","(name:mn,Хятад)","(name:lv,Ķīna)","(name:lt,Kinija)","(name:li,Sjina)","(name:lb,\\"Volleksrepublik China\\")","(name:la,Sinae)","(name:ja,中国)","(name:it,Cina)","(name:is,\\"Alþýðulýðveldið Kína\\")","(name:id,Cina)","(name:hy,Չինաստան)","(name:hu,Kína)","(name:hr,Kina)","(name:he,סין)","(name:haw,Kina)","(name:gd,Sìona)","(name:ga,\\"An tSín\\")","(name:fy,Sina)","(name:fr,Chine)","(name:fi,Kiina)","(name:fa,چین)","(name:eu,Txina)","(name:et,Hiina)","(name:es,China)","(name:eo,Ĉinio)","(name:en,China)","(name:el,Κίνα)","(name:de,China)","(name:da,Kina)","(name:cy,Tsieina)","(name:ca,Xina)","(name:br,Sina)","(name:be,Кітай)","(name:ar,الصين)","(name:af,Sjina)","(name,\\"China 中国\\")"}	\N
jm	{"(name:zh,牙买加)","(name:uk,Ямайка)","(name:tr,Jamaika)","(name:th,ประเทศจาเมกา)","(name:sv,Jamaica)","(name:sl,Jamajka)","(name:ru,Ямайка)","(name:pl,Jamajka)","(name:mn,Ямайка)","(name:lv,Jamaika)","(name:lt,Jamaika)","(name:lb,Jamaika)","(name:la,Iamaica)","(name:ja,ジャマイカ)","(name:it,Giamaica)","(name:is,Jamaíka)","(name:id,Jamaika)","(name:hu,Jamaica)","(name:hr,Jamajka)","(name:he,ג'מייקה)","(name:gd,Iaimeuca)","(name:ga,Iamáice)","(name:fy,Jamaika)","(name:fr,Jamaïque)","(name:fi,Jamaika)","(name:fa,جامائیکا)","(name:eo,Jamajko)","(name:el,Τζαμάικα)","(name:de,Jamaika)","(name:br,Jamaika)","(name:be,Ямайка)","(name:ar,جامايكا)","(name:af,Jamaika)"}	\N
az	{"(official_name:vi,\\"Cộng hoà Azerbaijan\\")","(official_name:sv,\\"Republiken Azerbajdzjan\\")","(official_name:pt,\\"República do Azerbaijão\\")","(official_name:pl,\\"Republika Azerbejdżanu\\")","(official_name:lv,\\"Azerbaidžānas Republika\\")","(official_name:lt,\\"Azerbaidžano Respublika\\")","(official_name:it,\\"Repubblica dell'Azerbaigian\\")","(official_name:id,\\"Republik Azerbaijan\\")","(official_name:fi,\\"Azerbaidžanin tasavalta\\")","(official_name:fa,\\"جمهوری آذربایجان\\")","(official_name:el,\\"Δημοκρατία του Αζερμπαϊτζάν\\")","(official_name:az,\\"Azərbaycan Respublikası\\")","(official_name,\\"Republic of Azerbaijan\\")","(name:zh_pyt,Āsàibàijiāng)","(name:zh_py,Asaibaijiang)","(name:zh,阿塞拜疆)","(name:uk,Азербаджайн)","(name:tr,Azerbaycan)","(name:th,ประเทศอาเซอร์ไบจาน)","(name:sv,Azerbajdzjan)","(name:sl,Azerbajdžan)","(name:ru,Азербайджан)","(name:pt,Azerbaijão)","(name:pl,Azerbejdżan)","(name:no,Aserbajdsjan)","(name:nn,Aserbajdsjan)","(name:nl,Azerbeidzjan)","(name:nb,Aserbajdsjan)","(name:mn,Азербайжан)","(name:lv,Azerbaidžāna)","(name:lt,Azerbaidžanas)","(name:li,Azerbaidzjan)","(name:lb,Aserbaidschan)","(name:la,Adrabigania)","(name:ja,アゼルバイジャン)","(name:it,Azerbaigian)","(name:is,Aserbaídsjan)","(name:hy,Ադրբեջան)","(name:hu,Azerbajdzsán)","(name:hr,Azerbejdžan)","(name:he,אזרבייג'ן)","(name:haw,‘Akepaikana)","(name:gd,Asarbaidean)","(name:ga,\\"An Asarbaiseáin\\")","(name:fy,Azerbeidzjan)","(name:fr,Azerbaïdjan)","(name:fi,Azerbaidžan)","(name:fa,آذربایجان)","(name:et,Aserbaidžaan)","(name:es,Azerbaiyán)","(name:eo,Azerbajĝano)","(name:en,Azerbaijan)","(name:el,Αζερμπαϊτζάν)","(name:de,Aserbaidschan)","(name:da,Aserbajdsjan)","(name:ca,Azerbaidjan)","(name:br,Azerbaidjan)","(name:be,Азербайджан)","(name:az,Azərbaycan)","(name:ar,أذربيجان)","(name:af,Azerbeidjan)","(name,Azerbaijan)"}	\N
bo	{"(official_name:vi,\\"Cộng hoà Bolivia\\")","(official_name:sv,\\"Republiken Bolivia\\")","(official_name:qu,\\"Bulibiya Mama llaqta\\")","(official_name:pt,\\"Estado Plurinacional da Bolívia\\")","(official_name:pl,\\"Wielonarodowe Państwo Boliwii\\")","(official_name:lv,\\"Bolīvijas Republika\\")","(official_name:lt,\\"Bolivijos Respublika\\")","(official_name:id,\\"Republik Bolivia\\")","(official_name:gn,\\"Tetã Volívia\\")","(official_name:fr,\\"État plurinational de Bolivie\\")","(official_name:fi,\\"Bolivian monikansallinen valtio\\")","(official_name:en,\\"Plurinational State of Bolivia\\")","(official_name:el,\\"Πολυεθνοτικό Κράτος της Βολιβίας\\")","(official_name:be,\\"Рэспубліка Балівія\\")","(official_name:ay,\\"Wuliwya Suyu\\")","(official_name,\\"Estado Plurinacional de Bolivia\\")","(name:zh,玻利维亚)","(name:uk,Болівія)","(name:tr,Bolivya)","(name:th,ประเทศโบลิเวีย)","(name:sv,Bolivia)","(name:sl,Bolivija)","(name:ru,Боливия)","(name:pt,Bolívia)","(name:pl,Boliwia)","(name:mn,Болив)","(name:lv,Bolīvija)","(name:lt,Bolivija)","(name:lb,Bolivien)","(name:it,Bolivia)","(name:is,Bólivía)","(name:hu,Bolívia)","(name:he,בוליוויה)","(name:gd,Boilibhia)","(name:ga,\\"An Bholaiv\\")","(name:fr,Bolivie)","(name:fi,Bolivia)","(name:fa,بولیوی)","(name:et,Boliivia)","(name:eo,Bolivio)","(name:en,Bolivia)","(name:el,Βολιβία)","(name:de,Bolivien)","(name:da,Bolivia)","(name:cy,Bolifia)","(name:ca,Bolívia)","(name:br,Bolivia)","(name:be,Балівія)","(name:ar,بوليفيا)","(name,Bolivia)"}	\N
br	{"(official_name:vi,\\"Cộng hòa Liên bang Brasil\\")","(official_name:sv,\\"Förbundsrepubliken Brasilien\\")","(official_name:pl,\\"Federacyjna Republika Brazylii\\")","(official_name:lv,\\"Brazīlijas Federatīvā Republika\\")","(official_name:lt,\\"Brazilijos Federacinė Respublika\\")","(official_name:ja,ブラジル連邦共和国)","(official_name:id,\\"Republik Federal Brasil\\")","(official_name:fr,\\"République fédérative du Brésil\\")","(official_name:fi,\\"Brasilian liittotasavalta\\")","(official_name:es,\\"República Federativa del Brasil\\")","(official_name:en,\\"Federative Republic of Brazil\\")","(official_name:el,\\"Ομοσπονδιακή Δημοκρατία της Βραζιλίας\\")","(official_name,\\"República Federativa do Brasil\\")","(name:zh,巴西)","(name:uk,Бразилія)","(name:tr,Brezilya)","(name:th,ประเทศบราซิล)","(name:sv,Brasilien)","(name:sl,Brazilija)","(name:ru,Бразилия)","(name:pl,Brazylia)","(name:nl,Brazilië)","(name:mn,Бразил)","(name:lv,Brazīlija)","(name:lt,Brazilija)","(name:li,\\"'t Braziel\\")","(name:lb,Brasilien)","(name:la,Brasilia)","(name:ja,ブラジル)","(name:it,Brasile)","(name:is,Brasilía)","(name:hy,Բրազիլիա)","(name:hu,Brazília)","(name:hr,Brazil)","(name:he,ברזיל)","(name:gd,Braisil)","(name:ga,\\"An Bhrasaíl\\")","(name:fy,Brazylje)","(name:fr,Brésil)","(name:fi,Brasilia)","(name:fa,برزیل)","(name:et,Brasiilia)","(name:eo,Brzilo)","(name:en,Brazil)","(name:el,Βραζιλία)","(name:de,Brasilien)","(name:da,Brasilien)","(name:br,Brazil)","(name:be,Бразілія)","(name:ar,البرازيل)","(name:af,Brasilië)","(name,Brasil)"}	\N
bw	{"(official_name:vi,\\"Cộng hoà Botswana\\")","(official_name:sv,\\"Republiken Botswana\\")","(official_name:pt,\\"República do Botswana\\")","(official_name:lv,\\"Botsvānas Republika\\")","(official_name:lt,\\"Botsvanos Respublika\\")","(official_name:lb,\\"Republik vu Botswana\\")","(official_name:ja,ボツワナ共和国)","(official_name:id,\\"Republik Botswana\\")","(official_name:fi,\\"Botswanan tasavalta\\")","(official_name:el,\\"Δημοκρατία της Μποτσουάνας\\")","(official_name,\\"Republic of Botswana;Lefatse la Botswana\\")","(name:zh_pyt,Bócíwǎnà)","(name:zh_py,Bociwana)","(name:zh,博茨瓦纳)","(name:uk,Ботсвана)","(name:tr,Botsvana)","(name:tn,\\"Lefatshe la Botswana\\")","(name:th,ประเทศบอตสวานา)","(name:sv,Botswana)","(name:sl,Bocvana)","(name:ru,Ботсвана)","(name:pt,Botswana)","(name:pl,Botswana)","(name:mn,Ботсван)","(name:lv,Botsvāna)","(name:lt,Botsvana)","(name:la,Botsuana)","(name:ja,ボツワナ)","(name:it,Botswana)","(name:is,Botsvana)","(name:hu,Botswana)","(name:hr,Bocvana)","(name:he,בוטסוונה)","(name:haw,Botuana)","(name:gd,Botsuana)","(name:ga,\\"An Bhotsuáin\\")","(name:fr,Botswana)","(name:fi,Botswana)","(name:fa,بوتسوانا)","(name:es,Botsuana)","(name:eo,Bocvano)","(name:en,Botswana)","(name:el,Μποτσουάνα)","(name:de,Botsuana)","(name:br,Botswana)","(name:be,Батсвана)","(name:ar,بوتسوانا)","(name,Botswana)"}	\N
ca	{"(name:zh_pyt,Jiānádà)","(name:zh_py,Jianada)","(name:zh,加拿大)","(name:uk,Канада)","(name:tr,Kanada)","(name:th,ประเทศแคนาดา)","(name:sv,Kanada)","(name:sl,Kanada)","(name:ru,Канада)","(name:pt,Canadá)","(name:pl,Kanada)","(name:mn,Канад)","(name:lv,Kanāda)","(name:lt,Kanada)","(name:lb,Kanada)","(name:ja,カナダ)","(name:it,Canada)","(name:is,Kanada)","(name:id,Kanada)","(name:hy,Կանադա)","(name:hu,Kanada)","(name:hr,Kanada)","(name:he,קנדה)","(name:ga,Ceanada)","(name:fy,Kanada)","(name:fr,Canada)","(name:fi,Kanada)","(name:fa,کانادا)","(name:eu,Kanada)","(name:es,Canadá)","(name:eo,Kanado)","(name:en,Canada)","(name:el,Καναδάς)","(name:de,Kanada)","(name:ca,Canadà)","(name:br,Kanada)","(name:be,Канада)","(name:ar,كندا)","(name:af,Kanada)","(name,Canada)"}	\N
cc	{"(official_name:pl,\\"Terytorium Wysp Kokosowych (Keelinga)\\")","(official_name:lv,\\"Kokosu (Kīlinga) salu teritorija\\")","(official_name:es,\\"Territorio de las Islas Cocos (Keeling)\\")","(official_name,\\"Territory of the Cocos (Keeling) Islands\\")","(name:zh,科科斯（基林）群島)","(name:vi,\\"Quần đảo Cocos (Keeling)\\")","(name:uk,\\"Кокосові острови\\")","(name:tr,\\"Cocos (Keeling) Adaları\\")","(name:sv,Kokosöarna)","(name:sl,\\"Kokosovi otoki\\")","(name:ru,\\"Кокосовые острова\\")","(name:pl,\\"Wyspy Kokosowe\\")","(name:nl,Cocoseilanden)","(name:mn,\\"Кокосын (Кийлингийн) Арлууд\\")","(name:lv,\\"Kokosu (Kīlinga) salas\\")","(name:lt,\\"Kokoso (Keelingo) salos\\")","(name:it,\\"Isole Cocos e Keeling\\")","(name:is,Kókoseyjar)","(name:id,\\"Kepulauan Cocos (Keeling)\\")","(name:hu,\\"Kókusz (Keeling)-szigetek\\")","(name:hr,\\"Kokosovi otoci\\")","(name:he,\\"איי קוקוס (קילינג)\\")","(name:fy,\\"de Kokoseilannen\\")","(name:fr,\\"Îles Cocos\\")","(name:fi,Kookossaaret)","(name:fa,\\"جزایر کوکوس\\")","(name:eu,\\"Cocos (Keeling) uharteak\\")","(name:et,Kookossaared)","(name:es,\\"Islas Cocos (Keeling)\\")","(name:eo,Kokosinsuloj)","(name:en,\\"Cocos (Keeling) Islands\\")","(name:el,\\"Νησιά Κόκος\\")","(name:de,Kokosinseln)","(name:da,Cocosøerne)","(name:ca,\\"Illes Cocos\\")","(name:br,\\"Inizi Kokoz\\")","(name:be,\\"Какосавыя (Кілінг) астравы\\")","(name:ar,\\"جزر كوكوس (كيلينغ)\\")","(name:af,\\"Cocos (Keeling) Eilande\\")","(name,\\"Cocos (Keeling) Islands\\")"}	\N
cz	{"(official_name:sv,\\"Republiken Tjeckien\\")","(official_name:sk,\\"Česká republika\\")","(official_name:ru,\\"Чешская Республика\\")","(official_name:pt,\\"República Checa\\")","(official_name:pl,\\"Republika Czeska\\")","(official_name:lv,\\"Čehijas Republika\\")","(official_name:lt,\\"Čekijos Respublika\\")","(official_name:lb,\\"Tschechesch Republik\\")","(official_name:la,\\"Res publica Bohemica\\")","(official_name:ja,チェコ共和国)","(official_name:it,\\"Repubblica Ceca\\")","(official_name:el,\\"Τσεχική Δημοκρατία\\")","(name:zh_pyt,Jiékè)","(name:zh_py,Jieke)","(name:zh,捷克)","(name:vi,\\"Cộng hòa Séc\\")","(name:uk,\\"Чеська Республіка\\")","(name:tr,\\"Çek Cumhuriyeti\\")","(name:th,สาธารณรัฐเช็ก)","(name:sv,Tjeckien)","(name:sl,Češka)","(name:sk,Česko)","(name:ru,Чехия)","(name:pt,\\"República Checa\\")","(name:pl,Czechy)","(name:nl,Tsjechië)","(name:mn,\\"Бүгд Найрамдах Чех Улс\\")","(name:lv,Čehija)","(name:lt,Čekija)","(name:li,Tsjechië)","(name:lb,Tschechien)","(name:la,Bohemia)","(name:ja,チェコ)","(name:it,Cechia)","(name:is,Tékkland)","(name:id,\\"Republik Ceko\\")","(name:hu,Csehország)","(name:hr,Češka)","(name:he,צכיה)","(name:haw,\\"Lepupalika ‘o Tieka\\")","(name:gd,\\"An t-Seic\\")","(name:ga,\\"Poblacht na Seice\\")","(name:fy,Tsjechje)","(name:fr,\\"République tchèque\\")","(name:fi,Tšekki)","(name:fa,\\"جمهوری چک\\")","(name:eu,\\"Txekiar Errepublika\\")","(name:et,Tšehhi)","(name:es,\\"República Checa\\")","(name:eo,Ĉeĥio)","(name:en,\\"Czech Republic\\")","(name:el,Τσεχία)","(name:de,Tschechien)","(name:da,Tjekkiet)","(name:cy,\\"Gweriniaeth Tsiec\\")","(name:cs,\\"Česká republika\\")","(name:ca,\\"República Txeca\\")","(name:br,\\"Republik Tchek\\")","(name:be,Чэхія)","(name:ar,\\"الجمهورية التشيكية\\")","(name:af,Tsjeggië)","(name,\\"Česká republika\\")"}	\N
fj	{"(official_name:vi,\\"Cộng hòa Quần đảo Fiji\\")","(official_name:sv,\\"Republiken Fijiöarna\\")","(official_name:ru,\\"Республика Островов Фиджи\\")","(official_name:pt,\\"República das Ilhas Fiji\\")","(official_name:pl,\\"Republika Wysp Fidżi\\")","(official_name:lv,\\"Fidži Republika\\")","(official_name:lt,\\"Fidžio Salų Respublika\\")","(official_name:ja,フィジー諸島共和国)","(official_name:id,\\"Republik Kepulauan Fiji\\")","(official_name:fr,\\"République des îles Fidji\\")","(official_name:es,\\"República de las Islas Fiyi\\")","(official_name:en,\\"Republic of the Fiji Islands\\")","(official_name:be,Фіджы)","(official_name,\\"Matanitu Tu-Vaka-i-koya ko Viti\\")","(name:zh,斐济岛)","(name:uk,Фіджі)","(name:th,ประเทศฟิจิ)","(name:sv,Fiji)","(name:sq,Fixhi)","(name:sl,Fidži)","(name:ru,Фиджи)","(name:pt,Fiji)","(name:pl,Fidżi)","(name:mn,Фижи)","(name:lv,Fidži)","(name:lt,Fidžis)","(name:li,Fidzji-eilen)","(name:lb,Fidschi)","(name:la,Viti)","(name:ja,フィジー)","(name:it,Figi)","(name:is,Fídjieyjar)","(name:hu,Fidzsi-szigetek)","(name:hr,Fidži)","(name:he,פיג'י)","(name:gd,Fìdi)","(name:ga,Fidsí)","(name:fy,Fidzjy)","(name:fr,Fidji)","(name:fi,Fidži)","(name:fa,فیجی)","(name:et,Fidži)","(name:es,Fiyi)","(name:eo,Fiĝioj)","(name:en,Fiji)","(name:el,Φίτζι)","(name:de,Fidschi)","(name:br,Fidji)","(name:be,Фіджы)","(name:ar,فيجي)","(name:af,Fidji)","(name,Fiji)"}	\N
ee	{"(official_name:vi,\\"Cộng hòa Estonia\\")","(official_name:sv,\\"Republiken Estland\\")","(official_name:sk,\\"Estónska republika\\")","(official_name:ru,\\"Эсто́нская Респу́блика\\")","(official_name:pl,\\"Republika Estońska\\")","(official_name:lv,\\"Igaunijas Republika\\")","(official_name:lt,\\"Estijos Respublika\\")","(official_name:lb,\\"Republik Estland\\")","(official_name:id,\\"Republik Estonia\\")","(official_name:gd,\\"Poblachd Eastòinia\\")","(official_name:fr,\\"République d'Estonie\\")","(official_name:es,\\"República de Estonia\\")","(official_name:en,\\"Republic of Estonia\\")","(official_name:el,\\"Δημοκρατία της Εσθονίας\\")","(official_name:be,\\"Рэспубліка Эстонія\\")","(official_name,\\"Eesti Vabariik\\")","(name:zh_pyt,Àishāníyà)","(name:zh_py,Aishaniya)","(name:zh,爱沙尼亚)","(name:vi,Estonia)","(name:uk,Естонія)","(name:tr,Estonya)","(name:th,ประเทศเอสโตเนีย)","(name:sv,Estland)","(name:sl,Estonija)","(name:sk,Estónsko)","(name:ru,Эстония)","(name:pl,Estonia)","(name:nl,Estland)","(name:mn,Эстон)","(name:lv,Igaunija)","(name:lt,Estija)","(name:li,Esland)","(name:lb,Estland)","(name:la,Estonia)","(name:ja,エストニア)","(name:it,Estonia)","(name:is,Eistland)","(name:id,Estonia)","(name:hu,Észtország)","(name:hr,Estonija)","(name:he,אסטוניה)","(name:haw,‘Esetonia)","(name:gd,Eastòinia)","(name:ga,\\"An Eastóin\\")","(name:fy,Estlân)","(name:fr,Estonie)","(name:fi,Viro)","(name:fa,استونی)","(name:eu,Estonia)","(name:es,Estonia)","(name:eo,Estonio)","(name:en,Estonia)","(name:el,Εσθονία)","(name:de,Estland)","(name:da,Estland)","(name:cy,Estonia)","(name:ca,Estònia)","(name:br,Estonia)","(name:be,Эстонія)","(name:ar,إستونيا)","(name:af,Estland)","(name,Eesti)"}	\N
gh	{"(official_name:vi,\\"Cộng hòa Ghana\\")","(official_name:sv,\\"Republiken Ghana\\")","(official_name:pt,\\"República do Gana\\")","(official_name:lv,\\"Ganas Republika\\")","(official_name:lt,\\"Ganos Respublika\\")","(official_name:id,\\"Republik Ghana\\")","(official_name:gd,\\"Poblachd Ghàna\\")","(official_name:el,\\"Δημοκρατία της Γκάνας\\")","(official_name:be,\\"Рэспубліка Гана\\")","(official_name,\\"Republic of Ghana\\")","(name:zh_pyt,Jiānà)","(name:zh_py,Jiana)","(name:zh,加纳)","(name:uk,Ґана)","(name:tr,Gana)","(name:th,ประเทศกานา)","(name:sv,Ghana)","(name:sl,Gana)","(name:ru,Гана)","(name:pt,Gana)","(name:pl,Ghana)","(name:mn,Гана)","(name:lv,Gana)","(name:lt,Gana)","(name:li,Gana)","(name:la,Gana)","(name:ja,ガーナ)","(name:it,Ghana)","(name:is,Gana)","(name:hu,Ghána)","(name:hr,Gana)","(name:he,גאנה)","(name:haw,Gāna)","(name:gd,Gàna)","(name:ga,Gána)","(name:fy,Gana)","(name:fr,Ghana)","(name:fi,Ghana)","(name:fa,غنا)","(name:es,Ghana)","(name:eo,Ganao)","(name:en,Ghana)","(name:el,Γκάνα)","(name:da,Ghana)","(name:br,Ghana)","(name:be,Гана)","(name:ar,غانا)","(name,Ghana)"}	\N
ke	{"(official_name:vi,\\"Cộng hòa Kenya\\")","(official_name:sv,\\"Republiken Kenya\\")","(official_name:lv,\\"Kenijas Republika\\")","(official_name:lt,\\"Kenijos Respublika\\")","(official_name:lb,\\"Republik Kenia\\")","(official_name:ja,ケニア共和国)","(official_name:id,\\"Republik Kenya\\")","(official_name:el,\\"Δημοκρατία της Κένυας\\")","(official_name,\\"Republic of Kenya;Jamhuri ya Kenya\\")","(name:zh_pyt,Kěnníyà)","(name:zh_py,Kenniya)","(name:zh,肯尼亚)","(name:uk,Кенія)","(name:th,ประเทศเคนยา)","(name:sv,Kenya)","(name:sl,Kenija)","(name:ru,Кения)","(name:pl,Kenia)","(name:nl,Kenia)","(name:mn,Кени)","(name:lv,Kenija)","(name:lt,Kenija)","(name:li,Kenia)","(name:la,Kenia)","(name:ja,ケニア)","(name:it,Kenya)","(name:is,Kenýa)","(name:hu,Kenya)","(name:hr,Kenija)","(name:he,קניה)","(name:haw,Kenia)","(name:gd,\\"A' Cheinia\\")","(name:ga,\\"An Chéinia\\")","(name:fr,Kenya)","(name:fi,Kenia)","(name:fa,کنیا)","(name:es,Kenia)","(name:eo,Kenjo)","(name:en,Kenya)","(name:el,Κένυα)","(name:de,Kenia)","(name:br,Kenya)","(name:be,Кенія)","(name:ar,كينيا)","(name:af,Kenia)","(name,Kenya)"}	\N
kw	{"(official_name:sv,\\"Staten Kuwait\\")","(official_name:pl,\\"Państwo Kuwejt\\")","(official_name:lv,\\"Kuveitas Valsts\\")","(official_name:lt,\\"Kuveito Valstybė\\")","(official_name:it,\\"Stato del Kuwait\\")","(official_name:et,\\"Kuveidi Riik\\")","(official_name:en,\\"State of Kuwait\\")","(official_name:el,\\"Κράτος του Κουβέιτ\\")","(official_name:br,\\"Stad Koweit\\")","(official_name,\\"State of Kuwait\\")","(name:zh_pyt,Kēwēitè)","(name:zh_py,Keweite)","(name:zh-min-nan,Kuwait)","(name:zh-classical,科威特)","(name:zh,科威特)","(name:wuu,科威特)","(name:wo,Kowet)","(name:war,Kuwait)","(name:vo,Kovätän)","(name:vi,Kuwait)","(name:uz,Quvayt)","(name:ur,کویت)","(name:uk,Кувейт)","(name:ug,كۇۋەيت)","(name:udm,Кувейт)","(name:tt,Күвәйт)","(name:tr,Kuveyt)","(name:tl,Kuwait)","(name:th,ประเทศคูเวต)","(name:tg,Кувайт)","(name:te,కువైట్)","(name:ta,குவைத்)","(name:szl,Kuwejt)","(name:sw,Kuwait)","(name:sv,Kuwait)","(name:sr,Кувајт)","(name:sq,Kuvajti)","(name:sl,Kuvajt)","(name:sk,Kuvajt)","(name:simple,Kuwait)","(name:sh,Kuvajt)","(name:se,Kuwait)","(name:scn,Kuwait)","(name:sah,Кувейт)","(name:sa,कुवैत)","(name:ru,Кувейт)","(name:ro,Kuweit)","(name:qu,Kuwait)","(name:pt,Kuwait)","(name:pms,Kuwait)","(name:pl,Kuwejt)","(name:pam,Kuwait)","(name:os,Кувейт)","(name:oc,Kowait)","(name:nov,Kuwayt)","(name:no,Kuwait)","(name:nn,Kuwait)","(name:nl,Koeweit)","(name:nds,Kuwait)","(name:nah,Cuhuait)","(name:ms,Kuwait)","(name:mr,कुवैत)","(name:mn,Кувейт)","(name:ml,കുവൈറ്റ്‌)","(name:mk,Кувајт)","(name:lv,Kuveita)","(name:lt,Kuveitas)","(name:lmo,Kuwait)","(name:lij,Kuwait)","(name:li,Koeweit)","(name:la,Cuvaitum)","(name:kw,Kuwait)","(name:kv,Кувейт)","(name:ku,Kuweyt)","(name:ko,쿠웨이트)","(name:kn,ಕುವೈತ್)","(name:km,គុយវ៉ែត)","(name:kk,Кувейт)","(name:ka,ქუვეითი)","(name:jv,Kuwait)","(name:ja,クウェート)","(name:it,Kuwait)","(name:is,Kúveit)","(name:io,Kuwait)","(name:ilo,Kuwait)","(name:ie,Kuwait)","(name:id,Kuwait)","(name:ia,Kuwait)","(name:hu,Kuvait)","(name:ht,Kowet)","(name:hsb,Kuwait)","(name:hr,Kuvajt)","(name:hif,Kuwait)","(name:hi,कुवैत)","(name:he,כווית)","(name:haw,Kuete)","(name:hak,Khô-vî-thi̍t)","(name:gv,\\"Yn Choowait\\")","(name:gd,Cubhait)","(name:ga,Cuáit)","(name:fy,Koeweit)","(name:frp,Koveyit)","(name:fr,Koweït)","(name:fo,Kuveit)","(name:fiu-vro,Kuveit)","(name:fi,Kuwait)","(name:fa,کویت)","(name:eu,Kuwait)","(name:et,Kuveit)","(name:eo,Kuvajto)","(name:en,Kuwait)","(name:el,Κουβέιτ)","(name:dz,ཀུ་ཝེཊ་)","(name:dv,ކުވެއިތު)","(name:dsb,Kuwait)","(name:de,Kuwait)","(name:cv,Кувейт)","(name:cs,Kuvajt)","(name:crh,Küveyt)","(name:ceb,Kuwait)","(name:ca,Kuwait)","(name:bs,Kuvajt)","(name:br,Koweit)","(name:bpy,কুয়েত)","(name:bn,কুয়েত)","(name:bg,Кувейт)","(name:be-x-old,Кувэйт)","(name:be,Кувейт)","(name:bcl,Kuwait)","(name:bat-smg,Kovėits)","(name:az,Küveyt)","(name:ast,Kuwait)","(name:arz,الكويت)","(name:arc,ܟܘܝܬ)","(name:ar,الكويت)","(name:ang,Cuwait)","(name:an,Kuwait)","(name:als,Kuwait)","(name:af,Koeweit)","(name:ace,Kuwait)","(name,\\"Kuwait / الكويت\\")"}	\N
ms	{"(name:zh,蒙特塞拉特)","(name:uk,Монтсеррат)","(name:th,มอนต์เซอร์รัต)","(name:sv,Montserrat)","(name:ru,Монтсеррат)","(name:pl,Montserrat)","(name:mn,Монтсеррат)","(name:lv,Montserrata)","(name:lt,Montseratas)","(name:it,Montserrat)","(name:is,Montserrat)","(name:hu,Montserrat)","(name:he,מונטסראט)","(name:ga,Montsarat)","(name:fr,Montserrat)","(name:fi,Montserrat)","(name:fa,مونتسرات)","(name:es,Montserrat)","(name:eo,Moncerato)","(name:en,Montserrat)","(name:da,Montserrat)","(name:br,Montserrat)","(name:be,Мансерат)","(name:ar,مونتسرات)","(name,Montserrat)"}	\N
pn	{"(official_name:lv,\\"Pitkērnas salas\\")","(official_name,\\"Pitcairn, Henderson, Ducie, and Oeno Islands;Pitkern Ailen\\")","(name:zh,皮特凯恩群岛)","(name:vi,\\"Quần đảo Pitcairn\\")","(name:uk,Піткерн)","(name:tr,\\"Pitcairn Adaları\\")","(name:th,หมู่เกาะพิตแคร์น)","(name:sv,Pitcairnöarna)","(name:ru,Питкерн)","(name:pl,\\"Wyspy Pitcairn\\")","(name:mn,\\"Питкэрн Арлууд\\")","(name:lv,Pitkērna)","(name:lt,Pitkernas)","(name:la,\\"Pitcairn Insulae\\")","(name:it,\\"Isole Pitcairn\\")","(name:is,Pitcairn)","(name:id,\\"Kepulauan Pitcairn\\")","(name:hu,Pitcairn-szigetek)","(name:he,פיטקרן)","(name:gd,\\"Eilean Pitcairn\\")","(name:ga,\\"Oileán Pitcairn\\")","(name:fy,\\"de Pitcairneilannen\\")","(name:fr,\\"Îles Pitcairn\\")","(name:fi,Pitcairn)","(name:fa,پیت‌کرن)","(name:es,\\"Islas Pitcairn\\")","(name:eo,\\"Pitkarna Insulo\\")","(name:en,Pitcairn)","(name:el,\\"Νήσοι Πίτκαιρν\\")","(name:da,Pitcairn)","(name:cy,\\"Ynysoedd Pitcairn\\")","(name:ca,\\"Illes Pitcairn\\")","(name:br,\\"Inizi Pitcairn\\")","(name:be,Піткерн)","(name:ar,بتكايرن)","(name,Pitcairn)"}	\N
sl	{"(official_name:vi,\\"Cộng hòa Sierra Leone\\")","(official_name:sv,\\"Republiken Sierra Leone\\")","(official_name:pt,\\"República da Serra Leoa\\")","(official_name:lt,\\"Siera Leonės Respublika\\")","(official_name:id,\\"Republik Sierra Leone\\")","(official_name:gd,\\"Poblachd Shiarra Leòmhann\\")","(official_name:el,\\"Δημοκρατία της Σιέρα Λεόνε\\")","(official_name:be,\\"Рэспубліка С’ера-Леоне \\")","(official_name,\\"Republic of Sierra Leone\\")","(name:zh_pyt,Sàilālì'áng)","(name:zh_py,Sailali'ang)","(name:zh,塞拉利昂)","(name:uk,Сьєрра-Леоне)","(name:th,ประเทศเซียร์ราลีโอน)","(name:sv,\\"Sierra Leone\\")","(name:ru,Сьерра-Леоне)","(name:pt,\\"Serra Leoa\\")","(name:pl,\\"Sierra Leone\\")","(name:mn,Сьерра-Леоне)","(name:lt,\\"Siera Leonė\\")","(name:la,\\"Mons Leoninus\\")","(name:it,\\"Sierra Leone\\")","(name:is,\\"Síerra Leóne\\")","(name:hu,\\"Sierra Leone\\")","(name:he,\\"סיארה ליאון\\")","(name:gd,\\"Siarra Leòmhann\\")","(name:ga,\\"Siarra Leon\\")","(name:fy,\\"Sierra Leöane\\")","(name:fr,\\"Sierra Leone\\")","(name:fi,\\"Sierra Leone\\")","(name:fa,سیرالئون)","(name:es,\\"Sierra Leona\\")","(name:eo,Siera-Leono)","(name:en,\\"Sierra Leone\\")","(name:el,\\"Σιέρα Λεόνε\\")","(name:da,\\"Sierra Leone\\")","(name:br,\\"Sierra Leone\\")","(name:be,\\"С’ера-Леоне \\")","(name:ar,سيراليون)","(name,\\"Sierra Leone\\")"}	\N
in	{"(official_name:sv,\\"Republiken Indien\\")","(official_name:pl,\\"Republika Indii\\")","(official_name:lv,\\"Indijas Republika\\")","(official_name:lt,\\"Indijos Respublika\\")","(official_name:lb,\\"Republik Indien\\")","(official_name:it,\\"Repubblica dell'India\\")","(official_name:id,\\"Republik India\\")","(official_name:hi,\\"भारत गणराज्य\\")","(official_name:fr,\\"République de l'Inde\\")","(official_name:en,\\"Republic of India\\")","(official_name:el,\\"Δημοκρατία της Ινδίας\\")","(official_name,\\"भारत गणराज्य\\")","(name:zh_pyt,Yìndù)","(name:zh_py,Yindu)","(name:zh,印度)","(name:vi,\\"Ấn Độ\\")","(name:uk,Індія)","(name:tr,Hindistan)","(name:th,ประเทศอินเดีย)","(name:sv,Indien)","(name:sl,Indija)","(name:ru,Индия)","(name:pl,Indie)","(name:mn,Энэтхэг)","(name:lv,Indija)","(name:lt,Indija)","(name:lb,Indien)","(name:ja,インド)","(name:iu,ᐃᓐᑎᐊ/intia)","(name:it,India)","(name:is,Indland)","(name:hu,India)","(name:hi,भारत)","(name:he,הודו)","(name:haw,‘Īnia)","(name:gd,\\"Na h-Innseachan\\")","(name:ga,\\"An India\\")","(name:fy,Yndia)","(name:fr,Inde)","(name:fi,Intia)","(name:fa,هند)","(name:eo,Barato)","(name:en,India)","(name:el,Ινδία)","(name:de,Indien)","(name:da,Indien)","(name:br,India)","(name:be,Індыя)","(name:ar,الهند)","(name:af,Indië)","(name,India)"}	\N
tf	{"(name:zh,法属南部领地)","(name:vi,\\"Vùng đất phía Nam và châu Nam Cực thuộc Pháp\\")","(name:uk,\\"Французькі Південні та Антарктичні території\\")","(name:tr,\\"Fransız Güney ve Antarktika Toprakları\\")","(name:ta,\\"பிரெஞ்சு தென்னக நிலங்களும் அண்டாடிக் நிலமும்\\")","(name:sv,\\"Franska sydterritorierna\\")","(name:sr,\\"Француске јужне и антарктичке земље\\")","(name:sl,\\"Francoske južne in antarktične dežele\\")","(name:sk,\\"Francúzske južné a antarktické územia\\")","(name:sh,\\"Francuske Južne Teritorije\\")","(name:ru,\\"Французские Южные и Антарктические территории\\")","(name:ro,\\"Teritoriile australe şi antarctice franceze\\")","(name:pt,\\"Terras Austrais e Antárticas Francesas\\")","(name:pl,\\"Francuskie Terytoria Południowe i Antarktyczne\\")","(name:oc,\\"Tèrras Australas e Antarticas Francesas\\")","(name:no,\\"De franske sørterritorier\\")","(name:nl,\\"Franse Zuidelijke en Antarctische Gebieden\\")","(name:lv,\\"Francijas Dienvidjūru un Antarktikas Zemes\\")","(name:lt,\\"Prancūzijos Pietų Sritys\\")","(name:lij,\\"Tæritöi Françèisi Meridionâ e dell'Antartigo\\")","(name:kw,\\"Tiryow Deghow hag Antarktik Frynkek\\")","(name:ko,\\"프랑스령 남부와 남극 지역\\")","(name:ja,フランス領南方・南極地域)","(name:it,\\"Terre Australi e Antartiche Francesi\\")","(name:is,\\"Frönsku suðlægu landsvæðin\\")","(name:id,\\"Daratan Selatan dan Antarktika Perancis\\")","(name:hu,\\"Francia déli és antarktiszi területek\\")","(name:hr,\\"Francuski južni i antarktički teritoriji\\")","(name:gl,\\"Terras Austrais e Antárticas Francesas\\")","(name:fy,\\"Frânske Súdlike en Antarktyske Lannen\\")","(name:fr,\\"Terres australes et antarctiques françaises\\")","(name:fi,\\"Ranskan eteläiset ja antarktiset alueet\\")","(name:eu,\\"Frantziaren lurralde austral eta antartikoak\\")","(name:es,\\"Tierras Australes y Antárticas Francesas\\")","(name:eo,\\"Francaj Sudaj Teritorioj\\")","(name:en,\\"French Southern Lands\\")","(name:el,\\"Γαλλικά νότια και ανταρκτικά εδάφη\\")","(name:de,\\"Französische Süd- und Antarktisgebiete\\")","(name:da,\\"Franske sydlige og Antarktiske territorier\\")","(name:cs,\\"Francouzská jižní a antarktická území\\")","(name:ca,\\"Terres Australs i Antàrtiques Franceses\\")","(name:br,\\"Douaroù Aostral hag Antarktikel Frañs\\")","(name:bg,\\"Френски южни и антарктически територии\\")","(name:be-x-old,\\"Францускія Паўднёвыя Тэрыторыі\\")","(name:be,\\"Французскія Паўднёвыя тэрыторыі\\")","(name:ar,\\"الأراضي الجنوبية الفرنسية\\")","(name:an,\\"Territorios Australs Franzeses\\")","(name:af,\\"Franse Suidelike en Antarktiese Gebiede\\")","(name,\\"Terres australes et antarctiques françaises\\")"}	\N
tj	{"(official_name:vi,\\"Cộng hòa Tajikistan\\")","(official_name:sv,\\"Republiken Tadzjikistan\\")","(official_name:pt,\\"República do Tadjiquistão\\")","(official_name:pl,\\"Republika Tadżykistanu\\")","(official_name:lt,\\"Tadžikistano Respublika\\")","(official_name:it,\\"Repubblica del Tagikistan\\")","(official_name:id,\\"Republik Tajikistan\\")","(official_name:gd,\\"Poblachd Thaidigeastàn\\")","(official_name:et,\\"Tadžikistani Vabariik\\")","(official_name:el,\\"Δημοκρατία του Τατζικιστάν\\")","(name:zh_pyt,Tǎjíkèsītǎn)","(name:zh_py,Tajikesitan)","(name:zh,塔吉克斯坦)","(name:uk,Таджикистан)","(name:tr,Tacikistan)","(name:th,ประเทศทาจิกิสถาน)","(name:tg,Тоҷикистон)","(name:sv,Tadzjikistan)","(name:sl,Tadžikistan)","(name:ru,Таджикистан)","(name:pt,Tadjiquistão)","(name:pl,Tadżykistan)","(name:nl,Tadzjikistan)","(name:mn,Тажикистан)","(name:lv,Tadžikistāna)","(name:lt,Tadžikistanas)","(name:li,Tadzjikistan)","(name:lb,Tadschikistan)","(name:la,Tadzikistania)","(name:it,Tagikistan)","(name:is,Tadsjikistan)","(name:hu,Tádzsikisztán)","(name:hr,Tadžikistan)","(name:he,טג'יקיסטן)","(name:gd,Taidigeastàn)","(name:ga,\\"An Táidsíceastáin\\")","(name:fy,Tadzjikistan)","(name:fr,Tadjikistan)","(name:fi,Tadžikistan)","(name:fa,تاجیکستان)","(name:et,Tadžikistan)","(name:es,Tayikistán)","(name:eo,Taĝikio)","(name:en,Tajikistan)","(name:el,Τατζικιστάν)","(name:de,Tadschikistan)","(name:da,Tadsjikistan)","(name:ca,Tadjikistan)","(name:br,Tadjikistan)","(name:be,Таджыкістан)","(name:az,Tacikistan)","(name:ar,طاجيكستان)","(name:af,Tadjikistan)","(name,Tajikistan)"}	\N
tz	{"(official_name:vi,\\"Cộng hòa Thống nhất Tanzania\\")","(official_name:sv,\\"Förenade republiken Tanzania\\")","(official_name:pt,\\"República Unida da Tanzânia\\")","(official_name:lt,\\"Tanzanijos Jungtinė Respublika\\")","(official_name:lb,\\"Vereenegt Republik Tansania\\")","(official_name:id,\\"Persatuan Republik Tanzania\\")","(official_name:et,\\"Tansaania Ühendvabariik\\")","(official_name,\\"United Republic of Tanzania;Jamhuri Ya Muungano Wa Tanzania\\")","(name:zh_pyt,Tǎnsāngníyà)","(name:zh_py,Tansangniya)","(name:zh,坦桑尼亚)","(name:uk,Танзанія)","(name:tr,Tanzanya)","(name:th,ประเทศแทนซาเนีย)","(name:sv,Tanzania)","(name:sl,Tanzanija)","(name:ru,Танзания)","(name:pt,Tanzânia)","(name:pl,Tanzania)","(name:mn,Танзани)","(name:lv,Tanzānija)","(name:lt,Tanzanija)","(name:lb,Tansania)","(name:ja,タンザニア)","(name:it,Tanzania)","(name:is,Tansanía)","(name:hu,Tanzánia)","(name:hr,Tanzanija)","(name:he,טנזניה)","(name:haw,Tanazania)","(name:gd,Tansainìa)","(name:ga,\\"An Tansáin\\")","(name:fr,Tanzanie)","(name:fi,Tansania)","(name:fa,تانزانیا)","(name:et,Tansaania)","(name:es,Tanzania)","(name:eo,Tanzanio)","(name:en,Tanzania)","(name:el,Τανζανία)","(name:de,Tansania)","(name:ca,Tanzània)","(name:br,Tanzania)","(name:be,Танзанія)","(name:ar,تنـزاني)","(name:af,Tanzanië)","(name,Tanzania)"}	\N
ws	{"(official_name:vi,\\"Nhà nước Độc lập Samoa\\")","(official_name:sv,\\"Självständiga staten Samoa\\")","(official_name:ru,\\"Независимое Государство Самоа\\")","(official_name:pl,\\"Niezależne Państwo Samoa\\")","(official_name:lt,\\"Samoa Nepriklausomoji Valstybė\\")","(official_name:lb,\\"Unabhängiger Stat Samoa\\")","(official_name:es,\\"Estado Independiente de Samoa\\")","(official_name:en,\\"Independent State of Samoa\\")","(official_name,\\"Malo Sa'oloto Tuto'atasi o Samoa\\")","(name:zh,萨摩亚)","(name:uk,Самоа)","(name:th,ประเทศซามัว)","(name:sv,Samoa)","(name:ru,Самоа)","(name:pl,Samoa)","(name:mn,Самоа)","(name:is,Samóa)","(name:hu,Szamoa)","(name:he,סמואה)","(name:ga,Samó)","(name:fr,Samoa)","(name:fi,Samoa)","(name:fa,ساموآ)","(name:eo,Samoo)","(name:en,Samoa)","(name:el,Σαμόα)","(name:da,Samoa)","(name:br,Samoa)","(name:be,Самоа)","(name:ar,ساموا)","(name,Samoa)"}	\N
co	{"(official_name:vi,\\"Cộng hoà Colombia\\")","(official_name:sv,\\"Republiken Colombia\\")","(official_name:pl,\\"Republika Kolumbii\\")","(official_name:lt,\\"Kolumbijos Respublika\\")","(official_name:id,\\"Republik Kolombia\\")","(official_name:fr,\\"République de Colombie\\")","(official_name:en,\\"Republic of Colombia\\")","(official_name:el,\\"Δημοκρατία της Κολομβίας\\")","(official_name:be,\\"Рэспубліка Калумбія\\")","(official_name,\\"República de Colombia\\")","(name:zh,哥伦比亚)","(name:uk,Колумбія)","(name:tr,Kolombiya)","(name:th,ประเทศโคลอมเบีย)","(name:sv,Colombia)","(name:sl,Kolumbija)","(name:ru,Колумбия)","(name:pt,Colômbia)","(name:pl,Kolumbia)","(name:mn,Колумб)","(name:lv,Kolumbija)","(name:lt,Kolumbija)","(name:lb,Kolumbien)","(name:la,Columbia)","(name:ja,コロンビア)","(name:it,Colombia)","(name:is,Kólumbía)","(name:id,Kolombia)","(name:hr,Kolumbija)","(name:he,קולומביה)","(name:ga,\\"An Cholóim\\")","(name:fy,Kolombia)","(name:fr,Colombie)","(name:fi,Kolumbia)","(name:fa,کلمبیا)","(name:eu,Kolonbia)","(name:eo,Kolombio)","(name:en,Colombia)","(name:el,Κολομβία)","(name:de,Kolumbien)","(name:da,Colombia)","(name:ca,Colòmbia)","(name:br,Kolombia)","(name:be,Калумбія)","(name:ar,كولومبيا)","(name,Colombia)"}	\N
ci	{"(official_name:vi,\\"Cộng hòa Côte d'Ivoire\\")","(official_name:sv,\\"Republiken Elfenbenskusten\\")","(official_name:pt,\\"República da Costa do Marfim\\")","(official_name:lv,\\"Kotdivuāras Republika\\")","(official_name:lt,\\"Dramblio Kaulo Kranto Respublika\\")","(official_name:en,\\"Republic of Côte d'Ivoire\\")","(official_name:el,\\"Δημοκρατία της Ακτής Ελεφαντοστού\\")","(official_name:be,\\"Рэспубліка Кот д’Івуар\\")","(official_name,\\"République de Côte d’Ivoire\\")","(name:zh_pyt,Kētèdíwǎ)","(name:zh_py,Ketediwa)","(name:zh,科特迪瓦)","(name:uk,Кот-д'Івуар)","(name:tr,\\"Fildişi Sahili\\")","(name:th,ประเทศโกตดิวัวร์)","(name:sv,Elfenbenskusten)","(name:sl,\\"Slonokoščena obala\\")","(name:ru,\\"Кот д'Ивуар\\")","(name:pt,\\"Costa do Marfim\\")","(name:pl,\\"Wybrzeże Kości Słoniowej\\")","(name:nl,Ivoorkust)","(name:mn,\\"Зааны Ясан Эрэг\\")","(name:lv,Kotdivuāra)","(name:lt,\\"Dramblio kaulo krantas\\")","(name:li,Ivoorkös)","(name:lb,Elfebeeküst)","(name:la,\\"Litus Eburneum\\")","(name:ja,コートジボワール)","(name:it,\\"Costa d'Avorio\\")","(name:is,Fílabeinsströndin)","(name:id,\\"Pantai Gading\\")","(name:hu,Elefántcsontpart)","(name:hr,\\"Obala Bjelokosti\\")","(name:he,\\"חוף השנהב\\")","(name:gd,\\"Costa Ìbhri\\")","(name:ga,\\"An Cósta Eabhair\\")","(name:fy,Ivoarkust)","(name:fr,\\"Côte d'Ivoire\\")","(name:fi,Norsunluurannikko)","(name:fa,\\"ساحل عاج\\")","(name:eu,\\"Boli Kosta\\")","(name:et,Elevandiluurannik)","(name:es,\\"Costa de Marfil\\")","(name:eo,Ebur-Bordo)","(name:en,\\"Côte d'Ivoire\\")","(name:el,\\"Ακτή Ελεφαντοστού\\")","(name:de,Elfenbeinküste)","(name:da,Elfenbenskysten)","(name:ca,\\"Costa d'Ivori\\")","(name:br,\\"Aod an Olifant\\")","(name:be,\\"Кот д’Івуар\\")","(name:ar,\\"كوت ديفوار\\")","(name:af,Ivoorkus)","(name,\\"Côte d'Ivoire\\")"}	\N
is	{"(official_name:vi,\\"Cộng hòa Iceland\\")","(official_name:sv,\\"Republiken Island\\")","(official_name:pl,\\"Republika Islandii\\")","(official_name:lv,\\"Īslandes Republika\\")","(official_name:lt,\\"Islandijos Respublika\\")","(official_name:lb,\\"Republik Island\\")","(official_name:ja,アイスランド共和国)","(official_name:it,\\"Repubblica d'Islanda\\")","(official_name:id,\\"Republik Islandia\\")","(official_name:es,\\"República de Islandia\\")","(official_name:en,\\"Republic of Iceland\\")","(official_name:el,\\"Δημοκρατία της Ισλανδίας\\")","(official_name:be,Ісландыя)","(official_name,\\"Lýðveldið Ísland\\")","(name:zh_pyt,Bīngdǎo)","(name:zh_py,Bingdao)","(name:zh,冰岛)","(name:vi,Iceland)","(name:uk,Ісландія)","(name:tr,İzlanda)","(name:th,ประเทศไอซ์แลนด์)","(name:sv,Island)","(name:sl,Islandija)","(name:ru,Исландия)","(name:pl,Islandia)","(name:no,Island)","(name:nn,Island)","(name:nl,IJsland)","(name:nb,Island)","(name:mn,Исланд)","(name:lv,Īslande)","(name:lt,Islandija)","(name:li,Iesland)","(name:lb,Island)","(name:la,Islandia)","(name:ja,アイスランド)","(name:it,Islanda)","(name:is,Ísland)","(name:id,Islandia)","(name:hu,Izland)","(name:he,איסלנד)","(name:haw,\\"‘Āina Hau\\")","(name:gd,\\"Innis Tìle\\")","(name:ga,\\"An Íoslainn\\")","(name:fy,Yslân)","(name:fr,Islande)","(name:fi,Islanti)","(name:fa,ایسلند)","(name:et,Island)","(name:es,Islandia)","(name:eo,Islando)","(name:en,Iceland)","(name:el,Ισλανδία)","(name:de,Island)","(name:da,Island)","(name:cy,\\"Gwlad yr Iâ\\")","(name:ca,Islàndia)","(name:br,Island)","(name:be,Ісландыя)","(name:ar,آيسلندا)","(name:af,Ysland)","(name,Ísland)"}	\N
ru	{"(official_name:vi,\\"Liên Bang Nga\\")","(official_name:sv,\\"Ryska federationen\\")","(official_name:sl,\\"Ruska federacija\\")","(official_name:pt,\\"Federação Russa\\")","(official_name:pl,\\"Federacja Rosyjska\\")","(official_name:lt,\\"Rusijos Federacija\\")","(official_name:lb,\\"Russesch Federatioun\\")","(official_name:id,\\"Federasi Rusia\\")","(official_name:et,\\"Venemaa Föderatsioon\\")","(official_name:es,\\"Federación Rusa\\")","(official_name:en,\\"Russian Federation\\")","(official_name:el,\\"Ρωσική Ομοσπονδία\\")","(official_name:ca,\\"Federació Russa\\")","(official_name:br,\\"Kevread Rusia\\")","(official_name:be,\\"Расійская Федэрацыя\\")","(official_name:af,\\"Russiese Federasie\\")","(official_name,\\"Российская Федерация\\")","(name:zh_pyt,Éluósī)","(name:zh_py,Eluosi)","(name:zh,俄罗斯)","(name:vi,Nga)","(name:uk,Росія)","(name:ua,Росія)","(name:tr,Rusya)","(name:th,ประเทศรัสเซีย)","(name:sv,Ryssland)","(name:sl,Rusija)","(name:ru,Россия)","(name:ro,Rusia)","(name:pt,Rússia)","(name:pl,Rosja)","(name:nl,Rusland)","(name:mn,Орос)","(name:lv,Krievija)","(name:lt,Rusija)","(name:li,Rösland)","(name:lb,Russland)","(name:la,Russia)","(name:ja,ロシア)","(name:is,Rússland)","(name:id,Rusia)","(name:hy,Ռուսաստան)","(name:hu,Oroszország)","(name:hr,Rusija)","(name:he,רוסיה)","(name:haw,Rūsia)","(name:gd,\\"An Ruis\\")","(name:ga,\\"An Rúis\\")","(name:fy,Ruslân)","(name:fr,Russie)","(name:fi,Venäjä)","(name:fa,روسیه)","(name:et,Venemaa)","(name:es,Rusia)","(name:eo,Rusio)","(name:en,Russia)","(name:el,Ρωσία)","(name:de,Russland)","(name:da,Rusland)","(name:cy,\\"Ffederasiwn Rwsia\\")","(name:ca,Rússia)","(name:by,Расія)","(name:br,Rusia)","(name:be,Расія)","(name:az,\\"Rusiya Federasiyası\\")","(name:ar,\\"روسيا الاتحادية\\")","(name:af,Rusland)","(name,Россия)","(alt_name,Russia;Россия)"}	\N
ls	{"(official_name:vi,\\"Vương quốc Lesotho\\")","(official_name:sv,\\"Konungariket Lesotho\\")","(official_name:sl,\\"Kraljevina Lesoto\\")","(official_name:lv,\\"Lesoto Karaliste\\")","(official_name:lt,\\"Lesoto Karalystė\\")","(official_name:lb,\\"Kinnekräich Lesotho\\")","(official_name:id,\\"Kerajaan Lesotho\\")","(official_name,\\"Kingdom of Lesotho;Muso oa Lesotho\\")","(name:zh_pyt,Láisuǒtuō)","(name:zh_py,Laisuotuo)","(name:zh,莱索托)","(name:uk,Лесото)","(name:tr,Lesoto)","(name:th,ประเทศเลโซโท)","(name:sv,Lesotho)","(name:sl,Lesoto)","(name:ru,Лесото)","(name:pl,Lesotho)","(name:mn,Лесото)","(name:lv,Lesoto)","(name:lt,Lesotas)","(name:la,Lesothum)","(name:ja,レソト)","(name:it,Lesotho)","(name:is,Lesótó)","(name:hu,Lesotho)","(name:hr,Lesoto)","(name:he,לסוטו)","(name:haw,Lesoto)","(name:gd,Leasoto)","(name:ga,Leosóta)","(name:fy,Lesoto)","(name:fr,Lesotho)","(name:fi,Lesotho)","(name:fa,لسوتو)","(name:es,Lesoto)","(name:eo,Lesoto)","(name:el,Λεσότο)","(name:br,Lesotho)","(name:be,Лесота)","(name:ar,ليسوتو)","(name,Lesotho)"}	\N
om	{"(official_name:sv,\\"Sultanatet Oman\\")","(official_name:pt,\\"Sultanato do Omã\\")","(official_name:pl,\\"Sułtanat Omanu\\")","(official_name:lt,\\"Omano Sultonatas\\")","(official_name:lb,\\"Saltanat Uman\\")","(official_name:ja,オマーン国)","(official_name:it,\\"Sultanato dell'Oman\\")","(official_name:id,\\"Kesultanan Oman\\")","(official_name:fr,\\"Sultanat d'Oman\\")","(official_name:et,\\"Omaani Sultaniriik\\")","(official_name:en,\\"Sultanate of Oman\\")","(official_name:el,\\"Σουλτανάτο του Ομάν\\")","(official_name:ca,\\"Sultanat d'Oman \\")","(official_name:br,\\"Sultanad Oman\\")","(official_name,\\"سلطنة عُمان\\")","(name:zh_pyt,Āmàn)","(name:zh_py,Aman)","(name:zh,阿曼)","(name:vi,Oman)","(name:uk,Оман)","(name:tr,Umman)","(name:th,ประเทศโอมาน)","(name:sv,Oman)","(name:sl,Oman)","(name:ru,Оман)","(name:pt,Omã)","(name:pl,Oman)","(name:nl,Oman)","(name:mn,Оман)","(name:lt,Omanas)","(name:li,Omaan)","(name:lb,Oman)","(name:la,Omania)","(name:ja,オマーン)","(name:it,Oman)","(name:is,Óman)","(name:id,Oman)","(name:hu,Omán)","(name:hr,Oman)","(name:he,עומן)","(name:haw,ʻOmana)","(name:gd,Omàn)","(name:ga,Óman)","(name:fy,Oman)","(name:fr,Oman)","(name:fi,Oman)","(name:fa,عمان)","(name:et,Omaan)","(name:es,Omán)","(name:eo,Omano)","(name:en,Oman)","(name:el,Ομάν)","(name:de,Oman)","(name:da,Oman)","(name:cy,Oman)","(name:ca,Oman)","(name:br,Oman)","(name:be,Аман)","(name:ar,عمان)","(name:af,Oman)","(name,\\"سلطنة عُمان Oman\\")"}	\N
gi	{"(old_name,\\"Mons Calpe\\")","(name:zh_pyt,Zhíbùluótuó)","(name:zh_py,Zhibuluotuo)","(name:zh,直布罗陀)","(name:uk,Гібралтар)","(name:tr,Cebelitarık)","(name:th,ยิบรอลตาร์)","(name:sv,Gibraltar)","(name:sk,Gibraltár)","(name:ru,Гибралтар)","(name:pl,Gibraltar)","(name:mn,Гибралтар)","(name:lv,Gibraltārs)","(name:lt,Gibraltaras)","(name:la,Calpe)","(name:it,Gibilterra)","(name:is,Gíbraltar)","(name:hu,Gibraltár)","(name:he,גיברלטר)","(name:gd,Giobraltair)","(name:ga,Giobráltar)","(name:fr,Gibraltar)","(name:fi,Gibraltar)","(name:fa,جبل‌الطارق)","(name:eo,Ĝibraltaro)","(name:el,Γιβραλτάρ)","(name:br,Gibraltar)","(name:be,Гібралтар)","(name:ar,\\"جبل طارق\\")","(name,Gibraltar)"}	\N
au	{"(official_name:vi,\\"Liên bang Úc\\")","(official_name:sv,\\"Australiska statsförbundet\\")","(official_name:pt,\\"Comunidade da Austrália\\")","(official_name:pl,\\"Związek Australijski\\")","(official_name:lv,\\"Austrālijas Savienība\\")","(official_name:id,\\"Negara Persemakmuran Australia\\")","(official_name:fr,\\"Commonwealth d’Australie\\")","(official_name:fi,\\"Australian liittovaltio\\")","(official_name:es,\\"Mancomunidad de Australia\\")","(official_name:el,\\"Κοινοπολιτεία της Αυστραλίας\\")","(official_name:be,\\"Аўстралійскі саюз\\")","(official_name,\\"Commonwealth of Australia\\")","(name:zh,澳大利亚)","(name:vi,Úc)","(name:uk,Австралія)","(name:tr,Avustralya)","(name:th,ประเทศออสเตรเลีย)","(name:sv,Australien)","(name:sl,Avstralija)","(name:ru,Австралия)","(name:pt,Austrália)","(name:pl,Australia)","(name:nl,Australië)","(name:mn,Австрали)","(name:lv,Austrālija)","(name:lt,Australija)","(name:li,Australië)","(name:lb,Australien)","(name:ja,オーストラリア)","(name:it,Australia)","(name:is,Ástralía)","(name:hy,Ավստրալիա)","(name:hu,Ausztrália)","(name:he,אוסטרליה)","(name:gd,Astràilia)","(name:ga,\\"An Astráil\\")","(name:fy,Austraalje)","(name:fr,Australie)","(name:fi,Australia)","(name:fa,استرالیا)","(name:et,Austraalia)","(name:eo,Aŭstralio)","(name:en,Australia)","(name:el,Αυστραλία)","(name:de,Australien)","(name:da,Australien)","(name:cy,Awstralia)","(name:ca,Austràlia)","(name:br,Aostralia)","(name:be,Аўстралія)","(name:az,Avstraliya)","(name:ar,أستراليا)","(name:af,Australië)","(name,Australia)"}	\N
bg	{"(official_name:vi,\\"Cộng hòa Bulgaria\\")","(official_name:sv,\\"Republiken Bulgarien\\")","(official_name:sk,\\"Bulharská republika\\")","(official_name:pt,\\"República da Bulgária\\")","(official_name:pl,\\"Republika Bułgarii\\")","(official_name:lv,\\"Bulgārijas Republika\\")","(official_name:lt,\\"Bulgarijos Respublika\\")","(official_name:lb,\\"Republik Bulgarien\\")","(official_name:ja,ブルガリア共和国)","(official_name:it,\\"Repubblica di Bulgaria\\")","(official_name:et,\\"Bulgaaria Vabariik\\")","(official_name:es,\\"República de Bulgaria\\")","(official_name:en,\\"Republic of Bulgaria\\")","(official_name:el,\\"Δημοκρατία της Βουλγαρίας\\")","(official_name:br,\\"Republik Bulgaria\\")","(official_name,\\"Република България\\")","(name:zh_pyt,Bǎojiālìyà)","(name:zh_py,Baojialiya)","(name:zh,保加利亚)","(name:vi,Bulgaria)","(name:uk,Болгарія)","(name:tr,Bulgaristan)","(name:th,ประเทศบัลแกเรีย)","(name:sv,Bulgarien)","(name:sl,Bolgarija)","(name:sk,Bulharsko)","(name:ru,Болгария)","(name:pt,Bulgária)","(name:pl,Bułgaria)","(name:nl,Bulgarije)","(name:mn,Болгар)","(name:lv,Bulgārija)","(name:lt,Bulgarija)","(name:li,Bölgarieë)","(name:lb,Bulgarien)","(name:la,Bulgaria)","(name:ja,ブルガリア)","(name:it,Bulgaria)","(name:is,Búlgaría)","(name:id,Bulgaria)","(name:hu,Bulgária)","(name:hr,Bugarska)","(name:he,בולגריה)","(name:haw,Pulukalia)","(name:gd,Bulgàiria)","(name:ga,\\"An Bhulgáir\\")","(name:fy,Bulgarije)","(name:fr,Bulgarie)","(name:fi,Bulgaria)","(name:fa,بلغارستان)","(name:et,Bulgaaria)","(name:es,Bulgaria)","(name:eo,Bulgario)","(name:en,Bulgaria)","(name:el,Βουλγαρία)","(name:de,Bulgarien)","(name:da,Bulgarien)","(name:cy,Bwlgaria)","(name:ca,Bulgària)","(name:br,Bulgaria)","(name:bg,България)","(name:be,Балгарыя)","(name:ar,بلغاريا)","(name:af,Bulgarye)","(name,България)"}	\N
cm	{"(official_name:vi,\\"Cộng hòa Cameroon\\")","(official_name:sv,\\"Republiken Kamerun\\")","(official_name:pt,\\"República dos Camarões\\")","(official_name:lv,\\"Kamerūnas Republika\\")","(official_name:lt,\\"Kamerūno Respublika\\")","(official_name:ja,カメルーン共和国)","(official_name:id,\\"Republik Kamerun\\")","(official_name:gd,\\"Poblachd Chamarun\\")","(official_name:el,\\"Δημοκρατία του Καμερούν\\")","(official_name,\\"Republic of Cameroon;République du Cameroun\\")","(name:zh_pyt,Kāmàilóng)","(name:zh_py,Kamailong)","(name:zh,喀麦隆)","(name:vi,Cameroon)","(name:uk,Камерун)","(name:tr,Kamerun)","(name:th,ประเทศแคเมอรูน)","(name:sv,Kamerun)","(name:sl,Kamerun)","(name:ru,Камерун)","(name:pt,Camarões)","(name:pl,Kamerun)","(name:nl,Kameroen)","(name:mn,Камерун)","(name:lv,Kamerūna)","(name:lt,Kamerūnas)","(name:li,Kameroen)","(name:lb,Kamerun)","(name:la,Cameronia)","(name:ja,カメルーン)","(name:it,Camerun)","(name:is,Kamerún)","(name:id,Kamerun)","(name:hu,Kamerun)","(name:hr,Kamerun)","(name:he,קמרון)","(name:gd,Camarun)","(name:ga,Camarún)","(name:fy,Kameroen)","(name:fr,Cameroun)","(name:fi,Kamerun)","(name:fa,کامرون)","(name:eu,Kamerun)","(name:et,Kamerun)","(name:es,Camerún)","(name:eo,Kameruno)","(name:en,Cameroon)","(name:el,Καμερούν)","(name:de,Kamerun)","(name:da,Cameroun)","(name:cy,Camerŵn)","(name:ca,Camerun)","(name:br,Kameroun)","(name:be,Камерун)","(name:ar,الكاميرون)","(name:af,Kameroen)","(name,Cameroon;Cameroun)"}	\N
er	{"(official_name:vi,\\"Quốc gia Eritrea\\")","(official_name:pt@PT,\\"Estado da Eritreia\\")","(official_name:pt@BR,\\"Estado da Eritréia\\")","(official_name:pt,\\"Estado da Eritreia;Estado da Eritréia\\")","(official_name:lv,\\"Eritrejas Valsts\\")","(official_name:en,\\"State of Eritrea\\")","(official_name:el,\\"Κράτος της Ερυθραίας\\")","(name:zh_pyt,Èlìtèlǐyà)","(name:zh_py,Eliteliya)","(name:zh,厄立特里亚)","(name:uk,Еритрея)","(name:tr,Eritre)","(name:th,ประเทศเอริเทรีย)","(name:sv,Eritrea)","(name:sl,Eritreja)","(name:ru,Эритрея)","(name:pt@PT,Eritreia)","(name:pt@BR,Eritréia)","(name:pt,Eritreia;Eritréia)","(name:pl,Erytrea)","(name:mn,Энэтхэг)","(name:lv,Eritreja)","(name:lt,Eritrėja)","(name:la,Erythraea)","(name:ja,エリトリア)","(name:it,Eritrea)","(name:is,Erítrea)","(name:hu,Eritrea)","(name:hr,Eritreja)","(name:he,אריתריאה)","(name:gd,Ertra)","(name:ga,\\"An Eiritré\\")","(name:fr,Érythrée)","(name:fi,Eritrea)","(name:fa,اریتره)","(name:es,Eritrea)","(name:eo,Eritreo)","(name:en,Eritrea)","(name:el,Ερυθραία)","(name:br,Eritrea)","(name:be,Эрытрэя)","(name:ar,إريتريا)","(name:af,Eritrea)","(name,Eritrea)"}	\N
gd	{"(name:zh,格林纳达)","(name:uk,Гренада)","(name:th,ประเทศเกรเนดา)","(name:sv,Grenada)","(name:ru,Гренада)","(name:pl,Granada)","(name:mn,Гренада)","(name:lv,Grenāda)","(name:lb,Granada)","(name:la,Granata)","(name:ja,グレナダ)","(name:it,Grenada)","(name:is,Grenada)","(name:hu,Grenada)","(name:he,גרנדה)","(name:gd,Greanada)","(name:ga,Greanáda)","(name:fr,Grenade)","(name:fi,Grenada)","(name:fa,گرنادا)","(name:es,Granada)","(name:eo,Grenado)","(name:en,Grenada)","(name:el,Γρενάδα)","(name:da,Grenada)","(name:br,Grenada)","(name:be,Грэнада)","(name:ar,غرينادا)","(name,Grenada)"}	\N
iq	{"(official_name:vi,\\"Cộng hoà Iraq\\")","(official_name:sv,\\"Republiken Irak\\")","(official_name:pl,\\"Republika Federalna Iraku\\")","(official_name:lv,\\"Irākas Republika\\")","(official_name:lt,\\"Irako Respublika\\")","(official_name:lb,\\"Republik Irak\\")","(official_name:id,\\"Republik Irak\\")","(official_name:gd,\\"Poblachd Ioràic\\")","(official_name:et,\\"Iraagi Vabariik\\")","(official_name:en,\\"Republic of Iraq\\")","(official_name:el,\\"Δημοκρατία του Ιράκ\\")","(official_name,\\"جمهورية العراق\\")","(name:zh_pyt,Yīlākè)","(name:zh_py,Yilake)","(name:zh,伊拉克)","(name:uk,Ірак)","(name:tr,Irak)","(name:th,ประเทศอิรัก)","(name:sv,Irak)","(name:sl,Irak)","(name:ru,Ирак)","(name:pl,Irak)","(name:no,Irak)","(name:nn,Irak)","(name:nl,Irak)","(name:nb,Irak)","(name:mn,Ирак)","(name:lv,Irāka)","(name:lt,Irakas)","(name:li,Irak)","(name:lb,Irak)","(name:la,Iraquia)","(name:ja,イラク)","(name:it,Iraq)","(name:is,Írak)","(name:id,Irak)","(name:hy,Իրաք)","(name:hu,Irak)","(name:hr,Irak)","(name:he,עירק)","(name:haw,‘Ilaka)","(name:gd,Ioràc)","(name:ga,\\"An Iaráic\\")","(name:fy,Irak)","(name:fr,Irak)","(name:fi,Irak)","(name:fa,عراق)","(name:et,Iraak)","(name:eo,Irako)","(name:en,Iraq)","(name:el,Ιράκ)","(name:de,Irak)","(name:da,Irak)","(name:cy,Irac)","(name:br,Irak)","(name:be,Ірак)","(name:ar,العراق)","(name:af,Irak)","(name,Iraq)"}	\N
la	{"(official_name:vi,\\"Cộng hòa Dân chủ Nhân dân Lào\\")","(official_name:sv,\\"Demokratiska folkrepubliken Laos\\")","(official_name:ru,\\"Лаосская Народно-Демократическая Республика\\")","(official_name:pl,\\"Laotańska Republika Ludowo-Demokratyczna\\")","(official_name:lv,\\"Laosas Tautas Demokrātiskā Republika\\")","(official_name:lt,\\"Laoso Liaudies Demokratinė Respublika\\")","(official_name:lb,\\"Demokratesch Volleksrepublik Laos\\")","(official_name:it,\\"Repubblica Popolare Democratica del Laos\\")","(official_name:id,\\"Republik Demokratik Rakyat Laos\\")","(official_name:el,\\"Λαϊκή Δημοκρατία του Λάος\\")","(official_name:br,\\"Republik Demokratel ar Bobl Lao\\")","(name:zh_pyt,Lǎowō)","(name:zh_py,Laowo)","(name:zh,老挝)","(name:vi,Lào)","(name:uk,Лаос)","(name:th,ประเทศลาว)","(name:sv,Laos)","(name:ru,Лаос)","(name:pl,Laos)","(name:mn,Лаос)","(name:lv,Laosa)","(name:lt,Laosas)","(name:la,Laotia)","(name:ja,ラオス)","(name:it,Laos)","(name:is,Lagos)","(name:hu,Laosz)","(name:he,לאוס)","(name:haw,Laosa)","(name:gd,Làthos)","(name:ga,Laos)","(name:fr,Laos)","(name:fi,Laos)","(name:fa,لائوس)","(name:eo,Laoso)","(name:en,Laos)","(name:el,Λάος)","(name:da,Laos)","(name:br,Laos)","(name:be,Лаос)","(name:ar,لاوس)","(name:af,Laos)","(name,Laos)"}	\N
lc	{"(name:zh,圣卢西亚岛)","(name:uk,Сент-Люсія)","(name:th,ประเทศเซนต์ลูเซีย)","(name:sv,\\"Saint Lucia\\")","(name:ru,Сент-Люсия)","(name:pt,\\"Santa Lúcia\\")","(name:pl,\\"Saint Lucia\\")","(name:mn,\\"Сент Люсиа\\")","(name:lv,Sentlūsija)","(name:lt,\\"Sent Lusija\\")","(name:li,\\"Santa Lucia\\")","(name:la,\\"Sancta Lucia\\")","(name:ja,セントルシア)","(name:it,\\"Santa Lucia\\")","(name:is,\\"Sankti Lúsía\\")","(name:hu,\\"Saint Lucia\\")","(name:hr,\\"Sveta Lucija\\")","(name:he,\\"סנט לוסיה\\")","(name:gd,\\"Naomh Lùisia\\")","(name:ga,\\"San Lucia\\")","(name:fy,\\"Sint Lusia\\")","(name:fr,Sainte-Lucie)","(name:fi,\\"Saint Lucia\\")","(name:fa,\\"سنت لوسیا\\")","(name:es,\\"Santa Lucía\\")","(name:eo,\\"Sankta Lucio\\")","(name:en,\\"Saint Lucia\\")","(name:de,\\"St. Lucia\\")","(name:da,\\"Saint Lucia\\")","(name:br,\\"Saint Lucia\\")","(name:be,\\"Святая Лусія\\")","(name:ar,\\"سانت لوسيا\\")","(name:af,\\"Sint Lucia\\")","(name,\\"Saint Lucia\\")"}	\N
mc	{"(official_name:sv,\\"Furstendömet Monaco\\")","(official_name:sl,\\"Kneževína Monáko\\")","(official_name:sk,\\"Monacké kniežatstvo\\")","(official_name:pl,\\"Księstwo Monako\\")","(official_name:mn,\\"Principatu de Múnegu\\")","(official_name:lv,\\"Monako Firstiste\\")","(official_name:lt,\\"Monako Kunigaikštystė\\")","(official_name:lb,\\"Fürstentum Monaco\\")","(official_name:ja,モナコ公国)","(official_name:it,\\"Principato di Monaco\\")","(official_name:id,\\"Kepangeranan Monako\\")","(official_name:fr,\\"Principauté de Monaco\\")","(official_name:es,\\"Principado de Mónaco\\")","(official_name:en,\\"Principality of Monaco\\")","(official_name:el,\\"Πριγκηπάτο του Μονακό\\")","(official_name:br,\\"Priñselezh Monako\\")","(official_name,\\"Principatu de Múnegu\\")","(name:zh_pyt,Mónàgē)","(name:zh_py,Monage)","(name:zh,摩纳哥)","(name:uk,Монако)","(name:tr,Monako)","(name:th,ประเทศโมนาโก)","(name:sv,Monaco)","(name:sl,Monako)","(name:sk,Monako)","(name:ru,Монако)","(name:pl,Monako)","(name:mn,Монако)","(name:lv,Monako)","(name:lt,Monakas)","(name:la,Monoecus)","(name:ja,モナコ)","(name:is,Mónakó)","(name:id,Monako)","(name:hu,Monaco)","(name:he,מונקו)","(name:haw,Monako)","(name:ga,Monacó)","(name:fy,Monako)","(name:fr,Monaco)","(name:fi,Monaco)","(name:fa,موناکو)","(name:es,Mónaco)","(name:eo,Monako)","(name:en,Monaco)","(name:el,Μονακό)","(name:br,Monako)","(name:be,Манака)","(name:ar,موناكو)","(name,Monaco)"}	\N
md	{"(official_name:vi,\\"Cộng hòa Moldova\\")","(official_name:sv,\\"Republiken Moldavien\\")","(official_name:sk,\\"Moldavská republika\\")","(official_name:ru,\\"Республика Молдова\\")","(official_name:pl,\\"Republika Mołdawii\\")","(official_name:lv,\\"Moldovas Republika\\")","(official_name:lb,\\"Republik Moldawien\\")","(official_name:ja,モルドバ共和国)","(official_name:id,\\"Republik Moldova\\")","(official_name:es,\\"República de Moldavia\\")","(official_name:en,\\"The Republic of Moldova\\")","(official_name:be,\\"Рэспубліка Малдова\\")","(official_name,\\"Republica Moldova\\")","(name:zh_pyt,Móěrduōwǎ)","(name:zh_py,Moerduowa)","(name:zh,摩尔多瓦)","(name:vi,Moldova)","(name:uk,Молдова)","(name:tr,Moldova)","(name:th,ประเทศมอลโดวา)","(name:sv,Moldavien)","(name:sl,Moldavija)","(name:sk,Moldavsko)","(name:ru,Молдова)","(name:pl,Mołdawia)","(name:nl,Moldavië)","(name:mn,Молдав)","(name:lv,Moldova)","(name:lt,\\"Moldovos Respublika\\")","(name:lb,Moldawien)","(name:la,\\"Respublica Moldavica\\")","(name:ja,モルドバ)","(name:it,Moldavia)","(name:is,Moldóva)","(name:id,Moldova)","(name:hu,Moldova)","(name:hr,Moldavija)","(name:he,מולדובה)","(name:haw,Molodowa)","(name:gd,Moldàibhia)","(name:ga,\\"An Mholdóiv\\")","(name:fy,Moldaavje)","(name:fr,Moldavie)","(name:fi,Moldova)","(name:fa,مولداوی)","(name:es,Moldavia)","(name:eo,Moldavio)","(name:en,Moldova)","(name:de,Moldawien)","(name:da,Moldova)","(name:cy,Moldofa)","(name:ca,Moldàvia)","(name:br,Moldavia)","(name:be,Малдова)","(name:ar,\\"جمهورية مولدوفا\\")","(name:af,Moldowa)","(name,Moldova)"}	\N
mm	{"(official_name:vi,\\"Liên bang Myanma\\")","(official_name:sv,\\"Unionen Myanmar\\")","(official_name:pl,\\"Związek Myanmar\\")","(official_name:lv,\\"Mjanmas Savienība\\")","(official_name:lt,\\"Mianmaro Sąjunga\\")","(official_name:it,Myanmar)","(official_name:id,\\"Persatuan Myanmar\\")","(name:zh_pyt,Miǎndiàn)","(name:zh_py,Miandian)","(name:zh,缅甸)","(name:vi,Myanma)","(name:uk,М'янма)","(name:th,ประเทศพม่า)","(name:sv,Burma)","(name:sl,Mjanmar)","(name:ru,Мьянма)","(name:pl,Birma)","(name:mn,Мьянмар)","(name:lv,Mjanma)","(name:lt,Mianmaras)","(name:li,Burma)","(name:la,Birmania)","(name:it,Birmania)","(name:is,Mjanmar)","(name:hu,Mianmar)","(name:hr,\\"Mijanmar (Burma)\\")","(name:he,מיאנמר)","(name:haw,Puruma)","(name:gd,Mianmar)","(name:ga,Maenmar)","(name:fy,Birma)","(name:fr,Birmanie)","(name:fi,Myanmar)","(name:fa,میانمار)","(name:et,Birma)","(name:eo,Birmo)","(name:en,Myanmar)","(name:el,Μιανμάρ)","(name:da,Myanmar)","(name:ca,Burma)","(name:br,Birmania)","(name:be,М'янма)","(name:ar,ميانمار)","(name:af,Mianmar)","(name,Myanmar)"}	\N
mr	{"(official_name:vi,\\"Cộng hòa Hồi giáo Mauritanie\\")","(official_name:sv,\\"Islamiska republiken Mauretanien\\")","(official_name:pt,\\"República Islâmica da Mauritânia\\")","(official_name:lv,\\"Mauritānijas Islāma Republika\\")","(official_name:lt,\\"Mauritanijos Islamo Respublika\\")","(official_name:lb,\\"Islamesch Republik Mauretanien\\")","(official_name:ja,モーリタニア・イスラム共和国)","(official_name:id,\\"Republik Islam Mauritania\\")","(official_name:et,\\"Mauritaania Islamivabariik\\")","(official_name:en,\\"Islamic Republic of Mauritania\\")","(official_name:el,\\"Ισλαμική Δημοκρατία της Μαυριτανίας\\")","(official_name:ca,\\"República Islàmica de Mauritània\\")","(official_name:br,\\"Republik islamek Maouritania\\")","(official_name:be,\\"Маўрытанская Ісламская Рэспубліка\\")","(official_name,\\"الجمهورية الإسلامية الموريتانية\\")","(name:zh_pyt,Máolǐtǎníyà)","(name:zh_py,Maolitaniya)","(name:zh,毛里塔尼亚)","(name:vi,Mauritanie)","(name:uk,Мавританія)","(name:tr,Moritanya)","(name:th,ประเทศมอริเตเนีย)","(name:sv,Mauretanien)","(name:sl,Mavretanija)","(name:ru,Мавритания)","(name:pt,Mauritânia)","(name:pl,Mauretania)","(name:nl,Mauritanië)","(name:mn,Мавритани)","(name:lv,Mauritānija)","(name:lt,Mauritanija)","(name:li,Mauretanië)","(name:lb,Mauretanien)","(name:la,Mauritania)","(name:ja,モーリタニア)","(name:it,Mauritania)","(name:is,Máritanía)","(name:id,Mauritania)","(name:hu,Mauritánia)","(name:hr,Mauritanija)","(name:he,מאוריטניה)","(name:haw,Mauritania)","(name:gd,Moratainia)","(name:ga,\\"An Mháratáin\\")","(name:fy,Mauritaanje)","(name:fr,Mauritanie)","(name:fi,Mauritania)","(name:fa,موریتانی)","(name:et,Mauritaania)","(name:es,Mauritania)","(name:eo,Maŭritanio)","(name:en,Mauritania)","(name:el,Μαυριτανία)","(name:de,Mauretanien)","(name:da,Mauretanien)","(name:cy,Mauritania)","(name:ca,Mauritània)","(name:br,Maouritania)","(name:be,Маўрытанія)","(name:ar,موريتانيا)","(name:af,Mauritanië)","(name,موريتانيا)"}	\N
mu	{"(official_name:vi,\\"Cộng hòa Mauritius\\")","(official_name:sv,\\"Republiken Mauritius\\")","(official_name:pl,\\"Republika Mauritiusa;Republika Mauritiusu\\")","(official_name:lv,\\"Maurīcijas Republika\\")","(official_name:lt,\\"Mauricijaus Respublika\\")","(official_name:lb,\\"Republik Mauritius\\")","(official_name:id,\\"Republik Mauritius\\")","(official_name:fr,\\"République de Maurice\\")","(official_name:es,\\"República de Mauricio\\")","(official_name:el,\\"Δημοκρατία του Μαυρίκιου\\")","(official_name,\\"Republic of Mauritius\\")","(name:zh_pyt,Máolǐqiúsī)","(name:zh_py,Maoliquisi)","(name:zh,毛里求斯)","(name:uk,Маврикій)","(name:th,ประเทศมอริเชียส)","(name:sv,Mauritius)","(name:ru,Маврикий)","(name:pl,Mauritius)","(name:mn,Маврикий)","(name:lv,Maurīcija)","(name:lt,Mauricijus)","(name:is,Máritíus)","(name:hu,Mauritius)","(name:hr,Mauricius)","(name:he,מאוריציוס)","(name:haw,Mauritiusa)","(name:gd,\\"Na h-Eileanan Mhoiriseas\\")","(name:ga,\\"Oileán Mhuirís\\")","(name:fy,Mauritsius)","(name:fr,Maurice)","(name:fi,Mauritius)","(name:fa,موریس)","(name:es,Mauricio)","(name:eo,Maŭricio)","(name:en,Mauritius)","(name:el,Μαυρίκιος)","(name:da,Mauritius)","(name:ca,Maurici)","(name:br,Moris)","(name:be,Маўрыкій)","(name:ar,موريشيوس)","(name:af,Mauritius)","(name,Mauritius)"}	\N
ng	{"(official_name:vi,\\"Cộng hòa Liên bang Nigeria\\")","(official_name:sv,\\"Förbundsrepubliken Nigeria\\")","(official_name:lv,\\"Nigērijas Federatīvā Republika\\")","(official_name:lt,\\"Nigerijos Federacinė Respublika\\")","(official_name:lb,\\"Bundesrepublik Nigeria\\")","(official_name:gd,\\"Poblachd Caidreachail Nìgeiria\\")","(official_name:et,\\"Nigeeria Liitvabariik\\")","(official_name:el,\\"Ομοσπονδιακή Δημοκρατία της Νιγηρίας\\")","(official_name:be,\\"Федэратыўная Рэспубліка Нігерыя\\")","(official_name,\\"Federal Republic of Nigeria\\")","(name:zh_pyt,Nírìlìyà)","(name:zh_py,Niriliya)","(name:zh,尼日利亚)","(name:uk,Нігерія)","(name:tr,Nijerya)","(name:th,ประเทศไนจีเรีย)","(name:sv,Nigeria)","(name:sl,Nigerija)","(name:ru,Нигерия)","(name:pl,Nigeria)","(name:mn,Нигери)","(name:lv,Nigērija)","(name:lt,Nigerija)","(name:ja,ナイジェリア)","(name:it,Nigeria)","(name:is,Nígería)","(name:hu,Nigéria)","(name:he,ניגריה)","(name:haw,Naigeria)","(name:gd,Nìgeiria)","(name:ga,\\"An Nigéir\\")","(name:fy,Nigearia)","(name:fr,Nigeria)","(name:fi,Nigeria)","(name:fa,نیجریه)","(name:et,Nigeeria)","(name:es,Nigeria)","(name:eo,Niĝerio)","(name:en,Nigeria)","(name:el,Νιγηρία)","(name:da,Nigeria)","(name:ca,Nigèria)","(name:br,Nigeria)","(name:be,Нігерыя)","(name:az,Nigeriya)","(name:ar,نيجيريا)","(name:af,Nigerië)","(name,Nigeria)"}	\N
ni	{"(official_name:sv,\\"Republiken Nicaragua\\")","(official_name:pl,\\"Republika Nikaragui\\")","(official_name:lv,\\"Nikaragvas Republika\\")","(official_name:lt,\\"Nikaragvos Respublika\\")","(official_name:ja,ニカラグア共和国)","(official_name:it,\\"Repubblica del Nicaragua\\")","(official_name:id,\\"Republik Nikaragua\\")","(official_name:be,\\"Рэспубліка Нікарагуа\\")","(official_name,\\"República de Nicaragua\\")","(name:zh,尼加拉瓜)","(name:uk,Нікарагуа)","(name:tr,Nikaragua)","(name:th,ประเทศนิการากัว)","(name:sv,Nicaragua)","(name:sl,Nikaragva)","(name:ru,Никарагуа)","(name:pl,Nikaragua)","(name:mn,Никарагуа)","(name:lv,Nikaragva)","(name:lt,Nikaragva)","(name:ja,ニカラグア)","(name:it,Nicaragua)","(name:is,Níkaragva)","(name:id,Nikaragua)","(name:hu,Nicaragua)","(name:hr,Nikaragva)","(name:he,ניקרגואה)","(name:gd,Niocaragua)","(name:ga,Nicearagua)","(name:fy,Nikaragua)","(name:fr,Nicaragua)","(name:fi,Nicaragua)","(name:fa,نیکاراگوآ)","(name:eo,Nikaragvo)","(name:en,Nicaragua)","(name:el,Νικαράγουα)","(name:da,Nicaragua)","(name:br,Nicaragua)","(name:be,Нікарагуа)","(name:ar,نيكاراغوا)","(name,Nicaragua)"}	\N
pa	{"(official_name:vi,\\"Cộng hoà Panama\\")","(official_name:sv,\\"Republiken Panama\\")","(official_name:pl,\\"Republika Panamy\\")","(official_name:lv,\\"Panamas Republika\\")","(official_name:lt,\\"Panamos Respublika\\")","(official_name:ja,パナマ共和国)","(official_name:it,\\"Repubblica di Panamá\\")","(official_name:id,\\"Republik Panama\\")","(official_name:gd,\\"Poblachd Phanama\\")","(official_name:en,\\"Republic of Panama\\")","(official_name:be,\\"Рэспубліка Панама\\")","(official_name,\\"República de Panamá\\")","(name:zh,巴拿马)","(name:uk,Панама)","(name:th,ประเทศปานามา)","(name:sv,Panama)","(name:ru,Панама)","(name:pl,Panama)","(name:mn,Панама)","(name:lv,Panama)","(name:li,Pánama)","(name:ja,パナマ)","(name:it,Panamá)","(name:is,Panama)","(name:hu,Panama)","(name:he,פנמה)","(name:ga,Panama)","(name:fr,Panama)","(name:fi,Panama)","(name:fa,پاناما)","(name:es,Panamá)","(name:eo,Panamo)","(name:en,Panama)","(name:da,Panama)","(name:ca,Panamà)","(name:br,Panama)","(name:be,Панама)","(name:ar,بنما)","(name,Panama)"}	\N
sm	{"(official_name:vi,\\"Cộng hòa Đại bình yên San Marino\\")","(official_name:sv,\\"Republiken San Marino\\")","(official_name:sk,\\"Sanmarínska republika\\")","(official_name:pt,\\"Sereníssima República de San Marino\\")","(official_name:lt,\\"San Marino Respublika\\")","(official_name:lb,\\"Republik San Marino\\")","(official_name:id,\\"Republik San Marino\\")","(name:zh_pyt,Shèngmǎlìnuò)","(name:zh_py,Shengmalinuo)","(name:zh,圣马力诺)","(name:uk,Сан-Марино)","(name:th,ประเทศซานมารีโน)","(name:sv,\\"San Marino\\")","(name:sk,\\"San Maríno\\")","(name:ru,Сан-Марино)","(name:pt,\\"San Marino\\")","(name:pl,\\"San Marino\\")","(name:mn,Сан-Марино)","(name:lt,\\"San Marinas\\")","(name:la,\\"Sancti Marini\\")","(name:is,\\"San Marínó\\")","(name:hu,\\"San Marino\\")","(name:he,\\"סן מרינו\\")","(name:haw,\\"Sana Marino\\")","(name:ga,\\"San Mairíne\\")","(name:fr,Saint-Marin)","(name:fi,\\"San Marino\\")","(name:fa,\\"سان مارینو\\")","(name:eo,San-Marino)","(name:en,\\"San Marino\\")","(name:el,\\"Άγιος Μαρίνος\\")","(name:da,\\"San Marino\\")","(name:br,\\"San Marino\\")","(name:be,Сан-Марына)","(name:ar,\\"سان مارينو\\")","(name,\\"San Marino\\")"}	\N
so	{"(official_name:vi,\\"Cộng hòa Somalia\\")","(official_name:sv,\\"Republiken Somalia\\")","(official_name:so,\\"Jamhuuriyadda Soomaaliya\\")","(official_name:pt,\\"República Somali\\")","(official_name:lt,\\"Somalio Respublika\\")","(official_name:lb,\\"Republik Somalia\\")","(official_name:fr,\\"République de Somalie\\")","(official_name:et,\\"Somaalia Vabariik\\")","(official_name:en,\\"Somali Republic\\")","(official_name:el,\\"Δημοκρατία της Σομαλίας\\")","(official_name:br,\\"Republik Somalia\\")","(official_name:ar,\\"جمهورية الصومال‎\\")","(official_name,\\"Somali Republic\\")","(name:zh_pyt,Suǒmǎlǐ)","(name:zh_py,Suomali)","(name:zh,索马里)","(name:vi,Somalia)","(name:uk,Сомалі)","(name:tr,Somali)","(name:th,ประเทศโซมาเลีย)","(name:sv,Somalia)","(name:so,Soomaaliya)","(name:sl,Somalija)","(name:ru,Сомали)","(name:pt,Somália)","(name:pl,Somalia)","(name:nl,Somalië)","(name:mn,Сомали)","(name:lv,Somālija)","(name:lt,Somalis)","(name:li,Somalië)","(name:lb,Somalia)","(name:la,Somalia)","(name:ja,ソマリア)","(name:it,Somalia)","(name:is,Sómalía)","(name:id,Somalia)","(name:hu,Szomália)","(name:hr,Somalija)","(name:he,סומליה)","(name:haw,Somalia)","(name:gd,Somàilia)","(name:ga,\\"An tSomáil\\")","(name:fy,Somaalje)","(name:fr,Somalie)","(name:fi,Somalia)","(name:fa,سومالی)","(name:et,Somaalia)","(name:es,Somalia)","(name:eo,Somalio)","(name:en,Somalia)","(name:el,Σομαλία)","(name:de,Somalia)","(name:da,Somalia)","(name:cy,Somalia)","(name:ca,Somàlia)","(name:br,Somalia)","(name:be,Самалі)","(name:ar,الصومال)","(name:af,Somalië)","(name,\\"Somalia / الصومال\\")"}	\N
tv	{"(old_name,\\"Ellice Islands\\")","(name:zh,吐瓦鲁)","(name:uk,Тувалу)","(name:th,ประเทศตูวาลู)","(name:sv,Tuvalu)","(name:ru,Тувалу)","(name:pl,Tuvalu)","(name:mn,Тувалу)","(name:ja,ツバル)","(name:is,Túvalú)","(name:hu,Tuvalu)","(name:he,טובלו)","(name:gd,Tubhalu)","(name:ga,Tuvalu)","(name:fy,Tûvalû)","(name:fr,Tuvalu)","(name:fi,Tuvalu)","(name:fa,تووالو)","(name:eo,Tuvalo)","(name:en,Tuvalu)","(name:el,Τουβαλού)","(name:da,Tuvalu)","(name:cy,Twfalw)","(name:br,Tuvalu)","(name:be,Тувалу)","(name:ar,توفالو)","(name,Tuvalu)"}	\N
ug	{"(official_name:sv,\\"Republiken Uganda\\")","(official_name:lt,\\"Ugandos Respublika\\")","(official_name:id,\\"Republik Uganda\\")","(official_name:gd,\\"Poblachd Uganda\\")","(official_name:br,\\"Republik Ouganda\\")","(official_name,\\"Republic of Uganda;Jamhuri ya Uganda\\")","(name:zh_pyt,Wūgāndá)","(name:zh_py,Wuganda)","(name:zh,乌干达)","(name:uk,Уганда)","(name:th,ประเทศยูกันดา)","(name:sv,Uganda)","(name:ru,Уганда)","(name:pl,Uganda)","(name:nl,Oeganda)","(name:mn,Уганда)","(name:lv,Uganda)","(name:li,Oeganda)","(name:ja,ウガンダ)","(name:it,Uganda)","(name:is,Úganda)","(name:hu,Uganda)","(name:he,אוגנדה)","(name:ga,Uganda)","(name:fr,Ouganda)","(name:fi,Uganda)","(name:fa,اوگاندا)","(name:es,Uganda)","(name:eo,Ugando)","(name:en,Uganda)","(name:el,Ουγκάντα)","(name:br,Ouganda)","(name:be,Уганда)","(name:ar,أوغندا)","(name,Uganda)"}	\N
uz	{"(official_name:sv,\\"Republiken Uzbekistan\\")","(official_name:pt,\\"República do Uzbequistão\\")","(official_name:pl,\\"Republika Uzbekistanu\\")","(official_name:lt,\\"Uzbekistano Respublika\\")","(official_name:lb,\\"Republik Usbekistan\\")","(official_name:it,\\"Repubblica dell'Uzbekistan\\")","(official_name:id,\\"Republik Usbekistan\\")","(official_name:gd,\\"Poblachd Usbagastàn\\")","(official_name:et,\\"Usbekistani Vabariik\\")","(official_name:el,\\"Δημοκρατία του Ουζμπεκιστάν\\")","(official_name:br,\\"Republik Ouzbekistan\\")","(name:zh_pyt,Wūzībiékèsītǎn)","(name:zh_py,Wuzibiekesitan)","(name:zh,乌兹别克斯坦)","(name:uz,\\"Ўзбекистон Республикаси (O‘zbekiston Respublikasi)\\")","(name:uk,Узбекистан)","(name:tr,Özbekistan)","(name:th,ประเทศอุซเบกิสถาน)","(name:sv,Uzbekistan)","(name:ru,Узбекистан)","(name:pt,Uzbequistão)","(name:pl,Uzbekistan)","(name:nl,Oezbekistan)","(name:mn,Узбекистан)","(name:lv,Uzbekistāna)","(name:lt,Uzbekija)","(name:lb,Usbekistan)","(name:la,Uzbecia)","(name:ja,ウズベキスタン)","(name:it,Uzbekistan)","(name:is,Úsbekistan)","(name:hu,Üzbegisztán)","(name:he,אוזבקיסטן)","(name:haw,ʻUsepekikana)","(name:gd,Usbagastàn)","(name:ga,\\"An Úisbéiceastáin\\")","(name:fy,Oezbekistan)","(name:fr,Ouzbékistan)","(name:fi,Uzbekistan)","(name:fa,ازبکستان)","(name:et,Usbekistan)","(name:es,Uzbekistán)","(name:eo,Uzbekio)","(name:en,Uzbekistan)","(name:el,Ουζμπεκιστάν)","(name:de,Usbekistan)","(name:da,Usbekistan)","(name:br,Ouzbekistan)","(name:be,Узбекістан)","(name:az,Özbəkistan)","(name:ar,أوزبكستان)","(name:af,Oesbekistan)","(name,Uzbekistan)"}	\N
mq	{"(official_name:lv,\\"Francijas Martinikas departaments\\")","(name:zh,馬提尼克)","(name:uk,Мартиніка)","(name:sv,Martinique)","(name:ru,Мартиника)","(name:pl,Martynika)","(name:mn,Мартиник)","(name:lv,Martinika)","(name:lt,Martinika)","(name:la,Martinica)","(name:it,Martinica)","(name:is,Martinique)","(name:id,Martinik)","(name:hu,Martinique)","(name:hr,Martinik)","(name:he,מרטיניק)","(name:fy,Martinyk)","(name:fr,Martinique)","(name:fi,Martinique)","(name:fa,مارتینیک)","(name:es,Martinica)","(name:eo,Martiniko)","(name:en,Martinique)","(name:el,Μαρτινίκα)","(name:da,Martinique)","(name:ca,Martinica)","(name:br,Martinik)","(name:be,Марцініка)","(name:ar,مارتينيك)","(name,Martinique)"}	\N
bd	{"(official_name:vi,\\"Cộng hoà Nhân dân Bangladesh\\")","(official_name:sv,\\"Folkrepubliken Bangladesh\\")","(official_name:pt,\\"República Popular do Bangladesh\\")","(official_name:pl,\\"Ludowa Republika Bangladeszu\\")","(official_name:lv,\\"Bangladešas Tautas Republika\\")","(official_name:lt,\\"Bangladešo Liaudies Respublika\\")","(official_name:la,\\"Res Publica Popularis Bangladeshae\\")","(official_name:it,\\"Repubblica Popolare del Bangladesh\\")","(official_name:id,\\"Republik Rakyat Bangladesh\\")","(official_name:fi,\\"Belgian kuningaskunta\\")","(official_name:el,\\"Λαϊκή Δημοκρατία του Μπανγκλαντές\\")","(name:zh_pyt,Mèngjiālāguó)","(name:zh_py,Mengjialaguo)","(name:zh,孟加拉国)","(name:uk,Бангладеш)","(name:tr,Bangladeş)","(name:th,ประเทศบังกลาเทศ)","(name:sv,Bangladesh)","(name:sl,Bangladeš)","(name:ru,Бангладеш)","(name:pt,Bangladesh)","(name:pl,Bangladesz)","(name:mn,Бангладеш)","(name:lv,Bangladeša)","(name:lt,Bangladešas)","(name:li,Bangladesj)","(name:lb,Bangladesch)","(name:la,Bangladesha)","(name:ja,バングラデシュ)","(name:it,Bangladesh)","(name:is,Bangladess)","(name:hu,Banglades)","(name:hr,Bangladeš)","(name:he,בנגלדש)","(name:haw,Banagaladesa)","(name:gd,Bangladais)","(name:ga,\\"An Bhangladéis\\")","(name:fy,Banglades)","(name:fr,Bangladesh)","(name:fi,Bangladesh)","(name:fa,بنگلادش)","(name:eo,Bangladeŝo)","(name:en,Bangladesh)","(name:el,Μπανγκλαντές)","(name:de,Bangladesch)","(name:da,Bangladesh)","(name:ca,\\"Bangla Desh\\")","(name:br,Bangladesh)","(name:be,Бангладэш)","(name:az,Banqladeş)","(name:ar,بنغلاديش)","(name:af,Bangladesj)","(name,Bangladesh)"}	\N
kh	{"(official_name:vi,\\"Vương quốc Campuchia\\")","(official_name:sv,\\"Konungariket Kambodja\\")","(official_name:pt,\\"Reino do Camboja\\")","(official_name:pl,\\"Królestwo Kambodży\\")","(official_name:lv,\\"Kambodžas Karaliste\\")","(official_name:lt,\\"Kambodžos Karalystė\\")","(official_name:ja,カンボジア王国)","(official_name:it,\\"Regno di Cambogia\\")","(official_name:id,\\"Kerajaan Kamboja\\")","(official_name:el,\\"Βασίλειο της Καμπότζης\\")","(official_name:af,\\"Koninkryk van Kambodja\\")","(name:zh_pyt,Gāomián)","(name:zh_py,Gaomian)","(name:zh,高棉)","(name:vi,Campuchia)","(name:uk,Камбоджа)","(name:tr,Kamboçya)","(name:th,\\"ประเทศ กัมพูชา\\")","(name:sv,Kambodja)","(name:sl,Kambodža)","(name:ru,Камбоджа)","(name:pt,Camboja)","(name:pl,Kambodża)","(name:nl,Cambodja)","(name:mn,Камбож)","(name:lv,Kambodža)","(name:lt,Kambodža)","(name:li,Cambodja)","(name:lb,Kambodscha)","(name:la,Cambosia)","(name:ja,カンボジア)","(name:it,Cambogia)","(name:is,Kambódía)","(name:id,Kamboja)","(name:hu,Kambodzsa)","(name:hr,Kambodža)","(name:he,קמבודיה)","(name:haw,Kamabodia)","(name:gd,Cambuidea)","(name:ga,\\"An Chambóid\\")","(name:fy,Kambodja)","(name:fr,Cambodge)","(name:fi,Kambodža)","(name:fa,کامبوج)","(name:eu,Kanputxea)","(name:et,Kambodža)","(name:eo,Kamboĝo)","(name:en,Cambodia)","(name:el,Καμπότζη)","(name:de,Kambodscha)","(name:da,Cambodja)","(name:ca,Cambodja)","(name:br,Kambodja)","(name:be,Камбоджа)","(name:ar,كمبوديا)","(name:af,Kambodja)","(name,Cambodia)"}	\N
cf	{"(official_name:pt,\\"República Centro-Africana\\")","(official_name:fr,\\"République centrafricaine\\")","(name:zh_pyt,\\"Zhōng Fēi\\")","(name:zh_py,\\"Zhong Fei\\")","(name:zh,中非)","(name:vi,\\"Cộng hòa Trung Phi\\")","(name:uk,\\"Центрально-Африканська Республіка\\")","(name:tr,\\"Orta Afrika Cumhuriyeti\\")","(name:th,สาธารณรัฐแอฟริกากลาง)","(name:sv,\\"Centralafrikanska republiken\\")","(name:sl,\\"Srednjeafriška republika\\")","(name:ru,\\"Центрально-Африканская Республика\\")","(name:pt,\\"República Centro-Africana\\")","(name:pl,\\"Republika Środkowoafrykańska\\")","(name:nl,\\"Centraal-Afrikaanse Republiek\\")","(name:mn,\\"Төв Африкийн Бүгд Найрамдах Улс\\")","(name:lv,\\"Centrālāfrikas Republika\\")","(name:lt,\\"Centrinės Afrikos Respublika\\")","(name:li,\\"Centraal Afrika\\")","(name:lb,\\"Zentralafrikanesch Republik\\")","(name:la,\\"Respublica Africae Mediae\\")","(name:it,\\"Repubblica Centrafricana\\")","(name:is,Mið-Afríkulýðveldið)","(name:id,\\"Republik Afrika Tengah\\")","(name:hu,\\"Közép-Afrikai Köztarsaság\\")","(name:hr,\\"Centralna Afrička Republika\\")","(name:he,\\"הרפובליקה המרכז-אפריקאית\\")","(name:gd,\\"Poblachd Meadhan Afraga\\")","(name:ga,\\"Poblacht na hAfraice Láir\\")","(name:fy,\\"de Sintraal-Afrikaanske Republyk\\")","(name:fr,Centrafrique)","(name:fi,\\"Keski-Afrikan tasavalta\\")","(name:fa,\\"جمهوری آفریقای مرکزی\\")","(name:eu,\\"Afrika Erdiko Errepublika\\")","(name:et,\\"Kesk-Aafrika Vabariik\\")","(name:es,\\"República Centroafricana\\")","(name:eo,\\"Centr-Afrika Respubliko\\")","(name:en,\\"Central African Republic\\")","(name:el,\\"Κεντροαφρικανική Δημοκρατία\\")","(name:de,\\"Zentralafrikanische Republik\\")","(name:da,\\"Centralafrikanske Republik\\")","(name:cy,\\"Gweriniaeth Canolbarth Affrica\\")","(name:ca,\\"República Centreafricana\\")","(name:br,Kreizafrika)","(name:be,\\"Цэнтральна-Афрыканская Рэспубліка\\")","(name:ar,\\"جمهورية أفريقيا الوسطى\\")","(name:af,\\"Sentraal-Afrikaanse Republiek\\")","(name,Centrafrique)"}	\N
dk	{"(official_name:vi,\\"Vương quốc Đan Mạch\\")","(official_name:sv,\\"Konungariket Danmark\\")","(official_name:sk,\\"Dánske kráľovstvo\\")","(official_name:pt,\\"Reino da Dinamarca\\")","(official_name:lt,\\"Danijos Karalystė\\")","(official_name:lb,\\"Kinneksräich Dänemark\\")","(official_name:ja,デンマーク王国)","(official_name:id,\\"Kerajaan Denmark\\")","(official_name:gd,\\"Rìoghachd na Danmhairg\\")","(official_name:fr,\\"Royaume du Danemark\\")","(official_name:el,\\"Βασίλειο της Δανίας\\")","(official_name:da,\\"Kongeriget Danmark\\")","(official_name:be,\\"Каралеўства Данія\\")","(official_name,\\"Kingdom of Denmark\\")","(name:zh_pyt,Dānmài)","(name:zh_py,Danmai)","(name:zh,丹麦)","(name:vi,\\"Đan Mạch\\")","(name:uk,Данія)","(name:tr,Danimarka)","(name:th,ประเทศเดนมาร์ก)","(name:sv,Danmark)","(name:sl,Danska)","(name:sk,Dánsko)","(name:ru,Дания)","(name:pt,Dinamarca)","(name:pl,Dania)","(name:nl,Denemarken)","(name:nds,Däänmark)","(name:mn,Дани)","(name:lv,Dānija)","(name:lt,Danija)","(name:li,Daenemark)","(name:lb,Dänemark)","(name:la,Dania)","(name:ja,デンマーク)","(name:it,Danimarca)","(name:is,Danmörk)","(name:id,Denmark)","(name:hu,Dánia)","(name:hr,Danska)","(name:he,דנמרק)","(name:gd,\\"An Danmhairg\\")","(name:ga,\\"An Danmhairg\\")","(name:fy,Denemark)","(name:fr,Danemark)","(name:fi,Tanska)","(name:fa,دانمارک)","(name:eu,Danimarka)","(name:et,Taani)","(name:es,Dinamarca)","(name:eo,Danio)","(name:en,Denmark)","(name:el,Δανία)","(name:de,Dänemark)","(name:da,Danmark)","(name:cy,Denmarc)","(name:ca,Dinamarca)","(name:br,Danmark)","(name:bg,Дания)","(name:be,Данія)","(name:ar,الدانمرك)","(name:af,Denemarke)","(name,Danmark)"}	\N
tl	{"(official_name:vi,\\"Cộng hòa Dân chủ Đông Timor\\")","(official_name:tl,\\"Demokratikong Republika ng Silangan Timor\\")","(official_name:tet,\\"Repúblika Demokrátika Timor Lorosa'e\\")","(official_name:sv,\\"Demokratiska republiken Östtimor\\")","(official_name:ru,\\"Демократическая Республика Тимор-Лесте\\")","(official_name:pt,\\"República Democrática de Timor-Leste\\")","(official_name:pl,\\"Demokratyczna Republika Timoru Wschodniego\\")","(official_name:lt,\\"Rytų Timoro Demokratinė Respublika\\")","(official_name:lb,\\"Demokratesch Republik Timor-Leste\\")","(official_name:id,\\"Republik Demokratik Timor Leste\\")","(official_name:gd,\\"Poblachd deomocrasach Timor-Leste\\")","(official_name:et,\\"Timor-Leste Demokraatlik Vabariik\\")","(official_name:en,\\"Democratic Republic of Timor-Leste\\")","(official_name,\\"Repúblika Demokrátika Timor Lorosa'e; República Democrática de Timor-Leste\\")","(name:zh,东帝汶)","(name:vi,\\"Đông Timor\\")","(name:uk,\\"Східний Тимор\\")","(name:tr,\\"Doğu Timor\\")","(name:tl,\\"Silangan Timor\\")","(name:th,ประเทศติมอร์ตะวันออก)","(name:tet,\\"Timor Lorosa'e\\")","(name:sv,Östtimor)","(name:sl,\\"Vzhodni Timor\\")","(name:ru,Тимор-Лесте)","(name:pt,Timor-Leste)","(name:pl,\\"Timor Wschodni\\")","(name:nl,Oost-Timor)","(name:mn,\\"Зүүн Тимор\\")","(name:lt,\\"Rytų Timoras\\")","(name:li,Oos-Timor)","(name:la,\\"Timoria Orientalis\\")","(name:it,\\"Timor Est\\")","(name:is,Austur-Tímor)","(name:id,\\"Timor Leste\\")","(name:hu,Kelet-Timor)","(name:hr,\\"Istočni Timor\\")","(name:he,\\"מזרח טימור\\")","(name:gd,\\"Tiomor an Ear\\")","(name:ga,\\"An Tíomór Thoir\\")","(name:fy,East-Timor)","(name:fr,\\"Timor Oriental\\")","(name:fi,Itä-Timor)","(name:fa,\\"تیمور شرقی\\")","(name:et,Ida-Timor)","(name:eo,\\"Orienta Timoro\\")","(name:en,\\"East Timor\\")","(name:de,Osttimor)","(name:da,Østtimor)","(name:cy,\\"Dwyrain Timor\\")","(name:ca,\\"Timor Oriental\\")","(name:br,\\"Timor ar Reter\\")","(name:ar,\\"جمهورية تيمور\\")","(name:af,Oos-Timor)","(name,\\"Timor-Leste; Timor Lorosa'e\\")","(alt_name,\\"East Timor\\")"}	\N
ki	{"(official_name:sv,\\"Republiken Kiribati\\")","(official_name:pl,\\"Republika Kiribati\\")","(official_name:lv,\\"Kiribati Republika\\")","(official_name:lt,\\"Kiribačio Respublika\\")","(official_name:id,\\"Republik Kiribati\\")","(official_name:gil,\\"Ribaberikin Kiribati\\")","(official_name:es,\\"República de Kiribati\\")","(official_name:el,\\"Δημοκρατία του Κιριμπάτι\\")","(official_name,\\"Republic of Kiribati\\")","(name:zh,基里巴斯)","(name:uk,Кірибаті)","(name:th,ประเทศคิริบาส)","(name:sv,Kiribati)","(name:ru,Кирибати)","(name:pl,Kiribati)","(name:mn,Кирибати)","(name:lv,Kiribati)","(name:lt,Kiribatis)","(name:li,Kiribati-eilen)","(name:is,Kíribatí)","(name:hu,Kiribati)","(name:he,קיריבטי)","(name:ga,Cireabaití)","(name:fy,Kiribaty)","(name:fr,Kiribati)","(name:fi,Kiribati)","(name:fa,کیریباتی)","(name:eo,Kiribato)","(name:en,Kiribati)","(name:el,Κιριμπάτι)","(name:da,Kiribati)","(name:br,Kiribati)","(name:be,Кірыбаці)","(name:ar,كيريباس)","(name,Kiribati)"}	\N
lv	{"(official_name:vi,\\"Cộng hòa Latvia\\")","(official_name:sv,\\"Republiken Lettland\\")","(official_name:sk,\\"Lotyšská republika\\")","(official_name:pl,\\"Republika Łotwy\\")","(official_name:lt,\\"Latvijos Respublika\\")","(official_name:it,\\"Repubblica di Lettonia\\")","(official_name:id,\\"Republik Latvia\\")","(official_name:et,\\"Läti Vabariik\\")","(official_name:es,\\"República de Letonia\\")","(official_name:en,\\"Republic of Latvia\\")","(official_name:el,\\"Δημοκρατία της Λεττονίας\\")","(official_name:be,\\"Латвійская Рэспубліка\\")","(official_name,\\"Latvijas Republika\\")","(name:zh_pyt,Lātuōwéiyà)","(name:zh_py,Latuoweiya)","(name:zh,拉脱维亚)","(name:vi,Latvia)","(name:uk,Латвія)","(name:tr,Letonya)","(name:th,ประเทศลัตเวีย)","(name:sv,Lettland)","(name:sk,Lotyšsko)","(name:ru,Латвия)","(name:pl,Łotwa)","(name:nl,Letland)","(name:mn,Латви)","(name:li,Letland)","(name:lb,Lettland)","(name:la,Lettonia)","(name:ja,ラトビア)","(name:it,Lettonia)","(name:is,Lettland)","(name:id,Latvia)","(name:hu,Lettország)","(name:he,לטביה)","(name:gd,\\"An Laitbhe\\")","(name:ga,\\"An Laitvia\\")","(name:fy,Letlân)","(name:fr,Lettonie)","(name:fi,Latvia)","(name:fa,لتونی)","(name:et,Läti)","(name:es,Letonia)","(name:eo,Latvio)","(name:en,Latvia)","(name:el,Λεττονία)","(name:de,Lettland)","(name:da,Letland)","(name:cy,Latfia)","(name:ca,Letònia)","(name:br,Latvia)","(name:be,Латвія)","(name:ar,لاتفيا)","(name:af,Letland)","(name,Latvija)"}	\N
ly	{"(official_name:vi,\\"Đại Dân quốc Ả Rập Libya Nhân dân Xã hội Chủ nghĩa\\")","(official_name:sv,\\"Libyska arabiska Jamahiriya\\")","(official_name:ru,\\"Ливийская Арабская Джамахирия\\")","(official_name:lv,\\"Lībijas Sociālistiskā Arābu Tautas Džamāhīrija\\")","(official_name:lt,\\"Libijos Arabų Socialistinė Liaudies Džamahirija\\")","(official_name:lb,\\"Sozialistisch Libysch-Arabisch Volleks-Dschamahirija\\")","(official_name:et,\\"Suur Liibüa Araabia Sotsialistlik Rahvadžamahirija\\")","(official_name:en,\\"Great Socialist People's Libyan Arab Jamahiriya\\")","(official_name,\\"الجماهيرية العربية الليبية الشعبية الإشتراكية العظمى\\")","(name:zh-yue,利比亞)","(name:zh_pyt,Lìbǐyà)","(name:zh_py,Libiya)","(name:zh-min-nan,Libya)","(name:zh-classical,利比亞)","(name:zh,利比亚)","(name:yo,Libya)","(name:yi,ליביע)","(name:wo,Libi)","(name:war,Libya)","(name:vo,Lübän)","(name:vi,Libya)","(name:vec,Łibia)","(name:uz,Liviya)","(name:ur,لیبیا)","(name:uk,Лівія)","(name:ug,لىۋىيە)","(name:ts,Libya)","(name:tr,Libya)","(name:tl,Libya)","(name:ti,ሊቢያ)","(name:th,ประเทศลิเบีย)","(name:tg,Либия)","(name:te,లిబియా)","(name:ta,லிபியா)","(name:szl,Libijo)","(name:sw,Libya)","(name:sv,Libyen)","(name:stq,Lybien)","(name:sr,Либија)","(name:sq,Libia)","(name:so,Libya)","(name:sm,Libya)","(name:sl,Libija)","(name:sk,Líbya)","(name:simple,Libya)","(name:si,ලිබියා)","(name:sh,Libija)","(name:se,Libya)","(name:scn,Libbia)","(name:sc,Lìbia)","(name:sah,Лиибийэ)","(name:sa,लिबिया)","(name:ru,Ливия)","(name:roa-rup,Libia)","(name:ro,Libia)","(name:qu,Libya)","(name:pt,Líbia)","(name:ps,ليبيا)","(name:pnb,لبیا)","(name:pms,Libia)","(name:pl,Libia)","(name:pap,Libia)","(name:pam,Libya)","(name:os,Ливи)","(name:oc,Libia)","(name:nov,Libia)","(name:no,Libya)","(name:nn,Libya)","(name:nl,Libië)","(name:nds,Libyen)","(name:nap,Libbia)","(name:nah,Libia)","(name:ms,Libya)","(name:mr,लिबिया)","(name:mn,Ливи)","(name:ml,ലിബിയ)","(name:mk,Либија)","(name:lv,Lībija)","(name:lt,Libija)","(name:ln,Libîya)","(name:lij,Libia)","(name:li,Libië)","(name:lb,Libyen)","(name:la,Libya)","(name:kw,Libi)","(name:ku,Lîbya)","(name:ko,리비아)","(name:kn,ಲಿಬ್ಯಾ)","(name:kk,Либия)","(name:kg,Libia)","(name:kab,Libya)","(name:ka,ლიბია)","(name:jv,Libya)","(name:jbo,libgu'e)","(name:ja,リビア)","(name:it,Libia)","(name:is,Líbýa)","(name:io,Libia)","(name:ilo,Libya)","(name:ie,Libya)","(name:id,Libya)","(name:hy,Լիբիա)","(name:hu,Líbia)","(name:ht,Libi)","(name:hsb,Libyska)","(name:hr,Libija)","(name:hif,Libya)","(name:hi,लीबिया)","(name:he,לוב)","(name:haw,Libia)","(name:ha,Libya)","(name:gv,\\"Yn Leeb\\")","(name:gl,Libia)","(name:gd,Libia)","(name:ga,\\"An Libia\\")","(name:fy,Libanon)","(name:frp,Libie)","(name:fr,Libye)","(name:fi,Libya)","(name:fa,لیبی)","(name:eu,Libia)","(name:et,Liibüa)","(name:es,Libia)","(name:eo,Libio)","(name:en,Libya)","(name:el,Λιβύη)","(name:dsb,Libyska)","(name:diq,Libya)","(name:de,Libyen)","(name:da,Libyen)","(name:cy,Libya)","(name:cv,Ливи)","(name:cs,Libye)","(name:crh,Libiya)","(name:ceb,Libya)","(name:ca,Líbia)","(name:bs,Libija)","(name:br,Libia)","(name:bpy,লিবিয়া)","(name:bo,ལིའི་པི་ཡ)","(name:bn,লিবিয়া)","(name:bm,Libya)","(name:bg,Либия)","(name:be-x-old,Лібія)","(name:be,Лівія)","(name:bcl,Libya)","(name:bat-smg,Lėbėjė)","(name:az,Liviya)","(name:ast,Libia)","(name:arz,ليبيا)","(name:arc,ܠܘܒܐ)","(name:ar,ليبيا)","(name:ang,Libia)","(name:an,Libia)","(name:am,ሊቢያ)","(name:als,Libye)","(name:af,Libië)","(name:ace,Libya)","(name,\\"Libya / ليبيا\\")"}	\N
li	{"(official_name:vi,\\"Công quốc Liechtenstein\\")","(official_name:sv,\\"Furstendömet Liechtenstein\\")","(official_name:sl,\\"Kneževina Líhtenštajn\\")","(official_name:sk,\\"Lichtenštajnské kniežatstvo\\")","(official_name:ru,\\"Кня́жество Лихтенште́йн\\")","(official_name:pl,\\"Księstwo Liechtenstein\\")","(official_name:lv,\\"Lihtenšteinas Firstiste\\")","(official_name:lt,\\"Lichtenšteino Kunigaikštystė\\")","(official_name:lb,\\"Fürstentum Liechtenstein\\")","(official_name:ja,リヒテンシュタイン公国)","(official_name:it,\\"Principato del Liechtenstein\\")","(official_name:id,\\"Kepangeranan Liechtenstein\\")","(official_name:es,\\"Principado de Liechtenstein\\")","(official_name:en,\\"Principality of Liechtenstein\\")","(official_name:el,\\"Πριγκηπάτο του Λιχτενστάιν\\")","(official_name:de,\\"Fürstentum Liechtenstein\\")","(official_name:br,\\"Priñselezh Liechtenstein\\")","(official_name:be,\\"Княства Ліхтэнштэйн\\")","(official_name,\\"Fürstentum Liechtenstein\\")","(name:zh_pyt,Lièzhīdūnshìdēng)","(name:zh_py,Liezhidunshideng)","(name:zh,列支敦士登)","(name:uk,Ліхтенштейн)","(name:tr,Lihtenştayn)","(name:th,ประเทศลิกเตนสไตน์)","(name:sv,Liechtenstein)","(name:sl,Lihtenštajn)","(name:sk,Lichtenštajnsko)","(name:ru,Лихтенштейн)","(name:pl,Liechtenstein)","(name:mn,Лихтенштейн)","(name:lv,Lihtenšteina)","(name:lt,Lichtenšteinas)","(name:la,Lichtenstenum)","(name:ja,リヒテンシュタイン)","(name:is,Liechtenstein)","(name:hu,Liechtenstein)","(name:hr,Lihtenštajn)","(name:he,ליכטנשטיין)","(name:haw,Likenekaina)","(name:ga,Lichtinstéin)","(name:fy,Lychtenstein)","(name:fr,Liechtenstein)","(name:fi,Liechtenstein)","(name:fa,لیختن‌اشتاین)","(name:eo,Liĥtenŝtejno)","(name:el,Λιχτενστάιν)","(name:br,Liechtenstein)","(name:be,Ліхтэнштэйн)","(name:ar,ليختنشتاين)","(name,Liechtenstein)"}	\N
mg	{"(official_name:vi,\\"Cộng hòa Madagascar\\")","(official_name:sv,\\"Republiken Madagaskar\\")","(official_name:pl,\\"Republika Madagaskaru\\")","(official_name:lv,\\"Madagaskaras Republika\\")","(official_name:lt,\\"Madagaskaro Respublika\\")","(official_name:id,\\"Republik Madagaskar\\")","(official_name:fr,\\"République de Madagascar\\")","(official_name:es,\\"República de Madagascar\\")","(official_name:en,\\"Republic of Madagascar\\")","(official_name:el,\\"Δημοκρατία της Μαδαγασκάρης\\")","(official_name,\\"Repoblikan'i Madagasikara\\")","(name:zh_pyt,Mǎdájiāsījiā)","(name:zh_py,Madajiasijia)","(name:zh,马达加斯加)","(name:uk,Мадагаскар)","(name:tr,Madagaskar)","(name:th,ประเทศมาดากัสการ์)","(name:sv,Madagaskar)","(name:sl,Madagaskar)","(name:ru,Мадагаскар)","(name:pl,Madagaskar)","(name:nl,Madagaskar)","(name:mn,Мадагаскар)","(name:lv,Madagaskara)","(name:lt,Madagaskaras)","(name:li,Madagaskar)","(name:lb,Madagaskar)","(name:la,Madagascaria)","(name:ja,マダガスカル)","(name:it,Madagascar)","(name:is,Madagaskar)","(name:id,Madagaskar)","(name:hu,Madagaszkár)","(name:hr,Madagaskar)","(name:he,מדגסקר)","(name:haw,Madagaseka)","(name:ga,Madagascar)","(name:fy,Madagaskar)","(name:fr,Madagascar)","(name:fi,Madagaskar)","(name:fa,ماداگاسکار)","(name:et,Madagaskar)","(name:es,Madagascar)","(name:eo,Madagaskaro)","(name:en,Madagascar)","(name:el,Μαδαγασκάρη)","(name:de,Madagaskar)","(name:da,Madagaskar)","(name:br,Madagaskar)","(name:be,Мадагаскар)","(name:ar,مدغشقر)","(name:af,Madagaskar)","(name,Madagascar)"}	\N
mt	{"(official_name:vi,\\"Cộng hòa Malta\\")","(official_name:sv,\\"Republiken Malta\\")","(official_name:sk,\\"Maltská republika\\")","(official_name:lv,\\"Maltas Republika\\")","(official_name:lt,\\"Maltos Respublika\\")","(official_name:lb,\\"Republik Malta\\")","(official_name:ja,マルタ共和国)","(official_name:id,\\"Republik Malta\\")","(official_name:el,\\"Δημοκρατία της Μάλτας\\")","(name:zh_pyt,Mǎěrtā)","(name:zh_py,Maerta)","(name:zh,马尔他)","(name:uk,Мальта)","(name:th,ประเทศมอลตา)","(name:sv,Malta)","(name:sk,Malta)","(name:ru,Мальта)","(name:pl,Malta)","(name:mn,Мальта)","(name:lv,Malta)","(name:la,Melita)","(name:ja,マルタ)","(name:is,Malta)","(name:hu,Málta)","(name:he,מלטה)","(name:haw,Malata)","(name:ga,Málta)","(name:fr,Malte)","(name:fi,Malta)","(name:fa,مالت)","(name:eo,Malto)","(name:en,Malta)","(name:el,Μάλτα)","(name:ca,\\"República de Malta\\")","(name:br,Malta)","(name:be,Мальта)","(name:ar,مالطا)","(name,Malta)"}	\N
mx	{"(official_name:vi,\\"Liên bang México\\")","(official_name:sv,\\"Mexikos förenta stater\\")","(official_name:pl,\\"Meksykańskie Stany Zjednoczone\\")","(official_name:lv,\\"Meksikas Savienotās Valstis\\")","(official_name:lt,\\"Meksikos Jungtinės Valstijos\\")","(official_name:lb,\\"Vereenegt mexikanesch Staaten\\")","(official_name:ja,メキシコ合衆国)","(official_name:it,\\"Stati Uniti Messicani\\")","(official_name:id,\\"Persatuan Negara-Negara Meksiko\\")","(official_name:et,\\"Mehhiko Ühendriigid\\")","(official_name:el,\\"Ηνωμένες Πολιτείες του Μεξικού\\")","(official_name:br,\\"Stadoù Unanet Mec’hiko\\")","(official_name:be,\\"Мексіканскія Злучаныя Штаты\\")","(official_name,\\"Estados Unidos Mexicanos\\")","(name:zh,墨西哥)","(name:uk,Мексика)","(name:tr,Meksika)","(name:th,ประเทศเม็กซิโก)","(name:sv,Mexiko)","(name:sl,Mehika)","(name:ru,Мексика)","(name:pl,Meksyk)","(name:nl,Mexico)","(name:mn,Мексик)","(name:lv,Meksika)","(name:lt,Meksika)","(name:li,Mexico)","(name:lb,Mexiko)","(name:la,Mexicum)","(name:ja,メキシコ)","(name:it,Messico)","(name:is,Mexíkó)","(name:id,Meksiko)","(name:hu,Mexikó)","(name:hr,Meksiko)","(name:he,מקסיקו)","(name:gd,Meagsago)","(name:ga,Meicsiceo)","(name:fy,Meksiko)","(name:fr,Mexique)","(name:fi,Meksiko)","(name:fa,مکزیک)","(name:et,Mehhiko)","(name:es,México)","(name:eo,Meksiko)","(name:en,Mexico)","(name:el,Μεξικό)","(name:de,Mexiko)","(name:da,Mexico)","(name:cy,Mexico)","(name:ca,Mèxic)","(name:br,Mec’hiko)","(name:be,Мексіка)","(name:ar,المكسيك)","(name:af,Meksiko)","(name,México)"}	\N
mn	{"(official_name:pl,\\"Republika Mongolska\\")","(name:zh,蒙古国)","(name:vi,\\"Mông Cổ\\")","(name:uk,Монголія)","(name:tr,Moğolistan)","(name:th,ประเทศมองโกเลีย)","(name:sv,Mongoliet)","(name:sl,Mongolija)","(name:ru,Монголия)","(name:pt,Mongólia)","(name:pl,Mongolia)","(name:nl,Mongolië)","(name:mn,\\"Монгол Улс\\")","(name:lv,Mongolija)","(name:lt,Mongolija)","(name:li,Mongolië)","(name:lb,Mongolei)","(name:la,Mogolia)","(name:ja,モンゴル)","(name:it,Mongolia)","(name:is,Mongólía)","(name:id,Mongolia)","(name:hu,Mongólia)","(name:hr,Mongolija)","(name:he,מונגוליה)","(name:haw,Monokolia)","(name:gd,Mongòilia)","(name:ga,\\"An Mhongóil\\")","(name:fy,Mongoalje)","(name:fr,Mongolie)","(name:fi,Mongolia)","(name:fa,مغولستان)","(name:et,Mongoolia)","(name:es,Mongolia)","(name:eo,Mongolio)","(name:en,Mongolia)","(name:el,Μογγολία)","(name:de,Mongolei)","(name:da,Mongoliet)","(name:cy,Mongolia)","(name:ca,Mongòlia)","(name:br,Mongolia)","(name:be,Манголія)","(name:az,Monqolustan)","(name:ar,منغوليا)","(name:af,Mongolië)","(name,\\"Монгол Улс\\")"}	\N
pl	{"(official_name:vi,\\"Cộng hòa Ba Lan\\")","(official_name:sv,\\"Republiken Polen\\")","(official_name:sk,\\"Poľská republika\\")","(official_name:ru,\\"Респу́блика По́льша\\")","(official_name:nl,\\"Republiek Polen\\")","(official_name:lt,\\"Lenkijos Respublika\\")","(official_name:ja,ポーランド共和国)","(official_name:it,\\"Repubblica di Polonia\\")","(official_name:fr,\\"République de Pologne\\")","(official_name:et,\\"Poola Vabariik\\")","(official_name:es,\\"República Polaca\\")","(official_name:eo,\\"Pola Respubliko\\")","(official_name:en,\\"Republic of Poland\\")","(official_name:el,\\"Δημοκρατία της Πολωνίας\\")","(official_name:be,\\"Рэспубліка Польшча\\")","(official_name,\\"Rzeczpospolita Polska\\")","(name:zh_pyt,Bōlán)","(name:zh_py,Bolan)","(name:zh,波兰)","(name:vi,\\"Ba Lan\\")","(name:uk,Польща)","(name:tr,Polonya)","(name:th,ประเทศโปแลนด์)","(name:sv,Polen)","(name:sl,Poljska)","(name:sk,Poľsko)","(name:ru,Польша)","(name:pl,Polska)","(name:no,Polen)","(name:nl,Polen)","(name:mn,Польш)","(name:lv,Polija)","(name:lt,Lenkija)","(name:li,Pole)","(name:lb,Polen)","(name:la,Polonia)","(name:ja,ポーランド)","(name:it,Polonia)","(name:is,Pólland)","(name:id,Polandia)","(name:hy,Լեհաստան)","(name:hu,Lengyelország)","(name:hr,Poljska)","(name:he,פולין)","(name:haw,Pōlani)","(name:gd,\\"A' Phòlainn\\")","(name:ga,\\"An Pholainn\\")","(name:fy,Poalen)","(name:fr,Pologne)","(name:fi,Puola)","(name:fa,لهستان)","(name:et,Poola)","(name:es,Polonia)","(name:eo,Pollando)","(name:en,Poland)","(name:el,Πολωνία)","(name:de,Polen)","(name:da,Polen)","(name:cy,\\"Gwlad Pwyl\\")","(name:ca,Polònia)","(name:br,Polonia)","(name:be,Польшча)","(name:ar,بولندا)","(name:af,Pole)","(name,Polska)"}	\N
qa	{"(official_name:sv,\\"Staten Qatar\\")","(official_name:pt,\\"Estado do Qatar\\")","(official_name:lv,\\"Kataras Valsts\\")","(official_name:lt,\\"Kataro Valstybė\\")","(official_name:ja,カタール国)","(official_name:id,\\"Negara Qatar\\")","(official_name:el,\\"Κράτος του Κατάρ\\")","(official_name,\\"دولة قطر\\")","(name:zh_pyt,Kǎtǎěr)","(name:zh_py,Kataer)","(name:zh,卡塔尔)","(name:vi,Qatar)","(name:uk,Катар)","(name:tr,Katar)","(name:th,ประเทศกาตาร์)","(name:sv,Qatar)","(name:sl,Katar)","(name:ru,Катар)","(name:pt,Qatar)","(name:pl,Katar)","(name:nl,Qatar)","(name:mn,Катар)","(name:lv,Katara)","(name:lt,Kataras)","(name:li,Katar)","(name:lb,Katar)","(name:la,Quataria)","(name:ja,カタール)","(name:it,Qatar)","(name:is,Katar)","(name:id,Qatar)","(name:hu,Katar)","(name:hr,Katar)","(name:he,קטר)","(name:haw,Katala)","(name:gd,Catar)","(name:ga,Catar)","(name:fy,Katar)","(name:fr,Qatar)","(name:fi,Qatar)","(name:fa,قطر)","(name:et,Katar)","(name:es,Qatar)","(name:eo,Kataro)","(name:en,Qatar)","(name:el,Κατάρ)","(name:de,Katar)","(name:da,Qatar)","(name:cy,Qatar)","(name:ca,Qatar)","(name:br,Katar)","(name:be,Катар)","(name:ar,قطر)","(name:af,Katar)","(name,\\"قطر Qatar\\")"}	\N
cg	{"(official_name:sv,\\"Republiken Kongo\\")","(official_name:sl,\\"Republika Kongo\\")","(official_name:lv,\\"Kongo Republika\\")","(official_name:gd,\\"Poblachd na Congo\\")","(official_name:fr,\\"République du Congo\\")","(name:zh,刚果共和国)","(name:vi,\\"Cộng hòa Congo\\")","(name:uk,\\"Республіка Конго\\")","(name:tr,\\"Kongo Cumhuriyeti\\")","(name:th,สาธารณรัฐคองโก)","(name:sv,Kongo)","(name:sl,Kongo)","(name:ru,\\"Республика Конго\\")","(name:pl,Kongo)","(name:nl,\\"Republiek Congo\\")","(name:mn,\\"Бүгд Найрамдах Конго\\")","(name:lv,Kongo)","(name:lt,\\"Kongo Respublika\\")","(name:ln,\\"Republiki ya Kongó\\")","(name:li,\\"Rippebliek vaan de Kongo\\")","(name:lb,\\"Republik Kongo\\")","(name:la,\\"Respublica Congensis\\")","(name:kg,\\"Repubilika ya Kongo\\")","(name:it,\\"Repubblica del Congo\\")","(name:is,Vestur-Kongó)","(name:id,\\"Republik Kongo\\")","(name:hu,Kongó)","(name:hr,\\"Republika Kongo\\")","(name:he,קונגו)","(name:gd,\\"A' Chongo\\")","(name:ga,\\"Poblacht an Chongó\\")","(name:fy,\\"Republyk de Kongo\\")","(name:fr,\\"République du Congo\\")","(name:fi,\\"Kongon tasavalta\\")","(name:fa,\\"جمهوری کنگو\\")","(name:et,\\"Kongo Vabariik\\")","(name:es,\\"República del Congo\\")","(name:eo,\\"Respubliko Kongo\\")","(name:en,\\"Republic of the Congo\\")","(name:el,\\"Δημοκρατία του Κονγκό\\")","(name:de,\\"Republik Kongo\\")","(name:da,\\"Republikken Congo\\")","(name:cy,\\"Gweriniaeth y Congo\\")","(name:ca,\\"República del Congo\\")","(name:br,\\"Republik Kongo\\")","(name:ar,\\"جمهورية الكونغو الديمقراطية\\")","(name:af,\\"Republiek van die Kongo\\")","(name,\\"République du Congo\\")","(alt_name,\\"Congo-Brazzaville;Congo (Brazzaville);Congo\\")"}	\N
ro	{"(name:zh_pyt,Luómăníyà)","(name:zh_py,Luomaniya)","(name:zh,罗马尼亚)","(name:vi,Romania)","(name:uk,Румунія)","(name:tr,Romanya)","(name:th,ประเทศโรมาเนีย)","(name:sv,Rumänien)","(name:sl,Romunija)","(name:sk,Rumunsko)","(name:ru,Румыния)","(name:ro,România)","(name:pl,Rumunia)","(name:nl,Roemenië)","(name:mn,Румын)","(name:lv,Rumānija)","(name:lt,Rumunija)","(name:li,Roemenië)","(name:lb,Rumänien)","(name:la,Romania)","(name:ja,ルーマニア)","(name:it,Romania)","(name:is,Rúmenía)","(name:id,Rumania)","(name:hu,Románia)","(name:hr,Rumunjska)","(name:he,רומניה)","(name:haw,Romānia)","(name:gd,Ròmainia)","(name:ga,\\"An Rómáin\\")","(name:fy,Roemeenje)","(name:fr,Roumanie)","(name:fi,Romania)","(name:fa,رومانی)","(name:et,Rumeenia)","(name:es,Rumania)","(name:eo,Rumanio)","(name:en,Romania)","(name:el,Ρουμανία)","(name:de,Rumänien)","(name:da,Rumænien)","(name:cy,Rwmania)","(name:ca,Romania)","(name:br,Roumania)","(name:be,Румынія)","(name:ar,رومانيا)","(name:af,Roemenië)","(name,România)"}	\N
vc	{"(name:zh,圣文森特和格林纳丁斯)","(name:vi,\\"Saint Vincent và Grenadines\\")","(name:uk,\\"Сент-Вінсент і Гренадини\\")","(name:tr,\\"Saint Vincent ve Grenadinler\\")","(name:th,ประเทศเซนต์วินเซนต์และเกรนาดีนส์)","(name:sv,\\"Saint Vincent och Grenadinerna\\")","(name:ru,\\"Сент-Винсент и Гренадины\\")","(name:pt,\\"São Vicente e Granadinas\\")","(name:pl,\\"Saint Vincent i Grenadyny\\")","(name:nl,\\"Saint Vincent en de Grenadines\\")","(name:mn,\\"Сент-Винсент ба Гренадин\\")","(name:lt,\\"Sent Vinsentas ir Grenadinai\\")","(name:li,Saint-Vincent)","(name:lb,\\"Saint Vincent an d’Grenadinen\\")","(name:ja,セントビンセント及びグレナディーン諸島)","(name:it,\\"Saint Vincent e Grenadine\\")","(name:is,\\"Sankti Vinsent og Grenadíneyjar\\")","(name:id,\\"Saint Vincent dan Grenadines\\")","(name:hu,\\"Saint Vincent és a Grenadine-szigetek\\")","(name:hr,\\"Sveti Vincent i Grenadini\\")","(name:he,\\"סנט וינסנט והגרנדינים\\")","(name:gd,\\"Naomh Bhionsant agus Eileanan Greanadach\\")","(name:ga,\\"San Uinseann agus na Greanáidíní\\")","(name:fy,\\"Sint Finsint en de Grenadinen\\")","(name:fr,\\"Saint-Vincent-et-les Grenadines\\")","(name:fi,\\"Saint Vincent ja Grenadiinit\\")","(name:fa,\\"سنت وینسنت و گرنادین\\")","(name:es,\\"San Vicente y las Granadinas\\")","(name:eo,\\"Sankta Vincento kaj Grenadinoj\\")","(name:en,\\"Saint Vincent and the Grenadines\\")","(name:de,\\"Saint Vincent und die Grenadinen\\")","(name:da,\\"Saint Vincent og Grenadinerne\\")","(name:cy,\\"Saint Vincent a'r Grenadines\\")","(name:ca,\\"Saint Vincent i les Grenadines\\")","(name:br,\\"Saint Vincent ha Grenadines\\")","(name:be,\\"Святы Вінцэнт і Грэнадзіны\\")","(name:ar,\\"سانت فنسنت وجزر غرينادين\\")","(name:af,\\"Sint Vincent en die Grenadines\\")","(name,\\"Saint Vincent and the Grenadines\\")"}	\N
sn	{"(official_name:vi,\\"Cộng hoà Sénégal\\")","(official_name:sv,\\"Republiken Senegal\\")","(official_name:pt,\\"República do Senegal\\")","(official_name:lt,\\"Senegalo Respublika\\")","(official_name:ja,セネガル共和国)","(official_name:id,\\"Republik Senegal\\")","(official_name:gd,\\"Poblachd Sheanagail\\")","(official_name:et,\\"Senegali Vabariik\\")","(official_name:el,\\"Δημοκρατία της Σενεγάλης\\")","(official_name:ca,\\"República del Senegal\\")","(official_name:be,\\"Рэспубліка Сенегал\\")","(official_name,\\"République du Sénégal\\")","(name:zh_pyt,Sàinèijiāěr)","(name:zh_py,Saineijiaer)","(name:zh,塞内加尔)","(name:uk,Сенегал)","(name:tr,Senegal)","(name:th,ประเทศเซเนกัล)","(name:sv,Senegal)","(name:sl,Senegal)","(name:ru,Сенегал)","(name:pt,Senegal)","(name:pl,Senegal)","(name:nl,Senegal)","(name:mn,Сенегал)","(name:lv,Senegāla)","(name:lt,Senegalas)","(name:li,Senegal)","(name:lb,Senegal)","(name:la,Senegalia)","(name:ja,セネガル)","(name:it,Senegal)","(name:is,Senegal)","(name:id,Senegal)","(name:hu,Szenegál)","(name:hr,Senegal)","(name:he,סנגל)","(name:haw,Senekala)","(name:gd,Seanagal)","(name:ga,\\"An tSeineagáil\\")","(name:fy,Senegal)","(name:fr,Sénégal)","(name:fi,Senegal)","(name:fa,سنگال)","(name:et,Senegal)","(name:es,Senegal)","(name:eo,Senegaleo)","(name:en,Senegal)","(name:el,Σενεγάλη)","(name:de,Senegal)","(name:da,Senegal)","(name:cy,Sénégal)","(name:ca,Senegal)","(name:br,Senegal)","(name:be,Сенегал)","(name:ar,السنغال)","(name:af,Senegal)","(name,Sénégal)"}	\N
sk	{"(official_name:vi,\\"Cộng hòa Slovakia\\")","(official_name:sv,\\"Republiken Slovakien\\")","(official_name:pt,\\"República Eslovaca\\")","(official_name:lt,\\"Slovakijos Respublika\\")","(official_name:id,\\"Republik Slowakia\\")","(official_name:fr,\\"République slovaque\\")","(official_name:et,\\"Slovaki Vabariik\\")","(official_name:el,\\"Δημοκρατία της Σλοβακίας\\")","(name:zh_pyt,Sīluòfákè)","(name:zh_py,Siluofake)","(name:zh,斯洛伐克)","(name:vi,Slovakia)","(name:uk,Словаччина)","(name:tr,Slovakya)","(name:th,ประเทศสโลวาเกีย)","(name:sv,Slovakien)","(name:sl,Slovaška)","(name:sk,\\"Slovenská republika\\")","(name:ru,Словакия)","(name:pt,Eslováquia)","(name:pl,Słowacja)","(name:nl,Slowakije)","(name:mn,Словак)","(name:lt,Slovakija)","(name:li,Slowakieë)","(name:lb,Slowakei)","(name:la,Slovacia)","(name:it,Slovacchia)","(name:is,Slóvakía)","(name:id,Slowakia)","(name:hu,Szlovákia)","(name:hr,Slovačka)","(name:he,סלובקיה)","(name:haw,Solowakia)","(name:gd,\\"An t-Slòbhac\\")","(name:ga,\\"An tSlóvaic\\")","(name:fy,Slowakije)","(name:fr,Slovaquie)","(name:fi,Slovakia)","(name:fa,اسلواکی)","(name:et,Slovakkia)","(name:es,Eslovaquia)","(name:eo,Slovakio)","(name:en,Slovakia)","(name:el,Σλοβακία)","(name:de,Slowakei)","(name:da,Slovakiet)","(name:cy,Slofacia)","(name:ca,Eslovàquia)","(name:br,Slovakia)","(name:be,Славакія)","(name:ar,\\"جمهورية سلوفاكيا\\")","(name:af,Slowakye)","(name,Slovensko)"}	\N
ua	{"(name:zh_pyt,Wūkèlán)","(name:zh_py,Wukelan)","(name:zh,乌克兰)","(name:vi,Ukraina)","(name:uk,Україна)","(name:tr,Ukrayna)","(name:th,ประเทศยูเครน)","(name:sv,Ukraina)","(name:sl,Ukrajina)","(name:sk,Ukrajina)","(name:ru,Украина)","(name:pt,Ucrânia)","(name:pl,Ukraina)","(name:nl,Oekraïne)","(name:mn,Украйн)","(name:lv,Ukraina)","(name:lt,Ukraina)","(name:li,\\"De Oekraïne\\")","(name:lb,Ukraine)","(name:la,Ucraina)","(name:ja,ウクライナ)","(name:it,Ucraina)","(name:is,Úkraína)","(name:id,Ukraina)","(name:hu,Ukrajna)","(name:hr,Ukrajina)","(name:he,אוקראינה)","(name:haw,‘Ukelena)","(name:gd,\\"An Ùcrain\\")","(name:ga,\\"An Úcráin\\")","(name:fy,\\"de Oekraïne\\")","(name:fr,Ukraine)","(name:fi,Ukraina)","(name:fa,اوکراین)","(name:et,Ukraina)","(name:es,Ucrania)","(name:eo,Ukrainio)","(name:en,Ukraine)","(name:el,Ουκρανία)","(name:de,Ukraine)","(name:da,Ukraine)","(name:cy,Wcráin)","(name:ca,Ucraïna)","(name:br,Ukraina)","(name:be,Украіна)","(name:ar,أوكرانيا)","(name:af,Oekraïne)","(name,Україна)"}	\N
uy	{"(official_name:sv,\\"Republiken Uruguay\\")","(official_name:pt,\\"República Oriental do Uruguai\\")","(official_name:pl,\\"Wschodnia Republika Urugwaju\\")","(official_name:lt,\\"Urugvajaus Rytų Respublika\\")","(official_name:lb,\\"Republik östlich vum Uruguay\\")","(official_name:id,\\"Republik Timur Uruguay\\")","(official_name:fr,\\"République orientale de l'Uruguay\\")","(official_name:es,\\"República Oriental del Uruguay\\")","(official_name:br,\\"Republik-Reter Uruguay\\")","(official_name,\\"Oriental Republic of Uruguay\\")","(name:zh,乌拉圭)","(name:uk,Уругвай)","(name:th,ประเทศอุรุกวัย)","(name:sv,Uruguay)","(name:sl,Urugvaj)","(name:ru,Уругвай)","(name:pt,Uruguai)","(name:pl,Urugwaj)","(name:mn,Уругвай)","(name:lv,Urugvaja)","(name:lt,Urugvajus)","(name:li,Urugay)","(name:la,Uruguaia)","(name:ja,ウルグアイ)","(name:is,Úrúgvæ)","(name:hu,Uruguay)","(name:hr,Urugvaj)","(name:he,אורוגואי)","(name:gd,Uruguaidh)","(name:ga,Uragua)","(name:fy,Urûguay)","(name:fr,Uruguay)","(name:fi,Uruguay)","(name:fa,اروگوئه)","(name:eo,Urugvajo)","(name:en,Uruguay)","(name:el,Ουρουγουάη)","(name:da,Uruguay)","(name:ca,Uruguai)","(name:br,Uruguay)","(name:be,Уругвай)","(name:ar,أوروغواي)","(name,Uruguay)"}	\N
zm	{"(official_name:sv,\\"Republiken Zambia\\")","(official_name:pt,\\"República da Zâmbia\\")","(official_name:lt,\\"Zambijos Respublika\\")","(official_name:lb,\\"Republik Sambia\\")","(official_name:ja,ザンビア共和国)","(official_name:id,\\"Republik Zambia\\")","(official_name:gd,\\"Poblachd Shaimbia\\")","(official_name:et,\\"Sambia Vabariik\\")","(official_name:el,\\"Δημοκρατία της Ζάμπιας\\")","(official_name,\\"Republic of Zambia\\")","(name:zh_pyt,Zànbǐyà)","(name:zh_py,Zanbiya)","(name:zh,赞比亚)","(name:uk,Замбія)","(name:tr,Zambiya)","(name:th,ประเทศแซมเบีย)","(name:sv,Zambia)","(name:sl,Zambija)","(name:ru,Замбия)","(name:pt,Zâmbia)","(name:pl,Zambia)","(name:mn,Замби)","(name:lv,Zambija)","(name:lt,Zambija)","(name:lb,Sambia)","(name:ja,ザンビア)","(name:it,Zambia)","(name:is,Sambía)","(name:hu,Zambia)","(name:he,זמביה)","(name:haw,Zamibia)","(name:gd,Saimbia)","(name:ga,\\"An tSaimbia\\")","(name:fy,Sambia)","(name:fr,Zambie)","(name:fi,Sambia)","(name:fa,زامبیا)","(name:et,Sambia)","(name:es,Zambia)","(name:eo,Zambio)","(name:en,Zambia)","(name:el,Ζάμπια)","(name:de,Sambia)","(name:ca,Zàmbia)","(name:br,Zambia)","(name:be,Замбія)","(name:ar,زامبيا)","(name:af,Zambië)","(name,Zambia)"}	\N
ai	{"(name:zh,安圭拉)","(name:uk,Ангілья)","(name:th,แองกวิลลา)","(name:sv,Anguilla)","(name:sl,Angvila)","(name:ru,Ангилья)","(name:pl,Anguilla)","(name:mn,Ангилья)","(name:lv,Angilja)","(name:lt,Angilija)","(name:is,Angvilla)","(name:hu,Anguilla)","(name:hr,Angvila)","(name:he,אנגווילה)","(name:ga,Angaíle)","(name:fr,Anguilla)","(name:fi,Anguilla)","(name:fa,آنگویلا)","(name:eu,Angila)","(name:es,Anguila)","(name:eo,Angvilo)","(name:en,Anguilla)","(name:el,Ανγκουίλα)","(name:br,Anguilla)","(name:az,Angilya)","(name:ar,أنجويلا)","(name,Anguilla)"}	\N
bm	{"(name:zh,百慕大)","(name:uk,\\"Бермудські острови\\")","(name:th,เบอร์มิวดา)","(name:sv,Bermuda)","(name:sl,Bermudi)","(name:ru,Бермуды)","(name:pt,Bermuda)","(name:pl,Bermudy)","(name:mn,\\"Бермудын Арал\\")","(name:lv,\\"Bermudu salas\\")","(name:is,Bermúda)","(name:hu,Bermuda)","(name:he,ברמודה)","(name:ga,Beirmiúda)","(name:fr,Bermudes)","(name:fi,Bermuda)","(name:fa,برمودا)","(name:eo,Bermudo)","(name:en,Bermuda)","(name:el,Βερμούδες)","(name:da,Bermuda)","(name:ca,Bermudes)","(name:br,Bermuda)","(name:be,Бярмуды)","(name:ar,برمودا)","(name,Bermuda)"}	\N
cx	{"(official_name:pl,\\"Terytorium Wyspy Bożego Narodzenia\\")","(official_name:lv,\\"Ziemsvētku salas teritorija\\")","(official_name:es,\\"Territorio de la Isla de Navidad\\")","(official_name,\\"Territory of Christmas Island\\")","(name:zh-min-nan,Christmas-tó)","(name:zh,圣诞岛)","(name:wo,\\"Dunu Christmas\\")","(name:vi,\\"Đảo Christmas\\")","(name:uk,\\"Острів Різдва\\")","(name:tr,\\"Christmas Adası\\")","(name:th,เกาะคริสต์มาส)","(name:ta,\\"கிறிஸ்துமசு தீவு\\")","(name:sw,\\"Kisiwa cha Krismasi\\")","(name:sv,Julön)","(name:sr,\\"Божићно Острво\\")","(name:sl,\\"Božični otoki\\")","(name:sk,\\"Vianočný ostrov\\")","(name:sh,\\"Božićni otok\\")","(name:ru,\\"Остров Рождества\\")","(name:ro,\\"Insula Crăciunului\\")","(name:pt,\\"Ilha Christmas\\")","(name:pl,\\"Wyspa Bożego Narodzenia\\")","(name:no,Christmasøya)","(name:nn,Christmasøya)","(name:nl,Christmaseiland)","(name:ms,\\"Pulau Krismas\\")","(name:mr,\\"क्रिसमस द्वीप\\")","(name:mn,\\"Зул Сарын Арал\\")","(name:lv,\\"Ziemsvētku sala\\")","(name:lt,\\"Kalėdų sala\\")","(name:lij,\\"Isoa Christmas\\")","(name:lb,Chrëschtdagsinsel)","(name:kw,\\"Ynys Nadelik\\")","(name:ko,\\"크리스마스 섬\\")","(name:kk,\\"Кристмас аралы\\")","(name:ka,\\"შობის კუნძული\\")","(name:ja,クリスマス島)","(name:it,\\"Isola del Natale\\")","(name:is,Jólaeyja)","(name:id,\\"Pulau Natal\\")","(name:hu,Karácsony-sziget)","(name:hr,\\"Božićni otok\\")","(name:hi,\\"क्रिसमस आईलैंड\\")","(name:he,\\"טריטוריית האי חג המולד\\")","(name:gl,\\"Illa de Nadal\\")","(name:ga,\\"Oileán na Nollag\\")","(name:fy,Krysteilân)","(name:fr,\\"Île Christmas\\")","(name:fi,Joulusaari)","(name:fa,\\"جزیره کریسمس\\")","(name:eu,\\"Christmas uhartea\\")","(name:et,Jõulusaar)","(name:es,\\"Isla de Navidad\\")","(name:eo,Kristnaskinsulo)","(name:el,\\"Νήσος των Χριστουγέννων\\")","(name:de,Weihnachtsinsel)","(name:da,Juleøen)","(name:cy,\\"Ynys y Nadolig\\")","(name:cs,\\"Vánoční ostrov\\")","(name:ca,\\"Illa Christmas\\")","(name:bs,\\"Božićno ostrvo\\")","(name:br,\\"Enez Nedeleg\\")","(name:bpy,\\"ক্রিসমাস দ্বীপমালা\\")","(name:bg,Рождество)","(name:ar,\\"جزيرة الميلاد\\")","(name:af,Christmas-eiland)","(name,\\"Christmas Island\\")"}	\N
gp	{"(official_name:lv,\\"Francijas Gvadelupas departaments\\")","(name:zh,瓜德罗普)","(name:uk,Гваделупа)","(name:th,กวาเดอลูป)","(name:sv,Guadeloupe)","(name:ru,Гваделупа)","(name:pl,Gwadelupa)","(name:mn,Гуаделупе)","(name:lv,Gvadelupa)","(name:lt,Gvadelupa)","(name:la,Guadalupa)","(name:it,Guadalupa)","(name:is,Gvadelúpeyjar)","(name:hu,Guadeloupe)","(name:hr,Gvadalupa)","(name:he,גוואדלופ)","(name:ga,Guadalúip)","(name:fy,Guadelûp)","(name:fr,Guadeloupe)","(name:fi,Guadeloupe)","(name:fa,گوادلوپ)","(name:es,Guadalupe)","(name:eo,Gvadelupo)","(name:en,Guadeloupe)","(name:el,Γουαδελούπη)","(name:da,Guadeloupe)","(name:ca,\\"Illa de Guadalupe\\")","(name:br,Gwadeloup)","(name:be,Гвадэлупа)","(name:ar,غوادلوب)","(name,Guadeloupe)"}	\N
je	{"(name:zh_pyt,\\"Zéxī Dǎo\\")","(name:zh_py,\\"Zexi Dao\\")","(name:zh,泽西岛)","(name:uk,Джерсі)","(name:th,เจอร์ซีย์)","(name:sv,Jersey)","(name:sk,Jersey)","(name:ru,Джерси)","(name:pl,Jersey)","(name:mn,Жерси)","(name:lv,Džērsija)","(name:lt,Džersis)","(name:la,Andium)","(name:is,Jersey)","(name:hu,Jersey)","(name:he,ג'רזי)","(name:ga,Geirsí)","(name:fr,Jersey)","(name:fi,Jersey)","(name:eo,Jersey)","(name:el,Τζέρσεϊ)","(name:br,Jerzenez)","(name:be,Джэрсі)","(name:ar,جيرسي)","(name,Jersey)"}	\N
nc	{"(official_name:lv,\\"Jaunkaledonija un piederīgās teritorijas\\")","(official_name:es,\\"Colectividad de Ultramar francesa de Nueva Caledonia\\")","(name:zh,新喀里多尼亚)","(name:uk,\\"Нова Каледонія\\")","(name:tr,\\"Yeni Kaledonya\\")","(name:th,นิวแคลิโดเนีย)","(name:sv,\\"Nya Kaledonien\\")","(name:sl,\\"Nova Kaledonija\\")","(name:ru,\\"Новая Каледония\\")","(name:pl,\\"Nowa Kaledonia\\")","(name:nl,Nieuw-Caledonië)","(name:mn,\\"Шинэ Каледони\\")","(name:lv,Jaunkaledonija)","(name:lt,\\"Naujoji Kaledonija\\")","(name:la,\\"Nova Caledonia\\")","(name:it,\\"Nuova Caledonia\\")","(name:is,Nýja-Kaledónía)","(name:id,\\"Kaledonia Baru\\")","(name:hu,Új-Kaledónia)","(name:hr,\\"Nova Kaledonija\\")","(name:he,\\"קלדוניה החדשה\\")","(name:ga,\\"An Nua-Chaladóin\\")","(name:fr,Nouvelle-Calédonie)","(name:fi,Uusi-Kaledonia)","(name:fa,\\"کالدونیای جدید\\")","(name:es,\\"Nueva Caledonia\\")","(name:eo,Nov-Kaledonio)","(name:en,\\"New Caledonia\\")","(name:el,\\"Νέα Καληδονία\\")","(name:de,Neukaledonien)","(name:da,\\"Ny Kaledonien\\")","(name:cy,\\"Caledonia Newydd\\")","(name:ca,\\"Nova Caledònia\\")","(name:br,\\"Kaledonia Nevez\\")","(name:be,\\"Новая Каледонія\\")","(name:ar,\\"كاليدونيا الجديدة\\")","(name:af,Nieu-Caledonia)","(name,Nouvelle-Calédonie)"}	\N
nu	{"(official_name:sv,\\"Republiken Niue\\")","(official_name:lt,\\"Niujės Respublika\\")","(name:zh,紐埃)","(name:uk,Ніуе)","(name:th,นีอูเอ)","(name:sv,Niue)","(name:ru,Ниуэ)","(name:pl,Niue)","(name:niu,Niuē-fekai)","(name:mn,Ниуэ)","(name:lv,Niue)","(name:lt,Niujė)","(name:is,Niue)","(name:hu,Niue)","(name:he,ניואה)","(name:ga,Niue)","(name:fy,Niûé)","(name:fr,Niue)","(name:fi,Niue)","(name:fa,نیووی)","(name:eo,Niuo)","(name:en,Niue)","(name:el,Νιούε)","(name:da,Niue)","(name:br,Niue)","(name:be,Ніўэ)","(name:ar,نيوي)","(name,Niue)","(alt_name,\\"Rock of Polynesia\\")"}	\N
tk	{"(name:zh,托克劳)","(name:uk,Токелау)","(name:th,โตเกเลา)","(name:sv,Tokelauöarna)","(name:ru,Токелау)","(name:pl,Tokelau)","(name:mn,Токелау)","(name:is,Tókelá)","(name:hu,Tokelau-szigetek)","(name:he,טוקלאו)","(name:ga,\\"Oileáin Tócalá\\")","(name:fy,Tokelaû)","(name:fr,Tokelau)","(name:fi,Tokelau)","(name:fa,توکلائو)","(name:eo,Tokelao)","(name:en,Tokelau)","(name:el,Τοκελάου)","(name:da,Tokelau)","(name:br,Tokelau)","(name:be,Такелаў)","(name:ar,توكلو)","(name,Tokelau)"}	\N
cd	{"(old_name,\\"Congo Free State;Belgian Congo;Congo-Léopoldville;Congo-Kinshasa;Zaire\\")","(official_name:fr,\\"République démocratique du Congo\\")","(name:zh,刚果民主共和国)","(name:vi,\\"Cộng hòa Dân chủ Congo\\")","(name:uk,\\"Демократична Республіка Конго\\")","(name:tr,\\"Demokratik Kongo Cumhuriyeti\\")","(name:th,สาธารณรัฐประชาธิปไตยคองโก)","(name:sw,\\"Jamhuri ya Kidemokrasia ya Kongo\\")","(name:sv,\\"Demokratiska republiken Kongo\\")","(name:sl,\\"Demokratična republika Kongo\\")","(name:ru,\\"Демократическая Республика Конго\\")","(name:pl,\\"Demokratyczna Republika Konga\\")","(name:nl,\\"Democratische Republiek Congo\\")","(name:mn,\\"Бүгд Найрамдах Ардчилсан Конго\\")","(name:lv,\\"Kongo Demokrātiskā Republika\\")","(name:lua,\\"Ditunga dia Kongu wa Mungalaata\\")","(name:lt,\\"Kongo Demokratinė Respublika\\")","(name:ln,\\"Republiki ya Kongó Demokratiki\\")","(name:li,\\"Democratische Rippebliek vaan de Kongo\\")","(name:lb,\\"Demokratesch Republik Kongo\\")","(name:la,\\"Respublica Popularis Congensis\\")","(name:kg,\\"Repubilika ya Kongo Demokratiki\\")","(name:it,\\"Repubblica Democratica del Congo\\")","(name:is,Vestur-Kongó)","(name:id,\\"Republik Demokratik Kongo\\")","(name:hu,\\"Kongói Demokratikus Köztársaság\\")","(name:hr,\\"Demokratska Republika Kongo\\")","(name:he,\\"הרפובליקה הדמוקרטית של קונגו\\")","(name:gd,\\"Poblachd Dheamocrach na Congo\\")","(name:ga,\\"Poblacht Dhaonlathach an Chongó\\")","(name:fy,\\"Demokratyske Republyk de Kongo\\")","(name:fr,\\"République démocratique du Congo\\")","(name:fi,\\"Kongon demokraattinen tasavalta\\")","(name:fa,\\"جمهوری دموکراتیک کنگو\\")","(name:et,\\"Kongo Demokraatlik Vabariik\\")","(name:es,\\"República Democrática del Congo\\")","(name:eo,\\"Demokratia Respubliko Kongo\\")","(name:en,\\"Democratic Republic of the Congo\\")","(name:el,\\"Λαϊκή Δημοκρατία του Κονγκό\\")","(name:de,\\"Demokratische Republik Kongo\\")","(name:da,\\"Demokratiske Republik Congo\\")","(name:cy,\\"Gweriniaeth Ddemocrataidd Congo\\")","(name:ca,\\"República Democràtica del Congo\\")","(name:br,\\"Republik Demokratel Kongo\\")","(name:ar,الكونغو)","(name:af,\\"Demokratiese Republiek van die Kongo\\")","(name,\\"République Démocratique du Congo\\")","(alt_name,\\"Congo-Kinshasa;Congo (Kinshasa);Congo;RD Congo;RDC\\")"}	\N
me	{"(official_name:sk,\\"Čiernohorská republika\\")","(official_name:lv,\\"Melnkalnes Republika\\")","(name:zh-yue,黑山)","(name:zh-min-nan,\\"O͘-soaⁿ Kiōng-hô-kok\\")","(name:zh,黑山)","(name:wuu,黑山共和国)","(name:wo,Montenegro)","(name:war,Montenegro)","(name:vo,Montenegrän)","(name:vi,Montenegro)","(name:vec,Montenégro)","(name:uz,Chernogoriya)","(name:ur,مونٹینیگرو)","(name:uk,Чорногорія)","(name:ug,Chérnogoriye)","(name:tr,Karadağ)","(name:tl,Montenegro)","(name:th,ประเทศมอนเตเนโกร)","(name:tg,Монтенегро)","(name:ta,மொண்டெனேகுரோ)","(name:szl,\\"Czorno Gůra\\")","(name:sw,Montenegro)","(name:sv,Montenegro)","(name:sr,\\"Црна Гора\\")","(name:sq,\\"Mali i Zi\\")","(name:sl,\\"Črna Gora\\")","(name:sk,\\"Čierna Hora\\")","(name:simple,Montenegro)","(name:sh,\\"Crna Gora\\")","(name:se,Montenegro)","(name:sco,Montenegro)","(name:scn,Montenegru)","(name:sah,Монтенегро)","(name:ru,Черногория)","(name:ro,Muntenegru)","(name:qu,Yanaurqu)","(name:pt,Montenegro)","(name:ps,مانټېنېګرو)","(name:pnt,Μαυροβούνιον)","(name:pnb,\\"مونٹی نیگرو\\")","(name:pms,Montnèigr)","(name:pl,Czarnogóra)","(name:pih,Montiniegrow)","(name:pap,Montenegro)","(name:os,Черногори)","(name:oc,Montenegro)","(name:nrm,\\"Crna Gora\\")","(name:nov,Montenegro)","(name:no,Montenegro)","(name:nn,Montenegro)","(name:nl,Montenegro)","(name:nds-nl,Montenegro)","(name:nds,Montenegro)","(name:nap,Montenegro)","(name:nah,Tlīltepēc)","(name:ms,Montenegro)","(name:mr,माँटेनिग्रो)","(name:mn,Монтенегро)","(name:ml,മോണ്ടെനെഗ്രൊ)","(name:mk,\\"Црна Гора\\")","(name:mhr,\\"Шемкурык Эл\\")","(name:lv,Melnkalne)","(name:lt,Juodkalnija)","(name:ln,Montenegro)","(name:lmo,Muntnegher)","(name:lij,Monteneigro)","(name:li,Montenegro)","(name:lb,Montenegro)","(name:la,\\"Mons Niger\\")","(name:ky,Черногория)","(name:kw,Montenegro)","(name:kv,Черногория)","(name:ku,Montenegro)","(name:ko,몬테네그로)","(name:kn,ಮಾಂಟೆನೆಗ್ರೊ)","(name:kk,Черногория)","(name:kg,\\"Monte Negro\\")","(name:ka,მონტენეგრო)","(name:jv,Montenégro)","(name:ja,モンテネグロ)","(name:it,Montenegro)","(name:is,Svartfjallaland)","(name:io,Montenegro)","(name:ilo,Montenegro)","(name:ie,Montenegro)","(name:id,Montenegro)","(name:ia,Montenegro)","(name:hy,Չեռնոգորիա)","(name:hu,Montenegró)","(name:ht,Montenegwo)","(name:hsb,\\"Čorna Hora\\")","(name:hr,\\"Crna Gora\\")","(name:he,מונטנגרו)","(name:haw,Montenegero)","(name:gv,Montenegro)","(name:gl,Montenegro)","(name:gd,\\"Am Monadh Neagrach\\")","(name:ga,Montainéagró)","(name:fy,Montenegro)","(name:frp,Montènègro)","(name:fr,Monténégro)","(name:fo,Montenegro)","(name:fiu-vro,Montõnegro)","(name:fi,Montenegro)","(name:fa,مونته‌نگرو)","(name:eu,Montenegro)","(name:et,Montenegro)","(name:es,Montenegro)","(name:eo,Montenegro)","(name:en,Montenegro)","(name:el,Μαυροβούνιο)","(name:ee,Montenegro)","(name:dv,މޮންޓެނީގުރޯ)","(name:dsb,Carnogórska)","(name:diq,Montenegro)","(name:de,Montenegro)","(name:da,Montenegro)","(name:cy,Montenegro)","(name:cv,Черногори)","(name:cu,\\"Чрьна́ Гора́\\")","(name:cs,\\"Černá Hora\\")","(name:crh,Montenegro)","(name:ceb,Montenegro)","(name:ce,Черногори)","(name:ca,Montenegro)","(name:by,Чарнагорыя)","(name:bs,\\"Crna Gora\\")","(name:br,Montenegro)","(name:bpy,মন্টিনিগ্রো)","(name:bn,মন্টিনিগ্রো)","(name:bg,\\"Черна гора\\")","(name:be-x-old,Чарнагорыя)","(name:be,Чарнагорыя)","(name:bcl,Montenegro)","(name:bat-smg,Joudkalnėjė)","(name:bar,Montenegro)","(name:az,Çernoqoriya)","(name:ast,Montenegru)","(name:arz,مونتينيجرو)","(name:arc,\\"ܛܘܪܐ ܐܘܟܡܐ\\")","(name:ar,\\"الجبل الأسود\\")","(name:ang,Sweartbeorg)","(name:an,Montenegro)","(name:am,ሞንቴኔግሮ)","(name:als,Montenegro)","(name:af,Montenegro)","(name,\\"Crna Gora\\")"}	\N
pf	{"(official_name:lv,\\"Francijas Polinēzijas teritorija\\")","(name:zh-min-nan,\\"Hoat-kok Polynésie\\")","(name:zh,法属波利尼西亚)","(name:wo,\\"Polineesi gu Faraas\\")","(name:vi,\\"Polynésie thuộc Pháp\\")","(name:uk,\\"Французька Полінезія\\")","(name:ug,\\"Fransiyige Qarashliq Polinéziye\\")","(name:ty,\\"Pōrīnetia Farāni\\")","(name:tr,\\"Fransız Polinezyası\\")","(name:th,เฟรนช์โปลินีเซีย)","(name:ta,\\"பிரெஞ்சு பொலினீசியா\\")","(name:sw,\\"Polynesia ya Kifaransa\\")","(name:sv,\\"Franska Polynesien\\")","(name:sr,\\"Француска Полинезија\\")","(name:sl,\\"Francoska Polinezija\\")","(name:sk,\\"Francúzska Polynézia\\")","(name:simple,\\"French Polynesia\\")","(name:sh,\\"Francuska Polinezija\\")","(name:se,\\"Frankriikka Polynesia\\")","(name:ru,\\"Французская Полинезия\\")","(name:ro,\\"Polinezia Franceză\\")","(name:qu,\\"Phransis Pulinisya\\")","(name:pt,\\"Polinésia Francesa\\")","(name:pl,\\"Polinezja Francuska\\")","(name:pam,\\"French Polynesia\\")","(name:os,\\"Францы Полинези\\")","(name:oc,\\"Polinesia Francesa\\")","(name:no,\\"Fransk Polynesia\\")","(name:nn,\\"Fransk Polynesia\\")","(name:nl,Frans-Polynesië)","(name:ms,\\"Polinesia Perancis\\")","(name:mr,\\"फ्रेंच पॉलिनेशिया\\")","(name:mn,\\"Францын Полинез\\")","(name:mk,\\"Француска Полинезија\\")","(name:mi,\\"Porinīhia Wīwī\\")","(name:lv,\\"Franču Polinēzija\\")","(name:lt,\\"Prancūzijos Polinezija\\")","(name:lij,\\"Polinesia Françeise\\")","(name:lb,Franséisch-Polynesien)","(name:la,\\"Polynesia Francica\\")","(name:kw,\\"Polynesi Frynkek\\")","(name:ko,\\"프랑스령 폴리네시아\\")","(name:kk,\\"Франция Полинезиясы\\")","(name:jv,\\"Polinesia Perancis\\")","(name:ja,フランス領ポリネシア)","(name:it,\\"Polinesia francese\\")","(name:is,\\"Franska Pólýnesía\\")","(name:io,\\"Franca Polinezia\\")","(name:id,\\"Polinesia Perancis\\")","(name:hu,\\"Francia Polinézia\\")","(name:hr,\\"Francuska Polinezija\\")","(name:hi,\\"फ्रेंच पोलीनेशिया\\")","(name:he,\\"פולינזיה הצרפתית\\")","(name:gl,\\"Polinesia francesa\\")","(name:gd,\\"French Polynesia\\")","(name:ga,\\"Polainéis na Fraince\\")","(name:fy,\\"Frânsk Polyneezje\\")","(name:frp,\\"Polinèsie francêsa\\")","(name:fr,\\"Polynésie française\\")","(name:fi,\\"Ranskan Polynesia\\")","(name:fa,\\"پلی‌نزی فرانسه\\")","(name:eu,\\"Frantziar Polinesia\\")","(name:et,\\"Prantsuse Polüneesia\\")","(name:es,\\"Polinesia Francesa\\")","(name:eo,\\"Franca Polinezio\\")","(name:en,\\"French Polynesia\\")","(name:el,\\"Γαλλική Πολυνησία\\")","(name:dv,\\"ފަރަންސޭސި ޕޮލިނޭޝިއާ\\")","(name:de,Französisch-Polynesien)","(name:da,\\"Fransk Polynesien\\")","(name:cy,\\"Polynesia Ffrengig\\")","(name:cs,\\"Francouzská Polynésie\\")","(name:ca,\\"Polinèsia Francesa\\")","(name:bs,\\"Francuska Polinezija\\")","(name:br,\\"Polinezia Frañs\\")","(name:bpy,\\"ফ্যাঞ্চ পলিনেসিয়া\\")","(name:bg,\\"Френска Полинезия\\")","(name:be-x-old,\\"Француская Палінэзія\\")","(name:be,\\"Французская Палінезія\\")","(name:bat-smg,\\"Prancūzėjės Polinezėjė\\")","(name:az,\\"Fransa Polineziyası\\")","(name:ar,\\"بولونيزيا الفرنسية\\")","(name:an,\\"Polinesia Franzesa\\")","(name:af,\\"Franse Polynesië\\")","(name,\\"Polynésie française\\")"}	\N
\.


--
-- Name: idx_country_name_country_code; Type: INDEX; Schema: public; Owner: twain; Tablespace: 
--

CREATE INDEX idx_country_name_country_code ON country_name USING btree (country_code);


--
-- Name: country_name; Type: ACL; Schema: public; Owner: twain
--

REVOKE ALL ON TABLE country_name FROM PUBLIC;
REVOKE ALL ON TABLE country_name FROM twain;
GRANT ALL ON TABLE country_name TO twain;
GRANT SELECT ON TABLE country_name TO "www-data";


--
-- PostgreSQL database dump complete
--

