/* This is (osh) struct.h  version 1.1

Audit Trail:

	mcn	6/30/92		Creation
	mcn	10/29/92	Ripped out Date because of insecurity

$Id: struct.h,v 1.5 1994/11/16 22:29:10 mcn Exp $

*/

#include <string.h>

#include "config.h"


#ifdef OSH
/* Handler prototypes */
int i_alias();
int i_more(); 
int i_cd();  
int i_pwd();
int i_done();
int i_cp();
int i_rm();
int i_vi();
int i_help();
int i_ldcache();
int execute();
int i_mount();
int i_test();
int i_exit();
#endif

struct entry {
   char *prog_name;	/* Name which parser will accept */
   int (*handler)();    /* Routine to call if internal */
   char *path;		/* Path to program-we don't want to use execvp
			   because of search path insecurity */
   };

#ifdef OSH
struct hand {
   char *prog_name;
   int (*handler)();
   };

struct alias {
   char *cmd;
   char *alias;
   };

#endif

#ifdef OSH
#ifdef COMPILE_TABLE
static struct entry Table[]= {
  { "help"    , i_help  , NULL                    },
  { "cd"      , i_cd    , NULL                    },
  { "more"    , i_more  , NULL                    },
  { "alias"   , i_alias , NULL                    },
  { "test"    , i_test  , NULL                    },
  { "logout"  , i_exit  , NULL                    },
  { "exit"    , i_exit  , NULL                    },
  { "wc"      , execute , "/bin/wc"               },
  { "ls"      , execute , "/bin/ls"               },
  { "rm"      , i_rm    , "/bin/rm"               },
  { "cp"      , i_cp    , "/bin/cp"               },
  { "cat"     , execute , "/bin/cat"              },
  { "who"     , execute , "/bin/who"              },
  { "finger"  , execute , "/usr/ucb/finger"       },
  { "printenv", execute , "/usr/ucb/printenv"     },
  { "grep"    , execute , "/bin/grep"             },
  {  NULL, NULL, NULL }
};
static int NUMENTRY=16; /* Number of entries listed in the compiled table */
#else /* COMPILE_TABLE */
extern int NUMENTRY;
#endif


static struct hand Internal[] = {
   { "more",   i_more   },
   { "cd",     i_cd     },
   { "cp",     i_cp,    },
   { "help",   i_help   },
   { "rm",     i_rm     },
   { "alias",  i_alias  },
   { "vi",     i_vi     },
   { "ldcache",i_ldcache},
   { "mount",  i_mount  },
   { "test",   i_test   },
   { "logout", i_exit   }, /* No handler, immediately exit */
   { "exit"  , i_exit   }, /* ditto */
   { NULL,     NULL     }
}; 
#define NUMINT  12
#endif /* OSH */

#ifndef OSH
static char *SearchPaths[] = { /* Look in these directories in csadmin */
   "/bin", 
   "/usr/bin", 
   "/usr/ucb",
   "/usr/local/bin", 
   "/usr/etc", 
   "/etc",
   NULL
};
#endif


#define MAXTABLESIZE 256

#ifndef MAXPATHLEN
# define MAXPATHLEN 1024
#endif
#ifndef BADSIG
# define BADSIG	(void (*)())-1
#endif


#define MAXARG 1024  /* To account for wildcards (ie. scc accounts) */
#define MAXFNAME 32
#define MAXWORD 20
#define BADFD (-1)

#define lowbyte(w) ((w) & 0377)
#define highbyte(w) lowbyte((w)>>8)
#ifndef OSH
# define MIN(a,b)   ((a<b) ? a:b)
#endif

typedef enum {TWORD,TPIPE,TAMP,TDOLLAR,TSEMI,TGT,TGTGT,TLT,TNL,TEOF} TOKEN;

extern int writeable();
extern int instring();
extern char *expand();
extern int check_access();
extern int NUMENTRY;
extern struct entry Table[];
extern struct alias AliasList[];
extern int AliasCounter;
extern char *FileList[];
extern char **environ;
extern void logit();

